@extends('layouts.app')

<style>
  .bd-placeholder-img {
    font-size: 1.125rem;
    text-anchor: middle;
    -webkit-user-select: none;
    -moz-user-select: none;
    -ms-user-select: none;
    user-select: none;
  }

  @media (min-width: 768px) {
    .bd-placeholder-img-lg {
      font-size: 3.5rem;
    }
  }

  /* .btn{
    background-color: #002859 !important;
} */
  .btn-prim {
    color: var(--blanco) !important;
    background-color: var(--azul);
    border-color: var(--azul);
    border-radius: 100px;
  }

  .btn-prim:hover {
    color: var(--blanco);
    background-color: var(--v_azul);
    border-color: var(--azul);
  }
</style>
<link href="{{ asset('css/signin.css') }}" rel="stylesheet">

@section('content')
<form class="form-signin" method="POST" action="{{ route('login') }}">
  @csrf
  <img class="p-3" src="{{ asset('../sistemacaja/public/aya-logo-signin.png') }}" alt="A&A Ingeniería">
  <h1 class="h3 mb-3 font-weight-normal">{{ __('INICIO DE SESIÓN') }}</h1>

  <label for="email" class="sr-only">{{ __('Usuario') }}</label>
  <input id="usuario" type="text" class="form-control @error('usuario') is-invalid @enderror" name="usuario" value="{{ old('usuario') }}" required autocomplete="usuario" autofocus placeholder="Nombre de usuario">
  @error('usuario')
  <span class="invalid-feedback" role="alert">
    <strong>{{ $message }}</strong>
  </span>
  @enderror

  <label for="password" class="sr-only">{{ __('Password') }}</label>
  <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="current-password" placeholder="Contraseña">
  @error('password')
  <span class="invalid-feedback" role="alert">
    <strong>{{ $message }}</strong>
  </span>
  @enderror

  <!--<div class="checkbox mb-3">
    <label>
      <input type="checkbox" value="remember-me"> Recuerdame
    </label>
  </div>-->
  <button class="btn btn-lg btn-prim btn-block" type="submit">{{ __('Ingresar') }}</button>
  <p class="mt-5 mb-3 text-muted">&copy; 2020-2022</p>
</form>
@endsection