@extends('menu/menu')

@section('content')

<div class="container mt-5">
    <div class="title-vista mt-4">INSTALACIÓN</div>
</div>


<form action="{{route('go.filtrarFecha',$proyectosSeleccionadoID[0]->id)}}" method="GET">
    <div class="container mt-5 mb-5">

        <!-- BARRA DE BUSQUEDA -->
        <div class="seccion-filtro">Filtrar por</div>
        <hr class="separador">

        <div class="row">
            <div class="container col-sm-6 form-group">
                <label for="datepicker">Fecha inicio</label>
                <input type="date" class="form-control" id="datepicker" name="datepicker">
            </div>
            <div class="container col-sm-6 form-group ">
                <label for="datepicker2">Fecha fin</label>
                <input type="date" class="form-control" id="datepicker2" name="datepicker2">
            </div>
            <div class="col-sm-12 text-center mt-5">
                <button type="buscar" class="btn btn-prim w-25">Buscar</button>
            </div>
        </div>
    </div>
</form>

{{-- @if(Route::current()->getName()=='go.filtrarFecha')
<div class="container">
    <form action="{{route('go.vistaprevia')}}" method="GET">
<input type="hidden" value="{{$f1 ?? ''}}" name="variable">
<input type="hidden" value="{{$f2 ?? ''}}" name="variable1">
<input type="hidden" value="{{$idProyectoSeleccionado ?? ''}}" name="variable2">
<button type="submit" class="btn btn-primary">Vista previa</button>
</form>
</div>
@endif --}}

<div class="container">
    <h1>{{$proyectosSeleccionadoID[0]->nombre}}</h1>
    <hr class="separador">
</div>

<div class="container mt-5 p-0">
    <ul class="nav bg-export d-flex justify-content-between">
        <li class="clas-item">
            <label class="pl-3 pt-2" for=""><strong>{{count($instalaciones)}} Registros</strong></label>
        </li>
        <li class="clas-item m-auto">
            <i>Para ver toda la información, deslice a la derecha</i>
            <span class="material-icons-round icon-midle">trending_flat</span>
        </li>
        <li class="clas-item">
            @if(Route::current()->getName()=='go.filtrarFecha')
            <form action="{{route('go.vistaprevia')}}" method="GET">
                <input type="hidden" value="{{$f1 ?? ''}}" name="variable">
                <input type="hidden" value="{{$f2 ?? ''}}" name="variable1">
                <input type="hidden" value="{{$idProyectoSeleccionado ?? ''}}" name="variable2">
                <button type="submit" class="btn btn-ter">
                    <span class="material-icons-round icon-midle">preview</span>Ver vista previa
                </button>
            </form>
            @endif
        </li>
    </ul>
</div>

<div class="container table-responsive mb-5 p-sm-0">
    <table class="table table-sm table-bordered table-striped table-hover">
        <!--ENCABEZADO-->
        <thead class="color-head">
            <tr>
                <th class="th-head border-th separador-v" colspan="1">Cliente</th>
                <th class="th-head border-th separador-v" colspan="1">T&eacute;cnico</th>
                <th class="th-head border-th separador-v" colspan="1">Fecha de Instalaci&oacute;n</th>
                <th class="th-head border-th separador-v" colspan="1">Fecha Finalizado</th>
                <th class="th-head border-th separador-v" colspan="1">Estado Despacho</th>
                <th class="th-head border-th separador-v" colspan="1">Estado Final</th>
                <th class="th-head border-th separador-v" colspan="1">Estado Check</th>
                <th class="th-head border-th separador-v" colspan="1">Cantidad de Usuarios</th>
                <th class="th-head border-th separador-v" colspan="1">Región</th>
                <th class="th-head border-th separador-v" colspan="1">Comuna</th>
                <th class="th-head border-th separador-v" colspan="1">Direcci&oacute;n | CUI</th>
                <th class="th-head border-th separador-v" colspan="1">N&deg; de serie</th>
            </tr>
        </thead>
        <!--FIN ENCABEZADO-->
        <!--RESULTADOS-->
        <tbody>
            @if(!empty($instalaciones))
            @foreach ($instalaciones as $key => $los_datos)
            <tr>
                <td>{{$los_datos->sCliente ?? ''}}</td>
                <!--<td>{{$los_datos->nombre ?? ''}}</td> -->
                <td>{{$los_datos->nombre_uno ?? ''}} {{$los_datos->apellido_uno ?? ''}}</td>
                <td>
                    {{Carbon\Carbon::createFromDate($los_datos->fecha_instalacion)->format('d-m-Y')}}
                </td>
                <td>
                    {{Carbon\Carbon::createFromDate($los_datos->fecha_termino)->format('d-m-Y')}}
                </td>
                <td> {{ucfirst($los_datos->sEstado_despacho ?? '')}}</td>
                <td> {{ucfirst($los_datos->sEstado_instalacion ?? '')}}</td>
                <td> {{ucfirst($los_datos->estado_asignacion ?? '')}}</td>
                <td> {{ucfirst($los_datos->Cscantidad_usuarios ?? '')}}</td>
                <td>{{$los_datos->sRegion ?? ''}}</td>
                <td>{{$los_datos->sComuna ?? ''}}</td>
                <td>{{$los_datos->sDireccion ?? ''}}</td>
                @if($los_datos->remplazo != null || $los_datos->remplazo != "")
                <td>{{$los_datos->remplazo ?? ''}}</td>
                @else
                <td>{{$los_datos->sSerie ?? ''}}</td>
                @endif
                <!--<td>{{$los_datos->sSerie ?? $los_datos->Csserie_remplazo ?? ''}}</td>-->
                <!--<td>{{$los_datos->observacion ?? ''}}</td>-->
            </tr>
            @endforeach
            @endif
        </tbody>
    </table>
</div>




@endsection