<?php

namespace App\Http\Controllers\bancos_cuentas;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Contracts\Encryption\DecryptException;
// use Cinema\Http\Request;
use Session;
use Redirect;
// use Illuminate\Http\Request;

use Crypt;

use App\User;
use App;
use DB;
use Carbon\Carbon;


use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;


use Auth;

class banco extends Controller
{
    public function __construct()

    {

        $this->middleware('auth');
        $this->middleware('traba');

    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */

public function crear_deposito( Request $request)
{



 

    $porciones = explode("--", $request->cuentas);
    
//   return $request;

    // deposito_mensuals
    $rules = [
        'titulo' => 'required|max:65',
        'total' => 'required|max:15',
        'fecha' => 'required|max:15',
        'cuentas' => 'required|max:15',
        'descripcion_motivo' => 'required|max:150',
 
    ];
    $this->validate($request, $rules);


//esto nos permetira obtener la id de la billetera
    $trabajadores = DB::table('personas')
    ->join('trabajadors','trabajadors.id_persona','=','personas.id')
    ->where('trabajadors.estado','=','1')
    ->where('personas.rut','=',$request->rut_trabajador)
    ->get();


    $fecha_actual_ = Carbon::now();

       // Obtener los datos del administrador que esta ejecutando la accion
       $datos_administrador = DB::table('administradors')        
       ->where('administradors.id_login','=',Auth::user()->id)
       ->get();
        $id_admi = $datos_administrador[0]->id;

        // ****************************************************
    
    $deposito_mensuals = new App\deposito_mensual;
    $deposito_mensuals->titulo_deposito = $request->titulo;
    $deposito_mensuals->descripcion_deposito= $request->descripcion_motivo;
    $deposito_mensuals->fecha_realizado = $fecha_actual_;
    $deposito_mensuals->id_administrado = $id_admi;
    $deposito_mensuals->total = $request->total;
    $deposito_mensuals->id_tipo_cuenta = $porciones[0];;   
    $deposito_mensuals->id_banco= $porciones[1];  
    $deposito_mensuals->id_billetera = $trabajadores[0]->id_billetera;
    $deposito_mensuals->timestamps = false;  
    $deposito_mensuals->save();
    

    // $this->validate($request, $rules);
 
    $billetera_virtual =  App\billetera_virtual::findOrfail($trabajadores[0]->id_billetera);
    $billetera_virtual->total_acumulado = $billetera_virtual->total_acumulado + $request->total;
    $billetera_virtual->fecha_actualizado_acumulado = Carbon::now();
    $billetera_virtual->timestamps = false; 
// return  $billetera_virtual->total_acumulado + $request->total;;
    $billetera_virtual->save();

    return back()->with('mensaje', 'Deposito Agregado Correctamente'); 
    // return "asd";

}

    public function create(request $request)
    {
        
        $banco = new App\cuentas_banco;
        $banco->nombre_banco = $request->nombre_banco;
        $banco->estado = 0;
        $banco->timestamps = false; 
        $banco->save();
   
        return back()->with('mensaje', 'Banco Agregado');  
    }
    public function create_mi_cuenta_sucursal(request $request){

        

        
if($request->nombre_cliente == "" || $request->apellido_cliente == "" || $request->correo_bancario == "" ||
        $request->numero_cuenta == "" ||  $request->id_trabajador == "" || $request->tipo_cuenta == ""){

            return back()->with('mensaje_error', 'Ingrese Todo Los Datos Solicitados');    


    }
        $mis_cuentas = new App\mis_cuentas;
        $mis_cuentas->nombre_persona_cuenta = $request->nombre_cliente;
        $mis_cuentas->apellido_persona_cuenta = $request->apellido_cliente;
        $mis_cuentas->correo_bancario = $request->correo_bancario;
        $mis_cuentas->numero_cuenta = $request->numero_cuenta;
        $mis_cuentas->total_cuentas = 0;
        $mis_cuentas->id_trabajador = $request->id_trabajador; 
        $mis_cuentas->id_tipo_cuenta = $request->tipo_cuenta; 
        $mis_cuentas->id_banco = $request->bancos; 
        $mis_cuentas->estado = 0; 
        $mis_cuentas->timestamps = false;  

        $mis_cuentas->save();


        // mis_cuentas
        return back()->with('mensaje', 'Cuenta Agregada Con Exito');    


    }
  
    public function create_cuenta_sucursal(request $request)
    {

        
        $rules = [
         
    
            'tipo_cuenta' => 'required|max:20',
            'bancos' => 'required|max:50',
         
  
        ];

        $this->validate($request, $rules);

        $sucursal_bancaria = new App\tipos_cuentas_banco;
        $sucursal_bancaria->tipo_cuenta = $request->tipo_cuenta;
        $sucursal_bancaria->id_banco = $request->bancos;
        $sucursal_bancaria->timestamps = false; 
        $sucursal_bancaria->save();
        return back()->with('mensaje', 'Sucursal Agregada'); 
    }
    
    public function buscando_suc(request $request){


        $datos_sucursales = DB::table('tipos_cuentas_bancos')        
        ->where('tipos_cuentas_bancos.id_banco','=',$request->id_sucursal)
        ->get();
        return $datos_sucursales;

    }

    public function buscando_cuentas(request $request)
    {
       
        $mis_cuentas = DB::table('mis_cuentas') 
        ->join('tipos_cuentas_bancos','tipos_cuentas_bancos.id','=','mis_cuentas.id_tipo_cuenta')  
        ->join('cuentas_bancos','cuentas_bancos.id','=','mis_cuentas.id_banco') 
        ->select('tipos_cuentas_bancos.tipo_cuenta','cuentas_bancos.nombre_banco','mis_cuentas.numero_cuenta','mis_cuentas.nombre_persona_cuenta',
        'mis_cuentas.apellido_persona_cuenta','mis_cuentas.correo_bancario','mis_cuentas.id as id_cuentas') 
        ->where('mis_cuentas.id_trabajador','=',$request->id_trabajador)
        ->where('mis_cuentas.id_banco','!=', '1')
        ->where('mis_cuentas.estado','=', '0')

        //estado 1 es eliminado
        // ->where()
        ->get();
        // return $request;
        
        // return $mis_cuentas;
        if(count($mis_cuentas) >= 1){
        $table = "";

        $table = "<thead>";
        $table .= " <tr>";
        $table .= "  <th>Banco - Cuenta</th>";   
        $table .= "  <th>Datos</th>";    
       // $table .= "  <th>Eliminar</th>";                      
        $table .= "</tr>         ";
        $table .= " </thead>";

        for($j = 0 ; $j < count($mis_cuentas); $j++){
            for($i = 0 ; $i < 1; $i++){

                $table .= "<tr>";
                    $table .= "<td class='mayuscula'>".$mis_cuentas[$j]->nombre_banco."<br>".$mis_cuentas[$j]->tipo_cuenta."<br>"."<b>N°: </b>".$mis_cuentas[$j]->numero_cuenta."</td>";
                    $table .= "<td class='mayuscula'>".$mis_cuentas[$j]->nombre_persona_cuenta." ". $mis_cuentas[$j]->apellido_persona_cuenta."<br>".
                    "<strong>@:</strong> ".$mis_cuentas[$j]->correo_bancario."</td>";
 
                    $table .= "<td class='mayuscula'>".
                            "<div class='btn-group' role='group'>".
                            //    "<a class=' btn btn-danger'  href='www.googo.cl' onclick='eliminar_cuenta()' >"."Eliminar"."</a>".
                            '<button class="btn btn-danger"   onclick="eliminar_cuenta('."'".$mis_cuentas[$j]->id_cuentas."'".')">Eliminar</button>'.

                            "</div>"
                                ."</td>";
           
                     $table .= "</tr>";

    

            }
        }
        

        return $table;
        }else{
            return "Sin Cuentas";
        }

       
    }











    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }


    public function  actualizar_eliminar_banco($id){
        try {
            $id_desencriptado = Crypt::decryptString($id);
           
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }

        // $bcuentas_bancos =  App\cuentas_banco::findOrfail($id_desencriptado);
        // $bcuentas_bancos->delete();
        $bcuentas_bancos =  App\cuentas_banco::findOrfail($id_desencriptado);
        $bcuentas_bancos->estado = 1;
        $bcuentas_bancos->timestamps = false; 
        $bcuentas_bancos->save();


        // $user->delete();
        
        return back()->with('mensaje_error', 'Banco Eliminado Correctamente'); 

    }

     public function eliminar_mi_cuenta($id)
    {
        $mis_cuentas =  App\mis_cuentas::findOrfail($id); 

        $mis_cuentas->estado = 1; 
        $mis_cuentas->timestamps = false;  

        $mis_cuentas->save();


        return back()->with('mensaje', 'Cuenta Eliminada Correctamente'); 
    }
}
