<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use GuzzleHttp\Client;


Route::get('/', function () {
    return view('auth/login');
});

Auth::routes();

Route::get('/home', 'HomeController@index')->name('home');
// Comunas************************************
Route::post('comunas', 'menus\menu_principal@buscar_comuna');

//  **************************Trabajadores***********************************************************
Route::get('go_add_trabajador', 'menus\menu_principal@go_add_trabajador')->name('go_add_traba');
Route::get('go_see_trabajador', 'menus\menu_principal@go_see_trabajador')->name('go_see_traba');
Route::get('filtro_go_see_trabajador', 'menus\menu_principal@filtro_go_see_trabajador')->name('filtro_see_trabajador');
Route::post('add_trabajador', 'usuario\usuarios@create')->name('crear.usuario');
// ****Crud Trabajador
Route::get('deleting/{id}', 'usuario\usuarios@deleting')->name('eliminar.trabajador');
Route::get('updating/{id}', 'usuario\usuarios@updating')->name('update.trabajador');
Route::post('update/{id}', 'usuario\usuarios@update')->name('actualizar.trabajador');
// ******************************CLIENTE**********************************************************
Route::get('goadd_sucurs', 'menus\menu_principal@go_add_succur')->name('go_add_sucur');
Route::post('addd_sucurs', 'client\sucursal@create')->name('create.sucur');
Route::post('addd_banc', 'bancos_cuentas\banco@create')->name('create.banco');

Route::get('filtro_see_client', 'menus\menu_principal@filtro_go_see_client')->name('filtro_see_clien');
// Route::post('add_sucur', 'client\clientes@create')->name('create.client');

Route::get('buscar_sucursal', 'client\sucursal@buscar_sucursales');
Route::get('delete_sucursal', 'client\sucursal@edit_sucur');
Route::get('edit_sucursal', 'client\sucursal@editar_sucurlal');
Route::put('update_suc', 'client\sucursal@update')->name('actualizar.suc');
Route::get('deleting_cliente/{id}', 'client\clientes@deleting_clien')->name('eliminar.cliente');
Route::get('bus_car_cliente', 'client\clientes@buscar_clientes');
Route::put('update_clien', 'client\clientes@update')->name('actualizar.client');


// **********************************GASTOS Y REEMBOLSOS***************************************************+

Route::get('goadd_gasto', 'menus\menu_principal@go_add_gasto')->name('go_add_gastos');
Route::post('add_gasto', 'gastosreembolsos\gastos@create')->name('create.gastos');
Route::get('goasee_gasto', 'menus\menu_principal@go_see_gasto')->name('go_see_gastos');
Route::get('filtro_sc_titulo', 'menus\menu_principal@filtro_sc_titulo')->name('filtro_sc_titulo');



Route::get('go_reem/{id_gasto}', 'gastosreembolsos\gastos@reembolsar')->name('go_reembolsar');
Route::get('dele_reem/{id_gasto}', 'gastosreembolsos\gastos@actualizar_eliminar')->name('dele_reembolsar');
Route::get('goo_see_solicitudes', 'menus\menu_principal@go_see_solicitudes')->name('go_see_solicitud');
Route::get('aceptar_reembolso', 'gastosreembolsos\solicitud_reembolso@aceptar_reembolso');
Route::get('filtro_goo_see_solicitudes', 'menus\menu_principal@filtro_go_see_solicitudes')->name('filtro_see_solicitud');

//adherir cuentas
Route::get('goadd_cuenta', 'menus\menu_principal@go_add_cuenta')->name('goadd_cuenta');
Route::post('add_cuenta', 'bancos_cuentas\banco@create_cuenta_sucursal')->name('create.cuenta');
Route::post('buscado_sucursales', 'bancos_cuentas\banco@buscando_suc');
Route::post('buscado_mis_cuentas', 'bancos_cuentas\banco@buscando_cuentas');

//cuentas internas
Route::post('addmi_cuenta', 'bancos_cuentas\banco@create_mi_cuenta_sucursal')->name('create.mi_cuenta');



//registrar aceptacion de solicitudes
Route::post('crear_acept_rec', 'gastosreembolsos\solicitudes_acep_recha@create')->name('create.aceptar_rechazar');

Route::get('buscar_informacion', 'menus\menu_principal@search_informacion');

Route::get('goo_see_solicitudes_per', 'menus\menu_principal@go_see_solicitudes_persona')->name('go_see_solicitud_persona');
// *****************DEPOSITOS*************
Route::get('go_add_depos', 'menus\menu_principal@go_add_depos')->name('go_add.deposito');
Route::get('search_trab', 'menus\menu_principal@buscar_trabajador')->name('search_trab');

Route::get('delet_banco/{id}', 'bancos_cuentas\banco@actualizar_eliminar_banco')->name('delet_banco');

Route::post('create_deposito', 'bancos_cuentas\banco@crear_deposito')->name('create.deposito');

//filtro en el menu
Route::get('filtro_1', 'menus\menu_principal@filtro_persona_fechas')->name('filtro_fecha_rut');
Route::get('filtro2_go', 'menus\menu_principal@filtro_persona_deposito')->name('filtro_deposito_rut');
Route::get('filtro_2', 'menus\menu_principal@buscar_deposito')->name('filtro_rut_deposto');

Route::post('nueva_comunas', 'menus\menu_principal@nueva_comunas');
Route::get('mis_depos', 'menus\menu_principal@filtro_persona_mis_deposito')->name('mis_depositos');

Route::get('mi_firma', 'menus\menu_principal@mi_firma')->name('mifirma');

Route::get('mis_depos_fecha', 'menus\menu_principal@filtro_misdepositos_fecha')->name('filtro_mis_depositos_fecha');
Route::get('eliminar_cuenta_/{id}', 'bancos_cuentas\banco@eliminar_mi_cuenta')->name('eliminar_cuenta_');

//agregar sucursales al trabajador

Route::get('goaddsuctra/{id}', 'menus\menu_principal@go_addtra')->name('go.add_suc_trabajador');

Route::post('buscar_sucursal_ciente', 'menus\menu_principal@buscar_sucursal_ciente_cliente');

Route::post('add_sucu_traba', 'menus\menu_principal@aderir_traba_suc')->name('add_sucursales_trabajador');

Route::post('buscar_sucu_cliente', 'menus\menu_principal@buscar_sucu_clientes');

Route::get('aceptar_gasto/{id}', 'gastosreembolsos\solicitudes_acep_recha@aceptando_sin_reembolso')->name('aceptar_gasto');


// *************************
Route::get('go_reembolsosgastos', 'menus\menu_principal@go_gastos_reembolsos')->name('go_gastos_reembolsos');
Route::get('filtro_3', 'menus\menu_principal@buscar_deposito_reembolso')->name('filtro_rut_deposto_gasto');


// ****************************+ S I S T E M A  D E   S O L I  C I T U  D E S **********************************+



Route::get('goviwaddsd', 'menus\menu_principal@go_add_sol_dia')->name('go.sol_dia');
Route::get('gomysol', 'menus\menu_principal@mis_solicitud')->name('go.mis_solici');

Route::post('addsolcidi', 'sistema_solicitudes\solicitudesdiasController@create')->name('create.solicitud_dias');


Route::get('generarpdfsolicituddia/{id?}', 'sistema_solicitudes\solicitudesdiasController@generar_pdf_sol_dia')->name('generar.pdf_solicitud_dia');

Route::get('mis_solicitudes_dias', 'sistema_solicitudes\solicitudesdiasController@dias_utlizados')->name('go.mis_dias_utilizados');

Route::get('solipendi', 'menus\menu_principal@sol_pendientes')->name('go.solicitudes_pendientes');

Route::post('aceptarsoldia', 'sistema_solicitudes\solicitudesdiasController@aceptar_sol_dia')->name('create.aceptar_solicitud_dias');

Route::post('rechatarsoldia', 'sistema_solicitudes\solicitudesdiasController@rechazar_sol_dia')->name('create.rechazar_solicitud_dias');


Route::get('solipendipers', 'sistema_solicitudes\solicitudesdiasController@sol_por_usuarios')->name('go.solicitudes_pendientes_por_persona');

//es para buscar ajax
Route::post('/autocomplete/fetch', 'sistema_solicitudes\solicitudesdiasController@fetch')->name('autocomplete.fetch');
Route::post('/autocomplete/fetchnombre', 'menus\menu_principal@fetch_nombre')->name('autocomplete.fetchnombre');
Route::post('/autocomplete/fetchnombrecliente', 'menus\menu_principal@fetch_nombrecliente')->name('autocomplete.fetchnombrecliente');


Route::post('aceptarsoldias', 'sistema_solicitudes\solicitudesdiasController@buscar_usuario_nombre')->name('filtro_buscar_usuario_nombre');

Route::get('deletinsoldia/{id?}', 'sistema_solicitudes\solicitudesdiasController@eliminar_sol_dia')->name('eliminar.solicitud_dia');


Route::get('generarpdfrespondida/{id?}', 'sistema_solicitudes\solicitudesdiasController@generar_pdf_acep_recha')->name('generar.pdf_solicitud_dia_acep_recha');


Route::get('generarpdfrespondida2/{id?}/{id_usu?}', 'sistema_solicitudes\solicitudesdiasController@generar_pdf_acep_recha2')->name('generar.pdf_solicitud_dia_acep_recha2');

//rutas para ver las inyecciones de la api
Route::get('ver_api_solicitudes', 'menus\menu_principal@ver_api_solicitudes')->name('go.api_solicitudes');

Route::get('informes', 'menus\menu_principal@verinforme')->name('go.informes');

Route::post('buscar_fechas_coinciden', 'sistema_solicitudes\solicitudesdiasController@buscarcoincidenfechas');

//Filtro informe
Route::get('informe1', 'menus\menu_principal@informedatos')->name('informe1');


Route::get('verdetallecapacitacion', 'checklist\capacitacionController@verdetalle')->name('go.visualizardetalleretiro');

//llamar metodos servidore
Route::get('storage', function () {

    Artisan::call('config:clear');
});

Route::post('/guardarfirmatecnico', 'checklist\checklistRetiroController@savefirmatecnico')->name('guardarfirmatrabajador');

Route::post('buscar_opciones', 'checklist\checklistController@buscar_opciones')->name('buscar_opciones');

Route::post('informePDF', 'menus\menu_principal@informedatosPDF')->name('informe1PDF');

//prueba de horas
Route::get('pruebaa', 'menus\menu_principal@pruebadehoras')->name('go.pruebadeingles');

Route::get('pruebainsert', function () {

    $client = new Client([
        // Base URI is used with relative requests
        'base_uri' => 'https://jsonplaceholder.typicode.com',
        // You can set any number of default request options.
        'timeout'  => 2.0,
    ]);

    $response = $client->request('GET', 'users');

    dd($response);
});

//pdf equipo antes de retiro
Route::get('equiporetiro', 'checklist\EstadoEquipoController@detallepdf')->name('go.equiporetiro');
//descargar PDF-equipo-antes-de-retiro
Route::get('donwload0/{url_pdf?}', 'checklist\EstadoEquipoController@getDownload')->name('go.donwload0');

//prueba de portal PDF-instalacion
Route::get('pdf_instalacion', 'pdfs\PdfInstalacionController@ir_pdfs_generados')->name('go.pdf_instalacion');

//nueva ruta para auto_completar capacitación con la busqueda de cui
Route::post('auto_complete_cui/{id?}', 'checklist\capacitacionController@auto_complete_cui')->name('go.auto_complete_cui');

Route::post('auto_complete_cui2/{id?}', 'checklist\ResumenRetirosController@auto_complete_cui2')->name('go.auto_complete_cui2');

//excel instalacion coordinador

Route::post('/autocomplete/fetchnombrecontacto', 'checklist\capacitacionController@fetch_nombrecontacto')->name('autocomplete.fetchnombrecontacto');

Route::get('asignaciontecnico/{idasig?}', 'checklist\capacitacionController@completarAsignacion')->name('go.asignaciontecnico');

//excel de retiro
Route::get('excel_retiro', 'checklist\excel\excel_retirocoordinadoraController@index')->name('excel_retiro');

Route::get('filtros_retiroexport', 'checklist\excel\excel_retirocoordinadoraController@filtros_retiroExport')->name('exportarfiltros_retiro');

//excel de retiro - kyocera
Route::get('excel_retiro', 'pdfs\PdfRetiroController@excel_retiro')->name('go.excel_retiro');

//excel de retiro - kyocera
Route::get('excel_Resumenretiro', 'pdfs\PdfResumenRetiroController@excel_Resumenretiro')->name('go.excel_Resumenretiro');

//rutas para descargar los pdf de retiro e instalacion 

//descargar todos PDF-RETIRO

Route::get('alldonwload2/{urls?}', 'pdfs\PdfRetiroController@getallDownload')->name('go.getalldonwload2');

//descargar todos los PDF-instalacion
Route::get('allDownload/{urls?}', 'pdfs\PdfInstalacionController@getallDownload')->name('go.getalldownload');

//excel historial de retiros
Route::get('ir_vista_excel_historial/{url?}', 'checklist\excel\excel_retirocoordinadoraController@create_excelHrr')->name('ir_vista_excel_historial');
Route::get('filtros_historialretiroexport', 'checklist\excel\excel_retirocoordinadoraController@filtros_historialretiroExport')->name('historialexportarfiltros_retiro');

//para buscar las comunas asociadas
Route::post('datos_comunas', 'menus\menu_principal@buscarComunas')->name('buscarComunas');

Route::post('datos_comunas_retiro_ciudad', 'menus\menu_principal@buscarComunasRetirosPorCiudad')->name('buscarComunasRetirosPorCiudad');


//para buscar las comunas asociadas CAPACITACIONES
Route::post('datos_clientes_region', 'menus\menu_principal@buscarRegionClientes')->name('buscarRegionClientes');
Route::post('datos_clientes_region_retiro', 'menus\menu_principal@buscarDireccionesRetiros')->name('buscarDireccionesRetiros');

Route::post('ciudades_comunas_capacitaciones', 'menus\menu_principal@buscarComunasCiudades')->name('buscarComunasCiudades');
Route::post('comunas_capacitaciones', 'menus\menu_principal@buscarComunasCapacitaciones')->name('buscarComunasCapacitaciones');


//MANTENEDOR KILOMETROS
Route::get('mantenedor_kilometros', 'prefactura\mantenedorController@index')->name('go.ver_mantenedor');
//RUTA FILTRO MANTENEDOR KILOMETROS
Route::get('filtros_mantenedor_kilometros', 'prefactura\mantenedorController@filtros_mantenedor_kilometros')->name('filtros_mantenedor_kilometros');
Route::post('ver_datos_kilometros', 'prefactura\mantenedorController@ver_datos_kilometros')->name('go.ver_datos_kilometros');
Route::post('editar_kilometros', 'prefactura\mantenedorController@editar')->name('go.editar_kilometros');
Route::get('crear_kilometros', 'prefactura\mantenedorController@create')->name('crearKilometros');
Route::get('deleted_kilometro', 'prefactura\mantenedorController@destroy')->name('deleteRegistro');

//MANTENEDOR CIUDAD BASES
Route::get('mantenedor_ciudad_base', 'prefactura\mantenedorCiudadbaseController@index')->name('go.ver_mantenedor_ciudadbase');
Route::post('ver_datos_ciudad_base', 'prefactura\mantenedorCiudadbaseController@ver_datos_ciudad_base')->name('go.ver_datos_ciudad_base');
Route::post('editar_ciudad_base', 'prefactura\mantenedorCiudadbaseController@editar')->name('go.editar_ciudad_base');
Route::get('crear_ciudad_base', 'prefactura\mantenedorCiudadbaseController@create')->name('crearCiudad_base');
Route::get('deleted_ciudad_base', 'prefactura\mantenedorCiudadbaseController@destroy')->name('deleteCiudad_base');

//resumenes retiros cliente
Route::post('datos_comunas_resumen_retiro', 'menus\menu_principal@buscarComunasResumenRetiro')->name('buscarComunasResumenRetiro');
Route::post('datos_direcciones_resumen_retiro', 'menus\menu_principal@buscarDireccionResumenRetiro')->name('buscarDireccionResumenRetiro');

Route::get('regenerar/{idasig?}', 'api\ConsumirInstalaccionController@regenerar')->name('regenerar.Ainstalacion');

//REPORTES
Route::get('ver_reportes', 'menus\menu_principal@ver_reportes')->name('go.api_reportes');
Route::post('consulta_tabla_reporte', 'menus\menu_principal@consulta_tabla_reportes')->name('consulta_tabla_reporte');
Route::post('tabla', 'menus\menu_principal@tabla_reportes')->name('tabla.api_reportes');
Route::post('reportes', 'menus\menu_principal@reporte')->name('reporte');
Route::post('numero_serie', 'menus\menu_principal@fetch_numeroserie')->name('numero_serie');

Route::post('/obtenerclientes', 'menus\menu_principal@obtenerClientesAsociados')->name('obtenerClientesAsociados');
Route::get('/ver_datos_prueba', 'menus\menu_principal@ver_datos_prueba')->name('ver_datos_prueba');
Route::post('/obtenerclientes2', 'menus\menu_principal@obtenerClientesAsociados2')->name('obtenerClientesAsociados2');
Route::get('/intermedio_capas', 'menus\menu_principal@intermedio_capas')->name('go.intermedio_capas');
Route::get('intermedio_api_retiros', 'menus\menu_principal@intermedio_api_retiros')->name('go.intermedio_api_retiros');

Route::post('/obtenerproyectos2', 'menus\menu_principal@obtenerProyectosAsociados2')->name('obtenerProyectosAsociados2');


Route::get('identificacionconfirmacion', 'HomeController@establecer_proveedor')->name('identificacion_confirmacion')->middleware(SetBd::class);;
Route::group(['middleware' => ['mydb']], function () {

    /**API INSTALACIONS */
    Route::get('siguiente_ver_api_instalaciones', 'menus\menu_principal@siguiente_ver_api_instalaciones')->name('go.api_instalacion');
    Route::get('ver_api_instalaciones', 'menus\menu_principal@ver_api_instalaciones')->name('show.api_instalacion');
    Route::get('asignarcheck', 'checklist\checklistController@asignar_check')->name('go.asignar_check');
    //FILTRO INSTALACIONES
    Route::get('filtros_instalacion', 'menus\menu_principal@filtros_instalacion')->name('filtros_instalacion');
    //ASIGNAR INSTALACIONES 
    Route::post('addcheck/{idinstalacion?}', 'checklist\checklistController@create')->name('create.checklist');
    //VER CHECK CORDINADORA
    Route::get('vercheckCordinadora/{idasig?}', 'checklist\checklistController@ver_checklistCoodinadora')->name('go.ver_check_cordinadora');
    //FINALIZAR CHECKLIST CORDINADORA
    Route::post('finalizarcheck/{id_asignacion?}{accion?}', 'checklist\checklistController@finalizar_check')->name('finalizar.checklist');
    //RECHAZAR CHECKLIST CORDINADORA
    Route::post('/checklistRechazar/{id_asignacion?}', 'checklist\checklistController@checklisRechazar')->name('checklist.rechazar');
    Route::post('/checklistReasignar/{id_asignacion?}', 'checklist\checklistController@checklisReasignar')->name('checklist.reasignar');
    //PDF
    Route::get('pdfinstalacionCordi/{idasig?}', 'checklist\checklistController@GenerarpdfIntalacionCordin')->name('generar.pdfCordinadoraInstalacion');
    //EDITAR ACCESORIO
    Route::POST('editar_accesorios', 'checklist\checklistController@editar_accesorios')->name('go.editar_accesorio');
    //CONSUMIR INSTALACION 
    Route::get('ppppp/{idasig?}', 'api\ConsumirInstalaccionController@index')->name('consumir.Ainstalacion');
    //BOTONES
    Route::post('datos_instalacion', 'checklist\checklistController@datos_instalacion')->name('datos_instalacion');
    Route::post('/checklist/sociados', 'checklist\checklistController@check_asociados')->name('checklist.asociados');
    Route::get('finalizacionManual/{idasig?}', 'checklist\checklistController@finaliza_manual')->name('go.finalizamanual');
    Route::post('historial_check_instalacion', 'menus\menu_principal@check_historial_instalacion')->name('go.historial_check_instalacions');

    /**EXPORTAR EXCEL**/
    Route::get('excelinstalacionCordinadora/{url?}', 'checklist\checklistController@excel_coordinadora_instalacion')->name('go.excel_instalacionCordinadora');
    Route::get('excel_instalacionchecklist/{nombrecliente?}', 'checklist\checklistController@instalacionchecklistExport')->name('exportar_instalacionchecklist');
    Route::get('filtros_instalacionexport', 'checklist\checklistController@filtros_instalacionExport')->name('exportarfiltros_instalacion');
    /** CAMBIOS  */
    Route::post('/cambiodedirecciones', 'checklist\checklistController@cambiardedireccion')->name('cambiodedireccion');
    Route::post('/cambiodecontadorbn', 'checklist\checklistController@cambiarcontadorbn')->name('cambiodecontadorbn');
    Route::post('/cambiodecontadorcolor', 'checklist\checklistController@cambiarcontadorcolor')->name('cambiodecontadorcolor');
    Route::post('/cambiodecomunas', 'checklist\checklistController@cambiardecomuna')->name('cambiodecomuna');
    Route::post('/cambioderegiones', 'checklist\checklistController@cambiarderegion')->name('cambioderegion');
    Route::post('/cambiodecontactos', 'checklist\checklistController@cambiardecontacto')->name('cambiodecontacto');
    Route::post('/cambiodecuis', 'checklist\checklistController@cambiardecui')->name('cambiodecui');
    Route::post('/cambiodeseries', 'checklist\checklistController@cambiardeserie')->name('cambiodeserie');
    Route::post('/cambiodeseriesremplazo', 'checklist\checklistController@cambiardeserieremplazo')->name('cambiodeserieremplazo');
    Route::post('/cambiodefechas', 'checklist\checklistController@cambiodefechafin')->name('cambiodefecha');
    Route::post('/cambiodecontadorbn', 'checklist\checklistController@cambiardecontadorbn')->name('cambiodecontadorbn');
    Route::post('/cambiodecontadorcc', 'checklist\checklistController@cambiardecontadorcc')->name('cambiodecontadorcc');
    Route::post('/cambiodeobservacion', 'checklist\checklistController@cambiardeobservacion')->name('cambiodeobservacion');

    /** API RETIROS */
    Route::get('ver_api_retiros', 'menus\menu_principal@ver_api_retiros')->name('go.api_retiros');
    Route::get('vercheckretirocordinadora/{idasig?}', 'checklist\checklistController@ver_retirocoodinadora')->name('go.ver_check_retirocordinadora');
    Route::get('asignarcheckretiro', 'checklist\checklistRetiroController@asignar_check_retiro')->name('go.asignar_check_retiro');
    //REASIGNAR
    Route::post('/retiroReasignar/{idretiro?}', 'checklist\checklistRetiroController@checklisRetiroReasignar')->name('checklistRetiro.reasignar');
    //RECHAZAR RETIRO
    Route::post('/checklistRetiroRechazar/{idretiros?}', 'checklist\checklistRetiroController@rechazar_retiro')->name('checklist.retiro_rechazo');
    //CONSUMIR RETIRO
    Route::get('sendretiro/{idasig?}', 'api\ConsumirRetiroController@index')->name('consumir.Aretiro');
    //GUARDAR IMAGENES
    Route::post('saveimagenRetiro', 'checklist\checklistRetiroController@save_imagenRetiro')->name('save.imagenchecklistRetiro');
    //CREAR RETIRO TEMPORAL
    Route::post('crear_retiro_temporal', 'api\api_retiroController@createTemporal')->name('crear.retiroTemporal');
    Route::post('addcheckretiros/{idRetiro?}', 'checklist\checklistRetiroController@create')->name('create.checklistRetiros');
    //PDF
    Route::get('pdfretiroCordi/{idasig?}', 'checklist\checklistController@GenerarpdfRetiroCordin')->name('generar.pdfCordinadoraRetiro');
    //EXCEL
    Route::get('ir_vista_excel/{url?}', 'checklist\excel\excel_retirocoordinadoraController@create')->name('ir_vista_excel');
    //BOTONES
    Route::post('datosretiro/{idasig?}', 'checklist\checklistController@datos_api_retiro')->name('go.datosretiro');
    Route::post('/checklistretiros/sociados', 'checklist\checklistRetiroController@check_asociadosRetiros')->name('checklist.retiros');
    Route::post('historial_check_retiro', 'menus\menu_principal@check_historial_retiro')->name('go.historial_check_retiro');
    //FILTRO
    Route::get('filtros_retiro', 'menus\menu_principal@filtros_retiro')->name('filtros_retiro');
    Route::post('datos_direcciones_retiro', 'menus\menu_principal@buscardireccionesRetiro')->name('buscardireccionesRetiro');
    Route::post('datos_comunas_retiro', 'menus\menu_principal@buscarComunasRetiros')->name('buscarComunasRetiros');
    Route::post('datos_sucursales', 'menus\menu_principal@buscarsucursales')->name('buscarsucursales');
    //CAMBIOS
    Route::post('/cambiodedireccionesretiro', 'checklist\checklistController@cambiardedireccion_retiro')->name('cambiodedireccion_retiro');
    Route::post('/cambiodecontadorbnretiro', 'checklist\checklistController@cambiarcontadorbn_retiro')->name('cambiocontadorbn_retiro');
    Route::post('/cambiodecontadorcolorretiro', 'checklist\checklistController@cambiarcontadorcolor_retiro')->name('cambiocontadorcolor_retiro');
    Route::post('/cambiodecomunasretiro', 'checklist\checklistController@cambiardecomuna_retiro')->name('cambiodecomuna_retiro');

    /** RESUMEN RETIRO CORDINADOR */
    Route::get('historial_retiro_coordinadora', 'menus\menu_principal@ir_historial_resumen_retiros_coordinadora')->name('go.historial_retiro_coordinadora');
    //FILTRO
    Route::get('filtros_historial_retiro', 'menus\menu_principal@filtros_historial_retiro')->name('filtros_historial_retiro');
    Route::post('datos_comunas_resu_re', 'menus\menu_principal@comunasResumentesRetiros')->name('comunasResumentesRetiros');
    Route::post('datos_direcciones_resu_re', 'menus\menu_principal@direccionesResumentesRetiros')->name('direccionesResumentesRetiros');
    Route::post('datos_sucursales_resu_re', 'menus\menu_principal@sucursalessResumentesRetiros')->name('sucursalessResumentesRetiros');
    //BOTONES
    Route::get('verdetalleresumenretiro_coordinadora', 'checklist\ResumenRetirosController@verdatosresumenretiro_coordinadora')->name('go.verdatosresumenretiro_coordinadora');
    //PDF
    Route::get('pdfresumenRetiroCordi/{idasig?}', 'checklist\checklistController@GenerarpdfResumenRetiroCordin')->name('generar.pdfresumenRetiroCordi');

    /** PREFACTURACION */
    Route::get('siguiente_ver_todos_checklist', 'menus\menu_principal@siguiente_ver_checklist')->name('go.all_checklist');
    Route::get('ver_todos_checklist', 'menus\menu_principal@todosloschecklist')->name('go.allchecklist');
    Route::get('filtrarFecha/{banco?}', 'prefactura\prefacturacionController@filtrarFecha')->name('go.filtrarFecha');
    Route::get('vistaprevia', 'prefactura\prefacturacionController@vistaPrevia')->name('go.vistaprevia');
    Route::post('obtenerCiudad', 'prefactura\prefacturacionController@obtenerCiudad')->name('obtenerCiudad');
    //EXCEL
    Route::get('ir_vista_excel_vistaprevia/{url?}', 'checklist\excel\excel_vistapreviaController@create_excelvistaprevia')->name('ir_vista_excel_vistaprevia');

    /** API CAPACITACIONES */
    Route::get('vercapacitaciones', 'menus\menu_principal@vercapas')->name('go.capas');
    //FILTRO
    Route::get('filtro/capacitacion', 'menus\menu_principal@filtro_capacitacion')->name('filtro_capacitacion');
    //ASIGNAR 
    Route::post('asginarCapacitacion', 'checklist\capacitacionController@asginarCapacitacion')->name('go.asginarCapacitacion');

    /** PROYECTOS */
    Route::get('siguiente_crear_proyecto', 'gastosreembolsos\CrearProyectoController@Siguiente_CrearProyecto')->name('go.siguientecrear_proyecto');
    Route::get('editar_proyecto', 'gastosreembolsos\CrearProyectoController@prueba')->name('go.editar_proyectos');
    Route::get('crear_proyecto', 'gastosreembolsos\CrearProyectoController@index')->name('go.crear_proyecto');
    Route::post('agregar_proyecto', 'gastosreembolsos\CrearProyectoController@create')->name('go.agregar_proyecto');
    Route::post('/obtenerproyectos', 'menus\menu_principal@obtenerProyectosAsociados')->name('obtenerProyectosAsociados');
    Route::post('update_proyecto', 'gastosreembolsos\CrearProyectoController@updateProyecto')->name('updateProyecto');
    Route::post('agregar_visita', 'gastosreembolsos\CrearProyectoController@añadirvisita')->name('go.agregar_visita');
    Route::post('/cambiocostos', 'gastosreembolsos\CrearProyectoController@cambiarcostos')->name('cambiodecostos');
    Route::post('ver_datos', 'gastosreembolsos\CrearProyectoController@ver_datos')->name('go.ver_datos');

    /** TECNICOS  */
    Route::post('/guardandofotosprueba', 'checklist\checklistController@funguardandofotosprueba')->name('guardandofotosprueba');
    Route::post('/guardandofotosprueba2', 'checklist\checklistController@funguardandofotosprueba2')->name('guardandofotosprueba2');
    Route::post('saveimagenaccesorios', 'checklist\checklistController@save_imagen_accesorios')->name('save.imagen_accesorios');
    Route::post('saveimagen', 'checklist\checklistController@save_imagen')->name('save.imagenchecklist');
    Route::get('iniciarcheck/{id_checklist?}', 'checklist\checklistController@iniciar_check')->name('iniciando.checklist');
    Route::get('iniciarcheckRetiro/{id_checklistRetiro?}', 'checklist\checklistRetiroController@iniciar_checkRetiro')->name('iniciando.checklistRetiro');
    Route::post('validar_fotos', 'checklist\checklistController@validar_imagenes')->name('go.validarfotoschecklist');
    Route::post('cancelar_fotos', 'checklist\checklistController@cancelar_imagenes')->name('go.cancelarfotoschecklist');
    Route::post('/guardarfirmaretiros', 'checklist\checklistRetiroController@guardarfirmaretiro')->name('guardarfirmaretiro');
    Route::get('iniciarchecretiro/{idasigRetiro?}', 'checklist\checklistRetiroController@InicarCheckRetiros')->name('go.ChecklistRetiros');
    Route::post('updatecheckretiro/{id_checkretiro?}', 'checklist\checklistRetiroController@updatechecklistRetiro')->name('update.IniciarchecklistRetiros');
    Route::get('estadoequipo', 'menus\menu_principal@estadoequipo')->name('go.estadoEquipo');
    Route::get('filtro/estadoequipo', 'checklist\EstadoEquipoController@index')->name('filtro.estadoequipo');
    Route::post('guardandoequipo', 'checklist\EstadoEquipoController@create')->name('save.equipoRetiro');
    Route::get('ver/equipo', 'checklist\EstadoEquipoController@CordinadoraEstadoEquipo')->name('go.estados_equipo');

    //VISTAS RESUMENES RETIRO TECNICO
    Route::get('historial_retiro', 'menus\menu_principal@ir_historial_resumen_retiros')->name('go.historial_retiro');
    Route::get('resumenes_retiro', 'menus\menu_principal@ir_resumen_retiros')->name('go.resumenes_retiro');
    Route::get('verdetalleresumenretiro', 'checklist\ResumenRetirosController@verdatosresumenretiro')->name('go.verdetalleresumenretiro');
    Route::post('addresumenretiro', 'checklist\ResumenRetirosController@create')->name('create.addresumenretiro');

    /** PERFIL PROVEEDOR */
    Route::get('verinstalacionesKyocera', 'pdfs\PdfInstalacionController@verInstalacionesKyocera')->name('go.verinstalacionesKyocera');
    Route::get('filtrosinstalacionKyocera', 'pdfs\PdfInstalacionController@filtros_instalacionKyocera')->name('filtros_instalacion_kyocera');
    Route::get('excel_instalacion', 'pdfs\PdfInstalacionController@excel_instalacion')->name('go.excel_instalacion');
    Route::get('donwloader/{url_pdf?}', 'pdfs\PdfInstalacionController@getDownload')->name('go.donwloader');

    Route::get('pdf_retiro', 'pdfs\PdfRetiroController@ir_pdfs_generados')->name('go.pdf_retiro');
    Route::get('donwload2/{url_pdf?}', 'pdfs\PdfRetiroController@getDownload')->name('go.donwload2');
    Route::get('filtrar_pdf_retiro', 'pdfs\PdfRetiroController@show')->name('go.filtrar_pdf_retiro');

    Route::get('pdf_capacitacion', 'pdfs\PdfCapacitacionController@ir_pdfs_generados')->name('go.pdf_capacitacion');
    Route::get('donwload3/{url_pdf?}', 'pdfs\PdfCapacitacionController@getDownload')->name('go.donwload3');
    Route::get('filtrar_pdf_capacitacion', 'pdfs\PdfCapacitacionController@show')->name('go.filtrar_pdf_capacitacion');

    Route::get('pdf_resumenretiro', 'pdfs\PdfResumenRetiroController@ir_pdfs_generados')->name('go.pdf_resumenretiro');
    Route::get('donwload4/{url_pdf?}', 'pdfs\PdfResumenRetiroController@getDownload')->name('go.donwload4');
    Route::get('filtrar_pdfresumen_retiro', 'pdfs\PdfResumenRetiroController@show')->name('go.filtrar_pdf__resumen_retiro');

    Route::get('pdf_informes', 'pdfs\PdfInformesController@ir_pdfs_generados')->name('go.pdf_informes');
    Route::get('donwload5/{url_pdf?}', 'pdfs\PdfInformesController@getDownload')->name('go.donwload5');
    Route::post('filtrar_pdf_informe', 'pdfs\PdfInformesController@show')->name('go.filtrar_pdf_informe');

    /** GRAFICOS  */
    Route::get('informesgraficos', 'menus\menu_principal@informes_graficos_menu')->name('informes.graficos');
    Route::get('informesgraficos_proyectos', 'graficos\graficosController@grafico_total_instalaciones_proyectos')->name('informes.graficos.instalaciones.proyectos');
    Route::post('informesgraficos_proyectosproveedores', 'graficos\graficosController@buscarProyectosAsociados')->name('informes.graficos.instalaciones.proyectos.asociados');
    Route::post('graficos_por_proyectos', 'graficos\graficosController@graficosPorProyecto')->name('informes.graficos.por.proyectos');

    Route::post('graficos_por_sucursales', 'graficos\graficosController@graficosPorSucursales')->name('informes.graficos.por.sucursales');
    Route::post('graficos_por_acessorios', 'graficos\graficosController@graficosPorAcessorios')->name('informes.graficos.por.acessorios');
    Route::post('informesgraficos_proyectos_retiros', 'graficos\graficosController@grafico_total_retiros_proyectos')->name('informes.graficos.retiros.proyectos');

    /** CLIENTES */
    Route::get('goadd_client', 'menus\menu_principal@go_add_client')->name('go_add_client');
    Route::post('add_client', 'client\clientes@create')->name('create.client');
    Route::get('see_client', 'menus\menu_principal@go_see_client')->name('go_see_clien');
});
Route::get('completandocheck', 'checklist\checklistController@completar_checklist')->name('go.completando_check')->middleware(SetBd2::class);
Route::get('vercheck/{idasig?}', 'checklist\checklistController@ver_checklist')->name('go.ver_check')->middleware(SetBd2::class);
Route::post('historial_check_tecnico', 'menus\menu_principal@check_tecnico_historial_retiro')->name('go.historial_check')->middleware(SetBd2::class);
Route::post('historial_check_tecnico_instalacion', 'menus\menu_principal@check_tecnico_historial_instalacion')->name('go.historial_check_instalacion')->middleware(SetBd2::class);
Route::get('iniciarchecretiro/{idasigRetiro?}', 'checklist\checklistRetiroController@InicarCheckRetiros')->name('go.ChecklistRetiros')->middleware(SetBd2::class);
Route::get('vercheckretiro', 'checklist\checklistRetiroController@ver_checktecnico')->name('go.ver_checkretiro')->middleware(SetBd2::class);
//HOME TECNICO
Route::get('informesgraficos_proyectos_tecnicos', 'graficos\graficosController@graficos_tecnicos')->name('graficos_tecnicos');
Route::get('revisar_pendiente_tecnico', 'HomeController@revisar_pendiente_tecnico')->name('revisar_pendientes_tecnicos');
Route::get('revisar_rechazados_tecnico', 'HomeController@revisar_rechazados_tecnico')->name('revisar_rechazados_tecnicos');
Route::get('revisar_encurso_tecnico', 'HomeController@revisar_encurso_tecnico')->name('revisar_encurso_tecnicos');
//HOME COORDINADOR
Route::get('seguimiento', 'HomeController@seguimiento')->name('go.seguimiento');
Route::get('informesgraficos_proyectos_tecnicos_coordinadora', 'graficos\graficosController@graficos_cordinadora')->name('graficos_coordinadora');
Route::get('revisar_pendientes_coordinador', 'HomeController@revisar_pendientes_coordinador')->name('revisar_pendientes_coordinador');
Route::get('revisar_porasignar', 'HomeController@revisar_porasignar')->name('revisar_porasignar');
Route::get('revisar_encurso_coordinador', 'HomeController@revisar_encurso_coordinador')->name('revisar_encurso_coordinador');
Route::get('revisar_porreasignar_coordinador', 'HomeController@revisar_porreasignar_coordinador')->name('revisar_porreasignar_coordinador');
Route::get('asignarcheckretiro_home', 'checklist\checklistRetiroController@asignar_check_retiro_home')->name('go.asignar_check_retiro_home')->middleware(SetBd2::class);
Route::get('asignarcheck_home', 'checklist\checklistController@asignar_check_home')->name('go.asignar_check_home')->middleware(SetBd2::class);
Route::get('vercheckCordinadora_home', 'checklist\checklistController@ver_checklistCoodinadora_home')->name('go.ver_check_cordinadora2')->middleware(SetBd2::class);
Route::get('vercheckretirocordinadora_home', 'checklist\checklistController@ver_retirocoodinadora_home')->name('go.ver_check_retirocordinadora2')->middleware(SetBd2::class);
Route::get('finalizacionManual_home', 'checklist\checklistController@finaliza_manual_home')->name('go.finalizamanual_home')->middleware(SetBd2::class);

Route::get('chekstecnico', 'menus\menu_principal@check_tecnico')->name('check.tecnico');
Route::get('filtro_tecnicos', 'menus\menu_principal@filtro_tecnicos')->name('filtro_tecnico');
//FUNCION DE PREFACTURA CON BD DE AYA
Route::post('calcularkilometros', 'prefactura\prefacturacionController@calularKilometros')->name('calcularkilometros');

//VISTAS CAPACITACION
Route::get('historial', 'menus\menu_principal@ir_historial_capacitacion')->name('go.historial');
Route::get('capacitacion', 'checklist\capacitacionController@ir_capacitacion')->name('go.capacitacion');
Route::post('addcapacitacion', 'checklist\capacitacionController@create')->name('create.addcapacitacion');
//RESUMEN ASIGNACIONES
Route::get('resumen', 'menus\menu_principal@ir_resumen')->name('go.resumen');

Route::get('accesorios', 'checklist\checklistController@inicio_accesorios')->name('go.accesorios');

//ACCESORIOS
Route::post('buscar_accesorios', 'checklist\checklistController@buscar_accesorios')->name('go.search_accesorios');
Route::post('buscar_accesorios2', 'checklist\checklistController@buscar_accesorios2')->name('go.search_accesorios2');
Route::post('agregar_accesorios', 'checklist\checklistController@agregar_accesorios')->name('go.agregar_accesorio');
Route::post('datos_direcciones', 'menus\menu_principal@buscardirecciones')->name('buscardirecciones');

Route::get('/obtenerproyectos', 'menus\menu_principal@actualizar_regiones')->name('go.actualizarregiones');
