@extends('menu/menu')
{{-- <script src="https://ajax.aspnetcdn.com/ajax/jQuery/jquery-3.4.1.min.js%22%3E</script> --}}
<script src="{{ asset('js/jquery-3.4.1.min.js') }}" ></script>
{{-- <link  href="{{ asset('css/a&a_style.css') }}" href="a&a_style.css" rel="stylesheet" type="text/css"> --}}

@section('content')

@if ( session('mensaje') )
    <div class="alert alert-success">{{ session('mensaje') }}</div>
@endif


<div class="container mt-5">
  <div class="title-vista mt-4">Capacitación</div>
</div>

<form action="{{route('go.filtrar_pdf_capacitacion')}}" method="get">
  @csrf
  <div class="container mt-4">
    <div class="seccion-filtro">Filtrar por</div> 
    <hr class="separador">

    <!-- BARRA DE BUSQUEDA -->
    <div class="row">
      <!--AQUI SE CARGA EL SELECT DE PROYECTO-->
      <div class="col-sm-3 form-group">
        <label for="proyectos">Proyecto</label>
        <select id="proyectos" name="proyectos"   class="custom-select col-mb-3">
          <option value="" selected>seleccionar</option>
          <option value="" selected>Todos</option>
          @if(!empty($proyectos))
          @foreach ($proyectos  as $los_datos3)
            @if($los_datos3->id_proyecto == $proyectos2)
            <option selected value="{{$los_datos3->id_proyecto}}">{{$los_datos3->nombre." (".$los_datos3->razon_social.")" }}  </option>
            @else
            <option value="{{$los_datos3->id_proyecto}}">{{$los_datos3->nombre." (".$los_datos3->razon_social.")" }}  </option>
            @endif
          @endforeach
          @endif
        </select>
      </div>
      <!--FIN SELECT DE PROYECTO-->

      <!--AQUI SE CARGA EL SELECT DE REGION-->
      <div class="col-sm-3 form-group">
        <label for="region">Ciudad</label>
        <select  id="region" name="region" class="custom-select">
          <option  selected disabled>seleccionar</option>
          <option value="" selected>Todos</option>
          @if (!empty($regiones))
          @foreach ($regiones as $data)
          @if ($data->ciudad != null)
          @if($data->ciudad == $ciudades)
            <option selected value="{{ $data->ciudad }}">{{ucfirst(strtolower($data->ciudad))}} </option>
          @else
            <option value="{{ $data->ciudad }}">{{ucfirst(strtolower($data->ciudad))}} </option>
          @endif
          @endif
          @endforeach
          @endif
        </select>
      </div>
      <!--FIN SELECT DE REGION-->

      <!--AQUI SE CARGA EL SELECT DE COMUNA-->
      <div class="col-sm-3 form-group">
        <label for="comuna">Comuna</label>
        <select id="comuna" name="comuna" class="custom-select">
          <option  selected disabled>seleccionar</option>
          <option value="" selected>Todos</option>
          @if (!empty($comunas))
          @foreach ($comunas as $data2)
          @if ($data2->comuna != null)                    
          @if( $data2->comuna === $comuna)
            <option selected value="{{ $data2->comuna }}">{{ucfirst(strtolower($data2->comuna))}}</option>
          @else
            <option value="{{ $data2->comuna }}">{{ucfirst(strtolower($data2->comuna))}}</option>
          @endif
          @endif
          @endforeach
          @endif
        </select>
      </div>

      <!--AQUI SE CARGA EL SELECT DE direccion-->
      <div class="col-sm-3 form-group">
        <label for="direccion">Dirección</label>
        <select  class="custom-select" id="direccion" name="direccion">
          <option selected value="" >seleccionar</option>
          @if(!empty($direccion))
          @foreach($direccion as $direcciones)
          @if ($direcciones->direccion != null)  
          @if($direcciones->direccion == $direccionR)
            <option selected value="{{$direcciones->direccion}}">{{$direcciones->direccion}}</option>
          @else
            <option  value="{{$direcciones->direccion}}">{{$direcciones->direccion}}</option>
          @endif
          @endif
          @endforeach
          @endif
        </select>
      </div>
      <!--FIN SELECT DE direccion-->

      <div class="col-sm-3 form-group">
        <label for="Serie">CUI sucursal</label>
        <input type="" class="form-control" id="Serie" name="Serie" placeholder="Nº de CUI" value="{{$Serie ?? ''}}">
      </div>
    </div>
    <!-- FIN BARRA DE BUSQUEDA -->
  </div>

  <div class="container text-center my-4">
    <button type="submit" class="btn btn-prim px-sm-5">Buscar</button>
  </div>
  
</form>

<!-- TABLA DE RESULTADOS DE BUSQUEDA -->
<div class="container table-responsive p-sm-0">
  <table class="table table-bordered table-responsive-lg table-striped table-hover" id="gridData">
    <!-- ENCABEZADO -->
    <thead class="color-head">
      <tr>
        <th class="th-head border-th separador-v" colspan="1">Proyecto</th>
        <th class="th-head border-th separador-v" colspan="1">Ciudad</th>
        <th class="th-head border-th separador-v" colspan="1">Dirección</th>
        <th class="th-head border-th separador-v" colspan="1">Comuna</th>
        <th class="th-head border-th separador-v" colspan="1">CUI</th>
        <th class="th-head border-th separador-v" colspan="1">PDF</th>
      </tr>
    </thead>
    <!-- FIN ENCABEZADO -->

    <!-- RESULTADOS -->
    <tbody>
      @if(!empty($rutapdf))
        @foreach ($rutapdf as $datos)
          <tr>
            <td class="td-val"> {{$datos->nombre}}</td>
            <td class="td-val"> {{$datos->ciudad}}</td>
            <td class="td-val"> {{$datos->direccion}}</td>
            <td class="td-val"> {{$datos->comuna}}</td>
            <td class="td-val"> {{$datos->cuisucursal}}</td>
            <td class="td-val text-center">
            <a class="btn-icon btn-icon-dd" href="{{route('go.donwload3',$datos->url_pdf)}}">
              <span class="material-icons-round">picture_as_pdf</span>
            </a>
          </td>
        </tr>
        @endforeach
      @endif
    </tbody>
    <!-- FIN RESULTADOS -->
  </table>

    @if(!empty($retiros))
    {{-- {{$solicitudes->Links()}} --}}
    {{ $retiros->appends(request()->query())->links() }}
    @endif
  </div>
  <!-- FIN TABLA DE RESULTADOS DE BUSQUEDA -->
  
  <script>

    $(document).ready(function(){
  
  
      $("#region").change(function(){
             region = $('select[id=region]').val();
             var _token = $('input[name="_token"]').val();
  
             $.ajax({
                    method:"POST",
  
                    url:"{{ route('buscarComunasCiudades') }}",
  
                    data: { 'region': region,  _token:_token},
  
                success: function(data) {
                  $("#comuna").empty();
                  $("#direccion").empty();
                  $("#sucursal").empty();
                  $("#comuna").append('<option value="">Seleccionar</option>');
                  $("#direccion").append('<option value="">Seleccionar</option>');
                  $("#sucursal").append('<option value="">Seleccionar</option>');
                  $(data).each(function(i, v){ // indice, valor
                    //if(v.sComuna != null || v.sComuna != "null"  ){ 
                        $("#comuna").append('<option value="' + v.comuna + '">' + v.comuna + '</option>');
                          })
                   // }
  
                  },
  
                error: function(xhr, status) {
                    alert('Disculpe, ha ocurrido un problema, intente mas tarde');
                 }
  
            });
    });
    $("#comuna").change(function(){
      comuna = $('select[id=comuna]').val();
             var _token = $('input[name="_token"]').val();
  
  
  
             $.ajax({
                    method:"POST",
  
                    url:"{{ route('buscarComunasCapacitaciones') }}",
  
                    data: { 'comuna': comuna,  _token:_token},
  
                success: function(data) {
                  $("#direccion").empty();
                  $("#sucursal").empty();
                  $("#direccion").append('<option value="">Seleccionar</option>');
                  $("#sucursal").append('<option value="">Seleccionar</option>');
  
                  $(data).each(function(i, v){ // indice, valor
                    //if(v.sdireccion != null || v.sdireccion != "null"  ){ 
                        $("#direccion").append('<option value="' + v.direccion + '">' + v.direccion + '</option>');
                          })
                   // }
  
                  },
  
                error: function(xhr, status) {
                    alert('Disculpe, ha ocurrido un problema, intente mas tarde');
                 }
  
            });
    });
  

  
      
  });

  function actualizar_regiones(){
           var _token = $('input[name="_token"]').val();

           $.ajax({
                  method:"GET",

                  url:"{{ route('go.actualizarregiones') }}",

                  data: {   _token:_token},

              success: function(data) {
                    alert("proceso Completado");
                    location.reload();

                },

              error: function(xhr, status) {
                  alert('Disculpe, ha ocurrido un problema, intente mas tarde');
               }

          });

}
  
      </script>
  @endsection
