@extends('menu/menu')
{{-- <script src="https://ajax.aspnetcdn.com/ajax/jQuery/jquery-3.4.1.min.js</script> --}}
<script src="{{ asset('js/jquery-3.4.1.min.js') }}"></script>
<link href="{{ asset('css/a&a_style.css') }}" href="a&a_style.css" rel="stylesheet" type="text/css">

@section('content')

@if ( session('mensaje') )
<div class="alert alert-success">{{ session('mensaje') }}</div>
@endif

<div class="container mt-5">
    <div class="title-vista mt-4">Crear</div>
</div>

<form action="{{route('go.agregar_proyecto')}}" method="post" enctype="multipart/form-data" >
    @csrf

    <!-- BARRA DE BUSQUEDA -->
    <div class="container mt-5 mb-5">

        <!-- Fila 1 Detalle de clientes ------------------------------------------------------>
        <div class="seccion-filtro">Detalle de clientes</div> 
        <hr class="separador">

        <div class="row">
            <div class="col-sm-4 form-group">
                <label for="nombre_proyecto">Nombre del cliente</label>
                <select class="custom-select mb-3 mayuscula" name="clientes" id="clientes">
                    <option value="" selected>Seleccionar</option>
                    @foreach($carga_selectClientes as $idcliente)
                    <option value="{{$idcliente->id }}">{{$idcliente->razon_social}}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-sm-4 form-group">
                <label for="nombre_proyecto">Nombre del proyecto</label>
                <input type="" class="form-control mayuscula" id="nombre_proyecto" placeholder="Nombre del proyecto" name="nombre_proyecto">
            </div>
            <div class="col-sm-4 form-group">
                <label for="nombre_proyecto">Fecha Inicio</label>
                <input type="date" class="form-control mayuscula" id="fechaInicioProyecto"  name="fechaInicioProyecto">
            </div>
            <div class="col-sm-4 form-group">
                <label for="nombre_proyecto">Fecha Final</label>
                <input type="date" class="form-control mayuscula" id="fechaFinProyecto"  name="fechaFinProyecto">
            </div>
            <div class="col-sm-4 form-group">
                <label class="d-block" for="nombre_proyecto">Logo</label>
                <input type="file" class="form-control-file mt-3" id="cargafoto1" name="cargafoto1" accept="image/png,image/jpeg">
            </div>
        </div>
                
        <!-- Fila 2 Datos Proyectos ------------------------------------------------------>
        <div class="seccion-filtro">Datos Proyectos</div> 
        <hr class="separador">

        <div class="row">
            <div class="col-sm-3 form-group">
                <label for="capacitacion">Capacitación</label>
                <select class="custom-select mb-3 mayuscula" name="capacitacion" id="capacitacion">
                    <option value="" selected>Seleccionar</option>
                    <option value="si">Si</option>
                    <option value="no">No</option>
                </select>
            </div>
            <div class="col-sm-3 form-group">  
                <label for="cantidad_equipos">Cantidad de equipos</label>
                <input type="number" class="form-control mayuscula" id="cantidad_equipos" placeholder="Cantidad de equipos" name="cantidad_equipos">
            </div>
            <div class="col-sm-3 form-group">
                <label for="">Valor usuario adicional</label>
                <input type="text" class="monto form-control mayuscula"  id="costo_usuarioadicional" placeholder="Valor por usuario adicional" name="costo_usuarioadicional" maxlength="9" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" onkeyup="sumar();"> 
            </div>
            <div class="col-sm-3 form-group">
                <label for="">Valor Kilometro</label>
                <input type="number" class="form-control mayuscula" id="valor_kilometros" placeholder="$300" name="valorKilometro">
            </div>
        </div>

        <!-- Fila 3 Costos primera visita ------------------------------------------------------>
        <div class="seccion-filtro">Costos primera visita</div> 
        <hr class="separador">

        <div class="row">
            <div class="col-sm-3 form-group">
                <label for="costo_habilitacion">Habilitación</label>
                <input type="text" class="monto form-control mayuscula" id="costo_habilitacion" placeholder="UF" name="costo_habilitacion" maxlength="9" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" onkeyup="sumar();">
            </div>
            <div class="col-sm-3 form-group">
                <label for="costo_instalacion">Instalación accesorios</label>
                <input type="text" class="monto  form-control mayuscula" id="costo_instalacion" placeholder="UF" name="costo_instalacion" maxlength="9" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" onkeyup="sumar();">
            </div>
            <div class="col-sm-3 form-group">
                <label for="costo_capacitacion">Capacitación</label>
                <input type="text" class="monto  form-control mayuscula" id="costo_capacitacion" placeholder="UF" name="costo_capacitacion" maxlength="9" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" onkeyup="sumar();">
            </div>
            <div class="col-sm-3 form-group">
                <label for="costo_retiro">Retiro</label>
                <input type="text" class="monto  form-control mayuscula" id="costo_retiro" placeholder="UF" name="costo_retiro" maxlength="9" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" onkeyup="sumar();">
            </div>
            <div class="col-sm-3 form-group">
                <label for="costo_actualizacion">Actualización firmware</label>
                <input type="text" class="monto  form-control mayuscula" id="costo_actualizacion" placeholder="UF" name="costo_actualizacion" maxlength="9" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" onkeyup="sumar();">
            </div>
            <div class="col-sm-3 form-group">
                <label for="costo_cortesia">Cortesía</label>
                <input type="text" class="monto  form-control mayuscula" id="costo_cortesia" placeholder="UF" name="costo_cortesia" maxlength="9" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" onkeyup="sumar();">
            </div>
            <div class="col-sm-3 form-group">
                <label for="costo_garantia">Garantía</label>
                <input type="text" class="monto  form-control mayuscula" id="costo_garantia" placeholder="UF" name="costo_garantia" maxlength="9" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" onkeyup="sumar();">
            </div>
            <div class="col-sm-3 form-group">
                <label for="costo_garantia">Mantenimiento</label>
                <input type="text" class="monto  form-control mayuscula" id="costo_mantenimiento" placeholder="UF" name="costo_garantia" maxlength="9" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" onkeyup="sumar();">
            </div>
        </div>
        
        <!-- Fila 3 Costo final ------------------------------------------------------>
        <div class="seccion-filtro">Costo final</div> 
        <hr class="separador">
                   
        <div class="row">
            <div class="col-sm-6 form-group">
                <label for="">Costo</label>
                <input type="text" class="form-control mayuscula" id="costos_cambio" value=""  placeholder="$10000" name="costo_proyecto">
            </div>
        </div>
        
        <!-- Botones ------------------------------------------------------>
        <div class="row mt-5">
            <div class="col-sm-12 text-right">
                <button class="btn btn-prim guardar w-25" type="submit">GUARDAR</button>
                <button class="btn btn-secundario w-25" type="button">CANCELAR</button>
                <button class="btn btn-secundario w-25 btn-addBody" style="display: none;" type="" >Añadir DIV al BODY</button>
            </div>
        </div>
</form>


<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.2/jquery.min.js"></script>
<script>
    $(document).ready(function() {
        var num = 1;
        $('.btn-addBody').click(function() {
            num++;
            $('.contenido').append(
                '<div class="container">'+ '<hr class="linea">'+ '</div>'+
                '<div class="col-sm-6">' +
                '<h2><strong>Costos segunda visita</strong></h2>' +
                '<div class="">' +
                '<label for="costo_habilitacion">' +
                '<h2>Habilitación</h2>' +
                '</label>' +
                '<input type="text" class="monto" id="costo_habilitacion2" placeholder="UF" name="$num" maxlength="9" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" onkeyup="sumar();">' +
                '</div>'
            );
        });
    });
</script>
<script type="text/javascript">
    $(document).ready(function() {
        var maxField = 10; // Numero maximo de campos
        var addButton = $('#add_button'); // Selector del boton de Insertar
        var wrapper = $('.field_wrapper'); // Contenedor de campos
        var fieldHTML = '<div><input type="text" class="form-control" name="field_name[]" value=""/><a href="javascript:void(0);" class="remove_button" title="Remove field"></a></div>'; //New input field html
        var x = 1; // Iniciamos el contador a 1
        $(addButton).click(function() { // Una vez que se haga clic en el boton
            if (x < maxField) { //Comprobamos el maximo
                x++; //Increment field counter
                $(wrapper).append(fieldHTML); // Añadimos el HTML
            }
        });
        $(wrapper).on('click', '.remove_button', function(e) { // Una vez se ha hecho clic en el boton de eliminar
            e.preventDefault();
            $(this).parent('div').remove(); //Eliminamos el div
            x--; // Reducimos el contador a 1
        });
    });
</script>
<script>
    function suma(valor) {
        var total = 0;
        valor = parseInt(valor); // Convertir el valor a un entero (número).

        total = document.getElementById('spTotal').innerHTML;

        // Aquí valido si hay un valor previo, si no hay datos, le pongo un cero "0".
        total = (total == null || total == undefined || total == "") ? 0 : total;

        /* Esta es la suma. */
        total = (parseInt(total) + parseInt(valor));

        // Colocar el resultado de la suma en el control "span".
        document.getElementById('spTotal').innerHTML = total;
       // $('#costos_cambio').val(total);
    }
</script>
<script>
    function sumar() {

        var total = 0;

        $(".monto").each(function() {

            if (isNaN(parseFloat($(this).val()))) {

                total += 0;

            } else {

                total += parseFloat($(this).val());

            }

        });

        //alert(total);
        //document.getElementById('spTotal').innerHTML = total;
        // $('#costos_cambio').val(total);
    }
</script>
@endsection