@extends('menu/menu')
{{-- <script src="https://ajax.aspnetcdn.com/ajax/jQuery/jquery-3.4.1.min.js"></script> --}}
<script src="{{ asset('js/jquery-3.4.1.min.js') }}" ></script>

 

@section('content') 


@if ( session('mensaje') )
    <div class="alert alert-success">{{ session('mensaje') }}</div>
@endif


@if ( session('mensaje_error') )

    <div class="alert alert-danger">{{ session('mensaje_error') }}</div>

@endif

<div class="container" style="margin-top:30px">
    <form action="{{route('search_trab')}}" method="GET">
    <div class="row">
    
        <h4>Rut trabajador</h4>
        <div class="input-group mb-3">
            <input type="text" name="rut"  value="{{@old('rut')}}" class="form-control" placeholder="xxxxxxxx-x">
            <div class="input-group-append">
              <button class="btn btn-success" type="submit">Buscar</button>
            </div>
          </div>
    </div>
</form>
</div>

 @if(!empty($trabajadores))
   

        @if(count($trabajadores ?? '0' >= 0))

        <div class="container">
            <div class="row">
                <div class="col-sm-3 form-group">
               
                        <span><b>Nombre:  </b></span> <span class="mayuscula">{{$trabajadores[0]->nombre_uno ?? ''}} {{$trabajadores[0]->apellido_uno ?? ''}} {{$trabajadores[0]->apellido_dos ?? ''}}</span>
                </div>
                <div class="col-sm-3 form-group">
                    <span><b>Rut: </b></span> <span> {{$trabajadores[0]->rut ?? ''}} </span> 
                </div>

            </div>
        </div>

        <form action="{{route('create.deposito')}}" method="POST">
            {{-- <form action="" method="POST"> --}}
              @csrf
        <div class="container" >
            <div class="row">
             <div class="col-sm-3 form-group">
                 <label for="" class="" >Título</label>
                 <input type="text" name="titulo" class="form-control" value="{{@old('titulo')}}"    placeholder="Titulo">
                 @error('titulo')
                 <div class="alert alert-danger">{{ $message }}</div>
                 @enderror
             </div>   
             <input type="text" name="rut_trabajador" value="{{$rut_persona}}" style="display:none"> 
             {{-- {{$mis_cuentas}} --}}
             <div class="col-sm-3 form-group">
                <label for="" class="" >Seleccione cuenta</label>
                
                <select class="form-control" name="cuentas" id="cuentas_usuario">
                  <option value="">Seleccionar</option>
                  @foreach($mis_cuentas as $mis_cuentas_)

                  <option value="{{$mis_cuentas_->id_tipo_cuenta."--".$mis_cuentas_->id_banco}}" {{(old('cuentas')==$mis_cuentas_->id_tipo_cuenta."--".$mis_cuentas_->id_banco )? 'selected':''}}>{{$mis_cuentas_->tipo_cuenta . " (". $mis_cuentas_->nombre_banco." )"}}</option>
                  @endforeach
              </select>
          
                @error('cuentas')
                <div class="alert alert-danger">{{ $message }}</div>
                @enderror
              </div>

             <div class="col-sm-3 form-group">
                 <label for="" class="" >Total</label>
                 <input type="text" name="total" class="form-control" value="{{@old('total')}}"    placeholder="$">
                 @error('total')
                 <div class="alert alert-danger">{{ $message }}</div>
                 @enderror
             </div>     
             <div class="col-sm-3 form-group">
                 <label for="" class="" >Fecha depósito</label>
                 <input type="date" name="fecha" class="form-control" value="{{@old('fecha')}}"    placeholder="fecha">
                 @error('fecha')
                 <div class="alert alert-danger">{{ $message }}</div>
                 @enderror
             </div>                 
           </div>
            
                
                 <div class="row">
                     <div class="col-sm-12 form-group">
                         <label for="" class="" >Descripción motivo</label>
                         <textarea rows="5" name="descripcion_motivo" class="form-control">
                          {{@old('descripcion_motivo')}}
                         </textarea>
                         @error('descripcion_motivo')
                         <div class="alert alert-danger">{{ $message }}</div>
                         @enderror
                     </div>                    
                   </div> 

                   <div class="row">
                    <div class="card-body" style="text-align: right" >
                        <button type="submit" class="btn btn-primary btn-lg ">Guardar</button>  
                    </div>
                  
                  
                  </div>
             
     </div>

    </form>
        @else
        Usuario no encontrado
        @endif
              
@endif




@endsection

<script>



  $(document).ready(function(){



    $('#region_usuario').change(function() {    
         buscar_comuna($("#region_usuario option:selected").val(),"#comuna_usuarios");  
        // alert("hols");
     })
// ************************RUT*****************************************
    //validar rut  
    $("#rut").change(function(){
      checkRut( $("#rut").val());
    });
    //agregar digito al rut
    $('#rut').on('input', function() {
      var valor = $("#rut").val().replace('.','');
     valor = valor.replace('-','');
     cuerpo = valor.slice(0,-1);
     dv = valor.slice(-1).toUpperCase();
     rut= cuerpo + '-'+ dv;
     $("#rut").val(rut);
     });

     
     $('#correo').change(function() {
    
      validarEmail($("#correo").val());
     });
  
  });

  function validarEmail(valor) {
  if (/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3,4})+$/.test(valor)){
  //  alert("La dirección de email " + valor + " es correcta.");
  console.log("listo");
  } else {
  //  alert("La dirección de email es incorrecta." + valor);
  //  $("#correo").val("");
  }
}

  function checkRut(rut) {
    // Despejar Puntos
    var valor = rut.replace('.','');
    // Despejar Guión
    valor = valor.replace('-','');
    
    // Aislar Cuerpo y Dígito Verificador
    cuerpo = valor.slice(0,-1);
    dv = valor.slice(-1).toUpperCase();
    
    // Formatear RUN
    rut.value = cuerpo + '-'+ dv
    
    // Si no cumple con el mínimo ej. (n.nnn.nnn)
    if(cuerpo.length < 7) { 
        alert("Rut Incorrecto");
        $("#rut").val('');
      }else{
    
    // Calcular Dígito Verificador
    suma = 0;
    multiplo = 2;
    
    // Para cada dígito del Cuerpo
    for(i=1;i<=cuerpo.length;i++) {
    
        // Obtener su Producto con el Múltiplo Correspondiente
        index = multiplo * valor.charAt(cuerpo.length - i);
        
        // Sumar al Contador General
        suma = suma + index;
        
        // Consolidar Múltiplo dentro del rango [2,7]
        if(multiplo < 7) { multiplo = multiplo + 1; } else { multiplo = 2; }
  
    }
    
    // Calcular Dígito Verificador en base al Módulo 11
    dvEsperado = 11 - (suma % 11);
    
    // Casos Especiales (0 y K)
    dv = (dv == 'K')?10:dv;
    dv = (dv == 0)?11:dv;
    
    // Validar que el Cuerpo coincide con su Dígito Verificador
    if(dvEsperado != dv) {
      alert("Rut incorrecto");
      $("#rut").val('');
    }
  }
  
}
  </script>
