@extends('menu/menu')

@section('content')
@if ( session('mensaje') )
<div class="alert alert-success">{{ session('mensaje') }}</div>
@endif
@if ( session('mensaje2') )
<div class="alert alert-danger">{{ session('mensaje2') }}</div>
@endif

<div class="container mt-5">
    <div class="title-vista mt-4">Mantenedor Ciudad Base</div>
</div>


   



<div class="container mt-5">
    <div class="container p-0 bg-export">
        <div class="clearfix">
            <button class="btn btn-ter py-2 px-3 float-right" data-toggle="modal" data-target="#modalCrear">
                <span class="material-icons-round icon-midle">note_add</span><strong>Crear registro</strong>
            </button>
        </div>
    </div>

    <!-- TABLA DE RESULTADOS DE BUSQUEDA -->
    <div class="container table-responsive mb-5 p-sm-0">
        <div class="table table-striped table-hover">
            <table class="table table-striped table-hover">

                <!-- ENCABEZADO -->
                <thead class="color-head">
                    <tr>
                        <th class="th-head border-th" colspan="1">Region</th>
                        <th class="th-head border-th" colspan="1">Ciudad Base</th>
                        <th class="th-head border-th" colspan="1"><span class="material-icons">settings</span></th>
                    </tr>
                </thead>

                <!-- RESULTADOS -->
                <tbody>
                    @if(!empty($ciudad_base))
                    @foreach ($ciudad_base as  $key => $los_datos)
                        <tr>
                            <!-- REGION -->
                            <td colspan="td-val">{{$los_datos->des_region}}</td>
                            <!-- CIUDAD BASES -->
                            <td colspan="td-val">{{$los_datos->ciudad_base}}</td>
                            
                            <td colspan="td-val">
                                <div class="d-flex justify-content-around">
                                    <a title="modificar" role="button" class="btn-icon btn-icon-dd ver_historial_instalacion editarciudad_base" data-id="{{$los_datos->id}}">                               
                                        <span class="material-icons-round">edit</span>                         
                                    </a>                             
                                    <a class="btn-icon btn-icon-dd ver_historial" data-toggle="modal" data-target="#modalEliminar" data-idEliminar="{{$los_datos->id}}">                               
                                        <span class="material-icons">delete</span>                         
                                    </a>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                    @endif
                </tbody>
                <!-- FIN RESULTADOS -->
            </table>
        </div>
    </div>
</div>

<!-- MODAL EDITAR CIUDAD BASE-->
<div class="modal" id="modalciudad_base" data-backdrop="static">
    <div class="modal-dialog " role="document">
        <div class="modal-content">

            <form action="{{route('go.editar_ciudad_base')}}" method="post">
            @csrf
                <div class="modal-header">
                    <div class="seccion-modal">Modificar ciudad base</div>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <hr class="separador ml-4 mr-4">

                <div class="modal-body">
                    <div class="container">
                        <div class="row">
                            <div class="col-sm-12 form-group" style="margin-bottom: 10px;">
                                <label for="">Región</label>
                                <input type="text" class="form-control mayuscula" id="region" value="" placeholder="" name="region" readonly>
                                <input type="hidden" id="id_region" name="id_region">
                            </div>
                            <div class="col-sm-12 form-group">
                                <label for="">Ciudad Base</label>
                                <input type="text" class="form-control mayuscula" id="ciudad_base" value="" placeholder="" name="ciudad_base" required>
                                <input type="hidden" id="id_ciudad_base" name="id_ciudad_base">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-prim w-25 mx-auto">Modificar</button>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- FIN MODAL EDITAR -->

<!-- MODAL CREAR-->
<div class="modal fade" id="modalCrear" tabindex="-1" role="dialog" aria-labelledby="modalCrearLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">

            <div class="modal-header">
                <div class="seccion-modal" id="modalCrearLabel">Nuevo registro</div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <hr class="separador ml-4 mr-4">

            <form action="{{route('crearCiudad_base')}}" method="GET">
                <div class="modal-body">
                    <div class="container">
                        <div class="row">
                            <div class="col-sm-12 form-group">
                                <label for="">Región</label>
                                <input type="text" class="form-control" id="region" value="" placeholder="Region" name="region" required>
                            </div>
                            <div class="col-sm-4 form-group">
                                <label for="">Número Region</label>
                                <input type="text" class="form-control" id="numero_region" value="" placeholder="EJ: 10" name="numero_region" required onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;">
                            </div>
                            <div class="col-sm-4 form-group">
                                <label for="">Número Romano</label>
                                <input type="text" class="form-control" id="numero_romano" value="" placeholder="Ej: XI" name="numero_romano" required>
                            </div>
                            <div class="col-sm-4 form-group">
                                <label for="">Abreviatura</label>
                                <input type="text" class="form-control" id="abreviatura" value="" placeholder="Ej: RM" name="abreviatura" required>
                            </div>
                            <div class="col-sm-12 form-group">
                                <label for="">Ciudad Base</label>
                                <input type="text" class="form-control" id="ciudad_base" value="" placeholder="Ciudad Base" name="ciudad_base" required>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-prim w-25 mx-auto">Guardar</button>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- FIN MODAL CREAR -->

<!-- MODAL ELIMINAR-->
<div class="modal fade" id="modalEliminar" tabindex="-1" role="dialog" aria-labelledby="modalEliminarLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">

            <div class="modal-header">
                <div class="seccion-modal" id="modalEliminarLabel"></div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <hr class="separador ml-4 mr-4">

            <div class="modal-body">
                <div class="text-center">¿Realmente desea eliminar este registro?</div>
            </div>

            <form action="{{route('deleteCiudad_base')}}" method="GET">
                <input type="text" name="id_ciudad_base" id="idKilometrosEliminar" style="display: none" hidden>
                <input type="text" name="id_region" id="idRegionEliminar" style="display: none" hidden>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-prim w-25">Si, eliminar</button>
                    <button type="button" class="btn btn-secundario w-25" data-dismiss="modal">Cancelar</button>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- FIN MODAL ELIMINAR -->

@endsection
<script src="{{ asset('js/jquery-3.4.1.min.js') }}" ></script>
<script>
    $(document).ready(function() {
        $('.eliminarKilometros').click(function() {
            var id = $(this).attr("data-idEliminar");
            var id2 =$(this).attr("data-idRegions");
            //alert(id);
            $("#idKilometrosEliminar").val(id);
            $("#idRegionEliminar").val(id2);

        });
        $('.editarciudad_base').click(function() {
            var id = $(this).attr("data-id");
            $("#id_ciudad_base").val(id);
            var _token = $('input[name="_token"]').val();
            $("#modalciudad_base").modal('show');
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                method: "POST",
                url: "{{route('go.ver_datos_ciudad_base')}}",
                data: {
                    'id': id,
                    _token: _token
                },
                success: function(data) {
                    console.log(data[0].ciudad_base);
                    console.log(data[0].des_region);
                    $("#region").val(data[0].des_region);
                    $("#ciudad_base").val(data[0].ciudad_base);
                },
                error: function(xhr, status) {
                    alert('Disculpe, ha ocurrido un problema, intente mas tarde');
                }
            });
        });
    });
</script>
