@extends('menu/menu')

{{-- <script src="https://ajax.aspnetcdn.com/ajax/jQuery/jquery-3.4.1.min.js%22%3E</script> --}}
<script src="{{ asset('js/jquery-3.4.1.min.js') }}"></script>
{{-- <link  href="{{ asset('css/a&a_style.css') }}" href="a&a_style.css" rel="stylesheet" type="text/css"> --}}



@section('content')

@if ( session('mensaje') )
<div class="alert alert-success">{{ session('mensaje') }}</div>
@endif

<div class="container mt-5">
	<div class="title-vista mt-4 d-flex justify-content-between">
		Instalación
		<div class="mostrar-contenido">
			<a href="javascript: history.go(-1)">
				<span class="material-icons-round icon-midle">arrow_back</span>
				Volver
			</a>
		</div>
	</div>
</div>

<form action="{{route('filtro_tecnico')}}" method="GET">
	<div class="container mt-4">

		<div class="seccion-filtro">Firltrar por</div>
		<hr class="separador">

		<div class="row">
			<div class="col-sm-3 form-group">
				<label for="fecha">Fecha (obligatorio)</label>
				<input type="date" class="form-control mayuscula" id="fecha" name="fecha">
			</div>

			<div class="col-sm-3 form-group">
				<label for="email">Comuna</label>
				<select name="comuna" class="custom-select">
					<option selected disabled>seleccionar</option>
					@if (!empty($comuna_retiros))
					@foreach ($comuna_retiros as $comuna_retiros_)
					@if ($comuna_retiros_->Cscomuna != null)
					<option value="{{ $comuna_retiros_->Cscomuna }}">{{ucfirst(strtolower($comuna_retiros_->Cscomuna))}}
						@endif
						@endforeach
						@endif
				</select>
			</div>

			<div class="col-sm-3 form-group">
				<label for="email">Asignación</label>
				<select name="asignacion" class="custom-select">
					<option selected disabled>seleccionar</option>
					@if (!empty($asignaciones))
					@foreach ($asignaciones as $asignaciones_)
					@if ($asignaciones_->tipo != null)
					<option value="{{ $asignaciones_->tipo }}">{{ucfirst(strtolower($asignaciones_->tipo))}}
						@endif
						@endforeach
						@endif
				</select>
			</div>

			<div class="col-sm-3 form-group">
				<label for="serie">Nº serie</label>
				<input type="" class="form-control mayuscula" id="" placeholder="Nº de Serie" name="serie">
			</div>

			<div class="col-sm-3 form-group">
				<label for="estado">Estado</label>
				<select name="estado" class="custom-select">
					<option selected disabled>seleccionar</option>
					@if (!empty($estado_retiros))
					@foreach ($estado_retiros as $estado_retiros)
					@if ($estado_retiros->estado_asignacion != null)
					@if($estado_retiros->estado_asignacion == "tarea_asignada")
					<option value="{{ $estado_retiros->estado_asignacion }}">Tarea Asignada
						@else
					<option value="{{ $estado_retiros->estado_asignacion }}">{{ucfirst(strtolower($estado_retiros->estado_asignacion))}}
						@endif
						@endif
						@endforeach
						@endif
				</select>
			</div>
		</div>

		<!-- FIN BARRA DE BUSQUEDA -->
		<div class="text-center mb-5 mt-5">
			<button type="buscar" class="btn btn-prim w-25">Buscar</button>
		</div>
	</div>
</form>




<!-- TABLA DE RESULTADOS DE BUSQUEDA -->
<div class="container table-responsive mb-5 p-sm-0">
	<table class="table table-striped table-hover">
		<!-- ENCABEZADO -->
		<thead class="color-head">
			<tr>
				<th class="th-head border-th separador-v" colspan="1">Fecha (Visita)</th>
				<th class="th-head border-th separador-v" colspan="1">Comuna</th>
				<th class="th-head border-th separador-v" colspan="1">Dirección y Cliente</th>
				<th class="th-head border-th separador-v" colspan="1">Id Sala</th>

				<th class="th-head border-th separador-v" colspan="1">Estado</th>
				<th class="th-head border-th separador-v" colspan="1">Serie</th>
				<th class="th-head border-th separador-v" colspan="1">Asignación</th>
				<th class="th-head border-th"><span class="material-icons">settings</span></th>
			</tr>
		</thead>
		<!-- FIN ENCABEZADO -->

		<!-- RESULTADOS -->
		<tbody>
			<!-- RESULTADOS -->
						{{-- para no mostrar 1 == 2 --}}

			@if(!empty($datos_asignacion3)  && 1==2) )
			@foreach ($datos_asignacion3 as $los_datos)
			<tr>
				<td>{{Carbon\Carbon::createFromDate($los_datos->fecha_visita)->format('d-m-Y')}}</td>
				<td>{{$los_datos->csComuna ?? ''}}</td>
				<td>{{$los_datos->Csdireccion}} ({{$los_datos->Cscliente}} )</td>
				<td>{{$los_datos->idSala}} </td>

				@if($los_datos->estado_asignacion == "tarea_asignada")
				<td class="pendiente" style="text-transform: ">Tarea Asignada</td>
				@elseif($los_datos->estado_asignacion == "pendiente")
				<td class="pendiente" style="text-transform: ">{{ucfirst($los_datos->estado_asignacion)}}</td>
				@elseif($los_datos->estado_asignacion == "finalizado")
				<td class="finalizado" style="text-transform: ">{{ucfirst($los_datos->estado_asignacion)}}</td>
				@elseif($los_datos->estado_asignacion == "rechazado")
				<td class="rechazado" style="text-transform: ">{{ucfirst($los_datos->estado_asignacion)}}</td>
				@else
				<td>{{$los_datos->estado_asignacion}}</td>
				@endif
				<td style="text-transform: ">{{ucfirst($los_datos->CsSerie)}}</td>
				<td style="text-transform: ">{{ucfirst($los_datos->tipo)}}</td>
				<td>
					<div style="text-align: center">
						{{-- preguntamos si el estado que viene, esta finalizado --}}
						@if($los_datos->estado_asignacion != "finalizado")
						{{-- preguntamos si el tipo de datos es de intalacion o retiro --}}
						@if ($los_datos->tipo == "instalacion")
						<form action="{{route('go.ver_check')}}" method="GET">
							<input type="hidden" value="{{$los_datos->proveedor}}" name="proveedor">
							<input type="hidden" value="{{$los_datos->id}}" name="id">
							<button type="submir" class="btn"><img src="{{ asset('Botones/Botones/revisar_m.png') }}" alt="" style="margin: 2px 0px" /></button>
						</form>
						<form action="{{route('go.completando_check')}}" method="GET">
							<input type="hidden" value="{{$los_datos->proveedor}}" name="proveedor">
							<input type="hidden" value="{{$los_datos->id}}" name="id">
							<button type="submir" class="btn"><img src="{{ asset('Botones/Botones/Editar.png') }}" alt="" style="margin: 2px 0px" /></button>
						</form>
						<a role="button" class="historial_instalacion" data-proveedor="{{$los_datos->proveedor}}" data-id="{{$los_datos->id}}" title="Historial"><img src="{{ asset('Botones/Botones/Historial.png') }}" alt="" style="margin: 2px 0px" /></a>
						@if($los_datos->estado_asignacion != "pendiente" and $los_datos->estado_asignacion != "tarea_asignada")
						<a href="#" class="motivo_rechazo" data-motivo="{{$los_datos->motivo_rechazado}}" role="button" title="Motivo"><img src="{{ asset('Botones/Botones/advertir.png') }}" alt="" style="margin: 2px 0px" /></a>
						@endif
						@elseif($los_datos->tipo == "retiro")
						<form action="{{route('go.ver_checkretiro')}}" method="GET">
							<input type="hidden" value="{{$los_datos->proveedor}}" name="proveedor">
							<input type="hidden" value="{{$los_datos->id}}" name="id">
							<button type="submir" class="btn"><img src="{{ asset('Botones/Botones/revisar_m.png') }}" alt="" style="margin: 2px 0px" /></button>
						</form>
						<form action="{{route('go.ChecklistRetiros')}}" method="GET">
							<input type="hidden" value="{{$los_datos->proveedor}}" name="proveedor">
							<input type="hidden" value="{{$los_datos->id}}" name="id">
							<button type="submir" class="btn"><img src="{{ asset('Botones/Botones/Editar.png') }}" alt="" style="margin: 2px 0px" /></button>
						</form>
						<a role="button" class="historial_retiro" data-id="{{$los_datos->id}}" data-proveedor="{{$los_datos->proveedor}}" title="Historial"><img src="{{ asset('Botones/Botones/Historial.png') }}" alt="" style="margin: 2px 0px" /></a>
						@if ($los_datos->motivo_reasignado != "" || $los_datos->motivo_reasignado != null)
						<a href="#" class="motivo_rechazo" data-motivo="{{$los_datos->motivo_reasignado}}" c role="button" title="Motivo"><img src="{{ asset('Botones/Botones/advertir.png') }}" alt="" style="margin: 2px 0px" /></a>
						@endif
						{{-- {{$los_datos->motivo_reasignado ?? "nada"}} --}}
						@if($los_datos->estado_asignacion != "pendiente" and $los_datos->estado_asignacion != "tarea_asignada")
						<a href="#" class="motivo_rechazo" data-motivo="{{$los_datos->motivo_rechazado}}" c role="button" title="Motivo"><img src="{{ asset('Botones/Botones/advertir.png') }}" alt="" style="margin: 2px 0px" /></a>
						@endif
						@endif
						@else
						@if ($los_datos->tipo == "instalacion")
						<a href="{{route('go.ver_check',Crypt::encryptString($los_datos->id))}}" role="button" title="Revisar"><img src="{{ asset('Botones/Botones/revisar_m.png') }}" alt="" style="margin: 2px 0px" /></a>
						<a role="button" class="historial_instalacion" data-id="{{$los_datos->id}}" title="Historial"><img src="{{ asset('Botones/Botones/Historial.png') }}" alt="" style="margin: 2px 0px" /></a>
						@elseif($los_datos->tipo == "retiro")
						<a href="{{route('go.ver_checkretiro',Crypt::encryptString($los_datos->id))}}" role="button" title="Revisar"><img src="{{ asset('Botones/Botones/revisar_m.png') }}" alt="" style="margin: 2px 0px" /></a>
						<a role="button" class="historial" data-id="{{$los_datos->id}}" title="Historial"><img src="{{ asset('Botones/Botones/Historial.png') }}" alt="" style="margin: 2px 0px" /></a>
						@endif
						@endif
					</div>
				</td>
			</tr>
			@endforeach
			@endif
						{{-- para no mostrar 1 == 2 --}}

			@if(!empty($datos_asignacion2)  && 1==2))
			@foreach ($datos_asignacion2 as $los_datos)
			<tr>
				<td>{{Carbon\Carbon::createFromDate($los_datos->fecha_visita)->format('d-m-Y')}}</td>
				<td>{{$los_datos->csComuna ?? ''}}</td>
				<td>{{$los_datos->Csdireccion}} ({{$los_datos->Cscliente}} )</td>
				<td>{{$los_datos->idSala}} </td>

				@if($los_datos->estado_asignacion == "tarea_asignada")
				<td class="pendiente" style="text-transform: ">Tarea Asignada</td>
				@elseif($los_datos->estado_asignacion == "pendiente")
				<td class="pendiente" style="text-transform: ">{{ucfirst($los_datos->estado_asignacion)}}</td>
				@elseif($los_datos->estado_asignacion == "finalizado")
				<td class="finalizado" style="text-transform: ">{{ucfirst($los_datos->estado_asignacion)}}</td>
				@elseif($los_datos->estado_asignacion == "rechazado")
				<td class="rechazado" style="text-transform: ">{{ucfirst($los_datos->estado_asignacion)}}</td>
				@else
				<td>{{$los_datos->estado_asignacion}}</td>
				@endif
				<td style="text-transform: ">{{ucfirst($los_datos->CsSerie)}}</td>
				<td style="text-transform: ">{{ucfirst($los_datos->tipo)}}</td>
				<td>
					<div style="text-align: center">
						{{-- preguntamos si el estado que viene, esta finalizado --}}
						@if($los_datos->estado_asignacion != "finalizado")
						{{-- preguntamos si el tipo de datos es de intalacion o retiro --}}
						@if ($los_datos->tipo == "instalacion")
						<form action="{{route('go.ver_check')}}" method="GET">
							<input type="hidden" value="{{$los_datos->proveedor}}" name="proveedor">
							<input type="hidden" value="{{$los_datos->id}}" name="id">
							<button type="submir" class="btn"><img src="{{ asset('Botones/Botones/revisar_m.png') }}" alt="" style="margin: 2px 0px" /></button>
						</form>
						<form action="{{route('go.completando_check')}}" method="GET">
							<input type="hidden" value="{{$los_datos->proveedor}}" name="proveedor">
							<input type="hidden" value="{{$los_datos->id}}" name="id">
							<button type="submir" class="btn"><img src="{{ asset('Botones/Botones/Editar.png') }}" alt="" style="margin: 2px 0px" /></button>
						</form>
						<a role="button" class="historial_instalacion" data-proveedor="{{$los_datos->proveedor}}" data-id="{{$los_datos->id}}" title="Historial"><img src="{{ asset('Botones/Botones/Historial.png') }}" alt="" style="margin: 2px 0px" /></a>
						@if($los_datos->estado_asignacion != "pendiente" and $los_datos->estado_asignacion != "tarea_asignada")
						<a href="#" class="motivo_rechazo" data-motivo="{{$los_datos->motivo_rechazado}}" role="button" title="Motivo"><img src="{{ asset('Botones/Botones/advertir.png') }}" alt="" style="margin: 2px 0px" /></a>
						@endif
						@elseif($los_datos->tipo == "retiro")
						<form action="{{route('go.ver_checkretiro')}}" method="GET">
							<input type="hidden" value="{{$los_datos->proveedor}}" name="proveedor">
							<input type="hidden" value="{{$los_datos->id}}" name="id">
							<button type="submir" class="btn"><img src="{{ asset('Botones/Botones/revisar_m.png') }}" alt="" style="margin: 2px 0px" /></button>
						</form>
						<form action="{{route('go.ChecklistRetiros')}}" method="GET">
							<input type="hidden" value="{{$los_datos->proveedor}}" name="proveedor">
							<input type="hidden" value="{{$los_datos->id}}" name="id">
							<button type="submir" class="btn"><img src="{{ asset('Botones/Botones/Editar.png') }}" alt="" style="margin: 2px 0px" /></button>
						</form>
						<a role="button" class="historial_retiro" data-id="{{$los_datos->id}}" data-proveedor="{{$los_datos->proveedor}}" title="Historial"><img src="{{ asset('Botones/Botones/Historial.png') }}" alt="" style="margin: 2px 0px" /></a> @if ($los_datos->motivo_reasignado != "" || $los_datos->motivo_reasignado != null)
						<a href="#" class="motivo_rechazo" data-motivo="{{$los_datos->motivo_reasignado}}" c role="button" title="Motivo"><img src="{{ asset('Botones/Botones/advertir.png') }}" alt="" style="margin: 2px 0px" /></a>
						@endif
						{{-- {{$los_datos->motivo_reasignado ?? "nada"}} --}}
						@if($los_datos->estado_asignacion != "pendiente" and $los_datos->estado_asignacion != "tarea_asignada")
						<a href="#" class="motivo_rechazo" data-motivo="{{$los_datos->motivo_rechazado}}" c role="button" title="Motivo"><img src="{{ asset('Botones/Botones/advertir.png') }}" alt="" style="margin: 2px 0px" /></a>
						@endif
						@endif
						@else
						@if ($los_datos->tipo == "instalacion")
						<a href="{{route('go.ver_check',Crypt::encryptString($los_datos->id))}}" role="button" title="Revisar"><img src="{{ asset('Botones/Botones/revisar_m.png') }}" alt="" style="margin: 2px 0px" /></a>
						<a role="button" class="historial_instalacion" data-id="{{$los_datos->id}}" title="Historial"><img src="{{ asset('Botones/Botones/Historial.png') }}" alt="" style="margin: 2px 0px" /></a>
						@elseif($los_datos->tipo == "retiro")
						<a href="{{route('go.ver_checkretiro',Crypt::encryptString($los_datos->id))}}" role="button" title="Revisar"><img src="{{ asset('Botones/Botones/revisar_m.png') }}" alt="" style="margin: 2px 0px" /></a>
						<a role="button" class="historial" data-id="{{$los_datos->id}}" title="Historial"><img src="{{ asset('Botones/Botones/Historial.png') }}" alt="" style="margin: 2px 0px" /></a>
						@endif
						@endif
					</div>
				</td>
			</tr>
			@endforeach
			@endif
			@if(!empty($datos_asignacion))
			@for ($i = 0; $i < count($datos_asignacion); $i++) 

			@foreach ($datos_asignacion[$i] as $los_datos)
			<tr>
				<td>{{Carbon\Carbon::createFromDate($los_datos->fecha_visita)->format('d-m-Y')}}</td>
				<td>{{$los_datos->csComuna ?? ''}}</td>
				<td>{{$los_datos->Csdireccion}} ({{$los_datos->Cscliente}} )</td>
				<td>{{$los_datos->idSala}} </td>

				@if($los_datos->estado_asignacion == "tarea_asignada")
				<td class="pendiente" style="text-transform: ">Tarea Asignada</td>
				@elseif($los_datos->estado_asignacion == "pendiente")
				<td class="pendiente" style="text-transform: ">{{ucfirst($los_datos->estado_asignacion)}}</td>
				@elseif($los_datos->estado_asignacion == "finalizado")
				<td class="finalizado" style="text-transform: ">{{ucfirst($los_datos->estado_asignacion)}}</td>
				@elseif($los_datos->estado_asignacion == "rechazado")
				<td class="rechazado" style="text-transform: ">{{ucfirst($los_datos->estado_asignacion)}}</td>
				@else
				<td>{{$los_datos->estado_asignacion}}</td>
				@endif
				<td style="text-transform: ">{{ucfirst($los_datos->CsSerie)}}</td>
				<td style="text-transform: ">{{ucfirst($los_datos->tipo)}}</td>
				<td>
					<div style="text-align: center">
						{{-- preguntamos si el estado que viene, esta finalizado --}}
						@if($los_datos->estado_asignacion != "finalizado")
						{{-- preguntamos si el tipo de datos es de intalacion o retiro --}}
						@if ($los_datos->tipo == "instalacion")
						<form action="{{route('go.ver_check')}}" method="GET">
							<input type="hidden" value="{{$los_datos->proveedor}}" name="proveedor">
							<input type="hidden" value="{{$los_datos->id}}" name="id">
							<button type="submir" class="btn"><img src="{{ asset('Botones/Botones/revisar_m.png') }}" alt="" style="margin: 2px 0px" /></button>
						</form>
						<form action="{{route('go.completando_check')}}" method="GET">
							<input type="hidden" value="{{$los_datos->proveedor}}" name="proveedor">
							<input type="hidden" value="{{$los_datos->id}}" name="id">
							<button type="submir" class="btn"><img src="{{ asset('Botones/Botones/Editar.png') }}" alt="" style="margin: 2px 0px" /></button>
						</form>
						<a role="button" class="historial_instalacion" data-proveedor="{{$los_datos->proveedor}}" data-id="{{$los_datos->id}}" title="Historial"><img src="{{ asset('Botones/Botones/Historial.png') }}" alt="" style="margin: 2px 0px" /></a>
						@if($los_datos->estado_asignacion != "pendiente" and $los_datos->estado_asignacion != "tarea_asignada")
						<a href="#" class="motivo_rechazo" data-motivo="{{$los_datos->motivo_rechazado}}" role="button" title="Motivo"><img src="{{ asset('Botones/Botones/advertir.png') }}" alt="" style="margin: 2px 0px" /></a>
						@endif
						@elseif($los_datos->tipo == "retiro")
						<form action="{{route('go.ver_checkretiro')}}" method="GET">
							<input type="hidden" value="{{$los_datos->proveedor}}" name="proveedor">
							<input type="hidden" value="{{$los_datos->id}}" name="id">
							<button type="submir" class="btn"><img src="{{ asset('Botones/Botones/revisar_m.png') }}" alt="" style="margin: 2px 0px" /></button>
						</form>
						<form action="{{route('go.ChecklistRetiros')}}" method="GET">
							<input type="hidden" value="{{$los_datos->proveedor}}" name="proveedor">
							<input type="hidden" value="{{$los_datos->id}}" name="id">
							<button type="submir" class="btn"><img src="{{ asset('Botones/Botones/Editar.png') }}" alt="" style="margin: 2px 0px" /></button>
						</form>
						<a role="button" class="historial_retiro" data-id="{{$los_datos->id}}" data-proveedor="{{$los_datos->proveedor}}" title="Historial"><img src="{{ asset('Botones/Botones/Historial.png') }}" alt="" style="margin: 2px 0px" /></a> @if ($los_datos->motivo_reasignado != "" || $los_datos->motivo_reasignado != null)
						<a href="#" class="motivo_rechazo" data-motivo="{{$los_datos->motivo_reasignado}}" c role="button" title="Motivo"><img src="{{ asset('Botones/Botones/advertir.png') }}" alt="" style="margin: 2px 0px" /></a>
						@endif
						{{-- {{$los_datos->motivo_reasignado ?? "nada"}} --}}
						@if($los_datos->estado_asignacion != "pendiente" and $los_datos->estado_asignacion != "tarea_asignada")
						<a href="#" class="motivo_rechazo" data-motivo="{{$los_datos->motivo_rechazado}}" c role="button" title="Motivo"><img src="{{ asset('Botones/Botones/advertir.png') }}" alt="" style="margin: 2px 0px" /></a>
						@endif
						@endif
						@else
						@if ($los_datos->tipo == "instalacion")
						<a href="{{route('go.ver_check',Crypt::encryptString($los_datos->id))}}" role="button" title="Revisar"><img src="{{ asset('Botones/Botones/revisar_m.png') }}" alt="" style="margin: 2px 0px" /></a>
						<a role="button" class="historial_instalacion" data-id="{{$los_datos->id}}" title="Historial"><img src="{{ asset('Botones/Botones/Historial.png') }}" alt="" style="margin: 2px 0px" /></a>
						@elseif($los_datos->tipo == "retiro")
						<a href="{{route('go.ver_checkretiro',Crypt::encryptString($los_datos->id))}}" role="button" title="Revisar"><img src="{{ asset('Botones/Botones/revisar_m.png') }}" alt="" style="margin: 2px 0px" /></a>
						<a role="button" class="historial" data-id="{{$los_datos->id}}" title="Historial"><img src="{{ asset('Botones/Botones/Historial.png') }}" alt="" style="margin: 2px 0px" /></a>
						@endif
						@endif
					</div>
				</td>
			</tr>
			@endforeach
			@endfor

			@endif
		</tbody>
		<!-- FIN RESULTADOS -->
	</table>


</div>

<!-- FIN TABLA DE RESULTADOS DE BUSQUEDA -->

</div>
<!--Modal Historial-->
<div class="modal" id="modalHistorial">
	<div class="modal-dialog modal-xl">
		<div class="modal-content">

			<!-- Modal Header -->
			<div class="modal-header">
				<div class="seccion-modal">Historial</div>
				<button type="button" class="close" data-dismiss="modal">&times;</button>
			</div>
			<hr class="separador">

			<div class="modal-body mb-3">
				<table class="table table-bordered table-responsive-lg table-striped">
					<thead>
						<th scope="col">N° de serie</th>
						<th scope="col">Direccion</th>
						<th scope="col">Cliente</th>
						<th scope="col">Fecha</th>
						<th scope="col">Contador B/N</th>
						<th scope="col">Contador Color</th>
						<th scope="col">Observaciones</th>
					</thead>
					<tbody id="agregar_historial_retiro"></tbody>
				</table>
			</div>
		</div>
	</div>
</div>
<!--Modal Historial instalacion-->
<div class="modal" id="modalHistorial_instalacion">
	<div class="modal-dialog modal-xl">
		<div class="modal-content">

			<!-- Modal Header -->
			<div class="modal-header">
				<div class="seccion-modal">Historial</div>
				<button type="button" class="close" data-dismiss="modal">&times;</button>
			</div>
			<hr class="separador">

			<div class="modal-body">
				<div class="container mb-3">
					<table class="table table-bordered table-responsive table-striped">
						<thead>
							<th scope="col">N° de atencion</th>
							<th scope="col">N° de serie</th>
							<th scope="col">Direccion</th>
							<th scope="col">Cliente</th>
							<th scope="col">Fecha</th>
							<th scope="col">Contador B/N</th>
							<th scope="col">Contador Color</th>
							<th scope="col">Tipo Visita</th>
							<th scope="col">Observaciones</th>
							<th scope="col">Accesorios</th>
						</thead>
						<tbody id="agregar_historial_instalacion"></tbody>
					</table>
				</div>
			</div>
		</div>
	</div>
</div>

<!--Modal  -->
<div class="modal" id="modalRechazo">
	<div class="modal-dialog">
		<div class="modal-content">
			<!-- Modal Header -->
			<div class="modal-header">
				<label class="seccion-modal" for="cambio">Observaciones</label>
				<button type="button" class="close" data-dismiss="modal">&times;</button>
			</div>
			<hr class="separador">

			<div class="modal-body mb-3">
				<textarea class="form-control" style="pointer-events: none" readonly="readonly" name="motivorechazado" value="" rows="4" id="motivo"></textarea>
			</div>
		</div>
	</div>
</div>


@endsection

<script>
	$(document).ready(function() {
		$('.motivo_rechazo').click(function() {
			$("#motivo").text($(this).attr("data-motivo"));
			$("#modalRechazo").modal('show');
		});
		$('.historial_retiro').click(function() {
			id = $(this).attr("data-id");
			proveedor = $(this).attr("data-proveedor");
			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				type: 'POST',
				url: "{{ route('go.historial_check') }}",
				data: {
					'id': id,
					'proveedor': proveedor
				},
				success: function(data) {
					$('#agregar_historial_retiro').empty();
					$("#modalHistorial").modal('show');
					$('#agregar_historial_retiro').append(data)
				},
				error: function(xhr, status) {
					alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
				}
			})
		})
		$('.historial_instalacion').click(function() {
			id = $(this).attr("data-id");
			proveedor = $(this).attr("data-proveedor");
			console.log(proveedor);
			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				type: 'POST',
				url: "{{ route('go.historial_check_instalacion') }}",
				data: {
					'id': id,
					'proveedor': proveedor
				},
				success: function(data) {
					$('#agregar_historial_instalacion').empty();
					$("#modalHistorial_instalacion").modal('show');
					$('#agregar_historial_instalacion').append(data);
				},
				error: function(xhr, status) {
					alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
				}
			})
		})
	})
</script>