@extends('menu/menu')

{{-- <script src="https://ajax.aspnetcdn.com/ajax/jQuery/jquery-3.4.1.min.js"></script> --}}
<script src="{{ asset('js/jquery-3.4.1.min.js') }}" ></script>
<!--<link src="sftp://aya_pruebafinal@35.232.42.155/var/www/html/rendicion/css/_______a%26a_style.css" rel="stylesheet" type="text/css">-->



@section('content')

<div class="container mt-5">
    <div class="title-vista mt-4">CHECKLIST DE RETIRO DE EQUIPOS</div>
</div>

<form action="{{route('create.checklistRetiros' , Crypt::encryptString($retiros[0]->id)) }} " method="POST">
    @csrf
    <div class="container mt-4">

        <div class="seccion-filtro">Asignación</div> 
        <hr class="separador">

        <!-- BARRA DE BUSQUEDA -->
        <div class="row">
            <!-- Fila 1 ------------------------------------------------------>
            <div class="col-sm-3 form-group">
                <label for="">Técnico asignado</label>
                <select name="tecnico" class="custom-select mayuscula">
                    <option value="" selected>SELECCIONE</option>
                    @if(!empty($trabajadores))
                        @foreach ($trabajadores   as $los_datos)
                          <option value="{{$los_datos->id}}" >{{$los_datos->nombre_uno. " ".$los_datos->apellido_uno. " ".$los_datos->apellido_dos }}  </option>
                        @endforeach
                    @endif
                </select>
                @error('tecnico')
                <div class="alert alert-danger">{{ $message }}</div>
               @enderror
            </div>
               
            <div class="col-sm-3 form-group">
                <label for="email">Nº de visita</label>
                <input type="number" class="form-control mayuscula" id=""  value="{{$total_dias}}" style="pointer-events: none"  readonly="readonly" placeholder="Nº DE VISITA" name="numero_visitas">
                @error('numero_visitas')
                   <div class="alert alert-danger">{{ $message }}</div>
                @enderror
            </div>

            <div class="col-sm-3 form-group">
                <label for="">Proyecto asociado</label>
                <select name="proyectos" class="custom-select mayuscula">
                    <option value="" selected>SELECCIONE</option>
                    @if(!empty($proyectos))
                        @foreach ($proyectos   as $los_datos)
                            <option value="{{$los_datos->id_proyecto}}">{{$los_datos->nombre." (".$los_datos->razon_social.")" }}  </option>
                        @endforeach
                    @endif
                </select>
                @error('proyectos')
                    <div class="alert alert-danger">{{ $message }}</div>
                @enderror
            </div>

            <div class="col-sm-3 form-group">
                <label for="">Fecha Retiro</label>
                <input type="date"  class="form-control mayuscula" id="" placeholder="FECHA" name="fecha_retiro"  value="">
                @error('fecha_retiro')
                    <div class="alert alert-danger">{{ $message }}</div>
                @enderror
            </div>
        </div>   


        <div class="seccion-filtro">Detalle del cliente</div> 
        <hr class="separador">

        <div class="row">
            <!-- Fila 2 ------------------------------------------------------>
           <div class="col-sm-3 form-group">
                <label for="email">Cliente</label>
                <input type="" class="form-control mayuscula" id="" placeholder="CLIENTE" name="" style="pointer-events: none"  readonly="readonly" placeholder="DIRECCIÓN" value="{{$retiros[0]->sCliente}}" name="">
            </div>

           <div class="col-sm-3 form-group">
                <label for="email">Fecha</label>
                <input type="" class="form-control mayuscula" id="" placeholder="FECHA" name=""  style="pointer-events: none"  readonly="readonly" placeholder="DIRECCIÓN" value="{{$retiros[0]->dFecharegistrado}}" name="">
            </div>

             <!-- Fila 3 ------------------------------------------------------>
            <div class="col-sm-6 form-group">
                <label for="email">Dirección</label>
                <input type="" class="form-control mayuscula" id="" style="pointer-events: none" readonly="readonly" placeholder="DIRECCIÓN" value="{{$retiros[0]->sDireccion}}" name="">
            </div>

            <div class="col-sm-3 form-group">
                <label for="email">Comuna</label>
                <input type="" class="form-control mayuscula" id="" placeholder="COMUNA" name="" style="pointer-events: none" readonly="readonly" value="{{$retiros[0]->sComuna}}">
            </div>

            <div class="col-sm-3 form-group">
                <label for="email">CUI o Código Sucursal</label>
                <input type="" class="form-control mayuscula" id="" placeholder="SC" name=""  style="pointer-events: none" readonly="readonly" value="{{$retiros[0]->sCui}}">
            </div>
        </div>

        <div class="container form-group text-center mt-5">
            <button class="btn btn-prim px-sm-5" type="submit">Guardar</button>
            <button class="btn btn-rechazar" style="margin-right:10px; display:none" type="button">RECHAZAR</button>
            <button class="btn btn-conf"  style="margin-right:10px;display:none" type="button">CONFIRMAR Y ENVIAR</button>
        </div>
    </div>
</form>
<!-- FIN BARRA DE BUSQUEDA -->

@endsection


