@extends('menu/menu')
<style>
  #myBtn {
    display: none;
    position: fixed;
    bottom: 20px;
    right: 30px;
    z-index: 99;
    border: none;
    outline: none;
    background-color: #2d2f6f;
    color: white;
    cursor: pointer;
    padding: 15px;
    border-radius: 35px;
  }

  #myBtn:hover {
    background-color: #bf4e2b;
  }
</style>
<script src="{{ asset('js/jquery-3.4.1.min.js') }}"></script>
<button class="mt-1" onclick="topFunction()" id="myBtn" title="Go to top">
  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-arrow-up-circle-fill" viewBox="0 0 16 16">
    <path d="M16 8A8 8 0 1 0 0 8a8 8 0 0 0 16 0zm-7.5 3.5a.5.5 0 0 1-1 0V5.707L5.354 7.854a.5.5 0 1 1-.708-.708l3-3a.5.5 0 0 1 .708 0l3 3a.5.5 0 0 1-.708.708L8.5 5.707V11.5z" />
  </svg>
</button>
@section('content')

<div class="container mt-5">
  <div class="title-vista mt-4">API CAPACITACIONES</div>
</div>

<form action="{{route('filtro_capacitacion')}}" method="GET">
  <div class="container mt-5">

    <div class="seccion-filtro">Filtrar por</div>
    <hr class="separador">

    <div class="row">
      <!--AQUI SE CARGA EL SELECT DE FECHA INICIO-->
      <div class="col-sm-4 form-group">
        <label for="datepicker">Fecha de inicio</label>
        <div class="input-group d-flex">
          <input type="date" class="form-control mayuscula" value="{{$fecha ?? ''}}" id="datepicker" name="datepicker">
          <div class="input-group-append">
            <button type="button" class="btn app-color" id="vaciar_fecha1" title="Borrar">
              <span class="material-icons-round">cancel</span>
            </button>
          </div>
        </div>
      </div>
      <!--AQUI SE CARGA EL SELECT DE FECHA FINAL-->
      <div class="col-sm-4 form-group">
        <label for="datepicker2">Fecha final</label>
        <div class="input-group d-flex">
          <input type="date" class="form-control mayuscula" value="{{$fecha2 ?? ''}}" id="datepicker2" name="datepicker2">
          <div class="input-group-append">
            <button type="button" class="btn app-color" id="vaciar_fecha1" title="Borrar">
              <span class="material-icons-round">cancel</span>
            </button>
          </div>
        </div>
      </div>
      <!--AQUI SE CARGA EL SELECT DE COMUNA-->
      <div class="col-sm-4 form-group">
        <label for="tecnicos">Técnico</label>
        <select id="tecnicos" name="tecnicos" class="custom-select mayuscula">
          <option selected value="">Seleccionar</option>
          @if (!empty($tecnico))
          @foreach ($tecnico as $tecnicos)
          @if ($tecnicos->nombre_uno != null)
          @if($tecnicos->id == $id_persona )
          <option selected value="{{ $tecnicos->id }}">{{ucfirst(strtolower($tecnicos->nombre_uno))}} {{ucfirst(strtolower($tecnicos->apellido_uno))}}
            @else
          <option value="{{ $tecnicos->id }}">{{ucfirst(strtolower($tecnicos->nombre_uno))}} {{ucfirst(strtolower($tecnicos->apellido_uno))}}
            @endif
            @endif
            @endforeach
            @endif
        </select>
      </div>
    </div>

    <div class="row">
      <!--AQUI SE CARGA EL SELECT DE ESTADO-->
      <div class="col-sm-4 form-group">
        <label for="estado">Estado de instalación</label>
        <select id="estado" name="estado" class="custom-select mayuscula">
          <option selected value="">Seleccionar</option>
          @if (!empty($carga_selectEstado))
          @foreach ($carga_selectEstado as $estados)
          @if ($estados->estado_capa != null)
          @if ($estados->estado_capa == $estado)
          <option selected value="{{ $estados->estado_capa }}">{{ucfirst(strtolower($estados->estado_capa))}}</option>
          @else
          <option value="{{ $estados->estado_capa }}">{{ucfirst(strtolower($estados->estado_capa))}}</option>
          @endif
          @endif
          @endforeach
          @endif
        </select>
      </div>
      <!--AQUI SE CARGA EL SELECT DE ESTADO-->
      <div class="col-sm-4 form-group">
        <label for="clientes">Cliente</label>
        <select class="custom-select mayuscula" id="clientes" name="clientes">
          <option selected value="">Seleccionar</option>
          @if (!empty($carga_selectClientes))
          @foreach ($carga_selectClientes as $cliente)
          @if ($cliente->sCliente != null)
          @if($cliente->sCliente == $clientes)
          <option selected value="{{ $cliente->sCliente }}">{{ucfirst(strtolower($cliente->sCliente ))}}</option>
          @else
          <option value="{{ $cliente->sCliente }}">{{ucfirst(strtolower($cliente->sCliente ))}}</option>
          @endif
          @endif
          @endforeach
          @endif
        </select>
      </div>
      <!-- CUI -->
      <div class="col-sm-4 form-group">
        <label for="cui">CUI</label>
        <input type="" class="form-control mayuscula" id="cui" placeholder="cui" name="cui">
      </div>

    </div>

    <div class="row bg-seccion-filtro rounded">
      <!--AQUI SE CARGA EL SELECT DE REGION-->
      <div class="col-sm-3 form-group">
        <label for="region">Región</label>
        @if (!empty($disable))
        <select id="region" name="region" class="custom-select mayuscula">
          @else
          <select id="region" disabled name="region" class="custom-select mayuscula">
            @endif
            <option selected value="">Seleccionar</option>
            <option selected value="">Todos</option>
            @if (!empty($carga_selectRegion))
            @foreach ($carga_selectRegion as $regiones)
            @if ($regiones->sRegion != null)
            @if($regiones->sRegion == $region)
            <option selected value="{{ $regiones->sRegion }}">{{ucfirst(strtolower($regiones->sRegion))}} </option>
            @else
            <option value="{{ $regiones->sRegion }}">{{ucfirst(strtolower($regiones->sRegion))}} </option>
            @endif
            @endif
            @endforeach
            @endif
          </select>
      </div>
      <!--AQUI SE CARGA EL SELECT DE COMUNA-->
      <div class="col-sm-3 form-group">
        <label for="comuna">Comuna</label>
        @if (!empty($disable))
        <select id="comuna" name="comuna" class="custom-select mayuscula">
          @else
          <select id="comuna" disabled name="comuna" class="custom-select mayuscula">
            @endif
            <option selected value="">Seleccionar</option>
            <option selected value="">Todos</option>
            @if (!empty($carga_selectComuna))
            @foreach ($carga_selectComuna as $comunas)
            @if ($comunas->sComuna != null)
            @if( $comunas->sComuna === $comuna)
            <option selected value="{{ $comunas->sComuna }}">{{ucfirst(strtolower($comunas->sComuna))}}</option>
            @else
            <option value="{{ $comunas->sComuna }}">{{ucfirst(strtolower($comunas->sComuna))}}</option>
            @endif
            @endif
            @endforeach
            @endif
          </select>
      </div>
      <!--AQUI SE CARGA EL SELECT DE DIRECCION-->
      <div class="col-sm-3 form-group">
        <label for="direccion">Dirección</label>
        @if (!empty($disable))
        <select name="direccion" id="direccion" class="custom-select mayuscula">
          @else
          <select name="direccion" disabled id="direccion" class="custom-select mayuscula">
            @endif
            <option selected value="">Seleccionar</option>
            <option selected value="">Todos</option>
            @if(!empty($carga_selectDireccion))
            @foreach($carga_selectDireccion as $direcciones)
            @if ($direcciones->sDireccion != null)
            @if($direcciones->sDireccion == $direccion)
            <option selected value="{{$direcciones->sDireccion}}">{{$direcciones->sDireccion}}</option>
            @else
            <option value="{{$direcciones->sDireccion}}">{{$direcciones->sDireccion}}</option>
            @endif
            @endif
            @endforeach
            @endif
          </select>
      </div>
      <!--AQUI SE CARGA EL SELECT DE SUCURSAL-->
      <div class="col-sm-3 form-group">
        <label for="sucursal">Sucursal</label>
        @if (!empty($disable))
        <select name="sucursal" id="sucursal" class="custom-select mayuscula">
          @else
          <select name="sucursal" disabled id="sucursal" class="custom-select mayuscula">
            @endif
            <option selected value="">Seleccionar</option>
            <option selected value="">Todos</option>
            @if (!empty($carga_selectSucursal))
            @foreach($carga_selectSucursal as $sucursales)
            @if ($sucursales->sTipo_sucursal != null)
            @if($sucursales->sTipo_sucursal == $sucursal)
            <option selected value="{{$sucursales->sTipo_sucursal}}">{{$sucursales->sTipo_sucursal}}</option>
            @else
            <option value="{{$sucursales->sTipo_sucursal}}">{{$sucursales->sTipo_sucursal}}</option>
            @endif
            @endif
            @endforeach
            @endif
          </select>
      </div>
      <div class="container">
        <a href="" onclick="actualizar_regiones()" class="btn btn-ter float-sm-right">
          <span class="material-icons-round">update</span>
          Actualizar datos de Región
        </a>
      </div>
    </div>
  </div>

  <div class="container mt-5">
    {{-- BOTON BUSCAR --}}
    <div class="text-center mb-5 mt-5">
      <button type="buscar" class="btn btn-pill btn-prim w-25">Buscar</button>
    </div>
  </div>

  {{-- TABLA DE RESULTADOS --}}
  <div class="container table-responsive mt-5">
    <table class="table table-striped table-hover" id="mitable">
      <thead class="color-head">
        <tr>
          <th class="th-head border-th separador-v" colspan="1">CUI</th>
          <th class="th-head border-th separador-v" colspan="1">Fecha capacitación</th>
          <th class="th-head border-th separador-v" colspan="1">Estado</th>
          <th class="th-head border-th separador-v" colspan="1">Cliente</th>
          <th class="th-head border-th separador-v" colspan="1">Comuna</th>
          <th class="th-head border-th separador-v" colspan="1">Dirección</th>
          <th class="th-head border-th"><span class="material-icons">settings</span></th>
        </tr>
      </thead>
      <!-- FIN ENCABEZADO -->

      <!-- RESULTADOS -->
      <tbody>
        @foreach ($datos_instalacion as $capacitacion)
        <tr>
          <td>{{$capacitacion->sCui}}</td>
          @php
          $lastStatus = DB::table('asignacion_capacitaciones')
          ->select('fecha_capacitacion','estado_capa')
          ->where('direccion','=',$capacitacion->sDireccion)
          ->orderBy('asignacion_capacitaciones.id','DESC')
          ->take(1)
          ->get();
          $cont = count($lastStatus);
          @endphp
          <td>
            @if($cont != 0)
            {{Carbon\Carbon::createFromDate($lastStatus[0]->fecha_capacitacion)->format('d-m-Y')}}
            @else
            No informado
            @endif
          </td>
          @if($cont != 0)
          <td>{{$lastStatus[0]->estado_capa ?? 'No informado'}}</td>
          @else
          <td>No informado</td>
          @endif
          <td>{{$capacitacion->sCliente}}</td>
          <td>{{$capacitacion->sComuna}}</td>
          <td>{{$capacitacion->sDireccion}}</td>
          <td class="td-val">
            <div class="d-flex justify-content-around">
              <a role="button" class="btn-icon btn-icon-dd ver_historial" title="Ver Detalle" data-id="{{Crypt::encryptString($capacitacion->sDireccion)}}">
                <span class="material-icons">history</span>
              </a>
              <a href="#" class="img1 asignar btn-icon btn-icon-dd" data-id="{{$capacitacion->sDireccion}}" data-toggle="modal" data-target="#modal_asignacion" role="button" title="Asignar"><span class="material-icons"> add_box </span></a>
            </div>
          </td>
        </tr>
        @endforeach
      </tbody>
    </table>
  </div>
</form>
<!-- Modal -->
<div class="modal fade" id="modal_asignacion" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLongTitle">Asignar capacitación</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <!--AQUI SE CARGA EL SELECT DE COMUNA-->
        <div class="container col-sm form-group">
          <label for="tecnicos">
            <h2>Técnico</h2>
          </label>
          <select id="m_tecnicos" name="m_tecnicos" class="custom-select mb-3">
            <option selected disabled>seleccionar</option>
            @if (!empty($tecnico))
            @foreach ($tecnico as $tecnicos)
            @if ($tecnicos->nombre_uno != null)
            <option value="{{ $tecnicos->id_trabajador }}">{{ucfirst(strtolower($tecnicos->nombre_uno))}} {{ucfirst(strtolower(($tecnicos->apellido_uno)))}}
              @endif
              @endforeach
              @endif
          </select>
        </div>
        <div class="container col-sm form-group">
          <label for="datepicker">
            <h2>Fecha capacitación</h2>
          </label>
          <input type="date" class="form-control" id="m_datepicker" name="m_datepicker">
          <input type="text" value="" id="md_id_cui" name="idcui" style="display:none">
        </div>
        <div id="result-username"></div>
      </div>
      <div class="modal-footer">
        <button id="btncerrar_crear" type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
        <button type="submit" onclick="submitCrearAsignacion()" class="btn btn-guardar float-sm-right"> ASIGNAR</button>
      </div>
    </div>
  </div>
</div>
<!--MODAL HISTORIAL CAPACITACIONES-->
<div class="modal fade" id="modal_historial_capacitacion" role="dialog">
  <div class="modal-dialog  modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <div class="seccion-modal">Historial de Capacitacion</div>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      <hr class="separador ml-4 mr-4">
      <div class="modal-body">
        <div class="container mb-4">
          <table class="table table-sm table-bordered table-responsive-md table-striped table-hover mt-4" style="margin: 0" id="dataGrid">
            <!-- ENCABEZADO -->
            <thead class="color-head">
              <tr>
                <th class="th-head border-th separador-v" colspan="1">DIRECCION</th>
                <th class="th-head border-th separador-v" colspan="1">FECHA ASIGNADA</th>
                <th class="th-head border-th separador-v" colspan="1">TECNICO</th>
                <th class="th-head border-th separador-v" colspan="1">ESTADO</th>
                <th class="th-head border-th">
                  <span class="material-icons">settings</span>
                </th>
              </tr>
            </thead>
            <tbody id="cuerpo_tabla"></tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
<!-- Modal -->
@endsection
<script>
  //Get the button
  var mybutton = document.getElementById("myBtn");

  // When the user scrolls down 20px from the top of the document, show the button
  window.onscroll = function() {
    scrollFunction()
  };

  function scrollFunction() {
    if (document.body.scrollTop > 20 || document.documentElement.scrollTop > 20) {
      mybutton.style.display = "block";
    } else {
      mybutton.style.display = "none";
    }
  }

  // When the user clicks on the button, scroll to the top of the document
  function topFunction() {
    document.body.scrollTop = 0;
    document.documentElement.scrollTop = 0;
  }
</script>
<script type="text/javascript">
  $(document).ready(function() {
    $('.ver_historial').click(function() {
      var direccion = $(this).attr("data-id");
      var _token = $('input[name="_token"]').val();
      $.ajax({
        method: "POST",
        url: "{{ route('capacitaciones.asociadas') }}",
        data: {
          'direccion': direccion,
          _token: _token
        },
        success: function(data) {
          console.log(data);
          $("#cuerpo_tabla").empty();
          $("#cuerpo_tabla").append(data);
          $("#modal_historial_capacitacion").modal('show');
          //validacion del boton
          var toma2 = "";
          //estado con boton
          var cancel = "cancelado";
          //estados sin boton
          var pend = "pendiente";
          var revis = "revisado";
          var asigna = "asignado";
          var fina = "finalizado";
          var recha = "rechazado";
          //funcion para botener el estado de la primera fila
          $.each($("#dataGrid:eq(0)"), function() {
            toma2 = $(this).find('td').eq(3).html();
            console.log(toma2);
            //estados sin boton
            if (toma2 == 'cancelado' || toma2 == "Cancelado") {
              $('#btnview').show();
            } else if (toma2 == pend || toma2 == "Pendiente") {
              $('#btnview').show();
            } else if (toma2 == fina || toma2 == "Finalizado") {
              $('#btnview').hide();
            } else if (toma2 == asigna || toma2 == "Asignado") {
              $('#btnview').hide();
            } else if (toma2 == revis || toma2 == "Revisado") {
              $('#btnview').hide();
            } else if (toma2 == recha || toma2 == "Rechazado") {
              $('#btnview').hide();
            } else if (toma2 == "revisar" || toma2 == "Revisar") {
              $('#btnview').hide();
            } else if (toma2 == "tarea_asignada" || toma2 == "Tarea_asignada" || toma2 == "Tarea Asignada") {
              $('#btnview').hide();
            } else if (data == '<tr><td>Sin Datos</td></tr>') {
              $('#btnview').show();
            }
          });
        },
        error: function(xhr, status) {
          alert('Disculpe, ha ocurrido un problema, intente mas tarde');
        }
      });
    })
    //script para cargar el modal
    $('.asignar').click(function() {
      $("#modal_asignacion").modal('show');
      var dcui2 = $(this).attr("data-id");
      $("#md_id_cui").val(dcui2);

    });
    $('#btncerrar_crear').click(function() {
      $("#modal_asignacion").modal('hide');
      location.reload();
    });

  });
</script>
<script>
  function submitCrearAsignacion() {
    var id_trabajador = $('#m_tecnicos').val();
    var fecha = $('#m_datepicker').val();
    if (id_trabajador == null) {
      alert('Seleccionar técnico');
      $('#m_tecnicos').focus();
      return false;
    } else if (fecha.trim() == "") {
      alert('Ingresar fecha');
      $('#m_datepicker').focus();
      return false;
    }
    var dcui = $("#md_id_cui").val();
    var _token = $('input[name="_token"]').val();
    $.ajax({
      method: "POST",
      url: "{{ route('go.asginarCapacitacion') }}",
      data: {
        'scui': dcui,
        'id_trabajador': id_trabajador,
        'fecha': fecha,
        _token: _token
      },
      success: function(data) {
        console.log(data);
        if (data != "") {
          setTimeout(function() {
           $('#result-username').html(data).fadeOut(10000);
          }, 100);
          setTimeout(function() {
            location.reload();
          }, 1000);
        } else {
          alert("sin Datos");
        }
      }
    });
  }
</script>
<script>
  $(document).ready(function() {
    $('#vaciar_fecha1').click(function() {
      $('#datepicker').val("");
    });
    $('#vaciar_fecha2').click(function() {
      $('#datepicker2').val("");
    });
  });
</script>
<script>
  function actualizar_regiones() {
    var _token = $('input[name="_token"]').val();
    $.ajax({
      method: "GET",
      url: "{{ route('go.actualizarregiones') }}",
      data: {
        _token: _token
      },
      success: function(data) {
        alert("proceso Completado");
        location.reload();
      },
      error: function(xhr, status) {
        alert('Disculpe, ha ocurrido un problema, intente mas tarde');
      }
    });
  }
  $(document).ready(function() {
    $("#clientes").change(function() {
      cliente = $('select[id=clientes]').val();
      var _token = $('input[name="_token"]').val();
      $.ajax({
        method: "POST",
        url: "{{ route('buscarRegionClientes') }}",
        data: {
          _token: _token,
          'cliente': cliente
        },
        success: function(data) {
          console.log(data);
          $("#comuna").empty();
          $("#direccion").empty();
          $("#sucursal").empty();
          $("#region").empty();
          $("#comuna").append('<option value="">Seleccionar</option>');
          $("#direccion").append('<option value="">Seleccionar</option>');
          $("#sucursal").append('<option value="">Seleccionar</option>');
          $("#region").append('<option value="">Seleccionar</option>');
          $(data).each(function(i, v) { // indice, valor
            $("#region").append('<option value="' + v.sRegion + '">' + v.sRegion + '</option>');
          })
          $('#region').prop('disabled', false);
        },
        error: function(xhr, status) {
          alert('Disculpe, ha ocurrido un problema, intente mas tarde');
        }
      });
    });

    $("#region").change(function() {
      region = $('select[id=region]').val();
      var _token = $('input[name="_token"]').val();
      $.ajax({
        method: "POST",
        url: "{{ route('buscarComunas') }}",
        data: {
          'region': region,
          _token: _token,
          'cliente': $("#clientes").val()
        },
        success: function(data) {
          $("#comuna").empty();
          $("#direccion").empty();
          $("#sucursal").empty();
          $("#comuna").append('<option value="">Seleccionar</option>');
          $("#direccion").append('<option value="">Seleccionar</option>');
          $("#sucursal").append('<option value="">Seleccionar</option>');
          $(data).each(function(i, v) { // indice, valor
            $("#comuna").append('<option value="' + v.sComuna + '">' + v.sComuna + '</option>');
          })
          $('#comuna').prop('disabled', false);
        },
        error: function(xhr, status) {
          alert('Disculpe, ha ocurrido un problema, intente mas tarde');
        }
      });
    });
    $("#comuna").change(function() {
      comuna = $('select[id=comuna]').val();
      var _token = $('input[name="_token"]').val();
      $.ajax({
        method: "POST",
        url: "{{ route('buscardirecciones') }}",
        data: {
          'comuna': comuna,
          _token: _token,
          'cliente': $("#clientes").val()
        },
        success: function(data) {
          $("#direccion").empty();
          $("#sucursal").empty();
          $("#direccion").append('<option value="">Seleccionar</option>');
          $("#sucursal").append('<option value="">Seleccionar</option>');
          $(data).each(function(i, v) { // indice, valor 
            $("#direccion").append('<option value="' + v.sDireccion + '">' + v.sDireccion + '</option>');
          })
          $('#direccion').prop('disabled', false);
        },
        error: function(xhr, status) {
          alert('Disculpe, ha ocurrido un problema, intente mas tarde');
        }
      });
    });

    $("#direccion").change(function() {
      direccion = $('select[id=direccion]').val();
      var _token = $('input[name="_token"]').val();
      $.ajax({
        method: "POST",
        url: "{{ route('buscarsucursales') }}",
        data: {
          'direccion': direccion,
          _token: _token,
          'cliente': $("#clientes").val()
        },
        success: function(data) {
          $("#sucursal").empty();
          $("#sucursal").append('<option value="">Seleccionar</option>');
          $(data).each(function(i, v) { // indice, valor
            //if(v.ssucursal != null || v.ssucursal != "null"  ){ 
            $("#sucursal").append('<option value="' + v.sTipo_sucursal + '">' + v.sTipo_sucursal + '</option>');
          })
          // }
          $('#sucursal').prop('disabled', false);
        },
        error: function(xhr, status) {
          alert('Disculpe, ha ocurrido un problema, intente mas tarde');
        }
      });
    });
  });
</script>