@extends('menu/menu')

@section('content')

    <div class="container mt-5">

        <div class="title-vista mt-4">REPORTES</div>
        <div class="seccion-filtro">Filtrar por</div>
        <hr class="separador">

    </div>

    <div class="container mt-5">
        <div class="container-fluid mt-4 mb-4 contenido" id="form-container">
            <div class="row">
                {{-- FECHAS --}}
                <div class="col-sm-4 form-group">
                    <label for="fecha">Fecha Inicio</label>
                    <div class="input-group d-flex">
                    <input type="date" class="form-control" id="fecha" value="" name="fecha">
                    <div class="input-group-append">
                        <button type="button" class="btn app-color" id="vaciar_fecha1" title="Borrar">
                            <span class="material-icons-round">cancel</span>
                        </button>
                    </div>
                </div>
              </div>
                <div class="col-sm-4 form-group">
                    <label for="fecha">Fecha Fin</label>
                    <div class="input-group d-flex">
                    <input type="date" class="form-control" id="fecha2" value="" name="fecha">
                    <div class="input-group-append">
                        <button type="button" class="btn app-color" id="vaciar_fecha2" title="Borrar">
                            <span class="material-icons-round">cancel</span>
                        </button>
                    </div>
                </div>
                </div>

                {{-- FIN FECHAS --}}
                <div class="col-sm-1 form-group">

                </div>

                {{-- NUMERO DE SERIE  --}}
                <div class="col-sm-3 form-group">
                    <label for="numero_serie">Numero Serie</label>
                    <input type="text" name="numero_serie" autocomplete="off" value="" class="form-control"
                        id="numero_serie" placeholder="Numero de Serie">
                    <div class="input_show" id="listaarrow"></div>
                    <input type="text" value="" id="numero_serie_" name="" style="display:none">
                </div>

                {{-- FIN NUMERO DE SERIE --}}
            </div>

            {{-- PRIMERO SELECT/ POR DEFECTO --}}
            <div class="row">
                <div class="col-sm-4 form-group">
                    <select disabled class="custom-select mb-3" onclick="opciones(0)" name="opciones" id="opciones0">
                        <option value="tipo" selected>Tipo de atencion</option>
                    </select>
                </div>
                <div class="col-sm-4 form-group">
                    <select required class="custom-select mb-3" name="seleccion" id="seleccion0">
                        <option value='instalacion'>Instalacion</option>
                        <option value='capacitacion'>Capacitacion</option>
                        <option value='retiro'>Retiro</option>
                    </select>
                </div>
                <div class="col-sm-1 form-group">
                    <a role="button" class="btn-icon btn-icon-dd agregar" onclick="agregalo()" id="id_agregar0" title="">
                        <span class="material-icons">add_circle</span>
                    </a>
                </div>
            </div>

            {{-- FIN PRIMER SELECT DEFECTO  --}}
        </div>

        {{-- Botón enviar --}}
        <div class="text-center mb-5">
            <button onclick="enviar()" type="submit" class="btn btn-pill btn-prim w-25">Enviar</button>
        </div>
    </div>

    {{-- AQUI VA LA TABLA DE RESULTADOS  --}}
    <div class="container table-responsive mb-5 tabla">
        
    </div>

    {{-- AQUI VA EL MODAL --}}
    <div class='container table-responsive p-0 exportar'>

    </div>

     {{-- MODAL TABLA  --}}

     <div class="modal fade" id="modal_historial_detalle" role="dialog">
        <div class="modal-dialog  modal-lg">
          <div class="modal-content">
            <div class="modal-header">
              <h1 style="margin-top: 50px">DETALLE REPORTES</h1>
              <button type="button" class="close" data-dismiss="modal">&times;</button>
            </div>
            <form>
            <div class="modal-body">
              <div class="container"><!-- sombra de separación con el fondo -->
                <div class="container mt-5 p-0 datos">

                </div>
            </div>
          </form>
          </div>
        </div>
      </div>

@endsection

<script src="{{ asset('js/jquery-3.4.1.min.js') }}"></script>


<script>
    var aux = 1;

    var cont = 0;

// BOTON EXCEL 
    var excel = '<ul class="nav bg-export">' +
                  '<li class="clas-item">' +
                    '<a class="btn btn-ter" id="exportar" target="_blank">' +
                      'Exportar excel' +
                     ' <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-earmark-excel-fill" viewBox="0 0 16 16">' +
                       ' <path d="M9.293 0H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V4.707A1 1 0 0 0 13.707 4L10 .293A1 1 0 0 0 9.293 0zM9.5 3.5v-2l3 3h-2a1 1 0 0 1-1-1zM5.884 6.68 8 9.219l2.116-2.54a.5.5 0 1 1 .768.641L8.651 10l2.233 2.68a.5.5 0 0 1-.768.64L8 10.781l-2.116 2.54a.5.5 0 0 1-.768-.641L7.349 10 5.116 7.32a.5.5 0 1 1 .768-.64z"/>'+
                      '</svg>'+
                      '</a>'+
                      '</li>'+
                     '<li class="m-auto">'+
                     '<i>Para ver toda la información, deslice a la derecha</i>'+
                     '<span class="material-icons-round icon-midle">trending_flat</span>'+
                     '</li>'+
                      '</ul>';

// BOTON VER MAS 
    var boton ='<div class="text-center mb-5">' +
            '<button onclick="modal()" type="submit" class="btn btn-pill btn-prim w-25">Ver Mas</button>' +
        '</div>';
    // CREAR CONTENEDOR NUEVO 

    function agregalo() {
        var contenido = '<div class="row eliminar' + aux + '">' +
            '<div class="col-sm-4 form-group eliminar' + aux + '">' +
            '<select required class="custom-select mb-3 eliminar' + aux + '" onclick="opciones(' + aux +
            ')" name="opciones" id="opciones' + aux + '">' +
            '<option value="seleccionar" selected>Seleccionar</option>' +
            '<option value="proveedor">Proveedor</option>' +
            '<option value="cliente">Cliente</option>' +
            '<option value="estado">Estado</option>' +
            '<option value="region">Region</option>' +
            '<option value="comuna">Comuna</option>' +
            '<option value="direccion">Direccion</option>' +
            '<option value="sucursal">Sucursal</option>' +
            '<option value="tecnico">Tecnico</option>' +
            '</select>' +
            '</div>' +
            '<div class="col-sm-4 form-group">' +
            '<select required class="custom-select mb-3 eliminar' + aux + '" name="seleccion" id="seleccion' + aux +
            '">' +
            '<option value="" selected>Seleccionar</option>' +
            '</select>' +
            '</div>' +
            '<div class="col-sm-4 form-group">' +
            '<a role="button" onclick="agregalo()" id="id_agregar"' + aux + ' class="btn-icon btn-icon-dd eliminar' +
            aux + '">' +
            '<span class="material-icons">add_circle</span>' +
            '</a>' +
            '<a role="button" onclick="eliminalo(' + aux + ')" class="btn-icon btn-icon-dd quitar eliminar' + aux +
            '" title="" id="id_eliminar"' + aux + '>' +
            '<span class="material-icons">remove_circle</span>' +
            '</a>' +
            '</div>' +
            '</div>';



        $('.contenido').append(contenido);

        aux++;
        cont++;
    }

    // ELIMINAR CONTENEDOR

    function eliminalo(params) {

        console.log("entro");
        $(".eliminar" + params).remove();

        aux--;
    }

// ABRIR MODAL 
    function modal(params) {
        
        $("#modal_historial_detalle").modal('show');
        $('.datos').empty();
        $(".datos").append(excel);
        var _token = $('input[name="_token"]').val();
        var opcion = [];
        var resultado = [];
        var fecha = $('#fecha').val();
        var fecha2 = $('#fecha2').val();
        var serie = $("#numero_serie_").val();
        

        for (let i = 0; i < aux; i++) {
            resultado[i] = $('#seleccion' + i).val();
            opcion[i] = $('select[id=opciones' + i + ']').val();
        }
        $.ajax({
            method: "POST",
            url: "{{ route('consulta_tabla_reporte') }}",
            data: {
                'cont' : cont,
                'serie': serie,
                'fecha2': fecha2,
                'fecha': fecha,
                'opcion': opcion,
                'resultado': resultado,
                _token: _token
            },
            success: function(data) {
                $('.datos').append(data);
                console.log(data);
                $('#exportar').click(function (e) {
                    var a = document.createElement('a');
                    var cuerpoA = "<table>";
                    var cuerpoB = "</table>";
                    var cuerpoC = $(data).html();
                    var cuerpo = cuerpoA + cuerpoC + cuerpoB;
                    a.href ='data:application/vnd.ms-excel,' + escape(cuerpo);
                    a.download = 'Reporte.xls';
                    a.click();
                    e.preventDefault();
                });
            },
            error: function(xhr, status) {
                alert('Disculpe, ha ocurrido un problema, intente mas tarde');
            }
        });        
        
    }


// TRAE LAS OPCIONES DEL CONTROLADOR
    function opciones(params) {

        var _token = $('input[name="_token"]').val();
        opcion = $('select[id=opciones' + params + ']').val();
        var opciones = [];
        var resultado = [];

        for (let i = 0; i < aux; i++) {
            resultado[i] = $('#seleccion' + i).val();
            opciones[i] = $('select[id=opciones' + i + ']').val();
        }

        $.ajax({
            method: "POST",
            url: "{{ route('reporte') }}",
            data: {
                'opcion': opcion,
                _token: _token,
                'resultado': resultado,
                'cont' : cont,
                'opciones' : opciones
            },
            success: function(data) {
              console.log(data);
                $('#seleccion' + params).empty();
                $('#seleccion' + params).append(data);
            },
            error: function(xhr, status) {
                alert('Disculpe, ha ocurrido un problema, intente mas tarde');
            }
        });
    }

    

// BOTON ENVIAR 
    function enviar() {

        var _token = $('input[name="_token"]').val();
        var opcion = [];
        var resultado = [];
        var fecha = $('#fecha').val();
        var fecha2 = $('#fecha2').val();
        var serie = $("#numero_serie_").val();
        

        console.log(serie);


        for (let i = 0; i < aux; i++) {
            resultado[i] = $('#seleccion' + i).val();
            opcion[i] = $('select[id=opciones' + i + ']').val();
        }
        $.ajax({
            method: "POST",
            url: "{{ route('tabla.api_reportes') }}",
            data: {
                'cont' : cont,
                'serie': serie,
                'fecha2': fecha2,
                'fecha': fecha,
                'opcion': opcion,
                'resultado': resultado,
                _token: _token
            },
            success: function(data) {
                $('.tabla').empty();
                $('.tabla').append(data);
            },
            error: function(xhr, status) {
                alert('Debe tener mas de una opcion seleccionada');
            }
        });
        
        $('.exportar').empty();
        $('.exportar').append(boton);
        
    }


    
    $(document).ready(function() {

// NUMERO DE SERIE 
        $('#numero_serie').keyup(function() {
            var query = $(this).val();
            var _token = $('input[name="_token"]').val();
            var opcion = [];

            for (let i = 0; i < aux; i++) {
                opcion[i] = $('select[id=opciones' + i + ']').val();
            }
            $.ajax({

                url: "{{ route('numero_serie') }}",
                method: "POST",
                data: {
                    'opcion': opcion,
                    query: query,
                    _token: _token
                },
                success: function(data) {
                    $('#listaarrow').fadeIn();
                    $('#listaarrow').html(data);
                }
            });
        });


        $(document).on('click', 'li', function() {
            $('#numero_serie').val($(this).text());
            $('#listaarrow').fadeOut();

            $("#numero_serie_").val($(this).attr("data-rut"));

        });

        $('#vaciar_fecha1').click(function() {
            $('#fecha').val("");
        });
        $('#vaciar_fecha2').click(function() {
            $('#fecha2').val("");
        });

    });
</script>
