<?php
    namespace App\Mail;

    use Illuminate\Bus\Queueable;
    use Illuminate\Contracts\Queue\ShouldQueue;
    use Illuminate\Mail\Mailable;
    use Illuminate\Queue\SerializesModels;

    class TestMail extends Mailable{
        use Queueable, SerializesModels;
        public $details;
        public $sc;
        public $nSerie;

        public function __construct($details,$sc,$nSerie,$size){
            $this->details = $details;
            $this->sc = $sc;
            $this->nSerie = $nSerie;
            $this->size = $size;
        }
        public function build()
        {
            $sc = $this->sc;
            $nSerie = $this->nSerie;
            $size = $this->size;
            if (!empty($sc)) {
                if ($size >= 20000000) {
                    return $this->subject($sc)->view('email.TestEmail');
                }else{
                    return $this->subject($sc)->view('email.TestEmail')->attach(storage_path('app/public/pdfServicio/' . $sc . 'servicio.pdf'));
                }
            }else{
                if ($size >= 20000000) {
                    return $this->subject($nSerie)->view('email.TestEmail');
                } else {
                    return $this->subject($nSerie)->view('email.TestEmail')->attach(storage_path('app/public/pdfinstalacion/' . $nSerie . 'instalacion.pdf'));
                }            
            }
        }
    }