<?php

namespace App\Http\Controllers\prefactura;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
use App;
use App\ciudad_bases;
use Carbon\Carbon;
use Crypt;

class mantenedorCiudadbaseController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $ciudad_base = DB::table('ciudad_bases')
        ->join('regions','regions.id','ciudad_bases.id_region')
        ->select('ciudad_bases.ciudad_base','regions.des_region','ciudad_bases.id','regions.id as region_id')
        ->get();

        return view('check.ver_mantenedor_ciudadbase',compact('ciudad_base'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        if($request->region != "" || $request->ciudad_base != ""){
            $verificar_region = App\region::where('des_region','=',$request->region)->exists();
            $verificar_ciudad_base = App\ciudad_bases::where('ciudad_base','=',$request->ciudad_base)->exists();
            if($verificar_ciudad_base == 1 && $verificar_region == 1){
                return back()->with('mensaje2', 'Nombre region y ciudad base ya existen');
            }elseif($verificar_ciudad_base == 1){
                return back()->with('mensaje2', 'Nombre de la ciudad base ya existe');
            }elseif($verificar_region == 1){
                return back()->with('mensaje2', 'Nombre de la region ya existe');
            }else{
                $region = new App\region;
                $region->des_region = $request->region;
                $region->num_region = "prueba";
                $region->num_r = "prueba";
                $region->abreviatura = "prueba";
                $region->timestamps = false;
                $region->save();

                $ciudad_bases = new App\ciudad_bases;
                $ciudad_bases->id_region =  $region->id;
                $ciudad_bases->ciudad_base =  $request->ciudad_base;
                $ciudad_bases->timestamps = false;
                $ciudad_bases->save();

                return back()->with('mensaje', 'Kilometro Creados');
            }
        }else{
            return back()->with('mensaje2', 'Inserte datos requeridos');
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy( request $request )
    {

        $ciudad_base = App\ciudad_bases::findOrFail($request->id_ciudad_base);
        $ciudad_base->delete();

        $region =  App\region::findOrFail($request->id_region);
        $region->delete();

        return back()->with('mensaje', 'Ciudad base Eliminada');
       
    }

    public function filtros_mantenedor_kilometros(Request $request)
    {

     
    }

    public function ver_datos_ciudad_base(request $request){


        $ciudad_base = DB::table('ciudad_bases')
        ->join('regions','regions.id','ciudad_bases.id_region')
        ->select('ciudad_bases.ciudad_base','regions.des_region')
        ->where('ciudad_bases.id','=',$request->id)
        ->get();

        return $ciudad_base;

       
    }

    public function editar(request $request){

        $id = $request->id_ciudad_base;

        if($request->ciudad_base != ""){

            $ciudad_base = App\ciudad_bases::findOrFail($id);
            $ciudad_base->ciudad_base = $request->ciudad_base;
            $ciudad_base->timestamps = false;
            $ciudad_base->save();

            return back()->with('mensaje', 'Ciudad base modificado');

        }else{

            return back()->with('mensaje2', 'Ingrese los datos requeridos');

        }

    }
}
