<?php

namespace App\Http\Controllers\graficos;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App;
use Illuminate\Support\Facades\Storage;
use App\direccion;
use App\persona;
use App\User;
use Auth;
use Session;
use DateTime;
use DateInterval;
use DatePeriod;
use DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Carbon\Carbon;

class graficosController extends Controller
{
    public function __construct()

    {

        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    public function grafico_total_instalaciones_proyectos(request $req)
    {
        $cliente = '';
        $totalInstalaciones = '';
        $totalFinalizados = '';
        $response = array();

        $pro = "";

        if ($req->proveedor == "" || $req->proveedor  == null) {
            $pro = Auth::user()->nombre_proveedor;
        } else {
            $pro = $req->proveedor;
        }
        $pro =  DB::connection()->getDatabaseName();

        $instalaciones = DB::table('instalacions')
            ->select('sCliente', DB::raw('count(*) as total'))
            ->groupBy('sCliente')
            ->where("proveedor_instalacion", "=", $pro)
            // ->where("proveedor_instalacion","=","KYOCERA")
            ->orderBy('total', 'desc')
            ->get();

        foreach ($instalaciones as $v1) {

            // print_r($v1->sCliente);
            // print_r($v1->total);

            $instalaciones_comepletadas = DB::table('instalacions')
                ->select('sCliente', DB::raw('count(*) as total_finalizados'))
                ->groupBy('sCliente')
                //  ->where("proveedor_instalacion","=","KYOCERA")
                ->where("proveedor_instalacion", "=", $pro)
                ->where("sEstado_instalacion", "=", "finalizado")
                ->where("sCliente", "=", $v1->sCliente)
                ->orderBy('total_finalizados', 'desc')
                ->get();


            if (count($instalaciones_comepletadas) > 0) {

                foreach ($instalaciones_comepletadas as $v2) {

                    $cliente = $this->generarNombre($v1->sCliente);
                    $totalInstalaciones = $v1->total;
                    $totalFinalizados = $v2->total_finalizados;
                    // print_r($v2->total_finalizados."<br>");

                }
            } else {
                $cliente = $this->generarNombre($v1->sCliente);
                $totalInstalaciones = $v1->total;
                $totalFinalizados = 0;
            }

            $response[] = [
                'cliente' => $cliente,
                'totalInstalaciones' => $totalInstalaciones,
                'totalFinalizados' => $totalFinalizados
            ];


            // $response[]['cliente'] =$cliente;
            // $response[]['totalInstalaciones'] =  $totalInstalaciones;
            // $response[]['totalFinalizados'] = $totalFinalizados;;


        }

        return $response;
    }


    function nombreRegiom($numeroRegion)
    {
        $nombre = "";

        if ($numeroRegion == 1) {
            $nombre = "R.Tarapacá";
        } else if ($numeroRegion == 2) {
            $nombre = "R.Antofagasta";
        } else if ($numeroRegion == 3) {
            $nombre = "R.Atacama";
        } else if ($numeroRegion == 4) {
            $nombre = "R.Coquimbo";
        } else if ($numeroRegion == 5) {
            $nombre = "R.Valparaiso";
        } else if ($numeroRegion == 6) {
            $nombre = "R.O’Higgins";
        } else if ($numeroRegion == 7) {
            $nombre = "R. Maule";
        } else if ($numeroRegion == 8) {
            $nombre = "R.Bio Bio";
        } else if ($numeroRegion == 9) {
            $nombre = "R.La Araucanía";
        } else if ($numeroRegion == 10) {
            $nombre = "R.Los Lagos";
        } else if ($numeroRegion == 11) {
            $nombre = "R.Aysén";
        } else if ($numeroRegion == 12) {
            $nombre = "R.Magallanes";
        } else if ($numeroRegion == 13) {
            $nombre = "R.Metropolitana";
        } else if ($numeroRegion == 14) {
            $nombre = "R.Los Rios";
        } else if ($numeroRegion == 15) {
            $nombre = "R.Arica y Parinacota";
        } else if ($numeroRegion == 16) {
            $nombre = "R.Ñuble";
        } else {
            $nombre = "No Identificado";
        }
        return $nombre;
    }

    function generarNombre($nombre)
    {

        $arrayNombre = explode(" ", $nombre);

        if (count($arrayNombre) == 1) {

            return $nombre;
        } else if (count($arrayNombre) == 2) {
            $nom = $arrayNombre[0];
            return $nom[0] . "." . $arrayNombre[1];
        } else if (count($arrayNombre) == 3) {

            $nom = $arrayNombre[0];
            $nom1 = $arrayNombre[1];
            return $nom[0] . "." . $nom1[0] . "." . $arrayNombre[2];
        } else if (count($arrayNombre) == 4) {

            $nom = $arrayNombre[0];
            $nom1 = $arrayNombre[1];
            $nom2 = $arrayNombre[2];
            // return $arrayNombre[3];
            return $nom[0] . "." . $nom1[0] . "." . $nom2 . "." . $arrayNombre[3];
        } else if (count($arrayNombre) == 5) {

            $nom = $arrayNombre[0];
            $nom1 = $arrayNombre[1];
            $nom2 = $arrayNombre[2];
            $nom3 = $arrayNombre[3];
            // return $arrayNombre[3];
            return $nom[0] . "." . $nom1[0] . "." . $nom2[0] . "." . $nom3[0] . "." . $arrayNombre[4];
        } else if (count($arrayNombre) == 6) {

            $nom = $arrayNombre[0];
            $nom1 = $arrayNombre[1];
            $nom2 = $arrayNombre[2];
            $nom3 = $arrayNombre[3];
            $nom4 = $arrayNombre[4];
            // return $arrayNombre[3];
            return $nom[0] . "." . $nom1[0] . "." . $nom2[0] . "." . $nom3[0] . "." . $nom4[0] . ".";
        } else if (count($arrayNombre) == 7) {

            $nom = $arrayNombre[0];
            $nom1 = $arrayNombre[1];
            $nom2 = $arrayNombre[2];
            $nom3 = $arrayNombre[3];
            $nom4 = $arrayNombre[4];
            $nom5 = $arrayNombre[5];
            // return $arrayNombre[3];
            return $nom[0] . "." . $nom1[0] . "." . $nom2[0] . "." . $nom3[0] . "." . $nom4[0] . "." . $nom5[0] . ".";
        } else if (count($arrayNombre) == 8) {

            $nom = $arrayNombre[0];
            $nom1 = $arrayNombre[1];
            $nom2 = $arrayNombre[2];
            $nom3 = $arrayNombre[3];
            $nom4 = $arrayNombre[4];
            $nom5 = $arrayNombre[5];
            $nom6 = $arrayNombre[6];
            // return $arrayNombre[3];
            return $nom[0] . "." . $nom1[0] . "." . $nom2[0] . "." . $nom3[0] . "." . $nom4[0] . "." . $nom5[0] . "." . $nom6[0] . ".";
        } else {
            return $nombre;
        }

        return "";
    }

    public function grafico_total_retiros_proyectos(request $req)
    {

        $cliente = '';
        $totalRetiros = '';
        $totalFinalizados = '';
        $response = array();

        $pro = "";

        if ($req->proveedor == "" || $req->proveedor  == null) {
            $pro = Auth::user()->nombre_proveedor;
        } else {

            $pro = $req->proveedor;
        }

        $retiros = DB::table('retiros')
            ->select('sCliente', DB::raw('count(*) as total'))
            ->groupBy('sCliente')
            ->where("proveedor_retiro", "=", $pro)
            // ->where("proveedor_instalacion","=","KYOCERA")
            ->orderBy('total', 'desc')
            ->get();



        foreach ($retiros as $v1) {

            // print_r($v1->sCliente);
            // print_r($v1->total);

            $retiros_comepletadas = DB::table('retiros')
                ->select('sCliente', DB::raw('count(*) as total_finalizados'))
                ->groupBy('sCliente')
                //  ->where("proveedor_instalacion","=","KYOCERA")
                ->where("proveedor_retiro", "=", $pro)
                ->where("estado_retiro_Cord", "=", "finalizado")
                ->where("sCliente", "=", $v1->sCliente)
                ->orderBy('total_finalizados', 'desc')
                ->get();


            if (count($retiros_comepletadas) > 0) {

                foreach ($retiros_comepletadas as $v2) {

                    $cliente = $this->generarNombre($v1->sCliente);
                    $totalretiros = $v1->total;
                    $totalFinalizados = $v2->total_finalizados;

                    // print_r($v2->total_finalizados."<br>");

                }
            } else {
                $cliente = $this->generarNombre($v1->sCliente);
                $totalretiros = $v1->total;
                $totalFinalizados = 0;
            }

            $response[] = [
                'cliente' => $cliente,
                'totalretiros' => $totalretiros,
                'totalFinalizados' => $totalFinalizados
            ];


            // $response[]['cliente'] =$cliente;
            // $response[]['totalInstalaciones'] =  $totalInstalaciones;
            // $response[]['totalFinalizados'] = $totalFinalizados;;


        }
        return $response;
    }


    public function buscarProyectosAsociados(request $req)
    {

        $pro = "";

        if ($req->proveedor == "" || $req->proveedor  == null) {
            $pro = Auth::user()->nombre_proveedor;
        } else {
            $pro = $req->proveedor;
        }
        $instalaciones = DB::table('instalacions')
            ->select('sCliente')
            ->where("proveedor_instalacion", "=", $pro)
            ->distinct()
            // ->where("proveedor_instalacion","=","KYOCERA")
            ->get();
        return $instalaciones;
    }
    public function graficosPorProyecto(request $req)
    {

        $pro = "";

        if ($req->proveedor == "" || $req->proveedor  == null) {
            $pro = Auth::user()->nombre_proveedor;
        } else {

            $pro = $req->proveedor;
        }

        $estados_proyectos = DB::table('instalacions')
            ->select('sEstado_instalacion', DB::raw('count(sEstado_instalacion) as cantidad'))
            ->groupBy('sEstado_instalacion')
            ->where("proveedor_instalacion", "=", $pro)
            ->where("sCliente", "=", $req->clienteproyecto)
            // ->where("proveedor_instalacion","=","KYOCERA")
            ->orderBy('cantidad', 'desc')
            ->get();
        return $estados_proyectos;
    }

    public function graficosPorSucursales(request $req)
    {
        // SELECT instalacions.sRegion, count( instalacions.sTipo_sucursal) FROM `instalacions` GROUP by instalacions.sRegion

        $pro = "";

        if ($req->proveedor == "" || $req->proveedor  == null) {
            $pro = Auth::user()->nombre_proveedor;
        } else {

            $pro = $req->proveedor;
        }

        $estados_proyectos = DB::table('instalacions')
            // ->select('sRegion',DB::raw('count(sTipo_sucursal) as cantidad'))    
            ->select('sRegion', DB::raw('count(sTipo_sucursal) as cantidad'))

            ->groupBy('sRegion')
            ->where("proveedor_instalacion", "=", $pro)
            ->where("sCliente", "=", $req->clienteproyecto)
            // ->where("proveedor_instalacion","=","KYOCERA")
            // ->orderBy('cantidad', 'desc')   
            ->orderByRaw(DB::raw("FIELD(instalacions.sRegion,  15,1,2,3,4,5,13,6,7,16,8,9,14,10,11,12) ASC"))

            ->get();
        return $estados_proyectos;
    }

    public function graficosPorAcessorios(request $req)
    {
        // SELECT instalacions.sRegion, count( instalacions.sTipo_sucursal) FROM `instalacions` GROUP by instalacions.sRegion
        $response = array();
        $usb;
        $mueble;
        $pro = "";

        if ($req->proveedor == "" || $req->proveedor  == null) {
            $pro = Auth::user()->nombre_proveedor;
        } else {

            $pro = $req->proveedor;
        }

        $accesorios = DB::table('instalacions')
            // ->select('sRegion',DB::raw('count(sTipo_sucursal) as cantidad'))    
            ->select(
                'instalacions.sCliente',
                DB::raw('count(CASE checklist_instalacions.CUsb_red WHEN checklist_instalacions.CUsb_red > 0 and checklist_instalacions.CUsb_red <> null or checklist_instalacions.CUsb_red = "red" THEN NULL ELSE checklist_instalacions.CUsb_red END) as usb_red'),
                DB::raw('count(CASE checklist_instalacions.CsMueble WHEN checklist_instalacions.CsMueble > 0 and checklist_instalacions.CsMueble <> null  or checklist_instalacions.CUsb_red = "si"  THEN NULL ELSE checklist_instalacions.CsMueble END) as CsMueble'),
                DB::raw('count(CASE checklist_instalacions.CsKit_lector WHEN checklist_instalacions.CsKit_lector > 0 and checklist_instalacions.CsKit_lector <> null  or checklist_instalacions.CUsb_red = "si"  THEN NULL ELSE checklist_instalacions.CsKit_lector END) as CsKit_lector'),
                DB::raw('count(CASE checklist_instalacions.CsBandeja_adicional WHEN checklist_instalacions.CsBandeja_adicional > 0 and checklist_instalacions.CsBandeja_adicional <> null  or checklist_instalacions.CUsb_red = "si"  THEN NULL ELSE checklist_instalacions.CsBandeja_adicional END) as CsBandeja_adicional'),

                DB::raw('count(CASE checklist_instalacions.CsSD WHEN checklist_instalacions.CsSD > 0 and checklist_instalacions.CsSD <> null  or checklist_instalacions.CUsb_red = "si"  THEN NULL ELSE checklist_instalacions.CsSD END) as CsSD')
            )


            ->join("asignacion_instalacions", "asignacion_instalacions.lista_instalacion_id", "=", "instalacions.id")
            ->join("checklist_instalacions", "checklist_instalacions.asignacion_instalacion_retiro_id", "=", "asignacion_instalacions.id")
            ->groupBy('instalacions.sCliente')
            ->where("instalacions.proveedor_instalacion", "=", $pro)
            ->where("instalacions.sCliente", "=", $req->clienteproyecto)
            // ->where("proveedor_instalacion","=","KYOCERA")
            // ->orderBy('cantidad', 'desc')   
            ->get();

        return $accesorios;

        if (count($accesorios) > 0) {

            foreach ($accesorios as $v2) {

                $usb = $v2->usb_red;
                $mueble = $v2->CsMueble;

                // print_r($v2->total_finalizados."<br>");

            }

            $response[] = [
                'usb' => $usb,
                'mueble' => $mueble,

            ];
        }



        return $response;
    }
    public function graficos_tecnicos(request $req){
        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();

        $id_trabajador = $datos_trabajador[0]->id;

        $cliente = '';
        $totalInstalaciones = '';
        $totalFinalizados = '';
        $response = array();

        $instalaciones1 = DB::connection('kyocera')->table('instalacions')
            ->join('asignacion_instalacions', 'asignacion_instalacions.lista_instalacion_id', '=', 'instalacions.id')
            ->select('sCliente', DB::connection('kyocera')->raw('count(*) as total'))
            ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->groupBy('sCliente')
            ->orderBy('total', 'desc')
            ->get();
        $instalaciones2 = DB::connection('upgrade')->table('instalacions')
            ->join('asignacion_instalacions', 'asignacion_instalacions.lista_instalacion_id', '=', 'instalacions.id')
            ->select('sCliente', DB::connection('upgrade')->raw('count(*) as total'))
            ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->groupBy('sCliente')
            ->orderBy('total', 'desc')
            ->get();
        $instalaciones = DB::connection('comtecglobal')->table('instalacions')
            ->join('asignacion_instalacions', 'asignacion_instalacions.lista_instalacion_id', '=', 'instalacions.id')
            ->select('sCliente', DB::connection('comtecglobal')->raw('count(*) as total'))
            ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->groupBy('sCliente')
            ->orderBy('total', 'desc')
            ->get();

        foreach ($instalaciones as $v1) {
            $instalaciones_comepletadas = DB::connection('comtecglobal')->table('instalacions')
                ->join('asignacion_instalacions', 'asignacion_instalacions.lista_instalacion_id', '=', 'instalacions.id')
                ->select('sCliente', DB::connection('comtecglobal')->raw('count(*) as total_finalizados'))
                ->groupBy('sCliente')
                ->where("sEstado_instalacion", "=", "finalizado")
                ->where("sCliente", "=", $v1->sCliente)
                ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
                ->orderBy('total_finalizados', 'desc')
                ->get();

            if (count($instalaciones_comepletadas) > 0) {
                foreach ($instalaciones_comepletadas as $v2) {
                    $cliente = $this->generarNombre($v1->sCliente);
                    $totalInstalaciones = $v1->total;
                    $totalFinalizados = $v2->total_finalizados;
                }
            } else {
                $cliente = $this->generarNombre($v1->sCliente);
                $totalInstalaciones = $v1->total;
                $totalFinalizados = 0;
            }
            $response[] = [
                'cliente' => $cliente,
                'totalInstalaciones' => $totalInstalaciones,
                'totalFinalizados' => $totalFinalizados
            ];
        }
        foreach ($instalaciones1 as $v1) {
            $instalaciones_comepletadas1 = DB::connection('kyocera')->table('instalacions')
                ->join('asignacion_instalacions', 'asignacion_instalacions.lista_instalacion_id', '=', 'instalacions.id')
                ->select('sCliente', DB::connection('kyocera')->raw('count(*) as total_finalizados'))
                ->groupBy('sCliente')
                ->where("sEstado_instalacion", "=", "finalizado")
                ->where("sCliente", "=", $v1->sCliente)
                ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
                ->orderBy('total_finalizados', 'desc')
                ->get();

            if (count($instalaciones_comepletadas1) > 0) {
                foreach ($instalaciones_comepletadas1 as $v2) {
                    $cliente = $this->generarNombre($v1->sCliente);
                    $totalInstalaciones = $v1->total;
                    $totalFinalizados = $v2->total_finalizados;
                }
            } else {
                $cliente = $this->generarNombre($v1->sCliente);
                $totalInstalaciones = $v1->total;
                $totalFinalizados = 0;
            }
            $response[] = [
                'cliente' => $cliente,
                'totalInstalaciones' => $totalInstalaciones,
                'totalFinalizados' => $totalFinalizados
            ];
        }
        foreach ($instalaciones2 as $v1) {
            $instalaciones_comepletadas2 = DB::connection('upgrade')->table('instalacions')
                ->join('asignacion_instalacions', 'asignacion_instalacions.lista_instalacion_id', '=', 'instalacions.id')
                ->select('sCliente', DB::connection('upgrade')->raw('count(*) as total_finalizados'))
                ->groupBy('sCliente')
                ->where("sEstado_instalacion", "=", "finalizado")
                ->where("sCliente", "=", $v1->sCliente)
                ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
                ->orderBy('total_finalizados', 'desc')
                ->get();

            if (count($instalaciones_comepletadas2) > 0) {
                foreach ($instalaciones_comepletadas2 as $v2) {
                    $cliente = $this->generarNombre($v1->sCliente);
                    $totalInstalaciones = $v1->total;
                    $totalFinalizados = $v2->total_finalizados;
                }
            } else {
                $cliente = $this->generarNombre($v1->sCliente);
                $totalInstalaciones = $v1->total;
                $totalFinalizados = 0;
            }
            $response[] = [
                'cliente' => $cliente,
                'totalInstalaciones' => $totalInstalaciones,
                'totalFinalizados' => $totalFinalizados
            ];
        }

        return $response;
    }
    public function graficos_cordinadora(request $req){
        $cliente = '';
        $totalInstalaciones = '';
        $totalFinalizados = '';
        $response = array();

        $instalaciones1 = DB::connection('kyocera')->table('instalacions')
            ->select('sCliente', DB::connection('kyocera')->raw('count(*) as total'))
            ->groupBy('sCliente')
            ->orderBy('total', 'desc')
            ->get();
        $instalaciones2 = DB::connection('upgrade')->table('instalacions')
            ->select('sCliente', DB::connection('upgrade')->raw('count(*) as total'))
            ->groupBy('sCliente')
            ->orderBy('total', 'desc')
            ->get();
        $instalaciones = DB::connection('comtecglobal')->table('instalacions')
            ->select('sCliente', DB::connection('comtecglobal')->raw('count(*) as total'))
            ->groupBy('sCliente')
            ->orderBy('total', 'desc')
            ->get();

        foreach ($instalaciones as $v1) {
            $instalaciones_comepletadas = DB::connection('comtecglobal')->table('instalacions')
                ->select('sCliente', DB::connection('comtecglobal')->raw('count(*) as total_finalizados'))
                ->groupBy('sCliente')
                ->where("sEstado_instalacion", "=", "finalizado")
                ->where("sCliente", "=", $v1->sCliente)
                ->orderBy('total_finalizados', 'desc')
                ->get();

            if (count($instalaciones_comepletadas) > 0) {
                foreach ($instalaciones_comepletadas as $v2) {
                    $cliente = $this->generarNombre($v1->sCliente);
                    $totalInstalaciones = $v1->total;
                    $totalFinalizados = $v2->total_finalizados;
                }
            } else {
                $cliente = $this->generarNombre($v1->sCliente);
                $totalInstalaciones = $v1->total;
                $totalFinalizados = 0;
            }
            $response[] = [
                'cliente' => $cliente,
                'totalInstalaciones' => $totalInstalaciones,
                'totalFinalizados' => $totalFinalizados
            ];
        }
        foreach ($instalaciones1 as $v1) {
            $instalaciones_comepletadas1 = DB::connection('kyocera')->table('instalacions')
                ->select('sCliente', DB::connection('kyocera')->raw('count(*) as total_finalizados'))
                ->groupBy('sCliente')
                ->where("sEstado_instalacion", "=", "finalizado")
                ->where("sCliente", "=", $v1->sCliente)
                ->orderBy('total_finalizados', 'desc')
                ->get();

            if (count($instalaciones_comepletadas1) > 0) {
                foreach ($instalaciones_comepletadas1 as $v2) {
                    $cliente = $this->generarNombre($v1->sCliente);
                    $totalInstalaciones = $v1->total;
                    $totalFinalizados = $v2->total_finalizados;
                }
            } else {
                $cliente = $this->generarNombre($v1->sCliente);
                $totalInstalaciones = $v1->total;
                $totalFinalizados = 0;
            }
            $response[] = [
                'cliente' => $cliente,
                'totalInstalaciones' => $totalInstalaciones,
                'totalFinalizados' => $totalFinalizados
            ];
        }
        foreach ($instalaciones2 as $v1) {
            $instalaciones_comepletadas2 = DB::connection('upgrade')->table('instalacions')
                ->select('sCliente', DB::connection('upgrade')->raw('count(*) as total_finalizados'))
                ->groupBy('sCliente')
                ->where("sEstado_instalacion", "=", "finalizado")
                ->where("sCliente", "=", $v1->sCliente)
                ->orderBy('total_finalizados', 'desc')
                ->get();

            if (count($instalaciones_comepletadas2) > 0) {
                foreach ($instalaciones_comepletadas2 as $v2) {
                    $cliente = $this->generarNombre($v1->sCliente);
                    $totalInstalaciones = $v1->total;
                    $totalFinalizados = $v2->total_finalizados;
                }
            } else {
                $cliente = $this->generarNombre($v1->sCliente);
                $totalInstalaciones = $v1->total;
                $totalFinalizados = 0;
            }
            $response[] = [
                'cliente' => $cliente,
                'totalInstalaciones' => $totalInstalaciones,
                'totalFinalizados' => $totalFinalizados
            ];
        }

        return $response;
    }
}
