<?php

namespace App\Http\Controllers\client;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Contracts\Encryption\DecryptException;


use App;
use App\direccion;
use App\persona;
use App\User;
use DB;
use Crypt;

use Carbon\Carbon;

use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

class clientes extends Controller
{
    public function __construct()

    {

        $this->middleware('auth');

    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        $rules = [
            'razon_social' => 'required|max:100',
            'rut' => 'required|max:10|unique:clientes',
            'telefono' => 'required|max:10',
            'correo' => 'required|max:50',
            'region' => 'required|max:50',
            'comuna' => 'required|max:50',
            'calle' => 'required|max:200',
  
        ];

        $this->validate($request, $rules);

        $direccion = new App\direccion;
        $direccion->descripcion_direccion = $request->calle;
        $direccion->id_region= $request->region;
        $direccion->id_comuna = $request->comuna;
        $direccion->timestamps = false;  
        $direccion->save();

        $clientes = new App\clientes;
        $clientes->razon_social = $request->razon_social;
        $clientes->rut = $request->rut;
        $clientes->estado = 1;
        $clientes->proveedor_nombre = strtolower(DB::connection()->getDatabaseName());
        $clientes->telefono = $request->telefono;
        $clientes->correo = $request->correo;
        $clientes->id_direccion = $direccion->id;
        $clientes->timestamps = false;  
        $clientes->save();
        
        return back()->with('mensaje', 'Cliente Agregado');    
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     * 
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {


        if($request->id_direccion_ == "" || $request->calle_=="" || $request->region_ == "" || $request->comuna_ == ""  ||
        $request->razon_social_ == ""  || $request->telefono_ == "" || $request->correo_ == ""){

            return back()->with('mensaje_error', 'Intente Nuevamente');  
        }


         $direccion =  App\direccion::findOrfail($request->id_direccion_);
         $direccion->descripcion_direccion = $request->calle_;
         $direccion->id_region= $request->region_;
         $direccion->id_comuna = $request->comuna_;
         $direccion->timestamps = false;  
         $direccion->save();

        $clientes =  App\clientes::findOrfail($request->id_cliente_);
        $clientes->razon_social = $request->razon_social_;
        // $clientes->rut = $request->rut;
        $clientes->proveedor_nombre = $request->nombre_proveedor;

        $clientes->telefono = $request->telefono_;
        $clientes->correo = $request->correo_;
        $clientes->timestamps = false;  
        $clientes->save();
        
        return back()->with('mensaje', 'Cliente Actualizado');  

        // return $request->id_cliente_;

    }

public function buscar_clientes(Request $request)
{
    $clientes = DB::table('clientes')
    ->join('direccions','direccions.id','=','clientes.id_direccion')
    ->join('regions','regions.id','=','direccions.id_region')
    ->join('comunas','comunas.id','=','direccions.id_comuna')
    ->select('clientes.id as id_cliente','clientes.razon_social','clientes.rut','clientes.telefono','clientes.correo',
    'direccions.descripcion_direccion','direccions.id as id_direccion','regions.des_region','comunas.des_comuna','comunas.id as id_comuna','regions.id as id_region','proveedor_nombre')
    ->where('clientes.estado',"=",1)
    ->where('clientes.id','=',$request->id_cli)
    ->get();

    return $clientes;
}

public function deleting_clien($id_cliente)
{

  
    # code...
    $clientes =  App\clientes::findOrfail($id_cliente);   
    $clientes->estado = 0;
    $clientes->timestamps = false;  
    $clientes->save();

   

    $sucursales =  DB::table('sucursals')
    ->where('id_cliente','=',$id_cliente)  ->get();
  
    foreach ($sucursales as $v1) {

        

        $sucursales =  App\sucursal::findOrfail($v1->id);
        $sucursales->estado = "0"; 
        $sucursales->timestamps = false; 
        $sucursales->save();
     
    } 


  
    return back()->with('mensaje_error', 'Cliente Eliminado'); 
}
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    
}
