<?php

namespace App\Http\Controllers\checklist;

use App;
use Auth;
use Carbon\Carbon;
use DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Contracts\Encryption\DecryptException;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Crypt;

class capacitacionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $datos)
    {
        // $var = str_replace('"'," ",$datos->selecionados);


        if (empty($datos->selecionados)) {
            return back()->with('mensaje', 'Necesita Seleccionar al menos una persona');
        }

        if (count($datos->selecionados) > 0) {
            $personas_contactadas =  implode(",", $datos->selecionados);
        } else {
            $personas_contactadas = "Sin Personas";
        }
        $id_asignacion = $datos->id_asignacion;
        $editarestado_asignacion = App\asignacion_capacitaciones::findOrfail($id_asignacion);
        $editarestado_asignacion->estado_capa = "Finalizado";
        $editarestado_asignacion->personas_capacitadas = $personas_contactadas;
        $editarestado_asignacion->timestamps = false;
        $editarestado_asignacion->save();

        $id_Capa = $editarestado_asignacion->id_capa;

        $fotosCapacitacion = DB::table('fotos_capacitacions')
        ->where('fotos_capacitacions.id_capacitacion','=',$id_Capa)
        ->get();

        $fecha = Carbon::now();

        $fechahoy = Carbon::now();
        $nombre_guardar = $fechahoy . "firmacapa.png";
        $fechahoy = $fechahoy->toDateTimeString();
        $capacitacion = App\capacitacions::findOrfail($editarestado_asignacion->id_capa);
        $capacitacion->cliente = $datos->cliente;
        $capacitacion->proyecto_id = $datos->proyectos;
        $capacitacion->direccion = $datos->direccion;
        $capacitacion->comuna = $datos->comuna;
        $capacitacion->ciudad = $datos->ciudad;
        $capacitacion->sucursals_id  = 1;
        $capacitacion->cantidad_personas = $datos->nupersonas;
        $capacitacion->trabajadors_id  = $datos->idtecnico;
        $capacitacion->datoscontacto  = $datos->scontacto;
        $capacitacion->rut_contacto = $datos->rut_contacto;
        $capacitacion->area_sucursal = $datos->area_sucursal;
        $capacitacion->observacion = $datos->observacion;
        $capacitacion->fecha_capacitacion  = $fecha;
        $capacitacion->cuisucursal  = $datos->dcui;
        $capacitacion->timestamps = false;
        $capacitacion->save();

        //crear Pdf's capacitaciones
        $datoscapa = DB::table('capacitacions')
            ->where('capacitacions.id', '=', $capacitacion->id)
            ->get();

        /**/
        $datos_proyecto = DB::table('proyectos')
            ->where('proyectos.id', '=', $datoscapa[0]->proyecto_id)
            ->get();

        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', $datoscapa[0]->trabajadors_id)
            ->get();

        $id_trabajador = $datos_trabajador[0]->id;
        $id_persona = $datos_trabajador[0]->id_persona;

        $datos_tecnico = DB::table('personas')
            ->where('personas.id', '=', $id_persona)
            ->select(
                'personas.nombre_uno',
                'personas.nombre_dos',
                'personas.apellido_uno',
                'personas.apellido_dos'
            )
            ->get();

        $firmatrabajador = DB::table('firma_clientes')
            ->where('firma_clientes.id_tecnico', '=', $datos_trabajador[0]->id_login)
            ->get();

        $fecha = Carbon::now();
        $fecha = $fecha->format('y-m-d');

        //sacar datos para generar nombre pdf
        $id_para_pdf = $datoscapa[0]->id;

        $buscar_asignacion = App\capacitacions::where('id', '=', $id_para_pdf)->first();

        $capacitadas_personas = $personas_contactadas;
        \PDF::setOptions(['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true])
            ->loadView('check/pdf.pdfcapacitacion_coordinadora', compact('fotosCapacitacion','datoscapa', 'datos_tecnico', 'firmatrabajador', 'datos_proyecto','capacitadas_personas'))
            ->save(storage_path('app/public/pdfCapacitacion/') . $id_para_pdf . 'Capacitaciones.pdf')
            ->stream($datoscapa[0]->direccion . '.pdf');

        $buscar_asignacion->url_pdf = $id_para_pdf . "Capacitaciones.pdf";
        $buscar_asignacion->timestamps = false;
        $buscar_asignacion->save();

        return redirect('historial')->with('mensaje', 'Capacitación Agregada');
    }
    public function save_imagen(Request $request)
    {

        $id_asignacion = $request->idCheck;
        $editarestado_asignacion = App\asignacion_capacitaciones::findOrfail($id_asignacion);

        $id_Capa = $editarestado_asignacion->id_capa;
        $fecha = Carbon::now();
        $fecha = $fecha->toDateTimeString();

        if (!empty($request->file('cargafoto1'))) {
            $file = $request->file('cargafoto1');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            //sacamos la exxtencion por medio de _
            $extencionArray = explode("_", $extencion);
            if ($extencionArray[1] == "jpg" || $extencionArray[1] == "jpeg" || $extencionArray[1] == "png" || $extencionArray[1] == "jfif") {
            } else {
                return [
                    'status' => 400,
                    'msg' => "Solo se permiten imagenes",
                ];
            }

            $nombreGuardar1 = "f1_" . $id_Capa . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("fotos_capacitaciones/fotos/" . strtolower(DB::connection()->getDatabaseName()) . "/" . $nombreGuardar1,  \File::get($file));
            $nombreGuardar1 = "/fotos_capacitaciones/fotos/" . strtolower(DB::connection()->getDatabaseName()) . "/" . $nombreGuardar1;

            $deletedRows = App\fotos_capacitacions::where('url', "/fotos_capacitaciones/fotos/" . strtolower(DB::connection()->getDatabaseName()) . "/f1_" . $id_Capa . '.png')->delete();
            $deletedRows = App\fotos_capacitacions::where('url', "/fotos_capacitaciones/fotos/" . strtolower(DB::connection()->getDatabaseName()) . "/f1_" . $id_Capa . '.jpg')->delete();

            $fotos_capacitacion = new App\fotos_capacitacions();
            $fotos_capacitacion->descripcion_foto  = $nombreGuardar1;
            $fotos_capacitacion->url = $nombreGuardar1;
            $fotos_capacitacion->id_capacitacion = $id_Capa;
            $fotos_capacitacion->timestamps = false;
            $fotos_capacitacion->save();
        }
        //foto2
        if (!empty($request->file('cargafoto2'))) {
            $file = $request->file('cargafoto2');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            $extencionArray = explode("_", $extencion);
            if ($extencionArray[1] == "jpg" || $extencionArray[1] == "jpeg" || $extencionArray[1] == "png" || $extencionArray[1] == "jfif") {
            } else {
                return [
                    'status' => 400,
                    'msg' => "Solo se permiten imagenes",
                ];
            }
            $nombreGuardar1 = "f2_" . $id_Capa . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("fotos_capacitaciones/fotos/" . strtolower(DB::connection()->getDatabaseName()) . "/" . $nombreGuardar1,  \File::get($file));
            $nombreGuardar1 = "/fotos_capacitaciones/fotos/" . strtolower(DB::connection()->getDatabaseName()) . "/" . $nombreGuardar1;

            $deletedRows = App\fotos_capacitacions::where('url', "/fotos_capacitaciones/fotos/" . strtolower(DB::connection()->getDatabaseName()) . "/f2_" . $id_Capa . '.png')->delete();
            $deletedRows = App\fotos_capacitacions::where('url', "/fotos_capacitaciones/fotos/" . strtolower(DB::connection()->getDatabaseName()) . "/f2_" . $id_Capa . '.jpg')->delete();

            $fotos_capacitacion = new App\fotos_capacitacions();
            $fotos_capacitacion->descripcion_foto  = $nombreGuardar1;
            $fotos_capacitacion->url = $nombreGuardar1;
            $fotos_capacitacion->id_capacitacion = $id_Capa;
            $fotos_capacitacion->timestamps = false;
            $fotos_capacitacion->save();
        }
        //foto3
        if (!empty($request->file('cargafoto3'))) {
            $file = $request->file('cargafoto3');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            $extencionArray = explode("_", $extencion);
            if ($extencionArray[1] == "jpg" || $extencionArray[1] == "jpeg" || $extencionArray[1] == "png" || $extencionArray[1] == "jfif") {
            } else {
                return [
                    'status' => 400,
                    'msg' => "Solo se permiten imagenes",
                ];
            }
            $nombreGuardar1 = "f3_" . $id_Capa . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("fotos_capacitaciones/fotos/" . strtolower(DB::connection()->getDatabaseName()) . "/" . $nombreGuardar1,  \File::get($file));
            $nombreGuardar1 = "/fotos_capacitaciones/fotos/" . strtolower(DB::connection()->getDatabaseName()) . "/" . $nombreGuardar1;

            $deletedRows = App\fotos_capacitacions::where('url', "/fotos_capacitaciones/fotos/" . strtolower(DB::connection()->getDatabaseName()) . "/f3_" . $id_Capa . '.png')->delete();
            $deletedRows = App\fotos_capacitacions::where('url', "/fotos_capacitaciones/fotos/" . strtolower(DB::connection()->getDatabaseName()) . "/f3_" . $id_Capa . '.jpg')->delete();

            $fotos_capacitacion = new App\fotos_capacitacions();
            $fotos_capacitacion->descripcion_foto  = $nombreGuardar1;
            $fotos_capacitacion->url = $nombreGuardar1;
            $fotos_capacitacion->id_capacitacion = $id_Capa;
            $fotos_capacitacion->timestamps = false;
            $fotos_capacitacion->save();
        }
        //FOTO 4
        if (!empty($request->file('cargafoto4'))) {
            $file = $request->file('cargafoto4');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            $extencionArray = explode("_", $extencion);
            if ($extencionArray[1] == "jpg" || $extencionArray[1] == "jpeg" || $extencionArray[1] == "png" || $extencionArray[1] == "jfif") {
            } else {
                return [
                    'status' => 400,
                    'msg' => "Solo se permiten imagenes",
                ];
            }
            $nombreGuardar1 = "f4_" . $id_Capa . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("fotos_capacitaciones/fotos/" . strtolower(DB::connection()->getDatabaseName()) . "/" . $nombreGuardar1,  \File::get($file));
            $nombreGuardar1 = "/fotos_capacitaciones/fotos/" . strtolower(DB::connection()->getDatabaseName()) . "/" . $nombreGuardar1;

            $deletedRows = App\fotos_capacitacions::where('url', "/fotos_capacitaciones/fotos/" . strtolower(DB::connection()->getDatabaseName()) . "/f4_" . $id_Capa . '.png')->delete();
            $deletedRows = App\fotos_capacitacions::where('url', "/fotos_capacitaciones/fotos/" . strtolower(DB::connection()->getDatabaseName()) . "/f4_" . $id_Capa . '.jpg')->delete();

            $fotos_capacitacion = new App\fotos_capacitacions();
            $fotos_capacitacion->descripcion_foto  = $nombreGuardar1;
            $fotos_capacitacion->url = $nombreGuardar1;
            $fotos_capacitacion->id_capacitacion = $id_Capa;
            $fotos_capacitacion->timestamps = false;
            $fotos_capacitacion->save();
        }
        //FOTO 5
        if (!empty($request->file('cargafoto5'))) {
            $file = $request->file('cargafoto5');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            $extencionArray = explode("_", $extencion);
            if ($extencionArray[1] == "jpg" || $extencionArray[1] == "jpeg" || $extencionArray[1] == "png" || $extencionArray[1] == "jfif") {
            } else {
                return [
                    'status' => 400,
                    'msg' => "Solo se permiten imagenes",
                ];
            }
            $nombreGuardar1 = "f5_" . $id_Capa . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("fotos_capacitaciones/fotos/" . strtolower(DB::connection()->getDatabaseName()) . "/" . $nombreGuardar1,  \File::get($file));
            $nombreGuardar1 = "/fotos_capacitaciones/fotos/" . strtolower(DB::connection()->getDatabaseName()) . "/" . $nombreGuardar1;

            $deletedRows = App\fotos_capacitacions::where('url', "/fotos_capacitaciones/fotos/" . strtolower(DB::connection()->getDatabaseName()) . "/f5_" . $id_Capa . '.png')->delete();
            $deletedRows = App\fotos_capacitacions::where('url', "/fotos_capacitaciones/fotos/" . strtolower(DB::connection()->getDatabaseName()) . "/f5_" . $id_Capa . '.jpg')->delete();

            $fotos_capacitacion = new App\fotos_capacitacions();
            $fotos_capacitacion->descripcion_foto  = $nombreGuardar1;
            $fotos_capacitacion->url = $nombreGuardar1;
            $fotos_capacitacion->id_capacitacion = $id_Capa;
            $fotos_capacitacion->timestamps = false;
            $fotos_capacitacion->save();
        }
        //FOTO 6
        if (!empty($request->file('cargafoto6'))) {
            $file = $request->file('cargafoto6');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            $extencionArray = explode("_", $extencion);
            if ($extencionArray[1] == "pdf") {
                return [
                    'status' => 400,
                    'msg' => "No se permiten Pdf's",
                ];
            }
            $nombreGuardar1 = "f6_" . $id_Capa . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("fotos_capacitaciones/fotos/" . strtolower(DB::connection()->getDatabaseName()) . "/" . $nombreGuardar1,  \File::get($file));
            $nombreGuardar1 = "/fotos_capacitaciones/fotos/" . strtolower(DB::connection()->getDatabaseName()) . "/" . $nombreGuardar1;

            $deletedRows = App\fotos_capacitacions::where('url', "/fotos_capacitaciones/fotos/" . strtolower(DB::connection()->getDatabaseName()) . "/f6_" . $id_Capa . '.png')->delete();
            $deletedRows = App\fotos_capacitacions::where('url', "/fotos_capacitaciones/fotos/" . strtolower(DB::connection()->getDatabaseName()) . "/f6_" . $id_Capa . '.jpg')->delete();

            $fotos_capacitacion = new App\fotos_capacitacions();
            $fotos_capacitacion->descripcion_foto  = $nombreGuardar1;
            $fotos_capacitacion->url = $nombreGuardar1;
            $fotos_capacitacion->id_capacitacion = $id_Capa;
            $fotos_capacitacion->timestamps = false;
            $fotos_capacitacion->save();
        }
        //FOTO 7
        if (!empty($request->file('cargafoto7'))) {
            $file = $request->file('cargafoto7');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            $extencionArray = explode("_", $extencion);
            if ($extencionArray[1] == "pdf") {
                return [
                    'status' => 400,
                    'msg' => "No se permiten Pdf's",
                ];
            }
            $nombreGuardar1 = "f7_" . $id_Capa . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("fotos_capacitaciones/fotos/" . strtolower(DB::connection()->getDatabaseName()) . "/" . $nombreGuardar1,  \File::get($file));
            $nombreGuardar1 = "/fotos_capacitaciones/fotos/" . strtolower(DB::connection()->getDatabaseName()) . "/" . $nombreGuardar1;

            $deletedRows = App\fotos_capacitacions::where('url', "/fotos_capacitaciones/fotos/" . strtolower(DB::connection()->getDatabaseName()) . "/f7_" . $id_Capa . '.png')->delete();
            $deletedRows = App\fotos_capacitacions::where('url', "/fotos_capacitaciones/fotos/" . strtolower(DB::connection()->getDatabaseName()) . "/f7_" . $id_Capa . '.jpg')->delete();

            $fotos_capacitacion = new App\fotos_capacitacions();
            $fotos_capacitacion->descripcion_foto  = $nombreGuardar1;
            $fotos_capacitacion->url = $nombreGuardar1;
            $fotos_capacitacion->id_capacitacion = $id_Capa;
            $fotos_capacitacion->timestamps = false;
            $fotos_capacitacion->save();
        }
        //FOTO 8
        if (!empty($request->file('cargafoto8'))) {
            $file = $request->file('cargafoto8');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            $extencionArray = explode("_", $extencion);
            if ($extencionArray[1] == "pdf") {
                return [
                    'status' => 400,
                    'msg' => "No se permiten Pdf's",
                ];
            }
            $nombreGuardar1 = "f8_" . $id_Capa . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("fotos_capacitaciones/fotos/" . strtolower(DB::connection()->getDatabaseName()) . "/" . $nombreGuardar1,  \File::get($file));
            $nombreGuardar1 = "/fotos_capacitaciones/fotos/" . strtolower(DB::connection()->getDatabaseName()) . "/" . $nombreGuardar1;

            $deletedRows = App\fotos_capacitacions::where('url', "/fotos_capacitaciones/fotos/" . strtolower(DB::connection()->getDatabaseName()) . "/f8_" . $id_Capa . '.png')->delete();
            $deletedRows = App\fotos_capacitacions::where('url', "/fotos_capacitaciones/fotos/" . strtolower(DB::connection()->getDatabaseName()) . "/f8_" . $id_Capa . '.jpg')->delete();

            $fotos_capacitacion = new App\fotos_capacitacions();
            $fotos_capacitacion->descripcion_foto  = $nombreGuardar1;
            $fotos_capacitacion->url = $nombreGuardar1;
            $fotos_capacitacion->id_capacitacion = $id_Capa;
            $fotos_capacitacion->timestamps = false;
            $fotos_capacitacion->save();
        }

        return [
            'status' => 200,
        ];
    }
    public function create_old(Request $datos)
    {
        $fecha = Carbon::now();
        $fecha = $fecha->toDateTimeString();
        $file = $datos->file('cargafoto1');
        //obtenemos el nombre del archivo
        $nombre =  time() . "_" . $file->getClientOriginalName();
        $extencion =  time() . "_" . $file->getClientOriginalExtension();
        //sacamos la exxtencion por medio de _
        $extencionArray = explode("_", $extencion);

        $nombreGuardar1 = $fecha . "-capacitacion_" . $datos->cliente . "." . $extencionArray[1];
        //indicamos que queremos guardar un nuevo archivo en el disco local
        \Storage::disk('fotos_sistema_check')->put("/fotos_capacitaciones/fotos/" . $nombreGuardar1,  \File::get($file));



        $capacitacion = new App\capacitacions();
        $capacitacion->cliente = $datos->cliente;
        $capacitacion->proyecto_id = $datos->proyectos;
        $capacitacion->direccion = $datos->direccion;
        $capacitacion->comuna = $datos->comuna;
        $capacitacion->ciudad = $datos->ciudad;
        $capacitacion->foto_capacitacion = "/fotos_capacitaciones/fotos/" . $nombreGuardar1;
        //estamos pasando 1, sucursal de api
        $capacitacion->sucursals_id  = 1;
        $capacitacion->cantidad_personas = $datos->nupersonas;
        $capacitacion->trabajadors_id  = $datos->idtecnico;
        $fechahoy = Carbon::now();
        $fechahoy = $fechahoy->toDateTimeString();
        $capacitacion->datoscontacto  = $datos->scontacto;
        $capacitacion->fecha_capacitacion  = $fecha;
        $capacitacion->cuisucursal  = $datos->dcui;
        $nombre_guardar = $fechahoy . "firmacapa.png";

        // echo '<img src="'.$request->imagen_firma.'" border="1">';

        // funcion para gusrfdar la imagen base64 en el servidor
        // el nombre debe tener la extension
        function uploadImgBase64($base64, $name)
        {


            $datosBase64 = base64_decode(preg_replace('#^data:image/\w+;base64,#i', '', $base64));

            //optimixar para poder subir imagenes
            $path = $_SERVER['DOCUMENT_ROOT'] . '/aya/rendicion/fotos/fotos_capacitaciones/' . $name;




            // guardamos la imagen en el server
            if (!file_put_contents($path, $datosBase64)) {
                // retorno si falla
                return "0";
            } else {
                // retorno si todo fue bien
                return "1";
            }
        }

        // llamamos a la funcion uploadImgBase64( img_base64, nombre_fina.png)
        $resultado = uploadImgBase64($datos->imagen_firma, $nombre_guardar);
        if ($resultado == "0") {
            return "Intente nuevamente";
        } else {
            $capacitacion->firma = "fotos_capacitaciones/" . $nombre_guardar;
        }


        /*$nombre_guardarfoto2 = $fechahoy."-firmacapa-".$id_trabajador.".png";
        $resultado2 = uploadImgBase64($datos->cargafoto1, $nombre_guardarfoto2 );
        if($resultado2 == "0"){
                                       return "Intente nuevamente";
              }else{
                  $capacitacion->foto_capacitacion = "fotos_capacitaciones/".$nombre_guardarfoto2;
              }*/

        $capacitacion->timestamps = false;
        $capacitacion->save();


        //crear Pdf's capacitaciones
        $datoscapa = DB::table('capacitacions')
            ->where('capacitacions.id', '=', $capacitacion->id)
            ->get();

        /**/
        $datos_proyecto = DB::table('proyectos')
            ->where('proyectos.id', '=', $datoscapa[0]->proyecto_id)
            ->get();

        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', $datoscapa[0]->trabajadors_id)
            ->get();


        $id_trabajador = $datos_trabajador[0]->id;
        $id_persona = $datos_trabajador[0]->id_persona;

        $datos_tecnico = DB::table('personas')
            ->where('personas.id', '=', $id_persona)

            ->select(
                'personas.nombre_uno',
                'personas.nombre_dos',
                'personas.apellido_uno',
                'personas.apellido_dos'
            )

            ->get();

        $firmatrabajador = DB::table('firma_clientes')
            ->where('firma_clientes.id_tecnico', '=', $datos_trabajador[0]->id_login)
            ->get();
        //return $datoscapa;

        $fecha = Carbon::now();
        $fecha = $fecha->format('y-m-d');


        //sacar datos para generar nombre pdf
        $id_para_pdf = $datoscapa[0]->id;

        $buscar_asignacion = App\capacitacions::where('id', '=', $id_para_pdf)->first();

        \PDF::setOptions(['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true])
            ->loadView('check/pdf.pdfcapacitacion_coordinadora', compact('datoscapa', 'datos_tecnico', 'firmatrabajador', 'datos_proyecto'))
            ->save(storage_path('app/public/pdfCapacitacion/') . $id_para_pdf . 'Capacitaciones.pdf')
            ->stream();

        $buscar_asignacion->url_pdf = $id_para_pdf . "Capacitaciones.pdf";
        $buscar_asignacion->timestamps = false;
        $buscar_asignacion->save();


        return back()->with('mensaje', 'capacitación agregada');
    }
    public function verdetalle()
    {

        try {
            $idcapa = Crypt::decryptString($_GET['check']);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }

        $datoscapa = DB::table('capacitacions')
            ->where('capacitacions.id', '=', $idcapa)
            ->get();

        /**/
        $datos_proyecto = DB::table('proyectos')
            ->where('proyectos.id', '=', $datoscapa[0]->proyecto_id)
            ->get();

        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', $datoscapa[0]->trabajadors_id)
            ->get();


        $id_trabajador = $datos_trabajador[0]->id;
        $id_persona = $datos_trabajador[0]->id_persona;

        $datos_tecnico = DB::table('personas')
            ->where('personas.id', '=', $id_persona)

            ->select(
                'personas.nombre_uno',
                'personas.nombre_dos',
                'personas.apellido_uno',
                'personas.apellido_dos'
            )

            ->get();

        $firmatrabajador = DB::table('firma_clientes')
            ->where('firma_clientes.id_tecnico', '=', $datos_trabajador[0]->id_login)
            ->get();
        //return $datoscapa;

        return view('capacitacion.verdetalle', compact('datoscapa', 'datos_tecnico', 'firmatrabajador', 'datos_proyecto'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function ir_capacitacion()
    {
        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();

        $id_trabajador = $datos_trabajador[0]->id;
        $id_persona = $datos_trabajador[0]->id_persona;

        $firma_datos = DB::table('firma_clientes')
            ->where('firma_clientes.id_tecnico', '=', Auth::user()->id)
            ->get();

        $datos_tecnico = DB::table('personas')
            ->where('personas.id', '=', $id_persona)
            ->select(
                'personas.nombre_uno',
                'personas.nombre_dos',
                'personas.apellido_uno',
                'personas.apellido_dos'
            )
            ->get();

        $proyectos = DB::table('proyectos')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->where('proyectos.estado', '=', '1')
            ->where('proyectos.id', '!=', '1')
            ->select('proyectos.nombre', 'clientes.razon_social', 'proyectos.id as id_proyecto')
            ->get();

        $datos_asignacion = DB::table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            //->orderBy('asignacion_instalacions.id', 'desc')
            ->select(
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscliente',
                'asignacion_instalacions.estado_asignacion',
                'asignacion_instalacions.fecha_asignado as fecha_as',
                'asignacion_instalacions.id',
                'asignacion_instalacions.tipo', //retiro o intalaccion
                'asignacion_instalacions.fecha_instalacion as fecha_visita'
            ) //fecha_instalacion
            ->orderBy('fecha_visita', 'desc')
            ->get();

        return view('check.capacitacion', compact('datos_trabajador', 'datos_tecnico', 'datos_asignacion', 'firma_datos', 'proyectos'));
    }

    public function auto_complete_cui(Request $datos)
    {
        $scui = $datos->scui;

        $cambioestado = DB::table('instalacions')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->where('instalacions.sCui', '=', $scui)
            ->select(
                'proyectos.id as id_proyecto',
                'instalacions.sCliente',
                'instalacions.tracker_idtracker',
                'instalacions.sDireccion',
                'instalacions.sComuna',
                'instalacions.sCiudad'
            )
            ->get();

        return $cambioestado;
    }

    public function fetch_nombrecontacto(request $request)
    {

        if ($request->get('query')) {

            $query = $request->get('query');
            $valores = explode(" ", $query);

            if (count($valores) > 1) {
                $nombre1 = $valores[0];
                $apelldo1 = $valores[1];
                $data = DB::table('nombres_usuarios')
                    ->where('nombres_usuarios.nombre', 'LIKE', "%{$query}%")
                    ->select('nombres_usuarios.nombre')
                    ->get();
            } elseif (count($valores) == 1) {
                $data = DB::table('nombres_usuarios')
                    ->where('nombres_usuarios.nombre', 'LIKE', "%{$query}%")
                    ->select('nombres_usuarios.nombre')
                    ->get();
            }

            $output = '<ul  class="alert alert-success" style="display:block; list-style:none">';
            //  foreach($data as $row)
            //  {
            //   $output .= '
            //   <li class="mayuscula" data-rut="'.$row->nombre.'" style="list-style:none;cursor: pointer;">'.'<a class="add_id" data-rut="'."'".$row->nombre."'".'">'.$row->nombre.'</a></li><hr>';
            //   //<li class="mayuscula " style="list-style:none;cursor: pointer;">'.'<a class="add_id" data-rut onclick="agregar_id('."'".$row->rut."'".')">'.$row->razon_social.'</a></li><hr>';

            //  }
            //  $output .= '</ul>';

            foreach ($data as $row) {
                $output .= '
         <li class="mayuscula" data-rut="' . $row->nombre . '" style="list-style:none;cursor: pointer;">' . '<a onclick="cambio(' . "'" . $row->nombre . "'" . ')"  class="add_id" data-nombre="' . $row->nombre . '">' . $row->nombre . '</a></li><hr>';
                //<li class="mayuscula " style="list-style:none;cursor: pointer;">'.'<a class="add_id" data-rut onclick="agregar_id('."'".$row->rut."'".')">'.$row->razon_social.'</a></li><hr>';
            }
            $output .= '</ul>';

            echo $output;
        } else {
        }
    }

    public function asginarCapacitacion(Request $datos)
    {
        $direccion = $datos->scui;
        $idtrabajador = $datos->id_trabajador;
        $fecha_asignacion =  $datos->fecha;

        if ($idtrabajador != null && $fecha_asignacion != null) {
            $cambioestado = DB::table('instalacions')
                ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
                ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
                ->where('instalacions.sDireccion', '=', $direccion)
                ->select(
                    'proyectos.id as id_proyecto',
                    'instalacions.tracker_idtracker',
                    'instalacions.sCui',
                    'instalacions.sCliente',
                    'instalacions.sComuna',
                    'instalacions.sDireccion',
                    'instalacions.proveedor_instalacion'
                )
                ->get();
                              
            $sCui = ($cambioestado[0]->sCui); 
            $sCliente = ($cambioestado[0]->sCliente);               
            $sComuna = ($cambioestado[0]->sComuna);
            $sDireccion = ($cambioestado[0]->sDireccion);
            $proveedor = ($cambioestado[0]->proveedor_instalacion);
            $proyecto = ($cambioestado[0]->id_proyecto);
            $capacitacion = new App\capacitacions();
            $capacitacion->cliente = $sCliente;
            $capacitacion->sucursals_id = "1";
            $capacitacion->direccion  = $sDireccion;
            $capacitacion->comuna  = $sComuna;
            $capacitacion->ciudad  = "no actualizada";
            $capacitacion->datoscontacto  = "no actualizada";
            $capacitacion->timestamps = false;
            $capacitacion->proyecto_id = $proyecto;
            $capacitacion->cuisucursal  = $sCui;
            $capacitacion->trabajadors_id = $idtrabajador;
            $capacitacion->nombre_proveedor  = $proveedor;
            $capacitacion->save();
        
            //creamos la asignacion
            $nueva_asignacion = new App\asignacion_capacitaciones();
            $nueva_asignacion->id_trabajador = $idtrabajador;
            $nueva_asignacion->fecha_capacitacion = $fecha_asignacion;
            $nueva_asignacion->cui = $sCui;
            $nueva_asignacion->cliente = $sCliente;
            $nueva_asignacion->comuna = $sComuna;
            $nueva_asignacion->direccion = $sDireccion;
            $nueva_asignacion->estado_capa = "Asignado";
            $nueva_asignacion->id_capa = $capacitacion->id;
            $nueva_asignacion->timestamps = false;
            $nueva_asignacion->save();
            echo '<div class="alert alert-success" role="alert">Capacitación asignada!</div>';
        } else {
            echo '<div class="alert alert-warning"><strong>Oh no!</strong> no se pudo asignar capacitación!</div>';
        }
    }

    public function completarAsignacion(request $request)
    {  
        //id de asignacion de capacitaciones
        $idcapa = Crypt::decryptString($request->idasig);

        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();

        $id_trabajador = $datos_trabajador[0]->id;
        $id_persona = $datos_trabajador[0]->id_persona;

        $firma_datos = DB::table('firma_clientes')
            ->where('firma_clientes.id_tecnico', '=', Auth::user()->id)
            ->get();

        $datos_tecnico = DB::table('personas')
            ->where('personas.id', '=', $id_persona)
            ->select(
                'personas.nombre_uno',
                'personas.nombre_dos',
                'personas.apellido_uno',
                'personas.apellido_dos'
            )
            ->get();
        $proyectos = DB::table('proyectos')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->where('proyectos.estado', '=', '1')
            ->where('proyectos.id', '!=', '1')
            ->select('proyectos.nombre', 'clientes.razon_social', 'proyectos.id as id_proyecto')
            ->get();

        $datos_asignacion = DB::table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            //->orderBy('asignacion_instalacions.id', 'desc')
            ->select(
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscliente',
                'asignacion_instalacions.estado_asignacion',
                'asignacion_instalacions.fecha_asignado as fecha_as',
                'asignacion_instalacions.id',
                'asignacion_instalacions.tipo', //retiro o intalaccion
                'asignacion_instalacions.fecha_instalacion as fecha_visita'
            ) //fecha_instalacion
            ->orderBy('fecha_visita', 'desc')
            ->get();
        $capas = DB::table('asignacion_capacitaciones')
            ->where('asignacion_capacitaciones.id', '=', $idcapa)
            ->get();

        $nombres_usuarios = DB::table('nombres_usuarios')
            ->get();

        //$sCui = $capas[0]->cui;
        $sDireccion = $capas[0]->direccion;
        $cambioestado = DB::table('instalacions')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->where('instalacions.sDireccion', '=', $sDireccion)
            ->select(
                'proyectos.id as id_proyecto',
                'instalacions.id as id_instalacion',
                'instalacions.sCui',
                'instalacions.sCliente',
                'instalacions.tracker_idtracker',
                'instalacions.sDireccion',
                'instalacions.sComuna',
                'instalacions.sCiudad'
            )
            ->get();

        $id_instalacion = $cambioestado[0]->id_instalacion;

        $proyecto_asociado = DB::table('instalacions')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->select('proyectos.id', 'proyectos.nombre', 'clientes.razon_social')
            ->where('instalacions.id', '=', $id_instalacion)
            ->get();

        return view('check.capacitacion', compact('nombres_usuarios', 'datos_trabajador', 'datos_tecnico', 'datos_asignacion', 'firma_datos', 'proyectos', 'cambioestado', 'proyecto_asociado', 'capas'));
    }
    public function firma_capacitacion($id)
    {

        try {
            $id_asig = Crypt::decryptString($id);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }

        return view('check.firma_capacitacion', compact('id_asig'));
    }
    public function save_FirmaCapacitacion(request $request)
    {
        try {
            $id_asig = Crypt::decryptString($request->id_asig);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }
        //ID CAPACITACION
        $editarestado_asignacion = App\asignacion_capacitaciones::findOrfail($id_asig);
        $id_Capa = $editarestado_asignacion->id_capa;


        function uploadImgBase($base64, $name)
        {
            $datosBase64 = base64_decode(preg_replace('#^data:image/\w+;base64,#i', '', $base64));
            //optimixar para poder subir imagenes
            $path = $_SERVER['DOCUMENT_ROOT'] . '/aya/rendicion/fotos/fotos_capacitaciones/firmas/' . strtolower(DB::connection()->getDatabaseName()) . "/" . $name;
            // guardamos la imagen en el server
            if (!file_put_contents($path, $datosBase64)) {
                // retorno si falla
                return "0";
            } else {
                // retorno si todo fue bien
                return "1";
            }
        }
        $nombre_guardar =  $id_Capa . "_firmacapa.png";
        $resultado = uploadImgBase($request->imagen_firma, $nombre_guardar);
        if ($resultado == "0") {
            return "Intente nuevamente";
        } else {
            $capacitacion = App\capacitacions::findOrfail($id_Capa);
            $capacitacion->firma = "fotos_capacitaciones/firmas/" . strtolower(DB::connection()->getDatabaseName()) . "/" . $nombre_guardar;
            $capacitacion->timestamps = false;
            $capacitacion->save();

            return "Firma guardada exitosamente";
        }
    }
    public function capa_asociados(request $request){
        try {
            $direccion = Crypt::decryptString($request->direccion);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }

        $datos_asignacion = DB::table('asignacion_capacitaciones')
        ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_capacitaciones.id_trabajador')
        ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
        ->where('asignacion_capacitaciones.direccion', '=', $direccion)
        ->select('asignacion_capacitaciones.id', 'personas.nombre_uno', 'personas.apellido_uno', 'asignacion_capacitaciones.estado_capa', 'asignacion_capacitaciones.fecha_capacitacion')
        ->orderBy('asignacion_capacitaciones.id', 'desc')
        ->get();

        $tbody = "";
        if (count($datos_asignacion) > 0) {
            foreach ($datos_asignacion as $row) {
                $tbody .= "<tr>";
                $tbody .= "<td>" . $direccion . "</td>";
                $tbody .= "<td>" . date('d-m-Y', strtotime($row->fecha_capacitacion)) . "</td>";
                $tbody .= "<td> " . $row->nombre_uno . " " . $row->apellido_uno . "</td>";
                if ($row->estado_capa == "pendiente" || $row->estado_capa == "Pendiente") {
                    $tbody .= '<td class="pendiente">' . $row->estado_capa . "</td>";
                } else if ($row->estado_capa == "cancelado" || $row->estado_capa == "Cancelado") {
                    $tbody .= '<td class="cancelado">' . $row->estado_capa . "</td>";
                } else if ($row->estado_capa == "reasignar" || $row->estado_capa == "Reasignar") {
                    $tbody .= '<td class="cancelado">' . "Reasignar" . "</td>";
                } else if ($row->estado_capa == "finalizado" || $row->estado_capa == "Finalizado") {
                    $tbody .= '<td class="finalizado">' . $row->estado_capa . "</td>";
                } else if ($row->estado_capa == "asignado" || $row->estado_capa == "Asignado") {
                    $tbody .= '<td class="asignado">' . $row->estado_capa . "</td>";
                } else if ($row->estado_capa == "revisar" || $row->estado_capa == "revisar") {
                    $tbody .= '<td class="revisado">' . "Revisar" . "</td>";
                } else if ($row->estado_capa == "rechazado" || $row->estado_capa == "Rechazado") {
                    $tbody .= '<td class="rechazado">' . $row->estado_capa . "</td>";
                } else if ($row->estado_capa == "tarea_asignada" || $row->estado_capa == "Tarea_asignada") {
                    $tbody .= '<td class="pendiente">' . "Tarea Asignada" . "</td>";
                }
                $tbody .= "<td class='td-val'>";
                if($row->estado_capa == "Finalizado"){
                    $tbody .= "<a class='btn-icon btn-icon-dd' href='".route('generar.pdfCordinadoraCapacitacion',Crypt::encryptString($row->id)) ."' title='Visualizar PDF'><span class='material-icons'>picture_as_pdf</span></a>";
                }else{
                    $tbody .= "<a class='btn-icon disabled' title='Sin PDF'><span class='material-icons'>picture_as_pdf</span></a>";
                }
                $tbody .= "</td>";
                $tbody .= "</tr>";
            }
        } else {
            $tbody .= "<tr>";
            $tbody .= "<td>Sin Datos</td>";
            $tbody .= "</tr>";
        }
        return $tbody;
    }
}
