<?php

namespace App\Http\Controllers\checklist;
use App;
use Auth;
use Carbon\Carbon;
use DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Contracts\Encryption\DecryptException;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
    use Crypt;

class ResumenRetirosController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $datos)
    {


      
        $datosClientes = DB::table('proyectos')
        ->join('clientes','clientes.id','=','proyectos.clientes_id')
        ->where('proyectos.id', '=', $datos->proyectos) 
        ->select('clientes.proveedor_nombre')
        ->get();
        $proveedor = $datosClientes[0]->proveedor_nombre;


       

        $resumen_retiros_ = App\resumen_retiros::where('cuisucursal', '=', $datos->dcui)->first();


        $fecha = Carbon::now();
        $fecha = $fecha->format('y-m-d');

      

    

        if (empty($resumen_retiros_->id)) {

            $file = $datos->file('cargafoto1');

        if($file == ""){
             return back()->with('mensaje', 'Necesita registrar una foto');    

        }
    

         

            //obtenemos el nombre del archivo
            $nombre =  time()."_".$file->getClientOriginalName();
            $extencion =  time()."_".$file->getClientOriginalExtension();
            //sacamos la exxtencion por medio de _
            $extencionArray = explode("_", $extencion);
  
            $nombreGuardar1 = "resumenretiro_work.".$datos->dcui.$extencionArray[1];
            //no existe
                       \Storage::disk('fotos_sistema_check')->put("fotos_resumenretiro/".$nombreGuardar1,  \File::get($file));
                       $resumen_retiros = new App\resumen_retiros();

        }else{
            //si existe
           
            $resumen_retiros =  App\resumen_retiros::findOrfail($resumen_retiros_->id);

        }

        $datos_trabajador = DB::table('trabajadors')
        ->where('trabajadors.id_login','=',Auth::user()->id)
        ->get();

        $id_trabajador = $datos_trabajador[0]->id;

        //$resumen_retiros = new App\resumen_retiros();
        $resumen_retiros->cliente = $datos->cliente;
        $resumen_retiros->proyectos_id = $datos->proyectos;
        $resumen_retiros->trabajadors_id  = $id_trabajador;
        $resumen_retiros->direccion = $datos->direccion;
        $resumen_retiros->comuna = $datos->comuna;
        $resumen_retiros->ciudad = $datos->ciudad;
        $resumen_retiros->cuisucursal  = $datos->dcui;
        //estamos pasando 1, sucursal de api
        $resumen_retiros->sucursals_id  = 1;

        if (empty($resumen_retiros_->id)) {
        $resumen_retiros->imagen = "fotos_resumenretiro/".$nombreGuardar1; //mantenemos el nombre ya que es el mismo de  la app
        }

        $resumen_retiros->suma_embalados  = $datos->cantidadembalado;
        $resumen_retiros->suma_sinembalar  = $datos->cantidadsinembalar;
        $resumen_retiros->descripcion_motivo  = $datos->obsercaviones;
        $resumen_retiros->cantidad_bultos  = $datos->cantidadbultos;
        $resumen_retiros->fecha_resumen      =$fecha;
        $resumen_retiros->nombre_proveedor      =$proveedor ;
        $resumen_retiros->timestamps = false;
        
        $resumen_retiros->save();

//este estaba arriba antes

        // $fecha = Carbon::now();
        // $fecha = $fecha->format('y-m-d');

        // $file = $datos->file('cargafoto1');
        //   //obtenemos el nombre del archivo
        //   $nombre =  time()."_".$file->getClientOriginalName();
        //   $extencion =  time()."_".$file->getClientOriginalExtension();
        //   //sacamos la exxtencion por medio de _
        //   $extencionArray = explode("_", $extencion);

        //   $nombreGuardar1 = "resumenretiro_work.".$datos->dcui.$extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            // \Storage::disk('fotos_sistema_check')->put("fotos_resumenretiro/".$nombreGuardar1,  \File::get($file));





        //generar pdf' de resumen de retiro de forma automatica

        $datoscapa = DB::table('resumen_retiros')
        ->where('resumen_retiros.id','=',$resumen_retiros->id)
        ->get();
        //nuevo
        $cuisucursal = $datoscapa[0]->cuisucursal;
        /**/
        $datos_proyecto = DB::table('proyectos')
             ->where('proyectos.id', '=', $datoscapa[0]->proyectos_id)
             ->get();

        $datos_trabajador = DB::table('trabajadors')
        ->where('trabajadors.id_login','=',Auth::user()->id)
        ->get();

        $id_trabajador = $datos_trabajador[0]->id;
        $id_persona = $datos_trabajador[0]->id_persona;

        $datos_tecnico = DB::table('personas')
        ->where('personas.id','=',$id_persona)

        ->select(
        'personas.nombre_uno',
        'personas.nombre_dos',
            'personas.apellido_uno',
            'personas.apellido_dos')

        ->get();

        $fecha = $datoscapa[0]->fecha_resumen;



        $datos_checklist = DB::table('asignacion_retiros')
        ->join('checklist_retiros','checklist_retiros.asignacion_retiros_id','=','asignacion_retiros.id')
        -> select (
            'checklist_retiros.id',
            'checklist_retiros.csSerie',
            'checklist_retiros.csModelo',
            'checklist_retiros.cnContador_color',
            'checklist_retiros.cnContador',
            'asignacion_retiros.fecha_termino'
        )
        ->where ('asignacion_retiros.estado_asignacion','=','finalizado')
        //->whereDate ('asignacion_retiros.fecha_termino','=',$fecha)
        ->where ('checklist_retiros.csCui','=',$cuisucursal)
        ->get();

             //sacar datos para generar nombre pdf
             $id_para_pdf = $datoscapa[0]->id;

             $buscar_asignacion = App\resumen_retiros::where('id', '=', $id_para_pdf)->first();

        \PDF::setOptions(['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true])
        ->loadView('check/pdf.pdfhistorialRetiro_coordinadora',compact ('datos_tecnico','datoscapa','datos_proyecto','datos_checklist'))
        ->save(storage_path('app/public/pdfResumenRetiro/') . $id_para_pdf.'ResumenRetiro.pdf')
        ->stream();

        $buscar_asignacion->url_pdf = $id_para_pdf."ResumenRetiro.pdf";
                        $buscar_asignacion->timestamps = false;
                        $buscar_asignacion->save();
                        return redirect('historial_retiro')->with('mensaje', 'Resumen de Retiro Asignado');  

        return back()->with('mensaje', 'resumen agregado');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function verdatosresumenretiro(){

        try {
            $idcapa = $_GET['check'];

        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }




        $datoscapa = DB::table('resumen_retiros')
        ->where('resumen_retiros.id','=',$idcapa)
        ->get();


        /**/
        $datos_proyecto = DB::table('proyectos')
             ->where('proyectos.id', '=', $datoscapa[0]->proyectos_id)
             ->get();




        $datos_trabajador = DB::table('trabajadors')
    ->where('trabajadors.id_login','=',Auth::user()->id)
    ->get();

    $id_trabajador = $datos_trabajador[0]->id;
    $id_persona = $datos_trabajador[0]->id_persona;

    $datos_tecnico = DB::table('personas')
    ->where('personas.id','=',$id_persona)

    ->select(
       'personas.nombre_uno',
       'personas.nombre_dos',
        'personas.apellido_uno',
        'personas.apellido_dos')

    ->get();

        $fecha = $datoscapa[0]->fecha_resumen;



        $datos_checklist = DB::table('asignacion_retiros')
        ->join('checklist_retiros','checklist_retiros.asignacion_retiros_id','=','asignacion_retiros.id')
        -> select (
            'checklist_retiros.id',
            'checklist_retiros.csSerie',
            'checklist_retiros.csModelo',
            'checklist_retiros.cnContador_color',
            'checklist_retiros.cnContador',
            'asignacion_retiros.fecha_termino'
        )
        ->where ('asignacion_retiros.estado_asignacion','=','finalizado')
        ->where ('asignacion_retiros.trabajadors_idtecnico','=', $id_trabajador)
        ->whereDate ('asignacion_retiros.fecha_termino','=',$fecha)
        ->get();


        return view('check.verdetalleretiros',compact ('datos_tecnico','datoscapa','datos_proyecto','datos_checklist'));
    }

    public function verdatosresumenretiro_coordinadora(){

        try {
            $idcapa = $_GET['check'];

        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }
        
        $datoscapa = DB::table('resumen_retiros')
        ->join('trabajadors','trabajadors.id','=','resumen_retiros.trabajadors_id')
        ->join('personas','personas.id','=','trabajadors.id_persona')
        ->where('resumen_retiros.id','=',$idcapa)
        ->get();

        $cuisucursal = $datoscapa[0]->cuisucursal;

        /**/
        $datos_proyecto = DB::table('proyectos')
        ->where('proyectos.id', '=', $datoscapa[0]->proyectos_id)
        ->get();

        $datos_trabajador = DB::table('trabajadors')
        ->where('trabajadors.id_login','=',Auth::user()->id)
        ->get();

        $id_trabajador = $datos_trabajador[0]->id;
        $id_persona = $datos_trabajador[0]->id_persona;

        $datos_tecnico = DB::table('personas')
        ->where('personas.id','=',$id_persona)
        ->select(
            'personas.nombre_uno',
            'personas.nombre_dos',
            'personas.apellido_uno',
            'personas.apellido_dos'
        )
        ->get();

        $fecha = $datoscapa[0]->fecha_resumen;

        $datos_checklist = DB::table('asignacion_retiros')
        ->join('checklist_retiros','checklist_retiros.asignacion_retiros_id','=','asignacion_retiros.id')
        -> select (
            'checklist_retiros.id',
            'checklist_retiros.csSerie',
            'checklist_retiros.csModelo',
            'checklist_retiros.cnContador_color',
            'checklist_retiros.cnContador',
            'asignacion_retiros.fecha_termino',
            'asignacion_retiros.estado_asignacion',
            'asignacion_retiros.id as idasignacion',
            'checklist_retiros.csCui'
        )
        ->where ('asignacion_retiros.estado_asignacion','=','finalizado')
        //->whereDate ('asignacion_retiros.fecha_termino','=',$fecha)
        //->where ('asignacion_retiros.fecha_termino','=',$fecha)
        ->where ('checklist_retiros.csCui','=',$cuisucursal)
        ->get();

        // return $datos_checklist;

        return view('check.verdetalleretiro_cordinadora',compact ('datos_tecnico','datoscapa','datos_proyecto','datos_checklist','idcapa','cuisucursal'));
    }
    public function auto_complete_cui2(Request $datos){
        $scui = $datos->scui;

      /*   $cambioestado=App\retiros::where('sCui', '=', $scui)->first(); */

        $cambioestado = DB::table('retiros')
        ->join('tracker','tracker.id','=','retiros.tracker_id')
        ->join('proyectos','proyectos.id','=','tracker.proyecto_id')
        ->where('retiros.sCui','=',$scui)
        ->select(
        'proyectos.id as id_proyecto',
        'retiros.sCliente',
        'retiros.tracker_id',
        'retiros.sDireccion',
        'retiros.sComuna',
        'retiros.sCiudad'
        )
        ->distinct()
        ->get();

        return $cambioestado;
    }

}
