<!DOCTYPE html>
<html lang="en">
<?php $mes = date('d/m/Y');
header('Content-type: application/vnd.ms-excel');
header("Content-Disposition: attachment; filename=InformeServiciosfecha$mes.xls");
header("Pragma: no-cache");
header("Expires: 0");  ?>

<body>
  <table class="table table-bordered table-responsive-lg table-striped table-hover" style="margin: 0" id="gridData">
    <!-- ENCABEZADO -->
    <thead>
      <tr>
        <th class="container-2">
          <h3>Fecha de Recepcion</h3>
        </th>
        <th class="container-1">
          <h3>Fecha Solicitud</h3>
        </th>
        <th class="container-1">
          <h3>Fecha Inicio</h3>
        </th>
        <th class="container-1">
          <h3>Fecha Fin</h3>
        </th>
        <th class="container-1">
          <h3>Estado despacho</h3>
        </th>
        <th class="container-1">
          <h3>Estado</h3>
        </th>
        <th class="container-1">
          <h3>Cliente</h3>
        </th>
        <th class="container-2">
          <h3>Regi&oacute;n</h3>
        </th>
        <th class="container-2">
          <h3>Comuna</h3>
        </th>
        <th class="container-2">
          <h3>Direcci&oacute;n|Cui</h3>
        </th>
        <th class="container-2">
          <h3>sSC</h3>
        </th>
        <th class="container-2">
          <h3>Serie</h3>
        </th>
        <th class="container-2">
          <h3>Modelo</h3>
        </th>
        <th class="container-2">
          <h3>Estado opci&oacute;n</h3>
        </th>
        <th class="container-2">
        <h3>Observacion</h3>
        </th>
        <th class="container-2">
        <h3>Observacion Tecnico</h3>
        </th>
        <th class="container-2">
          <h3>Piezas solicitadas</h3>
        </th>
        <th class="container-2">
          <h3>Nombre de parte solicitadas</h3>
        </th>
        <th class="container-2">
          <h3>S/N solicitadas</h3>
        </th>
        <th class="container-2">
          <h3>Cantidad solicitadas</h3>
        </th>
        <th class="container-2">
          <h3>Piezas instaladas</h3>
        </th>
        <th class="container-2">
          <h3>Nombre de parte instaladas</h3>
        </th>
        <th class="container-2">
          <h3>S/N instaladas</h3>
        </th>
        <th class="container-2">
          <h3>cantidad instaladas</h3>
        </th>
      </tr>
    </thead>
    <!-- FIN ENCABEZADO -->
    <!-- RESULTADOS -->
    <tbody>
      @if(!empty($Api_solicitudes))
      @foreach ($Api_solicitudes as $los_datos)
      <tr>
        <td class="td-val">{{Carbon\Carbon::createFromDate($los_datos->fecha_recepcion)->format('d-m-Y')}}</td>
        <td class="td-val">{{Carbon\Carbon::createFromDate($los_datos->fecha_asignada)->format('d-m-Y')}}</td>
        @php
        $fechas = DB::table('asignacion_solicitudes')
        ->select('asignacion_solicitudes.fecha_inicio','asignacion_solicitudes.fecha_fin')
        ->where('asignacion_solicitudes.id','=',$los_datos->id_asig)
        ->get();

        $fecha_inicio = "";
        $fecha_fin = "";
        if(count($fechas) != 0){
        $fecha_inicio = Carbon\Carbon::createFromDate($fechas[0]->fecha_inicio)->format('d-m-Y H:s');
        $fecha_fin = Carbon\Carbon::createFromDate($fechas[0]->fecha_fin)->format('d-m-Y H:s');
        }
        @endphp
        <td class="td-val">{{$fecha_inicio}}</td>
        <td class="td-val">{{$fecha_fin}}</td>
        <td class="td-val">{{$los_datos->estado_externo}}</td>
        @if($los_datos->estado_interno == "tarea_asignada")
        <td class="td-val">ASIGNADO</td>
        @else
        <td class="td-val">{{$los_datos->estado_interno}}</td>
        @endif
        <td class="td-val">{{$los_datos->sCliente ?? 'no informado'}}</td>
        <td class="td-val">{{$los_datos->sRegion ?? 'no informado'}}</td>
        <td class="td-val">{{$los_datos->sComuna}}</td>
        <td class="td-val">{{$los_datos->sDireccion ?? 'no informado'}}</td>
        <td class="td-val">{{$los_datos->sSC}}</td>
        <td class="td-val">{{$los_datos->sSerie}}</td>
        <td class="td-val">{{$los_datos->sModelo ?? ''}}</td>
        <td class="td-val">{{$los_datos->estado_seleccionado}}</td>
        <td class="td-val">{{$los_datos->sDescripcion}}</td>
        <td class="td-val">{{$los_datos->observaciones}}</td>
        
        @php
        $partes_solicitadas = DB::table('check_accesorios_servicios')
        ->join('accesorios','accesorios.id','=','check_accesorios_servicios.id_accesorio')
        ->select('check_accesorios_servicios.cantidad','check_accesorios_servicios.serie_parte','accesorios.descripcion','accesorios.articulo')
        ->where('check_accesorios_servicios.id_asig_servicio','=',$los_datos->id_asig)
        ->get();

        $partes_instaladas = DB::table('checklist_instalacion_accesorios_servicios')
        ->join('accesorios','accesorios.id','=','checklist_instalacion_accesorios_servicios.id_accesorio')
        ->select('checklist_instalacion_accesorios_servicios.cantidad','checklist_instalacion_accesorios_servicios.serie_parte','accesorios.descripcion','accesorios.articulo')
        ->where('checklist_instalacion_accesorios_servicios.id_asig_servicio','=',$los_datos->id_asig)
        ->get();
        @endphp
        <td class="text-center">
          @foreach($partes_solicitadas as $key => $solicitados)
          {{$key+1}} .- {{$solicitados->descripcion}}<br>
          @endforeach
        </td>
        <td class="text-center">
          @foreach($partes_solicitadas as $key => $solicitados)
          {{$key+1}} .- {{$solicitados->articulo}}<br>
          @endforeach
        </td>
        <td class="text-center">
          @foreach($partes_solicitadas as $key => $solicitados)
          {{$key+1}} .- {{$solicitados->serie_parte}}<br>
          @endforeach
        </td>
        <td class="text-center">
          @foreach($partes_solicitadas as $key => $solicitados)
          {{$key+1}} .- {{$solicitados->cantidad}}<br>
          @endforeach
        </td>
        <td class="text-center">
          @foreach($partes_instaladas as $key => $solicitados)
          {{$key+1}} .- {{$solicitados->articulo}}<br>
          @endforeach
        </td>
        <td class="text-center">
          @foreach($partes_instaladas as $key => $instalados)
          {{$key+1}} .- {{$instalados->descripcion}}<br>
          @endforeach
        </td>
        <td class="text-center">
          @foreach($partes_instaladas as $key => $solicitados)
          {{$key+1}} .- {{$solicitados->serie_parte}}<br>
          @endforeach
        </td>
        <td class="text-center">
          @foreach($partes_instaladas as $key => $instalados)
          {{$key+1}} .- {{$instalados->cantidad}}<br>
          @endforeach
        </td>
      </tr>
      @endforeach
      @endif
    </tbody>
    <!-- FIN RESULTADOS -->
  </table>
</body>

</html>