<?php

namespace App\Http\Controllers\sistema_solicitudes;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Carbon\Carbon;
use App;
use DB;
use App\User;
use Auth;
use Illuminate\Support\Facades\Validator;
use Dompdf\Dompdf;
use Dompdf\Options;
use Illuminate\Support\Facades\Crypt;


class solicitudesdiasController extends Controller
{

    public function __construct()

    {

        $this->middleware('auth');
        
        $this->middleware('traba',['only'=>['sol_por_usuarios']]);


    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(request $request)
    {
        //




            // deposito_mensuals
    $rules = [
        'fecha_inicio' => 'required|max:65',
        'fecha_fin' => 'required|max:15',
        'motivo_solicitud' => 'required|max:500',
        'tipo_solicitud' => 'required|max:15',
        
 
    ];
    $this->validate($request, $rules);

        // $fechaemision = Carbon::parse($request->input('fecha_inicio'));
        // $fechaexpiracion = Carbon::parse($request->input('fecha_fin'));
        // $diasdiferencia = $fechaexpiracion->diffInDays($fechaemision);


        $contador_dias = 0;

        $fecha1 = strtotime($request->fecha_inicio); 
        $fecha2 = strtotime($request->fecha_fin); 
        for($fecha1;$fecha1<=$fecha2;$fecha1=strtotime('+1 day ' . date('Y-m-d',$fecha1))){ 
            if((strcmp(date('D',$fecha1),'Sun')!=0) and (strcmp(date('D',$fecha1),'Sat')!=0)){
                    $contador_dias ++;
            }
        } 

        if($contador_dias == 0){
            return back()->with('mensaje_error', 'Dias Solicitados igual a : 0'); 
        }

        $id_trabajador = DB::table('trabajadors')        
        ->where('trabajadors.id_login','=',Auth::user()->id)
        ->get();
 
    
        
        $solicitudes_dia = new App\solicitudes_dia;

        $solicitudes_dia->fecha_enviada = Carbon::now();
        $solicitudes_dia->fecha_solicitada = $request->fecha_inicio;
        $solicitudes_dia->fecha_finalizada = $request->fecha_fin;
        $solicitudes_dia->total_dias =  $contador_dias;
        $solicitudes_dia->comentarios_solicitud  = $request->motivo_solicitud;
        $solicitudes_dia->trabajadors_id =  $id_trabajador[0]->id;
        $solicitudes_dia->estados_solicitudes_id = $request->tipo_solicitud; //id_tipo de solicitud
        $solicitudes_dia->estado = "enviada" ; //id_tipo de solicitud
        $solicitudes_dia->timestamps = false;  


    

        $solicitudes_dia->save();



        return back()->with('mensaje', 'Ingreso Correcto'); 
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function generar_pdf_sol_dia($id){


        try {
            $id_des = Crypt::decryptString($id);
   
        } catch (DecryptException $e) {
            //
        }

        $datos_trabajador = DB::table('trabajadors')        
        ->where('trabajadors.id_login','=',Auth::user()->id)
        ->get();
    
        // $solicitudes_dias = App\solicitudes_dia::all();
        $solicitudes_dias = DB::table('solicitudes_dias')
        ->join('estados_solicitudes','estados_solicitudes.id_estado_solicitud','=','solicitudes_dias.estados_solicitudes_id')
        ->select('estados_solicitudes.descripcion','solicitudes_dias.estado','solicitudes_dias.fecha_solicitada'
        ,'solicitudes_dias.fecha_finalizada' ,'solicitudes_dias.fecha_enviada','solicitudes_dias.total_dias'
        ,'solicitudes_dias.comentarios_solicitud','solicitudes_dias.idsolicitudes_dia as id_solicitudes_dia')
       ->where('solicitudes_dias.trabajadors_id' ,'=',  $datos_trabajador[0]->id)
       ->where('solicitudes_dias.idsolicitudes_dia' ,'=',  $id_des)
        ->get();
        

        $trabajadores = DB::table('personas')
        ->join('trabajadors','trabajadors.id_persona','=','personas.id')
        ->where('trabajadors.estado','=','1')
        ->where('trabajadors.id','=',$datos_trabajador[0]->id)
        ->get();
   
        $tipo_solicitud =  $solicitudes_dias[0]->descripcion;
         $nombre = $trabajadores[0]->nombre_uno." ".$trabajadores[0]->nombre_dos." ".$trabajadores[0]->apellido_uno." ".$trabajadores[0]->apellido_dos;
         $año = $solicitudes_dias[0]->fecha_enviada;
         $total_dias = $solicitudes_dias[0]->total_dias;
         $fecha_inicio =$solicitudes_dias[0]->fecha_solicitada;
         $fecha_final = $solicitudes_dias[0]->fecha_finalizada;

        return \PDF::setOptions(['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true])
        ->loadView('solicitudes_dias.generar_solicitud_dia_pdf',compact('año','nombre','total_dias','tipo_solicitud','fecha_inicio','fecha_final'))
        //->stream();
        ->download($nombre.".pdf");

        //$pdf = \PDF::loadView('solicitudes_dias.generar_solicitud_dia_pdf');
  
        // $pdf -> set ( 'isRemoteEnabled' , TRUE );
        // return $pdf->download('ejemplo.pdf');
     
       //return view('solicitudes_dias.generar_solicitud_dia_pdf');

    }

    public function generar_pdf_acep_recha2($id,$id_trabajador){

       
    
        // $solicitudes_dias = App\solicitudes_dia::all();
        $solicitudes_dias = DB::table('solicitudes_dias')
        ->join('estados_solicitudes','estados_solicitudes.id_estado_solicitud','=','solicitudes_dias.estados_solicitudes_id')
        ->join('respuesta_solicitud_dias','respuesta_solicitud_dias.solicitudes_dias_idsolicitudes_dia','=','solicitudes_dias.idsolicitudes_dia')
        ->select('estados_solicitudes.descripcion','solicitudes_dias.estado','solicitudes_dias.fecha_solicitada'
        ,'solicitudes_dias.fecha_finalizada' ,'solicitudes_dias.fecha_enviada','solicitudes_dias.total_dias'
        ,'solicitudes_dias.comentarios_solicitud','solicitudes_dias.idsolicitudes_dia as id_solicitudes_dia',
        'respuesta_solicitud_dias.comentario_respuesta')
       ->where('solicitudes_dias.trabajadors_id' ,'=',  $id_trabajador)
       ->where('solicitudes_dias.idsolicitudes_dia' ,'=',  $id)
        ->get();
        

        $trabajadores = DB::table('personas')
        ->join('trabajadors','trabajadors.id_persona','=','personas.id')
        ->where('trabajadors.estado','=','1')
        ->where('trabajadors.id','=',$id_trabajador)
        ->get();
   
        $tipo_solicitud =  $solicitudes_dias[0]->descripcion;
         $nombre = $trabajadores[0]->nombre_uno." ".$trabajadores[0]->nombre_dos." ".$trabajadores[0]->apellido_uno." ".$trabajadores[0]->apellido_dos;
         $año = $solicitudes_dias[0]->fecha_enviada;
         $total_dias = $solicitudes_dias[0]->total_dias;
         $fecha_inicio =$solicitudes_dias[0]->fecha_solicitada;
         $fecha_final = $solicitudes_dias[0]->fecha_finalizada;
         $estado = $solicitudes_dias[0]->estado;
         $comentario_respuesta = $solicitudes_dias[0]->comentario_respuesta;
       // return $id; 

       return \PDF::setOptions(['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true])
       ->loadView('solicitudes_dias.generar_respuesta_solicitud_pdf',compact('año','nombre','total_dias','tipo_solicitud','fecha_inicio','fecha_final','estado','comentario_respuesta'))
       ->stream();
    }

    public function generar_pdf_acep_recha($id)
    {
        try {
            $id_des = Crypt::decryptString($id);
   
        } catch (DecryptException $e) {
            //
        }

        $datos_trabajador = DB::table('trabajadors')        
        ->where('trabajadors.id_login','=',Auth::user()->id)
        ->get();
    
        // $solicitudes_dias = App\solicitudes_dia::all();
        $solicitudes_dias = DB::table('solicitudes_dias')
        ->join('estados_solicitudes','estados_solicitudes.id_estado_solicitud','=','solicitudes_dias.estados_solicitudes_id')
        ->join('respuesta_solicitud_dias','respuesta_solicitud_dias.solicitudes_dias_idsolicitudes_dia','=','solicitudes_dias.idsolicitudes_dia')
        ->select('estados_solicitudes.descripcion','solicitudes_dias.estado','solicitudes_dias.fecha_solicitada'
        ,'solicitudes_dias.fecha_finalizada' ,'solicitudes_dias.fecha_enviada','solicitudes_dias.total_dias'
        ,'solicitudes_dias.comentarios_solicitud','solicitudes_dias.idsolicitudes_dia as id_solicitudes_dia',
        'respuesta_solicitud_dias.comentario_respuesta')
       ->where('solicitudes_dias.trabajadors_id' ,'=',  $datos_trabajador[0]->id)
       ->where('solicitudes_dias.idsolicitudes_dia' ,'=',  $id_des)
        ->get();
        

        $trabajadores = DB::table('personas')
        ->join('trabajadors','trabajadors.id_persona','=','personas.id')
        ->where('trabajadors.estado','=','1')
        ->where('trabajadors.id','=',$datos_trabajador[0]->id)
        ->get();
   
        $tipo_solicitud =  $solicitudes_dias[0]->descripcion;
         $nombre = $trabajadores[0]->nombre_uno." ".$trabajadores[0]->nombre_dos." ".$trabajadores[0]->apellido_uno." ".$trabajadores[0]->apellido_dos;
         $año = $solicitudes_dias[0]->fecha_enviada;
         $total_dias = $solicitudes_dias[0]->total_dias;
         $fecha_inicio =$solicitudes_dias[0]->fecha_solicitada;
         $fecha_final = $solicitudes_dias[0]->fecha_finalizada;
         $estado = $solicitudes_dias[0]->estado;
         $comentario_respuesta = $solicitudes_dias[0]->comentario_respuesta;
       // return $id_des; 

       return \PDF::setOptions(['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true])
       ->loadView('solicitudes_dias.generar_respuesta_solicitud_pdf',compact('año','nombre','total_dias','tipo_solicitud','fecha_inicio','fecha_final','estado','comentario_respuesta'))
       ->stream();
    }


    public function dias_utlizados(){

        $año = carbon::now();
        $año_actual =$año->year;
        $año_anterior =$año_actual - 1;

        $fecha_actual= Carbon::parse($año_actual.'-12-31')->format('Y-m-d');
         $fecha_anterior= Carbon::parse($año_anterior.'-01-01')->format('Y-m-d');
        
       
        $años_filtrados = $fecha_anterior." - ". $fecha_actual;




        $datos_trabajador = DB::table('trabajadors')        
        ->where('trabajadors.id_login','=',Auth::user()->id)
        ->get();

        $id_trabajador = $datos_trabajador[0]->id;

        $mis_dias_utilizados = DB::table('mis_dias')
        ->join('respuesta_solicitud_dias','respuesta_solicitud_dias.idrespuesta_solicitud_dias','=','mis_dias.respuesta_solicitud_dias_idrespuesta_solicitud_dias')
        ->join('solicitudes_dias','solicitudes_dias.idsolicitudes_dia','=','respuesta_solicitud_dias.solicitudes_dias_idsolicitudes_dia')
        ->join('estados_solicitudes','estados_solicitudes.id_estado_solicitud','=','solicitudes_dias.estados_solicitudes_id')

        ->select('fecha_finalizada','fecha_solicitada','fecha_finalizada','estados_solicitudes.descripcion','solicitudes_dias.total_dias')
        ->where("mis_dias.trabajadors_id",'=',$id_trabajador)
        ->whereBetween('solicitudes_dias.fecha_solicitada', [$fecha_anterior , $fecha_actual])
        ->get();
        
       
 


       
        // Carbon::parse($fecha_anterior.'-01-01')->format('Y-m-d')
        $acumulador_dias = 0;
        foreach ($mis_dias_utilizados as $valor) {
            $acumulador_dias = $valor->total_dias + $acumulador_dias ;
        }
        $dias_disponibles = 30 -  $acumulador_dias;
        return view('solicitudes_dias.mis_dias_solicitados',compact('mis_dias_utilizados','años_filtrados','dias_disponibles'));

    }

    public function aceptar_sol_dia(request $request)
    {
       
        if($request->id_soli == null || $request->respuesta_describa == null || $request->region_sol == null ){

            return back()->with('mensaje_error', 'Debe de Intentar Nuevamente'); 


        }
        $datos_administrador = DB::table('administradors')        
        ->where('administradors.id_login','=',Auth::user()->id)
        ->get();
         $id_admi = $datos_administrador[0]->id;
         
        $respuesta_solicitud_dias = new App\respuesta_solicitud_dias;

        $respuesta_solicitud_dias->fecha_respuesta =  Carbon::now();
        $respuesta_solicitud_dias->comentario_respuesta = $request->respuesta_describa;
        $respuesta_solicitud_dias->estado_respuesta = 2; //aceptada
        $respuesta_solicitud_dias->administradors_id  =  $id_admi;
        $respuesta_solicitud_dias->solicitudes_dias_idsolicitudes_dia = $request->id_soli;
        $respuesta_solicitud_dias->lugar_solicitada =  $request->region_sol;
        $respuesta_solicitud_dias->timestamps = false;  
       $respuesta_solicitud_dias->save();

        $mis_dias = new App\mis_dias;
        $mis_dias->respuesta_solicitud_dias_idrespuesta_solicitud_dias  = $respuesta_solicitud_dias->id ;
        $mis_dias->trabajadors_id = $request->id_trabaja;
        $mis_dias->timestamps = false;  
       $mis_dias->save();


       $solicitudes_dia =  App\solicitudes_dia::findOrfail($request->id_soli);
        $solicitudes_dia->estado = "aceptada" ; //id_tipo de solicitud
        $solicitudes_dia->timestamps = false;  
        $solicitudes_dia->save();

        return back()->with('mensaje', 'Solicitud Respondida'); 

   
    }
  


    

    public function rechazar_sol_dia(request $request)
    {
       
        if($request->id_soli_2 == null || $request->respuesta_describa_2 == null || $request->region_sol_2 == null ){

            return back()->with('mensaje_error', 'Debe de Intentar Nuevamente'); 


        }
        $datos_administrador = DB::table('administradors')        
        ->where('administradors.id_login','=',Auth::user()->id)
        ->get();
         $id_admi = $datos_administrador[0]->id;
         
        $respuesta_solicitud_dias = new App\respuesta_solicitud_dias;

        $respuesta_solicitud_dias->fecha_respuesta =  Carbon::now();
        $respuesta_solicitud_dias->comentario_respuesta = $request->respuesta_describa_2;
        $respuesta_solicitud_dias->estado_respuesta = 3; //rechazada
        $respuesta_solicitud_dias->administradors_id  =  $id_admi;
        $respuesta_solicitud_dias->solicitudes_dias_idsolicitudes_dia = $request->id_soli_2;
        $respuesta_solicitud_dias->lugar_solicitada =  $request->region_sol_2;
        $respuesta_solicitud_dias->timestamps = false;  
       $respuesta_solicitud_dias->save();

    

       $solicitudes_dia =  App\solicitudes_dia::findOrfail($request->id_soli_2);
        $solicitudes_dia->estado = "rechazada" ; //id_tipo de solicitud
        $solicitudes_dia->timestamps = false;  
        $solicitudes_dia->save();

        return back()->with('mensaje', 'Solicitud Rechazada'); 

   
    }


    public function sol_por_usuarios()
    {
            return view('solicitudes_dias.solicitudes_see_admin');
    }

    function fetch(Request $request)
    {
       



     if($request->get('query'))
     {

        $query = $request->get('query');
        $valores = explode(" ", $query);

            if(count($valores) > 1){
                $nombre1= $valores[0];
                    $apelldo1= $valores[1];
                $data = DB::table('personas')
                ->join('trabajadors','trabajadors.id_persona','=','personas.id')
                ->where('nombre_uno', 'LIKE', "%{$nombre1}%")
                ->where('apellido_uno', 'LIKE', "%{$apelldo1}%")
                ->where('trabajadors.estado','=',1)
                ->select('personas.nombre_uno','personas.apellido_uno','personas.apellido_dos','trabajadors.id','personas.rut')
                ->get();
                
            }elseif(count($valores) == 1){
                $data = DB::table('personas')
                ->join('trabajadors','trabajadors.id_persona','=','personas.id')
                ->where('nombre_uno', 'LIKE', "%{$query}%")
                ->where('trabajadors.estado','=',1)
                ->select('personas.nombre_uno','personas.apellido_uno','personas.apellido_dos','trabajadors.id','personas.rut')

                ->get();
            

            }
      
    
      $output = '<ul  class="alert alert-success" style="display:block; list-style:none">';
      foreach($data as $row)
      {
       $output .= '
       <li class="mayuscula" data-id="'.$row->id.'" style="list-style:none;cursor: pointer;">'.'<a onclick="agregar_id('.$row->id.')">'.$row->nombre_uno.'  '.$row->apellido_uno.' '.$row->apellido_dos.'</a></li><hr>
       ';
      }
      $output .= '</ul>';
      
      echo $output;

     }else{
     
     }
    }


    public function buscar_usuario_nombre(request $request)
    {
         $nomre_usuario = $request->nombre_trabajador;
          // $solicitudes_dias = App\solicitudes_dia::all();
    $solicitudes_dias = DB::table('solicitudes_dias')
    ->join('estados_solicitudes','estados_solicitudes.id_estado_solicitud','=','solicitudes_dias.estados_solicitudes_id')
    ->select('estados_solicitudes.descripcion','solicitudes_dias.estado','solicitudes_dias.fecha_solicitada'
    ,'solicitudes_dias.fecha_finalizada' ,'solicitudes_dias.fecha_enviada','solicitudes_dias.total_dias',
    'solicitudes_dias.comentarios_solicitud','solicitudes_dias.idsolicitudes_dia as id_solicitudes_dia')
   ->where('solicitudes_dias.trabajadors_id' ,'=',  $request->id_trabajador)
   ->where('solicitudes_dias.estado' ,'!=',  "eliminada")
    ->orderBy('solicitudes_dias.idsolicitudes_dia', 'desc')   

    ->get();

    $id_trabajador = $request->id_trabajador;
    return view('solicitudes_dias.solicitudes_see_admin',compact('solicitudes_dias','nomre_usuario','id_trabajador'));

    }


    public function eliminar_sol_dia($id){

        try {
            $id_dia = Crypt::decryptString($id);

        
   
        } catch (DecryptException $e) {
            //
        }

        $solicitudes_dia =  App\solicitudes_dia::findOrfail($id_dia);
       $solicitudes_dia->estado = "eliminada" ; //id_tipo de solicitud
       $solicitudes_dia->timestamps = false;  
        $solicitudes_dia->save();

        return back()->with('mensaje', 'Solicitud Eliminada.'); 





    }
    public function buscarcoincidenfechas(request $request){

        $fechas = explode("&&&", $request->fechas);

  

        $f_inicio = Carbon::parse($fechas[0]);
        $f_fin = Carbon::parse($fechas[1]);
       // $fecha_inicio =  $f_inicio->format('d-m-Y');
       // $fecha_fin =  $f_fin->format('d-m-Y');

    //    ->join('trabajadors','trabajadors.id_persona','=','personas.id')


     //   $solicitudes_dias = DB::table('solicitudes_dias')
    //    ->join('trabajadors','trabajadors.id_persona','=','8')
  //      ->select('solicitudes_dias.fecha_solicitada','solicitudes_dias.fecha_finalizada','solicitudes_dias.estado')
        //->whereBetween('solicitudes_dias.fecha_solicitada', [$f_inicio, $f_fin])
        //->orWhere(function($query) use ($f_inicio,$f_fin )

        // {

        //   $query ->whereBetween('solicitudes_dias.fecha_solicitada', [$f_inicio, $f_fin]);

        // })

//        ->get();

        // trabajadors_id

        $trabajadores = DB::table('personas')
        ->join('trabajadors','trabajadors.id_persona','=','personas.id')
        ->join('solicitudes_dias','solicitudes_dias.trabajadors_id','=','trabajadors.id')
        ->select('personas.nombre_uno','personas.apellido_uno','solicitudes_dias.fecha_solicitada','solicitudes_dias.fecha_finalizada','solicitudes_dias.estado')
        ->orWhere(function($query) use ($f_inicio,$f_fin )
             {
                 $query ->whereBetween('solicitudes_dias.fecha_solicitada', [$f_inicio, $f_fin])
                 ->where('trabajadors.estado','=','1')
                 ->where('solicitudes_dias.estado','!=','eliminada');
            })
            ->orWhere(function($query) use ($f_inicio,$f_fin )
            {
                $query   ->whereBetween('solicitudes_dias.fecha_finalizada', [$f_inicio, $f_fin])
                ->where('trabajadors.estado','=','1')
                ->where('solicitudes_dias.estado','!=','eliminada');
           })    


       
       
        // ->where('trabajadors.id','=',"2")
        ->get();

        echo $trabajadores;


    }
    // ->join('trabajadors','trabajadors.id_persona','=','personas.id')

}


