<?php

namespace App\Http\Controllers\pdfs;
use Auth;
use DB;
use App;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class PdfInformesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request)
    {
        $fecha = Carbon::createFromDate($request->datepicker)->format('Y-m-d');
        //return $fecha;
        if (!empty($request->datepicker)){
            $rutapdf = DB::table('informes')
            ->select(
                'informes.id',
                'informes.url_pdf',
                'informes.fecha'
                )
            ->where('informes.url_pdf','!=',"null")
            ->where('nombre_proveedor','=',Auth::user()->nombre_proveedor)
            ->where('informes.fecha', 'like','%'.$fecha.'%')
            ->distinct('informes.fecha')
            ->groupBy('informes.fecha')
            ->get();
            return view ('portal.pdfs_informes',compact('rutapdf'));
        }else{
            $rutapdf = DB::table('informes')
            ->select(
                'informes.id',
                'informes.url_pdf',
                'informes.fecha'
                )
            ->where('informes.url_pdf','!=',"null")
            ->where('nombre_proveedor','=',Auth::user()->nombre_proveedor)

            ->distinct('informes.fecha')
            ->groupBy('informes.fecha')
            ->get();
            return view ('portal.pdfs_informes',compact('rutapdf'));
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    //ver pdf's
    public function ir_pdfs_generados(){


        //creamos el metodo para traer a todas los informes con ruta pdf
        $rutapdf = DB::table('informes')
        ->select(
            'informes.id',
            'informes.url_pdf',
            'informes.fecha'
            )
        ->where('informes.url_pdf','!=',"null")
        ->where('nombre_proveedor','=',Auth::user()->nombre_proveedor)

        ->distinct('informes.fecha')
            ->groupBy('informes.fecha')
        ->get();



        return view ('portal.pdfs_informes',compact('rutapdf'));

    }

    //funcion para descargar los pdf asociados a un id de asignacion
    public function getDownload($url_pdf)
    {

        $file= storage_path('app/public/pdfInformes/').$url_pdf;

        return response()->download($file);
    }
}
