<?php

namespace App\Http\Controllers\gastosreembolsos;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Contracts\Encryption\DecryptException;
use Crypt;

use App\User;
use App;
use DB;
use Carbon\Carbon;


use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;


use Auth;

class gastos extends Controller
{
    public function __construct()

    {

        $this->middleware('auth');

    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {

 


      

        $rules = [
         
            'codigo_sc' => 'required|max:50',
            'sucursal' => 'required|max:20',
            'combustible' => 'required|max:20',
            'colacion' => 'required|max:20',
            'viaje_atenciones' => 'required|max:20',
            'viaje_diario' => 'required|max:20',
            'otro_gasto' => 'required|max:20',
            'total_gasto' => 'required|max:50',
            'fecha_gasto' => 'required|max:50',
            'descripcion_gasto' => 'required|max:400',
            'titulo' => 'required|max:200',
  
        ];

        $this->validate($request, $rules);
        date_default_timezone_set('Chile/Continental');

        // $id_trabajador = App\trabajador::all()->where('id_login','=',Auth::user()->id);

        $id_trabajador = DB::table('trabajadors')        
        ->where('trabajadors.id_login','=',Auth::user()->id)
        ->get();


        $fecha_actual_ = Carbon::now();
        $fecha_actual =$fecha_actual_->format('d-m-Y');
        $hora_actual =$fecha_actual_->format('h:i:s');
        // $dt = new DateTime($request->fecha_gasto);
        // $date = Carbon::parse();
       $fecha_gastado = Carbon::parse($request->fecha_gasto)->format('Y-m-d');


       //estados 1= activo 2=enviado 3:aceptado
       $gastos_historial = new App\gastos_historial;
       $gastos_historial->estado = 1;
       $gastos_historial->titulo = $request->titulo;      
       $gastos_historial->descripcion_pago = $request->descripcion_gasto;
       $gastos_historial->fecha_eliminado = $fecha_actual_;
       $gastos_historial->estado_eliminado = 1;
       $gastos_historial->fecha_registrado =  $fecha_actual_;
       $gastos_historial->fecha_comprado =$fecha_gastado;
       
       $gastos_historial->viaje_diario =$request->viaje_diario;
       $gastos_historial->viaje_atenciones =$request->viaje_atenciones;
       $gastos_historial->combustible =$request->combustible;
       $gastos_historial->colacion =$request->colacion;
       $gastos_historial->otro_gasto =$request->otro_gasto;

       $gastos_historial->codigo_sc =$request->codigo_sc;

       
       $gastos_historial->total = $request->total_gasto;
       $gastos_historial->id_trabajador	 = $id_trabajador[0]->id;
       $gastos_historial->id_sucursal = $request->sucursal;
       $gastos_historial->timestamps = false;  
       $gastos_historial->save();


    $billetera_virtual =  App\billetera_virtual::findOrfail($id_trabajador[0]->id_billetera);
    $billetera_virtual->total_gastos = $billetera_virtual->total_gastos + $request->total_gasto;
    $billetera_virtual->fecha_actualizado_gasto = Carbon::now();
    $billetera_virtual->timestamps = false; 
    $billetera_virtual->save();

    
        return back()->with('mensaje', 'Gasto Agregado'); 


    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    
    public function reembolsar($id_gasto)
    {
        try {
            $id_desencriptado = Crypt::decryptString($id_gasto);
           
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }



        $datos_trabajador = DB::table('trabajadors')        
        ->where('trabajadors.id_login','=',Auth::user()->id)
        ->get();
        $fecha_actual_ = Carbon::now();
        $fecha_actual =$fecha_actual_->format('Y-m-d');
        $hora_actual =$fecha_actual_->format('h:i:s');
        // solicitudes_reembolsos
        $solicitudes_reembolsos = new App\solicitudes_reembolsos;
        $solicitudes_reembolsos->fecha_solicitada = $fecha_actual;
        $solicitudes_reembolsos->hora_solicitada = $hora_actual;
        $solicitudes_reembolsos->estado_solicitud = 1;
        $solicitudes_reembolsos->id_trabajador = $datos_trabajador[0]->id;
        $solicitudes_reembolsos->gasto_historial =  $id_desencriptado; //es la id, de esa tabla
        $solicitudes_reembolsos->timestamps = false; 
        $solicitudes_reembolsos->save();


        $gastos_historial =  App\gastos_historial::findOrfail($id_desencriptado);
        $gastos_historial->estado = 2; //1, solicitud enviada
        $gastos_historial->timestamps = false; 
        $gastos_historial->save();
        return back()->with('mensaje', 'Solicitud Enviada'); 

    }

    public function actualizar_eliminar($id_gasto)
    {
       

  
        try {
            $id_desencriptado = Crypt::decryptString($id_gasto);
           
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }


        $porciones = explode("x-x",$id_desencriptado);
        // return $id_desencriptado;



        $gastos_historial =  App\gastos_historial::findOrfail($porciones[0]);
        $gastos_historial->estado_eliminado = 0; //01, Eliminado
        $gastos_historial->timestamps = false; 
        $gastos_historial->save();

        // actualizamos los gastos de la billetera

        $id_trabajador = DB::table('trabajadors')        
        ->where('trabajadors.id_login','=',Auth::user()->id)
        ->get();

        // return $id_trabajador[0]->id_billetera;


        // return $porciones[1];
    $billetera_virtual =  App\billetera_virtual::findOrfail($id_trabajador[0]->id_billetera);
    $billetera_virtual->total_gastos = $billetera_virtual->total_gastos - $porciones[1];
    $billetera_virtual->fecha_actualizado_gasto = Carbon::now();
    $billetera_virtual->timestamps = false; 
    $billetera_virtual->save();


        return back()->with('mensaje', 'Solicitud Eliminada'); 

    }
}
