<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Contracts\Encryption\DecryptException;
// use Cinema\Http\Request;
use Session;
use Redirect;
// use Illuminate\Http\Request;

use Crypt;
use Illuminate\Support\Facades\Config;
use App\User;
use App;
use DB;
use Carbon\Carbon;


use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

class api_intalacionesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(request $request)
    {


        $rules = [
            'nFolio' => 'numeric|required|digits_between:1,6',
            'sRegion' => 'required|max:100',
            'sRut' => 'required|max:20',
            'sCliente' => 'required|max:100',
            'sDireccion' => 'required|max:100',
            'sPiso' => 'max:20',
            'sComuna' =>    'required|max:50',
            'nID_Tracker' => 'numeric|required',
            'sCiudad' =>    'required|max:50',
            'sCui' =>    'required|max:20',
            'sTipo_sucursal' =>    'required|max:50',
            'sContacto' =>    'required|max:100',
            'sN_contacto' =>    'required|max:20',
            'sSerie' =>    'required|max:20',
            'sModelo' =>    'required|max:30',
            'sUsb_red' =>    'required|max:3|min:0',
            'sDriver' =>    'required|max:100',
            'sSC' =>    'required|max:10',
            'sIP' =>    'required|max:20',
            'sMsk' =>    'required|max:20',
            'sGateway' =>    'required|max:20',
            'sMac' =>    'required|max:20',
            'sBandeja_adicional' =>    'required|max:10',
            'sMueble' =>    'required|max:10',
            'sKit_lector' =>    'required|max:10',
            'sCable_poder' =>    'required|max:10',
            'sSD' =>    'required|max:10',
            'sCable_red' =>    'required|max:10',
            'dFecha_plan_despacho' => 'date|required',
            'dFecha_despacho' => 'date|required',
            'nGuia' =>    'numeric|required|digits_between:1,4',
            'sEstado_despacho' =>    'required|max:20',
            'dFecha_instalacion' =>    'date|required',
            'nContador' =>    'numeric|required|digits_between:1,4',
            'nContador_color' =>    'digits_between:0,4',
            'sEstado_instalacion' =>    'required|max:20',
            'sObservacion' =>    'max:500',

        ];

        $messages = [

            'nFolio.required' => ' nFolio Requerido',
            'sRegion.required' => 'sRegion Requerido',
            'sRut.required' => ' sRut Requerido',
            'sCliente.required' => ' sCliente Requerido',
            'sDireccion.required' => ' sDireccion Requerido',
            'sComuna.required' => ' sComuna Requerido',
            'sCiudad.required' => ' sCiudad Requerido',
            'sCui.required' => ' sCui Requerido',
            'sTipo_sucursal.required' => ' sTipo_sucursal Requerido',
            'sContacto.required' => ' sContacto Requerido',
            'sN_contacto.required' => ' sN_contacto Requerido',
            'sSerie.required' => ' sSerie Requerido',
            'sModelo.required' => ' sModelo Requerido',
            'sUsb_red.required' => ' sUsb_red Requerido',
            'nID_Tracker' => 'nID_Tracker Requerido',
            'sDriver.required' => ' sDriver Requerido',
            'sSC.required' => ' sSC Requerido',
            'sIP.required' => ' sIP Requerido',
            'sMsk.required' => ' sMsk Requerido',
            'sGateway.required' => ' sGateway Requerido',
            'sMac.required' => ' sMac Requerido',
            'sBandeja_adicional.required' => ' sBandeja_adicional Requerido',
            'sMueble.required' => ' sMueble Requerido',
            'sKit_lector.required' => ' sKit_lector Requerido',
            'sCable_poder.required' => ' sCable_poder Requerido',
            'sSD.required' => ' sSD Requerido',
            'sCable_red.required' => ' sCable_red Requerido',
            'dFecha_plan_despacho.required' => ' dFecha_plan_despacho Requerido',
            'dFecha_despacho.required' => ' dFecha_despacho Requerido',
            'nGuia.required' => ' nGuia Requerido',
            'sEstado_despacho.required' => ' sEstado_despacho Requerido',
            'dFecha_instalacion.required' => ' dFecha_instalacion Requerido',
            'nContador.required' => ' nContador Requerido',
            'sEstado_instalacion.required' => ' sEstado_instalacion Requerido',

        ];


        // $validator = \Validator::make($request->all(),$rules,$messages);
        // if ($validator->fails()) {
        //     return [
        //         'created' => false,
        //         'errors'  => $validator->errors()->all()
        //     ];
        // }

        // if($request->nContador_color != "" || $request->nContador_color != null){
        //     if(!is_numeric($request->nContador_color)){
        //         return "la Variable nContador_color debe ser Numerica";
        //     }
        // }
        
        Config::set('database.connections.mysql.database', 'KYOCERA');
        DB::reconnect();

        $dFecha_instalacion = date('Y-m-d', strtotime($request->dFecha_instalacion));
        $dFecha_plan_despacho = date('Y-m-d', strtotime($request->dFecha_plan_despacho));
        $dFecha_despacho = date('Y-m-d', strtotime($request->dFecha_despacho));



        $buscar =  DB::table('instalacions')
            ->where('nFolio', '=', $request->nFolio)
            ->where('nID_Tracker', '=', $request->nID_Tracker)

            ->get();


        $FechaHoraActual  = Carbon::now();
        $FechaHoraActual = $FechaHoraActual->toDateTimeString();

        $file = fopen("instalacion.txt", "a");
        fwrite($file, $request . PHP_EOL);
        fclose($file);




        if (count($buscar) == 0) {

            // return $buscar;
            $instalacion = new App\instalacions;
            $instalacion->tracker_idtracker     = "1"; //dejaarlo asi mientras
            $instalacion->nFolio = $request->nFolio;
            $instalacion->sRegion = $request->sRegion;
            $instalacion->sRut = $request->sRut;
            
            //$nombreCliente = DB::table('instalacions')
            //->select('instalacions.sCliente')
            //->where('nID_Tracker', '=', $request->nID_Tracker)
            //->orderBy('id','DESC')
            //->take(1)
            //->get();

            //if(count($nombreCliente) == 0){
            $instalacion->sCliente = $request->sCliente;
            //}else{
                //$instalacion->sCliente = $nombreCliente[0]->sCliente;
            //}

            $instalacion->sDireccion = $request->sDireccion;
            $instalacion->sPiso = $request->sPiso;
            $instalacion->sComuna = $request->sComuna;
            $instalacion->nID_Tracker = $request->nID_Tracker;
            $instalacion->sCiudad = $request->sCiudad;
            $instalacion->sCui = $request->sCui;
            $instalacion->sTipo_sucursal = $request->sTipo_sucursal;
            $instalacion->sContacto = $request->sContacto;
            $instalacion->sN_contacto = $request->sN_contacto;
            $instalacion->sModelo = $request->sModelo;
            $instalacion->sUsb_red = $request->sUsb_red;
            $instalacion->sDriver = $request->sDriver;
            $instalacion->sSC = $request->sSC;
            $instalacion->sIP = $request->sIP;
            $instalacion->sSerie = $request->sSerie;
            $instalacion->sMsk = $request->sMsk;
            $instalacion->sGateway = $request->sGateway;
            $instalacion->sMac = $request->sMac;
            $instalacion->sBandeja_adicional = $request->sBandeja_adicional;
            $instalacion->sMueble = $request->sMueble;
            $instalacion->sKit_lector = $request->sKit_lector;
            $instalacion->sCable_poder = $request->sCable_poder;
            $instalacion->sSD = $request->sSD;
            $instalacion->sCable_red = $request->sCable_red;
            $instalacion->dFecha_plan_despacho = $dFecha_plan_despacho;
            $instalacion->dFecha_despacho = $dFecha_despacho;
            $instalacion->nGuia = $request->nGuia;
            $instalacion->sEstado_despacho = $request->sEstado_despacho;
            $instalacion->dFecha_instalacion = $dFecha_instalacion;
            $instalacion->nContador = $request->nContador;
            $instalacion->nContador_color = $request->nContador_color;
            $instalacion->sEstado_instalacion = "Por Asignar";
            $instalacion->sObservacion = $request->sObservacion;
            $instalacion->fecha_registrado = $FechaHoraActual;
            // $instalacion->sEstado_instalacion = $request->sEstado_despacho;
            $instalacion->instalador = $request->instalador;
            $instalacion->proveedor_instalacion = "kyocera";

            //Nuevos campos Solicitados
            $instalacion->tipo = $request->tipo;
            $instalacion->razonSocial = $request->razonSocial;
     

            $instalacion->timestamps = false;
            $instalacion->save();





            return "OK";
        } else {



            
      

            $actualizar_ins =  App\instalacions::findOrfail($buscar[0]->id);

            if($actualizar_ins->sEstado_despacho  == "finalizado" || $actualizar_ins->sEstado_despacho  == "revisar" || $actualizar_ins->sEstado_despacho  == "Pendiente" || $actualizar_ins->sEstado_despacho  == "Cancelado " || $actualizar_ins->sEstado_despacho  == "Asignado" || $actualizar_ins->sEstado_despacho  == "asignado" || $actualizar_ins->sEstado_despacho  == "Finalizado" ){

                $actualizar_ins->sRegion = $request->sRegion;
                $actualizar_ins->timestamps = false;
                $actualizar_ins->save();


                $file = fopen("archivo.txt", "a");
                fwrite($file, $request . PHP_EOL);
                fclose($file);
              return "No Actualizado";
            }else{
                $actualizar_ins->sEstado_despacho = $request->sEstado_despacho;
                $actualizar_ins->sRegion = $request->sRegion;
                $actualizar_ins->sCui = $request->sCui;
                $actualizar_ins->instalador = $request->instalador;
                $actualizar_ins->sCliente = $request->sCliente;
                $actualizar_ins->sSerie = $request->sSerie;
                $actualizar_ins->timestamps = false;
                $actualizar_ins->save();
    
                $file = fopen("archivo.txt", "a");
                fwrite($file, $request . PHP_EOL);
                fclose($file);
    
                return "Actualizado";

            }
            
           
        }
    }

    public function create_sin_restriccion(Request $request)
    {


        if ($request->dFecha_instalacion != "" || $request->dFecha_instalacion != null) {
            $dFecha_instalacion = date('Y-m-d', strtotime($request->dFecha_instalacion));
        } else {
            $dFecha_instalacion = "";
        }


        $dFecha_plan_despacho = date('Y-m-d', strtotime($request->dFecha_plan_despacho));
        $dFecha_despacho = date('Y-m-d', strtotime($request->dFecha_despacho));

        $FechaHoraActual  = Carbon::now();
        $FechaHoraActual = $FechaHoraActual->toDateTimeString();

        // return $buscar;

        if ($request->sCliente != "" || $request->sCliente != null) {

            if($request->proveedor_instalacion == "upgrade" || $request->proveedor_instalacion == "UPGRADE"){
                Config::set('database.connections.mysql.database', 'UPGRADE');
                DB::reconnect();
            }
            if($request->proveedor_instalacion == "kyocera" || $request->proveedor_instalacion == "KYOCERA"){
                Config::set('database.connections.mysql.database', 'KYOCERA');
                DB::reconnect();
            }
            if($request->proveedor_instalacion == "comtecglobal" || $request->proveedor_instalacion == "COMTECGLOBAL"){
                Config::set('database.connections.mysql.database', 'COMTECGLOBAL');
                DB::reconnect();
            }
            if($request->proveedor_instalacion == "microserv" || $request->proveedor_instalacion == "MICROSERV"){
                Config::set('database.connections.mysql.database', 'MICROSERV');
                DB::reconnect();
            }


            $buscar =  DB::table('instalacions')
                ->where('sSerie', '=', $request->sSerie)
                ->get();

            if (count($buscar) == 0) {
                $instalacion = new App\instalacions;
                $instalacion->tracker_idtracker  = 1; //dejaarlo asi mientras
                $instalacion->nFolio = $request->nFolio;
                $instalacion->sRegion = $request->sRegion;
                $instalacion->sRut = $request->sRut;
                $instalacion->sCliente = $request->sCliente;
                $instalacion->sDireccion = $request->sDireccion;
                $instalacion->sPiso = $request->sPiso;
                $instalacion->sComuna = $request->sComuna;
                $instalacion->nID_Tracker = $request->nID_Tracker;
                $instalacion->sCiudad = $request->sCiudad;
                $instalacion->sCui = $request->sCui;
                $instalacion->sTipo_sucursal = $request->sTipo_sucursal;
                $instalacion->sContacto = $request->sContacto;
                $instalacion->sN_contacto = $request->sN_contacto;
                $instalacion->sModelo = $request->sModelo;
                $instalacion->sUsb_red = $request->sUsb_red;
                $instalacion->sDriver = $request->sDriver;
                $instalacion->sSC = $request->sSC;
                $instalacion->sIP = $request->sIP;
                $instalacion->sSerie = $request->sSerie;
                $instalacion->sMsk = $request->sMsk;
                $instalacion->sGateway = $request->sGateway;
                $instalacion->sMac = $request->sMac;
                $instalacion->sBandeja_adicional = $request->sBandeja_adicional;
                $instalacion->sMueble = $request->sMueble;
                $instalacion->sKit_lector = $request->sKit_lector;
                $instalacion->sCable_poder = $request->sCable_poder;
                $instalacion->sSD = $request->sSD;
                $instalacion->sCable_red = $request->sCable_red;
                $instalacion->dFecha_plan_despacho = $dFecha_plan_despacho;
                $instalacion->dFecha_despacho = $dFecha_despacho;
                $instalacion->nGuia = $request->nGuia;
                $instalacion->sEstado_despacho = $request->sEstado_despacho;
                $instalacion->dFecha_instalacion = $dFecha_instalacion;
                $instalacion->nContador = $request->nContador;
                $instalacion->nContador_color = $request->nContador_color;
                $instalacion->sEstado_instalacion = "Por Asignar";
                $instalacion->sObservacion = $request->sObservacion;
                $instalacion->fecha_registrado = $FechaHoraActual;
                // $instalacion->sEstado_instalacion = $request->sEstado_despacho;
                $instalacion->instalador = $request->instalador;
                $instalacion->proveedor_instalacion = $request->proveedor_instalacion;
                $instalacion->timestamps = false;
                $instalacion->save();
            } else {

                echo "error";
                return "errtot";
                //$actualizar_ins =  App\instalacions::findOrfail($buscar[0]->id);
                //$actualizar_ins->sEstado_despacho = $request->sEstado_despacho;

                //$actualizar_ins->dFecha_instalacion = $request->dFecha_instalacion;
                //$actualizar_ins->timestamps = false;
                //$actualizar_ins->save();

            }
        }
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\api_intalacciones  $api_intalacciones
     * @return \Illuminate\Http\Response
     */
    public function show(api_intalacciones $api_intalacciones)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\api_intalacciones  $api_intalacciones
     * @return \Illuminate\Http\Response
     */
    public function edit(api_intalacciones $api_intalacciones)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\api_intalacciones  $api_intalacciones
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, api_intalacciones $api_intalacciones)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\api_intalacciones  $api_intalacciones
     * @return \Illuminate\Http\Response
     */
    public function destroy(api_intalacciones $api_intalacciones)
    {
        //
    }
}
