<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App; 
 
use Illuminate\Support\Facades\Storage;

use App\direccion;

use App\persona; 

use App\User; 

use Auth;
use Session;

use DateTime;
use DateInterval;
use DatePeriod;

use DB; 

use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Carbon\Carbon;


class GenerarPDFCorreosController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create( request $request)
    {
      
//Obtener las fechas ingresadas en el calendario
// $fechaInicio = date('Y-m-d', strtotime($request->input("fecha1pdf")));
// $fechaFin = date('Y-m-d', strtotime($request->input("fecha2pdf")));



$validacion = 1;
$letra = $request->input("idproyecto");

$date2 = Carbon::now();
$date2 = $date2->format('yy-m-d');
$date2 = $date2." 00:00:00";



$date3 = Carbon::now();
$date3 = $date3->format('yy-m-d');
$date3 =  $date3." 23:59:59";



$fecha_proeycto = DB::table('proyectos')->select('proyectos.fecha_inicio')
    ->where('proyectos.estado', '=', 1)
    ->where('proyectos.id', '=', $letra)
    ->get();

     



$fechaInicio = $fecha_proeycto[0]->fecha_inicio;
$fechaFin = $date3;



//Extraer los proyectos de la bd
$proyectos = DB::table('proyectos')->select('proyectos.id', 'proyectos.nombre')
    ->where('proyectos.estado', '=', 1)
    ->where('proyectos.id', '!=', 1)
    ->orderBy('proyectos.id', 'asc')
    ->get();
$nombres =  DB::table('proyectos')
    ->where('proyectos.estado', '=', 1)
    ->where('proyectos.id', '=', $letra)
    ->orderBy('proyectos.id', 'asc')
    ->get();
    

//TOTAL PROYECTOS.
$cantidad_equipo = DB::table('proyectos')->select('proyectos.cantidad_equipos')
    ->where('proyectos.estado', '=', 1)
    ->where('proyectos.id', '=', $letra)
    ->orderBy('proyectos.id', 'asc')
    ->get();

//extraer los datos de la tabla checklist
$checkList = DB::table('checklist_instalacions')->select('checklist_instalacions.estado_inicio')
    ->join('asignacion_instalacions', 'asignacion_instalacions.id', '=', 'checklist_instalacions.asignacion_instalacion_retiro_id')
    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
    ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
    ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
    ->where('proyectos.id', '=', $letra)
    ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
    ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio, 'AND', 'checklist_instalacions.fecha_fin', '<=', $fechaFin)
    ->get();
//total del checklist
$contador_check = count($checkList);


//extraer los datos de la tabla instalacion
$instalaciontotal = DB::table('instalacions')->select('instalacions.id')
    ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
    ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
    ->where('proyectos.id', '=', $letra)
    ->where('instalacions.dFecha_instalacion', '>=', $fechaInicio, 'AND', '<=', $fechaFin)
    ->orderBy('instalacions.id', 'asc')
    ->get();

//total instalados total tabla
$contador_instalacion_total = count($instalaciontotal);
$totalproyecto =   $cantidad_equipo[0]->cantidad_equipos;
//% Avance planificado
$valor_instalacion = $contador_instalacion_total * 100 / $totalproyecto;
//% Avance ejecutado

// $ejecutadototal = $contador_instalacion * 100 / $totalproyecto;
$ejecutadototal = $contador_check * 100 / $totalproyecto;
//$desviacion = $contador_instalacion - $contador_instalacion_total;
$desviacion = $contador_check - $contador_instalacion_total;
$desviacion2 = $ejecutadototal - $valor_instalacion;

$fechaConsultadaInicio = date('d-m-y', strtotime($fechaInicio));
$fechaConsultadaFin = date('d-m-y', strtotime($fechaFin));

//--------------- Reporte Tiempo de instalaciones ------
//Extraer las fechas de inicio y finalizacion de la tabla checklist
$checkListHora = DB::table('checklist_instalacions')->select('checklist_instalacions.fecha_inicio', 'checklist_instalacions.fecha_fin')
    ->join('asignacion_instalacions', 'asignacion_instalacions.id', '=', 'checklist_instalacions.asignacion_instalacion_retiro_id')
    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
    ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
    ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
    ->where('proyectos.id', '=', $letra)
    ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
    ->whereNotNull('checklist_instalacions.fecha_inicio')
    ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio, 'AND', 'checklist_instalacions.fecha_fin', '<=', $fechaFin)
    ->get();
//Crear Variable Auxiliar
$totalDias = 0;
$promedioM = 0;
$promedioH = 0;
$ContadorFinSemana = 0;
$contador = 0;
$totalH = 0;
if ($contador_check > 0) {
    //Buscar en el rango fechaInicio/fechaFin si hay fines de semana
    foreach ($checkListHora as $item) {
        $begin = new DateTime($item->fecha_inicio);
        $end = new DateTime($item->fecha_fin);
        $end = $end->modify('+1 day');
        $interval = new DateInterval('P1D');
        $daterange = new DatePeriod($begin, $interval, $end);

        foreach ($daterange as $date) {
            //Si hay fines de semana se suman 24 horas al contador
            if (date('l', strtotime($date->format("d-m-Y"))) == 'Sunday' || date('l', strtotime($date->format("d-m-Y"))) == 'Saturday') {
                $ContadorFinSemana += 24;
            }
        }
        //se calcula la diferencia entre las 2 fechas
        $fecha = new Carbon($item->fecha_inicio);
        //Al total de horas se le restan las horas correspondientes a fines de semana 
        $contador = round($fecha->diffInMinutes($item->fecha_fin) / 60) - $ContadorFinSemana;
        if ($contador < 0) {
            $contador *= -1;
        }
        while ($contador != 0) {
            //Si el total de horas es mayor a 9 significa que se trabajo mas de un dia
            //Se suman 9 horas al total de horas de trabajo
            //Y se le restan las 24 horas al contador de horas para eliminar el dia que ya paso
            if ($contador >= 9) {
                $totalH += 9;
                $contador -= 24;
            } else {
                $totalH += $contador;
                $contador = 0;
            }
        }

        //Calcular la diferencia de minutos entre las fechas
        $fecha = new Carbon($item->fecha_fin);
        $totalDias += $fecha->diffInDays($item->fecha_inicio);
        $ContadorFinSemana = 0;
        $contador = 0;
    }
    $totalHoras = $totalH;
    $totalMinutos = $totalH * 60;
    //Calcular los promedios
    $promedioM = round($totalMinutos / $contador_check);
    $promedioH = round($totalHoras / $contador_check);
}

//Reporte Tiempo instalacion por sucursal
$checkListSucursal = DB::table('checklist_instalacions')->select('checklist_instalacions.fecha_inicio', 'checklist_instalacions.fecha_fin', 'checklist_instalacions.Cscui')
    ->join('asignacion_instalacions', 'asignacion_instalacions.id', '=', 'checklist_instalacions.asignacion_instalacion_retiro_id')
    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
    ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
    ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
    ->where('proyectos.id', '=', $letra)
    ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
    ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio, 'AND', 'checklist_instalacions.fecha_fin', '<=', $fechaFin)
    ->select(DB::raw("MIN(checklist_instalacions.fecha_inicio) AS fecha_inicio, MAX(checklist_instalacions.fecha_fin) AS fecha_fin, checklist_instalacions.Cscui"))
    ->groupBy('Cscui')
    ->get();


//Reporte Tasa de efectividad
//Extraer los datos de la tabla asignacion_instalacions
$asignacionInstalacion = DB::table('asignacion_instalacions')->select('asignacion_instalacions.numero_visita')
    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
    ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
    ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
    ->where('proyectos.id', '=', $letra)
    ->where('asignacion_instalacions.estado_asignacion', '=', 'finalizado')
    ->where('asignacion_instalacions.fecha_instalacion', '>=', $fechaInicio, 'AND', 'asignacion_instalacions.fecha_instalacion', '<=', $fechaFin)
    ->get();

//Crear las variables
//Obtener total de visitas
$totalAsignacion = count($asignacionInstalacion);
//Contar las instalaciones exitosas en la primera visita
$contadorPrimeravisita = 0;
foreach ($asignacionInstalacion as $item) {
    if ($item->numero_visita == 1) {
        $contadorPrimeravisita += 1;
    }
}
//Obtener el porcentaje de efectividad
$tasaDeInstalacion = 0;
   if($totalAsignacion > 0){
       $tasaDeInstalacion = round(($contadorPrimeravisita * 100) / $totalAsignacion);
   }

//--------------------- Reporte de Status de proyecto por region ---------------
//Obtener nombre de las regiones
$reporteRegion = DB::table('instalacions')->select('instalacions.sRegion')
    ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
    ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
    ->where('proyectos.id', '=', $letra)
    ->orderBy('instalacions.sRegion')
    ->distinct('instalacions.sRegion')
    ->get();

$reporteRegion2 = DB::table('instalacions')->select('instalacions.sRegion')
    ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
    ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
    ->where('proyectos.id', '=', $letra)
    ->orderBy('instalacions.sRegion')
    ->get();
$totalProyectoRegion = Count($reporteRegion2);

   //Obtener nombre de las regiones y el estado de la instalacion
   $reporteRegionAux = DB::table('instalacions')->select('instalacions.sRegion', 'instalacions.sEstado_instalacion', 'checklist_instalacions.observacion', 'checklist_instalacions.id')
   ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
   ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
   ->join('asignacion_instalacions', 'asignacion_instalacions.lista_instalacion_id', '=', 'instalacions.id')
   ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
   ->where('proyectos.id', '=', $letra)
   ->whereNotNull('checklist_instalacions.observacion')
   ->orderBy('instalacions.sRegion')
   ->get();
    
//----------------------- Reporte Accesorios ------------------------------------ 
   //Obtener datos de la tabla instalacions
   $reporteAccesorios = DB::table('instalacions')->select(
       'instalacions.sBandeja_adicional',
       'instalacions.sMueble',
       'instalacions.sSD',
       'instalacions.sCable_poder',
       'instalacions.sCable_red',
       'instalacions.sKit_lector'
   )
       ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
       ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
       ->where('proyectos.id', '=', $letra)
       ->get();

   //Contar los accesorios solicitados
   $contadorInstalacionSi = 0;
   $contadorBandejaI = 0;
   $contadorCableRedI = 0;
   $contadorCablePoderI = 0;
   $contadorMuebleI = 0;
   $contadorLectorI = 0;
   $contadorSDI = 0;

   foreach ($reporteAccesorios as $item) {
       if ($item->sBandeja_adicional == 'si' || $item->sBandeja_adicional == 'Si' || $item->sBandeja_adicional == '1') {
           $contadorInstalacionSi += 1;
           $contadorBandejaI += 1;
       }
       if ($item->sMueble == 'si' || $item->sMueble == 'Si' || $item->sMueble == '1') {
           $contadorInstalacionSi += 1;
           $contadorMuebleI += 1;
       }
       if ($item->sSD == 'si' || $item->sSD == 'Si' || $item->sSD == '1') {
           $contadorInstalacionSi += 1;
           $contadorSDI += 1;
       }
       if ($item->sCable_poder == 'si' || $item->sCable_poder == 'Si' || $item->sCable_poder == '1') {
           $contadorInstalacionSi += 1;
           $contadorCablePoderI += 1;
       }
       if ($item->sCable_red == 'si' || $item->sCable_red == 'Si' || $item->sCable_red == '1') {
           $contadorInstalacionSi += 1;
           $contadorCableRedI += 1;
       }
       if ($item->sKit_lector == 'si' || $item->sKit_lector == 'Si' || $item->sKit_lector == '1') {
           $contadorInstalacionSi += 1;
           $contadorLectorI += 1;
       }
   }

   //Obtener datos tabla checklist
   $checklistAccesorios = $checkListHora = DB::table('checklist_instalacions')->select(
       'checklist_instalacions.CsBandeja_adicional',
       'checklist_instalacions.CsMueble',
       'checklist_instalacions.CsSD',
       'checklist_instalacions.CsCable_poder',
       'checklist_instalacions.CsCable_red',
       'checklist_instalacions.CsKit_lector'
   )
       ->join('asignacion_instalacions', 'asignacion_instalacions.id', '=', 'checklist_instalacions.asignacion_instalacion_retiro_id')
       ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
       ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
       ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
       ->where('proyectos.id', '=', $letra)
       ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
       ->whereNotNull('checklist_instalacions.fecha_inicio')
       ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio, 'AND', 'checklist_instalacions.fecha_fin', '<=', $fechaFin)
       ->get();

   //Contar los accesorios solicitados
   $contadorCheckSi = 0;
   $contadorBandeja = 0;
   $contadorCableRed = 0;
   $contadorCablePoder = 0;
   $contadorMueble = 0;
   $contadorLector = 0;
   $contadorSD = 0;

   foreach ($checklistAccesorios as $item) {
       if ($item->CsBandeja_adicional == 'si' || $item->CsBandeja_adicional == 'Si' || $item->CsBandeja_adicional == '1') {
           $contadorCheckSi += 1;
           $contadorBandeja += 1;
       }
       if ($item->CsMueble == 'si' || $item->CsMueble == 'Si' || $item->CsMueble == '1') {
           $contadorCheckSi += 1;
           $contadorMueble += 1;
       }
       if ($item->CsSD == 'si' || $item->CsSD == 'Si' || $item->CsSD == '1') {
           $contadorCheckSi += 1;
           $contadorSD += 1;
       }
       if ($item->CsCable_poder == 'si' || $item->CsCable_poder == 'Si' || $item->CsCable_poder == '1') {
           $contadorCheckSi += 1;
           $contadorCablePoder += 1;
       }
       if ($item->CsCable_red == 'si' || $item->CsCable_red == 'Si' || $item->CsCable_red == '1') {
           $contadorCheckSi += 1;
           $contadorCableRed += 1;
       }
       if ($item->CsKit_lector == 'si' || $item->CsKit_lector == 'Si' || $item->CsKit_lector == '1') {
           $contadorCheckSi += 1;
           $contadorLector += 1;
       }
   }
  //---------------------- Crear una lista con los datos recopilados ---------------------
  $listaAccesorios = [
   "Bandeja Adicional"."-".$contadorBandeja."-".$contadorBandejaI,
   "Mueble"."-".$contadorMueble."-".$contadorMuebleI,
   "Memoria SD"."-".$contadorSD."-".$contadorSDI,
   "Cable de Poder"."-".$contadorCablePoder."-".$contadorCablePoderI,
   "Cable de Red"."-".$contadorCableRed."-".$contadorCableRedI,
   "Kit Lector"."-".$contadorLector."-".$contadorLectorI
   
];
$coleccion = collect($listaAccesorios);
 //creamos variable de fecha para asignarla al pdf de informe
 $date = Carbon::now();


 $crear_url_informe = new App\informes();
 $crear_url_informe->fecha = $date->format('yy-m-d');

 $date = $date->format('d-m-Y');

 //creamos el proyecto a guardar

 $crear_url_informe->url_pdf = $date."Informes.pdf";
 $crear_url_informe->timestamps = false;
 $crear_url_informe->save();



//Devolver Datos a la vista
  \PDF::setOptions(['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true])
   ->loadView('informes.informe_pdf' , compact(
       'totalProyectoRegion',
       'validacion',
       'proyectos',
       'cantidad_equipo',
       'contador_instalacion_total',
       'valor_instalacion',
       'contador_check',
       'ejecutadototal',
       'desviacion',
       'desviacion2',
       'fechaInicio',
       'fechaFin',
       'nombres',
       'promedioM',
       'promedioH',
       'checkListSucursal',
       'totalAsignacion',
       'contadorPrimeravisita',
       'tasaDeInstalacion',
       'reporteRegion',
       'reporteRegionAux',
       'contadorCheckSi',
       'contadorInstalacionSi',
       'coleccion'
   ))
   ->save(storage_path('app/public/pdfInformes/') . $date.'Informes.pdf')
   ->stream();




   $para      = 'ariel@infosoluciones.cl,guillermo.andresv98@gmail.com';
   $titulo    = 'Informe Diario';
   $mensaje   = 'Adjuntamos link de Descarga'."\n"."http://35.232.42.155/aya/rendicion/donwload5/09-11-2020Informes.pdf   ";
   $cabeceras = 'From:  Aya' . "\r\n" .
       'Reply-To: webmaster@example.com' . "\r\n" .
       'X-Mailer: PHP/' . phpversion();
   
 
   if(mail($para, $titulo, $mensaje, $cabeceras))
   {
          echo "Mail sent...";    
   }
   else
   {
          echo "Mail not sent";   
   }

   return "Informe Creado con Exito";
        
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
