<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

Route::match(array('GET', 'POST'), 'informesPdf', 'api\GenerarPDFCorreosController@create');
Route::match(array('GET', 'POST'), 'fotoscorreo', 'api\ConsumiImagenesInstalaccionController@crearimagenesweb');

Route::match(array('GET', 'POST'), 'enviarreporte', 'reportes\reportesController@enviarreporte');
Route::match(array('GET', 'POST'), 'crarimagen', 'reportes\reportesController@crearimagen')->name('creando.imagen');;

Route::group(["middleware" => "apikey.validate"], function () {

    Route::get('ver_solicitudes_api', 'api\a_solicitudesController@index');

    Route::match(array('GET', 'POST'), 'crear_solicitud_api', 'api\a_solicitudesController@create');

    Route::match(array('GET', 'POST'), 'crear_instalaccion_api', 'api\api_intalacionesController@create');
    //para importar datos 
    Route::match(array('GET', 'POST'), 'crear_instalaccion_api_sin_restriccion', 'api\api_intalacionesController@create_sin_restriccion');


    Route::match(array('GET', 'POST'), 'crear_retiro_api', 'api\api_retiroController@create');


    Route::match(array('GET', 'POST'), 'loginm', 'api\api_loginController@create');

    //subir las fotos de instalacion y retiro
    Route::match(array('GET', 'POST'), 'subirfotosInstalacion', 'api\ConsumiImagenesInstalaccionController@create');
    Route::match(array('GET', 'POST'), 'subirfotosRetiro', 'api\ConsumirImagenRetiroController@create');

    Route::match(array('GET', 'POST'), 'subirfotosCapacitaciones', 'api\ConsumiImagenesInstalaccionController@create_capacitacion');


    Route::match(array('GET', 'POST'), 'subirfotosResumenRetiro', 'api\ConsumirImagenRetiroController@resumen_retiro');


    //api que consumira el  informe_datos_pdf menu principal 
    //  Route::match(array('GET','POST'),'informesPdf', 'menus\menu_principal@function_informedatosPDF');




});
