<!DOCTYPE html>
<html lang="es">
<script src="{{ asset('js/chart.min.js') }}"></script>

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Document</title>
</head>

<body>
    <canvas id="pie-chart" width="800" height="450"></canvas>
    <canvas id="myChart" width="800" height="450"></canvas>
</body>
<script>
    var arrayDatos = @json($grafico1);
    arrayDatos.forEach(function(data) {
        console.log(data);
        var xValues = data.modelos_instalados;
        backgroundColor = [];
        for(i=0;i<xValues.length;i++){
            const r = Math.floor(Math.random()*255);
            const g = Math.floor(Math.random()*255);
            const b = Math.floor(Math.random()*255);
            backgroundColor.push('rgba('+r+','+g+','+b+')');
        }
        var yValues = data.modelos_cantidad;
        new Chart(document.getElementById("pie-chart"), {
            type: 'pie',
            data: {
                labels: xValues,
                datasets: [{
                    label: "Population (millions)",
                    backgroundColor : backgroundColor,
                    //backgroundColor: ["#3e95cd", "#8e5ea2", "#3cba9f", "#e8c3b9", "#c45850"],
                    data: yValues,
                    datosx: xValues,
                }]
            },
            options: {
                animation: false,
                showTooltips: true,
                title: {
                    display: false,
                    text: "a",
                },
                legend: {
                    display: false,
                },
                animation: {
                    duration: 500,
                    easing: "easeOutQuart",
                    onComplete: function() {
                        var ctx = this.chart.ctx;
                        ctx.textAlign = 'center';
                        ctx.textBaseline = 'bottom';
                        this.data.datasets.forEach(function(dataset) {
                            for (var i = 0; i < dataset.data.length; i++) {
                                var model = dataset._meta[Object.keys(dataset._meta)[0]].data[i]._model,
                                    total = dataset._meta[Object.keys(dataset._meta)[0]].total,
                                    mid_radius = model.innerRadius + (model.outerRadius - model.innerRadius) / 2,
                                    start_angle = model.startAngle,
                                    end_angle = model.endAngle,
                                    mid_angle = start_angle + (end_angle - start_angle) / 2;
                                var x = mid_radius * Math.cos(mid_angle);
                                var y = mid_radius * Math.sin(mid_angle);
                                ctx.fillStyle = '#fff';
                                if (i == 3) { // Darker text color for lighter background
                                    //ctx.fillStyle = '#444';
                                }
                                var porcentaje = (dataset.data[i]);
                                ctx.font = Chart.helpers.fontString(25, 'bold', Chart.defaults.global.defaultFontFamily);
                                var percent = String(porcentaje);
                                if (percent != 0) {
                                    ctx.fillText(dataset.data[i] + " " + dataset.datosx[i].toUpperCase(), model.x + x, model.y + y);
                                }
                            }
                        });
                    }
                }
            }
        });
    })
    var arrayDatos2 = @json($grafico2);
    arrayDatos2.forEach(function(data2) {
        console.log(data2);
        var xValues = data2.coneccion_instalados;
        var yValues = data2.coneccion_cantidad;
        new Chart(document.getElementById("myChart"), {
            type: 'pie',
            data: {
                labels: xValues,
                datasets: [{
                    label: "Population (millions)",
                    backgroundColor: ["#3e95cd", "#8e5ea2", "#3cba9f", "#e8c3b9", "#c45850"],
                    data: yValues,
                    datosx: xValues,
                }]
            },
            options: {
                animation: false,
                showTooltips: true,
                title: {
                    display: false,
                    text: "a",
                },
                legend: {
                    display: false,
                },
                animation: {
                    duration: 500,
                    easing: "easeOutQuart",
                    onComplete: function() {
                        var ctx = this.chart.ctx;
                        ctx.textAlign = 'center';
                        ctx.textBaseline = 'bottom';
                        this.data.datasets.forEach(function(dataset) {
                            for (var i = 0; i < dataset.data.length; i++) {
                                var model = dataset._meta[Object.keys(dataset._meta)[0]].data[i]._model,
                                    total = dataset._meta[Object.keys(dataset._meta)[0]].total,
                                    mid_radius = model.innerRadius + (model.outerRadius - model.innerRadius) / 2,
                                    start_angle = model.startAngle,
                                    end_angle = model.endAngle,
                                    mid_angle = start_angle + (end_angle - start_angle) / 2;
                                var x = mid_radius * Math.cos(mid_angle);
                                var y = mid_radius * Math.sin(mid_angle);
                                ctx.fillStyle = '#fff';
                                if (i == 3) { // Darker text color for lighter background
                                    ctx.fillStyle = '#444';
                                }
                                var porcentaje = (dataset.data[i]);
                                ctx.font = Chart.helpers.fontString(25, 'bold', Chart.defaults.global.defaultFontFamily);
                                var percent = String(porcentaje);
                                if (percent != 0) {
                                    ctx.fillText(dataset.data[i] + " " + dataset.datosx[i].toUpperCase(), model.x + x, model.y + y);
                                }
                            }
                        });
                    }
                }
            }
        });
    })
</script>
<script src="{{ asset('js/jquery-3.4.1.min.js') }}"></script>
<!--GUARDAR LAS FOTOS-->
<script>
    setTimeout(function() {
        $(document).ready(function() {
            let datos1 = [];
            arrayDatos.forEach(function(data) {
                var canvas = document.getElementById('pie-chart');
                nombreGuardar = "f1_modelosServicios_" + data.fecha_actual + "pro" + Math.floor((Math.random() * 10) + 1);
                data = {
                    "url": canvas.toDataURL(),
                    "nombre": nombreGuardar,
                    "fecha": data.fecha_actual,
                    "total": data.total,
                    "s_revisar" : data.s_revisar,
                    "s_solicitudRepuesto" : data.s_solicitudRepuesto,
                    "s_respuestoTransito" : data.s_respuestoTransito,
                    "s_finalizado" : data.s_finalizado,
                }
                datos1.push(data);
            })
            let datos2 = [];
            arrayDatos2.forEach(function(data) {
                var canvas = document.getElementById('myChart');
                nombreGuardar = "f2_coneccionServicios_" + data.fecha_actual + "pro" + Math.floor((Math.random() * 10) + 1);
                data = {
                    "url": canvas.toDataURL(),
                    "nombre": nombreGuardar,
                    "fecha": data.fecha_actual,
                    "total": data.total,
                }
                datos2.push(data);
            })
            console.log(datos1)
            console.log(datos2)
            $.ajax({
                type: 'post',
                url: "{{ route('reporte_servicios') }}",
                data: { 
                    'data1' : datos1,
                    'data2' : datos2,
                    '_token': '{{ csrf_token() }}',
                },
                success: function(data) {
                    console.log(data);
                },
                error: function(xhr, status) {
                    alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
                }
            })
        })
    }, 3000);
</script>