@extends('menu/menu')
{{-- <script src="https://ajax.aspnetcdn.com/ajax/jQuery/jquery-3.4.1.min.js%22%3E</script> --}}
<script src="{{ asset('js/jquery-3.4.1.min.js') }}" ></script>
{{-- <link  href="{{ asset('css/a&a_style.css') }}" href="a&a_style.css" rel="stylesheet" type="text/css"> --}}

@section('content')

@if ( session('mensaje') )
    <div class="alert alert-success">{{ session('mensaje') }}</div>
@endif

<div class="container mt-5">
  <div class="title-vista mt-4">Resumen Retiro</div>
</div>

<form action="{{route('go.filtrar_pdf__resumen_retiro')}}" method="get">
  @csrf
  <div class="container mt-4">
    <div class="seccion-filtro">Filtrar por</div> 
    <hr class="separador">

    <div class="row">
      <!--AQUI SE CARGA EL SELECT DE PROYECTO-->
      <div class="col-sm-3 form-group">
        <label for="proyectos">Proyecto</label>
        <select id="proyectos" name="proyectos" class="custom-select mayuscula">
          <option value="" selected>seleccionar</option>
          @if(!empty($proyectos))
          @foreach ($proyectos  as $los_datos3)
          @if($los_datos3->id_proyecto == $proyectosR)
            <option selected value="{{$los_datos3->id_proyecto}}">{{$los_datos3->nombre." (".$los_datos3->razon_social.")" }}  </option>
          @else
            <option value="{{$los_datos3->id_proyecto}}">{{$los_datos3->nombre." (".$los_datos3->razon_social.")" }}  </option>
          @endif 
          @endforeach
          @endif 
        </select>
      </div>

      <!--AQUI SE CARGA EL SELECT DE REGION-->
      <div class="col-sm-3 form-group">
        <label for="region">Ciudad</label>
        <select  id="region" name="region" class="custom-select mayuscula">
          <option  selected disabled>seleccionar</option>
          <option value="" selected>Todos</option>
          @if (!empty($ciudad))
          @foreach ($ciudad as $data)
          @if ($data->ciudad != null)
          @if($data->ciudad == $ciudades)
            <option selected value="{{ $data->ciudad }}">{{ucfirst(strtolower($data->ciudad))}} </option>
          @else
            <option value="{{ $data->ciudad }}">{{ucfirst(strtolower($data->ciudad))}} </option>
          @endif
          @endif
          @endforeach
          @endif
        </select>
      </div>

      <!--AQUI SE CARGA EL SELECT DE COMUNA-->
      <div class="col-sm-3 form-group">
        <label for="comuna">Comuna</label>
        <select id="comuna" name="comuna" class="custom-select mayuscula">
          <option  selected disabled>seleccionar</option>
          <option value="" selected>Todos</option>
          @if (!empty($comunas))
          @foreach ($comunas as $data2)
          @if ($data2->comuna != null)                    
          @if( $data2->comuna === $comuna)
            <option selected value="{{ $data2->comuna }}">{{ucfirst(strtolower($data2->comuna))}}</option>
          @else
            <option value="{{ $data2->comuna }}">{{ucfirst(strtolower($data2->comuna))}}</option>
          @endif
          @endif
          @endforeach
          @endif
        </select>
      </div>

      <!--AQUI SE CARGA EL SELECT DE direccion-->
      <div class="col-sm-3 form-group">
        <label for="direccion">Direccion</label>
        <select  class="custom-select mb-3" id="direccion" name="direccion">
          <option selected value="" >seleccionar</option>
          <option selected value="" >Todos</option>
          @if(!empty($direccion))
          @foreach($direccion as $direcciones)
          @if ($direcciones->direccion != null)  
          @if($direcciones->direccion == $direccionR)
            <option selected value="{{$direcciones->direccion}}">{{$direcciones->direccion}}</option>
          @else
            <option  value="{{$direcciones->direccion}}">{{$direcciones->direccion}}</option>
          @endif
          @endif
          @endforeach
          @endif
        </select>
      </div>

      <div class="col-sm-3 form-group">
        <label for="Serie">CUI sucursal</label>
        <input type="" class="form-control" id="Serie" name="Serie" placeholder="Nº de CUI">
      </div> 
    </div>
    <!-- FIN BARRA DE BUSQUEDA -->
  </div>

  <div class="container text-center my-4">
    <button type="submit" class="btn btn-prim px-sm-5">Buscar</button>
  </div>
</form>


<div class="container mt-5 p-0">
  <ul class="nav bg-export">
    <li class="clas-item">
      <a class="btn btn-ter" target="_blank" href="{{route('go.excel_Resumenretiro') ?? ''}}">Exportar excel
        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16" class="bi bi-file-earmark-excel-fill">
          <path d="M9.293 0H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V4.707A1 1 0 0 0 13.707 4L10 .293A1 1 0 0 0 9.293 0zM9.5 3.5v-2l3 3h-2a1 1 0 0 1-1-1zM5.884 6.68 8 9.219l2.116-2.54a.5.5 0 1 1 .768.641L8.651 10l2.233 2.68a.5.5 0 0 1-.768.64L8 10.781l-2.116 2.54a.5.5 0 0 1-.768-.641L7.349 10 5.116 7.32a.5.5 0 1 1 .768-.64z"></path>
        </svg>
      </a> 
    </li>
  </ul>
</div>


<!-- TABLA DE RESULTADOS DE BUSQUEDA -->
<div class="container table-responsive p-sm-0 mb-5">
  <table class="table table-bordered table-responsive-lg table-striped table-hover" id="gridData">
    <!-- ENCABEZADO -->
    <thead class="color-head">
      <tr>
        <th class="th-head border-th separador-v" colspan="1">Fecha de resumen</th>
        <th class="th-head border-th separador-v" colspan="1">Equipos embalados</th>
        <th class="th-head border-th separador-v" colspan="1">Equipos sin embalados</th>
        <th class="th-head border-th separador-v" colspan="1">Cantidad de bultos</th>
        <th class="th-head border-th separador-v" colspan="1">Cliente</th>
        <th class="th-head border-th separador-v" colspan="1">Comuna</th>
        <th class="th-head border-th separador-v" colspan="1">Dirección</th>
        <th class="th-head border-th separador-v" colspan="1">CUI</th>
        <th class="th-head border-th separador-v" colspan="1">PDF</th>
      </tr>
    </thead>
    <!-- FIN ENCABEZADO -->

    <!-- RESULTADOS -->
    <tbody id="myTable">
      @if(!empty($rutapdf))
      @foreach ($rutapdf as $datos)
      <tr>
        <td class="td-val">{{Carbon\Carbon::createFromDate($datos->fecha_resumen)->format('d-m-Y')}}</td>
        <td class="td-val">{{$datos->suma_embalados}}</td>
        <td class="td-val">{{$datos->suma_sinembalar}}</td>
        <td class="td-val">{{$datos->cantidad_bultos}}</td>
        <td class="td-val">{{$datos->cliente}}</td>
        <td class="td-val">{{$datos->comuna}}</td>
        <td class="td-val"> {{$datos->direccion}}</td> 
        <td class="td-val">{{$datos->cuisucursal}}</td>                                               
        <td class="td-val text-center">
          <a class="btn-icon btn-icon-dd" href="{{route('go.donwload4',$datos->url_pdf)}}">
            <span class="material-icons-round">picture_as_pdf</span>
          </a>
        </td>
      </tr>
      @endforeach
      @endif
    </tbody>
    <!-- FIN RESULTADOS -->
  </table>

    @if(!empty($retiros))
    {{-- {{$solicitudes->Links()}} --}}
    {{ $retiros->appends(request()->query())->links() }}
    @endif

</div>
    
  <!-- FIN TABLA DE RESULTADOS DE BUSQUEDA -->
  </div>
  @endsection

  <script>
    $(document).ready(function(){
      $("#cui").on("keyup", function() {
      var value = $(this).val().toLowerCase();
      $("#myTable tr").filter(function() {
        $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
      });
      });
    });
    </script>


  <script>

    $(document).ready(function(){
  
  
      $("#region").change(function(){
             ciudad = $('select[id=region]').val();
             var _token = $('input[name="_token"]').val();
  
             $.ajax({
                    method:"POST",
  
                    url:"{{ route('buscarComunasResumenRetiro') }}",
  
                    data: { 'ciudad': ciudad,  _token:_token},
  
                success: function(data) {
                  $("#comuna").empty();
                  $("#direccion").empty();
                  $("#sucursal").empty();
                  $("#comuna").append('<option value="">Seleccionar</option>');
                  $("#direccion").append('<option value="">Seleccionar</option>');
                  $("#sucursal").append('<option value="">Seleccionar</option>');
                  $(data).each(function(i, v){ // indice, valor
                    //if(v.sComuna != null || v.sComuna != "null"  ){ 
                        $("#comuna").append('<option value="' + v.comuna + '">' + v.comuna + '</option>');
                          })
                   // }
  
                  },
  
                error: function(xhr, status) {
                    alert('Disculpe, ha ocurrido un problema, intente mas tarde');
                 }
  
            });
    });
    $("#comuna").change(function(){
      comuna = $('select[id=comuna]').val();
             var _token = $('input[name="_token"]').val();
  
  
  
             $.ajax({
                    method:"POST",
  
                    url:"{{ route('buscarDireccionResumenRetiro') }}",
  
                    data: { 'comuna': comuna,  _token:_token},
  
                success: function(data) {
                  $("#direccion").empty();
                  $("#sucursal").empty();
                  $("#direccion").append('<option value="">Seleccionar</option>');
                  $("#sucursal").append('<option value="">Seleccionar</option>');
  
                  $(data).each(function(i, v){ // indice, valor
                    //if(v.sdireccion != null || v.sdireccion != "null"  ){ 
                        $("#direccion").append('<option value="' + v.direccion + '">' + v.direccion + '</option>');
                          })
                   // }
  
                  },
  
                error: function(xhr, status) {
                    alert('Disculpe, ha ocurrido un problema, intente mas tarde');
                 }
  
            });
    });
  

  
      
  });

  function actualizar_regiones(){
           var _token = $('input[name="_token"]').val();

           $.ajax({
                  method:"GET",

                  url:"{{ route('go.actualizarregiones') }}",

                  data: {   _token:_token},

              success: function(data) {
                    alert("proceso Completado");
                    location.reload();

                },

              error: function(xhr, status) {
                  alert('Disculpe, ha ocurrido un problema, intente mas tarde');
               }

          });

}
  
      </script>
