@extends('menu/menu')
{{-- <script src="https://ajax.aspnetcdn.com/ajax/jQuery/jquery-3.4.1.min.js</script> --}}
<script src="{{ asset('js/jquery-3.4.1.min.js') }}"></script>
<link href="{{ asset('css/a&a_style.css') }}" href="a&a_style.css" rel="stylesheet" type="text/css">

@section('content')

@if ( session('mensaje') )
<div class="alert alert-success">{{ session('mensaje') }}</div>
@endif


<div class="container mt-5">
    <div class="title-vista mt-4">Actualizar datos</div>
</div>

<form action="{{route('updateProyecto')}}" method="post" enctype="multipart/form-data">
    @csrf
    <!-- BARRA DE BUSQUEDA -->
    <div class="container mt-5 mb-5">


        <!-- Fila 1 Detalle de cliente ------------------------------------------------------>
        <div class="seccion-filtro">Detalle de cliente</div>
        <hr class="separador">

        <div class="row">
            <div class="col-sm-4 form-group">
                <label for="nombre_proyecto">Nombre del cliente</label>
                <input type="text" value="{{Crypt::encryptString($nombrecliente[0]->id ?? '')}}" name="proyectoid" style="display: none">
                <input type="text" class="form-control mayuscula" value="{{$razonSocialCliente}}" disabled>
            </div>
            <div class="col-sm-4 form-group">
                <label for="nombre_proyecto">Nombre del proyecto</label>
                <input type="" class="form-control mayuscula" id="" name="nombre_proyecto" value="{{$nombreProyecto}}" disabled>
            </div>
            <div class="col-sm-4 form-group">
                <label for="nombre_proyecto">Fecha Inicio</label>
                <input type="date" class="form-control mayuscula" id="fechaInicioProyecto" name="fechaInicioProyecto" value="{{Carbon\Carbon::createFromDate($nombrecliente[0]->fecha_inicio ?? '')->format('Y-m-d')}}">
            </div>
            <div class="col-sm-4 form-group">
                <label for="nombre_proyecto">Fecha Final</label>
                <input type="date" class="form-control mayuscula" id="fechaFinProyecto" name="fechaFinProyecto" value="{{Carbon\Carbon::createFromDate($nombrecliente[0]->fecha_termino ?? '')->format('Y-m-d')}}">
            </div>
            <div class="col-sm-4 form-group">
                <label for="nombre_proyecto">Logo
                    @if ($nombrecliente[0]->url_logo != "")
                    <a data-target="#modal_foto" data-toggle="modal" style="cursor: pointer; color:#BF4E2B;">(Ver logotipo asociado)</a>
                    @endif
                </label>
                <input type="file" accept="image/png,image/jpeg" class="form-control-file mt-2" id="cargafoto1" name="cargafoto1">
            </div>
        </div>


        <!-- Fila 2 Datos Proyectos ------------------------------------------------------>
        <div class="seccion-filtro">Datos Proyectos</div>
        <hr class="separador">

        <div class="row">
            <div class="col-sm-3 form-group">
                <label for="capacitacion">Capacitacion</label>
                <select class="custom-select mayuscula" name="capacitacion" id="capacitacion">
                    <option value="">Seleccionar</option>
                    @if ($nombrecliente[0]->capacitacion == "si" || $nombrecliente[0]->capacitacion =="Si" )
                    <option value="si" selected>si</option>
                    <option value="no">no</option>
                    @else
                    <option value="si">si</option>
                    <option value="no" selected>no</option>
                    @endif
                </select>
            </div>
            <div class="col-sm-3 form-group">
                <label for="cantidad_equipos">Cantidad de equipos</label>
                <input type="text" class="form-control mayuscula" id="cantidad_equipos" placeholder="Cantidad de equipos" name="cantidad_equipos" value="{{$nombrecliente[0]->cantidad_equipos}}" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;">
            </div>
            <div class="col-sm-3 form-group">
                <label for="">Valor usuario adicional (UF)</label>
                <input type="text" class="form-control mayuscula" id="costo_usuarioadicional" placeholder="Valor por usuario adicional UF" name="costo_usuarioadicional" value="{{$nombrecliente[0]->costo_usuarioadicional}}" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;">
            </div>
            <div class="col-sm-3 form-group">
                <label for="">Valor Kilometro (CLP)</label>
                <input type="text" class="form-control mayuscula" id="valor_kilometros" placeholder="$300" name="valorKilometro" value="{{$nombrecliente[0]->valor_kilometro}}" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;">
            </div>
        </div>

        <!-- Fila 3 Botón ------------------------------------------------------>
        <div class="row">
            <div class="col-sm-12 my-5 text-center">
                <button type="button" class="btn btn-prim w-25" title="modificar" data-toggle="modal" data-target="#modalAnadirVisita">Añadir visita</button>
            </div>
        </div>

        <!-- Fila 4 Tabla ------------------------------------------------------>
        <table class="table table-sm table-bordered table-responsive-lg table-striped table-hover mb-5">
            <!--ENCABEZADO-->
            <thead>
                <tr>
                    <th class="container-2">Numero de visita</th>
                    <th class="container-1">Descripción</th>
                    <th class="container-1">Fecha de creación</th>
                    <th>Acción</th>
                </tr>
            </thead>

            <!--RESULTADOS-->
            <tbody>
                @if(!empty($datoscostos ))
                @foreach ($datoscostos as $los_datos)
                <tr>
                    <td>{{$los_datos->numero_visita ?? ''}}</td>
                    <td>{{$los_datos->costo_descripcion}}</td>
                    <td>{{Carbon\Carbon::createFromDate($los_datos->fecha_registro)->format('d-m-Y')}}</td>
                    <td class="text-center">
                        <a title="modificar" role="button" href="#" class="btn-icon btn-icon-dd ver_historial_instalacion editarvisita" data-id="{{$los_datos->id}}"><span class="material-icons-round">edit</span></a>
                    </td>
                </tr>
                @endforeach
                @endif
            </tbody>
        </table>

        <!-- Fila 5 Costo ------------------------------------------------------>
        <div class="seccion-filtro">Datos Proyectos</div>
        <hr class="separador">
        <div class="row">
            <div class="col-sm-6 form-group">
                <label for="">Costo</label>
                <input type="text" class="form-control mayuscula" id="" value="{{$nombrecliente[0]->costo_proyecto}}" placeholder="$10000" name="costo_proyecto">
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12 text-right">
                <button class="btn btn-prim w-25" type="submit">GUARDAR</button>
                <button class="btn btn-secundario w-25 btn-addBody" type="" style="display: none;">Añadir DIV al BODY</button>
            </div>
        </div>
    </div>
</form>


<!-- Modal  costos-->
<div class="modal" id="modalcostos" data-backdrop="static">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">

            <div class="modal-header">
                <div class="seccion-modal">CAMBIAR COSTOS</div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <hr class="separador ml-4 mr-4">

            <div class="modal-body">
                <div class="container">

                    <div class="row">
                        <!-- Fila 3 ------------------------------------------------------>
                        @if($nombreProyecto == "SERVICIOS")
                        <div class="form-group col-sm-6">
                            <label for="costo_otros">Valor</label>
                            <input type="text" class="monto form-control mayuscula" id="costo_otros" value="" placeholder="" name="costo_otros" maxlength="9" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" onkeyup="sumar();">
                        </div>
                        @else
                        <div class="form-group col-sm-6">
                            <label for="costo_habilitacion">Habilitación</label>
                            <input type="text" class="monto form-control mayuscula" id="costo_habilitacion2" value="" placeholder="" name="costo_habilitacion" maxlength="9" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" onkeyup="sumar();">
                        </div>
                        <div class="form-group col-sm-6">
                            <label for="costo_instalacion">Instalación accesorios</label>
                            <input type="text" class="monto form-control mayuscula" id="costo_instalacion2" value="" placeholder="" name="costo_instalacion" maxlength="9" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" onkeyup="sumar();">
                        </div>
                        <div class="form-group col-sm-6">
                            <label for="costo_capacitacion">Capacitación</label>
                            <input type="text" class="monto form-control mayuscula" id="costo_capacitacion2" value="" placeholder="" name="costo_capacitacion" maxlength="9" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" onkeyup="sumar();">
                        </div>
                        <div class="form-group col-sm-6">
                            <label for="costo_retiro">Retiro</label>
                            <input type="text" class="monto form-control mayuscula" id="costo_retiro2" value="" placeholder="" name="costo_retiro" maxlength="9" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" onkeyup="sumar();">
                        </div>
                        <div class="form-group col-sm-6">
                            <label for="costo_actualizacion">Actualización firmware</label>
                            <input type="text" class="monto form-control mayuscula" id="costo_actualizacion2" value="" placeholder="" maxlength="9" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" name="costo_actualizacion" onkeyup="sumar();">
                        </div>
                        <div class="form-group col-sm-6">
                            <label for="costo_cortesia">Cortesía</label>
                            <input type="text" class="monto form-control mayuscula" id="costo_cortesia2" value="" placeholder="" maxlength="9" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" name="costo_cortesia" onkeyup="sumar();">
                        </div>
                        <div class="form-group col-sm-6">
                            <label for="costo_garantia">Garantía</label>
                            <input type="text" class="monto form-control mayuscula" id="costo_garantia2" value="" placeholder="" name="costo_garantia" maxlength="9" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" onkeyup="sumar();">
                        </div>
                        <div class="col-sm-6 form-group">
                            <label for="costo_mantenimiento">Mantenimiento</label>
                            <input type="text" class="monto2 form-control mayuscula" id="costo_mantenimiento2" placeholder="UF" name="costo_mantenimiento" maxlength="9" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" onkeyup="sumar2();">
                        </div>
                        <div class="form-group col-sm-6">
                            <label for="costo_otros">Otros</label>
                            <input type="text" class="monto form-control mayuscula" id="costo_otros" value="" placeholder="" name="costo_otros" maxlength="9" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" onkeyup="sumar();">
                        </div>
                        @endif
                    </div>
                    <input type="hidden" class="form-control" id="id_visita" value="" readonly>
                    <input type="hidden" value="{{Crypt::encryptString($nombrecliente[0]->id ?? '')}}" id="idProyecto">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-prim w-25" id="cambiarcostos">Guardar</button>
                <button type="button" class="btn btn-secundario w-25" data-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>

<!--MODAL AÑADIR VISITA----------------------------------------->
<div class="modal fade" id="modalAnadirVisita" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <form action="{{route('go.agregar_visita')}}" method="post">
            <div class="modal-content">
                <div class="modal-header">
                    <div class="seccion-modal">NUEVA VISITA</div>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <hr class="separador ml-4 mr-4">
                <div class="modal-body">
                    @csrf
                    <div class="container">
                        <div class="row">
                            @if($nombreProyecto == "SERVICIOS")
                            <div class="form-group col-sm-6">
                                <label for="costo_otros">Valor</label>
                                <input type="text" class="monto form-control mayuscula" id="costo_otros" value="" placeholder="UF" name="costo_otros" maxlength="9" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" onkeyup="sumar();">
                            </div>
                            @else
                            <!-- Costos primera visita -->
                            <div class="col-sm-6 form-group">
                                <label for="costo_habilitacion">Habilitación</label>
                                <input type="text" class="monto2 form-control mayuscula" id="costo_habilitacion" placeholder="UF" name="costo_habilitacion" maxlength="9" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" onkeyup="sumar2();">
                            </div>
                            <div class="col-sm-6 form-group">
                                <label for="costo_instalacion">Instalación accesorios</label>
                                <input type="text" class="monto2 form-control mayuscula" id="costo_instalacion" placeholder="UF" name="costo_instalacion" maxlength="9" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" onkeyup="sumar2();">
                            </div>
                            <div class="col-sm-6 form-group">
                                <label for="costo_capacitacion">Capacitación</label>
                                <input type="text" class="monto2 form-control mayuscula" id="costo_capacitacion" placeholder="UF" name="costo_capacitacion" maxlength="9" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" onkeyup="sumar2();">
                            </div>
                            <div class="col-sm-6 form-group">
                                <label for="costo_retiro">Retiro</label>
                                <input type="text" class="monto2 form-control mayuscula" id="costo_retiro" placeholder="UF" name="costo_retiro" maxlength="9" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" onkeyup="sumar2();">
                            </div>
                            <div class="col-sm-6 form-group">
                                <label for="costo_actualizacion">Actualización firmware</label>
                                <input type="text" class="monto2 form-control mayuscula" id="costo_actualizacion" placeholder="UF" name="costo_actualizacion" maxlength="9" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" onkeyup="sumar2();">
                            </div>
                            <!-- Costos adicionales -->
                            <div class="col-sm-6 form-group">
                                <label for="costo_cortesia">Cortesía</label>
                                <input type="text" class="monto2 form-control mayuscula" id="costo_cortesia" placeholder="UF" name="costo_cortesia" maxlength="9" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" onkeyup="sumar2();">
                            </div>
                            <div class="col-sm-6 form-group">
                                <label for="costo_garantia">Garantía</label>
                                <input type="text" class="monto2 form-control mayuscula" id="costo_garantia" placeholder="UF" name="costo_garantia" maxlength="9" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" onkeyup="sumar2();">
                            </div>
                            <div class="col-sm-6 form-group">
                                <label for="costo_mantenimiento">Mantenimiento</label>
                                <input type="text" class="monto2 form-control mayuscula" id="costo_mantenimiento" placeholder="UF" name="costo_mantenimiento" maxlength="9" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" onkeyup="sumar2();">
                            </div>
                            <div class="form-group col-sm-6">
                                <label for="costo_otros">Otros</label>
                                <input type="text" class="monto form-control mayuscula" id="costo_otros" value="" placeholder="UF" name="costo_otros" maxlength="9" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" onkeyup="sumar();">
                            </div>
                            @endif
                            <div class="col-sm-6 form-group">
                                <label for="">Numero de visita</label>
                                @foreach($ultimavisita as $datos)
                                <input type="text" id="numero_visita" value="{{$datos->numero_visita + 1}}" name="numero_visita" readonly class="form-control mayuscula" maxlength="9" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;">
                                @endforeach
                            </div>
                            <input type="hidden" value="{{Crypt::encryptString($nombrecliente[0]->id ?? '')}}" name="id_proyeecto">
                        </div>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="submit" class="btn btn-prim w-25" id="cambiarcostosusuarioadicional">Guardar</button>
                    <button type="button" class="btn btn-secundario w-25" data-dismiss="modal">Cerrar</button>
                </div>
            </div>
        </form>
    </div>
</div>


<!-- Modal mostrar logotipo asociado -->
<div class="modal fade" id="modal_foto" role="dialog">
    <div class="modal-dialog">

        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
            </div>

            <div class="modal-body" style="text-align: center">
                <img src="{{ asset ("img/logo/".$nombrecliente[0]->url_logo ?? '') }}" width="200" height="200" style="text-align: right">
            </div>
        </div>

    </div>
</div>

<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.2/jquery.min.js"></script>

<script>
    $(document).ready(function() {


        $("#cambiarcostos").click(function() {
            id_visita = $("#id_visita").val();
            costototal = $("#costos_cambio").val();
            costo_habilitacion = $("#costo_habilitacion2").val();
            costo_instalacion = $("#costo_instalacion2").val();
            costo_capacitacion = $("#costo_capacitacion2").val();
            costo_retiro = $("#costo_retiro2").val();
            costo_actualizacion = $("#costo_actualizacion2").val();
            costo_cortesia = $("#costo_cortesia2").val();
            costo_garantia = $("#costo_garantia2").val();
            costo_capacitacionadicional = $("#costo_capacitacionadicional2").val();
            costo_retiroadicional = $("#costo_retiroadicional2").val();
            costo_mantenimiento = $("#costo_mantenimiento2").val();
            costo_otros = $("#costo_otros").val();
            idProyecto = $("#idProyecto").val();
            var _token = $('input[name="_token"]').val();

            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "{{ route('cambiodecostos') }}",
                type: "post",
                data: {
                    'id_visita': id_visita,
                    'costototal': costototal,
                    'costo_habilitacion': costo_habilitacion,
                    'costo_instalacion': costo_instalacion,
                    'costo_capacitacion': costo_capacitacion,
                    'costo_retiro': costo_retiro,
                    'costo_actualizacion': costo_actualizacion,
                    'costo_cortesia': costo_cortesia,
                    'costo_garantia': costo_garantia,
                    'costo_otros': costo_otros,
                    'idProyecto': idProyecto,
                    'costo_mantenimiento': costo_mantenimiento
                },

                success: function(response) {

                    // alert(response);
                    // $("#idcostos").val(response);
                    // console.log(response);
                    $('#modalcostos').modal('toggle');

                },
                error: function(xhr, status) {
                    alert('Disculpe, ha ocurrido un problema, intente mas tarde');
                }
            })
        });
    });
</script>

<script>
    $(document).ready(function() {
        $('.editarvisita').click(function() {
            var id = $(this).attr("data-id");
            var _token = $('input[name="_token"]').val();
            $("#modalcostos").modal('show');
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                method: "POST",
                url: "{{route('go.ver_datos')}}",
                data: {
                    'id': id,
                    _token: _token
                },
                success: function(data) {
                    $("#costo_habilitacion2").val(data.costo_habilitacion);
                    $("#costo_instalacion2").val(data.costo_instalacionaccesorios);
                    $("#costo_capacitacion2").val(data.costo_capacitacion);
                    $("#costo_retiro2").val(data.costo_retiro);
                    $("#costo_actualizacion2").val(data.costo_actualizacionfirmware);
                    $("#costo_cortesia2").val(data.costo_cortesia);
                    $("#costo_garantia2").val(data.costo_garantia);
                    $("#costo_capacitacionadicional2").val(data.costo_capacitacionadicional);
                    $("#costo_capacitacion2").val(data.costo_capacitacion);
                    $("#costo_retiroadicional2").val(data.costo_retiroadicional);
                    $("#costos_cambio").val(data.costo_total);
                    $("#costo_otros").val(data.costo_otros);
                    $("#id_visita").val(data.id);
                    $('#costo_mantenimiento').val(data.costo_mantenimiento);
                },
                error: function(xhr, status) {
                    alert('Disculpe, ha ocurrido un problema, intente mas tarde');
                }
            });

        });
    });


    $(document).ready(function() {
        var num = 1;
        $('.btn-addBody').click(function() {
            num++;
            $('.contenido').append(
                '<div class="container">' + '<hr class="linea">' + '</div>' +
                '<div class="col-sm-6">' +
                '<h2><strong>Costos segunda visita</strong></h2>' +
                '<div class="">' +
                '<label for="costo_habilitacion">' +
                '<h2>Habilitación</h2>' +
                '</label>' +
                '<input type="text" class="monto" id="costo_habilitacion2" placeholder="UF" name="$num" maxlength="9" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" onkeyup="sumar();">' +
                '</div>'
            );
        });
    });
</script>
<script type="text/javascript">
    $(document).ready(function() {
        var maxField = 10; // Numero maximo de campos
        var addButton = $('#add_button'); // Selector del boton de Insertar
        var wrapper = $('.field_wrapper'); // Contenedor de campos
        var fieldHTML = '<div><input type="text" class="form-control" name="field_name[]" value=""/><a href="javascript:void(0);" class="remove_button" title="Remove field"></a></div>'; //New input field html
        var x = 1; // Iniciamos el contador a 1
        $(addButton).click(function() { // Una vez que se haga clic en el boton
            if (x < maxField) { //Comprobamos el maximo
                x++; //Increment field counter
                $(wrapper).append(fieldHTML); // Añadimos el HTML
            }
        });
        $(wrapper).on('click', '.remove_button', function(e) { // Una vez se ha hecho clic en el boton de eliminar
            e.preventDefault();
            $(this).parent('div').remove(); //Eliminamos el div
            x--; // Reducimos el contador a 1
        });
    });
</script>
<script>
    function suma(valor) {
        var total = 0;
        valor = parseInt(valor); // Convertir el valor a un entero (número).

        total = document.getElementById('spTotal').innerHTML;

        // Aquí valido si hay un valor previo, si no hay datos, le pongo un cero "0".
        total = (total == null || total == undefined || total == "") ? 0 : total;

        /* Esta es la suma. */
        total = (parseInt(total) + parseInt(valor));

        // Colocar el resultado de la suma en el control "span".
        document.getElementById('spTotal').innerHTML = total;
        // $('#costos_cambio').val(total);
    }
</script>
<script>
    function sumar() {

        var total = 0;

        $(".monto").each(function() {

            if (isNaN(parseFloat($(this).val()))) {

                total += 0;

            } else {

                total += parseFloat($(this).val());

            }

        });

        //alert(total);
        //document.getElementById('spTotal').innerHTML = total;
        // $('#costos_cambio').val(total);
    }
</script>
@endsection