@extends('menu/menu')
@section('content')
@if ( session('mensaje') )
<div class="alert alert-success">{{ session('mensaje') }}</div>
@endif
<div class="container mt-5">
    <div class="title-vista mt-4">Mantenedor correos</div>
</div>
<div class="container mt-5">
    <!-- TABLA DE RESULTADOS DE BUSQUEDA -->
    <div class="container table-responsive mb-5 p-sm-0">
        <div class="table table-striped table-hover">
            <table class="table table-striped table-hover text-center">
                <!-- ENCABEZADO -->
                <thead class="color-head">
                    <tr>
                        <th class="th-head border-th" colspan="1">Nombre Proyecto</th>
                        <th class="th-head border-th" colspan="1">Envio reporte diario</th>
                    </tr>
                </thead>
                <!-- FIN ENCABEZADO -->
                <!-- RESULTADOS -->
                <tbody>
                    @if(!empty($clientes))
                    @foreach ($clientes as $key => $los_datos)
                    <th class="th-head border-th" colspan="3" style="text-align: left;">Cliente: {{strtoupper($los_datos->razon_social)}}</th>
                    @php
                    $proyectos = DB::table('proyectos')
                    ->select('proyectos.id','proyectos.nombre','proyectos.enviar_reporte_diario')
                    ->join('clientes','clientes.id','=','proyectos.clientes_id')
                    ->where('clientes.id','=',$los_datos->id)
                    ->get();
                    @endphp
                    @if(!empty($proyectos))
                    @foreach ($proyectos as $key => $datos)
                    <tr>
                        <td class="td-val">{{strtoupper($datos->nombre)}}</td>
                        <td class="td-val">
                            <div class="form-group check-input">
                                <div class="custom-control custom-checkbox">
                                    @if($datos->enviar_reporte_diario == 1)
                                    <input class="custom-control-input envio_check" type="checkbox" checked id="{{$datos->id}}" name="" value="">
                                    @else
                                    <input class="custom-control-input envio_check" type="checkbox" id="{{$datos->id}}" name="" value="">
                                    @endif
                                    <label class="custom-control-label" for="{{$datos->id}}"></label>
                                </div>
                            </div>
                        </td>
                    </tr>
                    @endforeach
                    @endif
                    @endforeach
                    @endif
                </tbody>
                <!-- FIN RESULTADOS -->
            </table>
        </div>
    </div>
    <!-- FIN TABLA DE RESULTADOS DE BUSQUEDA -->
</div>
@endsection
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script>
    $(document).ready(() => {
        $(".envio_check").click(function() {
            id = $(this).attr('id');
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                type: 'POST',
                url: "{{ route('go.cambio_envio') }}",
                data: {
                    'id': id,
                },
                success: function(data) {
                    console.log(data);
                },
                error: function(xhr, status) {
                    alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
                }
            });
        });
    });
</script>