@extends('menu/menu')

{{-- <script src="https://ajax.aspnetcdn.com/ajax/jQuery/jquery-3.4.1.min.js"></script> --}}
<script src="{{ asset('js/jquery-3.4.1.min.js') }}" ></script>
<!--<link src="sftp://aya_pruebafinal@35.232.42.155/var/www/html/rendicion/css/_______a%26a_style.css" rel="stylesheet" type="text/css">-->



@section('content')

<!-- body code goes here -->
<div class="container mt-5">
  <div class="title-vista mt-4">CHECKLIST DE RETIRO DE EQUIPOS</div>
</div>

<div class="container mt5 mb-5">

  <!-- Fila 1 ------------------------------------------------------>
  <div class="seccion-filtro">Asignación</div> 
  <hr class="separador">

  <div class="row">
    <div class="col-sm-6 form-group">
      <label for="">Técnico asignado</label>
      <input type="text" class="form-control mayuscula" value="{{$datos_asignacion[0]->nombre_uno." ".$datos_asignacion[0]->apellido_uno." ".$datos_asignacion[0]->apellido_dos}}" style="pointer-events: none" readonly="readonly" id="" placeholder="Nº DE VISITA" name="numero_visitas">

      @error('tecnico')
        <div class="alert alert-danger">{{ $message }}</div>
      @enderror
    </div>
    <div class="col-sm-6 form-group ali">
      <label for="">Proyecto asociado</label>
      <input type="text" class="form-control mayuscula" value="{{$proyectos[0]->nombre ?? ''}} " style="pointer-events: none" readonly="readonly">
      @error('proyectos')
        <div class="alert alert-danger">{{ $message }}</div>
      @enderror
    </div>
    <div class="col-sm-3 form-group">
      <label for="email">Nº de visita</label>
      <input type="text" class="form-control mayuscula" value="{{$datos_asignacion[0]->numero_visita ?? ''}}" id="" style="pointer-events: none" readonly="readonly" placeholder="Nº DE VISITA" name="numero_visitas">
      @error('numero_visitas')
        <div class="alert alert-danger">{{ $message }}</div>
      @enderror
    </div>
  </div>

  <!-- Fila 2 ------------------------------------------------------>
  <div class="seccion-filtro mt-2">Detalla del cliente</div> 
  <hr class="separador">

  <div class="row">
    <div class="col-sm-3 form-group">
      <label for="email">Cliente</label>
      <input type="" class="form-control mayuscula" id="" placeholder="CLIENTE" name="" style="pointer-events: none"  readonly="readonly" placeholder="DIRECCIÓN" value="{{$proyectos[0]->razon_social ?? ''}}" name="">
    </div>
    <div class="col-sm-3 form-group">
      <label for="email">Fecha</label>
      <input type="" class="form-control mayuscula" id="" placeholder="FECHA" name=""  readonly="readonly" value="{{Carbon\Carbon::createFromDate($datos_asignacion[0]->fecha_inicio ?? '')->format('d-m-Y')}}">
    </div>
    <div class="col-sm-3 form-group">
      <label for="email">Hora de inicio</label>
      <input type="" class="form-control mayuscula" id="" placeholder="HORA DE INICIO" name=""  readonly="readonly"  value="{{Carbon\Carbon::createFromDate($datos_asignacion[0]->fecha_asignado ?? '')->format('d-m-Y H:i:s')}}">
    </div>
    <div class="col-sm-3 form-group">
      <label for="email">Hora de termino</label>
      <input type="" class="form-control mayuscula" id="" placeholder="HORA DE TERMINO" name=""  readonly="readonly" value="{{Carbon\Carbon::createFromDate($datos_asignacion[0]->fecha_termino ?? '')->format('d-m-Y H:i:s')}}">
    </div>
  </div>

  <!-- Fila 3 ------------------------------------------------------>
  <div class="row">
    <div class="col-sm-6 form-group">
      <label for="email">Dirección</label>
      <div class="input-group d-flex">
        <input type="" class="form-control mayuscula" id="iddireccion" style="pointer-events: none" readonly="readonly" placeholder="DIRECCIÓN" value="{{$datos_asignacion[0]->csDireccion ?? ''}}" name="">
        <div class="input-group-append">
          <a class="btn app-color" title="modificar" href="" data-toggle="modal" data-target="#modaldireccion">
            <span class="material-icons-round">edit</span>
          </a>
        </div>
      </div>
    </div>
    <div class="col-sm-3 form-group">
      <label for="email">Comuna</label>
      <div class="input-group d-flex">
        <input type="" class="form-control mayuscula" id="idcomuna" placeholder="COMUNA" name="" style="pointer-events: none" readonly="readonly" value="{{$datos_asignacion[0]->csComuna ?? ''}}">
        <div class="input-group-append">
          <a class="btn app-color" title="modificar" href="" data-toggle="modal" data-target="#modalcomuna">
            <span class="material-icons-round">edit</span>
          </a>
        </div>
      </div>
    </div>
    <div class="col-sm-3 form-group">
      <label for="email">CUI o Código Sucursal</label>
      <input type="" class="form-control mayuscula" id="" placeholder="SC" name=""  style="pointer-events: none" readonly="readonly" value="{{$datos_asignacion[0]->csCui ?? ''}}">
   </div>
  </div>

  <!-- Fila 4 ------------------------------------------------------>
  <div class="seccion-filtro mt-2">Detalle de equipamiento</div> 
  <hr class="separador">
  <div class="row">
    <div class="col-sm-3 form-group">
      <label for="email">Serie</label>
      <input type="" class="form-control mayuscula" id="" placeholder="SERIE" name="n_serie" readonly="readonly" value="{{$datos_asignacion[0]->csSerie ?? ''}}">
    </div>
    <div class="col-sm-3 form-group">
        <label for="email">Modelo</label>
        <input type="" class="form-control mayuscula" id="" placeholder="MODELO" name="n_modelo" readonly="readonly" value="{{$datos_asignacion[0]->csModelo ?? ''}}">
    </div>
    <div class="col-sm-3 form-group">
        <label for="email">Contador B/N</label>
      <input type="" class="form-control mayuscula" id="" placeholder="CONTADOR B/N" readonly="readonly" name="n_contador" value="{{$datos_asignacion[0]->cnContador ?? ''}}">
    </div>
    <div class="col-sm-3 form-group">
        <label for="email">Contador color</label>
      <input type="" class="form-control mayuscula" id="" placeholder="CONTADOR COLOR" readonly="readonly" name="n_contadorcolor" value="{{$datos_asignacion[0]->cnContador_color ?? ''}}">
    </div>
  </div>

  <!-- Fila 5 ------------------------------------------------------>
  <div class="row my-3">
    <div class="col-sm-6 form-group check-input">
      <div class="custom-control custom-checkbox">
        <input type="checkbox" class="custom-control-input" id="equipo_sucursal" name="equipo_sucursal"   value="si" {{ (! empty(old('equipo_sucursal')) ? 'checked' : '') }}>
        <label class="custom-control-label" for="equipo_sucursal">El equipo no se encuentra en la sucursal</label>
      </div>
    </div>
  </div>
  
  <!-- Fila 6 - Accesorios ----------------------------------------------------->
  <div class="seccion-filtro mt-2">Accesorios</div> 
  <hr class="separador">
  
  <div class="row">
    <div class="col-md-3 form-group checkbox">
      <div class="custom-control custom-checkbox">
        @if ($datos_asignacion[0]->bandeja_adicional == 'si')
          <input type="checkbox" class="custom-control-input" id="bandeja_adicional" name="bandeja_adicional"  checked="checked"  value="si" {{ (! empty(old('bandeja_adicional')) ? 'checked' : '') }}>
          <label class="custom-control-label" for="bandeja_adicional">Bandeja adicional</label>
        @else
          <input type="checkbox" class="custom-control-input" id="bandeja_adicional" name="bandeja_adicional"  value="si" {{ (! empty(old('bandeja_adicional')) ? 'checked' : '') }}>
          <label class="custom-control-label" for="bandeja_adicional">Bandeja adicional</label>
        @endif
      </div>
    </div>

    <div class="col-md-3 form-group checkbox">
      <div class="custom-control custom-checkbox">
        @if ($datos_asignacion[0]->mueble == 'si')
          <input type="checkbox" class="custom-control-input" id="mueble" name="mueble" checked="checked" value="si" {{ (! empty(old('mueble')) ? 'checked' : '') }}>
          <label class="custom-control-label" for="mueble">Mueble</label>
        @else
          <input type="checkbox" class="custom-control-input" id="mueble" name="mueble" value="si" {{ (! empty(old('mueble')) ? 'checked' : '') }}>
          <label class="custom-control-label" for="mueble">Mueble</label>
        @endif
      </div>
    </div>

    <div class="col-md-3 form-group checkbox">
      <div class="custom-control custom-checkbox">
        @if ($datos_asignacion[0]->kitlector == 'si')
          <input type="checkbox" class="custom-control-input" id="kit_lector" name="kit_lector" checked="checked" value="si" {{ (! empty(old('kit_lector')) ? 'checked' : '') }}>
          <label class="custom-control-label" for="kit_lector">Kit lector</label>
        @else
          <input type="checkbox" class="custom-control-input" id="kit_lector" name="kit_lector" value="si" {{ (! empty(old('kit_lector')) ? 'checked' : '') }}>
          <label class="custom-control-label" for="kit_lector">Kit lector</label>
        @endif
      </div>
    </div>

    <div class="col-md-3 form-group checkbox">
      <div class="custom-control custom-checkbox">
        @if ($datos_asignacion[0]->memoriasd == 'si')
          <input type="checkbox" class="custom-control-input" id="memoria_sd" name="memoria_sd" checked="checked" value="si" {{ (! empty(old('memoria_sd')) ? 'checked' : '') }}>
          <label class="custom-control-label" for="memoria_sd">Memoria SD</label>
        @else
          <input type="checkbox" class="custom-control-input" id="memoria_sd" name="memoria_sd" value="si" {{ (! empty(old('memoria_sd')) ? 'checked' : '') }}>
          <label class="custom-control-label" for="memoria_sd">Memoria SD</label>
        @endif
      </div>
    </div>
  </div>
  <!-- Fila 7 - Accesorios ----------------------------------------------------->
  <div class="row my-3">
    <div class="col-md-3 form-group checkbox">
      <div class="custom-control custom-checkbox">
        @if ($datos_asignacion[0]->cablered == 'si')
          <input type="checkbox" class="custom-control-input" id="cable_red" name="cable_red" checked="checked" value="si" {{ (! empty(old('cable_red')) ? 'checked' : '') }}>
          <label class="custom-control-label" for="cable_red">Cable de red</label>
        @else
          <input type="checkbox" class="custom-control-input" id="cable_red" name="cable_red" value="si" {{ (! empty(old('cable_red')) ? 'checked' : '') }}>
          <label class="custom-control-label" for="cable_red">Cable de red</label>
        @endif
      </div>
    </div>

    <div class="col-md-3 form-group checkbox">
      <div class="custom-control custom-checkbox">
        @if ($datos_asignacion[0]->cablepoder == 'si')
          <input type="checkbox" class="custom-control-input" id="cable_poder" name="cable_poder" checked="checked" value="si" {{ (! empty(old('cable_poder')) ? 'checked' : '') }}>
          <label class="custom-control-label" for="cable_poder">Cable de poder</label>
        @else
          <input type="checkbox" class="custom-control-input" id="cable_poder" name="cable_poder"   value="si" {{ (! empty(old('cable_poder')) ? 'checked' : '') }}>
          <label class="custom-control-label" for="cable_poder">Cable de poder</label>
        @endif
      </div>
    </div>
  </div>

  <!-- Fila 8 ----------------------------------------------------->
  <div class="seccion-filtro mt-2">Equipo</div> 
  <hr class="separador">

  <div class="row">
    <div class="col-md-12 form-group checkbox">
      <div class="custom-control custom-checkbox">
        @if ($datos_asignacion[0]->equipoembalado == 'si')
          <input type="checkbox" class="custom-control-input" id="equipo_ensamblado" name="equipo_ensamblado" checked="checked" value="si" {{ (! empty(old('equipo_ensamblado')) ? 'checked' : '') }}>
          <label class="custom-control-label" for="equipo_ensamblado">Equipo embalado (si la respuesta es no, indicar el motivo en observaciones)</label>
        @else
          <input type="checkbox" class="custom-control-input" id="equipo_ensamblado" name="equipo_ensamblado" value="si" {{ (! empty(old('equipo_ensamblado')) ? 'checked' : '') }}>
          <label class="custom-control-label" for="equipo_ensamblado">Equipo embalado (si la respuesta es no, indicar el motivo en observaciones)</label>
        @endif
      </div>
    </div>

    <div class="col-sm-12 form-group">
      <label for="cambio"> Observaciones</label>
      <textarea  class="form-control mayuscula" id="cambio" name="obsercaviones"   readonly="readonly" rows="4" name="observaciones">
      {{ $datos_asignacion[0]->csObservacion }} </textarea>
    </div>
  </div>

  <!-- Fila 9 ----------------------------------------------------->
  <div class="seccion-filtro mt-2">Equipo</div> 
  <hr class="separador">

  <div class="row">
    <!-- Fila 9.1 -->
    <div class="col-sm-6">
      <div class="row">
        <div class="col-sm-12 form-group">
          <label for="email">Datos del Técnico</label>
          <input type="text" class="form-control mayuscula" value="{{$datos_asignacion[0]->nombre_uno." ".$datos_asignacion[0]->apellido_uno." ".$datos_asignacion[0]->apellido_dos}}" style="pointer-events: none" readonly="readonly" class="form-control" id="" placeholder="Nº DE VISITA" name="numero_visitas">
        </div>
        <div class="col-sm-12 form-group checkbox">
          <label for="">Estado check</label>
          <input type="text" class="form-control mayuscula" readonly value="{{$datos_asignacion[0]->estado_check ?? 'No existe'}}" class="form-control" id="" placeholder="Estado check" >
        </div>
        <div class="col-sm-12 form-group">
          <label for="email">Firma Técnico</label>
        </div>
      </div>
    </div>
    <!-- Fila 9.2 -->
    <div class="col-sm-6">
      <div class="row">
        <div class="col-sm-12 form-group">
          <label for="email">Datos del Contacto</label>
          <input type="text" class="form-control mayuscula" readonly="readonly" value="{{$datos_asignacion[0]->nombre_contacto ?? 'No existe dato ingresado'}}"  class="form-control" id="" placeholder="Contacto" name="contacto">
        </div>
        <div class="col-sm-12 form-group pt-5 pb-4"></div>
        <div class="col-sm-12 form-group">
          <label for="email">Firma Contacto</label>
        </div>
        <div class="col-md-12 form-group checkbox">
          <div class="custom-control custom-checkbox">
            @if ($datos_asignacion[0]->cliente_firma == 0)
              <input type="checkbox" class="custom-control-input" id="negarse_firma" checked="checked" name="negarse_firma" value="si">
              <label class="custom-control-label" for="negarse_firma">Cliente se niega a firmar</label>
            @else
              <input type="checkbox" class="custom-control-input" id="negarse_firma"  name="negarse_firma" value="si">
              <label class="custom-control-label" for="negarse_firma">Cliente se niega a firmar</label>
            @endif
          </div>
        </div>
        <div class="col-sm-12 form-group">
          <img src="{{ asset ("fotos/".$datos_asignacion[0]->url_firma) }}">
        </div>
      </div>
    </div>
  </div>

  <!-- Fila 10 ----------------------------------------------------->
  <div class="seccion-filtro mt-2">Imágenes</div> 
  <hr class="separador">
  <div class="row">
    <div class="col-sm-6 form-group checkbox">
      <button class="btn btn-ter asignarimagen" type="button">
        <span class="material-icons-round icon-midle">collections</span> Ver imágenes
      </button>
    </div>
  </div>

  <hr class="separador">
  <div class="row">
    <div class="col-sm-12 form-group text-right">
      @if( $datos_asignacion[0]->estado_asignacion != "reasignar")  
      @if($datos_asignacion[0]->estado_asignacion != "tarea_asignada")
        <form action="{{route('checklist.retiro_rechazo',Crypt::encryptString($datos_asignacion[0]->idCheckRetiros ?? ''))}} " method="POST">
          @csrf            
          <button class="btn btn-secundario w-25 mr-2" id="rechazar" type="button">Rechazar</button>
        </form>
          <button class="btn btn-prim w-25 mr-2" style="display:none;" type="button">Confirmar y enviar</button>
      @endif  
      @endif
    </div>
  </div>

  <hr class="separador">
  <div class="row">
    <div class="col-sm-12 form-group d-flex">
      <!-- {{$datos_asignacion[0]->estado_asignacion }} -->
      @if($datos_asignacion[0]->estado_asignacion == "tarea_asignada")
      <a class="btn btn-secundario w-25 mr-2" id="reasignar">Reasignar</a>
      @else
        <a class="btn btn-ter mr-auto" href="{{route('generar.pdfCordinadoraRetiro',Crypt::encryptString($datos_asignacion[0]->idCheckRetiros ?? ''))}}">
          <span class="material-icons-round icon-midle">picture_as_pdf</span> Ver PDF
        </a>
        <a class="btn btn-secundario w-25 mr-2 " id="reasignar">Reasignar</a>

        <a class="btn btn-prim  w-25 mr-2" href="{{route('consumir.Aretiro',Crypt::encryptString($datos_asignacion[0]->idCheckRetiros ?? ''))}}"  >Aceptar</a> 
      @endif
    </div>
  </div>
</div>





<!-- Modal reasignar -->
<div class="modal" id="modalReasignar">
  <div class="modal-dialog">
    <div class="modal-content">

      <!-- Modal Header -->
      <div class="modal-header">
        <h4 class="seccion-modal">Escriba sus observaciones</h4>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      <hr class="separador ml-4 mr-4">

      <form action="{{route('checklistRetiro.reasignar',Crypt::encryptString($datos_asignacion[0]->idCheckRetiros ?? ''))}} " method="POST">
        @csrf
      <!-- Modal body -->
      <div class="modal-body">
        <div class="container">
          <div class="row">
            <div class="col-sm-12 form-group text-center">
              <label for="flexCheckDefault">¿Asistió el técnico?</label>
              <br>
              <input class="" type="checkbox" value="si" name="asistencia" id="asistencia_si" required checked onchange="javascript:changeCheckNo()">
              <label for="">Si</label>
              <input class="" type="checkbox" value="no" name="asistencia_no" id="asistencia_no"  onchange="javascript:changeCheckSi()">
              <label for="">No</label>
            </div>
            <div class="col-sm-12 form-group">
              <label for="cambio">Observaciones</label>
              <textarea class="form-control mayuscula" id="modal-obs" name="motivorechazado" required rows="4" ></textarea>
            </div>
          </div>
        </div>
      </div>
      <!-- Modal footer -->
      <div class="modal-footer ">
        <button type="submit" class="btn btn-prim mx-auto w-25">Enviar</button>
      </div>
   </form>  
    </div>
  </div>
</div> 

    <!--Modal Ver imágenes------------------------------------------->
    <div class="modal" id="myModal">
      <div class="modal-dialog">
        <div class="modal-content">
                
          <div class="modal-header">
            <h4 class="seccion-modal">Ver Imágenes</h4>
            <button type="button" class="close" data-dismiss="modal">&times;</button>
          </div>
          <hr class="separador ml-4 mr-4">

          <div class="modal-body">
            <div class="container">
              <!--Carrusel----------------------------------------------->
              <div id="demo" class="carousel slide" data-ride="carousel">
                                
                <!--Indicaciones-->
                <ul class="carousel-indicators">
                  <li data-target="#demo" data-slide-to="0" class="active"></li>
                  <li data-target="#demo" data-slide-to="1"></li>
                  <li data-target="#demo" data-slide-to="2"></li>
                </ul>                
                                
                <div class="carousel-inner">
                  {{$valor = 0}}
                    @if(!empty($fotos))
                    @foreach ($fotos   as $los_datos)
                              
                    @if($valor == 0)
                      <div class="carousel-item active">
                        <img src="{{ asset ("fotos/".$los_datos->url) ?? ''}}" alt="cajas" width="500" height="500">
                      </div>
                    {{$valor=1}}
                    @else

                    <div class="carousel-item">
                      <img src="{{ asset ("fotos/".$los_datos->url ) ?? ''}}" alt="joya 1" width="500" height="500">
                    </div>

                    @endif
                    @endforeach
                    @endif                
                </div>
                                
                <!--Controles del acrrusel-->
                <a class="carousel-control-prev" href="#demo" data-slide="prev">
                  <span class="carousel-control-prev-icon"></span>
                </a>
                <a class="carousel-control-next" href="#demo" data-slide="next">
                  <span class="carousel-control-next-icon"></span>
                </a>             
              </div>
          <!--Fin Carrusel---------------------------------------->
            </div>
          </div>

          <div class="modal-footer">
              <button type="button" class="btn btn-prim w-25 mx-auto" data-dismiss="modal">Cerrar</button>
          </div>          
        </div>
      </div>
    </div>
    


    <!--Modal Observaciones -->
				<div class="modal" id="modalRechazo">
					<div class="modal-dialog">
					  <div class="modal-content">
						  <!-- Modal Header -->
						  <div class="modal-header">
						    <h4 class="seccion-modal">Escriba sus observaciones</h4>
						    <button type="button" class="close" data-dismiss="modal">&times;</button>
						  </div>
              <hr class="separador ml-4 mr-4">

              <form action="{{route('checklist.retiro_rechazo',Crypt::encryptString($datos_asignacion[0]->idCheckRetiros ?? ''))}} " method="POST">
              <!-- Modal body -->
              @csrf      
              <div class="modal-body">
                <div class="container">
                  <div class="row">
                    <div class="col-sm-12 form-group">
                      <label for="cambio">Observaciones</label>
                      <textarea class="form-control mayuscula" id="modal-obs" name="motivorechazado" required rows="4" ></textarea>	
                    </div>
                  </div>
                </div>
              </div>
						  <!-- Modal footer -->
              <div class="modal-footer">
                <button type="submit" class="btn btn-prim w-25 mx-auto">Enviar</button>
              </div>
              </form>  
					  </div>
					</div>
				</div> 
        <!--Fin Modal----->


        <!-- Modal DIRECCION-->
        <div class="modal fade" id="modaldireccion" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog" role="document">
            <div class="modal-content">

              <div class="modal-header">
						    <h4 class="seccion-modal">Cambiar Dirección</h4>
						    <button type="button" class="close" data-dismiss="modal">&times;</button>
						  </div>
              <hr class="separador ml-4 mr-4">

              <div class="modal-body">
               <div class="container">
                 <div class="row">
                   <div class="col-sm-12 form-group">
                      <input class="form-control mayuscula" type="" id="direccion_cambio" placeholder="{{$datos_asignacion[0]->csDireccion ?? ''}}">
                      <input class="form-control mayuscula" type="hidden" value="{{$datos_asignacion[0]->idCheckRetiros ?? ''}}" id="id_check">
                   </div>
                 </div>
               </div>
              </div>
                
              <div class="modal-footer">
                <button type="button" class="btn btn-prim w-25 mx-auto" id="cambiardireccion" >Guardar</button>
              </div>
            </div>
          </div>
        </div>
        <!--Fin Modal----------------------------------------->

        <!-- Modal COMUNA-->
        <div class="modal fade" id="modalcomuna" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog" role="document">
            <div class="modal-content">

              <div class="modal-header">
                <h4 class="seccion-modal">Cambiar Comuna</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <hr class="separador ml-4 mr-4">

              <div class="modal-body">
                <div class="container">
                  <div class="row">
                    <div class="col-sm-12 form-group">
                      <input type="text" class="form-control mayuscula" id="comuna_cambio" pattern="[a-z]{1,15}" required placeholder="{{$datos_asignacion[0]->csComuna ?? ''}}">
                    </div>
                  </div>
                </div>
                <input type="hidden" value="{{$datos_asignacion[0]->idCheckRetiros ?? ''}}" id="id_check">
              </div>
              <div class="modal-footer">
                <button type="submit" class="btn btn-prim w-25 mx-auto" id="cambiarcomuna">Guardar</button>
              </div>
            </div>
          </div>
        </div>

<!--Fin Modal----------------------------------------->

    @endsection
    <script>
      $(document).ready(function(){
        $("#cambiardireccion").click(function() {
          direccion = $("#direccion_cambio").val();
          id_check = $("#id_check").val();
          var _token = $('input[name="_token"]').val();
          $.ajax({
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
            url:"{{ route('cambiodedireccion_retiro') }}",
            type: "post",
            data: {'direccion': direccion,'id_check': id_check},

            success: function(response) {                    
                            
              console.log(response);
              $("#iddireccion").val(response);
              $('#modaldireccion').modal('toggle');

            },
          
            error: function(xhr, status) {

              alert('Disculpe, ha ocurrido un problema, intente mas tarde');

            }
          })
        });
      });
    </script>
    <script>
      $(document).ready(function(){
        $("#cambiarcomuna").click(function() {
          comuna = $("#comuna_cambio").val();
          id_check = $("#id_check").val();
          var _token = $('input[name="_token"]').val();
          $.ajax({
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
            url:"{{ route('cambiodecomuna_retiro') }}",
            type: "post",
            data: {'comuna': comuna,'id_check': id_check},

            success: function(response) {
                              
              $("#idcomuna").val(response);
              $('#modalcomuna').modal('toggle');

            },
            
            error: function(xhr, status) {
            
              alert('Disculpe, ha ocurrido un problema, intente mas tarde');
            
            }
          });
        });
      });
    </script>
    <script>
      $(document).ready(function(){
        $('#rechazar').click(function() {

               $("#modalRechazo").modal('show');
          });
      });
    </script>
     <script>

    $(function(){
      $('#reasignar').click(function() {
            
            //   alert("gola");
               $("#modalReasignar").modal('show');
          });


            $("#formuploadajax").on("submit", function(e){
                e.preventDefault();
                var f = $(this);
                var formData = new FormData(document.getElementById("formuploadajax"));
                formData.append("dato", "valor");
                //formData.append(f.attr("name"), $(this)[0].files[0]);
                $.ajax({
                    url:"{{ route('save.imagenchecklistRetiro') }}",
                    type: "post",
                    dataType: "html",
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                     success: function(response) { 

                         console.log(response);


                         $("#mensaje-text").text("Imagenes Guardadas");
                         alert("imagenes guardadas");
                           $("#modal_historial_retiros").modal('hide');
                     }
                })
                    .done(function(res){
                        $("#mensaje").html("Respuesta: " + res);
                    });
            });
        });


     $(document).ready(function(){

       $('.asignarimagen').click(function() {
             
             $("#myModal").modal('show');
    });

    //funcion para cambiar los tres estados
    $("#mueble").data('checked', 0).on('click', function() {
      el = $(this);
      tres_estados(el,'mueble');
    });
    $("#cable_poder").data('checked', 0).on('click', function() {
      el = $(this);
      tres_estados(el,'cable_poder');
    });
    $("#cable_red").data('checked', 0).on('click', function() {
      el = $(this);
      tres_estados(el,'cable_red');
    });
    $("#memoria_sd").data('checked', 0).on('click', function() {
      el = $(this);
      tres_estados(el,'memoria_sd');
    });
    $("#kit_lector").data('checked', 0).on('click', function() {
      el = $(this);
      tres_estados(el,'kit_lector');
    });
    $("#equipo_ensamblado").data('checked', 0).on('click', function() {
      el = $(this);
      tres_estados(el,'equipo_ensamblado');
    });
    $("#negarse_firma").data('checked', 0).on('click', function() {
      el = $(this);
      tres_estados(el,'negarse_firma');
    });
    $("#bandeja_adicional").data('checked', 0).on('click', function() {
      el = $(this);
      tres_estados(el,'bandeja_adicional');
    });
 
    
    
 })

 //funciones individuales

 function tres_estados(el, id_chec) {

switch (el.data('checked')) {

	case 0: //cehckeado
		el.data('checked', 1);
		el.prop('indeterminate', false);
		el.prop('checked', true);

		var valor2 = id_chec;

		var valor =$("#observaciones").text();



		$("#observaciones").text(valor.replace(" sin "+id_chec+',',""));

		//  console.log('true');
		break;


	case 1:
		el.data('checked', 2);
		el.prop('indeterminate', true);
		el.prop('checked', true);

		var valor2 = id_chec;

		var valor =$("#observaciones").text();

		valor+=" sin "+valor2+',';

		$("#observaciones").text(valor);



		//console.log('null');
		$("#" + id_chec).val("no");

	
		break;


	default:
		el.data('checked', 0);
		el.prop('indeterminate', false);
		el.prop('checked', false);
		//console.log('false');

		var valor2 = id_chec;

		var valor =$("#observaciones").text();


		$("#observaciones").text(valor.replace(" sin "+id_chec+',',""));
}
}
 </script>
 <script>
  function changeCheckNo(){
    ($('#asistencia_no')).prop('checked',false);
    check_si = document.getElementById("asistencia_si");
    check_no = document.getElementById("asistencia_no");
    if(check_si.checked){
      check_no.required = false
      check_si.required = true;
    }else if(check_no.checked){
      check_no.required = true;
      check_si.required = false;
    }else{
      check_si.required = true;
      check_no.required = true;
    }
  }
  function changeCheckSi(){
    ($('#asistencia_si')).prop('checked',false);
    check_si = document.getElementById("asistencia_si");
    check_no = document.getElementById("asistencia_no");
    if(check_no.checked){
      check_no.required = true;
      check_si.required = false;
    }else if(check_si.checked){
      check_no.required = false;
      check_si.required = true;
    }else{
      check_si.required = true;
      check_no.required = true;
    }
  }
</script>

