@extends('menu/menu')
<style>
  .mostrar {
    display: none;
  }

  @media (max-width: 768px) {
    .mostrar {
      display: block;
    }
  }

  .selectBox {
    position: relative;
  }

  .overSelect {
    position: absolute;
    left: 0;
    right: 0;
    top: 0;
    bottom: 0;
  }

  #checkboxes2 {
    display: none;
    border: 1px #dadada solid;
    background-color: white;
  }

  #checkboxes2 label {
    display: block;
  }

  #checkboxes2 label:hover {
    background-color: #1e90ff;
  }
</style>
{{-- <script src="https://ajax.aspnetcdn.com/ajax/jQuery/jquery-3.4.1.min.js"></script> --}}
<script src="{{ asset('js/jquery-3.4.1.min.js') }}"></script>
<!--<link src="sftp://aya_pruebafinal@35.232.42.155/var/www/html/rendicion/css/_______a%26a_style.css" rel="stylesheet" type="text/css">-->
<!-- <script src="https://files.codepedia.info/files/uploads/iScripts/html2canvas.js"></script> -->


<script src="https://html2canvas.hertzen.com/dist/html2canvas.js"></script>
<style>
  canvas {
    width: 250px;
    height: 250px;
    background-color: #fff;
  }

  @media screen and (max-width: 768px) {
    canvas {
      width: 250px;
      height: 250px;
      z-index: 99999;
      float: center;
      background-color: #fff;
    }
  }
</style>


@section('content')
@if ( session('mensaje') )
<div class="alert alert-success">{{ session('mensaje') }}</div>
@endif

@if ( session('mensaje_error') )

<div class="alert alert-danger">{{ session('mensaje_error') }}</div>

@endif

<div class="container mt-5">
  <div class="title-vista mt-4">
    CHECKLIST DE RETIRO DE EQUIPOS
    <div class="mostrar-contenido" style="text-align: right">
      <a href="javascript: history.go(-1)"><img src="img/volver.png"></a>
    </div>
  </div>
</div>

@if ( $datos_asignacion[0]->estado_inicio == null || $datos_asignacion[0]->estado_inicio == "" )
<div class="text-center">
  <a class="btn btn-prim w-25" href="{{route('iniciando.checklistRetiro',Crypt::encryptString($datos_asignacion[0]->idCheckRetiros))}}">Iniciar Retiro</a>
</div>
@else

@endif

<form action="{{route('update.IniciarchecklistRetiros',Crypt::encryptString($datos_asignacion[0]->idCheckRetiros))}} " method="POST">
  @csrf
  <div class="container">

    <!-- BARRA DE BUSQUEDA -->
    <div class="seccion-filtro">Asignación</div>
    <hr class="separador">

    <div class="row">
      <!-- Fila 1 ------------------------------------------------------>
      <div class="col-sm-6 form-group">
        <label for="">Técnico asignado</label>
        <input type="text" value="{{$datos_asignacion[0]->nombre_uno." ".$datos_asignacion[0]->apellido_uno." ".$datos_asignacion[0]->apellido_dos}}" style="pointer-events: none" readonly="readonly" class="form-control mayuscula" id="" placeholder="Nº DE VISITA" name="numero_visitas">
        @error('tecnico')
        <div class="alert alert-danger">{{ $message }}</div>
        @enderror
      </div>

      <div class="col-sm-6 form-group">
        <label for="">Proyecto asociado</label>
        <input type="text" class="form-control mayuscula" value="{{$proyectos[0]->nombre}} " style="pointer-events: none" readonly="readonly">
        @error('proyectos')
        <div class="alert alert-danger">{{ $message }}</div>
        @enderror
      </div>

      <div class="col-sm-3 form-group">
        <label for="email">Nº de visita</label>
        <input type="text" value="{{$datos_asignacion[0]->numero_visita}}" class="form-control mayuscula" id="" style="pointer-events: none" readonly="readonly" placeholder="Nº DE VISITA" name="numero_visitas">
        @error('numero_visitas')
        <div class="alert alert-danger">{{ $message }}</div>
        @enderror
      </div>

      <input type="hidden" value="{{$accion}}" name="acc">
    </div>

    <!-- Detalle del Cliente -->
    <div class="seccion-filtro">Detalle del Cliente</div>
    <hr class="separador">

    <div class="row">
      <!-- Fila 2 ------------------------------------------------------>
      <div class="col-sm-6 form-group">
        <label for="email">Cliente</label>
        <input type="" class="form-control mayuscula" id="" placeholder="CLIENTE" name="" style="pointer-events: none" readonly="readonly" placeholder="Cliente" value="{{$proyectos[0]->razon_social ?? ''}}" name="">
      </div>

      <div class="col-sm-6 form-group">
        <label for="email">Dirección</label>
        <input type="" class="form-control mayuscula" id="" style="pointer-events: none" readonly="readonly" placeholder="Dirección" value="{{$datos_asignacion[0]->csDireccion ?? ''}}" name="">
      </div>

      <!-- Fila 3 ------------------------------------------------------>
      <div class="col-sm-3 form-group">
        <label for="email">Comuna</label>
        <input type="" class="form-control mayuscula" id="" placeholder="COMUNA" name="sComuna" value="{{$datos_asignacion[0]->csComuna ?? ''}}">
      </div>

      <div class="col-sm-3 form-group">
        <label for="email">CUI o Código Sucursal</label>
        <input type="" class="form-control mayuscula" id="" placeholder="SC" name="" style="pointer-events: none" readonly="readonly" value="{{$datos_asignacion[0]->csCui ?? ''}}">
      </div>
    </div>

    <!-- Fila 4 ------------------------------------------------------>
    <!-- Detalle de Equipamiento -->
    <div class="seccion-filtro">Detalle de Equipamiento</div>
    <hr class="separador">

    <div class="row">
      <!-- Fila 5 ------------------------------------------------------>
      <div class="col-sm-3 form-group">
        <label for="email">Serie</label>
        <input type="" class="form-control mayuscula" id="n_serie" placeholder="SERIE" name="n_serie" value="{{$datos_asignacion[0]->csSerie ?? ''}}">
      </div>

      <div class="col-sm-3 form-group">
        <label for="email">Modelo</label>
        <input type="" class="form-control mayuscula" id="n_modelo" placeholder="MODELO" style="pointer-events: none" readonly="readonly" required name="n_modelo" value="{{$datos_asignacion[0]->csModelo ?? ''}}">
      </div>

      <div class="col-sm-3 form-group">
        <label for="email">Contador B/N</label>
        <input type="number" onKeyPress="return soloNumeros(event)" class="form-control" id="n_contador" placeholder="CONTADOR B/N" required name="n_contador" value="{{$datos_asignacion[0]->cnContador ?? ''}}">
      </div>

      <div class="col-sm-3 form-group">
        <label for="email">Contador color</label>
        <input type="number" onKeyPress="return soloNumeros(event)" class="form-control" id="n_contadorcolor" placeholder="CONTADOR COLOR" required name="n_contadorcolor" value="{{$datos_asignacion[0]->cnContador_color ?? ''}}">
      </div>

      <!-- Fila 6 ------------------------------------------------------>
      <div class="col-sm-6 form-group check-input my-3">
        <div class="custom-control custom-checkbox">
          <input type="checkbox" class="custom-control-input" id="equipo_sucursal" name="equipo_sucursal" value="si" {{ (! empty(old('equipo_sucursal')) ? 'checked' : '') }}>
          <label class="custom-control-label" for="equipo_sucursal">El equipo no se encuentra en la sucursal</label>
        </div>
      </div>
    </div>

    <!-- Fila 7 ------------------------------------------------------>
    <!-- Accsesorios -->
    <div class="seccion-filtro">Accesorios</div>
    <hr class="separador">

    <div class="row">
      <!-- FILA 8.1 -->
      <div class="col-md-3 form-group check-input">
        <div class="custom-control custom-checkbox">
          <input class="ip-111 custom-control-input" type="checkbox" id="bandeja_adicional" name="bandeja_adicional" required value="si" {{ (! empty(old('bandeja_adicional')) ? 'checked' : '') }}>
          <label class="custom-control-label" for="bandeja_adicional">Bandeja adicional</label>
        </div>
      </div>

      <div class="col-sm-3 form-group check-input">
        <div class="custom-control custom-checkbox">
          <input class="ip-111 custom-control-input" type="checkbox" id="mueble" name="mueble" required value="si" {{ (! empty(old('mueble')) ? 'checked' : '') }}>
          <label class="custom-control-label" for="mueble">Mueble</label>
        </div>
      </div>

      <div class="col-sm-3 form-group check-input">
        <div class="custom-control custom-checkbox">
          <input class="ip-111 custom-control-input" type="checkbox" id="kit_lector" name="kit_lector" required value="si" {{ (! empty(old('kit_lector')) ? 'checked' : '') }}>
          <label class="custom-control-label" for="kit_lector">Kit lector</label>
        </div>
      </div>

      <div class="col-sm-3 form-group check-input">
        <div class="custom-control custom-checkbox">
          <input class="ip-111 custom-control-input" type="checkbox" id="memoria_sd" name="memoria_sd" required value="si" {{ (! empty(old('memoria_sd')) ? 'checked' : '') }}>
          <label class="custom-control-label" for="memoria_sd">Memoria SD</label>
        </div>
      </div>

      <!-- FILA 8.2 -->
      <div class="col-sm-3 form-group check-input">
        <div class="custom-control custom-checkbox">
          <input class="ip-111 custom-control-input" type="checkbox" id="cable_red" name="cable_red" required value="si" {{ (! empty(old('cable_red')) ? 'checked' : '') }}>
          <label class="custom-control-label" for="cable_red">Cable red</label>
        </div>
      </div>

      <div class="col-sm-3 form-group check-input">
        <div class="custom-control custom-checkbox">
          <input class="ip-111 custom-control-input" type="checkbox" id="cable_poder" name="cable_poder" required value="si" {{ (! empty(old('cable_poder')) ? 'checked' : '') }}>
          <label class="custom-control-label" for="cable_poder">Cable de poder</label>
        </div>
      </div>
    </div>

    <div class="seccion-filtro mt-4">Equipo</div>
    <hr class="separador">

    <div class="row">
      <div class="col-sm-12 form-group check-input check-space">
        <div class="custom-control custom-checkbox">
          <input type="checkbox" class="custom-control-input" id="equipo_ensamblado" name="equipo_ensamblado" value="si" {{ (! empty(old('equipo_ensamblado')) ? 'checked' : '') }}>
          <label class="custom-control-label" for="equipo_ensamblado">Equipo embalado (si la respuesta es no, indicar el motivo en observaciones)</label>
        </div>
      </div>

      <div class="col-sm-12 form-group">
        <label for="cambio">Observaciones</label>
        <textarea required class="form-control" id="11observaciones" name="observaciones" rows="4"></textarea>
      </div>

      @if ( $datos_asignacion[0]->estado_inicio != 0 || $datos_asignacion[0]->estado_inicio != "" )
      <div class="col-sm-12 form-group">
        <button class="btn btn-secundario w-25 asignarimagen" type="button">Subir imágenes</button>
        <!--<button type="button" class="btn btn-secundario w-25" data-toggle="modal" data-target="#modal_fotos_android">Android</button>	-->
      </div>
      @endif
    </div>

    <div class="seccion-filtro mt-4">Datos</div>
    <hr class="separador">

    <div class="row">
      <!-- DATOS DEL TÉCNICO-->
      <div class="col-sm-6 form-group">
        <div class="row">
          <div class="col-sm-12 form-group">
            <label for="email">Datos del Técnico</label>
            <input type="text" value="{{$datos_asignacion[0]->nombre_uno." ".$datos_asignacion[0]->apellido_uno." ".$datos_asignacion[0]->apellido_dos}}" style="pointer-events: none" readonly="readonly" class="form-control" id="">
          </div>

          <div class="col-sm-12 form-group">
            <label for="email">Firma Técnico</label>
          </div>
        </div>
      </div>

      <!-- DATOS DEL CONTACTO-->
      <div class="col-sm-6 form-group">
        <div class="row">
          <div class="col-sm-12 form-group">
            <label for="email">Datos del Contacto</label>
            <input type="text" value="" required class="form-control" id="d_contacto" placeholder="Contacto" name="contacto">
          </div>

          <div class="col-sm-12 form-group">
            <label for="email">Firma Contacto</label>
            @if ( $datos_asignacion[0]->estado_inicio != 0 || $datos_asignacion[0]->estado_inicio != "" )

            <div class="row">
              <div class="col-sm-12 form-group check-input check-space">
                <div class="custom-control custom-checkbox">
                  <input type="checkbox" class="custom-control-input" id="no_firma_cliente" name="no_firma_cliente" value="si">
                  <label class="custom-control-label" for="no_firma_cliente">Cliente se niega a firmar</label>
                </div>
              </div>

              <div class="col-sm-12 form-group">
                <div id="contenido" class="text-center bg-destacar pt-3">
                  @csrf
                  <table class="mx-auto">
                    <tr>
                      <td>
                        <canvas class="rounded-lg" id="pizarra" name="img_firma"></canvas>
                      </td>
                    </tr>
                  </table>
                  <div class="mt-2 text-center">
                    <input type="text" style="display:none" id="imagen_firma" value="" name="imagen_firma">
                    <input type="text" style="display:none" id="check" value="{{Crypt::encryptString($datos_asignacion[0]->idCheckRetiros)}}" name="check">
                    <button type='button' class="btn btn-prim col-sm-5 form-group" id="enviar_firma" onclick="guardandofirna()">Guardar</button>
                    <button type='button' class="btn btn-secundario col-sm-5 form-group" id="borrars" onclick="borrar()">Borrar</button>
                    <input type='hidden' name='imagen' id='imagen'>
                  </div>
                </div>

                <button class="btn btn-secundario btn-block my-2" type="button">Firma masiva</button>
              </div>

              <div class="col-sm-12 form-group">
                <div class="selectBox" onclick="showCheckBoxes2()">
                  <select class="custom-select mayuscula">
                    <option>Seleccionar checks</option>
                  </select>
                  <div class="overSelect"></div>
                </div>
                <div id="checkboxes2">
                  <label for="one">
                    @if(!empty($datos_retiros))
                    @foreach ($datos_retiros as $checks)
                    <input type="checkbox" id="jerarquia" name="jerarquia[]" value="{{$checks->idcheck}}">{{strtoupper($checks->Csdireccion)}} - {{strtoupper($checks->Cscliente)}} - {{$checks->CsSerie ?? 'Sin serie'}}
                    @endforeach
                    @endif
                  </label>
                </div>
              </div>
            </div>

            @endif
          </div>
        </div>
      </div>
    </div>

    <div class="seccion-filtro mt-4">Agregar estado</div>
    <hr class="separador">

    <div class="row">
      <div class="col-sm-6 form-group">
        <label for="">Estado</label>
        <select name="estado" required class="custom-select mayuscula" id="estado">
          <option class="mayuscula" value="" required disabled selected>Seleccione</option>
          <option id="_id_finalizado" class="mayuscula" value="finalizado"> Finalizado (envalado) </option>
          <option id="id_noretirado" class="mayuscula" value="no retirado"> No retirado (conectado sin retiro) </option>
          <option id="id_desconectado" class="mayuscula" value="desconectado"> Desconectado (Arrumbado) </option>
        </select>
      </div>
    </div>

    {{-- fin del display --}}
    @if ( $datos_asignacion[0]->estado_inicio != 0 || $datos_asignacion[0]->estado_inicio != "" )
    <div class="container form-group text-center mt-4 mb-5">
      <button class="btn btn-prim w-25" type="submit">Guargar</button>
    </div>
    @endif
  </div>
  </div>
</form>

<!-- FIN BARRA DE BUSQUEDA -->

<!-- MODAL IMAGENES -->
<div class="modal fade" id="modal_historial_retiros" role="dialog">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <div class="seccion-modal">Carga de imagen retiro</div>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      <hr class="separador mx-4">

      <div class="modal-body">
        <form enctype="multipart/form-data" id="formuploadajax" method="post">
          @csrf
          <div class="container">
            <!-- CARGA DE IMAGEN DE RETIRO -->
            <div class="row">
              <input type="text" style="display:none" name="check_listRetiro" id="" value="{{$datos_asignacion[0]->idCheckRetiros}}">

              <div class="col-sm-12 form-group">
                Adjunte la imagen que se solicita a continuación
              </div>

              <!-- 1 -->
              <div class="col-sm-12 form-group">
                <label for="email" class="custom file espacio_carga_img">Fotografía de la página de estado</label>
                <input type="file" id="cargafoto1" name="cargafoto1">
              </div>
            </div>

            <!-- FIN CARGA DE IMAGEN DE RETIRO -->

            <div class="container form-group text-center mt-4">
              <button class="btn btn-secundario w-25" type="button">Cancelar</button>
              <button class="btn btn-prim w-25" type="submit">Subir imágenes</button>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>


<div class="modal fade" id="modal_fotos_android" role="dialog">
  <div class="modal-dialog">
    <div class="modal-content">

      <div class="modal-header">
        <div class="seccion-modal">Ingresar el siguiente ID en la Aplicacción</div>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      <hr class="separador mx-4">

      <div class="modal-body">
        <div class="container">
          <div class="row">
            <!-- CARGA DE IMÁGENES DE INSTALACIÓN -->

            <div class="col-sm-12 text-center form-group">
              <h1 class="rounded-lg border py-2">ID = {{$datos_asignacion[0]->idCheckRetiros}}</h1>
            </div>
          </div>

          <div class="container form-group text-center mt-4">
            <button class="btn btn-prim w-25" type="button" data-dismiss="modal">Cancelar</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

@endsection
<script>
  var lineas = [];


  function borrar() {

    // Creamos nuestro canvas
    var canvas = document.getElementById("pizarra");
    var ctx = canvas.getContext("2d");

    // Borramos el ÃƒÂ¡rea que nos interese
    ctx.clearRect(0, 0, canvas.width, canvas.height);
    //    console.log(lineas);
    lineas = [];

  }

  $(function() {

    var element = $("#pizarra"); // global variable
    var getCanvas; // global variable

    function downloadURI(uri, name) {
      var link = document.createElement("a");
      link.download = name;
      link.href = uri;

    }
    html2canvas(element, {
      onrendered: function(canvas) {
        getCanvas = canvas;
      }
    });




    //======================================================================
    // VARIABLES
    //======================================================================
    let miCanvas = document.querySelector('#pizarra');

    let correccionX = 0;
    let correccionY = 0;
    let pintarLinea = false;

    let posicion = miCanvas.getBoundingClientRect()
    correccionX = posicion.x;
    correccionY = posicion.y;

    miCanvas.width = 250;
    miCanvas.height = 250;

    //======================================================================
    // FUNCIONES
    //======================================================================

    /**
     * Funcion que empieza a dibujar la linea
     */
    function empezarDibujo() {
      pintarLinea = true;
      lineas.push([]);
    };

    /**
     * Funcion dibuja la linea
     */
    function dibujarLinea(event) {
      event.preventDefault();
      if (pintarLinea) {
        let ctx = miCanvas.getContext('2d')
        // Estilos de linea
        ctx.lineJoin = ctx.lineCap = 'round';
        ctx.lineWidth = 5;
        // Color de la linea
        ctx.strokeStyle = '#000';
        // Marca el nuevo punto
        let nuevaPosicionX = 0;
        let nuevaPosicionY = 0;
        if (event.changedTouches == undefined) {
          // Versión ratón
          nuevaPosicionX = event.layerX;
          nuevaPosicionY = event.layerY;
        } else {
          // Versión touch, pantalla tactil
          nuevaPosicionX = event.changedTouches[0].pageX - correccionX;
          nuevaPosicionY = event.changedTouches[0].pageY - correccionY;
        }
        // Guarda la linea
        lineas[lineas.length - 1].push({
          x: nuevaPosicionX,
          y: nuevaPosicionY
        });
        // Redibuja todas las lineas guardadas
        ctx.beginPath();
        lineas.forEach(function(segmento) {
          ctx.moveTo(segmento[0].x, segmento[0].y);
          segmento.forEach(function(punto, index) {
            ctx.lineTo(punto.x, punto.y);
          });
        });
        ctx.stroke();
      }
    }

    /**
     * Funcion que deja de dibujar la linea
     */
    function pararDibujar() {
      pintarLinea = false;
    }

    //======================================================================
    // EVENTOS
    //======================================================================

    // Eventos raton
    miCanvas.addEventListener('mousedown', empezarDibujo, false);
    miCanvas.addEventListener('mousemove', dibujarLinea, false);
    miCanvas.addEventListener('mouseup', pararDibujar, false);

    // Eventos pantallas táctiles
    miCanvas.addEventListener('touchstart', empezarDibujo, false);
    miCanvas.addEventListener('touchmove', dibujarLinea, false);




    //$("#formCanvas").on("submit", function(e){


    // });



  });

  function guardandofirna() {


    // <input type="text" style="display: "  id="imagen_firma" value="" name="imagen_firma">
    //<input type="text" style="display: "  id="check" value="{{Crypt::encryptString($datos_asignacion[0]->idCheckRetiros)}}" name="check">


    url_img = document.getElementById("pizarra").toDataURL('image/png');

    $("#imagen_firma").val(url_img);

    // var formData = new FormData(document.getElementById("formCanvas"));
    var _token = $('input[name="_token"]').val();

    var imagen_firma = $("#imagen_firma").val();
    var check = $("#check").val();
    var a = document.getElementById("jerarquia");
    //alert(check);
    // alert(id);

    //   formData.append("dato", url_img);
    //formData.append(f.attr("name"), $(this)[0].files[0]);
    $.ajax({
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },

        url: "{{ route('guardarfirmaretiro') }}",
        type: "post",
        //dataType: "html",
        data: {
          'imagen_firma': imagen_firma,
          'check': check,
          a
        },

        //   cache: false,
        //   contentType: false,
        //   processData: false,
        success: function(response) {
          alert(response);
        },
        error: function(xhr, status) {
          alert('Disculpe, ha ocurrido un problema, intente mas tarde');
        }
      })
      .done(function(res) {
        //    alert("error");
      });
  }

  $(document).ready(function() {

    //////////////////////////////////////////////////////
    $("#formuploadajax").on("submit", function(e) {
      e.preventDefault();
      var f = $(this);
      var formData = new FormData(document.getElementById("formuploadajax"));
      formData.append("dato", "valor");
      //formData.append(f.attr("name"), $(this)[0].files[0]);
      $.ajax({
          url: "{{ route('save.imagenchecklistRetiro') }}",
          type: "post",
          dataType: "html",
          data: formData,
          cache: false,
          contentType: false,
          processData: false,
          success: function(response) {
            console.log(response);
            $("#mensaje-text").text("Imagenes Guardadas");
            alert(response);
            $("#modal_historial_retiros").modal('hide');
          }
        })
        .done(function(res) {
          $("#mensaje").html("Respuesta: " + res);
        });
    });



    $('.asignarimagen').click(function() {

      $("#modal_historial_retiros").modal('show');
    });


    $('#equipo_sucursal').on('click', function() {
      if ($(this).is(':checked')) {
        valor = "";
        valor2 = ".El equipo no se encuentra en la sucursal,";
        valor += " sin " + valor2 + ',';
        $("#observaciones").val(valor);


        $('#mueble').removeAttr("required");
        $('#cable_poder').removeAttr("required");
        $('#cable_red').removeAttr("required");
        $('#memoria_sd').removeAttr("required");
        $('#kit_lector').removeAttr("required");
        $('#equipo_ensamblado').removeAttr("required");
        $('#negarse_firma').removeAttr("required");
        $('#bandeja_adicional').removeAttr("required");
        $('#n_serie').removeAttr("required");
        $('#n_modelo').removeAttr("required");
        $('#n_contador').removeAttr("required");
        $('#n_contadorcolor').removeAttr("required");
        $('#d_contacto').removeAttr("required");



      } else {

        valor2 = "El equipo no se encuentra en la sucursal";

        var valor = $("#observaciones").val();
        $("#observaciones").val(valor.replace(" sin " + valor2 + ',', ""));




        $('#mueble').attr("required", true);
        $('#cable_poder').attr("required", true);
        $('#cable_red').attr("required", true);
        $('#memoria_sd').attr("required", true);
        $('#kit_lector').attr("required", true);
        $('#equipo_ensamblado').attr("required", true);
        $('#negarse_firma').attr("required", true);
        $('#bandeja_adicional').attr("required", true);
        $('#n_serie').attr("required", true);
        $('#n_modelo').attr("required", true);
        $('#n_contador').attr("required", true);
        $('#n_contadorcolor').attr("required", true);
        $('#d_contacto').attr("required", true);


      }
    });



    //funcion para cambiar los tres estados
    $("#mueble").data('checked', 0).on('click', function() {
      el = $(this);
      tres_estados(el, 'mueble');
    });
    $("#cable_poder").data('checked', 0).on('click', function() {
      el = $(this);
      tres_estados(el, 'cable_poder');
    });
    $("#cable_red").data('checked', 0).on('click', function() {
      el = $(this);
      tres_estados(el, 'cable_red');
    });
    $("#memoria_sd").data('checked', 0).on('click', function() {
      el = $(this);
      tres_estados(el, 'memoria_sd');
    });
    $("#kit_lector").data('checked', 0).on('click', function() {
      el = $(this);
      tres_estados(el, 'kit_lector');
    });
    $("#equipo_ensamblado").data('checked', 0).on('click', function() {
      el = $(this);
      tres_estados(el, 'equipo_ensamblado');
    });
    $("#negarse_firma").data('checked', 0).on('click', function() {
      el = $(this);
      tres_estados(el, 'negarse_firma');
    });
    $("#bandeja_adicional").data('checked', 0).on('click', function() {
      el = $(this);
      tres_estados(el, 'bandeja_adicional');
    });



  })

  //funciones individuales

  function tres_estados(el, id_chec) {

    switch (el.data('checked')) {

      case 0: //cehckeado
        el.data('checked', 1);
        el.prop('indeterminate', false);
        el.prop('checked', true);

        var valor2 = id_chec;

        var valor = $("#observaciones").val();


        $("#" + id_chec).val("si");
        $("#observaciones").val(valor.replace(" sin " + id_chec + ',', ""));

        //  console.log('true');
        break;


      case 1:
        el.data('checked', 2);
        el.prop('indeterminate', true);
        el.prop('checked', true);

        var valor2 = id_chec;

        var valor = $("#observaciones").val();

        valor += " sin " + valor2 + ',';

        $("#observaciones").val(valor);



        //console.log('null');
        $("#" + id_chec).val("no");


        break;


      default:
        el.data('checked', 0);
        el.prop('indeterminate', false);
        el.prop('checked', false);
        //console.log('false');
        $("#" + id_chec).val("");
        var valor2 = id_chec;

        var valor = $("#observaciones").val();


        $("#observaciones").val(valor.replace(" sin " + id_chec + ',', ""));
    }
  }

  function soloNumeros(e) {

    var key = window.Event ? e.which : e.keyCode
    return (key >= 48 && key <= 57)
  }
</script>
<script>
  $(document).ready(function() {
    var option1 = document.getElementById('id_finalizado');
    $(".ip-111").each(function(index) {
      $(this).on("click", function() {
        if ($("#bandeja_adicional").is(":checked") &&
          $("#mueble").is(":checked") &&
          $("#kit_lector").is(":checked") &&
          $("#memoria_sd").is(":checked") &&
          $("#cable_red").is(":checked") &&
          $("#cable_poder").is(":checked")
        ) {
          option1.disabled = false;
        } else {
          option1.disabled = true;
        }
      });
    });

    $('#estado option:selected').each(function() {
      if (this.selected) {
        //$('#mueble').removeAttr("required");
        //$('#cable_poder').removeAttr("required");
        //$('#cable_red').removeAttr("required");
        //$('#memoria_sd').removeAttr("required");
        //$('#kit_lector').removeAttr("required");
        //$('#equipo_ensamblado').removeAttr("required");
        //$('#negarse_firma').removeAttr("required");
        //$('#bandeja_adicional').removeAttr("required");
        //$('#n_serie').removeAttr("required");
        //$('#n_modelo').removeAttr("required");
        //$('#n_contador').removeAttr("required");
        //$('#n_contadorcolor').removeAttr("required");
        //$('#d_contacto').removeAttr("required");
      }
    });

  });
</script>
<script>
  var expanded = false;

  function showCheckBoxes2() {
    checkboxes = document.getElementById("checkboxes2");
    if (!expanded) {
      checkboxes.style.display = "block";
      expanded = true;
    } else {
      checkboxes.style.display = "none";
      expanded = false;
    }
  }
</script>