@extends('menu/menu')
<script src="{{ asset('js/jquery-3.4.1.min.js') }}" ></script>
<script src="https://html2canvas.hertzen.com/dist/html2canvas.js"></script>
@section('content')
<div class="container my-5">
    <div class="row">
        <div class="col-sm-12 form-group">
            <div id="contenido" class="container text-center bg-destacar mb-3 mt-5" id='formCanvas'>
                <div class="container py-3 d-flex flex-wrap">
                    <div class="mx-auto mb-3">
                        {{-- Pizarra --}}
                        <canvas class="rounded-lg" id="pizarra" name="img_firma" width="250" height="250"></canvas>
                    </div>
                    <div class="col-md">
                        <input type="text" style="display: none" id="imagen_firma" value="" name="imagen_firma">
                        <input type="text" style="display:none" id="check"  value="{{Crypt::encryptString($id_asig)}}" name="check">
                        <button class="btn btn-prim btn-block" type='button' onclick="firmar()" id="enviar_firma">Guardar</button>
                        <button class="btn btn-secundario btn-block" type='button' id="borrars" onclick="borrar()">Borrar</button>
                    </div>
                </div>
                <input type='hidden' name='imagen' id='imagen' />
            </div>
        </div>
    </div>
</div>
@endsection
<script>
    function firmar() {
        url_img = document.getElementById("pizarra").toDataURL('image/png');
        console.log(check);
        $("#imagen_firma").val(url_img);
        var formData = new FormData();
        formData.append("pizarra", $("#pizarra").val());
        formData.append("imagen_firma", url_img);
        formData.append("id_asig", $("#check").val());
        var a = document.getElementById("jerarquia");
        $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "{{ route('saveFirmaCapacitacion') }}",
                type: "post",
                dataType: "html",
                data: formData,
                a,
                cache: false,
                contentType: false,
                processData: false,
                success: function(response) {
                    alert(response);
                    window.close();
                },
                error: function(xhr, status) {
                    alert('Disculpe, ha ocurrido un problema, intente mas tarde');
                }
            })
            .done(function(res) {});
    }
    var lineas = [];

    function borrar() {
        // Creamos nuestro canvas
        var canvas = document.getElementById("pizarra");
        var ctx = canvas.getContext("2d");
        // Borramos el ÃƒÂ¡rea que nos interese
        ctx.clearRect(0, 0, canvas.width, canvas.height);
        //	console.log(lineas);
        lineas = [];
    }

    $(function() {
        var element = $("#pizarra"); // global variable
        var getCanvas; // global variable
        function downloadURI(uri, name) {
            var link = document.createElement("a");
            link.download = name;
            link.href = uri;
        }
        html2canvas(element, {
            onrendered: function(canvas) {
                getCanvas = canvas;
            }
        });
        //======================================================================
        // VARIABLES
        //======================================================================
        let miCanvas = document.querySelector('#pizarra');

        let correccionX = 0;
        let correccionY = 0;
        let pintarLinea = false;

        let posicion = miCanvas.getBoundingClientRect()
        correccionX = posicion.x;
        correccionY = posicion.y;

        miCanvas.width = 250;
        miCanvas.height = 250;

        //======================================================================
        // FUNCIONES
        //======================================================================

        //borrar	

        /**
         * Funcion que empieza a dibujar la linea
         */
        function empezarDibujo() {
            pintarLinea = true;
            lineas.push([]);
        };

        /**
         * Funcion dibuja la linea
         */
        function dibujarLinea(event) {
            event.preventDefault();
            if (pintarLinea) {
                let ctx = miCanvas.getContext('2d')
                // Estilos de linea
                ctx.lineJoin = ctx.lineCap = 'round';
                ctx.lineWidth = 5;
                // Color de la linea
                ctx.strokeStyle = '#000';

                // Marca el nuevo punto
                let nuevaPosicionX = 0;
                let nuevaPosicionY = 0;
                if (event.changedTouches == undefined) {
                    // Versión ratón;
                    nuevaPosicionX = event.layerX;
                    nuevaPosicionY = event.layerY;
                } else {
                    //console.log("a");
                    // Versión touch, pantalla tactil
                    nuevaPosicionX = event.changedTouches[0].pageX - correccionX;
                    nuevaPosicionY = event.changedTouches[0].pageY - correccionY;
                    //console.log(nuevaPosicionY);
                }
                // Guarda la linea
                lineas[lineas.length - 1].push({
                    x: nuevaPosicionX,
                    y: nuevaPosicionY
                });
                // Redibuja todas las lineas guardadas
                ctx.beginPath();
                lineas.forEach(function(segmento) {
                    ctx.moveTo(segmento[0].x, segmento[0].y);
                    segmento.forEach(function(punto, index) {
                        ctx.lineTo(punto.x, punto.y);
                    });
                });
                ctx.stroke();
            }
        }

        /**
         * Funcion que deja de dibujar la linea
         */
        function pararDibujar() {
            pintarLinea = false;
        }
        //======================================================================
        // EVENTOS
        //======================================================================
        // Eventos raton
        miCanvas.addEventListener('mousedown', empezarDibujo, false);
        miCanvas.addEventListener('mousemove', dibujarLinea, false);
        miCanvas.addEventListener('mouseup', pararDibujar, false);
        // Eventos pantallas táctiles
        miCanvas.addEventListener('touchstart', empezarDibujo, false);
        miCanvas.addEventListener('touchmove', dibujarLinea, false);
        ////////////////////////////////////////
        //fin de la fucn
    });
</script>