@extends('menu/menu')
@section('content')

<div class="container mt-5">
    <div class="title-vista mt-4">ACCESORIOS</div>
</div>

<div class="container">
    <div class="row">
        <div class="col-sm-4 form-group">
            <label for="">ID</label>
            <input type="" class="form-control mayuscula" id="id_accesorio" placeholder="ID" name="" value="" oninput="myFunction()">
        </div>
        <div class="col-sm-4 form-group">
            <label for="">Número de parte</label>
            <input type="" class="form-control mayuscula" id="articulo" placeholder="Número de parte" name="" value="" oninput="myFunction()">
        </div>
        <div class="col-sm-4 form-group">
            <label for="">Nombre de la pieza</label>
            <input type="" class="form-control mayuscula" id="keywords" placeholder="Nombre de la pieza" name="" value="" oninput="myFunction()">
        </div>
    </div>
    
    <div class="container table-responsive mb-5 p-sm-0">
        <div class="table table-striped table-hover">
            <table class="table table-striped table-hover">
                <tbody>
                    <thead class="color-head">
                        <th scope="col">ID</th>
                        <th scope="col">Número de parte</th>
                        <th scope="col">Nombre de la pieza</th>
                    </thead>
                <tbody id="agregar_accesorios">
                    @foreach ($accesorios as $key => $los_datos)
                    <tr>
                        <td class="td-val">
                            {{$los_datos->id}}
                        </td>
                        <td class="td-val">
                            {{$los_datos->articulo}}
                        </td>
                        <td class="td-val">
                            {{$los_datos->descripcion}}
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    
</div>

@endsection
<script>
    function myFunction() {
        descripcion = $('#keywords').val();
        id = $('#id_accesorio').val();
        articulo = $('#articulo').val();
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            type: 'POST',
            url: "{{ route('go.search_accesorios2') }}",
            data: {
                'id': id,
                'articulo': articulo,
                'descripcion': descripcion
            },
            success: function(data) {
                $('#agregar_accesorios').empty();
                $(data).each(function(i, v) {
                    $('#agregar_accesorios').append(
                        '<tr>' +
                        '<td>' + v.id + '</td>' +
                        '<td>' + v.articulo + '</td>' +
                        '<td>' + v.descripcion + '</td>' +
                        '</tr');
                })
            },
            error: function(xhr, status) {
                alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
            }
        });
    };
</script>