@extends('menu/menu')
<!--<script src="https://ajax.aspnetcdn.com/ajax/jQuery/jquery-3.4.1.min.js</script>--> 


@section('content')

@if ( session('mensaje') )
<div class="alert alert-success">{{ session('mensaje') }}</div>
@endif

<div class="container-fluid">

        <div class="container-fluid">
            <div class="container">
                <!-- BARRA DE BUSQUEDA -->
                <h1 style="margin-top: 50px">Mantenedor kilometros</h1>
                <form action="{{route('filtros_mantenedor_kilometros')}}" method="GET">
                    @csrf
                <div class="row reex" style="height: auto">
                    <div class="container col-12" style="margin-top: 10px">
                        <h2><strong>Filtrar por</strong></h2>
                    </div>
                    <!--AQUI SE CARGA EL SELECT DE CIUDAD BASE-->
                    <div class="container col-sm form-group">
                        <label for="clientes"><h2>Ciudad Base</h2></label>
                        <select name="ciudad_base" class="custom-select" id="clientes">
                            <option selected disabled>Seleccionar</option>
                            @foreach ($ciudad_base as $datos_ciudad_base)
                                <option value="{{$datos_ciudad_base->id}}">{{ucfirst(strtolower($datos_ciudad_base->ciudad_base))}}</option>
                            @endforeach
                        </select>
                    </div>
                    <!--FIN SELECT DE CLIENTE-->
                    <!--AQUI SE CARGA EL SELECT DE CIUDAD DESTINO-->
                    <div class="container col-sm form-group">
                        <label for="clientes"><h2>Ciudad</h2></label>
                        <select name="ciudad_destino" class="custom-select" id="clientes">
                            <option selected disabled>Seleccionar</option>
                            @foreach ($ciudades as $ciudad)
                                <option value="{{$ciudad->ciudad}}">{{ucfirst(strtolower($ciudad->ciudad))}}</option>
                            @endforeach
                        </select>
                    </div>
                    <!--FIN SELECT DE CLIENTE-->
					<div class="container col-sm" style="margin-top: 32px">
						<button type="buscar" class="btn btn-info">Buscar</button>
                	</div>
                </div>
            </form>
                <!-- FIN BARRA DE BUSQUEDA -->
                <button  class="btn btn-primary mt-3" data-toggle="modal" data-target="#modalCrear">Crear</button>
          
            </div>
        </div>
   
</div>
<!-- TABLA DE RESULTADOS DE BUSQUEDA -->
<div class="container" style="margin-top: 20px">
    <div class="conteiner row rein table-responsive-md" style="border: 5px solid #e8f5fe">
        <table class="table table-sm table-bordered table-responsive-lg table-striped table-hover text-center">
            <!-- ENCABEZADO -->
            <thead>
                <tr>
                    <th><h3>#</h3></th>
                    <th><h3>Ciudad Base</h3></th>
                    <th><h3>Ciudad Destino</h3></th>
                    <th><h3>Kilometros</h3></th>
                    <th><h3>Acciones</h3></th>
                </tr>
            </thead>
            <!-- FIN ENCABEZADO -->
            <!-- RESULTADOS -->
            <tbody>
                @if(!empty($kilometros))
                @foreach ($kilometros as  $key => $los_datos)
                    <tr>
                        <th><h4 style="margin-bottom:0;">{{$los_datos->id}}</h4></th>
                        <!-- CIUDAD BASES -->
                        @if($los_datos->id_ciudad_bases == 1)<th><h4 style="margin-bottom:0;">Iquique</h4></th>
                        @elseif($los_datos->id_ciudad_bases == 2)<th><h4 style="margin-bottom:0;">Antofagasta</h4></th>
                        @elseif($los_datos->id_ciudad_bases == 3)<th><h4 style="margin-bottom:0;">Copiapo</h4></th>
                        @elseif($los_datos->id_ciudad_bases == 4)<th><h4 style="margin-bottom:0;">La Serena</h4></th>
                        @elseif($los_datos->id_ciudad_bases == 5)<th><h4 style="margin-bottom:0;">Valparaiso</h4></th>
                        @elseif($los_datos->id_ciudad_bases == 6 || $los_datos->id_ciudad_bases == 7)<th><h4 style="margin-bottom:0;">Talca</h4></th>
                        @elseif($los_datos->id_ciudad_bases == 8)<th><h4 style="margin-bottom:0;">Concepción</h4></th>
                        @elseif($los_datos->id_ciudad_bases == 9)<th><h4 style="margin-bottom:0;">Temuco</h4></th>
                        @elseif($los_datos->id_ciudad_bases == 10)<th><h4 style="margin-bottom:0;">Osorno</h4></th>
                        @elseif($los_datos->id_ciudad_bases == 11)<th><h4 style="margin-bottom:0;">Puerto Aysen</h4></th>
                        @elseif($los_datos->id_ciudad_bases == 12)<th><h4 style="margin-bottom:0;">Punta Arenas</h4></th>
                        @elseif($los_datos->id_ciudad_bases == 13)<th><h4 style="margin-bottom:0;">Santiago</h4></th>
                        @elseif($los_datos->id_ciudad_bases == 14)<th><h4 style="margin-bottom:0;">Osorno</h4></th>
                        @elseif($los_datos->id_ciudad_bases == 15)<th><h4 style="margin-bottom:0;">Arica</h4></th>
                        @endif
                        <!-- CIUDAD DESTINO -->
                        <th><h4 style="margin-bottom:0;">{{$los_datos->ciudad}}</h4></th>
                        <!-- KILOMETROS -->
                        <th><h4 style="margin-bottom:0;">{{$los_datos->kilometros}}</h4></th>
                        <th class="d-flex justify-content-around">
                        <a title="modificar" role="button" href="#">
							<img src="{{ asset('Botones/Botones/btneditaraya.png') }}" width="24px" height="auto" data-id="{{$los_datos->id}}" class="editarkilometros">
						</a>
						
						<a class=" btns btns eliminarKilometros" data-toggle="modal" data-target="#modalEliminar" data-idEliminar="{{$los_datos->id}}">
							<img title="Eliminar !" src="{{ asset('Botones/Botones/Eliminar.png') }}" width="24px" height="auto">
						</a> 
							  	
						    
                        </th>
                    </tr>
                @endforeach
                @endif
            </tbody>
            <!-- FIN RESULTADOS -->
        </table>
        <div style="margin: 10px 0px 10px 300px;">
            {{$kilometros->links()}}
        </div>
    </div>
</div>
<!-- FIN TABLA DE RESULTADOS DE BUSQUEDA -->

<!-- Modal Eliminar-->
<div class="modal fade" id="modalEliminar" tabindex="-1" role="dialog" aria-labelledby="modalEliminarLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="modalEliminarLabel">Eliminar Registro</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>

        <form action="{{route('deleteRegistro')}}" method="GET">
        
                <input type="text" name="idkilometros" id="idKilometrosEliminar" style="display: none" hidden>
            <div class="modal-footer">
                <button type="submit" class="btn btn-danger">Eliminar</button>
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
           
            </div>
       </form>

      </div>
    </div>
  </div>

<!-- Modal crear-->
<div class="modal fade" id="modalCrear" tabindex="-1" role="dialog" aria-labelledby="modalCrearLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="modalCrearLabel">Nuevo</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>

        <form action="{{route('crearKilometros')}}" method="GET">
        
            <div class="modal-body">
                
             
                   <div>
                        <div>
                            <label for="cBase">Ciudad Base</label>
                           <select id="cBase" class="form-control" name="cBase">

                            @foreach ($ciudad_base as  $key => $los_datos)
                            
                                <option  value="{{$los_datos->id}}">{{$los_datos->ciudad_base}}</option>
                            @endforeach
                           </select>
                        </div>
                        <div>
                            <label for="cOrigen">Ciuda Origen</label>
                            <input type="text" required class="form-control" name="cOrigen" id="cOrigen">
                        </div>
                        <div>
                            <label for="crearKilometros">Kilometros</label>
                            <input type="text" required class="form-control" id="crearKilometros" name="crearKilometros">
                        </div>

                   </div>

            </div>
            <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            <button type="submit" class="btn btn-primary">Save changes</button>
            </div>
       </form>

      </div>
    </div>
  </div>



<!-- MODAL EDITAR KILOMETROS-->
<div class="modal" id="modalkilometros" data-backdrop="static">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content">
            <form action="{{route('go.editar_kilometros')}}" method="post">
            @csrf
                <div class="modal-header">
                    <h3>Cambiar Costos</h3>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="container" style="margin-top: 50px; margin-bottom: 50px">
                    <input type="text" class="form-control" id="kilometros" value="" placeholder="" name="kilometros" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;">
                    <input type="hidden" id="id_kilometro" name="id">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                    <button type="submit" class="btn btn-primary">Guardar</button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection
<!-- FIN MODAL EDITAR KILOMETROS-->
<script src="{{ asset('js/jquery-3.4.1.min.js') }}" ></script>

<script>
    
    $(document).ready(function() {

        
        $('.eliminarKilometros').click(function() {
            var id = $(this).attr("data-idEliminar");
            alert(id);
            $("#idKilometrosEliminar").val(id);
        });
        //editar kilometros
        $('.editarkilometros').click(function() {
            var id = $(this).attr("data-id");
            $("#id_kilometro").val(id);
            var _token = $('input[name="_token"]').val();
            $("#modalkilometros").modal('show');
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                method: "POST",
                url: "{{route('go.ver_datos_kilometros')}}",
                data: {
                    'id': id,
                    _token: _token
                },
                success: function(data) {
                    $("#kilometros").val(data.kilometros);
                },
                error: function(xhr, status) {
                    alert('Disculpe, ha ocurrido un problema, intente mas tarde');
                }
            });
        });
    });
</script>