@extends('menu/menu')
<script src="{{ asset('js/jquery-3.4.1.min.js') }}" ></script>
@section('content')

<div class="container-fluid">
  <form action="{{route('filtros_historial_retiro')}}" method="GET">
    <div class="container-fluid">
      <div class="container">
        <!-- BARRA DE BUSQUEDA -->
        <h1 style="margin-top: 50px">Historial de Resumen de Retiros</h1>
        <div class="row reex" style="height: auto">            
          <div class="container col-12" style="margin-top: 10px">
            <h2><strong>Filtrar por</strong></h2>
          </div>    
          <!--AQUI SE CARGA EL SELECT DEL CLIENTE-->
          <div class="container col-sm form-group">
            <label for="clientes"><h2>Cliente</h2></label>
            <select name="clientes"  class="custom-select" id="clientes">
              <option selected >Seleccionar</option>
              @foreach ($carga_selectCliente as $clientesDatos)
                @if ($clientesDatos->nombre != null) 
                  @if($clientesDatos->id == $clientes) 
                    <option selected value="{{$clientesDatos->id}}">{{ucfirst(strtolower($clientesDatos->nombre))}}</option>
                  @else
                    <option value="{{$clientesDatos->id}}">{{ucfirst(strtolower($clientesDatos->nombre))}}</option>
                  @endif
                @endif
              @endforeach
            </select>
          </div>
          <!--FIN SELECT DE CLIENTE-->    
          <!--AQUI SE CARGA EL SELECT DE COMUNA-->
          <div class="container col-sm form-group">
            <label for="comuna"><h2>Comuna</h2></label>
            @if(!empty($disable))
            <select name="comuna"  class="custom-select" id="comuna">
            @else 
            <select name="comuna" disabled class="custom-select" id="comuna">
            @endif
              <option selected disabled>Seleccionar</option>
              <option selected  value ="" >Todos</option>
              @foreach ($carga_selectComuna as $comunasDatos)
                @if ($comunasDatos->comuna != null) 
                  @if($comunasDatos->comuna == $comuna) 
                    <option selected value="{{$comunasDatos->comuna}}">{{ucfirst(strtolower($comunasDatos->comuna))}}</option>
                  @else
                    <option value="{{$comunasDatos->comuna}}">{{ucfirst(strtolower($comunasDatos->comuna))}}</option>
                  @endif
                @endif
              @endforeach
            </select>
          </div>
          <!--FIN SELECT DE COMUNA-->    
          <!--AQUI SE CARGA EL SELECT DIRECCION-->
          <div class="container col-sm-4 form-group">
            <label for="direccion"><h2>Dirección</h2></label>
            @if(!empty($disable))
            <select name="direccion"  class="custom-select" id="direccion">
            @else 
            <select name="direccion" disabled class="custom-select" id="direccion">
            @endif
              <option selected disabled>Seleccionar</option>
              <option selected  value ="" >Todos</option>
              @foreach ($carga_selectDireccion as $direcciones)
                @if ($direcciones->direccion != null) 
                  @if($direcciones->direccion == $direccion) 
                    <option selected value="{{$direcciones->direccion}}">{{ucfirst(strtolower($direcciones->direccion))}}</option>
                  @else
                    <option value="{{$direcciones->direccion}}">{{ucfirst(strtolower($direcciones->direccion))}}</option>
                  @endif
                @endif
              @endforeach
            </select>
          </div>
          <!--FIN DE SELECT DIRECCION-->    
          <!--AQUI SE CARGA EL SELECT SUCURSAL-->
          <div class="container col-sm-4 form-group">
            <label for="cuisucursal"><h2>CUI</h2></label>
            @if(!empty($disable))
            <select name="cuisucursal"  class="custom-select" id="cuisucursal">
            @else 
            <select name="cuisucursal" disabled class="custom-select" id="cuisucursal">
            @endif                                                        
              <option selected disabled>Seleccionar</option>
              <option selected  value ="" >Todos</option>
              @foreach ($carga_selectSucursal as $sucursales)
                @if ($sucursales->cuisucursal != null) 
                  @if($sucursales->cuisucursal == $cuisucursal) 
                    <option selected value="{{$sucursales->cuisucursal}}">{{ucfirst(strtolower($sucursales->cuisucursal))}}</option>
                  @else
                    <option  value="{{$sucursales->cuisucursal}}">{{ucfirst(strtolower($sucursales->cuisucursal))}}</option>
                  @endif
                @endif
              @endforeach
            </select>
          </div>
          <!--FIN SELECT DE SUCURSAL-->
        </div>
        <div class="container" style="margin-top: 20px">
          <button type="buscar" class="btn buscar float-sm-right">
            <h3 style="color:#FFFFFF; margin-top: 5px; width: 104px">Buscar</h3>
          </button>
        </div>
      </div>
    </div>
  </form>
  <!-- FIN BARRA DE BUSQUEDA -->
  {{          session(['url_retiro' => url()->full()])     }}
  <!-- IMPORTAR A EXCEL-->
  <div class="container" style="margin-top: 100px;margin-bottom:2px  " >
    <a style="color: #00A06F"  target="_blank" href="{{route('ir_vista_excel_historial',Crypt::encryptString(url()->full()))}})}}"><img  src="{{ asset('img/excel-icon.png') }}" width="32px" height="auto" alt="">Exportar excel</a>  
  </div>    
</div>

<!-- TABLA DE RESULTADOS DE BUSQUEDA -->
<div class="container" style="margin-top: 20px">
  <div class="conteiner row rein table-responsive-md" style="border: 5px solid #e8f5fe">
    <table class="table table-sm table-bordered table-responsive-lg table-striped table-hover">
      <!-- ENCABEZADO -->
      <thead>
        <tr>
          <th class="container-1"><h3>Fecha de resumen</h3></th>
          <th class="container-2"><h3>Equipos embalados</h3></th>
          <th class="container-2"><h3>Equipos sin embalados</h3></th>
          <th class="container-2"><h3>Cantidad de bultos</h3></th>
          <th class="container-2"><h3>Cliente</h3></th>
          <th class="container-2"><h3>Comuna</h3></th>
          <th class="container-2"><h3>Dirección</h3></th>
          <th class="container-2"><h3>CUI</h3></th>
          <th class="container-2"><h3>Comentario </h3></th>
          <th class="container-1"><h3>Acciones</h3></th>
        </tr>
      </thead>
      <!-- FIN ENCABEZADO -->
      <!-- RESULTADOS -->
      @if(!empty($datosretiro))
      @foreach ($datosretiro   as $los_datos)
      <tr>
        <td>
          {{Carbon\Carbon::createFromDate($los_datos->fecha_resumen)->format('d-m-Y')}}
        </td>
        <td>{{$los_datos->suma_embalados}}</td>
        <td>{{$los_datos->suma_sinembalar}}</td>
        <td>{{$los_datos->cantidad_bultos}}</td>
        <td>{{$los_datos->cliente}}</td>
        <td>{{$los_datos->comuna}}</td>
        <td>{{$los_datos->direccion}}</td>
        <td>{{$los_datos->cuisucursal}}</td>
        <td>{{$los_datos->descripcion_motivo}}</td>                      
        <td>
          <div style="text-align: center">
                                {{-- <form action="{{route('go.verdatosresumenretiro_coordinadora')}}" method="GET"> --}}
            <form target="_blank" action="{{route ('go.verdatosresumenretiro_coordinadora')}}" method="GET">
             <!--{{$los_datos->id}}-->
              <button type="submit" style="border:0px;border-color:transparent;background-color:transparent;">
                <input type="text" style="display:none "  id="check" value="{{$los_datos->id}}" name="check">
                <a href="" role="button" title="Ver Resumen"><img  src="{{ asset('Botones/Botones/Historial.png') }}" class="ver_historial"   alt="" style="margin: 2px 5px"/></a>
              </button>
            </form>
            <!--<a  href="{{route('go.donwload4',$los_datos->url_pdf)}}"> <img src="{{ asset('img/Descargar PDF.png') }}" alt=""></a>-->
          </div>
        </td>
      </tr>
      @endforeach
      @endif
      <!-- FIN RESULTADOS -->
    </table>
  </div>
</div>
<!-- FIN TABLA DE RESULTADOS DE BUSQUEDA -->
</div>




  <script>


    
    
      
$(document).ready(function(){


  $("#clientes").change(function(){
    

  
    cliente = $('select[id=clientes]').val();
      var _token = $('input[name="_token"]').val();
 
  $.ajax({
     method:"POST",

        url:"{{ route('comunasResumentesRetiros') }}",

        data: {  _token:_token,'cliente':cliente},

    success: function(data) {
      console.log(data);
      $("#comuna").empty();
      $("#direccion").empty();
      $("#cuisucursal").empty();
      

      $("#comuna").append('<option value="">Seleccionar</option>');
      $("#direccion").append('<option value="">Seleccionar</option>');
      $("#cuisucursal").append('<option value="">Seleccionar</option>');

   

      $(data).each(function(i, v){ // indice, valor
        //if(v.sComuna != null || v.sComuna != "null"  ){ 
            $("#comuna").append('<option value="' + v.comuna + '">' + v.comuna + '</option>');
              })
        // }
        $('#comuna').prop('disabled', false);

   },

 error: function(xhr, status) {
     alert('Disculpe, ha ocurrido un problema, intente mas tarde');
  }

});

});

$("#comuna").change(function(){
  comuna = $('select[id=comuna]').val();
         var _token = $('input[name="_token"]').val();



         $.ajax({
                method:"POST",

                url:"{{ route('direccionesResumentesRetiros') }}",

                data: { 'comuna': comuna,  _token:_token, 'cliente':$("#clientes").val()},

            success: function(data) {
              $("#direccion").empty();
              $("#cuisucursal").empty();
              $("#direccion").append('<option value="">Seleccionar</option>');
              $("#cuisucursal").append('<option value="">Seleccionar</option>');

              $(data).each(function(i, v){ // indice, valor
                //if(v.sdireccion != null || v.sdireccion != "null"  ){ 
                    $("#direccion").append('<option value="' + v.direccion + '">' + v.direccion + '</option>');
                      })
               // }
               $('#direccion').prop('disabled', false);
              },
             

            error: function(xhr, status) {
                alert('Disculpe, ha ocurrido un problema, intente mas tarde');
             }

        });
});

$("#direccion").change(function(){
  direccion = $('select[id=direccion]').val();
         var _token = $('input[name="_token"]').val();


         $.ajax({
                method:"POST",

                url:"{{ route('sucursalessResumentesRetiros') }}",

                data: { 'direccion': direccion,  _token:_token, 'cliente':$("#clientes").val()},

            success: function(data) {
              $("#cuisucursal").empty();
              $("#cuisucursal").append('<option value="">Seleccionar</option>');

              $(data).each(function(i, v){ // indice, valor
                //if(v.ssucursal != null || v.ssucursal != "null"  ){ 
                    $("#cuisucursal").append('<option value="' + v.cuisucursal + '">' + v.cuisucursal + '</option>');
                      })
               // }
               $('#cuisucursal').prop('disabled', false);
              },
             


            error: function(xhr, status) {
                alert('Disculpe, ha ocurrido un problema, intente mas tarde');
             }

        });
});

  });

  </script>


<!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
<!-- <script src="./Untitled Document_files/jquery-3.4.1.min.js.descarga"></script> -->

<!-- Include all compiled plugins (below), or include individual files as needed -->
<!-- <script src="./Untitled Document_files/popper.min.js.descarga"></script>
<script src="./Untitled Document_files/bootstrap-4.4.1.js.descarga"></script> -->
@endsection
