@extends('menu/menu')
{{-- <script src="https://ajax.aspnetcdn.com/ajax/jQuery/jquery-3.4.1.min.js"></script> --}}
<script src="{{ asset('js/jquery-3.4.1.min.js') }}"></script>
@section('content')
@if ( session('mensaje_error') )
<div class="alert alert-danger">{{ session('mensaje_error') }}</div>
@endif
<div class="container mt-5">
  <div class="title-vista mt-4">Usuarios registrados</div>
</div>
<div class="container mb-5">
  <form action="{{route('filtro_see_trabajador')}}" method="GET">

    <div class="row">
      <div class="col-md-6 form-group w-50 mx-auto">
        <label for="">Nombre trabajador</label>
        <input type="text" name="nombre_trabajador" value="{{@old('nombre_trabajador')}}" class="form-control mayuscula" id="nombre_trabajador" placeholder="...">
      </div>
      <div class="col-sm-12 text-center ">
        <button class="btn btn-prim w-25" type="submit">
          @if($opcion != "1")
          Buscar
          @else
          Todos
          @endif
        </button>
      </div>
    </div>
  </form>
</div>


<div class="container table-responsive mb-5">
  <div class="">
    <table class="table table-striped table-hover">

      <thead class="color-head">
        <tr>
          <th class="th-head border-th separador-v" colspan="3">Datos personales</th>
          <th class="th-head border-th separador-v" colspan="2">Billetera virtual</th>
          <th class="th-head border-th separador-v" colspan="1">Administrar cuenta bancaria</th>
          <th class="th-head border-th" colspan="1">
            <span class="material-icons">settings</span>
          </th>
        </tr>

        <tr>
          <th class="th-subhead border-th">Nombre</th>
          <th class="th-subhead border-th">Teléfonos</th>
          <th class="th-subhead border-th separador-v">Correos</th>
          <th class="th-subhead border-th">Cuenta</th>
          <th class="th-subhead border-th separador-v">F. Actualizado</th>
          <th class="th-subhead border-th separador-v">Total Billetera</th>
          <th class="th-subhead border-th"></th>
        </tr>

      </thead>

      <tbody>
        @foreach ($trabajadores as $los_datos)
        <tr>
          <td class="td-val">{{$los_datos->nombre_uno}} {{$los_datos->apellido_uno}} {{$los_datos->apellido_dos}}</td>
          <td class="td-val">{{$los_datos->telefono1}} - {{$los_datos->telefono2}}</td>
          <td class="td-val">{{$los_datos->correo1}} - {{$los_datos->correo2}}</td>
          <td class="td-val">${{number_format($los_datos->total_acumulado,0,',','.')}} <br> ${{number_format($los_datos->total_gastos,0,',','.')}}</td>
          <td class="td-val">{{ Carbon\Carbon::createFromDate($los_datos->fecha_actualizado_acumulado ?? '')->format('d-m-Y')}} <br> {{ Carbon\Carbon::createFromDate($los_datos->fecha_actualizado_gasto ?? '')->format('d-m-Y')}}</td>

          <td class="td-val">
            <span class="v-left">${{number_format($los_datos->total_acumulado -  $los_datos->total_gastos,0,',','.')}}</span>
            <span class="v-right">
              <a class="billetera_modal btn-icon btn-icon-dd" data-id_trabajador="{{$los_datos->id_trabajador}}">
                <span class="material-icons-round">edit</span>
              </a>
            </span>
          </td>

          <td class="td-val">
            <form>
              <div class="dropdown dropleft" style="text-align: center;">
                <button type="button" data-toggle="dropdown" class="btn-dropdown">
                  <span class="material-icons">more_vert</span>
                </button>
                <div class="dropdown-menu mostrar shadow">
                  <div class="d-flex justify-content-around">
                    <a title="Editar" class="btn-icon btn-icon-dd editar_cliente" href="{{route('update.trabajador',$los_datos->id_trabajador)}}">
                      <span class="material-icons">edit</span>
                    </a>
                    <a title="Agregar" class="show-modal-versucursales btn-icon btn-icon-dd" href="{{route('go.add_suc_trabajador',$los_datos->id_trabajador)}}">
                      <span class="material-icons-round">add_circle</span>
                    </a>
                    <a title="Eliminar" class="btn-icon btn-icon-dd" href="{{route('eliminar.trabajador',$los_datos->id_trabajador)}}" onclick="return confirm('¿Desea eliminar el registro?')">
                      <span class="material-icons">delete</span>
                    </a>
                  </div>
                </div>
              </div>
            </form>
          </td>
        </tr>
        @endforeach
      </tbody>
    </table>
  </div>
</div>



<div class="container">
  <div class="d-flex justify-content-center">
    @if(!empty($trabajadores))
    {{ $trabajadores->appends(request()->query())->links() }}
    @endif
  </div>
</div>





<!-- Modal -->
<div class="modal fade" id="modal_banco" role="dialog">
  <div class="modal-dialog modal-lg">
    <div class="modal-content pb-4">

      <div class="modal-header">
        <div class="seccion-modal">Agregar cuenta</div>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      <hr class="separador ml-4 mr-4">

      <div class="modal-body">
        <div class="container">

          {{-- ******************************ocultar agregar**************************************************************** --}}
          <div class="text-center mb-5">
            <button class="agregar btn btn-prim w-25">Agregar cuenta</button>
          </div>
          <div style="display:none" id="ocultar_agrega">
            <form action="{{route('create.mi_cuenta')}}" method="POST">
              @csrf
              <div class="row">
                <div class="col-sm-4 form-group">
                  <label for="">Bancos</label>
                  <select class="form-control mayuscula" name="bancos" id="sucursal_bancos">
                    <option value="">Seleccionar</option>
                    @if ($bancos == "" )

                    @else
                    @foreach($bancos as $banco)
                    <option value="{{$banco->id}}" {{(old('region')==$banco->id)? 'selected':''}}>{{$banco->nombre_banco}}</option>
                    @endforeach
                    @endif
                  </select>
                  @error('bancos')
                  <div class="alert alert-danger">{{ $message }}</div>
                  @enderror
                </div>

                <input style="display:none" type="text" name="id_trabajador" id="id_trabajador" value="">

                <div class="col-sm-4 form-group">
                  <label for="tipo_cuenta" class="">Tipo cuenta</label>
                  <select class="form-control mayuscula" name="tipo_cuenta" id="tipo_cuentas">
                    @foreach($tipos_cuentas_bancos as $tipo_cuenta)
                    <option value="{{$tipo_cuenta->id}}" {{(old('region')==$tipo_cuenta->id)? 'selected':''}}>{{$tipo_cuenta->tipo_cuenta}}</option>
                    @endforeach
                  </select>
                  @error('tipo_cuenta')
                  <div class="alert alert-danger">{{ $message }}</div>
                  @enderror
                </div>
                <div class="col-sm-4 form-group">
                  <label for="numero_cuenta" class="">Número cuenta</label>
                  <input type="text" class="form-control mayuscula" value="{{@old('numero_cuenta')}}" name="numero_cuenta" id="numero_cuenta" placeholder="Número Cuenta">
                  @error('numero_cuenta')
                  <div class="alert alert-danger">{{ $message }}</div>
                  @enderror
                </div>
              </div>

              <div class="row">
                <div class="col-sm-4 form-group">
                  <label for="nombre_cliente" class="">Nombre (dueño cuenta)</label>
                  <input type="text" class="form-control mayuscula" value="{{@old('nombre_cliente')}}" name="nombre_cliente" id="nombre_cliente" placeholder="Nombre">
                  @error('nombre_cliente')
                  <div class="alert alert-danger">{{ $message }}</div>
                  @enderror
                </div>
                <div class="col-sm-4 form-group">
                  <label for="apellido_cliente" class="">Apellido (dueño cuenta)</label>
                  <input type="text" class="form-control mayuscula" value="{{@old('apellido_cliente')}}" name="apellido_cliente" id="apellido_cliente" placeholder="Apellido">
                  @error('apellido_cliente')
                  <div class="alert alert-danger">{{ $message }}</div>
                  @enderror
                </div>
                <div class="col-sm-4 form-group">
                  <label for="correo_bancario" class="">Correo bancario</label>
                  <input type="email" class="form-control mayuscula" value="{{@old('correo_bancario')}}" name="correo_bancario" id="correo_bancario" placeholder="Correo">
                  @error('correo_bancario')
                  <div class="alert alert-danger">{{ $message }}</div>
                  @enderror
                </div>
              </div>

              <div class="text-center mt-3">
                <button type="submit" class="btn btn-prim w-25 agregar_cuenta ">Guardar</button>
              </div>
            </form>
          </div>

          <table class="table table-hover" id="tabla_sucursal">
            <thead>
              <th>Cuenta</th>
              <th>Número</th>
            </thead>
            <tbody>

            </tbody>

          </table>

        </div>
      </div>
    </div>
  </div>
</div>
</div>







@endsection





<script>
  function eliminar_cuenta(id) {

    // alert(id);

    var result = confirm("¿Desea eliminar?");
    if (result) {
      //Logic to delete the item
      location.href = 'eliminar_cuenta_/' + id;


    }

  }

  $(document).ready(function() {



    $(".agregar").click(function() {

      $('#ocultar_agrega').css('display', '')

    });

    $(".billetera_modal").click(function() {

      $('#ocultar_agrega').css('display', 'none')

      var id_trabajado = $(this).attr("data-id_trabajador");
      // alert(id_trabajado);
      modal_villetera(id_trabajado);
    }); //fin de la funcion


    $('#sucursal_bancos').change(function() {

      id_selec = "#tipo_cuenta";
      // alert($("#sucursal_bancos option:selected").val()); 
      buscar_sucursales_banco($("#sucursal_bancos option:selected").val(), id_selec);
      //  buscar_comuna($("#region_empresa option:selected").val(),"#comuna_empresa","../");  
    })

  });

  function confirmation()

  {

    if (confirm("¿Desea continuar?"))

    {

      return true;

    } else

    {

      return false;

    }

  }
</script>