<?php

namespace App\Http\Controllers\menus;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App;
use Illuminate\Support\Facades\Storage;
use App\direccion;
use App\persona;
use App\User;
use Auth;
use Crypt;
use Session;
use DateTime;
use DateInterval;
use DatePeriod;
use DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Carbon\Carbon;

class menu_principal extends Controller
{
    public function __construct()

    {

        $this->middleware('auth');

        $this->middleware('traba', ['only' => [
            'go_add_cuenta', 'go_see_solicitudes', 'go_see_trabajador', 'go_add_trabajador',
            'go_add_succur', 'go_see_solicitudes_persona', 'go_add_depos', 'filtro_persona_deposito', 'go_gastos_reembolsos', 'sol_pendientes',
        ]]);
    }
    public function formsolicitudes (){

        $proveedor = "";
        $externo = "";

        $databases = App\bd_proveedores::selectDB();
        $regions = App\region::orderby('des_region', 'ASC')->get();

// return strtoupper(Auth::user()->tipo_usuario) ;
         if(strtoupper(Auth::user()->tipo_usuario) == "EXTERNO" || strtoupper(Auth::user()->tipo_usuario) == "KYOCERA"){
            $databases = strtoupper(Auth::user()->nombre_proveedor) ;
            $externo = "si";

            return view('formulario.formsolicitudes',compact('databases','regions','externo'));


         }else if(strtoupper(Auth::user()->tipo_usuario) == "COORDINADOR" || strtoupper(Auth::user()->tipo_usuario) == "ADMINISTRADOR"){

            $externo ="no";
            return view('formulario.formsolicitudes',compact('databases','regions','externo'));

         } else{
            
         } 

        // $clientes = App\clientes::where('razon_social','!=','global')->where('razon_social','!=','SERVICIOS')->get();
 

    }
    /*
    public function formsolicitudes_old (){

        // $clientes = App\clientes::where('razon_social','!=','global')->where('razon_social','!=','SERVICIOS')->get();
  $databases = App\bd_proveedores::selectDB();
        $regions = App\region::orderby('des_region', 'ASC')->get();

        return view('formulario.formsolicitudes',compact('databases','regions'));

    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function createpass($pas)
    {   

        return  Hash::make($pas);
        //
    }
    public function nuevoproveedor()
    {
        //
        return view('proveedor.crearproveedor');

       
    }
    public function index()
    {
        //
    }

    private function nombre_database()
    {
        $tables = DB::select('SHOW DATABASES WHERE `Database` NOT LIKE ' . '"' . '%max%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%aya%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%schema%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%php%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%prueba%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%admin%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%fusion%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%sql%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%probando%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%soporte%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%sys%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%13octubre%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%nueva%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%rendicion%' . '"');
        return $tables;
    }

    public function pruebadehoras()
    {
        //
        $mytime = Carbon::now();
        return $mytime;
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
    public function go_add_depos()
    {

        return view('deposito.depositos');
    }
    public function buscar_trabajador(request $request)
    {

        //return $request;

        // return $request;
        $rut_persona = $request->rut_trabajador_;
        $trabajadores = DB::table('personas')
            ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
            ->where('trabajadors.estado', '=', '1')
            ->where('personas.rut', '=', $request->rut_trabajador_)
            ->get();

        // return $trabajadores;

        if (count($trabajadores) != 0) {

            // return "si";

            $mis_cuentas = DB::table('mis_cuentas')
                ->join('trabajadors', 'trabajadors.id', '=', 'mis_cuentas.id_trabajador')
                ->join('tipos_cuentas_bancos', 'tipos_cuentas_bancos.id', '=', 'mis_cuentas.id_tipo_cuenta')
                ->join('cuentas_bancos', 'cuentas_bancos.id', '=', 'mis_cuentas.id_banco')
                ->select('tipos_cuentas_bancos.id as id_tipo_cuenta', 'tipos_cuentas_bancos.tipo_cuenta', 'cuentas_bancos.id as id_banco', 'cuentas_bancos.nombre_banco')
                ->where('trabajadors.estado', '=', '1')
                ->where('trabajadors.id', '=', $trabajadores[0]->id)
                ->where('mis_cuentas.id_banco', '!=', '1')
                ->get();
            return view('deposito.depositos', compact('trabajadores', 'rut_persona', 'mis_cuentas'));
            // return $mis_cuentas;
        } else {

            return redirect()->route('go_add.deposito')
                ->with('mensaje_error', 'No Encontrado');
            // return "a";
        }
        // return $mis_cuentas;

    }
    // mis_depositos



    public function go_add_trabajador()
    {


        $regiones = App\region::all();

        $comunas = App\comuna::all();


        // $regiones_clientes = DB::table('sucursals')
        // ->join('direccions','direccions.id','=','sucursals.id_direccion')
        // ->join('regions','regions.id','=','direccions.id_region')
        // ->where('sucursals.estado','=',1)
        // ->select('regions.id','regions.des_region')
        // ->distinct()
        // ->get();
        $regiones_clientes =  $regiones;


        return view('auth.nuevo_usuario', compact('regiones', 'comunas', 'regiones_clientes'));
    }


    public function go_see_trabajador()
    {

        $trabajadores = DB::table('personas')
            ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
            ->join('billetera_virtuals', 'billetera_virtuals.id', '=', 'trabajadors.id_billetera')
            ->select(
                'personas.nombre_uno',
                'personas.apellido_uno',
                'personas.apellido_dos',
                'personas.telefono1',
                'personas.telefono2',
                'personas.correo1',
                'personas.correo2',
                'billetera_virtuals.total_acumulado',
                'billetera_virtuals.fecha_actualizado_acumulado',
                'billetera_virtuals.total_gastos',
                'billetera_virtuals.fecha_actualizado_gasto',
                'trabajadors.id as id_trabajador'
            )
            ->where('trabajadors.estado', '=', '1')
            ->orderBy('trabajadors.id', 'desc')
            ->paginate(20);




        $trabajadores_dos = DB::table('personas')
            ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
            ->where('trabajadors.estado', '=', '1')

            ->get();
        $bancos = App\cuentas_banco::where('nombre_banco', '!=', 'todoslosbancos')->where('estado', '=', 0)->get();
        $tipos_cuentas_bancos = App\tipos_cuentas_banco::all();
        $opcion = 2;

        return view('auth.ver_usuarios', compact('trabajadores', 'bancos', 'tipos_cuentas_bancos', 'opcion', 'trabajadores_dos'));
    }


    public function buscar_comuna(Request $request)

    {

        $id_region = $request->id_region;

        // $comunas =   App\comuna::where('id_region', $id_region)->get();
        $comunas =   App\comuna::where('id_region', $id_region)->orderby('des_comuna','ASC')->get();

        // $comunas = App\comuna::all();

        return $comunas;
    }
    // ***************************CLIENTES************************************************

    public function go_add_client()
    {

        $regiones = App\region::all();
        $comunas = App\comuna::all();

        return view('clientes.create_client', compact('regiones', 'comunas'));
    }
    public function go_add_succur()
    {

        $regiones = App\region::all();
        $comunas = App\comuna::all();
        $clientes = DB::table('clientes')
            ->where('clientes.estado', "=", 1)
            ->get();

        return view('clientes.create_sucursal', compact('regiones', 'comunas', 'clientes'));
    }

    public function go_see_client()
    {

        // $clientes = App\clientes::all();

        $clientes = DB::table('clientes')
            ->join('direccions', 'direccions.id', '=', 'clientes.id_direccion')
            ->join('regions', 'regions.id', '=', 'direccions.id_region')
            ->join('comunas', 'comunas.id', '=', 'direccions.id_comuna')
            ->select(
                'clientes.id as id_cliente',
                'clientes.razon_social',
                'clientes.rut',
                'clientes.telefono',
                'clientes.correo',
                'direccions.descripcion_direccion',
                'regions.des_region',
                'comunas.des_comuna',
                'comunas.id as id_comuna',
                'regions.id as id_region'
            )
            ->where('clientes.estado', "=", 1)
            ->get();
        $proveedores =  DB::table('users')
            ->select('nombre_proveedor')
            ->orderBy('nombre_proveedor', 'asc')

            ->where('nombre_proveedor', '!=', '')
            ->distinct()
            ->get();
        $regiones = App\region::all();
        $comunas = App\comuna::all();
        $clientes_2 = DB::table('clientes')
            ->where('clientes.estado', "=", 1)
            ->get();

        $opcion = 2;

        return view('clientes.see_client', compact('clientes', 'clientes_2', 'regiones', 'comunas', 'opcion', 'proveedores'));
    }

    public function go_add_gasto()
    {

        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();
        // $clientes = App\clientes::all()->where('estado','=',1);
        // $sucursal = App\sucursal::all()->where('estado','=',1);

        $sucursal = DB::table('trabajador_sucursals')
            ->join('sucursals', 'sucursals.id', '=', 'trabajador_sucursals.id_sucursals')
            ->join('clientes', 'clientes.id', '=', 'trabajador_sucursals.id_trabajador')
            ->select('sucursals.id', 'sucursals.nombre')
            ->where('trabajador_sucursals.id_trabajador', '=', $datos_trabajador[0]->id)
            ->distinct()
            ->get();

        $clientes = DB::table('trabajador_sucursals')
            ->join('sucursals', 'sucursals.id', '=', 'trabajador_sucursals.id_sucursals')
            ->join('clientes', 'clientes.id', '=', 'sucursals.id_cliente')
            ->select('clientes.id', 'clientes.razon_social')
            ->where('trabajador_sucursals.id_trabajador', '=', $datos_trabajador[0]->id)
            ->distinct()
            ->get();

        return view('gastos.create_gastos', compact('clientes', 'sucursal'));
    }


    public function go_see_gasto()
    {
        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();
        $id_persona = $datos_trabajador[0]->id_persona;
        $persona =  App\persona::findOrfail($id_persona);
        $id_billetera = $datos_trabajador[0]->id_billetera;
        $billetera =  App\billetera_virtual::findOrfail($id_billetera);



        $buscar_total = DB::table('trabajadors')
            ->join('deposito_mensuals', 'deposito_mensuals.id_billetera', '=', 'trabajadors.id_billetera')
            ->where('trabajadors.id_persona', '=', $id_persona)
            ->select('deposito_mensuals.total')
            ->get();
        $suma_total = 0;

        foreach ($buscar_total as $v1) {
            foreach ($v1 as $total) {
                $suma_total += $total;
            }
        }


        $gastos_trabajador = DB::table('gastos_historials')
            ->join('sucursals', 'sucursals.id', '=', 'gastos_historials.id_sucursal')
            ->join('clientes', 'clientes.id', '=', 'sucursals.id_cliente')
            ->select(
                'gastos_historials.codigo_sc',
                'gastos_historials.id as id_gasto',
                'gastos_historials.titulo',
                'gastos_historials.estado',
                'gastos_historials.total',
                'sucursals.nombre as nombre_sucursal',
                'gastos_historials.fecha_registrado',
                'clientes.razon_social',
                'gastos_historials.descripcion_pago as descripcion_del_rembolso'
            )
            ->where('gastos_historials.id_trabajador', '=', $datos_trabajador[0]->id)
            ->where('gastos_historials.estado_eliminado', '=', '1')
            ->orderBy('gastos_historials.id', 'desc')
            ->paginate(5);

        $opcion = "1"; //esta opcion es para saber que mostrar en el boton buscar
        return view('gastos.see_gastos', compact('persona', 'billetera', 'gastos_trabajador', 'suma_total', 'opcion'));
    }



    public function go_see_solicitudes()
    {




        //estado solicitud 1 -> solicitado, 2 -> respondido

        $gastos_trabajador = DB::table('solicitudes_reembolsos')
            ->join('trabajadors', 'trabajadors.id', '=', 'solicitudes_reembolsos.id_trabajador')
            ->join('billetera_virtuals', 'billetera_virtuals.id', '=', 'trabajadors.id_billetera')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->join('gastos_historials', 'gastos_historials.id', '=', 'solicitudes_reembolsos.gasto_historial')
            ->join('sucursals', 'sucursals.id', '=', 'gastos_historials.id_sucursal')
            ->join('clientes', 'clientes.id', '=', 'sucursals.id_cliente')
            ->select(
                'personas.nombre_uno',
                'personas.apellido_uno',
                'personas.apellido_dos',
                'gastos_historials.total',
                'gastos_historials.titulo',
                'clientes.razon_social',
                'sucursals.nombre as nombre_sucursal',
                'solicitudes_reembolsos.id as id_reembolso',
                'trabajadors.id as id_trabajador',
                'solicitudes_reembolsos.fecha_solicitada',
                'gastos_historials.descripcion_pago as descripcion_del_rembolso',
                'billetera_virtuals.total_acumulado',
                'billetera_virtuals.total_gastos',
                'gastos_historials.viaje_diario',
                'gastos_historials.colacion',
                'gastos_historials.otro_gasto',
                'gastos_historials.combustible',
                'gastos_historials.viaje_atenciones'
            )
            ->where('solicitudes_reembolsos.estado_solicitud', '=', 1)
            ->orderBy('solicitudes_reembolsos.id', 'desc')
            ->get();
        // ->join('sucursals','sucursals.id','=','gastos_historials.id_sucursal')
        // ->join('clientes','clientes.id','=','sucursals.id_cliente')
        // ->select('gastos_historials.id as id_gasto','gastos_historials.titulo','gastos_historials.estado','gastos_historials.total','sucursals.nombre as nombre_sucursal'
        //  ,'gastos_historials.fecha_registrado','clientes.razon_social')
        // ->where('gastos_historials.estado_eliminado','=','1')

        $opcion = 2;
        return view('solicitudes_gasto.solicitud_gasto', compact('gastos_trabajador', 'opcion'));
    }
    public function go_see_solicitudes_persona()
    {

        $trabajadores = DB::table('trabajadors')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select('personas.nombre_uno', 'personas.nombre_dos', 'personas.apellido_uno', 'personas.apellido_dos', 'trabajadors.id as id_trabajador')
            ->where('trabajadors.estado', '=', 1)
            ->get();

        return view('solicitudes_gasto.solicitudes_trabajadores', compact('trabajadores'));
    }



    public function search_informacion(request $request)
    {
        // return $request->id_gasto;
        $informacion_rembolsos = DB::table('solicitudes_reembolsos')
            ->leftJoin('estado_final_solicitudes', 'estado_final_solicitudes.id_solicitud_reembolsos', '=', 'solicitudes_reembolsos.id')
            // ->leftJoin ('estado_final_solicitudes','estado_final_solicitudes.id_solicitud_reembolsos','=','solicitudes_reembolsos.id')
            // ->join('billetera_virtuals','billetera_virtuals.id','=','trabajadors.id_billetera')
            ->select(
                'solicitudes_reembolsos.fecha_solicitada',
                'estado_final_solicitudes.descripcion as respuesta_solicitud',
                'estado_final_solicitudes.fecha_respondido'
            )
            ->where('solicitudes_reembolsos.gasto_historial', '=', $request->id_gasto)
            ->get();

        // $fecha_actual =$fecha_actual_->format('Y-m-d');
        if ($informacion_rembolsos[0]->fecha_solicitada == null) {
            $f_soli = "";
        } else {
            $f_soli = $informacion_rembolsos[0]->fecha_solicitada;
            $f_soli = strtotime($f_soli);
            $f_soli = date('d-m-Y', $f_soli);
        }

        if ($informacion_rembolsos[0]->fecha_respondido == null) {
            $f_respu = "";
        } else {
            $f_respu = $informacion_rembolsos[0]->fecha_respondido;
            $f_respu = strtotime($f_respu);
            $f_respu = date('d-m-Y', $f_respu);
        }

        if ($informacion_rembolsos[0]->respuesta_solicitud == null) {
            $des_crip = "";
        } else {
            $des_crip = $informacion_rembolsos[0]->respuesta_solicitud;
        }

        $objeto = [
            'fecha_solicitada' => $f_soli,
            'fecha_respuesta' => $f_respu,
            'descripcion' => $des_crip
        ];
        return $objeto;
    }

    public function go_add_cuenta()
    {


        $bancos = App\cuentas_banco::where('nombre_banco', '!=', 'todoslosbancos')->where('estado', '=', 0)->get();

        return view('cuentas_bancarias.new_cuenta_bancaria', compact('bancos'));
    }






    public function mi_firma()
    {
        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();

        $datos_firma = DB::table('firma_clientes')
            ->where('firma_clientes.id_tecnico', '=', $datos_trabajador[0]->id )
            ->get();



        return view('firma.cambiarfirma', compact('datos_trabajador', 'datos_firma'));
    }
    // *****************************FILTROSSSSSS********************************************




    public function filtro_persona_mis_deposito()
    {

        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();
        $id_persona = $datos_trabajador[0]->id_persona;
        $persona =  App\persona::findOrfail($id_persona);
        $id_billetera = $datos_trabajador[0]->id_billetera;
        $billetera =  App\billetera_virtual::findOrfail($id_billetera);


        $depositos = DB::table('deposito_mensuals')
            ->join('billetera_virtuals', 'billetera_virtuals.id', '=', 'deposito_mensuals.id_billetera')
            ->join('cuentas_bancos', 'cuentas_bancos.id', '=', 'deposito_mensuals.id_banco')
            ->join('tipos_cuentas_bancos', 'tipos_cuentas_bancos.id', '=', 'deposito_mensuals.id_tipo_cuenta')
            ->where('billetera_virtuals.id', '=', $billetera->id)
            ->orderBy('deposito_mensuals.id', 'desc')
            ->get();




        $buscar_total = DB::table('deposito_mensuals')
            ->join('billetera_virtuals', 'billetera_virtuals.id', '=', 'deposito_mensuals.id_billetera')
            ->where('billetera_virtuals.id', '=', $billetera->id)
            ->select('deposito_mensuals.total')
            ->get();
        $suma_total = 0;

        foreach ($buscar_total as $v1) {
            foreach ($v1 as $total) {
                $suma_total += $total;
            }
        }


        return view('deposito.ver_mis_depositos', compact('depositos', 'suma_total'));


        // return view('deposito.ver_mis_depositos');


    }

    public function filtro_misdepositos_fecha(Request $request)
    {



        $rules = [

            'fecha_inicio' => 'required|max:15',
            'fecha_fin' => 'required|max:15',
        ];
        $this->validate($request, $rules);

        $f_inicio = Carbon::parse($request->fecha_inicio);
        $f_fin = Carbon::parse($request->fecha_fin . " 23:59:59");
        $f_inicio = Carbon::parse($request->fecha_inicio);
        $fecha_fin =  $f_fin->format('d-m-Y');


        if ($f_inicio->gt($f_fin)) {
            return back()->with('mensaje_error', 'Ingrese Las Fechas Correctamente');
        }

        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();
        $id_persona = $datos_trabajador[0]->id_persona;
        $persona =  App\persona::findOrfail($id_persona);
        $id_billetera = $datos_trabajador[0]->id_billetera;
        $billetera =  App\billetera_virtual::findOrfail($id_billetera);


        $depositos = DB::table('deposito_mensuals')
            ->join('billetera_virtuals', 'billetera_virtuals.id', '=', 'deposito_mensuals.id_billetera')
            ->join('cuentas_bancos', 'cuentas_bancos.id', '=', 'deposito_mensuals.id_banco')
            ->join('tipos_cuentas_bancos', 'tipos_cuentas_bancos.id', '=', 'deposito_mensuals.id_tipo_cuenta')
            ->where('billetera_virtuals.id', '=', $billetera->id)
            ->whereBetween('deposito_mensuals.fecha_realizado', [$f_inicio, $f_fin])
            ->get();


        $buscar_total = DB::table('deposito_mensuals')
            ->join('billetera_virtuals', 'billetera_virtuals.id', '=', 'deposito_mensuals.id_billetera')
            ->where('billetera_virtuals.id', '=', $billetera->id)
            ->select('deposito_mensuals.total')
            ->whereBetween('deposito_mensuals.fecha_realizado', [$f_inicio, $f_fin])
            ->get();




        $suma_total = 0;

        foreach ($buscar_total as $v1) {
            foreach ($v1 as $total) {
                $suma_total += $total;
            }
        }


        return view('deposito.ver_mis_depositos', compact('depositos', 'suma_total'));
    }


    public function filtro_persona_deposito()
    {

        return view('deposito.ver_depositos');
    }
    public function buscar_deposito(Request $request)
    {

        $rules = [
            'rut_trabajador' => 'required',
            'rut_trabajador_' => 'required|max:15',
            // 'fecha_inicio' => 'required|max:15',
            // 'fecha_fin' => 'required|max:15',
        ];
        $this->validate($request, $rules);

        if (!empty($request->filtro)) { //si seleciona el boton de filtro

            $rules = [
                'rut_trabajador_' => 'required|max:15',
                'fecha_inicio' => 'required|max:15',
                'fecha_fin' => 'required|max:15',
            ];
            $this->validate($request, $rules);

            $f_inicio = Carbon::parse($request->fecha_inicio);
            $f_fin = Carbon::parse($request->fecha_fin);

            $f_inicio_2 = Carbon::parse($request->fecha_inicio);
            $f_fin_2 = Carbon::parse($request->fecha_fin . " 23:59:59");

            $fecha_inicio =  $f_inicio->format('d-m-Y');
            $fecha_fin =  $f_fin->format('d-m-Y');

            $datos_personas = DB::table('personas')
                ->select('personas.nombre_uno', 'personas.apellido_uno', 'personas.apellido_dos', 'personas.rut', 'personas.telefono1', 'personas.correo1', 'personas.id as id_persona')
                ->where('personas.rut', '=', $request->rut_trabajador_)
                ->get();


            if (count($datos_personas) <= 0) {
                $datos_personas = "";
                $depositos = "";
                $fecha_inicio = "";
                $fecha_fin = "";
                $suma_total = "0";
                // return back()->with('mensaje_error', 'Trabajador No Encontrado')->compact('datos_personas','depositos','buscar_total')); 
                // return view('deposito.ver_depositos',compact('datos_personas','depositos','fecha_inicio','fecha_fin','suma_total'));

                return redirect()->route('filtro_deposito_rut')
                    ->with('mensaje_error', 'No Encontrado');
            } else {



                $depositos = DB::table('trabajadors')
                    ->join('deposito_mensuals', 'deposito_mensuals.id_billetera', '=', 'trabajadors.id_billetera')
                    ->join('cuentas_bancos', 'cuentas_bancos.id', '=', 'deposito_mensuals.id_banco')
                    ->join('tipos_cuentas_bancos', 'tipos_cuentas_bancos.id', '=', 'deposito_mensuals.id_tipo_cuenta')

                    ->where('trabajadors.id_persona', '=', $datos_personas[0]->id_persona)
                    ->whereBetween('deposito_mensuals.fecha_realizado', [$f_inicio_2, $f_fin_2])
                    ->orderBy('deposito_mensuals.id', 'desc')
                    ->get();

                $buscar_total = DB::table('trabajadors')
                    ->join('deposito_mensuals', 'deposito_mensuals.id_billetera', '=', 'trabajadors.id_billetera')
                    ->where('trabajadors.id_persona', '=', $datos_personas[0]->id_persona)
                    ->select('deposito_mensuals.total')
                    ->whereBetween('deposito_mensuals.fecha_realizado', [$f_inicio_2, $f_fin_2])

                    ->get();
                $suma_total = 0;

                foreach ($buscar_total as $v1) {
                    foreach ($v1 as $total) {
                        $suma_total += $total;
                    }
                }
                return view('deposito.ver_depositos', compact('datos_personas', 'depositos', 'fecha_inicio', 'fecha_fin', 'suma_total'));
            }
        }





        $datos_personas = DB::table('personas')
            ->select('personas.nombre_uno', 'personas.apellido_uno', 'personas.apellido_dos', 'personas.rut', 'personas.telefono1', 'personas.correo1', 'personas.id as id_persona')
            ->where('personas.rut', '=', $request->rut_trabajador_)
            ->get();



        if (count($datos_personas) <= 0) {
            $datos_personas = "";
            $depositos = "";
            $suma_total = "0";
            // return back()->with('mensaje_error', 'Trabajador No Encontrado')->compact('datos_personas','depositos','suma_total')); 
            // return view('deposito.ver_depositos',compact('datos_personas','depositos','suma_total'));

            return redirect()->route('filtro_deposito_rut')
                ->with('mensaje_error', 'No Encontrado');
        } else {


            $depositos = DB::table('trabajadors')
                ->join('deposito_mensuals', 'deposito_mensuals.id_billetera', '=', 'trabajadors.id_billetera')
                ->join('cuentas_bancos', 'cuentas_bancos.id', '=', 'deposito_mensuals.id_banco')
                ->join('tipos_cuentas_bancos', 'tipos_cuentas_bancos.id', '=', 'deposito_mensuals.id_tipo_cuenta')
                ->where('trabajadors.id_persona', '=', $datos_personas[0]->id_persona)
                ->orderBy('deposito_mensuals.id', 'desc')
                ->get();


            $buscar_total = DB::table('trabajadors')
                ->join('deposito_mensuals', 'deposito_mensuals.id_billetera', '=', 'trabajadors.id_billetera')
                ->where('trabajadors.id_persona', '=', $datos_personas[0]->id_persona)
                ->select('deposito_mensuals.total')
                ->get();
            $suma_total = 0;

            foreach ($buscar_total as $v1) {
                foreach ($v1 as $total) {
                    $suma_total += $total;
                }
            }
        }

        //    $depositos = DB::table('deposito_mensuals')


        return view('deposito.ver_depositos', compact('datos_personas', 'depositos', 'suma_total'));
    }



    public function nueva_comunas(Request $request)

    {



        $comuna = new App\comuna;

        $comuna->des_comuna = $request->nueva_comuna;

        $comuna->id_region = $request->id_region;
        $comuna->timestamps = false;

        $comuna->save();



        $response = array();

        $response['nombre'] = $comuna->des_comuna;

        $response['id_comuna'] =  $comuna->id;

        $response['id_region'] = $request->id_region;;



        return $request;
    }




    public function filtro_persona_fechas(request $request)
    {


        //con la nueva actualizacion rut_trabajador_  trae el verdadero rut, el rut_trabajador, solo trae el nombre del cliente


        if (!empty($request->filtro)) { //si seleciona el boton de filtro

            $rules = [
                'rut_trabajador' => 'required',
                'rut_trabajador_' => 'required|max:15',

                'fecha_inicio' => 'required|max:15',
                'fecha_fin' => 'required|max:15',
            ];
            $this->validate($request, $rules);

            $f_inicio = Carbon::parse($request->fecha_inicio);
            $f_fin = Carbon::parse($request->fecha_fin . " 23:59:00");

            // $resultado = var_dump($f_inicio->gt($f_fin));
            if ($f_inicio->gt($f_fin)) {
                return back()->with('mensaje_error', 'Ingrese Las Fechas Correctamente');
            }


            $todas_solicitudes = DB::table('personas')
                ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
                ->join('solicitudes_reembolsos', 'solicitudes_reembolsos.id_trabajador', '=', 'trabajadors.id')

                ->join('gastos_historials', 'gastos_historials.id', '=', 'solicitudes_reembolsos.gasto_historial')

                //  ->join('gastos_historials','gastos_historials.id_sucursal','=','solicitudes_reembolsos.id')


                ->leftJoin('estado_final_solicitudes', 'estado_final_solicitudes.id_solicitud_reembolsos', '=', 'solicitudes_reembolsos.id')
                ->select(
                    'gastos_historials.titulo',
                    'gastos_historials.descripcion_pago',
                    'gastos_historials.estado as estado_solicitud',
                    'gastos_historials.total',
                    'personas.nombre_uno',
                    'personas.apellido_uno',
                    'personas.apellido_dos',
                    'personas.rut',
                    'personas.telefono1',
                    'personas.correo1',
                    'gastos_historials.descripcion_pago as descripcion_del_rembolso',
                    'gastos_historials.fecha_registrado',
                    'trabajadors.id as id_trabajador'
                )
                ->where('personas.rut', '=', $request->rut_trabajador_)
                ->where('gastos_historials.estado_eliminado', '=', 1)
                ->where('gastos_historials.estado', 'like', "%" . $request->estados . "%")
                ->whereBetween('gastos_historials.fecha_registrado', [$f_inicio, $f_fin])
                ->orderBy('gastos_historials.id', 'desc')
                ->paginate(7);


            if (count($todas_solicitudes) > 0) {



                //onbener Gatos aceptados y rechazados
                $suma_gasto_pendiente = 0;
                $gastos_pendientes = DB::table('personas')
                    ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
                    ->join('gastos_historials', 'gastos_historials.id_trabajador', '=', 'trabajadors.id')
                    ->select('gastos_historials.total')
                    ->where('gastos_historials.estado_eliminado', '=', 1)
                    ->where('gastos_historials.estado', '=', 2)
                    ->where('gastos_historials.id_trabajador', '=', $todas_solicitudes[0]->id_trabajador)
                    ->whereBetween('gastos_historials.fecha_registrado', [$f_inicio, $f_fin])
                    ->get();
                $suma_gasto_pendiente = 0;

                foreach ($gastos_pendientes as $v1) {
                    foreach ($v1 as $total) {
                        $suma_gasto_pendiente += $total;
                    }
                }


                //onbener Gatos aceptados y rechazados
                $suma_gasto_aceptado = 0;
                $gastos_aceptados = DB::table('personas')
                    ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
                    ->join('gastos_historials', 'gastos_historials.id_trabajador', '=', 'trabajadors.id')
                    ->select('gastos_historials.total')
                    ->where('gastos_historials.estado_eliminado', '=', 1)
                    ->where('gastos_historials.estado', '=', 3)
                    ->where('gastos_historials.id_trabajador', '=', $todas_solicitudes[0]->id_trabajador)
                    ->whereBetween('gastos_historials.fecha_registrado', [$f_inicio, $f_fin])
                    ->get();
                $suma_gasto_aceptado = 0;

                foreach ($gastos_aceptados as $v1) {
                    foreach ($v1 as $total) {
                        $suma_gasto_aceptado += $total;
                    }
                }
                //obnbener Gatos aceptados y rechazados
                $suma_gasto_rechazado = 0;
                $gastos_rechazado = DB::table('personas')
                    ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
                    ->join('gastos_historials', 'gastos_historials.id_trabajador', '=', 'trabajadors.id')
                    ->select('gastos_historials.total')
                    ->where('gastos_historials.estado_eliminado', '=', 1)
                    ->where('gastos_historials.estado', '=', 4)
                    ->where('gastos_historials.id_trabajador', '=', $todas_solicitudes[0]->id_trabajador)
                    ->whereBetween('gastos_historials.fecha_registrado', [$f_inicio, $f_fin])
                    ->get();
                $suma_gasto_rechazado = 0;

                foreach ($gastos_rechazado as $v1) {
                    foreach ($v1 as $total) {
                        $suma_gasto_rechazado += $total;
                    }
                }

                $fecha_inicio =  $f_inicio->format('d-m-Y');
                $fecha_fin =  $f_fin->format('d-m-Y');
                return view('solicitudes_gasto.solicitudes_trabajadores', compact('gastos_rechazado', 'suma_gasto_aceptado', 'todas_solicitudes', 'fecha_inicio', 'fecha_fin', 'suma_gasto_pendiente'));
            } else {
                return redirect()->route('go_see_solicitud_persona')
                    ->with('mensaje_error', 'No Encontrado');
            }
        } else {  //cuando no seleciono el bton filtrar

            $rules = [
                'rut_trabajador_' => 'required|max:15',
            ];

            $this->validate($request, $rules);

            $todas_solicitudes = DB::table('personas')
                ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
                ->join('solicitudes_reembolsos', 'solicitudes_reembolsos.id_trabajador', '=', 'trabajadors.id')

                ->join('gastos_historials', 'gastos_historials.id', '=', 'solicitudes_reembolsos.gasto_historial')


                ->leftJoin('estado_final_solicitudes', 'estado_final_solicitudes.id_solicitud_reembolsos', '=', 'solicitudes_reembolsos.id')
                ->select(
                    'gastos_historials.titulo',
                    'gastos_historials.descripcion_pago',
                    'gastos_historials.estado as estado_solicitud',
                    'gastos_historials.total',
                    'personas.nombre_uno',
                    'personas.apellido_uno',
                    'personas.apellido_dos',
                    'personas.rut',
                    'personas.telefono1',
                    'personas.correo1',
                    'gastos_historials.descripcion_pago as descripcion_del_rembolso',
                    'gastos_historials.fecha_registrado',
                    'trabajadors.id as id_trabajador'
                )
                ->where('personas.rut', '=', $request->rut_trabajador_)
                ->where('gastos_historials.estado_eliminado', '=', 1)
                ->where('gastos_historials.estado', 'like', "%" . $request->estados . "%")
                ->orderBy('gastos_historials.id', 'desc')
                ->paginate(7);

            if (count($todas_solicitudes) > 0) {

                // return $todas_solicitudes;

                //onbener Gatos aceptados y rechazados
                $gastos_pendientes = DB::table('personas')
                    ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
                    ->join('gastos_historials', 'gastos_historials.id_trabajador', '=', 'trabajadors.id')
                    ->select('gastos_historials.total')
                    ->where('gastos_historials.estado_eliminado', '=', 1)
                    ->where('gastos_historials.estado', '=', 2)
                    ->where('gastos_historials.id_trabajador', '=', $todas_solicitudes[0]->id_trabajador)
                    ->get();
                $suma_gasto_pendiente = 0;

                foreach ($gastos_pendientes as $v1) {
                    foreach ($v1 as $total) {
                        $suma_gasto_pendiente += $total;
                    }
                }

                //onbener Gatos aceptados y rechazados
                $suma_gasto_aceptado = 0;
                $gastos_aceptados = DB::table('personas')
                    ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
                    ->join('gastos_historials', 'gastos_historials.id_trabajador', '=', 'trabajadors.id')
                    ->select('gastos_historials.total')
                    ->where('gastos_historials.estado_eliminado', '=', 1)
                    ->where('gastos_historials.estado', '=', 3)
                    ->where('gastos_historials.id_trabajador', '=', $todas_solicitudes[0]->id_trabajador)
                    ->get();
                $suma_gasto_aceptado = 0;

                foreach ($gastos_aceptados as $v1) {
                    foreach ($v1 as $total) {
                        $suma_gasto_aceptado += $total;
                    }
                }
                //onbener Gatos aceptados y rechazados
                $suma_gasto_rechazado = 0;
                $gastos_rechazado = DB::table('personas')
                    ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
                    ->join('gastos_historials', 'gastos_historials.id_trabajador', '=', 'trabajadors.id')
                    ->select('gastos_historials.total')
                    ->where('gastos_historials.estado_eliminado', '=', 1)
                    ->where('gastos_historials.estado', '=', 4)
                    ->where('gastos_historials.id_trabajador', '=', $todas_solicitudes[0]->id_trabajador)
                    ->get();
                $suma_gasto_rechazado = 0;

                foreach ($gastos_rechazado as $v1) {
                    foreach ($v1 as $total) {
                        $suma_gasto_rechazado += $total;
                    }
                }


                return view('solicitudes_gasto.solicitudes_trabajadores', compact('todas_solicitudes', 'suma_gasto_pendiente', 'suma_gasto_aceptado', 'suma_gasto_rechazado'));
            } //fin del if, que pregunta si existen datos
            else {

                return redirect()->route('go_see_solicitud_persona')
                    ->with('mensaje_error', 'No Encontrado');

                // Session::flash('flash_message', 'Mensaje de prueba');


                // return view('solicitudes_gasto.solicitudes_trabajadores')->with('mensaje', "No Hay Depositos");


            }
        }




        $datos_persona_trabajo = "gola";
        return view('solicitudes_gasto.solicitudes_trabajadores', compact('datos_persona_trabajo'));
    }


    public function buscar_sucursal_ciente_cliente(request $request)
    {
        // return $request->id_cliente;

        $sucursales = DB::table('sucursals')
            ->where('sucursals.id_cliente', '=', $request->id_cliente)
            ->get();

        $opciones = "";

        if (count($sucursales) >= 1) {


            for ($j = 0; $j < count($sucursales); $j++) {
                for ($i = 0; $i < 1; $i++) {

                    $opciones .= "<option value= '" . $sucursales[$j]->id . "--" . $sucursales[$j]->nombre . "'>" . $sucursales[$j]->nombre . "</option>";
                }
            }

            return $opciones;
        } else {

            return "Sin Sucursales";
        }
    }


    public function go_addtra($id)
    {
        # code...
        $id_trabajado = $id;
        $cliente = App\clientes::all();
        // $mis_sucursales = App\trabajador_sucursal::where('id_trabajador',$id )->get();

        $mis_sucursales = DB::table('trabajador_sucursals')
            ->join('sucursals', 'sucursals.id', '=', 'trabajador_sucursals.id_sucursals')
            ->join('clientes', 'clientes.id', '=', 'sucursals.id_cliente')
            ->where('trabajador_sucursals.id_trabajador', '=', $id)
            ->get();


        return view('auth.agregar_sucursal_trabajador', compact('cliente', 'id_trabajado', 'mis_sucursales'));
    }


    public function aderir_traba_suc(request $request)
    {


        //   return $request;



        if (!empty($request->selecionados)) {
            $total = count($request->selecionados);
            $deletedRows = App\trabajador_sucursal::where('id_trabajador', $request->id_trabajador)->delete();

            for ($i = 0; $i < $total; $i++) {


                $mis_sucursales = DB::table('trabajador_sucursals')
                    ->where('trabajador_sucursals.id_sucursals', '=', $request->selecionados[$i])
                    ->where('trabajador_sucursals.id_trabajador', '=', $request->id_trabajador)
                    ->get();

                if (count($mis_sucursales) > 0) {
                } else {
                    $trabajador_sucursal = new App\trabajador_sucursal;
                    $trabajador_sucursal->id_sucursals = $request->selecionados[$i];
                    $trabajador_sucursal->id_trabajador = $request->id_trabajador;
                    $trabajador_sucursal->timestamps = false;
                    $trabajador_sucursal->save();
                }
            }
            return back()->with('mensaje', 'Ingreso Correctamente');
        }
        return back()->with('mensaje_error', 'No ha Seleccionado Nada');
    }

    public function buscar_sucu_clientes(request $request)
    {
        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();


        $mis_sucursales = DB::table('trabajador_sucursals')
            ->join('sucursals', 'sucursals.id', '=', 'trabajador_sucursals.id_sucursals')
            ->join('clientes', 'clientes.id', '=', 'sucursals.id_cliente')
            ->where('trabajador_sucursals.id_trabajador', '=',    $datos_trabajador[0]->id)
            ->where('sucursals.id_cliente', '=', $request->id_cliente)
            ->select('sucursals.id', 'sucursals.nombre')

            ->get();


        return $mis_sucursales;
    }

    // ***********************

    // reportes de gastos

    public function go_gastos_reembolsos()
    {
        return view('gastos.see_gastos_deposito');
    }

    public function buscar_deposito_reembolso(request $request)
    {


        //con la nueva actualizacion rut_trabajador_  trae el verdadero rut, el rut_trabajador, solo trae el nombre del cliente

        $rules = [
            'rut_trabajador' => 'required',
            'rut_trabajador_' => 'required|max:15',
            // 'fecha_inicio' => 'required|max:15',
            // 'fecha_fin' => 'required|max:15',
        ];
        $this->validate($request, $rules);





        $datos_personas = DB::table('personas')
            ->select('personas.nombre_uno', 'personas.apellido_uno', 'personas.apellido_dos', 'personas.rut', 'personas.telefono1', 'personas.correo1', 'personas.id as id_persona')
            ->where('personas.rut', '=', $request->rut_trabajador_)
            ->get();



        if (count($datos_personas) <= 0) {
            $datos_personas = "";
            $depositos = "";
            $suma_total = "0";
            // return back()->with('mensaje_error', 'Trabajador No Encontrado')->compact('datos_personas','depositos','suma_total')); 
            // return view('deposito.ver_depositos',compact('datos_personas','depositos','suma_total'));

            return redirect()->route('go_gastos_reembolsos')
                ->with('mensaje_error', 'No Encontrado');
        } else {

            $trabajadores = DB::table('personas')
                ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
                ->select('trabajadors.id as id_trabajador', 'trabajadors.id_billetera')
                ->where('trabajadors.estado', '=', '1')
                ->where('personas.rut', '=', $request->rut_trabajador_)

                ->get();


            //sin terminar**************************************


            // $depositos = DB::table('gastos_historials')
            // ->join('trabajadors','trabajadors.id','=','gastos_historials.id_trabajador')
            // ->join('billetera_virtuals','billetera_virtuals.id','=','trabajadors.id_billetera')
            // ->join('deposito_mensuals','deposito_mensuals.id_billetera','=','billetera_virtuals.id')
            // ->where('gastos_historials.id_trabajador','=',$trabajadores[0]->id_trabajador)
            // ->where('gastos_historials.estado_eliminado','=',1)
            // ->select('gastos_historials.total','gastos_historials.fecha_registrado','trabajadors.id as id_trabaja','deposito_mensuals.total as total_deposito')

            // ->get();


            $depositos = DB::table('deposito_mensuals')
                ->join('trabajadors', 'trabajadors.id_billetera', '=', 'deposito_mensuals.id_billetera')
                ->join('billetera_virtuals', 'billetera_virtuals.id', '=', 'trabajadors.id_billetera')
                ->where('trabajadors.id', '=', $trabajadores[0]->id_trabajador)
                ->where('deposito_mensuals.descripcion_deposito', '<>', 'Reajuste')


                ->select('deposito_mensuals.fecha_realizado as fecha_registrado', 'deposito_mensuals.total as total_deposito')
                ->get()->toarray();


            $gastos = DB::table('gastos_historials')
                ->join('trabajadors', 'trabajadors.id', '=', 'gastos_historials.id_trabajador')
                ->where('trabajadors.id', '=', $trabajadores[0]->id_trabajador)


                ->select('gastos_historials.fecha_registrado', 'gastos_historials.total as total_gasto')
                ->get()->toarray();



            $suma_total = 0;
        }

        $depositos = array_merge($depositos, $gastos);


        $depositos = collect($depositos)->sortByDesc('fecha_registrado');


        $total = 0;

        for ($j = 0; $j < count($depositos); $j++) {

            if (!empty($depositos[$j]->total_gasto)) {

                $total = $total - $depositos[$j]->total_gasto;
            } else {
                $total = $total + $depositos[$j]->total_deposito;
            }
        }





        return view('gastos.see_gastos_deposito', compact('datos_personas', 'depositos', 'suma_total', 'gastos', 'total'));
    }


    public function filtro_sc_titulo(request $request)
    {


        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();
        $id_persona = $datos_trabajador[0]->id_persona;
        $persona =  App\persona::findOrfail($id_persona);
        $id_billetera = $datos_trabajador[0]->id_billetera;
        $billetera =  App\billetera_virtual::findOrfail($id_billetera);



        $buscar_total = DB::table('trabajadors')
            ->join('deposito_mensuals', 'deposito_mensuals.id_billetera', '=', 'trabajadors.id_billetera')
            ->where('trabajadors.id_persona', '=', $id_persona)
            ->select('deposito_mensuals.total')
            ->get();
        $suma_total = 0;

        foreach ($buscar_total as $v1) {
            foreach ($v1 as $total) {
                $suma_total += $total;
            }
        }
        $letra = $request->filtro_tabla;
        $id = $datos_trabajador[0]->id;

        $gastos_trabajador = DB::table('gastos_historials')
            ->join('sucursals', 'sucursals.id', '=', 'gastos_historials.id_sucursal')
            ->join('clientes', 'clientes.id', '=', 'sucursals.id_cliente')
            ->select(
                'gastos_historials.codigo_sc',
                'gastos_historials.id as id_gasto',
                'gastos_historials.titulo',
                'gastos_historials.estado',
                'gastos_historials.total',
                'sucursals.nombre as nombre_sucursal',
                'gastos_historials.fecha_registrado',
                'clientes.razon_social',
                'gastos_historials.descripcion_pago as descripcion_del_rembolso'
            )
            ->Where(function ($query) use ($letra, $id) {

                $query->where('gastos_historials.id_trabajador', '=', $id)
                    ->where('gastos_historials.estado_eliminado', '=', '1')
                    ->where('gastos_historials.titulo', 'like', '%' . $letra . '%');
            })
            ->orWhere(function ($query) use ($letra, $id) {

                $query->where('gastos_historials.id_trabajador', '=', $id)
                    ->where('gastos_historials.estado_eliminado', '=', '1')
                    ->where('gastos_historials.codigo_sc', 'like', '%' . $letra . '%');
            })







            ->orderBy('gastos_historials.id', 'desc')
            ->paginate(5);

        if ($request->filtro_tabla == "") {
            $opcion = "Buscar";
        } else {

            $opcion = "Todos";
        }


        return view('gastos.see_gastos', compact('persona', 'billetera', 'gastos_trabajador', 'suma_total', 'opcion'));
    }


    public function filtro_go_see_solicitudes(Request $request)
    {

        $array_  = explode(' ', $request->nombre_trabajador);





        if (count($array_) > 1) {

            $nombre =  $array_[0];
            $apellido =  $array_[1];
        } else {
            $nombre =  $array_[0];
            $apellido =  "";
        }

        //estado solicitud 1 -> solicitado, 2 -> respondido

        $gastos_trabajador = DB::table('solicitudes_reembolsos')
            ->join('trabajadors', 'trabajadors.id', '=', 'solicitudes_reembolsos.id_trabajador')
            ->join('billetera_virtuals', 'billetera_virtuals.id', '=', 'trabajadors.id_billetera')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->join('gastos_historials', 'gastos_historials.id', '=', 'solicitudes_reembolsos.gasto_historial')
            ->join('sucursals', 'sucursals.id', '=', 'gastos_historials.id_sucursal')
            ->join('clientes', 'clientes.id', '=', 'sucursals.id_cliente')
            ->select(
                'personas.nombre_uno',
                'personas.apellido_uno',
                'personas.apellido_dos',
                'gastos_historials.total',
                'gastos_historials.titulo',
                'clientes.razon_social',
                'sucursals.nombre as nombre_sucursal',
                'solicitudes_reembolsos.id as id_reembolso',
                'trabajadors.id as id_trabajador',
                'solicitudes_reembolsos.fecha_solicitada',
                'gastos_historials.descripcion_pago as descripcion_del_rembolso',
                'billetera_virtuals.total_acumulado',
                'billetera_virtuals.total_gastos',
                'gastos_historials.viaje_diario',
                'gastos_historials.colacion',
                'gastos_historials.otro_gasto',
                'gastos_historials.combustible',
                'gastos_historials.viaje_atenciones'
            )
            ->where('solicitudes_reembolsos.estado_solicitud', '=', 1)
            ->where('personas.nombre_uno', 'like', '%' . $nombre . '%')
            ->where('personas.apellido_uno', 'like', '%' . $apellido . '%')
            ->orderBy('solicitudes_reembolsos.id', 'desc')
            ->get();

        if ($nombre == "") {
            $opcion = 2;
        } else {
            $opcion = 1;
        }

        return view('solicitudes_gasto.solicitud_gasto', compact('gastos_trabajador', 'opcion'));
    }
    public function filtro_go_see_client(Request $request)
    {


        $clientes = DB::table('clientes')
            ->join('direccions', 'direccions.id', '=', 'clientes.id_direccion')
            ->join('regions', 'regions.id', '=', 'direccions.id_region')
            ->join('comunas', 'comunas.id', '=', 'direccions.id_comuna')
            ->select(
                'clientes.id as id_cliente',
                'clientes.razon_social',
                'clientes.rut',
                'clientes.telefono',
                'clientes.correo',
                'direccions.descripcion_direccion',
                'regions.des_region',
                'comunas.des_comuna',
                'comunas.id as id_comuna',
                'regions.id as id_region'
            )
            ->where('clientes.estado', "=", 1)

            ->where('clientes.rut', 'like', '%' . $request->rut_cliente_ . '%')
            ->get();

        $proveedores =  DB::table('users')
            ->select('nombre_proveedor')
            ->orderBy('nombre_proveedor', 'asc')

            ->where('nombre_proveedor', '!=', '')
            ->distinct()
            ->get();
        $regiones = App\region::all();
        $comunas = App\comuna::all();
        $clientes_2 = DB::table('clientes')
            ->where('clientes.estado', "=", 1)
            ->get();

        if ($request->rut_cliente_ == "") {
            $opcion = 2;
        } else {
            $opcion = 1;
        }


        return view('clientes.see_client', compact('clientes', 'clientes_2', 'regiones', 'comunas', 'opcion', 'proveedores'));
    }


    public function filtro_go_see_trabajador(Request $request)
    {
        // nombre_trabajador

        $array_  = explode(' ', $request->nombre_trabajador);





        if (count($array_) > 1) {

            $nombre =  $array_[0];
            $apellido =  $array_[1];
        } else {
            $nombre =  $array_[0];
            $apellido =  "";
        }

        $trabajadores = DB::table('personas')
            ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
            ->join('billetera_virtuals', 'billetera_virtuals.id', '=', 'trabajadors.id_billetera')
            ->select(
                'personas.nombre_uno',
                'personas.apellido_uno',
                'personas.apellido_dos',
                'personas.telefono1',
                'personas.telefono2',
                'personas.correo1',
                'personas.correo2',
                'billetera_virtuals.total_acumulado',
                'billetera_virtuals.fecha_actualizado_acumulado',
                'billetera_virtuals.total_gastos',
                'billetera_virtuals.fecha_actualizado_gasto',
                'trabajadors.id as id_trabajador'
            )
            ->where('trabajadors.estado', '=', '1')
            ->where('personas.nombre_uno', 'like', '%' . $nombre . '%')
            ->where('personas.apellido_uno', 'like', '%' . $apellido . '%')
            ->orderBy('trabajadors.id', 'desc')
            ->paginate(3);

        $bancos = App\cuentas_banco::where('nombre_banco', '!=', 'todoslosbancos')->where('estado', '=', 0)->get();
        $tipos_cuentas_bancos = App\tipos_cuentas_banco::all();

        if ($request->nombre == "") {
            $opcion = 2;
        } else {
            $opcion = 1;
        }

        return view('auth.ver_usuarios', compact('trabajadores', 'bancos', 'tipos_cuentas_bancos', 'opcion'));
    }



    // funciones para la manipulacion de solicitudes de dia *****************************************


    public function go_add_sol_dia()
    {

        $año = carbon::now();
        $año_actual = $año->year;
        $año_anterior = $año_actual - 1;

        $fecha_actual = Carbon::parse($año_actual . '-12-31')->format('Y-m-d');
        $fecha_anterior = Carbon::parse($año_anterior . '-01-01')->format('Y-m-d');


        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();

        $id_trabajador = $datos_trabajador[0]->id;

        $mis_dias_utilizados = DB::table('mis_dias')
            ->join('respuesta_solicitud_dias', 'respuesta_solicitud_dias.idrespuesta_solicitud_dias', '=', 'mis_dias.respuesta_solicitud_dias_idrespuesta_solicitud_dias')
            ->join('solicitudes_dias', 'solicitudes_dias.idsolicitudes_dia', '=', 'respuesta_solicitud_dias.solicitudes_dias_idsolicitudes_dia')
            ->join('estados_solicitudes', 'estados_solicitudes.id_estado_solicitud', '=', 'solicitudes_dias.estados_solicitudes_id')
            ->select('solicitudes_dias.total_dias')
            ->where("mis_dias.trabajadors_id", '=', $id_trabajador)

            ->whereBetween('solicitudes_dias.fecha_solicitada', [$fecha_anterior, $fecha_actual])
            ->get();

        $años_filtrados =  Carbon::parse($fecha_anterior)->format('d-m-Y') . " / " . Carbon::parse($fecha_actual)->format('d-m-Y');


        $acumulador_dias = 0;
        foreach ($mis_dias_utilizados as $valor) {
            $acumulador_dias = $valor->total_dias + $acumulador_dias;
        }
        $dias_disponibles = 30 -  $acumulador_dias;



        $tipos_solicitudes = App\estados_solicitudes::all();
        return view('solicitudes_dias.add_solicitud', compact('tipos_solicitudes', 'años_filtrados', 'dias_disponibles'));
    }

    public function mis_solicitud()
    {

        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();

        // $solicitudes_dias = App\solicitudes_dia::all();
        $solicitudes_dias = DB::table('solicitudes_dias')
            ->join('estados_solicitudes', 'estados_solicitudes.id_estado_solicitud', '=', 'solicitudes_dias.estados_solicitudes_id')
            ->select(
                'estados_solicitudes.descripcion',
                'solicitudes_dias.estado',
                'solicitudes_dias.fecha_solicitada',
                'solicitudes_dias.fecha_finalizada',
                'solicitudes_dias.fecha_enviada',
                'solicitudes_dias.total_dias',
                'solicitudes_dias.comentarios_solicitud',
                'solicitudes_dias.idsolicitudes_dia as id_solicitudes_dia'
            )
            ->where('solicitudes_dias.trabajadors_id', '=',  $datos_trabajador[0]->id)
            ->where("solicitudes_dias.estado", "!=", "eliminada")
            ->orderBy('solicitudes_dias.idsolicitudes_dia', 'desc')
            ->get();


        return view('solicitudes_dias.mis_solicitudes_dia', compact('solicitudes_dias'));
    }

    public function sol_pendientes()
    {

        $array = array();
        $solicitudes_dias = DB::table('solicitudes_dias')
            ->join('estados_solicitudes', 'estados_solicitudes.id_estado_solicitud', '=', 'solicitudes_dias.estados_solicitudes_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'solicitudes_dias.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')

            ->select(
                'estados_solicitudes.descripcion',
                'solicitudes_dias.estado',
                'solicitudes_dias.fecha_solicitada',
                'solicitudes_dias.fecha_finalizada',
                'solicitudes_dias.fecha_enviada',
                'solicitudes_dias.total_dias',
                'solicitudes_dias.comentarios_solicitud',
                'solicitudes_dias.trabajadors_id',
                'personas.nombre_uno',
                'estados_solicitudes.descripcion as tipo_estado',
                'solicitudes_dias.idsolicitudes_dia',
                'trabajadors.id as trabajador_id'
            )
            ->orderBy('solicitudes_dias.idsolicitudes_dia', 'desc')

            ->where('solicitudes_dias.estado', '=', "enviada")
            ->get();


        foreach ($solicitudes_dias as $solicitudes_dias_) {
            $id_trabajador =  $solicitudes_dias_->trabajadors_id . "<br>";

            $trabajador_sucursals = DB::table('trabajador_sucursals')
                ->join('sucursals', 'sucursals.id', '=', 'trabajador_sucursals.id_sucursals')
                ->join('direccions', 'direccions.id', '=', 'sucursals.id_direccion')
                ->join('regions', 'regions.id', '=', 'direccions.id_region')
                ->where('trabajador_sucursals.id_trabajador', '=', $id_trabajador)
                ->select('regions.des_region')
                ->get();
            $regiones = "";

            foreach ($trabajador_sucursals as $datos) {
                $regiones .= $datos->des_region . "-";
            }



            $array_[] = array(
                "nombre" => $solicitudes_dias_->nombre_uno,
                "estado" => $solicitudes_dias_->estado,
                "fecha_solicitada" => $solicitudes_dias_->fecha_solicitada,
                "fecha_finalizada" => $solicitudes_dias_->fecha_finalizada,
                "fecha_enviada" => $solicitudes_dias_->fecha_enviada,
                "total_dias" => $solicitudes_dias_->total_dias,
                "regiones" => $regiones,
                "tipo_estado" => $solicitudes_dias_->tipo_estado,
                "idsolicitudes_dia" => $solicitudes_dias_->idsolicitudes_dia,
                "trabajador_id" => $solicitudes_dias_->trabajador_id

            );
        }


        //  print_r($array);

        if (empty($array_)) {


            $asistencia = "";
            return view('solicitudes_dias.solicitudes_pendientes_ad', compact('asistencia'));
        } else {

            $asistenciax = collect($array_)->toArray();

            $asistencia = json_encode($asistenciax);
            return view('solicitudes_dias.solicitudes_pendientes_ad', compact('asistencia'));
        }
    }


    /*public function ver_api_solicitudes()
    {


        $Api_solicitudes = DB::table('api_solicitudes')
            ->orderBy('api_solicitudes.id', 'desc')
            ->get();

        return view('Apiviews.Api_solicitudes', compact('Api_solicitudes'));
    }*/
    public function ver_api_instalaciones_old()
    {


        $users = DB::table('users')
            ->where('users.id', '=', Auth::user()->id)
            ->get();


        $instalaciones =  DB::table('instalacions')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->select(
                'instalacions.id',
                'instalacions.dFecha_instalacion',
                'instalacions.sEstado_despacho',
                'instalacions.sCliente',
                'instalacions.sComuna',
                'instalacions.sSerie',
                'instalacions.sDireccion'
            )

            ->orderBy('instalacions.fecha_registrado', 'desc')

            ->get();

        return view('Apiviews.api_instalacion', compact('instalaciones'));
    }
    public function ver_api_retiros_old()
    {


        $retiros =  DB::table('retiros')
            ->join('tracker', 'tracker.id', '=', 'retiros.tracker_id')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->select('retiros.dFecharegistrado', 'retiros.id', 'retiros.sEstado', 'retiros.sCliente', 'retiros.sComuna', 'retiros.sSerie')
            //   ->where('proyectos.id','=',1) 
            ->orderBy('retiros.dFecharegistrado', 'desc')

            ->paginate(7);

        return view('Apiviews.api_retiros', compact('retiros'));
    }

    public function verinforme()
    {
        $proyectos = DB::table('proyectos')->select('proyectos.id', 'proyectos.nombre')
            ->where('proyectos.estado', '=', 1)
            ->where('proyectos.id', '!=', 1)
            ->orderBy('proyectos.id', 'asc')
            ->get();


        /*$informes =  DB::table('asignacion_instalacions') ->select('asignacion_instalacions.estado_asignacion','asignacion_instalacions.fecha_termino','asignacion_instalacions.fecha_termino','asignacion_instalacions.tipo')
                ->where('asignacion_instalacions.estado_asignacion','=','finalizado')
                ->orderBy('asignacion_instalacions.id', 'asc')
                ->get();
            
              $informes2 =  DB::table('asignacion_instalacions')
              ->select('asignacion_instalacions.fecha_asignado')
              ->orderBy('asignacion_instalacions.id', 'asc')
              ->get();
              
            
              $contador_fechafin = count($informes);
              $contador_general = count($informes2);
              $porcentaje = $contador_fechafin * 100 / $contador_general;
              $porcentaje2 = intval($porcentaje);*/
        $validacion = 0;
        return view('informes.informe', compact('proyectos', 'validacion'));
    }

    function vercapas(Request $request)
    {
        $capas = DB::table('capacitacions')
            ->orderBy('capacitacions.id', 'asc')
            ->get();

        $datos_instalacion = DB::table('instalacions')
            ->leftJoin('capacitacions', 'capacitacions.direccion', '=', 'instalacions.sDireccion')
            ->leftJoin('asignacion_capacitaciones', 'asignacion_capacitaciones.id_capa', '=', 'capacitacions.id')
            ->select(
                'instalacions.id',
                'instalacions.sCui',
                'instalacions.sCliente',
                'instalacions.sComuna',
                'instalacions.sTipo_sucursal',
                'instalacions.sDireccion',
                'asignacion_capacitaciones.estado_capa',
                'asignacion_capacitaciones.fecha_capacitacion',
                'capacitacions.url_pdf',
                'capacitacions.id as id_capacitacion'
            )
            ->where('instalacions.sDireccion', '!=', null)
            ->groupBy('instalacions.sDireccion')
            ->orderBy('id_capacitacion', 'DESC')
            ->distinct()
            ->limit(150)
            ->get();

        //obtener trabajadores asociados a checklist
        $tecnico = DB::table('users')
            ->join('trabajadors', 'trabajadors.id_login', '=', 'users.id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('trabajadors.estado', '=', '1')
            ->select('personas.nombre_uno', 'personas.apellido_uno', 'personas.id', 'trabajadors.id as id_trabajador')
            ->orderBy('personas.nombre_uno', 'asc')
            ->limit(150)

            ->distinct()
            ->get();

        //Cargar Select Estado
        $carga_selectEstado = DB::table('asignacion_capacitaciones')
            ->select('asignacion_capacitaciones.estado_capa')
            ->distinct()
            ->get();

        //Cargar Select Clientes
        if (strtolower(DB::connection()->getDatabaseName()) == "kyocera") {
            $carga_selectClientes = DB::table('instalacions')
                ->select('instalacions.sCliente')
                ->groupBy('instalacions.nID_Tracker')
                ->orderBy('instalacions.sCliente', 'asc')
                ->distinct()
                ->get();
        }else{
            $carga_selectClientes = DB::table('instalacions')
            ->select('instalacions.sCliente')
            ->orderBy('instalacions.sCliente', 'asc')
            ->distinct()
            ->get();
        }

        //Cargar Select Comuna
        $carga_selectComuna =  DB::table('instalacions')
            ->leftJoin('asignacion_capacitaciones', 'asignacion_capacitaciones.cui', '=', 'instalacions.sCui')
            ->leftJoin('capacitacions', 'capacitacions.id', '=', 'asignacion_capacitaciones.id_capa')
            ->select(
                'instalacions.sComuna',
            )
            ->where('instalacions.sCui', '!=', null)
            ->groupBy('instalacions.sCui')
            ->orderBy('instalacions.sCliente', 'asc')
            ->distinct()
            ->get();

        //Cargar select Direccion
        $carga_selectDireccion = DB::table('instalacions')
            ->select('instalacions.sDireccion')
            ->distinct()
            ->get();

        //Cargar select Sucursal
        $carga_selectSucursal = DB::table('instalacions')
            ->select('instalacions.sTipo_sucursal')
            ->distinct()
            ->get();

        $proyectos_sistema_propios = DB::table('proyectos')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->where('proyectos.estado', '=', '1')
            ->where('proyectos.id', '!=', '1')
            ->select('proyectos.nombre', 'clientes.razon_social', 'proyectos.id as id_proyecto')
            ->get();

        $carga_selectRegion = DB::table('instalacions')
            ->select('instalacions.sRegion')
            ->where('instalacions.sRegion', '!=', null)
            //->orderByRaw("CAST(instalacions.sRegion as UNSIGNED) ASC")
            ->orderByRaw(DB::raw("FIELD(instalacions.sRegion,  1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17) ASC"))
            ->distinct()
            ->get();

        $comuna = "";
        $id_persona = "";
        $estado = "";
        $clientes = "";
        $direccion = "";
        $sucursal = "";
        $region = "";
        return view('capacitacion.capacitacioneshome', compact('region', 'carga_selectRegion', 'sucursal', 'direccion', 'clientes', 'estado', 'id_persona', 'comuna', 'carga_selectDireccion', 'carga_selectSucursal', 'capas', 'datos_instalacion', 'tecnico', 'carga_selectComuna', 'carga_selectClientes', 'carga_selectEstado', 'proyectos_sistema_propios'));
    }

    function vercapas_old()
    {
        $capas = DB::table('capacitacions')
            ->orderBy('capacitacions.id', 'asc')
            ->get();


        return view('capacitacion.capacitacioneshome', compact('capas'));
    }
    function old_informedatos(Request $request)
    {
        $proyectos = DB::table('proyectos')->select('proyectos.id', 'proyectos.nombre')
            ->where('proyectos.estado', '=', 1)
            ->where('proyectos.id', '!=', 1)
            ->orderBy('proyectos.id', 'asc')
            ->get();
        $letra = $request->proyecto;
        //TOTAL PROYECTOS.
        $cantidad_equipo = DB::table('proyectos')->select('proyectos.cantidad_equipos')
            ->where('proyectos.estado', '=', 1)
            ->where('proyectos.id', '=', $letra)
            ->orderBy('proyectos.id', 'asc')
            ->get();

        //obtener datos de instalacion
        $instalacion = DB::table('instalacions')->select('instalacions.sEstado_instalacion')
            ->where('instalacions.sEstado_instalacion', '=', 'finalizado')
            ->orderBy('instalacions.id', 'asc')
            ->get();
        //total instalados finalizados
        $contador_instalacion = count($instalacion);

        $currentDateTime = date('Y-m-d');
        $instalaciontotal = DB::table('instalacions')->select('instalacions.id')
            ->where('instalacions.dFecha_instalacion', '<=', $currentDateTime)
            ->orderBy('instalacions.id', 'asc')
            ->get();
        //total instalados total tabla
        $contador_instalacion_total = count($instalaciontotal);

        $totalproyecto =   $cantidad_equipo[0]->cantidad_equipos;
        //% Avance planificado
        $valor_instalacion = $contador_instalacion_total * 100 / $totalproyecto;
        //% Avance ejecutado
        $ejecutadototal = $contador_instalacion * 100 / $totalproyecto;

        $desviacion = $contador_instalacion - $contador_instalacion_total;
        $desviacion2 = $ejecutadototal - $valor_instalacion;
        return view('informes.informe', compact('proyectos', 'cantidad_equipo', 'contador_instalacion_total', 'valor_instalacion', 'contador_instalacion', 'ejecutadototal', 'desviacion', 'desviacion2'));
    }

    function fetch_nombre(Request $request)
    {




        if ($request->get('query')) {

            $query = $request->get('query');
            $valores = explode(" ", $query);

            if (count($valores) > 1) {
                $nombre1 = $valores[0];
                $apelldo1 = $valores[1];
                $data = DB::table('personas')
                    ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
                    ->where('nombre_uno', 'LIKE', "%{$nombre1}%")
                    ->where('apellido_uno', 'LIKE', "%{$apelldo1}%")
                    ->where('trabajadors.estado', '=', 1)
                    ->select('personas.nombre_uno', 'personas.apellido_uno', 'personas.apellido_dos', 'trabajadors.id', 'personas.rut')
                    ->get();
            } elseif (count($valores) == 1) {
                $data = DB::table('personas')
                    ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
                    ->where('nombre_uno', 'LIKE', "%{$query}%")
                    ->where('trabajadors.estado', '=', 1)
                    ->select('personas.nombre_uno', 'personas.apellido_uno', 'personas.apellido_dos', 'trabajadors.id', 'personas.rut')

                    ->get();
            }


            $output = '<ul  class="alert alert-success" style="display:block; list-style:none">';
            foreach ($data as $row) {
                $output .= '
   <li class="mayuscula"  data-rut="' . $row->rut . '" style="list-style:none;cursor: pointer;">' . '<a>' . $row->nombre_uno . ' ' . $row->apellido_uno . ' ' . $row->apellido_dos . '</a></li><hr>
   ';
            }
            $output .= '</ul>';

            echo $output;
        } else {
        }
    }


    function fetch_nombrecliente(Request $request)
    {




        if ($request->get('query')) {

            $query = $request->get('query');
            $valores = explode(" ", $query);

            if (count($valores) > 1) {
                $nombre1 = $valores[0];
                $apelldo1 = $valores[1];
                $data = DB::table('clientes')
                    ->where('razon_social', 'LIKE', "%{$query}%")

                    ->where('clientes.estado', '=', 1)
                    ->select('razon_social', 'rut')
                    ->get();
            } elseif (count($valores) == 1) {
                $data = DB::table('clientes')
                    ->where('razon_social', 'LIKE', "%{$query}%")

                    ->where('clientes.estado', '=', 1)
                    ->select('razon_social', 'rut')
                    ->get();
            }


            $output = '<ul  class="alert alert-success" style="display:block; list-style:none">';
            foreach ($data as $row) {
                $output .= '
   <li class="mayuscula" data-rut="' . $row->rut . '" style="list-style:none;cursor: pointer;">' . '<a class="add_id" data-rut="' . "'" . $row->rut . "'" . '">' . $row->razon_social . '</a></li><hr>';
                //<li class="mayuscula " style="list-style:none;cursor: pointer;">'.'<a class="add_id" data-rut onclick="agregar_id('."'".$row->rut."'".')">'.$row->razon_social.'</a></li><hr>';

            }
            $output .= '</ul>';

            echo $output;
        } else {
        }
    }
    public function check_tecnico()
    {

        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();

        $id_trabajador = $datos_trabajador[0]->id;

        $databases = App\bd_proveedores::selectDB();


        foreach ($databases as $los_datos) {

        

        $datos_retiros = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->where('asignacion_retiros.estado_asignacion', '=', 'rechazado')
            ->orWhere('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
            ->select(
                'checklist_retiros.motivo_reasignado',
                'checklist_retiros.Csdireccion',
                'checklist_retiros.Cscliente',
                'asignacion_retiros.estado_asignacion',
                'asignacion_retiros.fecha_asignado as fecha_as',
                'asignacion_retiros.id',
                'asignacion_retiros.tipo',
                'asignacion_retiros.motivo_rechazado',
                'asignacion_retiros.fecha_retiro as fecha_visita',
                'checklist_retiros.csComuna',
                'checklist_retiros.CsSerie',
                'retiros.proveedor_retiro as proveedor',
                DB::raw('null as idSala')

            );
            $datos_asignacion[] = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
            ->orWhere('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_instalacions.estado_asignacion', '=', 'rechazado')
            ->select(
                'checklist_instalacions.motivo_reasignado',
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscliente',
                'asignacion_instalacions.estado_asignacion',
                'asignacion_instalacions.fecha_asignado as fecha_as',
                'asignacion_instalacions.id',
                'asignacion_instalacions.tipo',
                'asignacion_instalacions.motivo_rechazado',
                'asignacion_instalacions.fecha_instalacion as fecha_visita',
                'checklist_instalacions.csComuna',
                'checklist_instalacions.CsSerie',
                'instalacions.proveedor_instalacion as proveedor',
                'instalacions.idSala'

            )
            ->orderBy('fecha_visita', 'desc')
            ->union($datos_retiros)
            ->get();


          }

        //   return $datos_asignacion;
        foreach ($databases as $los_datos) {
        $datos_retiros2 = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->where('asignacion_retiros.estado_asignacion', '=', 'rechazado')
            ->orWhere('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
            ->select(
                'checklist_retiros.motivo_reasignado',
                'checklist_retiros.Csdireccion',
                'checklist_retiros.Cscliente',
                'asignacion_retiros.estado_asignacion',
                'asignacion_retiros.fecha_asignado as fecha_as',
                'asignacion_retiros.id',
                'asignacion_retiros.tipo',
                'asignacion_retiros.motivo_rechazado',
                'asignacion_retiros.fecha_retiro as fecha_visita',
                'checklist_retiros.csComuna',
                'checklist_retiros.CsSerie',
                'retiros.proveedor_retiro as proveedor',
                DB::raw('null as idSala')

            );

        $datos_asignacion2[] = DB::Connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
            ->orWhere('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_instalacions.estado_asignacion', '=', 'rechazado')
            ->select(
                'checklist_instalacions.motivo_reasignado',
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscliente',
                'asignacion_instalacions.estado_asignacion',
                'asignacion_instalacions.fecha_asignado as fecha_as',
                'asignacion_instalacions.id',
                'asignacion_instalacions.tipo',
                'asignacion_instalacions.motivo_rechazado',
                'asignacion_instalacions.fecha_instalacion as fecha_visita',
                'checklist_instalacions.csComuna',
                'checklist_instalacions.CsSerie',
                'instalacions.proveedor_instalacion as proveedor',
                'instalacions.idSala'

            )
            ->union($datos_retiros2)
            ->orderBy('fecha_visita', 'desc')
            ->get();
   }

 foreach ($databases as $los_datos) {
        $datos_retiros3 = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->where('asignacion_retiros.estado_asignacion', '=', 'rechazado')
            ->orWhere('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
            ->select(
                'checklist_retiros.motivo_reasignado',
                'checklist_retiros.Csdireccion',
                'checklist_retiros.Cscliente',
                'asignacion_retiros.estado_asignacion',
                'asignacion_retiros.fecha_asignado as fecha_as',
                'asignacion_retiros.id',
                'asignacion_retiros.tipo',
                'asignacion_retiros.motivo_rechazado',
                'asignacion_retiros.fecha_retiro as fecha_visita',
                'checklist_retiros.csComuna',
                'checklist_retiros.CsSerie',
                'retiros.proveedor_retiro as proveedor',
                DB::raw('null as idSala')

            );

        $datos_asignacion3[] = DB::Connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
            ->orWhere('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_instalacions.estado_asignacion', '=', 'rechazado')
            ->select(
                'checklist_instalacions.motivo_reasignado',
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscliente',
                'asignacion_instalacions.estado_asignacion',
                'asignacion_instalacions.fecha_asignado as fecha_as',
                'asignacion_instalacions.id',
                'asignacion_instalacions.tipo',
                'asignacion_instalacions.motivo_rechazado',
                'asignacion_instalacions.fecha_instalacion as fecha_visita',
                'checklist_instalacions.csComuna',
                'checklist_instalacions.CsSerie',
                'instalacions.proveedor_instalacion as proveedor',
                'instalacions.idSala'

            )
            ->union($datos_retiros3)
            ->orderBy('fecha_visita', 'desc')
            ->get();
 }
        //Cargar Select Estado
        $estado_instalacion = DB::table('asignacion_instalacions')
            ->select('estado_asignacion')
            ->where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->distinct();

        $estado_retiros = DB::table('asignacion_retiros')
            ->select('estado_asignacion')
            ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->union($estado_instalacion)
            ->distinct()
            ->get();

        //Cargar Select Estado
        $tipo_asignacion = DB::table('asignacion_instalacions')
            ->select('asignacion_instalacions.tipo')
            ->where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador);

        $asignaciones = DB::table('asignacion_retiros')
            ->select('asignacion_retiros.tipo')
            ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->union($tipo_asignacion)
            ->distinct()
            ->get();

        //Cargar comunas
        $comuna_instalacion = DB::table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->select('checklist_instalacions.Cscomuna')
            ->where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador);

        $comuna_retiros = DB::table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->select('checklist_retiros.Cscomuna')
            ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->union($comuna_instalacion)
            ->get();


        return view('check.check_tecnico', compact('datos_asignacion3', 'datos_asignacion2', 'datos_asignacion', 'datos_retiros2', 'estado_retiros', 'comuna_retiros', 'asignaciones'));
    }
    public function check_tecnico_22_02_23()
    {

        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();

        $id_trabajador = $datos_trabajador[0]->id;

        $databases = App\bd_proveedores::selectDB();


        foreach ($databases as $los_datos) {

        

        $datos_retiros = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->where('asignacion_retiros.estado_asignacion', '=', 'rechazado')
            ->orWhere('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
            ->select(
                'checklist_retiros.motivo_reasignado',
                'checklist_retiros.Csdireccion',
                'checklist_retiros.Cscliente',
                'asignacion_retiros.estado_asignacion',
                'asignacion_retiros.fecha_asignado as fecha_as',
                'asignacion_retiros.id',
                'asignacion_retiros.tipo',
                'asignacion_retiros.motivo_rechazado',
                'asignacion_retiros.fecha_retiro as fecha_visita',
                'checklist_retiros.csComuna',
                'checklist_retiros.CsSerie',
                'retiros.proveedor_retiro as proveedor'
            );
            $datos_asignacion[] = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
            ->orWhere('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_instalacions.estado_asignacion', '=', 'rechazado')
            ->select(
                'checklist_instalacions.motivo_reasignado',
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscliente',
                'asignacion_instalacions.estado_asignacion',
                'asignacion_instalacions.fecha_asignado as fecha_as',
                'asignacion_instalacions.id',
                'asignacion_instalacions.tipo',
                'asignacion_instalacions.motivo_rechazado',
                'asignacion_instalacions.fecha_instalacion as fecha_visita',
                'checklist_instalacions.csComuna',
                'checklist_instalacions.CsSerie',
                'instalacions.proveedor_instalacion as proveedor'
            )
            ->orderBy('fecha_visita', 'desc')
            ->union($datos_retiros)
            ->get();


          }

        //   return $datos_asignacion;
        foreach ($databases as $los_datos) {
        $datos_retiros2 = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->where('asignacion_retiros.estado_asignacion', '=', 'rechazado')
            ->orWhere('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
            ->select(
                'checklist_retiros.motivo_reasignado',
                'checklist_retiros.Csdireccion',
                'checklist_retiros.Cscliente',
                'asignacion_retiros.estado_asignacion',
                'asignacion_retiros.fecha_asignado as fecha_as',
                'asignacion_retiros.id',
                'asignacion_retiros.tipo',
                'asignacion_retiros.motivo_rechazado',
                'asignacion_retiros.fecha_retiro as fecha_visita',
                'checklist_retiros.csComuna',
                'checklist_retiros.CsSerie',
                'retiros.proveedor_retiro as proveedor'
            );

        $datos_asignacion2[] = DB::Connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
            ->orWhere('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_instalacions.estado_asignacion', '=', 'rechazado')
            ->select(
                'checklist_instalacions.motivo_reasignado',
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscliente',
                'asignacion_instalacions.estado_asignacion',
                'asignacion_instalacions.fecha_asignado as fecha_as',
                'asignacion_instalacions.id',
                'asignacion_instalacions.tipo',
                'asignacion_instalacions.motivo_rechazado',
                'asignacion_instalacions.fecha_instalacion as fecha_visita',
                'checklist_instalacions.csComuna',
                'checklist_instalacions.CsSerie',
                'instalacions.proveedor_instalacion as proveedor'
            )
            ->union($datos_retiros2)
            ->orderBy('fecha_visita', 'desc')
            ->get();
   }

 foreach ($databases as $los_datos) {
        $datos_retiros3 = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->where('asignacion_retiros.estado_asignacion', '=', 'rechazado')
            ->orWhere('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
            ->select(
                'checklist_retiros.motivo_reasignado',
                'checklist_retiros.Csdireccion',
                'checklist_retiros.Cscliente',
                'asignacion_retiros.estado_asignacion',
                'asignacion_retiros.fecha_asignado as fecha_as',
                'asignacion_retiros.id',
                'asignacion_retiros.tipo',
                'asignacion_retiros.motivo_rechazado',
                'asignacion_retiros.fecha_retiro as fecha_visita',
                'checklist_retiros.csComuna',
                'checklist_retiros.CsSerie',
                'retiros.proveedor_retiro as proveedor'
            );

        $datos_asignacion3[] = DB::Connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
            ->orWhere('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_instalacions.estado_asignacion', '=', 'rechazado')
            ->select(
                'checklist_instalacions.motivo_reasignado',
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscliente',
                'asignacion_instalacions.estado_asignacion',
                'asignacion_instalacions.fecha_asignado as fecha_as',
                'asignacion_instalacions.id',
                'asignacion_instalacions.tipo',
                'asignacion_instalacions.motivo_rechazado',
                'asignacion_instalacions.fecha_instalacion as fecha_visita',
                'checklist_instalacions.csComuna',
                'checklist_instalacions.CsSerie',
                'instalacions.proveedor_instalacion as proveedor'
            )
            ->union($datos_retiros3)
            ->orderBy('fecha_visita', 'desc')
            ->get();
 }
        //Cargar Select Estado
        $estado_instalacion = DB::table('asignacion_instalacions')
            ->select('estado_asignacion')
            ->where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->distinct();

        $estado_retiros = DB::table('asignacion_retiros')
            ->select('estado_asignacion')
            ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->union($estado_instalacion)
            ->distinct()
            ->get();

        //Cargar Select Estado
        $tipo_asignacion = DB::table('asignacion_instalacions')
            ->select('asignacion_instalacions.tipo')
            ->where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador);

        $asignaciones = DB::table('asignacion_retiros')
            ->select('asignacion_retiros.tipo')
            ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->union($tipo_asignacion)
            ->distinct()
            ->get();

        //Cargar comunas
        $comuna_instalacion = DB::table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->select('checklist_instalacions.Cscomuna')
            ->where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador);

        $comuna_retiros = DB::table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->select('checklist_retiros.Cscomuna')
            ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->union($comuna_instalacion)
            ->get();


        return view('check.check_tecnico', compact('datos_asignacion3', 'datos_asignacion2', 'datos_asignacion', 'datos_retiros2', 'estado_retiros', 'comuna_retiros', 'asignaciones'));
    }

    public function check_tecnico_old_20_02_23()
    {

        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();

        $id_trabajador = $datos_trabajador[0]->id;

        $datos_retiros = DB::connection('comtecglobal')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->where('asignacion_retiros.estado_asignacion', '=', 'rechazado')
            ->orWhere('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
            ->select(
                'checklist_retiros.motivo_reasignado',
                'checklist_retiros.Csdireccion',
                'checklist_retiros.Cscliente',
                'asignacion_retiros.estado_asignacion',
                'asignacion_retiros.fecha_asignado as fecha_as',
                'asignacion_retiros.id',
                'asignacion_retiros.tipo',
                'asignacion_retiros.motivo_rechazado',
                'asignacion_retiros.fecha_retiro as fecha_visita',
                'checklist_retiros.csComuna',
                'checklist_retiros.CsSerie',
                'retiros.proveedor_retiro as proveedor'
            );
        $datos_asignacion = DB::connection('comtecglobal')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
            ->orWhere('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_instalacions.estado_asignacion', '=', 'rechazado')
            ->select(
                'checklist_instalacions.motivo_reasignado',
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscliente',
                'asignacion_instalacions.estado_asignacion',
                'asignacion_instalacions.fecha_asignado as fecha_as',
                'asignacion_instalacions.id',
                'asignacion_instalacions.tipo',
                'asignacion_instalacions.motivo_rechazado',
                'asignacion_instalacions.fecha_instalacion as fecha_visita',
                'checklist_instalacions.csComuna',
                'checklist_instalacions.CsSerie',
                'instalacions.proveedor_instalacion as proveedor'
            )
            ->orderBy('fecha_visita', 'desc')
            ->union($datos_retiros)
            ->get();

        $datos_retiros2 = DB::connection('kyocera')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->where('asignacion_retiros.estado_asignacion', '=', 'rechazado')
            ->orWhere('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
            ->select(
                'checklist_retiros.motivo_reasignado',
                'checklist_retiros.Csdireccion',
                'checklist_retiros.Cscliente',
                'asignacion_retiros.estado_asignacion',
                'asignacion_retiros.fecha_asignado as fecha_as',
                'asignacion_retiros.id',
                'asignacion_retiros.tipo',
                'asignacion_retiros.motivo_rechazado',
                'asignacion_retiros.fecha_retiro as fecha_visita',
                'checklist_retiros.csComuna',
                'checklist_retiros.CsSerie',
                'retiros.proveedor_retiro as proveedor'
            );

        $datos_asignacion2 = DB::Connection('kyocera')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
            ->orWhere('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_instalacions.estado_asignacion', '=', 'rechazado')
            ->select(
                'checklist_instalacions.motivo_reasignado',
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscliente',
                'asignacion_instalacions.estado_asignacion',
                'asignacion_instalacions.fecha_asignado as fecha_as',
                'asignacion_instalacions.id',
                'asignacion_instalacions.tipo',
                'asignacion_instalacions.motivo_rechazado',
                'asignacion_instalacions.fecha_instalacion as fecha_visita',
                'checklist_instalacions.csComuna',
                'checklist_instalacions.CsSerie',
                'instalacions.proveedor_instalacion as proveedor'
            )
            ->union($datos_retiros2)
            ->orderBy('fecha_visita', 'desc')
            ->get();

        $datos_retiros3 = DB::connection('upgrade')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->where('asignacion_retiros.estado_asignacion', '=', 'rechazado')
            ->orWhere('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
            ->select(
                'checklist_retiros.motivo_reasignado',
                'checklist_retiros.Csdireccion',
                'checklist_retiros.Cscliente',
                'asignacion_retiros.estado_asignacion',
                'asignacion_retiros.fecha_asignado as fecha_as',
                'asignacion_retiros.id',
                'asignacion_retiros.tipo',
                'asignacion_retiros.motivo_rechazado',
                'asignacion_retiros.fecha_retiro as fecha_visita',
                'checklist_retiros.csComuna',
                'checklist_retiros.CsSerie',
                'retiros.proveedor_retiro as proveedor'
            );

        $datos_asignacion3 = DB::Connection('upgrade')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
            ->orWhere('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_instalacions.estado_asignacion', '=', 'rechazado')
            ->select(
                'checklist_instalacions.motivo_reasignado',
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscliente',
                'asignacion_instalacions.estado_asignacion',
                'asignacion_instalacions.fecha_asignado as fecha_as',
                'asignacion_instalacions.id',
                'asignacion_instalacions.tipo',
                'asignacion_instalacions.motivo_rechazado',
                'asignacion_instalacions.fecha_instalacion as fecha_visita',
                'checklist_instalacions.csComuna',
                'checklist_instalacions.CsSerie',
                'instalacions.proveedor_instalacion as proveedor'
            )
            ->union($datos_retiros3)
            ->orderBy('fecha_visita', 'desc')
            ->get();

        //Cargar Select Estado
        $estado_instalacion = DB::table('asignacion_instalacions')
            ->select('estado_asignacion')
            ->where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->distinct();

        $estado_retiros = DB::table('asignacion_retiros')
            ->select('estado_asignacion')
            ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->union($estado_instalacion)
            ->distinct()
            ->get();

        //Cargar Select Estado
        $tipo_asignacion = DB::table('asignacion_instalacions')
            ->select('asignacion_instalacions.tipo')
            ->where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador);

        $asignaciones = DB::table('asignacion_retiros')
            ->select('asignacion_retiros.tipo')
            ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->union($tipo_asignacion)
            ->distinct()
            ->get();

        //Cargar comunas
        $comuna_instalacion = DB::table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->select('checklist_instalacions.Cscomuna')
            ->where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador);

        $comuna_retiros = DB::table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->select('checklist_retiros.Cscomuna')
            ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->union($comuna_instalacion)
            ->get();


        return view('check.check_tecnico', compact('datos_asignacion3', 'datos_asignacion2', 'datos_asignacion', 'datos_retiros2', 'estado_retiros', 'comuna_retiros', 'asignaciones'));
    }


    public function ir_resumen()
    {
        //Cargar Select Clientes
        $carga_selectClientes = DB::table('instalacions')
            ->select('instalacions.sCliente')
            ->orderBy('instalacions.sCliente', 'asc')
            ->distinct()
            ->get();



        return view('Apiviews.intermedio_instalacion', compact('carga_selectClientes'));
    }


    public function siguiente_ver_api_instalaciones()
    {


        //Cargar Select Clientes
        $nID_Tracker = DB::table('instalacions')
            ->select('instalacions.nID_Tracker')
            ->get();

        if (strtolower(DB::connection()->getDatabaseName()) == "kyocera") {

            $carga_selectClientes = DB::table('instalacions')
                ->select('instalacions.sCliente')
                ->groupBy('instalacions.nID_Tracker')
                ->orderBy('instalacions.sCliente', 'asc')
                ->distinct()
                ->get();
        } else {
            $carga_selectClientes = DB::table('instalacions')
                ->select('instalacions.sCliente')
                ->orderBy('instalacions.sCliente', 'asc')
                ->distinct()
                ->get();
        }

        return view('Apiviews.intermedio_instalacion', compact('carga_selectClientes'));
    }

    // public function buscarComunas(request $request )
    // {

    //      $carga_selectComuna = DB::table('instalacions')
    //     ->select('instalacions.sComuna')
    //     ->orderBy('instalacions.sComuna', 'asc')
    //     ->orderByRaw(DB::raw("FIELD(instalacions.sRegion, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17 ) ASC"))

    //     ->where("instalacions.sRegion","=",$request->region)

    //     ->distinct()
    //     ->get();

    //     return $carga_selectComuna;
    // }




    public function ver_api_instalaciones(request $request)
    {

        $users = DB::table('users')
            ->where('users.id', '=', Auth::user()->id)
            ->get();

        $cliente_seleccionado = $request->clientes;

        if (strtolower(DB::connection()->getDatabaseName()) == "kyocera") {
            $nid_tracker = DB::table('instalacions')
                ->select('nID_Tracker')
                ->where('sCliente', '=', $cliente_seleccionado)
                ->orderby('id', 'ASC')
                ->get();

            $instalaciones =  DB::table('instalacions')
                ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
                ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
                ->select(
                    'proyectos.nombre',
                    'instalacions.id',
                    'instalacions.sTipo_sucursal',
                    'instalacions.sRegion',
                    'instalacions.instalador',
                    'instalacions.sCui',
                    'instalacions.dFecha_instalacion',
                    'instalacions.fecha_registrado',
                    'instalacions.sEstado_despacho',
                    'instalacions.sCliente',
                    'instalacions.sComuna',
                    'instalacions.sSerie',
                    'instalacions.sDireccion',
                    'instalacions.fecha_registrado',
                    'instalacions.sEstado_instalacion',
                    'instalacions.fecha_instalacion_coordinadora',
                    'instalacions.Csserie_remplazo',
                    'instalacions.Csserie_es',
                    'instalacions.i_opcion_estado_instalacion',
                    'instalacions.razonSocial',
                    'instalacions.tipo',
                    'instalacions.idSala'

                )
                ->where("instalacions.nID_Tracker", "=", $nid_tracker[0]->nID_Tracker)
                ->orderBy('instalacions.fecha_instalacion_coordinadora', 'desc')
                ->limit(150)
                ->get();
        } else {

            $instalaciones =  DB::table('instalacions')
                ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
                ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
                ->select(
                    'proyectos.nombre',
                    'instalacions.id',
                    'instalacions.sTipo_sucursal',
                    'instalacions.sRegion',
                    'instalacions.instalador',
                    'instalacions.sCui',
                    'instalacions.dFecha_instalacion',
                    'instalacions.fecha_registrado',
                    'instalacions.sEstado_despacho',
                    'instalacions.sCliente',
                    'instalacions.sComuna',
                    'instalacions.sSerie',
                    'instalacions.sDireccion',
                    'instalacions.fecha_registrado',
                    'instalacions.sEstado_instalacion',
                    'instalacions.fecha_instalacion_coordinadora',
                    'instalacions.Csserie_remplazo',
                    'instalacions.Csserie_es',
                    'instalacions.i_opcion_estado_instalacion',
                    'instalacions.idSala'

                )
                ->where("instalacions.sCliente", "=", $cliente_seleccionado)
                ->orderBy('instalacions.fecha_instalacion_coordinadora', 'desc')
                ->limit(150)

                ->get();
        }

        //Cargar Select Estado
        $carga_selectEstado = DB::table('instalacions')
            ->select('instalacions.sEstado_instalacion')
            ->orderBy('instalacions.sEstado_instalacion', 'asc')
            ->distinct()
            ->get();
        //Cargar Select Clientes
        $carga_selectClientes = DB::table('instalacions')
            ->select('instalacions.sCliente')
            ->orderBy('instalacions.sCliente', 'asc')
            ->distinct()
            ->get();
        $cliente = DB::table('clientes')
            ->select('id')
            ->where('clientes.razon_social', '=', $cliente_seleccionado)
            ->get();
//razonsocialAgrupada
            $con_razonSocial= "no";
            $razonAgrupasa = DB::table('clientes')
            ->select('razon_social_agrupada')
            ->where('clientes.razon_social', '=', $cliente_seleccionado)
            ->get();


            if(count($razonAgrupasa ) >0){
              $con_razonSocial = $razonAgrupasa[0]->razon_social_agrupada;
            }else{
                $con_razonSocial= "no";
            
            }

            // 
        $carga_selectProyecto = DB::table('instalacions')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->select('proyectos.id', 'proyectos.nombre')
            ->where("instalacions.sCliente", "=", $cliente_seleccionado)
            ->where('proyectos.id', '!=', 1)
            ->distinct()
            ->get();

        //Cargar Select Region
        $carga_selectRegion = DB::table('instalacions')
            ->select('instalacions.sRegion')
            ->where('instalacions.sRegion', '!=', null)
            //->orderByRaw("CAST(instalacions.sRegion as UNSIGNED) ASC")
            ->orderByRaw(DB::raw("FIELD(instalacions.sRegion,  1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17) ASC"))
            ->where("instalacions.sCliente", "=", $cliente_seleccionado)
            ->distinct()
            ->get();
        //Cargar Select Comuna
        $carga_selectComuna = DB::table('instalacions')
            ->select('instalacions.sComuna')
            ->where("instalacions.sCliente", "=", $cliente_seleccionado)
            ->orderBy('instalacions.sComuna', 'asc')
            ->distinct()
            ->get();

        //Cargar Select direccion
        $direccionTemporal = DB::table('instalacions')
            ->select('instalacions.sDireccion as descripcion_direccion')
            ->where("instalacions.sCliente", "=", $cliente_seleccionado)
            ->distinct()
            ->get();

        //Cargar Select Sucursal
        $carga_selectSucursal = DB::table('instalacions')
            ->select('instalacions.sTipo_sucursal')
            ->where("instalacions.sCliente", "=", $cliente_seleccionado)
            ->distinct()
            ->get();

        //obtener trabajadores asociados a checklist
        $tecnico = DB::table('asignacion_instalacions')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('trabajadors.estado', '=', '1')
            ->select('personas.nombre_uno', 'personas.apellido_uno', 'personas.id')
            ->orderBy('personas.nombre_uno', 'asc')
            ->distinct()
            ->get();
        /*  $usuario_empresas = 0;  */

        $id_persona = "";
        $direccion = "";
        $sucursal = "";
        $sc = "";
        $serie = "";
        $comuna = "";
        $region = "";
        $estado = "";
        $proyectoseleccionado = "";


        return view('Apiviews.api_instalacion', compact('con_razonSocial','proyectoseleccionado', 'carga_selectProyecto', 'direccion', 'sucursal', 'sc', 'serie', 'comuna', 'region', 'estado', 'id_persona', 'carga_selectSucursal', 'direccionTemporal', 'instalaciones', 'carga_selectEstado', 'carga_selectClientes', 'carga_selectComuna', 'tecnico', 'cliente_seleccionado', 'carga_selectRegion'));
    }

    //CREAR FUNCION PARA FILTROS API INSTALACION
    public function filtros_instalacion(Request $request)
    {
        $proyectos = $request->proyectos;
        $proyectoseleccionado = $proyectos;
        $id_persona = $request->tecnicos;
        $estado = $request->estado;
        $clientes = $request->clientes;
        $region = $request->region;
        $comuna = $request->comuna;
        $serie = $request->serie;
        $sc = $request->sc;
        $sucursal = $request->sucursal;
        $direccion = $request->direccion;
        $cliente_seleccionado = $request->clientes;
        $fecha = "";
        $fecha2 = "";

        if (strtolower(DB::connection()->getDatabaseName()) == "kyocera") {
            $nid_tracker = DB::table('instalacions')
                ->select('nID_Tracker')
                ->where('sCliente', '=', $cliente_seleccionado)
                ->orderby('id', 'ASC')
                ->get();
        }

        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();

        $id_trabajador = $datos_trabajador[0]->id;


        //$where  = "instalacions.proveedor_instalacion ="."'".$proveedor."'". " and instalacions.sEstado_despacho != "."'"."estoesparapasarlosdemasparametros"."'";
        $where  = "instalacions.proveedor_instalacion !=" . "'" . "'";
        if ($request->datepicker != "" && $request->datepicker2 != "") {
            $fecha = Carbon::createFromDate($request->datepicker)->format('Y-m-d');
            $fecha2 = Carbon::createFromDate($request->datepicker2)->format('Y-m-d');
            $where = $where . " and instalacions.fecha_instalacion_coordinadora" . " BETWEEN " . "'" . $fecha . "'" . " and " . "'" . $fecha2 . "'";
        }

        if ($estado != "") {
            $where = $where . " and instalacions.sEstado_instalacion" . " = " . "'" . $estado . "'";
        }

        if ($clientes != "") {
            if (strtolower(DB::connection()->getDatabaseName()) == "kyocera") {
                $where = $where . " and instalacions.nID_Tracker = " . "'" . $nid_tracker[0]->nID_Tracker . "'";
            }else{
                $where = $where . " and instalacions.sCliente = " . "'" . $cliente_seleccionado . "'";
            }
        }

        if ($region != "") {
            $where = $where . " and  instalacions.sRegion  = " . "'" . $region . "'";
        }

        if ($comuna != "") {
            $where = $where . " and  instalacions.sComuna  = " . "'" . $comuna . "'";
        }

        if ($serie != "") {

            $consulta = DB::table('instalacions')
                ->where('instalacions.sSerie', '=', $serie)
                ->get();

            if (!empty($consulta[0]->sSerie)) {
                $where = $where . " and  instalacions.sSerie  = " . "'" . $serie . "'";
            } else {
                $where = $where . " and  instalacions.Csserie_remplazo  = " . "'" . $serie . "'";
            }
        }

        if ($sc != "") {
            $where = $where . " and  instalacions.sSC  = " . "'" . $sc . "'";
        }

        if ($sucursal != "") {
            $where = $where . " and instalacions.sTipo_sucursal = " . "'" . $sucursal . "'";
        }

        if ($direccion != "") {
            $where = $where . " and instalacions.sDireccion = " . "'" . $direccion . "'";
        }
        if ($proyectos != "") {
            $where = $where . " and proyectos.id = " . "'" . $proyectos . "'";
        }

        if ($id_persona != "") {

            $id_trabajador =  DB::table('trabajadors')
                ->select('trabajadors.id')
                ->where('trabajadors.id_persona', '=', $id_persona)
                ->get();

            $id_tra =  $id_trabajador[0]->id;

            $where = $where . " and  asignacion_instalacions.trabajadors_id  = " . "'" . $id_tra . "'";


            $instalaciones = DB::select('select 
        proyectos.nombre,
            instalacions.sRegion,
            instalacions.sTipo_sucursal,
            instalacions.instalador,
            instalacions.sCui,
            instalacions.sEstado_instalacion,
            instalacions.fecha_instalacion_coordinadora,
            instalacions.id,
            instalacions.dFecha_instalacion,
            instalacions.fecha_registrado,
            instalacions.sEstado_despacho,
            instalacions.sCliente,
            instalacions.sComuna,
            instalacions.Csserie_remplazo,
            instalacions.Csserie_es,
            instalacions.sSerie,instalacions.sDireccion,
            instalacions.i_opcion_estado_instalacion
            from instalacions
            inner join asignacion_instalacions on instalacions.id = asignacion_instalacions.lista_instalacion_id  
            inner join tracker on tracker.id = instalacions.tracker_idtracker  
            inner join  proyectos on  proyectos.id = tracker.proyecto_id  where ' . $where . " group by  instalacions.sSerie 
            order by instalacions.fecha_instalacion_coordinadora desc ");
        } else {

            $instalaciones = DB::select('select
        proyectos.nombre,
            instalacions.sRegion,
            instalacions.sTipo_sucursal,
            instalacions.instalador,
            instalacions.sCui,
            instalacions.sEstado_instalacion,
            instalacions.fecha_instalacion_coordinadora,
            instalacions.id,instalacions.dFecha_instalacion,
            instalacions.fecha_registrado,instalacions.sEstado_despacho,
            instalacions.sCliente,
            instalacions.sComuna,
            instalacions.sSerie,
            instalacions.sDireccion,
            instalacions.Csserie_remplazo,
            instalacions.Csserie_es,
            instalacions.i_opcion_estado_instalacion
            from instalacions
            inner join tracker on tracker.id = instalacions.tracker_idtracker
            inner join  proyectos on  proyectos.id = tracker.proyecto_id  
            where ' . $where . " 
            order by instalacions.fecha_instalacion_coordinadora desc ");

            //return $where;
        }

        //Cargar Select Estado
        $carga_selectEstado = DB::table('instalacions')
            ->select('instalacions.sEstado_instalacion')
            ->orderBy('instalacions.sEstado_instalacion', 'asc')
            ->distinct()
            ->get();

        //Cargar Select Clientes
        $carga_selectClientes = DB::table('instalacions')
            ->select('instalacions.sCliente')
            ->orderBy('instalacions.sCliente', 'asc')
            ->distinct()
            ->get();

        //Cargar Select Region
        $carga_selectRegion = DB::table('instalacions')
            ->select('instalacions.sRegion')
            ->orderByRaw(DB::raw("FIELD(instalacions.sRegion,  1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17) ASC"))
            ->where("instalacions.sCliente", "=", $clientes)
            ->where('instalacions.sRegion', '!=', null)
            //->orderBy('instalacions.sRegion', 'asc')
            ->distinct()
            ->get();

        //Cargar Select direccion
        $direccionTemporal = DB::table('instalacions')
            ->select('instalacions.sDireccion as descripcion_direccion')
            ->where("instalacions.sCliente", "=", $request->clientes)
            ->where("instalacions.sComuna", "=", $comuna)

            ->distinct()
            ->get();

        //Cargar Select Sucursal
        $carga_selectSucursal = DB::table('instalacions')
            ->select('instalacions.sTipo_sucursal')
            ->where("instalacions.sCliente", "=", $request->clientes)
            ->where("instalacions.sDireccion", "=", $direccion)

            ->distinct()
            ->get();
        //Cargar Select Comuna
        $carga_selectComuna = DB::table('instalacions')
            ->select('instalacions.sComuna')
            ->orderBy('instalacions.sComuna', 'asc')
            ->where("instalacions.sCliente", "=", $request->clientes)
            ->where("instalacions.sRegion", "=", $region)
            ->distinct()
            ->get();

            $con_razonSocial= "no";
            $razonAgrupasa = DB::table('clientes')
            ->select('razon_social_agrupada')
            ->where('clientes.razon_social', '=', $cliente_seleccionado)
            ->get();


            if(count($razonAgrupasa ) >0){
              $con_razonSocial = $razonAgrupasa[0]->razon_social_agrupada;
            }else{
                $con_razonSocial= "no";
            
            }

        //obtener trabajadores asociados a checklist
        $tecnico = DB::table('asignacion_instalacions')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('trabajadors.estado', '=', '1')
            ->select('personas.nombre_uno', 'personas.apellido_uno', 'personas.id')
            ->orderBy('personas.nombre_uno', 'asc')
            /* ->where("personas.id","=",$id_persona)   */
            ->distinct()
            ->get();

        $cliente_id = DB::table('clientes')
            ->select('id')
            ->where('clientes.razon_social', '=', $request->clientes)
            ->get();
        $carga_selectProyecto = DB::table('instalacions')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->select('proyectos.id', 'proyectos.nombre')
            ->where("instalacions.sCliente", "=", $cliente_seleccionado)
            ->where('proyectos.id', '!=', 1)
            ->distinct()
            ->get();


        return view('Apiviews.api_instalacion', compact('con_razonSocial','proyectoseleccionado', 'carga_selectProyecto', 'direccion', 'sucursal', 'sc', 'serie', 'comuna', 'region', 'estado', 'id_persona', 'fecha', 'fecha2', 'carga_selectSucursal', 'direccionTemporal', 'cliente_seleccionado', 'instalaciones', 'carga_selectEstado', 'carga_selectClientes', 'carga_selectComuna', 'tecnico', 'carga_selectRegion'));
    }
    public function filtros_instalacion_buenoeditable(Request $request)
    {
        $fecha = Carbon::createFromDate($request->datepicker)->format('Y-m-d');
        $fecha2 = Carbon::createFromDate($request->datepicker2)->format('Y-m-d');

        $id_persona = $request->tecnicos;
        $estado = $request->estado;
        $clientes = $request->clientes;
        $comuna = $request->comuna;
        $serie = $request->serie;
        $sc = $request->sc;

        /*  $usuario_empresas = 0; */

        $users = DB::table('users')
            ->where('users.id', '=', Auth::user()->id)
            ->get();

        //FILTRO 1
        if (!empty($request->datepicker)) {
            //FILTRO 1 Y 2
            if (!empty($request->datepicker) && !empty($request->estado)) {

                $instalaciones =  DB::table('instalacions')
                    ->select(
                        'instalacions.id',
                        'instalacions.dFecha_instalacion',
                        'instalacions.fecha_registrado',
                        'instalacions.sEstado_despacho',
                        'instalacions.sCliente',
                        'instalacions.sComuna',
                        'instalacions.sSerie',
                        'instalacions.sDireccion'
                    )
                    /* ->whereDate('instalacions.dFecha_instalacion', '=', $fecha) */
                    ->whereDate('instalacions.fecha_registrado', '>=', $fecha)
                    ->whereDate('instalacions.fecha_registrado', '<=', $fecha2)
                    ->where('instalacions.sEstado_despacho', '=', $estado)
                    ->orderBy('instalacions.fecha_registrado', 'desc')
                    ->get();
            }
            //FILTRO 1, 3
            else if (!empty($request->datepicker) && !empty($request->clientes)) {

                $instalaciones =  DB::table('instalacions')
                    ->select('instalacions.id', 'instalacions.dFecha_instalacion', 'instalacions.fecha_registrado', 'instalacions.sEstado_despacho', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sDireccion', 'instalacions.sSerie')
                    /* ->whereDate('instalacions.dFecha_instalacion', '=', $fecha) */
                    ->whereDate('instalacions.fecha_registrado', '>=', $fecha)
                    ->whereDate('instalacions.fecha_registrado', '<=', $fecha2)
                    ->where('instalacions.sCliente', '=', $clientes)
                    ->orderBy('instalacions.fecha_registrado', 'desc')
                    ->get();
            } //FILTRO 1, 4
            else if (!empty($request->datepicker) && !empty($request->comuna)) {
                $instalaciones =  DB::table('instalacions')
                    ->select('instalacions.id', 'instalacions.dFecha_instalacion', 'instalacions.fecha_registrado', 'instalacions.sEstado_despacho', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sDireccion', 'instalacions.sSerie')
                    /* ->whereDate('instalacions.dFecha_instalacion', '=', $fecha) */
                    ->whereDate('instalacions.fecha_registrado', '>=', $fecha)
                    ->whereDate('instalacions.fecha_registrado', '<=', $fecha2)
                    ->where('instalacions.sComuna', '=', $comuna)
                    ->orderBy('instalacions.fecha_registrado', 'desc')
                    ->get();
            } //FILTRO 1, 5
            else if (!empty($request->datepicker) && !empty($request->serie)) {

                $instalaciones =  DB::table('instalacions')
                    ->select('instalacions.id', 'instalacions.dFecha_instalacion', 'instalacions.fecha_registrado', 'instalacions.sEstado_despacho', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sSerie')
                    /* ->whereDate('instalacions.dFecha_instalacion', '=', $fecha) */
                    ->whereDate('instalacions.fecha_registrado', '>=', $fecha)
                    ->whereDate('instalacions.fecha_registrado', '<=', $fecha2)
                    ->where('instalacions.sSerie', '=', $serie)
                    ->orderBy('instalacions.fecha_registrado', 'desc')
                    ->get();
            } //FILTRO 1, 6
            else if (!empty($request->datepicker) && !empty($request->sc)) {

                $instalaciones =  DB::table('instalacions')
                    ->select('instalacions.id', 'instalacions.dFecha_instalacion', 'instalacions.fecha_registrado', 'instalacions.sEstado_despacho', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sSerie')
                    /* ->whereDate('instalacions.dFecha_instalacion', '=', $fecha) */
                    ->whereDate('instalacions.fecha_registrado', '>=', $fecha)
                    ->whereDate('instalacions.fecha_registrado', '<=', $fecha2)
                    ->where('instalacions.sSc', '=', $sc)
                    ->orderBy('instalacions.fecha_registrado', 'desc')
                    ->get();
            } else {
                $instalaciones =  DB::table('instalacions')
                    ->select('instalacions.id', 'instalacions.dFecha_instalacion', 'instalacions.fecha_registrado', 'instalacions.sEstado_despacho', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sDireccion', 'instalacions.sSerie')
                    /* ->whereDate('instalacions.dFecha_instalacion', '=', $fecha) */
                    ->whereDate('instalacions.fecha_registrado', '>=', $fecha)
                    ->whereDate('instalacions.fecha_registrado', '<=', $fecha2)
                    ->orderBy('instalacions.fecha_registrado', 'desc')
                    ->where("instalacions.sEstado_despacho", "<>", "asignado")
                    ->get();
            }
        } else if (!empty($request->tecnicos)) {


            if (!empty($request->tecnicos) && !empty($request->datepicker)) {

                $instalaciones =  DB::table('personas')
                    ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
                    ->join('asignacion_instalacions', 'asignacion_instalacions.trabajadors_id', '=', 'trabajadors.id')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select('instalacions.id', 'instalacions.dFecha_instalacion', 'instalacions.fecha_registrado', 'instalacions.sEstado_despacho', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sDireccion', 'instalacions.sSerie')
                    ->orderBy('instalacions.fecha_registrado', 'desc')
                    ->whereDate('instalacions.fecha_registrado', '>=', $fecha)
                    ->whereDate('instalacions.fecha_registrado', '<=', $fecha2)
                    ->where("personas.id", "=", $id_persona)
                    ->get();
            } else if (!empty($request->tecnicos) && !empty($request->estado)) {

                $instalaciones =  DB::table('personas')
                    ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
                    ->join('asignacion_instalacions', 'asignacion_instalacions.trabajadors_id', '=', 'trabajadors.id')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select('instalacions.id', 'instalacions.dFecha_instalacion', 'instalacions.fecha_registrado', 'instalacions.sEstado_despacho', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sDireccion', 'instalacions.sSerie')
                    ->orderBy('instalacions.fecha_registrado', 'desc')
                    ->where("personas.id", "=", $id_persona)
                    ->where('instalacions.sEstado_despacho', '=', $estado)
                    ->get();
            }
            //FILTRO 1, 3
            else if (!empty($request->tecnicos) && !empty($request->clientes)) {

                $instalaciones =  DB::table('personas')
                    ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
                    ->join('asignacion_instalacions', 'asignacion_instalacions.trabajadors_id', '=', 'trabajadors.id')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select('instalacions.id', 'instalacions.dFecha_instalacion', 'instalacions.fecha_registrado', 'instalacions.sEstado_despacho', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sDireccion', 'instalacions.sSerie')
                    ->orderBy('instalacions.fecha_registrado', 'desc')
                    ->where("personas.id", "=", $id_persona)
                    ->where('instalacions.sCliente', '=', $clientes)
                    ->get();
            } //FILTRO 1, 4
            else if (!empty($request->tecnicos) && !empty($request->comuna)) {

                $instalaciones =  DB::table('personas')
                    ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
                    ->join('asignacion_instalacions', 'asignacion_instalacions.trabajadors_id', '=', 'trabajadors.id')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select('instalacions.id', 'instalacions.dFecha_instalacion', 'instalacions.fecha_registrado', 'instalacions.sEstado_despacho', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sDireccion', 'instalacions.sSerie')
                    ->orderBy('instalacions.fecha_registrado', 'desc')
                    ->where("personas.id", "=", $id_persona)
                    ->where('instalacions.sComuna', '=', $comuna)
                    ->get();
            } //FILTRO 1, 5
            else if (!empty($request->tecnicos) && !empty($request->serie)) {

                $instalaciones =  DB::table('personas')
                    ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
                    ->join('asignacion_instalacions', 'asignacion_instalacions.trabajadors_id', '=', 'trabajadors.id')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select('instalacions.id', 'instalacions.dFecha_instalacion', 'instalacions.fecha_registrado', 'instalacions.sEstado_despacho', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sDireccion', 'instalacions.sSerie')
                    ->orderBy('instalacions.fecha_registrado', 'desc')
                    ->where("personas.id", "=", $id_persona)
                    ->where('instalacions.sSerie', '=', $serie)
                    ->get();
            } //FILTRO 1, 6
            else if (!empty($request->tecnicos) && !empty($request->sc)) {


                $instalaciones =  DB::table('personas')
                    ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
                    ->join('asignacion_instalacions', 'asignacion_instalacions.trabajadors_id', '=', 'trabajadors.id')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select('instalacions.id', 'instalacions.dFecha_instalacion', 'instalacions.fecha_registrado', 'instalacions.sEstado_despacho', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sDireccion', 'instalacions.sSerie')
                    ->orderBy('instalacions.fecha_registrado', 'desc')
                    ->where("personas.id", "=", $id_persona)
                    ->where('instalacions.sSc', '=', $sc)
                    ->get();
            } else {
                $instalaciones =  DB::table('personas')
                    ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
                    ->join('asignacion_instalacions', 'asignacion_instalacions.trabajadors_id', '=', 'trabajadors.id')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select('instalacions.id', 'instalacions.dFecha_instalacion', 'instalacions.fecha_registrado', 'instalacions.sEstado_despacho', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sDireccion', 'instalacions.sSerie')
                    ->orderBy('instalacions.fecha_registrado', 'desc')
                    ->where("personas.id", "=", $id_persona)
                    ->get();
                /* $usuario_empresas = $id_persona; */
            }
        }
        //FILTRO 2
        else if (!empty($request->estado)) {
            //FILTRO 2 Y 3
            if (!empty($request->estado) && !empty($request->clientes)) {

                $instalaciones =  DB::table('instalacions')
                    ->select('instalacions.id', 'instalacions.dFecha_instalacion', 'instalacions.fecha_registrado', 'instalacions.sEstado_despacho', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sDireccion', 'instalacions.sSerie')
                    ->where('instalacions.sEstado_despacho', '=', $estado)
                    ->where('instalacions.sCliente', '=', $clientes)
                    ->orderBy('instalacions.fecha_registrado', 'desc')
                    ->get();
            }
            //FILTRO 2 Y 4
            else if (!empty($request->estado) && !empty($request->comuna)) {
                $instalaciones =  DB::table('instalacions')
                    ->select('instalacions.id', 'instalacions.dFecha_instalacion', 'instalacions.fecha_registrado', 'instalacions.sEstado_despacho', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sDireccion', 'instalacions.sSerie')
                    ->where('instalacions.sEstado_despacho', '=', $estado)
                    ->where('instalacions.sComuna', '=', $comuna)
                    ->orderBy('instalacions.fecha_registrado', 'desc')
                    ->get();
            }
            //FILTRO 2 Y 5
            else if (!empty($request->estado) && !empty($request->serie)) {
                $instalaciones =  DB::table('instalacions')
                    ->select('instalacions.id', 'instalacions.dFecha_instalacion', 'instalacions.fecha_registrado', 'instalacions.sEstado_despacho', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sDireccion', 'instalacions.sSerie')
                    ->where('instalacions.sEstado_despacho', '=', $estado)
                    ->where('instalacions.sSerie', '=', $serie)
                    ->orderBy('instalacions.fecha_registrado', 'desc')
                    ->get();
            }
            //FILTRO 2 Y 6
            else if (!empty($request->estado) && !empty($request->sc)) {
                $instalaciones =  DB::table('instalacions')
                    ->select('instalacions.id', 'instalacions.dFecha_instalacion', 'instalacions.fecha_registrado', 'instalacions.sEstado_despacho', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sDireccion', 'instalacions.sSerie')
                    ->where('instalacions.sEstado_despacho', '=', $estado)
                    ->where('instalacions.sSc', '=', $sc)
                    ->orderBy('instalacions.fecha_registrado', 'desc')
                    ->get();
            } else {
                $instalaciones =  DB::table('instalacions')
                    ->select('instalacions.id', 'instalacions.dFecha_instalacion', 'instalacions.fecha_registrado', 'instalacions.sEstado_despacho', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sDireccion', 'instalacions.sSerie')
                    ->where('instalacions.sEstado_despacho', '=', $estado)
                    ->orderBy('instalacions.fecha_registrado', 'desc')
                    ->get();
            }
        }
        //FILTRO 3
        else if (!empty($request->clientes)) {
            //FILTRO 3 y 4
            if (!empty($request->clientes) && !empty($request->comuna)) {

                $instalaciones =  DB::table('instalacions')
                    ->select('instalacions.id', 'instalacions.dFecha_instalacion', 'instalacions.fecha_registrado', 'instalacions.sEstado_despacho', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sDireccion', 'instalacions.sSerie')
                    ->where('instalacions.sCliente', '=', $clientes)
                    ->where('instalacions.sComuna', '=', $comuna)
                    ->orderBy('instalacions.fecha_registrado', 'desc')
                    ->get();
            }
            //FILTRO 3 Y 5
            else if (!empty($request->clientes) && !empty($request->serie)) {
                $instalaciones =  DB::table('instalacions')
                    ->select('instalacions.id', 'instalacions.dFecha_instalacion', 'instalacions.fecha_registrado', 'instalacions.sEstado_despacho', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sDireccion', 'instalacions.sSerie')
                    ->where('instalacions.sCliente', '=', $clientes)
                    ->where('instalacions.sSerie', '=', $serie)
                    ->orderBy('instalacions.fecha_registrado', 'desc')
                    ->get();
            }
            //FILTRO 3 Y 6
            else if (!empty($request->clientes) && !empty($request->sc)) {
                $instalaciones =  DB::table('instalacions')
                    ->select('instalacions.id', 'instalacions.dFecha_instalacion', 'instalacions.fecha_registrado', 'instalacions.sEstado_despacho', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sDireccion', 'instalacions.sSerie')
                    ->where('instalacions.sCliente', '=', $clientes)
                    ->where('instalacions.sSc', '=', $sc)
                    ->orderBy('instalacions.fecha_registrado', 'desc')
                    ->get();
            } else {
                $instalaciones =  DB::table('instalacions')
                    ->select('instalacions.id', 'instalacions.dFecha_instalacion', 'instalacions.fecha_registrado', 'instalacions.sEstado_despacho', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sDireccion', 'instalacions.sSerie')
                    ->where('instalacions.sCliente', '=', $clientes)
                    ->orderBy('instalacions.fecha_registrado', 'desc')
                    ->where("instalacions.sEstado_despacho", "<>", "asignado")

                    ->get();
            }
        }
        //FILTRO 4
        else if (!empty($request->comuna)) {
            //FILTRO 4 Y 5
            if (!empty($request->comuna) && !empty($request->serie)) {
                $instalaciones =  DB::table('instalacions')
                    ->select('instalacions.id', 'instalacions.dFecha_instalacion', 'instalacions.fecha_registrado', 'instalacions.sEstado_despacho', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sDireccion', 'instalacions.sSerie')
                    ->where('instalacions.sComuna', '=', $comuna)
                    ->where('instalacions.sSerie', '=', $serie)
                    ->orderBy('instalacions.fecha_registrado', 'desc')
                    ->get();
            }
            //FILTRO 4 Y 6
            else if (!empty($request->comuna) && !empty($request->sc)) {
                $instalaciones =  DB::table('instalacions')
                    ->select('instalacions.id', 'instalacions.dFecha_instalacion', 'instalacions.fecha_registrado', 'instalacions.sEstado_despacho', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sDireccion', 'instalacions.sSerie')
                    ->where('instalacions.sComuna', '=', $comuna)
                    ->where('instalacions.sSc', '=', $sc)
                    ->orderBy('instalacions.fecha_registrado', 'desc')
                    ->get();
            } else {
                $instalaciones =  DB::table('instalacions')
                    ->select('instalacions.id', 'instalacions.dFecha_instalacion', 'instalacions.fecha_registrado', 'instalacions.sEstado_despacho', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sDireccion', 'instalacions.sSerie')
                    ->where('instalacions.sComuna', '=', $request->comuna)
                    ->orderBy('instalacions.fecha_registrado', 'desc')
                    /* ->where("instalacions.sEstado_despacho","<>","asignado") */
                    ->get();
            }
        }
        //FILTRO 5
        else if (!empty($request->serie)) {
            //FILTRO 5 Y 6
            if (!empty($request->serie) && !empty($request->sc)) {
                $instalaciones =  DB::table('instalacions')
                    ->select('instalacions.id', 'instalacions.dFecha_instalacion', 'instalacions.fecha_registrado', 'instalacions.sEstado_despacho', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sDireccion', 'instalacions.sSerie')
                    ->where('instalacions.sSerie', '=', $serie)
                    ->where('instalacions.sSc', '=', $sc)
                    ->orderBy('instalacions.fecha_registrado', 'desc')
                    ->get();
            } else {
                $instalaciones =  DB::table('instalacions')
                    ->select('instalacions.id', 'instalacions.dFecha_instalacion', 'instalacions.fecha_registrado', 'instalacions.sEstado_despacho', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sDireccion', 'instalacions.sSerie')
                    ->where('instalacions.sSerie', '=', $serie)
                    ->orderBy('instalacions.fecha_registrado', 'desc')
                    /* ->where("instalacions.sEstado_despacho","<>","asignado") */
                    ->get();
            }
        }
        //FILTRO 6
        else if (!empty($request->sc)) {
            $instalaciones =  DB::table('instalacions')
                ->select('instalacions.id', 'instalacions.dFecha_instalacion', 'instalacions.fecha_registrado', 'instalacions.sEstado_despacho', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sDireccion', 'instalacions.sSerie')
                ->where('instalacions.sSc', '=', $sc)
                ->orderBy('instalacions.fecha_registrado', 'desc')
                ->get();
        } else {
            $instalaciones =  DB::table('instalacions')
                ->select('instalacions.id', 'instalacions.dFecha_instalacion', 'instalacions.fecha_registrado', 'instalacions.sEstado_despacho', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sDireccion', 'instalacions.sSerie')
                ->orderBy('instalacions.fecha_registrado', 'desc')
                /* ->where("instalacions.sEstado_despacho","<>","asignado") */
                ->get();
        }


        //Cargar Select Estado
        $carga_selectEstado = DB::table('instalacions')
            ->select('instalacions.sEstado_despacho')
            ->orderBy('instalacions.sEstado_despacho', 'asc')
            ->distinct()
            ->get();

        //Cargar Select Clientes
        $carga_selectClientes = DB::table('instalacions')
            ->select('instalacions.sCliente')
            ->orderBy('instalacions.sCliente', 'asc')
            ->distinct()
            ->get();

        //Cargar Select Comuna
        $carga_selectComuna = DB::table('instalacions')
            ->select('instalacions.sComuna')
            ->orderBy('instalacions.sComuna', 'asc')
            ->distinct()
            ->get();

        //obtener trabajadores asociados a checklist
        $tecnico = DB::table('asignacion_instalacions')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('trabajadors.estado', '=', '1')
            ->select('personas.nombre_uno', 'personas.apellido_uno', 'personas.id')
            ->orderBy('personas.nombre_uno', 'asc')
            /* ->where("personas.id","=",$id_persona)   */
            ->distinct()
            ->get();

        return view('Apiviews.api_instalacion', compact('instalaciones', 'carga_selectEstado', 'carga_selectClientes', 'carga_selectComuna', 'tecnico'));
    }
    //FIN FILTROS API INSTALACION

    public function ver_api_retiros(Request $request)
    {
        $retiros =  DB::table('retiros')
            ->join('tracker', 'tracker.id', '=', 'retiros.tracker_id')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->select('retiros.dFecharegistrado', 'retiros.instalador', 'retiros.id', 'retiros.sEstado', 'retiros.sCliente', 'retiros.sRegion', 'retiros.sComuna', 'retiros.sCui', 'retiros.sSerie', 'sDireccion', 'fecha_retiroCord', 'estado_retiro_Cord')
            ->orderBy('retiros.dFecharegistrado', 'desc')
            ->paginate(50);

        //Cargar Select Clientes
        $carga_selectClientes2 = DB::table('retiros')
            ->select('retiros.sCliente')
            ->distinct()
            ->get();

        //Cargar Select Region
        $carga_selectRegion = DB::table('retiros')
            ->select('retiros.sRegion')
            ->where('retiros.sRegion', '!=', null)
            ->orderByRaw(DB::raw("FIELD(retiros.sRegion,  1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17) ASC"))
            ->distinct()
            ->get();

        //Cargar Select Comuna
        $carga_selectComuna2 = DB::table('retiros')
            ->select('retiros.sComuna')
            ->distinct()
            ->orderBy('retiros.sComuna', 'asc')
            ->where('retiros.sComuna', '!=', null)
            ->get();

        //Cargar Select Estado
        $carga_selectEstado2 = DB::table('retiros')
            ->select('retiros.estado_retiro_Cord')
            ->orderBy('retiros.estado_retiro_Cord', 'asc')
            ->distinct()
            ->where("retiros.estado_retiro_Cord", "!=", null)
            ->get();

        //obtener trabajadores asociados a checklist
        $tecnico = DB::table('asignacion_retiros')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_retiros.trabajadors_idtecnico')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('trabajadors.estado', '=', '1')
            ->select('personas.nombre_uno', 'personas.apellido_uno', 'personas.id')
            ->orderBy('personas.nombre_uno', 'asc')
            ->distinct()
            ->get();

        //MODAL CREAR RETIRO TEMPORAL
        //SELECT TECNICO CREAR RETIRO TEMPORAL
        $tecnicoTemporal = DB::table('personas')
            ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
            ->join('users', 'users.id', '=', 'trabajadors.id_login')
            ->where('trabajadors.estado', '=', '1')
            ->where('users.tipo_usuario', '=', 'trabajador')
            ->select('personas.nombre_uno', 'personas.apellido_uno', 'personas.apellido_dos', 'trabajadors.id')
            ->orderBy('personas.nombre_uno', 'asc')
            ->get();
        //SELECT PROYECTO CREAR RETIRO TEMPORAL
        $proyectosTemporal = DB::table('proyectos')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->where('proyectos.estado', '=', '1')
            //->where('proyectos.id', '!=', '1')
            ->select('proyectos.nombre', 'clientes.razon_social', 'proyectos.id as id_proyecto', 'clientes.id as id_cliente')
            ->get();

        $clientesTemporal = DB::table('clientes')
            ->get();

        //SELECT DIRECCION CREAR RETIRO TEMPORAL
        $direccionTemporal = DB::table('retiros')
            ->select('retiros.sDireccion as descripcion_direccion')
            ->distinct()
            ->get();

        $id_persona = "";
        $estado = "";
        $clientes = "";
        $region = "";
        $comuna = "";
        $serie = "";
        $direccion = "";
        $fecha1 = "";

        return view('Apiviews.api_retiros', compact('clientesTemporal', 'id_persona', 'estado', 'clientes', 'region', 'comuna', 'serie', 'direccion', 'fecha1', 'tecnicoTemporal', 'direccionTemporal', 'proyectosTemporal', 'retiros', 'carga_selectEstado2', 'carga_selectClientes2', 'carga_selectComuna2', 'tecnico', 'carga_selectRegion'));
    }


    //FILTROS PARA API RETIROS
    public function filtros_retiro_masmas(Request $request)
    {
        $fecha = Carbon::createFromDate($request->fecha)->format('Y-m-d');

        $estado = $request->estado;
        $clientes = $request->clientes;
        $comuna = $request->comuna;
        $serie = $request->serie;
        $sc = $request->sc;




        //FILTRO 1
        if (!empty($request->fecha)) {


            //FILTRO 1 Y 2
            if (!empty($request->fecha) && !empty($request->estado)) {

                $retiros =  DB::table('retiros')
                    ->select('retiros.dFecharegistrado', 'retiros.id', 'retiros.sEstado', 'retiros.sCliente', 'retiros.sComuna', 'retiros.sSerie', 'sDireccion')
                    ->whereDate('retiros.dFecharegistrado', $fecha)
                    ->where('retiros.sEstado', '=', $estado)
                    ->orderBy('retiros.dFecharegistrado', 'desc')
                    ->paginate(7);
            }
            //FILTRO 1, 3
            else if (!empty($request->fecha) && !empty($request->clientes)) {

                $retiros =  DB::table('retiros')
                    ->select('retiros.dFecharegistrado', 'retiros.id', 'retiros.sEstado', 'retiros.sCliente', 'retiros.sComuna', 'retiros.sSerie', 'sDireccion')
                    ->whereDate('retiros.dFecharegistrado', $fecha)
                    ->where('retiros.sCliente', '=', $clientes)
                    ->orderBy('retiros.dFecharegistrado', 'desc')
                    ->paginate(7);
            } //FILTRO 1, 4
            else if (!empty($request->fecha) && !empty($request->comuna)) {

                $retiros =  DB::table('retiros')
                    ->select('retiros.dFecharegistrado', 'retiros.id', 'retiros.sEstado', 'retiros.sCliente', 'retiros.sComuna', 'retiros.sSerie', 'sDireccion')
                    ->whereDate('retiros.dFecharegistrado', $fecha)
                    ->where('retiros.sComuna', '=', $comuna)
                    ->orderBy('retiros.dFecharegistrado', 'desc')
                    ->paginate(7);
            } //FILTRO 1, 5
            else if (!empty($request->fecha) && !empty($request->serie)) {

                $retiros =  DB::table('retiros')
                    ->select('retiros.dFecharegistrado', 'retiros.id', 'retiros.sEstado', 'retiros.sCliente', 'retiros.sComuna', 'retiros.sSerie', 'sDireccion')
                    ->whereDate('retiros.dFecharegistrado', $fecha)
                    ->where('retiros.sSerie', '=', $serie)
                    ->orderBy('retiros.dFecharegistrado', 'desc')
                    ->paginate(7);
            } else {


                $retiros =  DB::table('retiros')
                    ->select('retiros.dFecharegistrado', 'retiros.id', 'retiros.sEstado', 'retiros.sCliente', 'retiros.sComuna', 'retiros.sSerie', 'sDireccion')
                    ->whereDate('retiros.dFecharegistrado', $fecha)
                    ->orderBy('retiros.dFecharegistrado', 'desc')
                    ->paginate(7);
                //   
            }
        }
        //FILTRO 2
        else if (!empty($request->estado)) {
            //FILTRO 2, 3
            if (!empty($request->estado) && !empty($request->clientes)) {

                $retiros =  DB::table('retiros')
                    ->select('retiros.dFecharegistrado', 'retiros.id', 'retiros.sEstado', 'retiros.sCliente', 'retiros.sComuna', 'retiros.sSerie', 'sDireccion')
                    ->where('retiros.sEstado', '=', $estado)
                    ->where('retiros.sCliente', '=', $clientes)
                    ->orderBy('retiros.dFecharegistrado', 'desc')
                    ->paginate(7);
            } //FILTRO 2, 4
            else if (!empty($request->estado) && !empty($request->comuna)) {

                $retiros =  DB::table('retiros')
                    ->select('retiros.dFecharegistrado', 'retiros.id', 'retiros.sEstado', 'retiros.sCliente', 'retiros.sComuna', 'retiros.sSerie', 'sDireccion')
                    ->where('retiros.sEstado', '=', $estado)
                    ->where('retiros.sComuna', '=', $comuna)
                    ->orderBy('retiros.dFecharegistrado', 'desc')
                    ->paginate(7);
            } //FILTRO 2, 5
            else if (!empty($request->estado) && !empty($request->serie)) {

                $retiros =  DB::table('retiros')
                    ->select('retiros.dFecharegistrado', 'retiros.id', 'retiros.sEstado', 'retiros.sCliente', 'retiros.sComuna', 'retiros.sSerie', 'sDireccion')
                    ->where('retiros.sEstado', '=', $estado)
                    ->where('retiros.sSerie', '=', $serie)
                    ->orderBy('retiros.dFecharegistrado', 'desc')
                    ->paginate(7);
            } else {
                $retiros =  DB::table('retiros')
                    ->select('retiros.dFecharegistrado', 'retiros.id', 'retiros.sEstado', 'retiros.sCliente', 'retiros.sComuna', 'retiros.sSerie', 'sDireccion')
                    ->where('retiros.sEstado', '=', $estado)
                    ->orderBy('retiros.dFecharegistrado', 'desc')
                    ->paginate(7);
            }
        }
        //FILTRO 3
        else if (!empty($request->clientes)) {
            //FILTRO 3, 4
            if (!empty($request->clientes) && !empty($request->comuna)) {

                $retiros =  DB::table('retiros')
                    ->select('retiros.dFecharegistrado', 'retiros.id', 'retiros.sEstado', 'retiros.sCliente', 'retiros.sComuna', 'retiros.sSerie', 'sDireccion')
                    ->where('retiros.sCliente', '=', $clientes)
                    ->where('retiros.sComuna', '=', $comuna)
                    ->orderBy('retiros.dFecharegistrado', 'desc')
                    ->paginate(7);
            } //FILTRO 3, 5
            else if (!empty($request->clientes) && !empty($request->serie)) {

                $retiros =  DB::table('retiros')
                    ->select('retiros.dFecharegistrado', 'retiros.id', 'retiros.sEstado', 'retiros.sCliente', 'retiros.sComuna', 'retiros.sSerie', 'sDireccion')
                    ->where('retiros.sCliente', '=', $clientes)
                    ->where('retiros.sSerie', '=', $serie)
                    ->orderBy('retiros.dFecharegistrado', 'desc')
                    ->paginate(7);
            } else {
                $retiros =  DB::table('retiros')
                    ->select('retiros.dFecharegistrado', 'retiros.id', 'retiros.sEstado', 'retiros.sCliente', 'retiros.sComuna', 'retiros.sSerie', 'sDireccion')
                    ->where('retiros.sCliente', '=', $clientes)
                    ->orderBy('retiros.dFecharegistrado', 'desc')
                    ->paginate(7);
            }
        }
        //FILTRO 4
        else if (!empty($request->comuna)) {
            //FILTRO 3, 5
            if (!empty($request->comuna) && !empty($request->serie)) {

                $retiros =  DB::table('retiros')
                    ->select('retiros.dFecharegistrado', 'retiros.id', 'retiros.sEstado', 'retiros.sCliente', 'retiros.sComuna', 'retiros.sSerie', 'sDireccion')
                    ->where('retiros.sComuna', '=', $comuna)
                    ->where('retiros.sSerie', '=', $serie)
                    ->orderBy('retiros.dFecharegistrado', 'desc')
                    ->paginate(7);
            } else {
                $retiros =  DB::table('retiros')
                    ->select('retiros.dFecharegistrado', 'retiros.id', 'retiros.sEstado', 'retiros.sCliente', 'retiros.sComuna', 'retiros.sSerie', 'sDireccion')
                    ->where('retiros.sComuna', '=', $comuna)
                    ->orderBy('retiros.dFecharegistrado', 'desc')
                    ->paginate(7);
            }
        }
        //FILTRO 5
        else if (!empty($request->serie)) {
            $retiros =  DB::table('retiros')
                ->select('retiros.dFecharegistrado', 'retiros.id', 'retiros.sEstado', 'retiros.sCliente', 'retiros.sComuna', 'retiros.sSerie', 'sDireccion')
                ->where('retiros.sSerie', '=', $serie)
                ->orderBy('retiros.dFecharegistrado', 'desc')
                ->paginate(7);
        } else {
            $retiros =  DB::table('retiros')
                ->select('retiros.dFecharegistrado', 'retiros.id', 'retiros.sEstado', 'retiros.sCliente', 'retiros.sComuna', 'retiros.sSerie', 'sDireccion')
                ->orderBy('retiros.dFecharegistrado', 'desc')
                ->paginate(7);
        }


        //Cargar Select Estado
        $carga_selectEstado2 = DB::table('retiros')
            ->select('retiros.sEstado')
            ->distinct()
            ->get();

        //Cargar Select Clientes
        $carga_selectClientes2 = DB::table('retiros')
            ->select('retiros.sCliente')
            ->distinct()
            ->get();

        //Cargar Select Comuna
        $carga_selectComuna2 = DB::table('retiros')
            ->select('retiros.sComuna')
            ->distinct()
            ->orderBy('retiros.sComuna', 'asc')
            ->where('retiros.sComuna', '!=', null)
            ->get();

        return view('Apiviews.api_retiros', compact('retiros', 'carga_selectEstado2', 'carga_selectClientes2', 'carga_selectComuna2'));
    }



    // /codigo de jerson
    function old2__informedatos(Request $request)
    {
        if ($request->proyecto == null) {
            return redirect('informes')->with('status', 'Por Favor Seleccione un proyecto');;
        } else {
            $fechaInicio = date($request->input("calendarioInicio"));
            $fechaFin = date($request->input("calendarioFin"));
            $proyectos = DB::table('proyectos')->select('proyectos.id', 'proyectos.nombre')
                ->where('proyectos.estado', '=', 1)
                ->where('proyectos.id', '!=', 1)
                ->orderBy('proyectos.id', 'asc')
                ->get();
            $nombres =  DB::table('proyectos')
                ->where('proyectos.estado', '=', 1)
                ->where('proyectos.id', '!=', 1)
                ->orderBy('proyectos.id', 'asc')
                ->get();
            $letra = $request->proyecto;
            //TOTAL PROYECTOS.
            $cantidad_equipo = DB::table('proyectos')->select('proyectos.cantidad_equipos')
                ->where('proyectos.estado', '=', 1)
                ->where('proyectos.id', '=', $letra)
                ->orderBy('proyectos.id', 'asc')
                ->get();

            //obtener datos de instalacion
            /*$instalacion = DB::table('instalacions')->select('instalacions.sEstado_instalacion')
            ->where('instalacions.sEstado_instalacion', '=', 'finalizado')
            ->where('instalacions.dFecha_instalacion', '>=', $fechaInicio, 'AND', '<=', $fechaFin)
            ->orderBy('instalacions.id', 'asc')
            ->get();*/
            //obtener datos de checklist_instalacion
            $checkList = DB::table('checklist_instalacions')->select('checklist_instalacions.estado_inicio')
                ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
                ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio, 'AND', 'checklist_instalacions.fecha_fin', '<=', $fechaFin)
                ->get();
            //total del checklist
            $contador_check = count($checkList);
            //total instalados finalizados
            //$contador_instalacion = count($instalacion);
            //$contador_instalacion = count($instalacion);

            $currentDateTime = date('Y-m-d');
            $instalaciontotal = DB::table('instalacions')->select('instalacions.id')
                ->where('instalacions.dFecha_instalacion', '>=', $fechaInicio, 'AND', '<=', $fechaFin)
                /*->where('instalacions.dFecha_instalacion','<=', $currentDateTime)*/
                ->orderBy('instalacions.id', 'asc')
                ->get();
            //total instalados total tabla
            $contador_instalacion_total = count($instalaciontotal);

            $totalproyecto =   $cantidad_equipo[0]->cantidad_equipos;
            //% Avance planificado
            $valor_instalacion = $contador_instalacion_total * 100 / $totalproyecto;
            //% Avance ejecutado
            // $ejecutadototal = $contador_instalacion * 100 / $totalproyecto;
            $ejecutadototal = $contador_check * 100 / $totalproyecto;
            //$desviacion = $contador_instalacion - $contador_instalacion_total;
            $desviacion = $contador_check - $contador_instalacion_total;
            $desviacion2 = $ejecutadototal - $valor_instalacion;
            $fechaConsultadaInicio = date('d-m-y', strtotime($fechaInicio));
            $fechaConsultadaFin = date('d-m-y', strtotime($fechaFin));

            //Reporte Tiempo de instalaciones
            //Extraer las fechas de inicio y finalizacion
            $checkListHora = DB::table('checklist_instalacions')->select('checklist_instalacions.fecha_inicio', 'checklist_instalacions.fecha_fin')
                ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
                ->whereNotNull('checklist_instalacions.fecha_inicio')
                ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio, 'AND', 'checklist_instalacions.fecha_fin', '<=', $fechaFin)
                ->get();
            //Crear Variable Auxiliar
            $totalDias = 0;
            $promedioM = 0;
            $promedioH = 0;
            if ($contador_check > 0) {
                //Sumar los minutos


                foreach ($checkListHora as $item) {
                    //Calcular la diferencia de minutos entre las fechas
                    $fecha = new Carbon($item->fecha_fin);
                    $totalDias += $fecha->diffInDays($item->fecha_inicio);
                }
                $totalHoras = $totalDias * 9;
                $totalMinutos = $totalHoras * 60;
                $promedioM = round($totalMinutos / $contador_check);
                $promedioH = round($totalHoras / $contador_check);
            }

            //Reporte Tiempo instalacion por sucursal
            $checkListSucursal = DB::table('checklist_instalacions')->select('checklist_instalacions.fecha_inicio', 'checklist_instalacions.fecha_fin', 'checklist_instalacions.Cscui')
                ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
                ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio, 'AND', 'checklist_instalacions.fecha_fin', '<=', $fechaFin)
                ->select(DB::raw("MIN(checklist_instalacions.fecha_inicio) AS fecha_inicio, MAX(checklist_instalacions.fecha_fin) AS fecha_fin, checklist_instalacions.Cscui"))
                ->groupBy('Cstipo_sucursal')
                ->get();
            //Devolver Datos a la vista
            return view('informes.informe', compact('proyectos', 'cantidad_equipo', 'contador_instalacion_total', 'valor_instalacion', 'contador_check', 'ejecutadototal', 'desviacion', 'desviacion2', 'fechaConsultadaInicio', 'fechaConsultadaFin', 'nombres', 'promedioM', 'promedioH', 'checkListSucursal'));
        }
    }
    public function filtros_retiro_ariel_07_1(Request $request)
    {


        $id_persona = $request->tecnicos;
        $estado = $request->estado;
        $clientes = $request->clientes;
        $region = $request->region;
        $comuna = $request->comuna;
        $serie = $request->serie;
        //$sc = $request->sc;  

        /*  $usuario_empresas = 0; */


        $where  = "retiros.estado_retiro_Cord != " . "'" . "estoesparapasarlosdemasparametros" . "'";
        /* $where  = ""; */


        if ($request->datepicker != "" && $request->datepicker2 != "") {
            $fecha = Carbon::createFromDate($request->datepicker)->format('Y-m-d');
            $fecha2 = Carbon::createFromDate($request->datepicker2)->format('Y-m-d');
            $where = $where . " and retiros.fecha_retiroCord" . " BETWEEN " . "'" . $fecha . "'" . " and " . "'" . $fecha2 . "'";
        }
        if ($estado != "") {

            if ($where == "") {
                $where = $where . " retiros.estado_retiro_Cord" . " = " . "'" . $estado . "'";
            } else {
                $where = $where . " and retiros.estado_retiro_Cord" . " = " . "'" . $estado . "'";
            }
        }
        if ($clientes != "") {

            if ($where == "") {
                $where = $where . " retiros.sCliente = " . "'" . $clientes . "'";
            } else {
                $where = $where . " and retiros.sCliente = " . "'" . $clientes . "'";
            }
        }
        if ($region != "") {

            if ($where == "") {
                $where = $where . "  retiros.sRegion  = " . "'" . $region . "'";
            } else {
                $where = $where . " and  retiros.sRegion  = " . "'" . $region . "'";
            }
        }
        if ($comuna != "") {

            if ($where == "") {
                $where = $where . "  retiros.sComuna  = " . "'" . $comuna . "'";
            } else {
                $where = $where . " and  retiros.sComuna  = " . "'" . $comuna . "'";
            }
        }

        if ($serie != "") {
            if ($where == "") {
                $where = $where . " retiros.sSerie  = " . "'" . $serie . "'";
            } else {
                $where = $where . " and  retiros.sSerie  = " . "'" . $serie . "'";
            }
        }
        // if($sc != ""){
        // $where = $where." and  retiros.sSC  = "."'".$sc."'";
        // }

        if ($id_persona != "") {


            $id_trabajador =  DB::table('trabajadors')
                ->select('trabajadors.id')
                ->where('trabajadors.id_persona', '=', $id_persona)
                ->get();

            $id_tra =  $id_trabajador[0]->id;

            /* $where = $where." and  asignacion_retiros.trabajadors_idtecnico  = "."'".$id_tra."'"; */

            if ($where == "") {
                $where = $where . "   asignacion_retiros.trabajadors_idtecnico  = " . "'" . $id_tra . "'";
            } else {
                $where = $where . " and  asignacion_retiros.trabajadors_idtecnico  = " . "'" . $id_tra . "'";
            }

            $retiros = DB::select('select retiros.sEstado, retiros.estado_retiro_Cord,retiros.fecha_retiroCord,retiros.id
    ,retiros.sCliente,retiros.sRegion,retiros.sComuna,retiros.sSerie,retiros.sCui,retiros.instalador,retiros.sDireccion from retiros inner join asignacion_retiros on retiros.id = asignacion_retiros.retiros_id   where ' . $where . " group by  retiros.sSerie order by retiros.fecha_retiroCord asc ");
        } else {

            $retiros = DB::select('select retiros.sEstado, retiros.estado_retiro_Cord,retiros.fecha_retiroCord,retiros.id,retiros.estado_retiro_Cord
    ,retiros.sCliente,retiros.sRegion,retiros.sComuna,retiros.sSerie,retiros.sCui,retiros.instalador,retiros.sDireccion from retiros where ' . $where . " group by  retiros.sSerie order by retiros.fecha_retiroCord asc ");
        }



        $retiros_mal =  DB::table('retiros')
            ->join('tracker', 'tracker.id', '=', 'retiros.tracker_id')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->select('retiros.dFecharegistrado', 'retiros.instalador', 'retiros.id', 'retiros.sEstado', 'retiros.sCliente', 'retiros.sRegion', 'retiros.sComuna', 'retiros.sCui', 'retiros.sSerie', 'sDireccion', 'fecha_retiroCord', 'estado_retiro_Cord')
            //->where('proyectos.id', '=', 1)
            ->orderBy('retiros.dFecharegistrado', 'desc')

            ->get();

        //Cargar Select Estado


        //Cargar Select Clientes
        $carga_selectClientes2 = DB::table('retiros')
            ->select('retiros.sCliente')
            ->distinct()
            ->get();

        //Cargar Select Region
        $carga_selectRegion = DB::table('retiros')
            ->select('retiros.sRegion')
            ->where('retiros.sRegion', '!=', null)
            ->orderBy('retiros.sRegion', 'asc')
            ->distinct()
            ->get();

        //Cargar Select Comuna
        $carga_selectComuna2 = DB::table('retiros')
            ->select('retiros.sComuna')
            ->orderBy('retiros.sComuna', 'asc')
            ->where('retiros.sComuna', '!=', null)
            ->distinct()
            ->get();



        //Cargar Select Estado
        $carga_selectEstado2 = DB::table('retiros')
            ->select('retiros.estado_retiro_Cord')
            ->orderBy('retiros.estado_retiro_Cord', 'asc')
            ->where("retiros.estado_retiro_Cord", "!=", null)
            ->distinct()
            ->get();



        //obtener trabajadores asociados a checklist
        $tecnico = DB::table('asignacion_retiros')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_retiros.trabajadors_idtecnico')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('trabajadors.estado', '=', '1')
            ->select('personas.nombre_uno', 'personas.apellido_uno', 'personas.id')
            ->orderBy('personas.nombre_uno', 'asc')
            /* ->where("personas.id","=",$id_persona)   */
            ->distinct()
            ->get();

        return view('Apiviews.api_retiros', compact('retiros', 'carga_selectEstado2', 'carga_selectClientes2', 'carga_selectComuna2', 'tecnico', 'carga_selectRegion'));
    }
    public function filtros_retiro(Request $request)
    {

        $id_persona = $request->tecnicos;
        $estado = $request->estado;
        $clientes = $request->clientes;
        $region = $request->region;
        $comuna = $request->comuna;
        $serie = $request->serie;
        $direccion = $request->direccion;

        $proveedores =  DB::table('users')
            ->select('nombre_proveedor')
            ->orderBy('nombre_proveedor', 'asc')

            ->where('nombre_proveedor', '!=', '')
            ->distinct()
            ->get();

        //$where  = "retiros.proveedor_retiro = "."'".$proveedor."' ";
        $where = "";
        $fecha1 = "";

        if ($request->fecha != "") {
            $fecha1 = Carbon::createFromDate($request->fecha)->format('Y-m-d');
            $where = $where . " retiros.fecha_retiroCord" . " = " . "'" . $fecha1 . "'";
        }
        if ($estado != "") {

            if ($where == "") {
                $where = $where . " retiros.estado_retiro_Cord" . " = " . "'" . $estado . "'";
            } else {
                $where = $where . " and retiros.estado_retiro_Cord" . " = " . "'" . $estado . "'";
            }
        }

        if ($direccion != "") {

            if ($where == "") {
                $where = $where . " retiros.sDireccion" . " = " . "'" . $direccion . "'";
            } else {
                $where = $where . " and retiros.sDireccion" . " = " . "'" . $direccion . "'";
            }
        }

        if ($clientes != "") {

            if ($where == "") {
                $where = $where . " retiros.sCliente = " . "'" . $clientes . "'";
            } else {
                $where = $where . " and retiros.sCliente = " . "'" . $clientes . "'";
            }
        }

        if ($region != "") {

            if ($where == "") {
                $where = $where . "  retiros.sRegion  = " . "'" . $region . "'";
            } else {
                $where = $where . " and  retiros.sRegion  = " . "'" . $region . "'";
            }
        }

        if ($comuna != "") {

            if ($where == "") {
                $where = $where . "  retiros.sComuna  = " . "'" . $comuna . "'";
            } else {
                $where = $where . " and  retiros.sComuna  = " . "'" . $comuna . "'";
            }
        }

        if ($serie != "") {
            if ($where == "") {
                $where = $where . " retiros.sSerie  = " . "'" . $serie . "'";
            } else {
                $where = $where . " and  retiros.sSerie  = " . "'" . $serie . "'";
            }
        }

        if ($id_persona != "") {

            $id_trabajador =  DB::table('trabajadors')
                ->select('trabajadors.id')
                ->where('trabajadors.id_persona', '=', $id_persona)
                ->get();

            $id_tra =  $id_trabajador[0]->id;

            /* $where = $where." and  asignacion_retiros.trabajadors_idtecnico  = "."'".$id_tra."'"; */

            if ($where == "") {
                $where = $where . "   asignacion_retiros.trabajadors_idtecnico  = " . "'" . $id_tra . "'";
            } else {
                $where = $where . " and  asignacion_retiros.trabajadors_idtecnico  = " . "'" . $id_tra . "'";
            }

            $retiros = DB::select('select retiros.sEstado, retiros.estado_retiro_Cord,retiros.fecha_retiroCord,retiros.id
        ,retiros.sCliente,retiros.sRegion,retiros.sComuna,retiros.sSerie,retiros.sCui,retiros.instalador,retiros.sDireccion 
        from retiros 
        inner join asignacion_retiros on retiros.id = asignacion_retiros.retiros_id 
        where ' . $where . " 
        order by retiros.dFecharegistrado desc ");
        } else {

            if ($id_persona == "" &&  $estado == "" &&  $clientes == "" &&  $region == ""   &&  $comuna == ""  && $serie == "" &&  $request->fecha == "" && $direccion == "") {

                /* $where  = "retiros.estado_retiro_Cord != "."'"."estoesparapasarlosdemasparametros"."'"; 
       $retiros = DB::select('select retiros.sEstado, retiros.estado_retiro_Cord,retiros.fecha_retiroCord,retiros.id,retiros.estado_retiro_Cord
        ,retiros.sCliente,retiros.sRegion,retiros.sComuna,retiros.sSerie,retiros.sCui,retiros.instalador,retiros.sDireccion from retiros where '.$where . " group by  retiros.sSerie order by retiros.fecha_retiroCord asc ");
         */
                $retiros =  DB::table('retiros')
                    ->join('tracker', 'tracker.id', '=', 'retiros.tracker_id')
                    ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
                    ->select('retiros.dFecharegistrado', 'retiros.instalador', 'retiros.id', 'retiros.sEstado', 'retiros.sCliente', 'retiros.sRegion', 'retiros.sComuna', 'retiros.sCui', 'retiros.sSerie', 'sDireccion', 'fecha_retiroCord', 'estado_retiro_Cord')
                    //->where('proyectos.id', '=', 1)
                    ->orderBy('retiros.dFecharegistrado', 'desc')
                    ->get();

                return redirect()->route('go.api_retiros');
            } else {

                $retiros = DB::select('select retiros.sEstado, retiros.estado_retiro_Cord,retiros.fecha_retiroCord,retiros.id,retiros.estado_retiro_Cord
        ,retiros.sCliente,retiros.sRegion,retiros.sComuna,retiros.sSerie,retiros.sCui,retiros.instalador,retiros.sDireccion from retiros where ' . $where . " group by  retiros.sSerie order by retiros.fecha_retiroCord asc ");
            }
        }





        $retiros_mal =  DB::table('retiros')
            ->join('tracker', 'tracker.id', '=', 'retiros.tracker_id')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->select('retiros.dFecharegistrado', 'retiros.instalador', 'retiros.id', 'retiros.sEstado', 'retiros.sCliente', 'retiros.sRegion', 'retiros.sComuna', 'retiros.sCui', 'retiros.sSerie', 'sDireccion', 'fecha_retiroCord', 'estado_retiro_Cord')
            //->where('proyectos.id', '=', 1)
            ->orderBy('retiros.dFecharegistrado', 'desc')
            ->get();




        //Cargar Select Clientes
        $carga_selectClientes2 = DB::table('retiros')
            ->select('retiros.sCliente')
            ->distinct()
            ->get();

        //Cargar Select Region
        $carga_selectRegion = DB::table('retiros')
            ->select('retiros.sRegion')
            ->where('retiros.sRegion', '!=', null)
            ->orderBy('retiros.sRegion', 'asc')
            ->distinct()
            ->get();

        //Cargar Select Comuna
        $carga_selectComuna2 = DB::table('retiros')
            ->select('retiros.sComuna')
            ->orderBy('retiros.sComuna', 'asc')
            ->where('retiros.sComuna', '!=', null)
            ->where('retiros.sRegion', '=', $region)
            ->distinct()
            ->get();

        //Cargar Select direccion
        $direccionTemporal = DB::table('retiros')
            ->select('retiros.sDireccion as descripcion_direccion')
            ->where('retiros.sComuna', '=', $comuna)
            ->distinct()
            ->get();

        //Cargar Select Estado
        $carga_selectEstado2 = DB::table('retiros')
            ->select('retiros.estado_retiro_Cord')
            ->where('retiros.estado_retiro_Cord', '!=', null)
            ->orderBy('retiros.estado_retiro_Cord', 'asc')
            ->distinct()
            ->get();



        //obtener trabajadores asociados a checklist
        $tecnico = DB::table('asignacion_retiros')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_retiros.trabajadors_idtecnico')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('trabajadors.estado', '=', '1')
            ->select('personas.nombre_uno', 'personas.apellido_uno', 'personas.id')
            ->orderBy('personas.nombre_uno', 'asc')
            /* ->where("personas.id","=",$id_persona)   */
            ->distinct()
            ->get();

        $clientesTemporal = DB::table('clientes')
            ->get();


        return view('Apiviews.api_retiros', compact('clientesTemporal', 'proveedores', 'id_persona', 'estado', 'clientes', 'region', 'comuna', 'serie', 'direccion', 'fecha1', 'retiros', 'carga_selectEstado2', 'carga_selectClientes2', 'carga_selectComuna2', 'tecnico', 'carga_selectRegion', 'direccionTemporal'));
    }
    public function ir_historial_capacitacion()
    {
        // $databases = $this->nombre_database();
        $databases = App\bd_proveedores::selectDB();

        $cont = count($databases);
        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();
        $id_user = $datos_trabajador[0]->id;
        foreach ($databases as $los_datos) {
            $capas[] =  DB::connection(strtolower($los_datos->Database))->table('asignacion_capacitaciones')
                ->join('capacitacions', 'capacitacions.id', '=', 'asignacion_capacitaciones.id_capa')
                ->select(
                    'asignacion_capacitaciones.id',
                    'asignacion_capacitaciones.id_trabajador',
                    'asignacion_capacitaciones.fecha_capacitacion',
                    'asignacion_capacitaciones.cui',
                    'asignacion_capacitaciones.cliente',
                    'asignacion_capacitaciones.comuna',
                    'asignacion_capacitaciones.direccion',
                    'asignacion_capacitaciones.estado_capa',
                    'capacitacions.nombre_proveedor'
                )
                ->where('asignacion_capacitaciones.id_trabajador', '=', $id_user)
                ->where("asignacion_capacitaciones.estado_capa", "<>", "Finalizado")
                ->get();
        }
        return view('check.historial_capacitacion', compact('capas', 'cont'));
    }



    public function old_ir_resumen_retiros()
    {
        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();

        $id_trabajador = $datos_trabajador[0]->id;
        $id_persona = $datos_trabajador[0]->id_persona;

        $datos_tecnico = DB::table('personas')
            ->where('personas.id', '=', $id_persona)

            ->select(
                'personas.nombre_uno',
                'personas.nombre_dos',
                'personas.apellido_uno',
                'personas.apellido_dos'
            )

            ->get();

        $proyectos = DB::table('proyectos')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->where('proyectos.estado', '=', '1')
            ->where('proyectos.id', '!=', '1')
            ->select('proyectos.nombre', 'clientes.razon_social', 'proyectos.id as id_proyecto')
            ->get();

        $fecha = Carbon::today();

        $datos_checklist = DB::table('checklist_retiros')
            ->join('asignacion_retiros', 'asignacion_retiros.id', '=', 'checklist_retiros.asignacion_retiros_id')
            ->select(

                'checklist_retiros.csSerie',
                'checklist_retiros.csModelo',
                'checklist_retiros.cnContador_color',
                'checklist_retiros.cnContador',
                'asignacion_retiros.fecha_termino'
            )
            ->whereDate('asignacion_retiros.fecha_termino', '=', $fecha)
            ->where('asignacion_retiros.estado_asignacion', '=', 'finalizado')
            ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->get();

        return view('check.resumen_retiros', compact('datos_tecnico', 'datos_checklist', 'proyectos'));
    }

    public function verdatosresumenretiro()
    {

        try {
            $idcapa = $_GET['check'];
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }

        $datoscapa = DB::table('resumen_retiros')
            ->where('resumen_retiros.id', '=', $idcapa)
            ->get();

        /**/
        $datos_proyecto = DB::table('proyectos')
            ->where('proyectos.id', '=', $datoscapa[0]->proyecto_id)
            ->get();

        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();

        $id_trabajador = $datos_trabajador[0]->id;
        $id_persona = $datos_trabajador[0]->id_persona;

        $datos_tecnico = DB::table('personas')
            ->where('personas.id', '=', $id_persona)

            ->select(
                'personas.nombre_uno',
                'personas.nombre_dos',
                'personas.apellido_uno',
                'personas.apellido_dos'
            )

            ->get();

        $fecha = $datoscapa[0]->fecha_resumen;



        $datos_checklist = DB::table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->select(
                'checklist_retiros.id',
                'checklist_retiros.csSerie',
                'checklist_retiros.csModelo',
                'checklist_retiros.cnContador_color',
                'checklist_retiros.cnContador',
                'asignacion_retiros.fecha_termino'
            )
            ->where('asignacion_retiros.estado_asignacion', '=', 'finalizado')
            ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->whereDate('asignacion_retiros.fecha_termino', '=', $fecha)
            ->get();


        return view('check.verdetalleretiros', compact('datos_tecnico', 'datoscapa', 'datos_proyecto', 'datos_checklist'));
    }

    public function verdatosresumenretiro_coordinadora()
    {

        try {
            $idcapa = $_GET['check'];
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }

        $datoscapa = DB::table('resumen_retiros')
            ->where('resumen_retiros.id', '=', $idcapa)
            ->get();

        /**/
        $datos_proyecto = DB::table('proyectos')
            ->where('proyectos.id', '=', $datoscapa[0]->proyecto_id)
            ->get();

        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();

        $id_trabajador = $datos_trabajador[0]->id;
        $id_persona = $datos_trabajador[0]->id_persona;

        $datos_tecnico = DB::table('personas')
            ->where('personas.id', '=', $id_persona)

            ->select(
                'personas.nombre_uno',
                'personas.nombre_dos',
                'personas.apellido_uno',
                'personas.apellido_dos'
            )

            ->get();

        $fecha = $datoscapa[0]->fecha_resumen;



        $datos_checklist = DB::table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->select(
                'checklist_retiros.id',
                'checklist_retiros.csSerie',
                'checklist_retiros.csModelo',
                'checklist_retiros.cnContador_color',
                'checklist_retiros.cnContador',
                'asignacion_retiros.fecha_termino'
            )
            ->where('asignacion_retiros.estado_asignacion', '=', 'finalizado')
            ->whereDate('asignacion_retiros.fecha_termino', '=', $fecha)
            ->get();


        return view('check.verdetalleretiro_cordinadora', compact('datos_tecnico', 'datoscapa', 'datos_proyecto', 'datos_checklist'));
    }





    public function ir_resumen_retiros()
    {
        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();

        $id_trabajador = $datos_trabajador[0]->id;
        $id_persona = $datos_trabajador[0]->id_persona;

        $datos_tecnico = DB::table('personas')
            ->where('personas.id', '=', $id_persona)

            ->select(
                'personas.nombre_uno',
                'personas.nombre_dos',
                'personas.apellido_uno',
                'personas.apellido_dos'
            )

            ->get();

        $proyectos = DB::table('proyectos')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->where('proyectos.estado', '=', '1')
            ->where('proyectos.id', '!=', '1')
            ->select('proyectos.nombre', 'clientes.razon_social', 'proyectos.id as id_proyecto')
            ->get();

        $fecha = Carbon::today();

        $datos_checklist = DB::table('checklist_retiros')
            ->join('asignacion_retiros', 'asignacion_retiros.id', '=', 'checklist_retiros.asignacion_retiros_id')
            ->select(

                'checklist_retiros.csSerie',
                'checklist_retiros.csModelo',
                'checklist_retiros.cnContador_color',
                'checklist_retiros.cnContador',
                'asignacion_retiros.fecha_termino'
            )
            ->whereDate('asignacion_retiros.fecha_termino', '=', $fecha)
            ->where('asignacion_retiros.estado_asignacion', '=', 'finalizado')
            ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->get();


        return view('check.resumen_retiros', compact('datos_tecnico', 'proyectos', 'datos_checklist'));
    }
    public function ir_historial_resumen_retiros()
    {
        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();

        $id_trabajador = $datos_trabajador[0]->id;
        $id_persona = $datos_trabajador[0]->id_persona;

        $datos_tecnico = DB::table('personas')
            ->where('personas.id', '=', $id_persona)

            ->select(
                'personas.nombre_uno',
                'personas.nombre_dos',
                'personas.apellido_uno',
                'personas.apellido_dos'
            )

            ->get();

        $datosretiro = DB::table('resumen_retiros')
            ->select(
                'resumen_retiros.id',
                'resumen_retiros.fecha_resumen',
                'resumen_retiros.cantidad_bultos',
                'resumen_retiros.suma_embalados',
                'resumen_retiros.suma_sinembalar',
                'resumen_retiros.cliente',
                'resumen_retiros.comuna',
                'resumen_retiros.cuisucursal'
            )
            ->orderBy('resumen_retiros.fecha_resumen', 'DESC')

            ->paginate(6);


        return view('check.historial_resumen_retiros', compact('datosretiro', 'datos_tecnico'));
    }
    public function ir_historial_resumen_retiros_coordinadora()
    {


        $datosretiro = DB::table('resumen_retiros')
            ->select(
                'resumen_retiros.id',
                'resumen_retiros.fecha_resumen',
                'resumen_retiros.cantidad_bultos',
                'resumen_retiros.suma_embalados',
                'resumen_retiros.suma_sinembalar',
                'resumen_retiros.cliente',
                'resumen_retiros.comuna',
                'resumen_retiros.cuisucursal',
                'resumen_retiros.url_pdf',
                'resumen_retiros.direccion',
                'resumen_retiros.descripcion_motivo'
            )
            ->orderBy('resumen_retiros.id', 'DESC')
            ->get();

        //Cargar Select Clientes
        $carga_selectCliente = DB::table('resumen_retiros')
            ->join('proyectos', 'proyectos.id', '=', 'resumen_retiros.proyectos_id')
            ->select('proyectos.nombre', 'proyectos.id')
            ->distinct()
            ->get();

        //Cargas Select Comuna
        $carga_selectComuna = DB::table('resumen_retiros')
            ->select('resumen_retiros.comuna')
            ->get();

        //Cargar Select Direccion
        $carga_selectDireccion = DB::table('resumen_retiros')
            ->select('resumen_retiros.direccion')
            ->get();

        //Cargar Select Sucursal
        $carga_selectSucursal = DB::table('resumen_retiros')
            ->select('resumen_retiros.cuisucursal')
            ->get();

        $id_persona = "";
        $estado = "";
        $clientes = "";
        $fecha1 = "";
        $serie = "";
        $comuna = "";
        $direccion = "";
        $region = "";
        $cuisucursal = "";
        $comuna = "";
        $clientes = "";

        return view('check.historial_retiro_coordinadora', compact('cuisucursal', 'direccion', 'comuna', 'clientes', 'id_persona', 'estado', 'clientes', 'region', 'comuna', 'serie', 'direccion', 'fecha1', 'datosretiro', 'carga_selectCliente', 'carga_selectComuna', 'carga_selectDireccion', 'carga_selectSucursal'));
    }


    function informedatos_old3(Request $request)
    {

        //Preguntar si se selecciono un proyecto
        if ($request->proyecto == null) {
            return redirect('informes')->with('status', 'Por Favor Seleccione un proyecto');;
        } else {
            //Obtener las fechas ingresadas en el calendario
            $fechaInicio = date($request->input("calendarioInicio"));
            $fechaFin = date($request->input("calendarioFin"));
            $idproyectoPDF = $request->input("proyecto");
            //Extraer los proyectos de ls bd
            $proyectos = DB::table('proyectos')->select('proyectos.id', 'proyectos.nombre')
                ->where('proyectos.estado', '=', 1)
                ->where('proyectos.id', '!=', 1)
                ->orderBy('proyectos.id', 'asc')
                ->get();
            $nombres =  DB::table('proyectos')
                ->where('proyectos.estado', '=', 1)
                ->where('proyectos.id', '!=', 1)
                ->orderBy('proyectos.id', 'asc')
                ->get();
            $letra = $request->proyecto;

            //TOTAL PROYECTOS.
            $cantidad_equipo = DB::table('proyectos')->select('proyectos.cantidad_equipos')
                ->where('proyectos.estado', '=', 1)
                ->where('proyectos.id', '=', $letra)
                ->orderBy('proyectos.id', 'asc')
                ->get();

            //extraer los datos de la tabla checklist
            $checkList = DB::table('checklist_instalacions')->select('checklist_instalacions.estado_inicio')
                ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
                ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio, 'AND', 'checklist_instalacions.fecha_fin', '<=', $fechaFin)
                ->get();
            //total del checklist
            $contador_check = count($checkList);


            //extraer los datos de la tabla instalacion
            $instalaciontotal = DB::table('instalacions')->select('instalacions.id')
                ->where('instalacions.dFecha_instalacion', '>=', $fechaInicio, 'AND', '<=', $fechaFin)
                /*->where('instalacions.dFecha_instalacion','<=', $currentDateTime)*/
                ->orderBy('instalacions.id', 'asc')
                ->get();

            //total instalados total tabla
            $contador_instalacion_total = count($instalaciontotal);

            $totalproyecto =   $cantidad_equipo[0]->cantidad_equipos;
            //% Avance planificado
            $valor_instalacion = $contador_instalacion_total * 100 / $totalproyecto;
            //% Avance ejecutado
            // $ejecutadototal = $contador_instalacion * 100 / $totalproyecto;
            $ejecutadototal = $contador_check * 100 / $totalproyecto;
            //$desviacion = $contador_instalacion - $contador_instalacion_total;
            $desviacion = $contador_check - $contador_instalacion_total;
            $desviacion2 = $ejecutadototal - $valor_instalacion;
            $fechaConsultadaInicio = date('d-m-y', strtotime($fechaInicio));
            $fechaConsultadaFin = date('d-m-y', strtotime($fechaFin));

            //--------------- Reporte Tiempo de instalaciones ------
            //Extraer las fechas de inicio y finalizacion de la tabla checklist
            $checkListHora = DB::table('checklist_instalacions')->select('checklist_instalacions.fecha_inicio', 'checklist_instalacions.fecha_fin')
                ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
                ->whereNotNull('checklist_instalacions.fecha_inicio')
                ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio, 'AND', 'checklist_instalacions.fecha_fin', '<=', $fechaFin)
                ->get();
            //Crear Variable Auxiliar
            $totalDias = 0;
            $promedioM = 0;
            $promedioH = 0;
            $ContadorFinSemana = 0;
            $contador = 0;
            $totalH = 0;
            if ($contador_check > 0) {
                //Buscar en el rango fechaInicio/fechaFin si hay fines de semana
                foreach ($checkListHora as $item) {
                    $begin = new DateTime($item->fecha_inicio);
                    $end = new DateTime($item->fecha_fin);
                    $end = $end->modify('+1 day');
                    $interval = new DateInterval('P1D');
                    $daterange = new DatePeriod($begin, $interval, $end);

                    foreach ($daterange as $date) {
                        //Si hay fines de semana se suman 24 horas al contador
                        if (date('l', strtotime($date->format("d-m-Y"))) == 'Sunday' || date('l', strtotime($date->format("d-m-Y"))) == 'Saturday') {
                            $ContadorFinSemana += 24;
                        }
                    }
                    //se calcula la diferencia entre las 2 fechas
                    $fecha = new Carbon($item->fecha_inicio);
                    //Al total de horas se le restan las horas correspondientes a fines de semana 
                    $contador = round($fecha->diffInMinutes($item->fecha_fin) / 60) - $ContadorFinSemana;
                    if ($contador < 0) {
                        $contador *= -1;
                    }
                    while ($contador != 0) {
                        //Si el total de horas es mayor a 9 significa que se trabajo mas de un dia
                        //Se suman 9 horas al total de horas de trabajo
                        //Y se le restan las 24 horas al contador de horas para eliminar el dia que ya paso
                        if ($contador >= 9) {
                            $totalH += 9;
                            $contador -= 24;
                        } else {
                            $totalH += $contador;
                            $contador = 0;
                        }
                    }

                    //Calcular la diferencia de minutos entre las fechas
                    $fecha = new Carbon($item->fecha_fin);
                    $totalDias += $fecha->diffInDays($item->fecha_inicio);
                    $ContadorFinSemana = 0;
                    $contador = 0;
                }
                $totalHoras = $totalH;
                $totalMinutos = $totalH * 60;
                //Calcular los promedios
                $promedioM = round($totalMinutos / $contador_check);
                $promedioH = round($totalHoras / $contador_check);
            }

            //Reporte Tiempo instalacion por sucursal
            $checkListSucursal = DB::table('checklist_instalacions')->select('checklist_instalacions.fecha_inicio', 'checklist_instalacions.fecha_fin', 'checklist_instalacions.Cscui')
                ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
                ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio, 'AND', 'checklist_instalacions.fecha_fin', '<=', $fechaFin)
                ->select(DB::raw("MIN(checklist_instalacions.fecha_inicio) AS fecha_inicio, MAX(checklist_instalacions.fecha_fin) AS fecha_fin, checklist_instalacions.Cscui"))
                ->groupBy('Cstipo_sucursal')
                ->get();


            //Reporte Tasa de efectividad
            //Extraer los datos de la tabla asignacion_instalacions
            $asignacionInstalacion = DB::table('asignacion_instalacions')->select('asignacion_instalacions.numero_visita')
                ->where('asignacion_instalacions.estado_asignacion', '=', 'finalizado')
                ->where('asignacion_instalacions.fecha_instalacion', '>=', $fechaInicio, 'AND', 'asignacion_instalacions.fecha_instalacion', '<=', $fechaFin)
                ->get();

            //Crear las variables
            //Obtener total de visitas
            $totalAsignacion = count($asignacionInstalacion);
            //Contar las instalaciones exitosas en la primera visita
            $contadorPrimeravisita = 0;
            foreach ($asignacionInstalacion as $item) {
                if ($item->numero_visita == 1) {
                    $contadorPrimeravisita += 1;
                }
            }
            //Obtener el porcentaje de efectividad
            $tasaDeInstalacion = round(($contadorPrimeravisita * 100) / $totalAsignacion);

            //--------------------- Reporte de Status de proyecto por region ---------------
            //Obtener nombre de las regiones
            $reporteRegion = DB::table('instalacions')->select('instalacions.sRegion')
                ->orderBy('instalacions.sRegion')
                ->distinct('instalacions.sRegion')
                ->get();
            //Obtener nombre de las regiones y el estado de la instalacion
            $reporteRegionAux = DB::table('instalacions')->select('instalacions.sRegion', 'instalacions.sEstado_instalacion')
                ->orderBy('instalacions.sRegion')
                ->get();

            //----------------------- Reporte Accesorios ------------------------------------ 
            //Obtener datos de la tabla instalacions
            $reporteAccesorios = DB::table('instalacions')->select(
                'instalacions.sBandeja_adicional',
                'instalacions.sMueble',
                'instalacions.sSD',
                'instalacions.sCable_poder',
                'instalacions.sCable_red',
                'instalacions.sKit_lector'
            )
                ->get();

            //Contar los accesorios solicitados
            $contadorInstalacionSi = 0;
            foreach ($reporteAccesorios as $item) {
                if ($item->sBandeja_adicional == 'si' || $item->sBandeja_adicional == 'Si') {
                    $contadorInstalacionSi += 1;
                }
                if ($item->sMueble == 'si' || $item->sMueble == 'Si') {
                    $contadorInstalacionSi += 1;
                }
                if ($item->sSD == 'si' || $item->sSD == 'Si') {
                    $contadorInstalacionSi += 1;
                }
                if ($item->sCable_poder == 'si' || $item->sCable_poder == 'Si') {
                    $contadorInstalacionSi += 1;
                }
                if ($item->sCable_red == 'si' || $item->sCable_red == 'Si') {
                    $contadorInstalacionSi += 1;
                }
                if ($item->sKit_lector == 'si' || $item->sKit_lector == 'Si') {
                    $contadorInstalacionSi += 1;
                }
            }

            //Obtener datos tabla checklist
            $checklistAccesorios = $checkListHora = DB::table('checklist_instalacions')->select(
                'checklist_instalacions.CsBandeja_adicional',
                'checklist_instalacions.CsMueble',
                'checklist_instalacions.CsSD',
                'checklist_instalacions.CsCable_poder',
                'checklist_instalacions.CsCable_red',
                'checklist_instalacions.CsKit_lector'
            )
                ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
                ->whereNotNull('checklist_instalacions.fecha_inicio')
                ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio, 'AND', 'checklist_instalacions.fecha_fin', '<=', $fechaFin)
                ->get();

            //Contar los accesorios solicitados
            $contadorCheckSi = 0;

            foreach ($checklistAccesorios as $item) {
                if ($item->CsBandeja_adicional == 'si' || $item->CsBandeja_adicional == 'Si') {
                    $contadorCheckSi += 1;
                }
                if ($item->CsMueble == 'si' || $item->CsMueble == 'Si') {
                    $contadorCheckSi += 1;
                }
                if ($item->CsSD == 'si' || $item->CsSD == 'Si') {
                    $contadorCheckSi += 1;
                }
                if ($item->CsCable_poder == 'si' || $item->CsCable_poder == 'Si') {
                    $contadorCheckSi += 1;
                }
                if ($item->CsCable_red == 'si' || $item->CsCable_red == 'Si') {
                    $contadorCheckSi += 1;
                }
                if ($item->CsKit_lector == 'si' || $item->CsKit_lector == 'Si') {
                    $contadorCheckSi += 1;
                }
            }

            $accesoriosPorcentaje = round(($contadorCheckSi * 100) / $contadorInstalacionSi);
            $accesoriosPorcentaje = round(($contadorCheckSi * 100) / $contadorInstalacionSi);


            //Devolver Datos a la vista
            return view('informes.informe', compact(
                'proyectos',
                'cantidad_equipo',
                'contador_instalacion_total',
                'valor_instalacion',
                'contador_check',
                'ejecutadototal',
                'desviacion',
                'desviacion2',
                'fechaConsultadaInicio',
                'fechaConsultadaFin',
                'nombres',
                'promedioM',
                'promedioH',
                'checkListSucursal',
                'totalAsignacion',
                'contadorPrimeravisita',
                'tasaDeInstalacion',
                'reporteRegion',
                'reporteRegionAux',
                'contadorCheckSi',
                'contadorInstalacionSi',
                'accesoriosPorcentaje',
                'letra'
            ));
        }
    }

    function informedatosPDF(Request $request)
    {

        //Obtener las fechas ingresadas en el calendario
        $fechaInicio = date('Y-m-d', strtotime($request->input("fecha1pdf"))) . " 00:00:00";
        $fechaFin = date('Y-m-d', strtotime($request->input("fecha2pdf"))) . " 23:59:59";

        $validacion = 1;
        $letra = $request->input("idproyecto");

        //Extraer los proyectos de la bd
        $proyectos = DB::table('proyectos')->select('proyectos.id', 'proyectos.nombre')
            ->where('proyectos.estado', '=', 1)
            ->where('proyectos.id', '!=', 1)
            ->orderBy('proyectos.id', 'asc')
            ->get();
        $nombres =  DB::table('proyectos')
            ->where('proyectos.estado', '=', 1)
            ->where('proyectos.id', '=', $letra)
            ->orderBy('proyectos.id', 'asc')
            ->get();


        //TOTAL PROYECTOS.
        $cantidad_equipo = DB::table('proyectos')->select('proyectos.cantidad_equipos')
            ->where('proyectos.estado', '=', 1)
            ->where('proyectos.id', '=', $letra)
            ->orderBy('proyectos.id', 'asc')
            ->get();

        //extraer los datos de la tabla checklist
        $checkList = DB::table('checklist_instalacions')->select('checklist_instalacions.estado_inicio')
            ->join('asignacion_instalacions', 'asignacion_instalacions.id', '=', 'checklist_instalacions.asignacion_instalacion_retiro_id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->where('proyectos.id', '=', $letra)
            ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
            ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio, 'AND', 'checklist_instalacions.fecha_fin', '<=', $fechaFin)
            ->get();
        //total del checklist
        $contador_check = count($checkList);


        //extraer los datos de la tabla instalacion
        $instalaciontotal = DB::table('instalacions')->select('instalacions.id')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->where('proyectos.id', '=', $letra)
            ->where('instalacions.dFecha_instalacion', '>=', $fechaInicio, 'AND', '<=', $fechaFin)
            ->orderBy('instalacions.id', 'asc')
            ->get();

        //total instalados total tabla
        $contador_instalacion_total = count($instalaciontotal);
        $totalproyecto =   $cantidad_equipo[0]->cantidad_equipos;
        //% Avance planificado
        $valor_instalacion = $contador_instalacion_total * 100 / $totalproyecto;
        //% Avance ejecutado

        // $ejecutadototal = $contador_instalacion * 100 / $totalproyecto;
        $ejecutadototal = $contador_check * 100 / $totalproyecto;
        //$desviacion = $contador_instalacion - $contador_instalacion_total;
        $desviacion = $contador_check - $contador_instalacion_total;
        $desviacion2 = $ejecutadototal - $valor_instalacion;

        $fechaConsultadaInicio = date('d-m-y', strtotime($fechaInicio));
        $fechaConsultadaFin = date('d-m-y', strtotime($fechaFin));

        //--------------- Reporte Tiempo de instalaciones ------
        //Extraer las fechas de inicio y finalizacion de la tabla checklist
        $checkListHora = DB::table('checklist_instalacions')->select('checklist_instalacions.fecha_inicio', 'checklist_instalacions.fecha_fin')
            ->join('asignacion_instalacions', 'asignacion_instalacions.id', '=', 'checklist_instalacions.asignacion_instalacion_retiro_id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->where('proyectos.id', '=', $letra)
            ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
            ->whereNotNull('checklist_instalacions.fecha_inicio')
            ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio, 'AND', 'checklist_instalacions.fecha_fin', '<=', $fechaFin)
            ->get();
        //Crear Variable Auxiliar
        $totalDias = 0;
        $promedioM = 0;
        $promedioH = 0;
        $ContadorFinSemana = 0;
        $contador = 0;
        $totalH = 0;
        if ($contador_check > 0) {
            //Buscar en el rango fechaInicio/fechaFin si hay fines de semana
            foreach ($checkListHora as $item) {
                $begin = new DateTime($item->fecha_inicio);
                $end = new DateTime($item->fecha_fin);
                $end = $end->modify('+1 day');
                $interval = new DateInterval('P1D');
                $daterange = new DatePeriod($begin, $interval, $end);

                foreach ($daterange as $date) {
                    //Si hay fines de semana se suman 24 horas al contador
                    if (date('l', strtotime($date->format("d-m-Y"))) == 'Sunday' || date('l', strtotime($date->format("d-m-Y"))) == 'Saturday') {
                        $ContadorFinSemana += 24;
                    }
                }
                //se calcula la diferencia entre las 2 fechas
                $fecha = new Carbon($item->fecha_inicio);
                //Al total de horas se le restan las horas correspondientes a fines de semana 
                $contador = round($fecha->diffInMinutes($item->fecha_fin) / 60) - $ContadorFinSemana;
                if ($contador < 0) {
                    $contador *= -1;
                }
                while ($contador != 0) {
                    //Si el total de horas es mayor a 9 significa que se trabajo mas de un dia
                    //Se suman 9 horas al total de horas de trabajo
                    //Y se le restan las 24 horas al contador de horas para eliminar el dia que ya paso
                    if ($contador >= 9) {
                        $totalH += 9;
                        $contador -= 24;
                    } else {
                        $totalH += $contador;
                        $contador = 0;
                    }
                }

                //Calcular la diferencia de minutos entre las fechas
                $fecha = new Carbon($item->fecha_fin);
                $totalDias += $fecha->diffInDays($item->fecha_inicio);
                $ContadorFinSemana = 0;
                $contador = 0;
            }
            $totalHoras = $totalH;
            $totalMinutos = $totalH * 60;
            //Calcular los promedios
            $promedioM = round($totalMinutos / $contador_check);
            $promedioH = round($totalHoras / $contador_check);
        }

        //Reporte Tiempo instalacion por sucursal
        $checkListSucursal = DB::table('checklist_instalacions')->select('checklist_instalacions.fecha_inicio', 'checklist_instalacions.fecha_fin', 'checklist_instalacions.Cscui')
            ->join('asignacion_instalacions', 'asignacion_instalacions.id', '=', 'checklist_instalacions.asignacion_instalacion_retiro_id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->where('proyectos.id', '=', $letra)
            ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
            ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio, 'AND', 'checklist_instalacions.fecha_fin', '<=', $fechaFin)
            ->select(DB::raw("MIN(checklist_instalacions.fecha_inicio) AS fecha_inicio, MAX(checklist_instalacions.fecha_fin) AS fecha_fin, checklist_instalacions.Cscui"))
            ->groupBy('Cscui')
            ->get();


        //Reporte Tasa de efectividad
        //Extraer los datos de la tabla asignacion_instalacions
        $asignacionInstalacion = DB::table('asignacion_instalacions')->select('asignacion_instalacions.numero_visita')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->where('proyectos.id', '=', $letra)
            ->where('asignacion_instalacions.estado_asignacion', '=', 'finalizado')
            ->where('asignacion_instalacions.fecha_instalacion', '>=', $fechaInicio, 'AND', 'asignacion_instalacions.fecha_instalacion', '<=', $fechaFin)
            ->get();

        //Crear las variables
        //Obtener total de visitas
        $totalAsignacion = count($asignacionInstalacion);
        //Contar las instalaciones exitosas en la primera visita
        $contadorPrimeravisita = 0;
        foreach ($asignacionInstalacion as $item) {
            if ($item->numero_visita == 1) {
                $contadorPrimeravisita += 1;
            }
        }
        //Obtener el porcentaje de efectividad
        $tasaDeInstalacion = 0;
        if ($totalAsignacion > 0) {
            $tasaDeInstalacion = round(($contadorPrimeravisita * 100) / $totalAsignacion);
        }

        //--------------------- Reporte de Status de proyecto por region ---------------
        //Obtener nombre de las regiones
        $reporteRegion = DB::table('instalacions')->select('instalacions.sRegion')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->where('proyectos.id', '=', $letra)
            ->orderBy('instalacions.sRegion')
            ->distinct('instalacions.sRegion')
            ->get();

        $reporteRegion2 = DB::table('instalacions')->select('instalacions.sRegion')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->where('proyectos.id', '=', $letra)
            ->orderBy('instalacions.sRegion')
            ->get();
        $totalProyectoRegion = Count($reporteRegion2);

        //Obtener nombre de las regiones y el estado de la instalacion
        $reporteRegionAux = DB::table('instalacions')->select('instalacions.sRegion', 'instalacions.sEstado_instalacion', 'checklist_instalacions.observacion', 'checklist_instalacions.id')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->join('asignacion_instalacions', 'asignacion_instalacions.lista_instalacion_id', '=', 'instalacions.id')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->where('proyectos.id', '=', $letra)
            ->whereNotNull('checklist_instalacions.observacion')
            ->orderBy('instalacions.sRegion')
            ->get();

        //----------------------- Reporte Accesorios ------------------------------------ 
        //Obtener datos de la tabla instalacions
        $reporteAccesorios = DB::table('instalacions')->select(
            'instalacions.sBandeja_adicional',
            'instalacions.sMueble',
            'instalacions.sSD',
            'instalacions.sCable_poder',
            'instalacions.sCable_red',
            'instalacions.sKit_lector'
        )
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->where('proyectos.id', '=', $letra)
            ->get();

        //Contar los accesorios solicitados
        $contadorInstalacionSi = 0;
        $contadorBandejaI = 0;
        $contadorCableRedI = 0;
        $contadorCablePoderI = 0;
        $contadorMuebleI = 0;
        $contadorLectorI = 0;
        $contadorSDI = 0;

        foreach ($reporteAccesorios as $item) {
            if ($item->sBandeja_adicional == 'si' || $item->sBandeja_adicional == 'Si' || $item->sBandeja_adicional == '1') {
                $contadorInstalacionSi += 1;
                $contadorBandejaI += 1;
            }
            if ($item->sMueble == 'si' || $item->sMueble == 'Si' || $item->sMueble == '1') {
                $contadorInstalacionSi += 1;
                $contadorMuebleI += 1;
            }
            if ($item->sSD == 'si' || $item->sSD == 'Si' || $item->sSD == '1') {
                $contadorInstalacionSi += 1;
                $contadorSDI += 1;
            }
            if ($item->sCable_poder == 'si' || $item->sCable_poder == 'Si' || $item->sCable_poder == '1') {
                $contadorInstalacionSi += 1;
                $contadorCablePoderI += 1;
            }
            if ($item->sCable_red == 'si' || $item->sCable_red == 'Si' || $item->sCable_red == '1') {
                $contadorInstalacionSi += 1;
                $contadorCableRedI += 1;
            }
            if ($item->sKit_lector == 'si' || $item->sKit_lector == 'Si' || $item->sKit_lector == '1') {
                $contadorInstalacionSi += 1;
                $contadorLectorI += 1;
            }
        }

        //Obtener datos tabla checklist
        $checklistAccesorios = $checkListHora = DB::table('checklist_instalacions')->select(
            'checklist_instalacions.CsBandeja_adicional',
            'checklist_instalacions.CsMueble',
            'checklist_instalacions.CsSD',
            'checklist_instalacions.CsCable_poder',
            'checklist_instalacions.CsCable_red',
            'checklist_instalacions.CsKit_lector'
        )
            ->join('asignacion_instalacions', 'asignacion_instalacions.id', '=', 'checklist_instalacions.asignacion_instalacion_retiro_id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->where('proyectos.id', '=', $letra)
            ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
            ->whereNotNull('checklist_instalacions.fecha_inicio')
            ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio, 'AND', 'checklist_instalacions.fecha_fin', '<=', $fechaFin)
            ->get();

        //Contar los accesorios solicitados
        $contadorCheckSi = 0;
        $contadorBandeja = 0;
        $contadorCableRed = 0;
        $contadorCablePoder = 0;
        $contadorMueble = 0;
        $contadorLector = 0;
        $contadorSD = 0;

        foreach ($checklistAccesorios as $item) {
            if ($item->CsBandeja_adicional == 'si' || $item->CsBandeja_adicional == 'Si' || $item->CsBandeja_adicional == '1') {
                $contadorCheckSi += 1;
                $contadorBandeja += 1;
            }
            if ($item->CsMueble == 'si' || $item->CsMueble == 'Si' || $item->CsMueble == '1') {
                $contadorCheckSi += 1;
                $contadorMueble += 1;
            }
            if ($item->CsSD == 'si' || $item->CsSD == 'Si' || $item->CsSD == '1') {
                $contadorCheckSi += 1;
                $contadorSD += 1;
            }
            if ($item->CsCable_poder == 'si' || $item->CsCable_poder == 'Si' || $item->CsCable_poder == '1') {
                $contadorCheckSi += 1;
                $contadorCablePoder += 1;
            }
            if ($item->CsCable_red == 'si' || $item->CsCable_red == 'Si' || $item->CsCable_red == '1') {
                $contadorCheckSi += 1;
                $contadorCableRed += 1;
            }
            if ($item->CsKit_lector == 'si' || $item->CsKit_lector == 'Si' || $item->CsKit_lector == '1') {
                $contadorCheckSi += 1;
                $contadorLector += 1;
            }
        }
        //---------------------- Crear una lista con los datos recopilados ---------------------
        $listaAccesorios = [
            "Bandeja Adicional" . "-" . $contadorBandeja . "-" . $contadorBandejaI,
            "Mueble" . "-" . $contadorMueble . "-" . $contadorMuebleI,
            "Memoria SD" . "-" . $contadorSD . "-" . $contadorSDI,
            "Cable de Poder" . "-" . $contadorCablePoder . "-" . $contadorCablePoderI,
            "Cable de Red" . "-" . $contadorCableRed . "-" . $contadorCableRedI,
            "Kit Lector" . "-" . $contadorLector . "-" . $contadorLectorI

        ];
        $coleccion = collect($listaAccesorios);
        /*  //creamos variable de fecha para asignarla al pdf de informe
          $date = Carbon::now();


          $crear_url_informe = new App\informes();
          $crear_url_informe->fecha = $date->format('yy-m-d');

          $date = $date->format('d-m-Y');

          //creamos el proyecto a guardar

          $crear_url_informe->url_pdf = $date."Informes.pdf";
          $crear_url_informe->timestamps = false;
          $crear_url_informe->save(); */



        //Devolver Datos a la vista
        return  \PDF::setOptions(['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true])
            ->loadView('informes.informe_pdf', compact(
                'totalProyectoRegion',
                'validacion',
                'proyectos',
                'cantidad_equipo',
                'contador_instalacion_total',
                'valor_instalacion',
                'contador_check',
                'ejecutadototal',
                'desviacion',
                'desviacion2',
                'fechaInicio',
                'fechaFin',
                'nombres',
                'promedioM',
                'promedioH',
                'checkListSucursal',
                'totalAsignacion',
                'contadorPrimeravisita',
                'tasaDeInstalacion',
                'reporteRegion',
                'reporteRegionAux',
                'contadorCheckSi',
                'contadorInstalacionSi',
                'coleccion'
            ))
            /* ->save(storage_path('app/public/pdfInformes/') . $date.'Informes.pdf') */
            ->stream();
    }


    function informedatos(Request $request)
    {

        //Preguntar si se selecciono un proyecto
        if ($request->proyecto == null) {
            return redirect('informes')->with('status', 'Por Favor Seleccione un proyecto');;
        } else {
            $validacion = 1;
            $letra = $request->proyecto;
            //Obtener las fechas ingresadas en el calendario
            $fechaInicio = date('Y-m-d', strtotime($request->input("calendarioInicio")));
            $fechaFin = date('Y-m-d', strtotime($request->input("calendarioFin")));

            $fechaInicio = $fechaInicio . " 00:00:00";
            $fechaFin = $fechaFin . " 23:59:59";




            $idproyectoPDF = $request->input("proyecto");
            //Extraer los proyectos de la bd
            $proyectos = DB::table('proyectos')->select('proyectos.id', 'proyectos.nombre')
                ->where('proyectos.estado', '=', 1)
                ->where('proyectos.id', '!=', 1)
                ->orderBy('proyectos.id', 'asc')
                ->get();

            $nombres =  DB::table('proyectos')
                ->where('proyectos.estado', '=', 1)
                ->where('proyectos.id', '=', $letra)
                ->orderBy('proyectos.id', 'asc')
                ->get();


            //TOTAL PROYECTOS.
            $cantidad_equipo = DB::table('proyectos')->select('proyectos.cantidad_equipos', 'proyectos.nombre')
                ->where('proyectos.estado', '=', 1)
                ->where('proyectos.id', '=', $letra)
                ->orderBy('proyectos.id', 'asc')
                ->get();

            //extraer los datos de la tabla checklist
            $checkList = DB::table('checklist_instalacions')
                ->select('checklist_instalacions.estado_inicio')
                ->join('asignacion_instalacions', 'asignacion_instalacions.id', '=', 'checklist_instalacions.asignacion_instalacion_retiro_id')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
                ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
                ->where('proyectos.id', '=', $letra)
                ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
                ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio, 'AND', 'checklist_instalacions.fecha_fin', '<=', $fechaFin)
                ->get();



            //total del checklist
            $contador_check = count($checkList);



            //extraer los datos de la tabla instalacion
            $instalaciontotal = DB::table('instalacions')->select('instalacions.id')
                ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
                ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
                ->where('proyectos.id', '=', $letra)
                ->where('instalacions.dFecha_instalacion', '>=', $fechaInicio, 'AND', '<=', $fechaFin)
                ->orderBy('instalacions.id', 'asc')
                ->get();

            //total instalados total tabla
            $contador_instalacion_total = count($instalaciontotal);

            $totalproyecto =   $cantidad_equipo[0]->cantidad_equipos;
            //% Avance planificado
            $valor_instalacion = $contador_instalacion_total * 100 / $totalproyecto;
            //% Avance ejecutado
            // $ejecutadototal = $contador_instalacion * 100 / $totalproyecto;
            $ejecutadototal = $contador_check * 100 / $totalproyecto;
            //$desviacion = $contador_instalacion - $contador_instalacion_total;
            $desviacion = $contador_check - $contador_instalacion_total;
            $desviacion2 = $ejecutadototal - $valor_instalacion;
            $fechaConsultadaInicio = date('d-m-y', strtotime($fechaInicio));
            $fechaConsultadaFin = date('d-m-y', strtotime($fechaFin));

            //--------------- Reporte Tiempo de instalaciones ------
            //Extraer las fechas de inicio y finalizacion de la tabla checklist
            $checkListHora = DB::table('checklist_instalacions')->select('checklist_instalacions.fecha_inicio', 'checklist_instalacions.fecha_fin')
                ->join('asignacion_instalacions', 'asignacion_instalacions.id', '=', 'checklist_instalacions.asignacion_instalacion_retiro_id')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
                ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
                ->where('proyectos.id', '=', $letra)
                ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
                ->whereNotNull('checklist_instalacions.fecha_inicio')
                ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio, 'AND', 'checklist_instalacions.fecha_fin', '<=', $fechaFin)
                ->get();
            //Crear Variable Auxiliar
            $totalDias = 0;
            $promedioM = 0;
            $promedioH = 0;
            $ContadorFinSemana = 0;
            $contador = 0;
            $totalH = 0;
            if ($contador_check > 0) {
                //Buscar en el rango fechaInicio/fechaFin si hay fines de semana
                foreach ($checkListHora as $item) {
                    $begin = new DateTime($item->fecha_inicio);
                    $end = new DateTime($item->fecha_fin);
                    $end = $end->modify('+1 day');
                    $interval = new DateInterval('P1D');
                    $daterange = new DatePeriod($begin, $interval, $end);

                    foreach ($daterange as $date) {
                        //Si hay fines de semana se suman 24 horas al contador
                        if (date('l', strtotime($date->format("d-m-Y"))) == 'Sunday' || date('l', strtotime($date->format("d-m-Y"))) == 'Saturday') {
                            $ContadorFinSemana += 24;
                        }
                    }
                    //se calcula la diferencia entre las 2 fechas
                    $fecha = new Carbon($item->fecha_inicio);
                    //Al total de horas se le restan las horas correspondientes a fines de semana 
                    $contador = round($fecha->diffInMinutes($item->fecha_fin) / 60) - $ContadorFinSemana;
                    if ($contador < 0) {
                        $contador *= -1;
                    }
                    while ($contador != 0) {
                        //Si el total de horas es mayor a 9 significa que se trabajo mas de un dia
                        //Se suman 9 horas al total de horas de trabajo
                        //Y se le restan las 24 horas al contador de horas para eliminar el dia que ya paso
                        if ($contador >= 9) {
                            $totalH += 9;
                            $contador -= 24;
                        } else {
                            $totalH += $contador;
                            $contador = 0;
                        }
                    }

                    //Calcular la diferencia de minutos entre las fechas
                    $fecha = new Carbon($item->fecha_fin);
                    $totalDias += $fecha->diffInDays($item->fecha_inicio);
                    $ContadorFinSemana = 0;
                    $contador = 0;
                }
                $totalHoras = $totalH;
                $totalMinutos = $totalH * 60;
                //Calcular los promedios
                if ($contador_check > 0) {
                    $promedioM = round($totalMinutos / $contador_check);
                    $promedioH = round($totalHoras / $contador_check);
                }
            }

            //Reporte Tiempo instalacion por sucursal
            $checkListSucursal = DB::table('checklist_instalacions')->select('checklist_instalacions.fecha_inicio', 'checklist_instalacions.fecha_fin', 'checklist_instalacions.Cscui')
                ->join('asignacion_instalacions', 'asignacion_instalacions.id', '=', 'checklist_instalacions.asignacion_instalacion_retiro_id')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
                ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
                ->where('proyectos.id', '=', $letra)
                ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
                ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio, 'AND', 'checklist_instalacions.fecha_fin', '<=', $fechaFin)
                ->select(DB::raw("MIN(checklist_instalacions.fecha_inicio) AS fecha_inicio, MAX(checklist_instalacions.fecha_fin) AS fecha_fin, checklist_instalacions.Cscui"))
                ->groupBy('Cscui')
                ->get();


            //Reporte Tasa de efectividad
            //Extraer los datos de la tabla asignacion_instalacions
            $asignacionInstalacion = DB::table('asignacion_instalacions')->select('asignacion_instalacions.numero_visita')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
                ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
                ->where('proyectos.id', '=', $letra)
                ->where('asignacion_instalacions.estado_asignacion', '=', 'finalizado')
                ->where('asignacion_instalacions.fecha_instalacion', '>=', $fechaInicio, 'AND', 'asignacion_instalacions.fecha_instalacion', '<=', $fechaFin)
                ->get();

            //Crear las variables
            //Obtener total de visitas
            $totalAsignacion = count($asignacionInstalacion);
            //Contar las instalaciones exitosas en la primera visita
            $contadorPrimeravisita = 0;
            foreach ($asignacionInstalacion as $item) {
                if ($item->numero_visita == 1) {
                    $contadorPrimeravisita += 1;
                }
            }
            //Obtener el porcentaje de efectividad
            $tasaDeInstalacion = 0;
            if ($totalAsignacion > 0) {
                $tasaDeInstalacion = round(($contadorPrimeravisita * 100) / $totalAsignacion);
            }

            //--------------------- Reporte de Status de proyecto por region ---------------
            //Obtener nombre de las regiones
            $reporteRegion = DB::table('instalacions')->select('instalacions.sRegion')
                ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
                ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
                ->join('asignacion_instalacions', 'asignacion_instalacions.lista_instalacion_id', '=', 'instalacions.id')
                ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                ->where('proyectos.id', '=', $letra)
                ->orderBy('instalacions.sRegion')
                ->distinct('instalacions.sRegion')
                ->get();
            $reporteRegion2 = DB::table('instalacions')->select('instalacions.sRegion')
                ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
                ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
                ->where('proyectos.id', '=', $letra)
                ->orderBy('instalacions.sRegion')
                ->get();
            $totalProyectoRegion = Count($reporteRegion2);
            //Obtener nombre de las regiones y el estado de la instalacion
            $reporteRegionAux = DB::table('instalacions')->select('instalacions.sRegion', 'instalacions.sEstado_instalacion', 'checklist_instalacions.observacion', 'checklist_instalacions.id')
                ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
                ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
                ->join('asignacion_instalacions', 'asignacion_instalacions.lista_instalacion_id', '=', 'instalacions.id')
                ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                ->where('proyectos.id', '=', $letra)
                ->whereNotNull('checklist_instalacions.observacion')
                ->orderBy('instalacions.sRegion')
                ->get();

            //----------------------- Reporte Accesorios ------------------------------------ 
            //Obtener datos de la tabla instalacions
            $reporteAccesorios = DB::table('instalacions')->select(
                'instalacions.sBandeja_adicional',
                'instalacions.sMueble',
                'instalacions.sSD',
                'instalacions.sCable_poder',
                'instalacions.sCable_red',
                'instalacions.sKit_lector'
            )
                ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
                ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
                ->where('proyectos.id', '=', $letra)
                ->get();

            //Contar los accesorios solicitados
            $contadorInstalacionSi = 0;
            $contadorBandejaI = 0;
            $contadorCableRedI = 0;
            $contadorCablePoderI = 0;
            $contadorMuebleI = 0;
            $contadorLectorI = 0;
            $contadorSDI = 0;

            foreach ($reporteAccesorios as $item) {
                if ($item->sBandeja_adicional == 'si' || $item->sBandeja_adicional == 'Si' || $item->sBandeja_adicional == '1') {
                    $contadorInstalacionSi += 1;
                    $contadorBandejaI += 1;
                }
                if ($item->sMueble == 'si' || $item->sMueble == 'Si' || $item->sMueble == '1') {
                    $contadorInstalacionSi += 1;
                    $contadorMuebleI += 1;
                }
                if ($item->sSD == 'si' || $item->sSD == 'Si' || $item->sSD == '1') {
                    $contadorInstalacionSi += 1;
                    $contadorSDI += 1;
                }
                if ($item->sCable_poder == 'si' || $item->sCable_poder == 'Si' || $item->sCable_poder == '1') {
                    $contadorInstalacionSi += 1;
                    $contadorCablePoderI += 1;
                }
                if ($item->sCable_red == 'si' || $item->sCable_red == 'Si' || $item->sCable_red == '1') {
                    $contadorInstalacionSi += 1;
                    $contadorCableRedI += 1;
                }
                if ($item->sKit_lector == 'si' || $item->sKit_lector == 'Si' || $item->sKit_lector == '1') {
                    $contadorInstalacionSi += 1;
                    $contadorLectorI += 1;
                }
            }

            //Obtener datos tabla checklist
            $checklistAccesorios = $checkListHora = DB::table('checklist_instalacions')->select(
                'checklist_instalacions.CsBandeja_adicional',
                'checklist_instalacions.CsMueble',
                'checklist_instalacions.CsSD',
                'checklist_instalacions.CsCable_poder',
                'checklist_instalacions.CsCable_red',
                'checklist_instalacions.CsKit_lector'
            )
                ->join('asignacion_instalacions', 'asignacion_instalacions.id', '=', 'checklist_instalacions.asignacion_instalacion_retiro_id')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
                ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
                ->where('proyectos.id', '=', $letra)
                ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
                ->whereNotNull('checklist_instalacions.fecha_inicio')
                ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio, 'AND', 'checklist_instalacions.fecha_fin', '<=', $fechaFin)
                ->get();

            //Contar los accesorios solicitados
            $contadorCheckSi = 0;
            $contadorBandeja = 0;
            $contadorCableRed = 0;
            $contadorCablePoder = 0;
            $contadorMueble = 0;
            $contadorLector = 0;
            $contadorSD = 0;

            foreach ($checklistAccesorios as $item) {
                if ($item->CsBandeja_adicional == 'si' || $item->CsBandeja_adicional == 'Si' || $item->CsBandeja_adicional == '1') {
                    $contadorCheckSi += 1;
                    $contadorBandeja += 1;
                }
                if ($item->CsMueble == 'si' || $item->CsMueble == 'Si' || $item->CsMueble == '1') {
                    $contadorCheckSi += 1;
                    $contadorMueble += 1;
                }
                if ($item->CsSD == 'si' || $item->CsSD == 'Si' || $item->CsSD == '1') {
                    $contadorCheckSi += 1;
                    $contadorSD += 1;
                }
                if ($item->CsCable_poder == 'si' || $item->CsCable_poder == 'Si' || $item->CsCable_poder == '1') {
                    $contadorCheckSi += 1;
                    $contadorCablePoder += 1;
                }
                if ($item->CsCable_red == 'si' || $item->CsCable_red == 'Si' || $item->CsCable_red == '1') {
                    $contadorCheckSi += 1;
                    $contadorCableRed += 1;
                }
                if ($item->CsKit_lector == 'si' || $item->CsKit_lector == 'Si' || $item->CsKit_lector == '1') {
                    $contadorCheckSi += 1;
                    $contadorLector += 1;
                }
            }
            //---------------------- Crear una lista con los datos recopilados ---------------------
            $listaAccesorios = [
                "Bandeja Adicional" . "-" . $contadorBandeja . "-" . $contadorBandejaI,
                "Mueble" . "-" . $contadorMueble . "-" . $contadorMuebleI,
                "Memoria SD" . "-" . $contadorSD . "-" . $contadorSDI,
                "Cable de Poder" . "-" . $contadorCablePoder . "-" . $contadorCablePoderI,
                "Cable de Red" . "-" . $contadorCableRed . "-" . $contadorCableRedI,
                "Kit Lector" . "-" . $contadorLector . "-" . $contadorLectorI

            ];
            $coleccion = collect($listaAccesorios);



            //Devolver Datos a la vista
            return view('informes.informe', compact(
                'totalProyectoRegion',
                'validacion',
                'proyectos',
                'cantidad_equipo',
                'contador_instalacion_total',
                'valor_instalacion',
                'contador_check',
                'ejecutadototal',
                'desviacion',
                'desviacion2',
                'fechaInicio',
                'fechaFin',
                'nombres',
                'promedioM',
                'promedioH',
                'checkListSucursal',
                'totalAsignacion',
                'contadorPrimeravisita',
                'tasaDeInstalacion',
                'reporteRegion',
                'reporteRegionAux',
                'letra',
                'coleccion'
            ));
        }
    }


    function informedatos_7novimebre(Request $request)
    {

        //Preguntar si se selecciono un proyecto
        if ($request->proyecto == null) {
            return redirect('informes')->with('status', 'Por Favor Seleccione un proyecto');;
        } else {
            $validacion = 1;
            $letra = $request->proyecto;
            //Obtener las fechas ingresadas en el calendario
            $fechaInicio = date('Y-m-d', strtotime($request->input("calendarioInicio")));
            $fechaFin = date('Y-m-d', strtotime($request->input("calendarioFin")));

            $idproyectoPDF = $request->input("proyecto");
            //Extraer los proyectos de la bd
            $proyectos = DB::table('proyectos')->select('proyectos.id', 'proyectos.nombre')
                ->where('proyectos.estado', '=', 1)
                ->where('proyectos.id', '!=', 1)
                ->orderBy('proyectos.id', 'asc')
                ->get();
            $nombres =  DB::table('proyectos')
                ->where('proyectos.estado', '=', 1)
                ->where('proyectos.id', '=', $letra)
                ->orderBy('proyectos.id', 'asc')
                ->get();


            //TOTAL PROYECTOS.
            $cantidad_equipo = DB::table('proyectos')->select('proyectos.cantidad_equipos', 'proyectos.nombre')
                ->where('proyectos.estado', '=', 1)
                ->where('proyectos.id', '=', $letra)
                ->orderBy('proyectos.id', 'asc')
                ->get();

            //extraer los datos de la tabla checklist
            $checkList = DB::table('checklist_instalacions')->select('checklist_instalacions.estado_inicio')
                ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
                ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio, 'AND', 'checklist_instalacions.fecha_fin', '<=', $fechaFin)
                ->get();
            //total del checklist
            $contador_check = count($checkList);


            //extraer los datos de la tabla instalacion
            $instalaciontotal = DB::table('instalacions')->select('instalacions.id')
                ->where('instalacions.dFecha_instalacion', '>=', $fechaInicio, 'AND', '<=', $fechaFin)
                /*->where('instalacions.dFecha_instalacion','<=', $currentDateTime)*/
                ->orderBy('instalacions.id', 'asc')
                ->get();

            //total instalados total tabla
            $contador_instalacion_total = count($instalaciontotal);

            $totalproyecto =   $cantidad_equipo[0]->cantidad_equipos;
            //% Avance planificado
            $valor_instalacion = $contador_instalacion_total * 100 / $totalproyecto;
            //% Avance ejecutado
            // $ejecutadototal = $contador_instalacion * 100 / $totalproyecto;
            $ejecutadototal = $contador_check * 100 / $totalproyecto;
            //$desviacion = $contador_instalacion - $contador_instalacion_total;
            $desviacion = $contador_check - $contador_instalacion_total;
            $desviacion2 = $ejecutadototal - $valor_instalacion;
            $fechaConsultadaInicio = date('d-m-y', strtotime($fechaInicio));
            $fechaConsultadaFin = date('d-m-y', strtotime($fechaFin));

            //--------------- Reporte Tiempo de instalaciones ------
            //Extraer las fechas de inicio y finalizacion de la tabla checklist
            $checkListHora = DB::table('checklist_instalacions')->select('checklist_instalacions.fecha_inicio', 'checklist_instalacions.fecha_fin')
                ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
                ->whereNotNull('checklist_instalacions.fecha_inicio')
                ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio, 'AND', 'checklist_instalacions.fecha_fin', '<=', $fechaFin)
                ->get();
            //Crear Variable Auxiliar
            $totalDias = 0;
            $promedioM = 0;
            $promedioH = 0;
            $ContadorFinSemana = 0;
            $contador = 0;
            $totalH = 0;
            if ($contador_check > 0) {
                //Buscar en el rango fechaInicio/fechaFin si hay fines de semana
                foreach ($checkListHora as $item) {
                    $begin = new DateTime($item->fecha_inicio);
                    $end = new DateTime($item->fecha_fin);
                    $end = $end->modify('+1 day');
                    $interval = new DateInterval('P1D');
                    $daterange = new DatePeriod($begin, $interval, $end);

                    foreach ($daterange as $date) {
                        //Si hay fines de semana se suman 24 horas al contador
                        if (date('l', strtotime($date->format("d-m-Y"))) == 'Sunday' || date('l', strtotime($date->format("d-m-Y"))) == 'Saturday') {
                            $ContadorFinSemana += 24;
                        }
                    }
                    //se calcula la diferencia entre las 2 fechas
                    $fecha = new Carbon($item->fecha_inicio);
                    //Al total de horas se le restan las horas correspondientes a fines de semana 
                    $contador = round($fecha->diffInMinutes($item->fecha_fin) / 60) - $ContadorFinSemana;
                    if ($contador < 0) {
                        $contador *= -1;
                    }
                    while ($contador != 0) {
                        //Si el total de horas es mayor a 9 significa que se trabajo mas de un dia
                        //Se suman 9 horas al total de horas de trabajo
                        //Y se le restan las 24 horas al contador de horas para eliminar el dia que ya paso
                        if ($contador >= 9) {
                            $totalH += 9;
                            $contador -= 24;
                        } else {
                            $totalH += $contador;
                            $contador = 0;
                        }
                    }

                    //Calcular la diferencia de minutos entre las fechas
                    $fecha = new Carbon($item->fecha_fin);
                    $totalDias += $fecha->diffInDays($item->fecha_inicio);
                    $ContadorFinSemana = 0;
                    $contador = 0;
                }
                $totalHoras = $totalH;
                $totalMinutos = $totalH * 60;
                //Calcular los promedios
                if ($contador_check > 0) {
                    $promedioM = round($totalMinutos / $contador_check);
                    $promedioH = round($totalHoras / $contador_check);
                }
            }

            //Reporte Tiempo instalacion por sucursal
            $checkListSucursal = DB::table('checklist_instalacions')->select('checklist_instalacions.fecha_inicio', 'checklist_instalacions.fecha_fin', 'checklist_instalacions.Cscui')
                ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
                ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio, 'AND', 'checklist_instalacions.fecha_fin', '<=', $fechaFin)
                ->select(DB::raw("MIN(checklist_instalacions.fecha_inicio) AS fecha_inicio, MAX(checklist_instalacions.fecha_fin) AS fecha_fin, checklist_instalacions.Cscui"))
                ->groupBy('Cstipo_sucursal')
                ->get();


            //Reporte Tasa de efectividad
            //Extraer los datos de la tabla asignacion_instalacions
            $asignacionInstalacion = DB::table('asignacion_instalacions')->select('asignacion_instalacions.numero_visita')
                ->where('asignacion_instalacions.estado_asignacion', '=', 'finalizado')
                ->where('asignacion_instalacions.fecha_instalacion', '>=', $fechaInicio, 'AND', 'asignacion_instalacions.fecha_instalacion', '<=', $fechaFin)
                ->get();

            //Crear las variables
            //Obtener total de visitas
            $totalAsignacion = count($asignacionInstalacion);
            //Contar las instalaciones exitosas en la primera visita
            $contadorPrimeravisita = 0;
            foreach ($asignacionInstalacion as $item) {
                if ($item->numero_visita == 1) {
                    $contadorPrimeravisita += 1;
                }
            }
            //Obtener el porcentaje de efectividad
            $tasaDeInstalacion = 0;
            if ($totalAsignacion > 0) {
                $tasaDeInstalacion = round(($contadorPrimeravisita * 100) / $totalAsignacion);
            }
            //--------------------- Reporte de Status de proyecto por region ---------------
            //Obtener nombre de las regiones
            $reporteRegion = DB::table('instalacions')->select('instalacions.sRegion')
                ->orderBy('instalacions.sRegion')
                ->distinct('instalacions.sRegion')
                ->get();
            //Obtener nombre de las regiones y el estado de la instalacion
            $reporteRegionAux = DB::table('instalacions')->select('instalacions.sRegion', 'instalacions.sEstado_instalacion')
                ->orderBy('instalacions.sRegion')
                ->get();

            //----------------------- Reporte Accesorios ------------------------------------ 
            //Obtener datos de la tabla instalacions
            $reporteAccesorios = DB::table('instalacions')->select(
                'instalacions.sBandeja_adicional',
                'instalacions.sMueble',
                'instalacions.sSD',
                'instalacions.sCable_poder',
                'instalacions.sCable_red',
                'instalacions.sKit_lector'
            )
                ->get();

            //Contar los accesorios solicitados
            $contadorInstalacionSi = 0;
            $contadorBandejaI = 0;
            $contadorCableRedI = 0;
            $contadorCablePoderI = 0;
            $contadorMuebleI = 0;
            $contadorLectorI = 0;
            $contadorSDI = 0;

            foreach ($reporteAccesorios as $item) {
                if ($item->sBandeja_adicional == 'si' || $item->sBandeja_adicional == 'Si' || $item->sBandeja_adicional == '1') {
                    $contadorInstalacionSi += 1;
                    $contadorBandejaI += 1;
                }
                if ($item->sMueble == 'si' || $item->sMueble == 'Si' || $item->sMueble == '1') {
                    $contadorInstalacionSi += 1;
                    $contadorMuebleI += 1;
                }
                if ($item->sSD == 'si' || $item->sSD == 'Si' || $item->sSD == '1') {
                    $contadorInstalacionSi += 1;
                    $contadorSDI += 1;
                }
                if ($item->sCable_poder == 'si' || $item->sCable_poder == 'Si' || $item->sCable_poder == '1') {
                    $contadorInstalacionSi += 1;
                    $contadorCablePoderI += 1;
                }
                if ($item->sCable_red == 'si' || $item->sCable_red == 'Si' || $item->sCable_red == '1') {
                    $contadorInstalacionSi += 1;
                    $contadorCableRedI += 1;
                }
                if ($item->sKit_lector == 'si' || $item->sKit_lector == 'Si' || $item->sKit_lector == '1') {
                    $contadorInstalacionSi += 1;
                    $contadorLectorI += 1;
                }
            }

            //Obtener datos tabla checklist
            $checklistAccesorios = $checkListHora = DB::table('checklist_instalacions')->select(
                'checklist_instalacions.CsBandeja_adicional',
                'checklist_instalacions.CsMueble',
                'checklist_instalacions.CsSD',
                'checklist_instalacions.CsCable_poder',
                'checklist_instalacions.CsCable_red',
                'checklist_instalacions.CsKit_lector'
            )
                ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
                ->whereNotNull('checklist_instalacions.fecha_inicio')
                ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio, 'AND', 'checklist_instalacions.fecha_fin', '<=', $fechaFin)
                ->get();

            //Contar los accesorios solicitados
            $contadorCheckSi = 0;
            $contadorBandeja = 0;
            $contadorCableRed = 0;
            $contadorCablePoder = 0;
            $contadorMueble = 0;
            $contadorLector = 0;
            $contadorSD = 0;

            foreach ($checklistAccesorios as $item) {
                if ($item->CsBandeja_adicional == 'si' || $item->CsBandeja_adicional == 'Si' || $item->CsBandeja_adicional == '1') {
                    $contadorCheckSi += 1;
                    $contadorBandeja += 1;
                }
                if ($item->CsMueble == 'si' || $item->CsMueble == 'Si' || $item->CsMueble == '1') {
                    $contadorCheckSi += 1;
                    $contadorMueble += 1;
                }
                if ($item->CsSD == 'si' || $item->CsSD == 'Si' || $item->CsSD == '1') {
                    $contadorCheckSi += 1;
                    $contadorSD += 1;
                }
                if ($item->CsCable_poder == 'si' || $item->CsCable_poder == 'Si' || $item->CsCable_poder == '1') {
                    $contadorCheckSi += 1;
                    $contadorCablePoder += 1;
                }
                if ($item->CsCable_red == 'si' || $item->CsCable_red == 'Si' || $item->CsCable_red == '1') {
                    $contadorCheckSi += 1;
                    $contadorCableRed += 1;
                }
                if ($item->CsKit_lector == 'si' || $item->CsKit_lector == 'Si' || $item->CsKit_lector == '1') {
                    $contadorCheckSi += 1;
                    $contadorLector += 1;
                }
            }
            //---------------------- Crear una lista con los datos recopilados ---------------------
            $listaAccesorios = [
                "Bandeja Adicional" . "-" . $contadorBandeja . "-" . $contadorBandejaI,
                "Mueble" . "-" . $contadorMueble . "-" . $contadorMuebleI,
                "Memoria SD" . "-" . $contadorSD . "-" . $contadorSDI,
                "Cable de Poder" . "-" . $contadorCablePoder . "-" . $contadorCablePoderI,
                "Cable de Red" . "-" . $contadorCableRed . "-" . $contadorCableRedI,
                "Kit Lector" . "-" . $contadorLector . "-" . $contadorLectorI

            ];
            $coleccion = collect($listaAccesorios);

            //Devolver Datos a la vista
            return view('informes.informe', compact(
                'validacion',
                'proyectos',
                'cantidad_equipo',
                'contador_instalacion_total',
                'valor_instalacion',
                'contador_check',
                'ejecutadototal',
                'desviacion',
                'desviacion2',
                'fechaInicio',
                'fechaFin',
                'nombres',
                'promedioM',
                'promedioH',
                'checkListSucursal',
                'totalAsignacion',
                'contadorPrimeravisita',
                'tasaDeInstalacion',
                'reporteRegion',
                'reporteRegionAux',
                'letra',
                'coleccion'
            ));
        }
    }

    function informedatos_4novimebre(Request $request)
    {

        //Preguntar si se selecciono un proyecto
        if ($request->proyecto == null) {
            return redirect('informes')->with('status', 'Por Favor Seleccione un proyecto');;
        } else {
            //Obtener las fechas ingresadas en el calendario
            $fechaInicio = date('Y-m-d', strtotime($request->input("calendarioInicio")));
            $fechaFin = date('Y-m-d', strtotime($request->input("calendarioFin")));

            $idproyectoPDF = $request->input("proyecto");
            //Extraer los proyectos de ls bd
            $proyectos = DB::table('proyectos')->select('proyectos.id', 'proyectos.nombre')
                ->where('proyectos.estado', '=', 1)
                ->where('proyectos.id', '!=', 1)
                ->orderBy('proyectos.id', 'asc')
                ->get();



            $nombres =  DB::table('proyectos')
                ->where('proyectos.estado', '=', 1)
                ->where('proyectos.id', '!=', 1)
                ->orderBy('proyectos.id', 'asc')
                ->get();
            $letra = $request->proyecto;

            //TOTAL PROYECTOS.
            $cantidad_equipo = DB::table('proyectos')->select('proyectos.cantidad_equipos')
                ->where('proyectos.estado', '=', 1)
                ->where('proyectos.id', '=', $letra)
                ->orderBy('proyectos.id', 'asc')
                ->get();

            // $f_inicio = Carbon::parse($request->fecha_inicio);
            // $f_fin = Carbon::parse($request->fecha_fin." 23:59:59");
            // ->whereBetween('deposito_mensuals.fecha_realizado', [$f_inicio, $f_fin])

            //extraer los datos de la tabla checklist
            $checkList = DB::table('checklist_instalacionsd')->select('checklist_instalacions.estado_inicio')
                ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
                ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio)
                ->where('checklist_instalacions.fecha_fin', '<=', $fechaFin)
                //  ->whereBetween()
                ->get();
            return $checkList;
            //total del checklist
            $contador_check = count($checkList);


            //extraer los datos de la tabla instalacion
            $instalaciontotal = DB::table('instalacions')->select('instalacions.id')
                ->where('instalacions.dFecha_instalacion', '>=', $fechaInicio, 'AND', '<=', $fechaFin)
                /*->where('instalacions.dFecha_instalacion','<=', $currentDateTime)*/
                ->orderBy('instalacions.id', 'asc')
                ->get();

            //total instalados total tabla
            $contador_instalacion_total = count($instalaciontotal);

            $totalproyecto =   $cantidad_equipo[0]->cantidad_equipos;
            //% Avance planificado
            $valor_instalacion = $contador_instalacion_total * 100 / $totalproyecto;
            //% Avance ejecutado
            // $ejecutadototal = $contador_instalacion * 100 / $totalproyecto;
            $ejecutadototal = $contador_check * 100 / $totalproyecto;
            //$desviacion = $contador_instalacion - $contador_instalacion_total;
            $desviacion = $contador_check - $contador_instalacion_total;
            $desviacion2 = $ejecutadototal - $valor_instalacion;
            $fechaConsultadaInicio = date('d-m-y', strtotime($fechaInicio));
            $fechaConsultadaFin = date('d-m-y', strtotime($fechaFin));

            //--------------- Reporte Tiempo de instalaciones ------
            //Extraer las fechas de inicio y finalizacion de la tabla checklist
            $checkListHora = DB::table('checklist_instalacions')->select('checklist_instalacions.fecha_inicio', 'checklist_instalacions.fecha_fin')
                ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
                ->whereNotNull('checklist_instalacions.fecha_inicio')
                ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio, 'AND', 'checklist_instalacions.fecha_fin', '<=', $fechaFin)
                ->get();
            //Crear Variable Auxiliar
            $totalDias = 0;
            $promedioM = 0;
            $promedioH = 0;
            $ContadorFinSemana = 0;
            $contador = 0;
            $totalH = 0;
            if ($contador_check > 0) {
                //Buscar en el rango fechaInicio/fechaFin si hay fines de semana
                foreach ($checkListHora as $item) {
                    $begin = new DateTime($item->fecha_inicio);
                    $end = new DateTime($item->fecha_fin);
                    $end = $end->modify('+1 day');
                    $interval = new DateInterval('P1D');
                    $daterange = new DatePeriod($begin, $interval, $end);

                    foreach ($daterange as $date) {
                        //Si hay fines de semana se suman 24 horas al contador
                        if (date('l', strtotime($date->format("d-m-Y"))) == 'Sunday' || date('l', strtotime($date->format("d-m-Y"))) == 'Saturday') {
                            $ContadorFinSemana += 24;
                        }
                    }
                    //se calcula la diferencia entre las 2 fechas
                    $fecha = new Carbon($item->fecha_inicio);
                    //Al total de horas se le restan las horas correspondientes a fines de semana 
                    $contador = round($fecha->diffInMinutes($item->fecha_fin) / 60) - $ContadorFinSemana;
                    if ($contador < 0) {
                        $contador *= -1;
                    }
                    while ($contador != 0) {
                        //Si el total de horas es mayor a 9 significa que se trabajo mas de un dia
                        //Se suman 9 horas al total de horas de trabajo
                        //Y se le restan las 24 horas al contador de horas para eliminar el dia que ya paso
                        if ($contador >= 9) {
                            $totalH += 9;
                            $contador -= 24;
                        } else {
                            $totalH += $contador;
                            $contador = 0;
                        }
                    }

                    //Calcular la diferencia de minutos entre las fechas
                    $fecha = new Carbon($item->fecha_fin);
                    $totalDias += $fecha->diffInDays($item->fecha_inicio);
                    $ContadorFinSemana = 0;
                    $contador = 0;
                }
                $totalHoras = $totalH;
                $totalMinutos = $totalH * 60;
                //Calcular los promedios
                if ($contador_check > 0) {
                    $promedioM = round($totalMinutos / $contador_check);
                    $promedioH = round($totalHoras / $contador_check);
                }
            }

            //Reporte Tiempo instalacion por sucursal
            $checkListSucursal = DB::table('checklist_instalacions')->select('checklist_instalacions.fecha_inicio', 'checklist_instalacions.fecha_fin', 'checklist_instalacions.Cscui')
                ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
                ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio, 'AND', 'checklist_instalacions.fecha_fin', '<=', $fechaFin)
                ->select(DB::raw("MIN(checklist_instalacions.fecha_inicio) AS fecha_inicio, MAX(checklist_instalacions.fecha_fin) AS fecha_fin, checklist_instalacions.Cscui"))
                ->groupBy('Cstipo_sucursal')
                ->get();


            //Reporte Tasa de efectividad
            //Extraer los datos de la tabla asignacion_instalacions
            $asignacionInstalacion = DB::table('asignacion_instalacions')->select('asignacion_instalacions.numero_visita')
                ->where('asignacion_instalacions.estado_asignacion', '=', 'finalizado')
                ->where('asignacion_instalacions.fecha_instalacion', '>=', $fechaInicio, 'AND', 'asignacion_instalacions.fecha_instalacion', '<=', $fechaFin)
                ->get();

            //Crear las variables
            //Obtener total de visitas
            $totalAsignacion = count($asignacionInstalacion);
            //Contar las instalaciones exitosas en la primera visita
            $contadorPrimeravisita = 0;
            foreach ($asignacionInstalacion as $item) {
                if ($item->numero_visita == 1) {
                    $contadorPrimeravisita += 1;
                }
            }
            //Obtener el porcentaje de efectividad
            $tasaDeInstalacion = 0;
            if ($totalAsignacion > 0) {
                $tasaDeInstalacion = round(($contadorPrimeravisita * 100) / $totalAsignacion);
            }
            //--------------------- Reporte de Status de proyecto por region ---------------
            //Obtener nombre de las regiones
            $reporteRegion = DB::table('instalacions')->select('instalacions.sRegion')
                ->orderBy('instalacions.sRegion')
                ->distinct('instalacions.sRegion')
                ->get();
            //Obtener nombre de las regiones y el estado de la instalacion
            $reporteRegionAux = DB::table('instalacions')->select('instalacions.sRegion', 'instalacions.sEstado_instalacion')
                ->orderBy('instalacions.sRegion')
                ->get();

            //----------------------- Reporte Accesorios ------------------------------------ 
            //Obtener datos de la tabla instalacions
            $reporteAccesorios = DB::table('instalacions')->select(
                'instalacions.sBandeja_adicional',
                'instalacions.sMueble',
                'instalacions.sSD',
                'instalacions.sCable_poder',
                'instalacions.sCable_red',
                'instalacions.sKit_lector'
            )
                ->get();

            //Contar los accesorios solicitados
            $contadorInstalacionSi = 0;
            $contadorBandejaI = 0;
            $contadorCableRedI = 0;
            $contadorCablePoderI = 0;
            $contadorMuebleI = 0;
            $contadorLectorI = 0;
            $contadorSDI = 0;

            foreach ($reporteAccesorios as $item) {
                if ($item->sBandeja_adicional == 'si' || $item->sBandeja_adicional == 'Si' || $item->sBandeja_adicional == '1') {
                    $contadorInstalacionSi += 1;
                    $contadorBandejaI += 1;
                }
                if ($item->sMueble == 'si' || $item->sMueble == 'Si' || $item->sMueble == '1') {
                    $contadorInstalacionSi += 1;
                    $contadorMuebleI += 1;
                }
                if ($item->sSD == 'si' || $item->sSD == 'Si' || $item->sSD == '1') {
                    $contadorInstalacionSi += 1;
                    $contadorSDI += 1;
                }
                if ($item->sCable_poder == 'si' || $item->sCable_poder == 'Si' || $item->sCable_poder == '1') {
                    $contadorInstalacionSi += 1;
                    $contadorCablePoderI += 1;
                }
                if ($item->sCable_red == 'si' || $item->sCable_red == 'Si' || $item->sCable_red == '1') {
                    $contadorInstalacionSi += 1;
                    $contadorCableRedI += 1;
                }
                if ($item->sKit_lector == 'si' || $item->sKit_lector == 'Si' || $item->sKit_lector == '1') {
                    $contadorInstalacionSi += 1;
                    $contadorLectorI += 1;
                }
            }

            //Obtener datos tabla checklist
            $checklistAccesorios = $checkListHora = DB::table('checklist_instalacions')->select(
                'checklist_instalacions.CsBandeja_adicional',
                'checklist_instalacions.CsMueble',
                'checklist_instalacions.CsSD',
                'checklist_instalacions.CsCable_poder',
                'checklist_instalacions.CsCable_red',
                'checklist_instalacions.CsKit_lector'
            )
                ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
                ->whereNotNull('checklist_instalacions.fecha_inicio')
                ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio, 'AND', 'checklist_instalacions.fecha_fin', '<=', $fechaFin)
                ->get();

            //Contar los accesorios solicitados
            $contadorCheckSi = 0;
            $contadorBandeja = 0;
            $contadorCableRed = 0;
            $contadorCablePoder = 0;
            $contadorMueble = 0;
            $contadorLector = 0;
            $contadorSD = 0;

            foreach ($checklistAccesorios as $item) {
                if ($item->CsBandeja_adicional == 'si' || $item->CsBandeja_adicional == 'Si' || $item->CsBandeja_adicional == '1') {
                    $contadorCheckSi += 1;
                    $contadorBandeja += 1;
                }
                if ($item->CsMueble == 'si' || $item->CsMueble == 'Si' || $item->CsMueble == '1') {
                    $contadorCheckSi += 1;
                    $contadorMueble += 1;
                }
                if ($item->CsSD == 'si' || $item->CsSD == 'Si' || $item->CsSD == '1') {
                    $contadorCheckSi += 1;
                    $contadorSD += 1;
                }
                if ($item->CsCable_poder == 'si' || $item->CsCable_poder == 'Si' || $item->CsCable_poder == '1') {
                    $contadorCheckSi += 1;
                    $contadorCablePoder += 1;
                }
                if ($item->CsCable_red == 'si' || $item->CsCable_red == 'Si' || $item->CsCable_red == '1') {
                    $contadorCheckSi += 1;
                    $contadorCableRed += 1;
                }
                if ($item->CsKit_lector == 'si' || $item->CsKit_lector == 'Si' || $item->CsKit_lector == '1') {
                    $contadorCheckSi += 1;
                    $contadorLector += 1;
                }
            }
            //---------------------- Crear una lista con los datos recopilados ---------------------
            $listaAccesorios = [
                "Bandeja Adicional" . "-" . $contadorBandeja . "-" . $contadorBandejaI,
                "Mueble" . "-" . $contadorMueble . "-" . $contadorMuebleI,
                "Memoria SD" . "-" . $contadorSD . "-" . $contadorSDI,
                "Cable de Poder" . "-" . $contadorCablePoder . "-" . $contadorCablePoderI,
                "Cable de Red" . "-" . $contadorCableRed . "-" . $contadorCableRedI,
                "Kit Lector" . "-" . $contadorLector . "-" . $contadorLectorI

            ];
            $coleccion = collect($listaAccesorios);

            //Devolver Datos a la vista
            return view('informes.informe', compact(
                'proyectos',
                'cantidad_equipo',
                'contador_instalacion_total',
                'valor_instalacion',
                'contador_check',
                'ejecutadototal',
                'desviacion',
                'desviacion2',
                'fechaInicio',
                'fechaFin',
                'nombres',
                'promedioM',
                'promedioH',
                'checkListSucursal',
                'totalAsignacion',
                'contadorPrimeravisita',
                'tasaDeInstalacion',
                'reporteRegion',
                'reporteRegionAux',
                'letra',
                'coleccion'
            ));
        }
    }
    function informedatosPDF_7noviembre(Request $request)
    {

        //Obtener las fechas ingresadas en el calendario
        $fechaInicio = date('Y-m-d', strtotime($request->input("fecha1pdf")));
        $fechaFin = date('Y-m-d', strtotime($request->input("fecha2pdf")));
        $validacion = 1;
        $letra = $request->input("idproyecto");
        //Extraer los proyectos de ls bd
        $proyectos = DB::table('proyectos')->select('proyectos.id', 'proyectos.nombre')
            ->where('proyectos.estado', '=', 1)
            ->where('proyectos.id', '!=', 1)
            ->orderBy('proyectos.id', 'asc')
            ->get();
        $nombres =  DB::table('proyectos')
            ->where('proyectos.estado', '=', 1)
            ->where('proyectos.id', '=', $letra)
            ->orderBy('proyectos.id', 'asc')
            ->get();


        //TOTAL PROYECTOS.
        $cantidad_equipo = DB::table('proyectos')->select('proyectos.cantidad_equipos')
            ->where('proyectos.estado', '=', 1)
            ->where('proyectos.id', '=', $letra)
            ->orderBy('proyectos.id', 'asc')
            ->get();

        //extraer los datos de la tabla checklist
        $checkList = DB::table('checklist_instalacions')->select('checklist_instalacions.estado_inicio')
            ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
            ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio, 'AND', 'checklist_instalacions.fecha_fin', '<=', $fechaFin)
            ->get();
        //total del checklist
        $contador_check = count($checkList);


        //extraer los datos de la tabla instalacion
        $instalaciontotal = DB::table('instalacions')->select('instalacions.id')
            ->where('instalacions.dFecha_instalacion', '>=', $fechaInicio, 'AND', '<=', $fechaFin)
            /*->where('instalacions.dFecha_instalacion','<=', $currentDateTime)*/
            ->orderBy('instalacions.id', 'asc')
            ->get();

        //total instalados total tabla
        $contador_instalacion_total = count($instalaciontotal);
        $totalproyecto =   $cantidad_equipo[0]->cantidad_equipos;
        //% Avance planificado
        $valor_instalacion = $contador_instalacion_total * 100 / $totalproyecto;
        //% Avance ejecutado

        // $ejecutadototal = $contador_instalacion * 100 / $totalproyecto;
        $ejecutadototal = $contador_check * 100 / $totalproyecto;
        //$desviacion = $contador_instalacion - $contador_instalacion_total;
        $desviacion = $contador_check - $contador_instalacion_total;
        $desviacion2 = $ejecutadototal - $valor_instalacion;

        $fechaConsultadaInicio = date('d-m-y', strtotime($fechaInicio));
        $fechaConsultadaFin = date('d-m-y', strtotime($fechaFin));

        //--------------- Reporte Tiempo de instalaciones ------
        //Extraer las fechas de inicio y finalizacion de la tabla checklist
        $checkListHora = DB::table('checklist_instalacions')->select('checklist_instalacions.fecha_inicio', 'checklist_instalacions.fecha_fin')
            ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
            ->whereNotNull('checklist_instalacions.fecha_inicio')
            ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio, 'AND', 'checklist_instalacions.fecha_fin', '<=', $fechaFin)
            ->get();
        //Crear Variable Auxiliar
        $totalDias = 0;
        $promedioM = 0;
        $promedioH = 0;
        $ContadorFinSemana = 0;
        $contador = 0;
        $totalH = 0;
        if ($contador_check > 0) {
            //Buscar en el rango fechaInicio/fechaFin si hay fines de semana
            foreach ($checkListHora as $item) {
                $begin = new DateTime($item->fecha_inicio);
                $end = new DateTime($item->fecha_fin);
                $end = $end->modify('+1 day');
                $interval = new DateInterval('P1D');
                $daterange = new DatePeriod($begin, $interval, $end);

                foreach ($daterange as $date) {
                    //Si hay fines de semana se suman 24 horas al contador
                    if (date('l', strtotime($date->format("d-m-Y"))) == 'Sunday' || date('l', strtotime($date->format("d-m-Y"))) == 'Saturday') {
                        $ContadorFinSemana += 24;
                    }
                }
                //se calcula la diferencia entre las 2 fechas
                $fecha = new Carbon($item->fecha_inicio);
                //Al total de horas se le restan las horas correspondientes a fines de semana 
                $contador = round($fecha->diffInMinutes($item->fecha_fin) / 60) - $ContadorFinSemana;
                if ($contador < 0) {
                    $contador *= -1;
                }
                while ($contador != 0) {
                    //Si el total de horas es mayor a 9 significa que se trabajo mas de un dia
                    //Se suman 9 horas al total de horas de trabajo
                    //Y se le restan las 24 horas al contador de horas para eliminar el dia que ya paso
                    if ($contador >= 9) {
                        $totalH += 9;
                        $contador -= 24;
                    } else {
                        $totalH += $contador;
                        $contador = 0;
                    }
                }

                //Calcular la diferencia de minutos entre las fechas
                $fecha = new Carbon($item->fecha_fin);
                $totalDias += $fecha->diffInDays($item->fecha_inicio);
                $ContadorFinSemana = 0;
                $contador = 0;
            }
            $totalHoras = $totalH;
            $totalMinutos = $totalH * 60;
            //Calcular los promedios
            $promedioM = round($totalMinutos / $contador_check);
            $promedioH = round($totalHoras / $contador_check);
        }

        //Reporte Tiempo instalacion por sucursal
        $checkListSucursal = DB::table('checklist_instalacions')->select('checklist_instalacions.fecha_inicio', 'checklist_instalacions.fecha_fin', 'checklist_instalacions.Cscui')
            ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
            ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio, 'AND', 'checklist_instalacions.fecha_fin', '<=', $fechaFin)
            ->select(DB::raw("MIN(checklist_instalacions.fecha_inicio) AS fecha_inicio, MAX(checklist_instalacions.fecha_fin) AS fecha_fin, checklist_instalacions.Cscui"))
            ->groupBy('Cstipo_sucursal')
            ->get();


        //Reporte Tasa de efectividad
        //Extraer los datos de la tabla asignacion_instalacions
        $asignacionInstalacion = DB::table('asignacion_instalacions')->select('asignacion_instalacions.numero_visita')
            ->where('asignacion_instalacions.estado_asignacion', '=', 'finalizado')
            ->where('asignacion_instalacions.fecha_instalacion', '>=', $fechaInicio, 'AND', 'asignacion_instalacions.fecha_instalacion', '<=', $fechaFin)
            ->get();

        //Crear las variables
        //Obtener total de visitas
        $totalAsignacion = count($asignacionInstalacion);
        //Contar las instalaciones exitosas en la primera visita
        $contadorPrimeravisita = 0;
        foreach ($asignacionInstalacion as $item) {
            if ($item->numero_visita == 1) {
                $contadorPrimeravisita += 1;
            }
        }
        //Obtener el porcentaje de efectividad
        $tasaDeInstalacion = round(($contadorPrimeravisita * 100) / $totalAsignacion);

        //--------------------- Reporte de Status de proyecto por region ---------------
        //Obtener nombre de las regiones
        $reporteRegion = DB::table('instalacions')->select('instalacions.sRegion')
            ->orderBy('instalacions.sRegion')
            ->distinct('instalacions.sRegion')
            ->get();
        //Obtener nombre de las regiones y el estado de la instalacion
        $reporteRegionAux = DB::table('instalacions')->select('instalacions.sRegion', 'instalacions.sEstado_instalacion')
            ->orderBy('instalacions.sRegion')
            ->get();

        //----------------------- Reporte Accesorios ------------------------------------ 
        //Obtener datos de la tabla instalacions
        $reporteAccesorios = DB::table('instalacions')->select(
            'instalacions.sBandeja_adicional',
            'instalacions.sMueble',
            'instalacions.sSD',
            'instalacions.sCable_poder',
            'instalacions.sCable_red',
            'instalacions.sKit_lector'
        )
            ->get();

        //Contar los accesorios solicitados
        $contadorInstalacionSi = 0;
        $contadorBandejaI = 0;
        $contadorCableRedI = 0;
        $contadorCablePoderI = 0;
        $contadorMuebleI = 0;
        $contadorLectorI = 0;
        $contadorSDI = 0;

        foreach ($reporteAccesorios as $item) {
            if ($item->sBandeja_adicional == 'si' || $item->sBandeja_adicional == 'Si' || $item->sBandeja_adicional == '1') {
                $contadorInstalacionSi += 1;
                $contadorBandejaI += 1;
            }
            if ($item->sMueble == 'si' || $item->sMueble == 'Si' || $item->sMueble == '1') {
                $contadorInstalacionSi += 1;
                $contadorMuebleI += 1;
            }
            if ($item->sSD == 'si' || $item->sSD == 'Si' || $item->sSD == '1') {
                $contadorInstalacionSi += 1;
                $contadorSDI += 1;
            }
            if ($item->sCable_poder == 'si' || $item->sCable_poder == 'Si' || $item->sCable_poder == '1') {
                $contadorInstalacionSi += 1;
                $contadorCablePoderI += 1;
            }
            if ($item->sCable_red == 'si' || $item->sCable_red == 'Si' || $item->sCable_red == '1') {
                $contadorInstalacionSi += 1;
                $contadorCableRedI += 1;
            }
            if ($item->sKit_lector == 'si' || $item->sKit_lector == 'Si' || $item->sKit_lector == '1') {
                $contadorInstalacionSi += 1;
                $contadorLectorI += 1;
            }
        }

        //Obtener datos tabla checklist
        $checklistAccesorios = $checkListHora = DB::table('checklist_instalacions')->select(
            'checklist_instalacions.CsBandeja_adicional',
            'checklist_instalacions.CsMueble',
            'checklist_instalacions.CsSD',
            'checklist_instalacions.CsCable_poder',
            'checklist_instalacions.CsCable_red',
            'checklist_instalacions.CsKit_lector'
        )
            ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
            ->whereNotNull('checklist_instalacions.fecha_inicio')
            ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio, 'AND', 'checklist_instalacions.fecha_fin', '<=', $fechaFin)
            ->get();

        //Contar los accesorios solicitados
        $contadorCheckSi = 0;
        $contadorBandeja = 0;
        $contadorCableRed = 0;
        $contadorCablePoder = 0;
        $contadorMueble = 0;
        $contadorLector = 0;
        $contadorSD = 0;

        foreach ($checklistAccesorios as $item) {
            if ($item->CsBandeja_adicional == 'si' || $item->CsBandeja_adicional == 'Si' || $item->CsBandeja_adicional == '1') {
                $contadorCheckSi += 1;
                $contadorBandeja += 1;
            }
            if ($item->CsMueble == 'si' || $item->CsMueble == 'Si' || $item->CsMueble == '1') {
                $contadorCheckSi += 1;
                $contadorMueble += 1;
            }
            if ($item->CsSD == 'si' || $item->CsSD == 'Si' || $item->CsSD == '1') {
                $contadorCheckSi += 1;
                $contadorSD += 1;
            }
            if ($item->CsCable_poder == 'si' || $item->CsCable_poder == 'Si' || $item->CsCable_poder == '1') {
                $contadorCheckSi += 1;
                $contadorCablePoder += 1;
            }
            if ($item->CsCable_red == 'si' || $item->CsCable_red == 'Si' || $item->CsCable_red == '1') {
                $contadorCheckSi += 1;
                $contadorCableRed += 1;
            }
            if ($item->CsKit_lector == 'si' || $item->CsKit_lector == 'Si' || $item->CsKit_lector == '1') {
                $contadorCheckSi += 1;
                $contadorLector += 1;
            }
        }
        //---------------------- Crear una lista con los datos recopilados ---------------------
        $listaAccesorios = [
            "Bandeja Adicional" . "-" . $contadorBandeja . "-" . $contadorBandejaI,
            "Mueble" . "-" . $contadorMueble . "-" . $contadorMuebleI,
            "Memoria SD" . "-" . $contadorSD . "-" . $contadorSDI,
            "Cable de Poder" . "-" . $contadorCablePoder . "-" . $contadorCablePoderI,
            "Cable de Red" . "-" . $contadorCableRed . "-" . $contadorCableRedI,
            "Kit Lector" . "-" . $contadorLector . "-" . $contadorLectorI

        ];
        $coleccion = collect($listaAccesorios);

        //Devolver Datos a la vista
        return \PDF::setOptions(['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true])
            ->loadView('informes.informe_pdf', compact(
                'validacion',
                'proyectos',
                'cantidad_equipo',
                'contador_instalacion_total',
                'valor_instalacion',
                'contador_check',
                'ejecutadototal',
                'desviacion',
                'desviacion2',
                'fechaInicio',
                'fechaFin',
                'nombres',
                'promedioM',
                'promedioH',
                'checkListSucursal',
                'totalAsignacion',
                'contadorPrimeravisita',
                'tasaDeInstalacion',
                'reporteRegion',
                'reporteRegionAux',
                'contadorCheckSi',
                'contadorInstalacionSi',
                'coleccion'
            ))
            ->stream();
    }
    function informedatosPDF_4noviembre(Request $request)
    {

        //Obtener las fechas ingresadas en el calendario
        $fechaInicio = date('Y-m-d', strtotime($request->input("fecha1pdf")));
        $fechaFin = date('Y-m-d', strtotime($request->input("fecha2pdf")));

        //Extraer los proyectos de ls bd
        $proyectos = DB::table('proyectos')->select('proyectos.id', 'proyectos.nombre')
            ->where('proyectos.estado', '=', 1)
            ->where('proyectos.id', '!=', 1)
            ->orderBy('proyectos.id', 'asc')
            ->get();
        $nombres =  DB::table('proyectos')
            ->where('proyectos.estado', '=', 1)
            ->where('proyectos.id', '!=', 1)
            ->orderBy('proyectos.id', 'asc')
            ->get();

        $letra = $request->input("idproyecto");
        //TOTAL PROYECTOS.
        $cantidad_equipo = DB::table('proyectos')->select('proyectos.cantidad_equipos')
            ->where('proyectos.estado', '=', 1)
            ->where('proyectos.id', '=', $letra)
            ->orderBy('proyectos.id', 'asc')
            ->get();

        //extraer los datos de la tabla checklist
        $checkList = DB::table('checklist_instalacions')->select('checklist_instalacions.estado_inicio')
            ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
            ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio, 'AND', 'checklist_instalacions.fecha_fin', '<=', $fechaFin)
            ->get();
        //total del checklist
        $contador_check = count($checkList);


        //extraer los datos de la tabla instalacion
        $instalaciontotal = DB::table('instalacions')->select('instalacions.id')
            ->where('instalacions.dFecha_instalacion', '>=', $fechaInicio, 'AND', '<=', $fechaFin)
            /*->where('instalacions.dFecha_instalacion','<=', $currentDateTime)*/
            ->orderBy('instalacions.id', 'asc')
            ->get();

        //total instalados total tabla
        $contador_instalacion_total = count($instalaciontotal);
        $totalproyecto =   $cantidad_equipo[0]->cantidad_equipos;
        //% Avance planificado
        $valor_instalacion = $contador_instalacion_total * 100 / $totalproyecto;
        //% Avance ejecutado

        // $ejecutadototal = $contador_instalacion * 100 / $totalproyecto;
        $ejecutadototal = $contador_check * 100 / $totalproyecto;
        //$desviacion = $contador_instalacion - $contador_instalacion_total;
        $desviacion = $contador_check - $contador_instalacion_total;
        $desviacion2 = $ejecutadototal - $valor_instalacion;

        $fechaConsultadaInicio = date('d-m-y', strtotime($fechaInicio));
        $fechaConsultadaFin = date('d-m-y', strtotime($fechaFin));

        //--------------- Reporte Tiempo de instalaciones ------
        //Extraer las fechas de inicio y finalizacion de la tabla checklist
        $checkListHora = DB::table('checklist_instalacions')->select('checklist_instalacions.fecha_inicio', 'checklist_instalacions.fecha_fin')
            ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
            ->whereNotNull('checklist_instalacions.fecha_inicio')
            ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio, 'AND', 'checklist_instalacions.fecha_fin', '<=', $fechaFin)
            ->get();
        //Crear Variable Auxiliar
        $totalDias = 0;
        $promedioM = 0;
        $promedioH = 0;
        $ContadorFinSemana = 0;
        $contador = 0;
        $totalH = 0;
        if ($contador_check > 0) {
            //Buscar en el rango fechaInicio/fechaFin si hay fines de semana
            foreach ($checkListHora as $item) {
                $begin = new DateTime($item->fecha_inicio);
                $end = new DateTime($item->fecha_fin);
                $end = $end->modify('+1 day');
                $interval = new DateInterval('P1D');
                $daterange = new DatePeriod($begin, $interval, $end);

                foreach ($daterange as $date) {
                    //Si hay fines de semana se suman 24 horas al contador
                    if (date('l', strtotime($date->format("d-m-Y"))) == 'Sunday' || date('l', strtotime($date->format("d-m-Y"))) == 'Saturday') {
                        $ContadorFinSemana += 24;
                    }
                }
                //se calcula la diferencia entre las 2 fechas
                $fecha = new Carbon($item->fecha_inicio);
                //Al total de horas se le restan las horas correspondientes a fines de semana 
                $contador = round($fecha->diffInMinutes($item->fecha_fin) / 60) - $ContadorFinSemana;
                if ($contador < 0) {
                    $contador *= -1;
                }
                while ($contador != 0) {
                    //Si el total de horas es mayor a 9 significa que se trabajo mas de un dia
                    //Se suman 9 horas al total de horas de trabajo
                    //Y se le restan las 24 horas al contador de horas para eliminar el dia que ya paso
                    if ($contador >= 9) {
                        $totalH += 9;
                        $contador -= 24;
                    } else {
                        $totalH += $contador;
                        $contador = 0;
                    }
                }

                //Calcular la diferencia de minutos entre las fechas
                $fecha = new Carbon($item->fecha_fin);
                $totalDias += $fecha->diffInDays($item->fecha_inicio);
                $ContadorFinSemana = 0;
                $contador = 0;
            }
            $totalHoras = $totalH;
            $totalMinutos = $totalH * 60;
            //Calcular los promedios
            $promedioM = round($totalMinutos / $contador_check);
            $promedioH = round($totalHoras / $contador_check);
        }

        //Reporte Tiempo instalacion por sucursal
        $checkListSucursal = DB::table('checklist_instalacions')->select('checklist_instalacions.fecha_inicio', 'checklist_instalacions.fecha_fin', 'checklist_instalacions.Cscui')
            ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
            ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio, 'AND', 'checklist_instalacions.fecha_fin', '<=', $fechaFin)
            ->select(DB::raw("MIN(checklist_instalacions.fecha_inicio) AS fecha_inicio, MAX(checklist_instalacions.fecha_fin) AS fecha_fin, checklist_instalacions.Cscui"))
            ->groupBy('Cstipo_sucursal')
            ->get();


        //Reporte Tasa de efectividad
        //Extraer los datos de la tabla asignacion_instalacions
        $asignacionInstalacion = DB::table('asignacion_instalacions')->select('asignacion_instalacions.numero_visita')
            ->where('asignacion_instalacions.estado_asignacion', '=', 'finalizado')
            ->where('asignacion_instalacions.fecha_instalacion', '>=', $fechaInicio, 'AND', 'asignacion_instalacions.fecha_instalacion', '<=', $fechaFin)
            ->get();

        //Crear las variables
        //Obtener total de visitas
        $totalAsignacion = count($asignacionInstalacion);
        //Contar las instalaciones exitosas en la primera visita
        $contadorPrimeravisita = 0;
        foreach ($asignacionInstalacion as $item) {
            if ($item->numero_visita == 1) {
                $contadorPrimeravisita += 1;
            }
        }
        //Obtener el porcentaje de efectividad
        $tasaDeInstalacion = round(($contadorPrimeravisita * 100) / $totalAsignacion);

        //--------------------- Reporte de Status de proyecto por region ---------------
        //Obtener nombre de las regiones
        $reporteRegion = DB::table('instalacions')->select('instalacions.sRegion')
            ->orderBy('instalacions.sRegion')
            ->distinct('instalacions.sRegion')
            ->get();
        //Obtener nombre de las regiones y el estado de la instalacion
        $reporteRegionAux = DB::table('instalacions')->select('instalacions.sRegion', 'instalacions.sEstado_instalacion')
            ->orderBy('instalacions.sRegion')
            ->get();

        //----------------------- Reporte Accesorios ------------------------------------ 
        //Obtener datos de la tabla instalacions
        $reporteAccesorios = DB::table('instalacions')->select(
            'instalacions.sBandeja_adicional',
            'instalacions.sMueble',
            'instalacions.sSD',
            'instalacions.sCable_poder',
            'instalacions.sCable_red',
            'instalacions.sKit_lector'
        )
            ->get();

        //Contar los accesorios solicitados
        $contadorInstalacionSi = 0;
        $contadorBandejaI = 0;
        $contadorCableRedI = 0;
        $contadorCablePoderI = 0;
        $contadorMuebleI = 0;
        $contadorLectorI = 0;
        $contadorSDI = 0;

        foreach ($reporteAccesorios as $item) {
            if ($item->sBandeja_adicional == 'si' || $item->sBandeja_adicional == 'Si' || $item->sBandeja_adicional == '1') {
                $contadorInstalacionSi += 1;
                $contadorBandejaI += 1;
            }
            if ($item->sMueble == 'si' || $item->sMueble == 'Si' || $item->sMueble == '1') {
                $contadorInstalacionSi += 1;
                $contadorMuebleI += 1;
            }
            if ($item->sSD == 'si' || $item->sSD == 'Si' || $item->sSD == '1') {
                $contadorInstalacionSi += 1;
                $contadorSDI += 1;
            }
            if ($item->sCable_poder == 'si' || $item->sCable_poder == 'Si' || $item->sCable_poder == '1') {
                $contadorInstalacionSi += 1;
                $contadorCablePoderI += 1;
            }
            if ($item->sCable_red == 'si' || $item->sCable_red == 'Si' || $item->sCable_red == '1') {
                $contadorInstalacionSi += 1;
                $contadorCableRedI += 1;
            }
            if ($item->sKit_lector == 'si' || $item->sKit_lector == 'Si' || $item->sKit_lector == '1') {
                $contadorInstalacionSi += 1;
                $contadorLectorI += 1;
            }
        }

        //Obtener datos tabla checklist
        $checklistAccesorios = $checkListHora = DB::table('checklist_instalacions')->select(
            'checklist_instalacions.CsBandeja_adicional',
            'checklist_instalacions.CsMueble',
            'checklist_instalacions.CsSD',
            'checklist_instalacions.CsCable_poder',
            'checklist_instalacions.CsCable_red',
            'checklist_instalacions.CsKit_lector'
        )
            ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
            ->whereNotNull('checklist_instalacions.fecha_inicio')
            ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio, 'AND', 'checklist_instalacions.fecha_fin', '<=', $fechaFin)
            ->get();

        //Contar los accesorios solicitados
        $contadorCheckSi = 0;
        $contadorBandeja = 0;
        $contadorCableRed = 0;
        $contadorCablePoder = 0;
        $contadorMueble = 0;
        $contadorLector = 0;
        $contadorSD = 0;

        foreach ($checklistAccesorios as $item) {
            if ($item->CsBandeja_adicional == 'si' || $item->CsBandeja_adicional == 'Si' || $item->CsBandeja_adicional == '1') {
                $contadorCheckSi += 1;
                $contadorBandeja += 1;
            }
            if ($item->CsMueble == 'si' || $item->CsMueble == 'Si' || $item->CsMueble == '1') {
                $contadorCheckSi += 1;
                $contadorMueble += 1;
            }
            if ($item->CsSD == 'si' || $item->CsSD == 'Si' || $item->CsSD == '1') {
                $contadorCheckSi += 1;
                $contadorSD += 1;
            }
            if ($item->CsCable_poder == 'si' || $item->CsCable_poder == 'Si' || $item->CsCable_poder == '1') {
                $contadorCheckSi += 1;
                $contadorCablePoder += 1;
            }
            if ($item->CsCable_red == 'si' || $item->CsCable_red == 'Si' || $item->CsCable_red == '1') {
                $contadorCheckSi += 1;
                $contadorCableRed += 1;
            }
            if ($item->CsKit_lector == 'si' || $item->CsKit_lector == 'Si' || $item->CsKit_lector == '1') {
                $contadorCheckSi += 1;
                $contadorLector += 1;
            }
        }
        //---------------------- Crear una lista con los datos recopilados ---------------------
        $listaAccesorios = [
            "Bandeja Adicional" . "-" . $contadorBandeja . "-" . $contadorBandejaI,
            "Mueble" . "-" . $contadorMueble . "-" . $contadorMuebleI,
            "Memoria SD" . "-" . $contadorSD . "-" . $contadorSDI,
            "Cable de Poder" . "-" . $contadorCablePoder . "-" . $contadorCablePoderI,
            "Cable de Red" . "-" . $contadorCableRed . "-" . $contadorCableRedI,
            "Kit Lector" . "-" . $contadorLector . "-" . $contadorLectorI

        ];
        $coleccion = collect($listaAccesorios);

        //Devolver Datos a la vista
        return \PDF::setOptions(['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true])
            ->loadView('informes.informe_pdf', compact(
                'proyectos',
                'cantidad_equipo',
                'contador_instalacion_total',
                'valor_instalacion',
                'contador_check',
                'ejecutadototal',
                'desviacion',
                'desviacion2',
                'fechaInicio',
                'fechaFin',
                'nombres',
                'promedioM',
                'promedioH',
                'checkListSucursal',
                'totalAsignacion',
                'contadorPrimeravisita',
                'tasaDeInstalacion',
                'reporteRegion',
                'reporteRegionAux',
                'contadorCheckSi',
                'contadorInstalacionSi',
                'coleccion'
            ))
            ->stream();
    }




    function old_informedatosPDF(Request $request)
    {

        //Obtener las fechas ingresadas en el calendario
        $fechaInicio = date($request->input("fecha1pdf"));
        $fechaFin = date($request->input("fecha2pdf"));

        //Extraer los proyectos de ls bd
        $proyectos = DB::table('proyectos')->select('proyectos.id', 'proyectos.nombre')
            ->where('proyectos.estado', '=', 1)
            ->where('proyectos.id', '!=', 1)
            ->orderBy('proyectos.id', 'asc')
            ->get();
        $nombres =  DB::table('proyectos')
            ->where('proyectos.estado', '=', 1)
            ->where('proyectos.id', '!=', 1)
            ->orderBy('proyectos.id', 'asc')
            ->get();

        $letra = $request->input("idproyecto");
        //TOTAL PROYECTOS.
        $cantidad_equipo = DB::table('proyectos')->select('proyectos.cantidad_equipos')
            ->where('proyectos.estado', '=', 1)
            ->where('proyectos.id', '=', $letra)
            ->orderBy('proyectos.id', 'asc')
            ->get();

        //extraer los datos de la tabla checklist
        $checkList = DB::table('checklist_instalacions')->select('checklist_instalacions.estado_inicio')
            ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
            ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio, 'AND', 'checklist_instalacions.fecha_fin', '<=', $fechaFin)
            ->get();
        //total del checklist
        $contador_check = count($checkList);


        //extraer los datos de la tabla instalacion
        $instalaciontotal = DB::table('instalacions')->select('instalacions.id')
            ->where('instalacions.dFecha_instalacion', '>=', $fechaInicio, 'AND', '<=', $fechaFin)
            /*->where('instalacions.dFecha_instalacion','<=', $currentDateTime)*/
            ->orderBy('instalacions.id', 'asc')
            ->get();

        //total instalados total tabla
        $contador_instalacion_total = count($instalaciontotal);
        $totalproyecto =   $cantidad_equipo[0]->cantidad_equipos;
        //% Avance planificado
        $valor_instalacion = $contador_instalacion_total * 100 / $totalproyecto;
        //% Avance ejecutado

        // $ejecutadototal = $contador_instalacion * 100 / $totalproyecto;
        $ejecutadototal = $contador_check * 100 / $totalproyecto;
        //$desviacion = $contador_instalacion - $contador_instalacion_total;
        $desviacion = $contador_check - $contador_instalacion_total;
        $desviacion2 = $ejecutadototal - $valor_instalacion;

        $fechaConsultadaInicio = date('d-m-y', strtotime($fechaInicio));
        $fechaConsultadaFin = date('d-m-y', strtotime($fechaFin));

        //--------------- Reporte Tiempo de instalaciones ------
        //Extraer las fechas de inicio y finalizacion de la tabla checklist
        $checkListHora = DB::table('checklist_instalacions')->select('checklist_instalacions.fecha_inicio', 'checklist_instalacions.fecha_fin')
            ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
            ->whereNotNull('checklist_instalacions.fecha_inicio')
            ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio, 'AND', 'checklist_instalacions.fecha_fin', '<=', $fechaFin)
            ->get();
        //Crear Variable Auxiliar
        $totalDias = 0;
        $promedioM = 0;
        $promedioH = 0;
        $ContadorFinSemana = 0;
        $contador = 0;
        $totalH = 0;
        if ($contador_check > 0) {
            //Buscar en el rango fechaInicio/fechaFin si hay fines de semana
            foreach ($checkListHora as $item) {
                $begin = new DateTime($item->fecha_inicio);
                $end = new DateTime($item->fecha_fin);
                $end = $end->modify('+1 day');
                $interval = new DateInterval('P1D');
                $daterange = new DatePeriod($begin, $interval, $end);

                foreach ($daterange as $date) {
                    //Si hay fines de semana se suman 24 horas al contador
                    if (date('l', strtotime($date->format("d-m-Y"))) == 'Sunday' || date('l', strtotime($date->format("d-m-Y"))) == 'Saturday') {
                        $ContadorFinSemana += 24;
                    }
                }
                //se calcula la diferencia entre las 2 fechas
                $fecha = new Carbon($item->fecha_inicio);
                //Al total de horas se le restan las horas correspondientes a fines de semana 
                $contador = round($fecha->diffInMinutes($item->fecha_fin) / 60) - $ContadorFinSemana;
                if ($contador < 0) {
                    $contador *= -1;
                }
                while ($contador != 0) {
                    //Si el total de horas es mayor a 9 significa que se trabajo mas de un dia
                    //Se suman 9 horas al total de horas de trabajo
                    //Y se le restan las 24 horas al contador de horas para eliminar el dia que ya paso
                    if ($contador >= 9) {
                        $totalH += 9;
                        $contador -= 24;
                    } else {
                        $totalH += $contador;
                        $contador = 0;
                    }
                }

                //Calcular la diferencia de minutos entre las fechas
                $fecha = new Carbon($item->fecha_fin);
                $totalDias += $fecha->diffInDays($item->fecha_inicio);
                $ContadorFinSemana = 0;
                $contador = 0;
            }
            $totalHoras = $totalH;
            $totalMinutos = $totalH * 60;
            //Calcular los promedios
            $promedioM = round($totalMinutos / $contador_check);
            $promedioH = round($totalHoras / $contador_check);
        }

        //Reporte Tiempo instalacion por sucursal
        $checkListSucursal = DB::table('checklist_instalacions')->select('checklist_instalacions.fecha_inicio', 'checklist_instalacions.fecha_fin', 'checklist_instalacions.Cscui')
            ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
            ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio, 'AND', 'checklist_instalacions.fecha_fin', '<=', $fechaFin)
            ->select(DB::raw("MIN(checklist_instalacions.fecha_inicio) AS fecha_inicio, MAX(checklist_instalacions.fecha_fin) AS fecha_fin, checklist_instalacions.Cscui"))
            ->groupBy('Cstipo_sucursal')
            ->get();


        //Reporte Tasa de efectividad
        //Extraer los datos de la tabla asignacion_instalacions
        $asignacionInstalacion = DB::table('asignacion_instalacions')->select('asignacion_instalacions.numero_visita')
            ->where('asignacion_instalacions.estado_asignacion', '=', 'finalizado')
            ->where('asignacion_instalacions.fecha_instalacion', '>=', $fechaInicio, 'AND', 'asignacion_instalacions.fecha_instalacion', '<=', $fechaFin)
            ->get();

        //Crear las variables
        //Obtener total de visitas
        $totalAsignacion = count($asignacionInstalacion);
        //Contar las instalaciones exitosas en la primera visita
        $contadorPrimeravisita = 0;
        foreach ($asignacionInstalacion as $item) {
            if ($item->numero_visita == 1) {
                $contadorPrimeravisita += 1;
            }
        }
        //Obtener el porcentaje de efectividad
        $tasaDeInstalacion = round(($contadorPrimeravisita * 100) / $totalAsignacion);

        //--------------------- Reporte de Status de proyecto por region ---------------
        //Obtener nombre de las regiones
        $reporteRegion = DB::table('instalacions')->select('instalacions.sRegion')
            ->orderBy('instalacions.sRegion')
            ->distinct('instalacions.sRegion')
            ->get();
        //Obtener nombre de las regiones y el estado de la instalacion
        $reporteRegionAux = DB::table('instalacions')->select('instalacions.sRegion', 'instalacions.sEstado_instalacion')
            ->orderBy('instalacions.sRegion')
            ->get();

        //----------------------- Reporte Accesorios ------------------------------------ 
        //Obtener datos de la tabla instalacions
        $reporteAccesorios = DB::table('instalacions')->select(
            'instalacions.sBandeja_adicional',
            'instalacions.sMueble',
            'instalacions.sSD',
            'instalacions.sCable_poder',
            'instalacions.sCable_red',
            'instalacions.sKit_lector'
        )->get();

        //Contar los accesorios solicitados
        $contadorInstalacionSi = 0;
        foreach ($reporteAccesorios as $item) {
            if ($item->sBandeja_adicional == 'si' || $item->sBandeja_adicional == 'Si') {
                $contadorInstalacionSi += 1;
            }
            if ($item->sMueble == 'si' || $item->sMueble == 'Si') {
                $contadorInstalacionSi += 1;
            }
            if ($item->sSD == 'si' || $item->sSD == 'Si') {
                $contadorInstalacionSi += 1;
            }
            if ($item->sCable_poder == 'si' || $item->sCable_poder == 'Si') {
                $contadorInstalacionSi += 1;
            }
            if ($item->sCable_red == 'si' || $item->sCable_red == 'Si') {
                $contadorInstalacionSi += 1;
            }
            if ($item->sKit_lector == 'si' || $item->sKit_lector == 'Si') {
                $contadorInstalacionSi += 1;
            }
        }

        //Obtener datos tabla checklist
        $checklistAccesorios = $checkListHora = DB::table('checklist_instalacions')->select(
            'checklist_instalacions.CsBandeja_adicional',
            'checklist_instalacions.CsMueble',
            'checklist_instalacions.CsSD',
            'checklist_instalacions.CsCable_poder',
            'checklist_instalacions.CsCable_red',
            'checklist_instalacions.CsKit_lector'
        )
            ->where('checklist_instalacions.estado_inicio', '=', 'finalizado')
            ->whereNotNull('checklist_instalacions.fecha_inicio')
            ->where('checklist_instalacions.fecha_inicio', '>=', $fechaInicio, 'AND', 'checklist_instalacions.fecha_fin', '<=', $fechaFin)
            ->get();

        //Contar los accesorios solicitados
        $contadorCheckSi = 0;

        foreach ($checklistAccesorios as $item) {
            if ($item->CsBandeja_adicional == 'si' || $item->CsBandeja_adicional == 'Si') {
                $contadorCheckSi += 1;
            }
            if ($item->CsMueble == 'si' || $item->CsMueble == 'Si') {
                $contadorCheckSi += 1;
            }
            if ($item->CsSD == 'si' || $item->CsSD == 'Si') {
                $contadorCheckSi += 1;
            }
            if ($item->CsCable_poder == 'si' || $item->CsCable_poder == 'Si') {
                $contadorCheckSi += 1;
            }
            if ($item->CsCable_red == 'si' || $item->CsCable_red == 'Si') {
                $contadorCheckSi += 1;
            }
            if ($item->CsKit_lector == 'si' || $item->CsKit_lector == 'Si') {
                $contadorCheckSi += 1;
            }
        }

        $accesoriosPorcentaje = round(($contadorCheckSi * 100) / $contadorInstalacionSi);
        $accesoriosPorcentaje = round(($contadorCheckSi * 100) / $contadorInstalacionSi);

        //Devolver Datos a la vista
        return \PDF::setOptions(['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true])
            ->loadView('informes.informe_pdf', compact(
                'proyectos',
                'cantidad_equipo',
                'contador_instalacion_total',
                'valor_instalacion',
                'contador_check',
                'ejecutadototal',
                'desviacion',
                'desviacion2',
                'fechaConsultadaInicio',
                'fechaConsultadaFin',
                'nombres',
                'promedioM',
                'promedioH',
                'checkListSucursal',
                'totalAsignacion',
                'contadorPrimeravisita',
                'tasaDeInstalacion',
                'reporteRegion',
                'reporteRegionAux',
                'contadorCheckSi',
                'contadorInstalacionSi',
                'accesoriosPorcentaje'
            ))
            ->stream();
    }



    //funcion estado equipo
    function estadoequipo(Request $request)
    {
        $proyectos = DB::table('proyectos')->select('proyectos.id', 'proyectos.nombre')
            ->where('proyectos.estado', '=', 1)
            ->where('proyectos.id', '!=', 1)
            ->orderBy('proyectos.id', 'asc')
            ->get();
        $informacion_retiro = ["1"]; //esto solo sirve para poder pasar la validacion y no mostrar el mensaje de faltan datos
        return view('check.EstadoEquipoRetiros', compact('proyectos', 'informacion_retiro'));
    }

    //funcion filtro tecnico
    function filtro_tecnicos(Request $request)
    {
        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();
        $id_trabajador = $datos_trabajador[0]->id;

        //Cargar Select Estado
        $estado_instalacion = DB::connection('comtecglobal')->table('asignacion_instalacions')
            ->select('asignacion_instalacions.tipo', 'estado_asignacion')
            ->where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador);

        $estado_retiros = DB::connection('comtecglobal')->table('asignacion_retiros')
            ->select('asignacion_retiros.tipo', 'estado_asignacion')
            ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->where('asignacion_retiros.estado_asignacion', '!=', "reasignar")
            ->union($estado_instalacion)
            ->distinct()
            ->get();

        //Cargar Select Estado
        $tipo_asignacion = DB::connection('kyocera')->table('asignacion_instalacions')
            ->select('asignacion_instalacions.tipo')
            ->where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador);

        $asignaciones = DB::connection('kyocera')->table('asignacion_retiros')
            ->select('asignacion_retiros.tipo')
            ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->union($tipo_asignacion)
            ->distinct()
            ->get();


        //Cargar comunas
        $comuna_instalacion = DB::connection('kyocera')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->select('checklist_instalacions.Cscomuna')
            ->where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador);

        $comuna_retiros = DB::connection('kyocera')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->select('checklist_retiros.Cscomuna')
            ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->union($comuna_instalacion)
            ->get();

        $where  = "asignacion_instalacions.trabajadors_id = " . "'" . $id_trabajador . "'";

        if ($request->fecha != "") {
            $where = $where . " and asignacion_instalacions.fecha_instalacion" . " = " . "'" . $request->fecha . "'";
        }
        if ($request->asignacion != "") {
            $where = $where . " and asignacion_instalacions.tipo = " . "'" . $request->asignacion . "'";
        }
        if ($request->estado != "") {
            $where = $where . " and  asignacion_instalacions.estado_asignacion = " . "'" . $request->estado . "'";
        }
        if ($request->serie != "") {
            $where = $where . " and  checklist_instalacions.CsSerie  = " . "'" . $request->serie . "'";
        }
        if ($request->serie != "") {
            $where = $where . " and  checklist_instalacions.CsSerie  = " . "'" . $request->serie . "'";
        }
        if ($request->comuna != "") {
            $where = $where . " and  checklist_instalacions.Cscomuna  = " . "'" . $request->comuna . "'";
        }

        //retiros
        $where_r = "asignacion_retiros.trabajadors_idtecnico = " . "'" . $id_trabajador . "'";

        if ($request->fecha != "") {
            $where_r  = $where_r . " and asignacion_retiros.fecha_asignado	" . " = " . "'" . $request->fecha . "'";
        }
        if ($request->asignacion != "") {
            $where_r  = $where_r . " and asignacion_retiros.tipo = " . "'" . $request->asignacion . "'";
        }
        if ($request->estado != "") {
            $where_r  = $where_r . " and  asignacion_retiros.estado_asignacion = " . "'" . $request->estado . "'";
        }
        if ($request->serie != "") {
            $where_r  = $where_r . " and  checklist_retiros.CsSerie  = " . "'" . $request->serie . "'";
        }
        if ($request->comuna != "") {
            $where_r = $where_r . " and  checklist_retiros.Cscomuna  = " . "'" . $request->comuna . "'";
        }

        $datos_asignacion = DB::connection('comtecglobal')->select(
            'SELECT  
                checklist_retiros.motivo_reasignado,
                checklist_retiros.CsSerie,
                checklist_retiros.csComuna,
                asignacion_retiros.fecha_retiro as fecha_visita,
                asignacion_retiros.motivo_rechazado,
                asignacion_retiros.tipo,checklist_retiros.id,
                checklist_retiros.Csdireccion,
                checklist_retiros.Cscliente,
                asignacion_retiros.estado_asignacion,
                asignacion_retiros.fecha_asignado as fecha_as,
                retiros.proveedor_retiro as proveedor
            FROM  
                asignacion_retiros
            INNER JOIN  
                checklist_retiros on checklist_retiros.asignacion_retiros_id = asignacion_retiros.id 
            INNER JOIN  
                retiros on retiros.id = asignacion_retiros.retiros_id 
            WHERE
                ' . $where_r  . " and  asignacion_retiros.estado_asignacion !=" . "'" . "finalizado" . "'" . " and asignacion_retiros.estado_asignacion !=" . "'" . "reasignar" . "'" .
                " union " .
                'SELECT
                checklist_instalacions.motivo_reasignado,
                checklist_instalacions.CsSerie,
                checklist_instalacions.csComuna,
                asignacion_instalacions.fecha_instalacion as fecha_visita,
                asignacion_instalacions.motivo_rechazado,
                asignacion_instalacions.tipo,
                asignacion_instalacions.id,
                checklist_instalacions.Csdireccion,
                checklist_instalacions.Cscliente,
                asignacion_instalacions.estado_asignacion,
                asignacion_instalacions.fecha_asignado as fecha_as,
                instalacions.proveedor_instalacion as proveedor
            FROM
                asignacion_instalacions
            INNER JOIN
                checklist_instalacions on checklist_instalacions.asignacion_instalacion_retiro_id = asignacion_instalacions.id 
            INNER JOIN  
                instalacions on instalacions.id = asignacion_instalacions.lista_instalacion_id 
            WHERE
                ' . $where . " and  asignacion_instalacions.estado_asignacion !=" . "'" . "finalizado" . "'"
        );

        $datos_asignacion2 = DB::connection('kyocera')->select(
            'SELECT  
                checklist_retiros.motivo_reasignado,
                checklist_retiros.CsSerie,
                checklist_retiros.csComuna,
                asignacion_retiros.fecha_retiro as fecha_visita,
                asignacion_retiros.motivo_rechazado,
                asignacion_retiros.tipo,checklist_retiros.id,
                checklist_retiros.Csdireccion,
                checklist_retiros.Cscliente,
                asignacion_retiros.estado_asignacion,
                asignacion_retiros.fecha_asignado as fecha_as,
                retiros.proveedor_retiro as proveedor
            FROM  
                asignacion_retiros
            INNER JOIN  
                checklist_retiros on checklist_retiros.asignacion_retiros_id = asignacion_retiros.id 
            INNER JOIN  
                retiros on retiros.id = asignacion_retiros.retiros_id 
            WHERE
                ' . $where_r  . " and  asignacion_retiros.estado_asignacion !=" . "'" . "finalizado" . "'" . " and asignacion_retiros.estado_asignacion !=" . "'" . "reasignar" . "'" .
                " union " .
                'SELECT
                checklist_instalacions.motivo_reasignado,
                checklist_instalacions.CsSerie,
                checklist_instalacions.csComuna,
                asignacion_instalacions.fecha_instalacion as fecha_visita,
                asignacion_instalacions.motivo_rechazado,
                asignacion_instalacions.tipo,
                asignacion_instalacions.id,
                checklist_instalacions.Csdireccion,
                checklist_instalacions.Cscliente,
                asignacion_instalacions.estado_asignacion,
                asignacion_instalacions.fecha_asignado as fecha_as,
                instalacions.proveedor_instalacion as proveedor
            FROM
                asignacion_instalacions
            INNER JOIN
                checklist_instalacions on checklist_instalacions.asignacion_instalacion_retiro_id = asignacion_instalacions.id 
            INNER JOIN  
                instalacions on instalacions.id = asignacion_instalacions.lista_instalacion_id 
            WHERE
                ' . $where . " and  asignacion_instalacions.estado_asignacion !=" . "'" . "finalizado" . "'"
        );

        return view('check.check_tecnico', compact('datos_asignacion2', 'datos_asignacion', 'estado_retiros', 'comuna_retiros', 'asignaciones'));
    }


    public function filtro_capacitacion(Request $request)
    {
        $id_persona = $request->tecnicos;
        $estado = $request->estado;
        $clientes = $request->clientes;
        $comuna = $request->comuna;
        $serie = $request->serie;
        $cui = $request->cui;
        $sucursal = $request->sucursal;
        $direccion = $request->direccion;
        $region = $request->region;
        $disable = "no";

        $fecha = "";
        $fecha2 = "";

        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();
        $id_trabajador = $datos_trabajador[0]->id;

        $where  = " instalacions.sDireccion != '' ";

        if ($request->datepicker != "" && $request->datepicker2 != "") {
            $fecha = Carbon::createFromDate($request->datepicker)->format('Y-m-d');
            $fecha2 = Carbon::createFromDate($request->datepicker2)->format('Y-m-d');
            $where = $where . " and asignacion_capacitaciones.fecha_capacitacion" . " BETWEEN " . "'" . $fecha . "'" . " and " . "'" . $fecha2 . "'";
        }
        if ($estado != "") {
            $where = $where . " and asignacion_capacitaciones.estado_capa" . " = " . "'" . $estado . "'";
        }
        if ($sucursal != "") {
            $where = $where . " and instalacions.sTipo_sucursal" . " = " . "'" . $sucursal . "'";
        }
        if ($direccion != "") {
            $where = $where . " and instalacions.sDireccion" . " = " . "'" . $direccion . "'";
        }
        if ($clientes != "") {
            if (strtolower(DB::connection()->getDatabaseName()) == "kyocera") {
                $nid_tracker = DB::table('instalacions')
                ->select('instalacions.nID_Tracker')
                ->where('instalacions.sCliente','=',$clientes)
                ->get();
                $where = $where . " and instalacions.nID_Tracker = " . "'" . $nid_tracker[0]->nID_Tracker . "'";
            }else{
                $where = $where . " and instalacions.sCliente = " . "'" . $clientes . "'";
            }
        }
        if ($comuna != "") {
            $where = $where . " and  instalacions.sComuna  = " . "'" . $comuna . "'";
        }
        if ($cui != "") {
            $where = $where . " and  instalacions.sCui  = " . "'" . $cui . "'";
        }
        //return $where;
        if ($id_persona != "") {

            $id_trabajador =  DB::table('trabajadors')
                ->select('trabajadors.id')
                ->where('trabajadors.id_persona', '=', $id_persona)
                ->get();

            $id_tra =  $id_trabajador[0]->id;

            $where = $where . " and  asignacion_capacitaciones.id_trabajador  = " . "'" . $id_tra . "'";

            $datos_instalacion = DB::select('select 
                instalacions.id,
                instalacions.sTipo_sucursal,
                asignacion_capacitaciones.id_trabajador as id_trabajador,
                instalacions.sCui,
                instalacions.sCliente,
                instalacions.sComuna,
                instalacions.sDireccion,
                asignacion_capacitaciones.estado_capa, 
                asignacion_capacitaciones.fecha_capacitacion,
                capacitacions.url_pdf,
                capacitacions.id as id_capacitacion
                from instalacions 
                left join asignacion_capacitaciones on asignacion_capacitaciones.direccion = instalacions.sDireccion
                left join capacitacions on capacitacions.id = asignacion_capacitaciones.id_capa  
                where ' . $where . " 
                group by instalacions.sDireccion order by asignacion_capacitaciones.fecha_capacitacion DESC ");
        } else {

            $datos_instalacion = DB::select('select 
                instalacions.id,
                instalacions.sTipo_sucursal,
                asignacion_capacitaciones.id_trabajador as id_trabajador,
                instalacions.sCui,
                instalacions.sCliente,
                instalacions.sComuna,
                instalacions.sDireccion,
                asignacion_capacitaciones.estado_capa, 
                asignacion_capacitaciones.fecha_capacitacion,
                capacitacions.url_pdf,
                capacitacions.id as id_capacitacion 
                from instalacions 
                left join asignacion_capacitaciones on asignacion_capacitaciones.direccion =  instalacions.sDireccion
                left join capacitacions on capacitacions.id = asignacion_capacitaciones.id_capa 
                where ' . $where . " 
                group by  instalacions.sDireccion order by asignacion_capacitaciones.fecha_capacitacion DESC ");
        }

        //obtener trabajadores asociados a checklist
        $tecnico = DB::table('asignacion_instalacions')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('trabajadors.estado', '=', '1')
            ->select('personas.nombre_uno', 'personas.apellido_uno', 'personas.id', 'trabajadors.id as id_trabajador')
            ->orderBy('personas.nombre_uno', 'asc')
            ->distinct()
            ->get();

        //Cargar Select Estado
        $carga_selectEstado = DB::table('asignacion_capacitaciones')
            ->select('asignacion_capacitaciones.estado_capa')
            ->distinct()
            ->get();

        //Cargar Select Clientes
        if (strtolower(DB::connection()->getDatabaseName()) == "kyocera") {
            $carga_selectClientes = DB::table('instalacions')
                ->select('instalacions.sCliente')
                ->groupBy('instalacions.nID_Tracker')
                ->orderBy('instalacions.sCliente', 'asc')
                ->distinct()
                ->get();
        }else{
            $carga_selectClientes = DB::table('instalacions')
            ->select('instalacions.sCliente')
            ->orderBy('instalacions.sCliente', 'asc')
            ->distinct()
            ->get();
        }

        //Cargar Select Comuna
        $carga_selectComuna =  DB::table('instalacions')
            ->leftJoin('asignacion_capacitaciones', 'asignacion_capacitaciones.cui', '=', 'instalacions.sCui')
            ->leftJoin('capacitacions', 'capacitacions.id', '=', 'asignacion_capacitaciones.id_capa')
            ->select(
                'instalacions.sComuna',
            )
            ->where('instalacions.sCui', '!=', null)
            ->groupBy('instalacions.sCui')
            ->orderBy('instalacions.sCliente', 'asc')
            ->where('instalacions.sRegion', '=', $region)
            ->distinct()
            ->get();

        //Cargar select Direccion
        $carga_selectDireccion = DB::table('instalacions')
            ->select('instalacions.sDireccion')
            ->where('instalacions.sComuna', '=', $comuna)
            ->distinct()
            ->get();

        //Cargar select Sucursal
        $carga_selectSucursal = DB::table('instalacions')
            ->select('instalacions.sTipo_sucursal')
            ->where('instalacions.sDireccion', '=', $direccion)

            ->distinct()
            ->get();

        $proyectos_sistema_propios = DB::table('proyectos')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->where('proyectos.estado', '=', '1')
            ->where('proyectos.id', '!=', '1')
            ->select('proyectos.nombre', 'clientes.razon_social', 'proyectos.id as id_proyecto')
            ->get();

        $capas = DB::table('capacitacions')
            ->orderBy('capacitacions.id', 'asc')
            ->get();
        $carga_selectRegion = DB::table('instalacions')
            ->select('instalacions.sRegion')
            ->where('instalacions.sRegion', '!=', null)
            //->orderByRaw("CAST(instalacions.sRegion as UNSIGNED) ASC")
            ->orderByRaw(DB::raw("FIELD(instalacions.sRegion,  1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17) ASC"))
            ->where('instalacions.sCliente', '=', $clientes)
            ->distinct()
            ->get();

        return view('capacitacion.capacitacioneshome', compact('region', 'carga_selectRegion', 'disable', 'sucursal', 'direccion', 'clientes', 'id_persona', 'estado', 'comuna', 'cui', 'fecha', 'fecha2', 'carga_selectDireccion', 'carga_selectSucursal', 'capas', 'datos_instalacion', 'tecnico', 'carga_selectComuna', 'carga_selectClientes', 'carga_selectEstado', 'proyectos_sistema_propios'));
    }



    ///ultimos controladores 2 de febrero 2021

    public function filtros_historial_retiro(Request $request)
    {

        $clientes = $request->clientes;
        $comuna = $request->comuna;
        $direccion = $request->direccion;
        $cuisucursal = $request->cuisucursal;




        $where  = "";



        if ($clientes == "" &&  $comuna == "" &&  $direccion == "" &&  $cuisucursal == "") {

            $datosretiro = DB::table('resumen_retiros')
                ->select(
                    'resumen_retiros.id',
                    'resumen_retiros.fecha_resumen',
                    'resumen_retiros.cantidad_bultos',
                    'resumen_retiros.suma_embalados',
                    'resumen_retiros.suma_sinembalar',
                    'resumen_retiros.cliente',
                    'resumen_retiros.comuna',
                    'resumen_retiros.url_pdf',
                    'resumen_retiros.direccion',
                    'resumen_retiros.cuisucursal',
                    'resumen_retiros.descripcion_motivo'
                )
                ->get();
        } else {

            if ($clientes != "") {

                if ($where == "") {
                    $where = $where . " resumen_retiros.proyectos_id = " . "'" . $clientes . "'";
                } else {
                    $where = $where . " and resumen_retiros.proyectos.id = " . "'" . $clientes . "'";
                }
            }
            if ($direccion != "") {

                if ($where == "") {
                    $where = $where . "  resumen_retiros.direccion  = " . "'" . $direccion . "'";
                } else {
                    $where = $where . " and  resumen_retiros.direccion  = " . "'" . $direccion . "'";
                }
            }
            if ($comuna != "") {

                if ($where == "") {
                    $where = $where . "  resumen_retiros.comuna  = " . "'" . $comuna . "'";
                } else {
                    $where = $where . " and  resumen_retiros.comuna  = " . "'" . $comuna . "'";
                }
            }
            if ($cuisucursal != "") {

                if ($where == "") {
                    $where = $where . "  resumen_retiros.cuisucursal  = " . "'" . $cuisucursal . "'";
                } else {
                    $where = $where . " and  resumen_retiros.cuisucursal  = " . "'" . $cuisucursal . "'";
                }
            }
            //var_dump($where);

            $datosretiro = DB::select('select 
        resumen_retiros.id,
        resumen_retiros.fecha_resumen,
        resumen_retiros.cantidad_bultos,
        resumen_retiros.suma_embalados,
        resumen_retiros.suma_sinembalar,
        resumen_retiros.cliente,
        resumen_retiros.comuna,
        resumen_retiros.direccion,
        resumen_retiros.cuisucursal,
        resumen_retiros.url_pdf,
        resumen_retiros.descripcion_motivo
        from resumen_retiros where ' . $where . "");
        }

        //Cargar Select Clientes
        $carga_selectCliente = DB::table('resumen_retiros')
            ->join('proyectos', 'proyectos.id', '=', 'resumen_retiros.proyectos_id')
            ->select('proyectos.nombre', 'proyectos.id')
            //->select('resumen_retiros.cliente')
            ->distinct()
            ->get();

        //Cargar Select Comuna
        $carga_selectComuna = DB::table('resumen_retiros')
            ->select('resumen_retiros.comuna')
            ->where('resumen_retiros.cliente', '=', $clientes)
            ->distinct()
            ->get();

        //Cargar Select Direccion
        $carga_selectDireccion = DB::table('resumen_retiros')
            ->select('resumen_retiros.direccion')
            ->where('resumen_retiros.comuna', '=', $comuna)

            ->distinct()
            ->get();

        //Cargar Select Sucursal
        $carga_selectSucursal = DB::table('resumen_retiros')
            ->select('resumen_retiros.cuisucursal')
            ->where('resumen_retiros.direccion', '=', $direccion)

            ->distinct()
            ->get();

        $disable = "no";

        return view('check.historial_retiro_coordinadora', compact('disable', 'cuisucursal', 'direccion', 'comuna', 'clientes', 'datosretiro', 'carga_selectCliente', 'carga_selectComuna', 'carga_selectDireccion', 'carga_selectSucursal'));
    }

    public function obtenerProyectosAsociados(request $request)
    {

        $idCliente = $request->idClientes;

        $proyectos = DB::table('proyectos')
            ->select("proyectos.nombre", "proyectos.id")
            ->orderBy('proyectos.nombre', 'asc')
            ->where("proyectos.clientes_id", "=", $idCliente)
            ->distinct()
            ->get();

        return  $proyectos;
    }
    public function siguiente_ver_checklist()
    {

        //Cargar Select Clientes
        $carga_selectClientes = DB::table('clientes')
            ->select('clientes.razon_social', 'clientes.id')
            ->orderBy('clientes.razon_social', 'asc')
            ->distinct()
            ->get();

        //Cargar Select Clientes
        $carga_selectClientesServicio = DB::table('api_solicitudes')
            ->select('api_solicitudes.sCliente')
            //->orderBy('api_solicitudessCliente', 'asc')
            ->where('api_solicitudes.sCliente', '!=', null)
            ->distinct()
            ->get();

        return view('check.intermedio_allchecklist', compact('carga_selectClientes', 'carga_selectClientesServicio'));
    }
    public function todosloschecklistservicio(request $request)
    {
        $servicios = DB::select('SELECT
            check_formulario_solicitudes.observaciones as observacion,
            asignacion_solicitudes.estado_interno as estado_asignacion,
            api_solicitudes.id,
            api_solicitudes.fecha_asignado as dFecha_instalacion,
            api_solicitudes.dFecha as fecha_registrado,
            asignacion_solicitudes.fecha_fin as fecha_termino,
            asignacion_solicitudes.fecha_local as fecha_instalacion,
            api_solicitudes.sCliente,
            api_solicitudes.sSC,
            api_solicitudes.sRegion,
            api_solicitudes.sComuna,
            api_solicitudes.sSerie,
            api_solicitudes.sDireccion,
            api_solicitudes.estado_interno as estado_final,
            personas.nombre_uno,
            personas.apellido_uno
            FROM
                api_solicitudes
            INNER JOIN
                asignacion_solicitudes
            ON
                asignacion_solicitudes.api_solicitudes_id = api_solicitudes.id
            INNER JOIN
                check_formulario_solicitudes
            ON
                check_formulario_solicitudes.id = asignacion_solicitudes.check_formulario_solicitudes_id
            INNER JOIN
                trabajadors
            ON
                trabajadors.id = asignacion_solicitudes.trabajadors_id
            INNER JOIN
                personas
            ON
                personas.id = trabajadors.id_persona
            ORDER BY
                fecha_termino
            DESC');
        //return $servicios;
        return view('solicitudes_servicios.ver_todoschecklistservicios', compact('servicios'));
    }
    public function todosloschecklist(request $request)
    {



        $proyectosSeleccionado = $request->proyectosSeleccionado;

        if ($proyectosSeleccionado == 0 || $request = null) {

            return back()->with('mensaje', 'Ingrese un proyecto asociado');
        } else {

            $instalaciones = DB::select('SELECT
            checklist_instalacions.Cscantidad_usuarios,
            checklist_instalacions.observacion,
            checklist_instalacions.Csserie_remplazo as remplazo,
            checklist_instalacions.Csserie_es as serie_salida,
            asignacion_instalacions.estado_asignacion,
            instalacions.id,
            instalacions.dFecha_instalacion,
            instalacions.fecha_registrado,
            instalacions.sEstado_despacho,
            asignacion_instalacions.fecha_termino,
            asignacion_instalacions.fecha_instalacion,
            instalacions.sCliente,
            instalacions.sRegion,
            instalacions.sComuna,
            instalacions.sSerie,
            instalacions.sDireccion,
            instalacions.fecha_registrado,
            instalacions.sEstado_instalacion,
            instalacions.fecha_instalacion_coordinadora,
            personas.nombre_uno,
            personas.apellido_uno
        FROM
            tracker
        INNER JOIN
            instalacions
        ON
            tracker.id = instalacions.tracker_idtracker
        INNER JOIN
            asignacion_instalacions
        ON
            asignacion_instalacions.lista_instalacion_id = instalacions.id
        INNER JOIN
            checklist_instalacions
        ON
            checklist_instalacions.asignacion_instalacion_retiro_id = asignacion_instalacions.id
        INNER JOIN
            trabajadors
        ON
            trabajadors.id = asignacion_instalacions.trabajadors_id
        INNER JOIN
            personas
        ON
            personas.id = trabajadors.id_persona
        WHERE
            tracker.tipo_tracker = "instalacion" AND tracker.estado_tracker = "activo" and tracker.proyecto_id =' . " '$proyectosSeleccionado '" . "" . '
        ORDER BY
            asignacion_instalacions.fecha_termino
        ASC limit 150');


            $proyectosSeleccionadoID = DB::table('proyectos')
                ->select('proyectos.id', 'proyectos.nombre')
                ->where('proyectos.id', "=", $proyectosSeleccionado)
                ->get();


            return view('check.ver_todoschecklist', compact('instalaciones', 'proyectosSeleccionadoID'));
        }
    }
    function actualizar_regiones(Request $request)
    {




        // $detalle = '[{"id": 6, "valor"=1},{"id": 3, "valor"=4}]';

        $detalle[0] = array(
            "letra" => "I",
            "valor" => "1",
        );
        $detalle[1] = array(
            "letra" => "i",
            "valor" => "1",
        );
        $detalle[2] = array(
            "letra" => "v",
            "valor" => "5",
        );
        $detalle[3] = array(
            "letra" => "vi",
            "valor" => "6",
        );
        $detalle[4] = array(
            "letra" => "xvi",
            "valor" => "16",
        );
        $detalle[5] = array(
            "letra" => "viii",
            "valor" => "8",
        );
        $detalle[6] = array(
            "letra" => "rm",
            "valor" => "13",
        );
        $detalle[7] = array(
            "letra" => "|x",
            "valor" => "9",
        );
        $detalle[8] = array(
            "letra" => "rg",
            "valor" => "13",
        );
        $detalle[9] = array(
            "letra" => "IX",
            "valor" => "9",
        );
        $detalle[10] = array(
            "letra" => "iX",
            "valor" => "9",
        );
        $detalle[11] = array(
            "letra" => "II",
            "valor" => "2",
        );


        $detalle[12] = array(
            "letra" => "Metropolitana",
            "valor" => "13",
        );
        $detalle[13] = array(
            "letra" => "METROPOLITANA",
            "valor" => "13",
        );
        $detalle[14] = array(
            "letra" => "RM",
            "valor" => "13",
        );
        $detalle[15] = array(
            "letra" => "rm",
            "valor" => "13",
        );

        $detalle[16] = array(
            "letra" => "Iii",
            "valor" => "3",
        );

        $detalle[17] = array(
            "letra" => "IV",
            "valor" => "4",
        );
        $detalle[18] = array(
            "letra" => "VII",
            "valor" => "7",
        );
        $detalle[19] = array(
            "letra" => "X",
            "valor" => "10",
        );

        $detalle[20] = array(
            "letra" => "XI",
            "valor" => "9",
        );
        $detalle[21] = array(
            "letra" => "XII",
            "valor" => "12",
        );
        $detalle[22] = array(
            "letra" => "XIV",
            "valor" => "14",
        );
        $detalle[23] = array(
            "letra" => "XV",
            "valor" => "15",
        );
        $detalle[] = array("letra" => "ANTOFAGASTA", "valor" => "2");
        $detalle[] = array("letra" => "ARICA", "valor" => "1");
        $detalle[] = array("letra" => "CHILLAN", "valor" => "16");
        $detalle[] = array("letra" => "CONCEPCION", "valor" => "8");
        $detalle[] = array("letra" => "COPIAPO", "valor" => "3");
        $detalle[] = array("letra" => "COYHAIQUE", "valor" => "11");
        $detalle[] = array("letra" => "IQUIQUE", "valor" => "1");
        $detalle[] = array("letra" => "LA SERENA", "valor" => "5");
        $detalle[] = array("letra" => "PUERTO MONTT", "valor" => "10");
        $detalle[] = array("letra" => "PUNTA ARENAS", "valor" => "12");
        $detalle[] = array("letra" => "RANCAGUA", "valor" => "6");
        $detalle[] = array("letra" => "REGIONAL VALPARAISO", "valor" => "5");
        $detalle[] = array("letra" => "SANTIAGO", "valor" => "13");
        $detalle[] = array("letra" => "TALCA", "valor" => "7");
        $detalle[] = array("letra" => "VALDIVIA", "valor" => "14");
        $detalle[] = array("letra" => "VALPARAISO", "valor" => "5");


















        foreach ($detalle as  $row) {
            //instalaciones
            $instalacions = DB::table('instalacions')
                ->select("instalacions.sRegion", "instalacions.id")
                ->where("instalacions.sRegion", "=", $row["letra"])
                ->get();

            foreach ($instalacions as $v1) {

                //actualizamos la lista de api insntalacion
                $instala =  App\instalacions::findOrfail($v1->id);
                $instala->sRegion = $row["valor"];
                $instala->timestamps = false;
                $instala->save();
            }

            //Retiros
            $retiros = DB::table('retiros')
                ->select("retiros.sRegion", "retiros.id")
                ->where("retiros.sRegion", "=", $row["letra"])
                ->get();

            foreach ($retiros as $v1) {

                //actualizamos la lista de api insntalacion
                $reti =  App\retiros::findOrfail($v1->id);
                $reti->sRegion = $row["valor"];
                $reti->timestamps = false;
                $reti->save();
            }
        }
        return "OK";
    }

    public function buscarComunas(request $request)
    {

        $carga_selectComuna = DB::table('instalacions')
            ->select('instalacions.sComuna')
            ->orderBy('instalacions.sComuna', 'asc')
            ->orderByRaw(DB::raw("FIELD(instalacions.sRegion, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17 ) ASC"))
            ->where("instalacions.sCliente", "=", $request->cliente)
            ->where("instalacions.sRegion", "=", $request->region)

            ->distinct()
            ->get();

        return $carga_selectComuna;
    }

    public function buscardirecciones(request $request)
    {

        $carga_selectComuna = DB::table('instalacions')
            ->select('instalacions.sDireccion')
            ->orderBy('instalacions.sDireccion', 'asc')
            ->where("instalacions.sCliente", "=", $request->cliente)

            // ->orderByRaw(DB::raw("FIELD(instalacions.sRegion, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17 ) ASC"))

            ->where("instalacions.sComuna", "=", $request->comuna)

            ->distinct()
            ->get();

        return $carga_selectComuna;
    }
    public function buscarsucursales(request $request)
    {

        $carga_selectComuna = DB::table('instalacions')
            ->select('instalacions.sTipo_sucursal')
            ->orderBy('instalacions.sTipo_sucursal', 'asc')
            // ->orderByRaw(DB::raw("FIELD(instalacions.sRegion, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17 ) ASC"))
            ->where("instalacions.sCliente", "=", $request->cliente)

            ->where("instalacions.sDireccion", "=", $request->direccion)

            ->distinct()
            ->get();

        return $carga_selectComuna;
    }
    ///RETIROSS
    public function buscarComunasRetiros(request $request)
    {

        $carga_selectComuna = DB::table('retiros')
            ->select('retiros.sComuna')
            ->orderByRaw(DB::raw("FIELD(retiros.sRegion, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17 ) ASC"))

            ->where("retiros.sRegion", "=", $request->region)

            ->distinct()
            ->get();

        return $carga_selectComuna;
    }

    public function buscardireccionesRetiro(request $request)
    {

        $carga_selectComuna = DB::table('retiros')
            ->select('retiros.sDireccion')
            ->orderBy('retiros.sDireccion', 'asc')
            // ->orderByRaw(DB::raw("FIELD(retiros.sRegion, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17 ) ASC"))

            ->where("retiros.sComuna", "=", $request->comuna)

            ->distinct()
            ->get();

        return $carga_selectComuna;
    }

    // CAPACITACIONES



    public function buscarRegionClientes(request $request)
    {

        $regiones = DB::table('instalacions')
            ->select('instalacions.sRegion')
            ->where("instalacions.sCliente", "=", $request->cliente)
            ->orderByRaw(DB::raw("FIELD(instalacions.sRegion, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17 ) ASC"))
            ->distinct()
            ->get();

        return $regiones;
    }

    public function buscarDireccionesRetiros(request $request)
    {

        $regiones = DB::table('retiros')
            ->select('retiros.sDireccion')
            // ->where("retiros.sDireccion","=",$request->cliente)
            ->where("retiros.sComuna", "=", $request->comuna)

            ->distinct()
            ->get();

        return $regiones;
    }
    ///RESUMENES RETIROSS

    public function comunasResumentesRetiros(request $request)
    {

        $carga_selectComuna = DB::table('resumen_retiros')
            ->select('resumen_retiros.comuna')
            ->where("resumen_retiros.proyectos_id", "=", $request->cliente)
            ->distinct()
            ->get();

        return $carga_selectComuna;
    }

    public function direccionesResumentesRetiros(request $request)
    {

        $carga_selectComuna = DB::table('resumen_retiros')
            ->select('resumen_retiros.direccion')
            ->where("resumen_retiros.proyectos_id", "=", $request->cliente)
            ->where("resumen_retiros.comuna", "=", $request->comuna)
            ->distinct()
            ->get();

        return $carga_selectComuna;
    }

    public function sucursalessResumentesRetiros(request $request)
    {

        $carga_selectComuna = DB::table('resumen_retiros')
            ->select('resumen_retiros.cuisucursal')
            ->where("resumen_retiros.proyectos_id", "=", $request->cliente)
            ->where("resumen_retiros.direccion", "=", $request->direccion)
            ->distinct()
            ->get();

        return $carga_selectComuna;
    }
    // ******

    public function buscarComunasRetirosPorCiudad(request $request)
    {

        $regiones = DB::table('capacitacions')
            ->select('capacitacions.comuna')
            ->where("capacitacions.ciudad", "=", $request->region)
            ->distinct()
            ->get();

        return $regiones;
    }

    public function buscarComunasCiudades(request $request)
    {

        $ciudades = DB::table('capacitacions')
            ->select('capacitacions.comuna')
            ->where("capacitacions.ciudad", "=", $request->region)
            ->distinct()
            ->get();

        return $ciudades;
    }

    public function buscarComunasCapacitaciones(request $request)
    {

        $direciones = DB::table('capacitacions')
            ->select('capacitacions.direccion')
            ->where("capacitacions.comuna", "=", $request->comuna)
            ->distinct()
            ->get();

        return $direciones;
    }
    public function buscarComunasResumenRetiro(request $request)
    {

        //Cargar Select Comuna
        $comunas = DB::table('resumen_retiros')
            ->select('resumen_retiros.comuna')
            ->where("resumen_retiros.ciudad", "=", $request->ciudad)
            ->distinct()
            ->get();

        return $comunas;
    }
    public function buscarDireccionResumenRetiro(request $request)
    {

        //Cargar Select Comuna
        $comunas = DB::table('resumen_retiros')
            ->select('resumen_retiros.direccion')
            ->where("resumen_retiros.comuna", "=", $request->comuna)
            ->distinct()
            ->get();

        return $comunas;
    }


    //informes graficos

    public function informes_graficos_menu(request $request)
    {
        //$tipo_proveedor = "";
        //$tipo_proveedor =  Auth::user()->nombre_proveedor;
        $tipo_proveedor = DB::connection()->getDatabaseName();

        $instalacions = DB::table('instalacions')
            ->select('instalacions.proveedor_instalacion')
            ->distinct()
            ->get();

        return view('graficos.graficossClientes', compact('instalacions', 'tipo_proveedor'));

        print_r($response);

        return $response;
    }
    // VISTA REPORTE
    public function ver_reportes()
    {

        return view('Apiviews.api_reportes');
    }

    // TABLA DE DATOS / FILTROS  
    public function tabla_reportes(request $request)
    {

        $tbody = "";
        $where = "";
        $opcion = $request->opcion;
        $fecha = "";
        $fecha2 = "";
        $resultado = $request->resultado;
        $serie = $request->serie;

        $tbody .= "<table class='table table-striped table-hover' id='mitable'>
    <thead class='color-head'>
      <tr>
        <th class='th-head border-th separador-v' colspan='1'>FILTROS</th>
        <th class='th-head border-th separador-v' colspan='1'>FILTRO SELECCIONADO</th>
        <th class='th-head border-th separador-v' colspan='1'>DATOS FILTRADOS</th>        
        <th class='th-head border-th separador-v' colspan='1'>TOTAL DE DATOS</th>
      </tr>
    </thead>";


        if ($request->fecha != null && $request->fecha2 != null) {

            $fecha = Carbon::createFromDate($request->fecha)->format('Y-m-d');
            $fecha2 = Carbon::createFromDate($request->fecha2)->format('Y-m-d');

            for ($i = 0; $i < sizeof($opcion); $i++) {
                if ($resultado[$i] == "instalacion") {
                    if ($where == "") {
                        $where .= "instalacions.fecha_instalacion_coordinadora" . " BETWEEN " . "'" . $fecha . "'" . " and " . "'" . $fecha2 . "'";
                    } else $where .= " and instalacions.fecha_instalacion_coordinadora" . " BETWEEN " . "'" . $fecha . "'" . " and " . "'" . $fecha2 . "'";
                } else if ($resultado[$i] == "capacitacion") {

                    if ($where == "") {
                        $where .= "asignacion_capacitaciones.fecha_capacitacion" . " BETWEEN " . "'" . $fecha . "'" . " and " . "'" . $fecha2 . "'";
                    } else $where .= " and asignacion_capacitaciones.fecha_capacitacion" . " BETWEEN " . "'" . $fecha . "'" . " and " . "'" . $fecha2 . "'";
                } else if ($resultado[$i] == "retiro") {

                    if ($where == "") {
                        $where .= "retiros.fecha_retiroCord" . " BETWEEN " . "'" . $fecha . "'" . " and " . "'" . $fecha2 . "'";
                    } else $where .= " and retiros.fecha_retiroCord" . " BETWEEN " . "'" . $fecha . "'" . " and " . "'" . $fecha2 . "'";
                }
            }
        }




        for ($i = 0; $i < sizeof($opcion); $i++) {
            if ($opcion[$i] == "tipo") {

                if ($resultado[$i] == "instalacion") {

                    $w = DB::table('instalacions')->count();
                    $w1 = DB::table('retiros')->count();
                    $w2 = DB::table('capacitacions')->count();

                    $w3 = $w;

                    $re = $w + $w1 + $w2;
                    $tbody .= "<tbody>";
                    $tbody .= "<td class='td-val'>Tipo de Atencion</td>";
                    $tbody .= "<td class='td-val'>Instalacion</td>";
                    $tbody .= "<td class='td-val'>" . $w . "</td>";
                    $tbody .= "<td class='td-val'>" . $re . "</td>";
                    $tbody .= "</tbody>";

                    for ($j = 0; $j < sizeof($opcion); $j++) {
                        if ($opcion[$j] == "estado") {

                            $tbody .= "<tbody>";
                            $tbody .= "<td class='td-val'>Estado</td>";
                            $tbody .= "<td class='td-val'>" . $resultado[$j] . "</td>";

                            if ($where == "") {
                                $where .= "instalacions.sEstado_instalacion" . " = " . "'" . $resultado[$j] . "'";
                                $w = DB::select('select

                    personas.nombre_uno,
                    personas.apellido_uno,
                    proyectos.nombre,
                    instalacions.sRegion,
                    instalacions.sTipo_sucursal,
                    instalacions.instalador,
                    instalacions.sCui,
                    instalacions.sEstado_instalacion,
                    instalacions.fecha_instalacion_coordinadora,
                    instalacions.id,
                    instalacions.dFecha_instalacion,
                    instalacions.fecha_registrado,
                    instalacions.sEstado_despacho,
                    instalacions.sCliente,
                    instalacions.sComuna,
                    instalacions.Csserie_remplazo,
                    instalacions.Csserie_es,
                    instalacions.sSerie,
                    instalacions.sDireccion,
                    instalacions.proveedor_instalacion
                from instalacions
                inner join asignacion_instalacions on instalacions.id = asignacion_instalacions.lista_instalacion_id
                inner join trabajadors on trabajadors.id = asignacion_instalacions.trabajadors_id
                inner join personas on personas.id = trabajadors.id_persona
                inner join tracker on tracker.id = instalacions.tracker_idtracker  
                inner join  proyectos on  proyectos.id = tracker.proyecto_id 
                where ' . $where . "
                group by  instalacions.sSerie order by instalacions.dFecha_instalacion asc ");

                                $tbody .= "<td class='td-val'>" . count($w) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";
                                $w3 = count($w);
                            } else {
                                $where .= " and instalacions.sEstado_instalacion" . " = " . "'" . $resultado[$j] . "'";
                                $w = DB::select('select

                    personas.nombre_uno,
                    personas.apellido_uno,
                    proyectos.nombre,
                    instalacions.sRegion,
                    instalacions.sTipo_sucursal,
                    instalacions.instalador,
                    instalacions.sCui,
                    instalacions.sEstado_instalacion,
                    instalacions.fecha_instalacion_coordinadora,
                    instalacions.id,
                    instalacions.dFecha_instalacion,
                    instalacions.fecha_registrado,
                    instalacions.sEstado_despacho,
                    instalacions.sCliente,
                    instalacions.sComuna,
                    instalacions.Csserie_remplazo,
                    instalacions.Csserie_es,
                    instalacions.sSerie,
                    instalacions.sDireccion,
                    instalacions.proveedor_instalacion
                from instalacions
                inner join asignacion_instalacions on instalacions.id = asignacion_instalacions.lista_instalacion_id
                inner join trabajadors on trabajadors.id = asignacion_instalacions.trabajadors_id
                inner join personas on personas.id = trabajadors.id_persona
                inner join tracker on tracker.id = instalacions.tracker_idtracker  
                inner join  proyectos on  proyectos.id = tracker.proyecto_id 
                where ' . $where . "
                group by  instalacions.sSerie order by instalacions.dFecha_instalacion asc ");


                                $tbody .= "<td class='td-val'>" . count($w) . "</td>";

                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";
                                $w3 = count($w);
                            }
                        } else if ($opcion[$j] == "region") {
                            $tbody .= "<tbody>";
                            $tbody .= "<td class='td-val'>Region</td>";
                            $tbody .= "<td class='td-val'>" . $resultado[$j] . "</td>";

                            if ($where == "") {
                                $where .= "instalacions.sRegion " . " = " . "'" . $resultado[$j] . "'";
                                $w = DB::select('select

                    personas.nombre_uno,
                    personas.apellido_uno,
                    proyectos.nombre,
                    instalacions.sRegion,
                    instalacions.sTipo_sucursal,
                    instalacions.instalador,
                    instalacions.sCui,
                    instalacions.sEstado_instalacion,
                    instalacions.fecha_instalacion_coordinadora,
                    instalacions.id,
                    instalacions.dFecha_instalacion,
                    instalacions.fecha_registrado,
                    instalacions.sEstado_despacho,
                    instalacions.sCliente,
                    instalacions.sComuna,
                    instalacions.Csserie_remplazo,
                    instalacions.Csserie_es,
                    instalacions.sSerie,
                    instalacions.sDireccion,
                    instalacions.proveedor_instalacion
                from instalacions
                inner join asignacion_instalacions on instalacions.id = asignacion_instalacions.lista_instalacion_id
                inner join trabajadors on trabajadors.id = asignacion_instalacions.trabajadors_id
                inner join personas on personas.id = trabajadors.id_persona
                inner join tracker on tracker.id = instalacions.tracker_idtracker  
                inner join  proyectos on  proyectos.id = tracker.proyecto_id 
                where ' . $where . "
                group by  instalacions.sSerie order by instalacions.dFecha_instalacion asc ");


                                $tbody .= "<td class='td-val'>" . count($w) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";

                                $w3 = count($w);
                            } else {
                                $where .= " and instalacions.sRegion " . " = " . "'" . $resultado[$j] . "'";
                                $w = DB::select('select

                    personas.nombre_uno,
                    personas.apellido_uno,
                    proyectos.nombre,
                    instalacions.sRegion,
                    instalacions.sTipo_sucursal,
                    instalacions.instalador,
                    instalacions.sCui,
                    instalacions.sEstado_instalacion,
                    instalacions.fecha_instalacion_coordinadora,
                    instalacions.id,
                    instalacions.dFecha_instalacion,
                    instalacions.fecha_registrado,
                    instalacions.sEstado_despacho,
                    instalacions.sCliente,
                    instalacions.sComuna,
                    instalacions.Csserie_remplazo,
                    instalacions.Csserie_es,
                    instalacions.sSerie,
                    instalacions.sDireccion,
                    instalacions.proveedor_instalacion
                from instalacions
                inner join asignacion_instalacions on instalacions.id = asignacion_instalacions.lista_instalacion_id
                inner join trabajadors on trabajadors.id = asignacion_instalacions.trabajadors_id
                inner join personas on personas.id = trabajadors.id_persona
                inner join tracker on tracker.id = instalacions.tracker_idtracker  
                inner join  proyectos on  proyectos.id = tracker.proyecto_id 
                where ' . $where . "
                group by  instalacions.sSerie order by instalacions.dFecha_instalacion asc ");


                                $tbody .= "<td class='td-val'>" . count($w) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";
                                $w3 = count($w);
                            }
                        } else if ($opcion[$j] == "comuna") {
                            $tbody .= "<tbody>";
                            $tbody .= "<td class='td-val'>Comuna</td>";
                            $tbody .= "<td class='td-val'>" . $resultado[$j] . "</td>";

                            if ($where == "") {
                                $where .= "instalacions.sComuna " . " = " . "'" . $resultado[$j] . "'";
                                $w = DB::select('select

                    personas.nombre_uno,
                    personas.apellido_uno,
                    proyectos.nombre,
                    instalacions.sRegion,
                    instalacions.sTipo_sucursal,
                    instalacions.instalador,
                    instalacions.sCui,
                    instalacions.sEstado_instalacion,
                    instalacions.fecha_instalacion_coordinadora,
                    instalacions.id,
                    instalacions.dFecha_instalacion,
                    instalacions.fecha_registrado,
                    instalacions.sEstado_despacho,
                    instalacions.sCliente,
                    instalacions.sComuna,
                    instalacions.Csserie_remplazo,
                    instalacions.Csserie_es,
                    instalacions.sSerie,
                    instalacions.sDireccion,
                    instalacions.proveedor_instalacion
                from instalacions
                inner join asignacion_instalacions on instalacions.id = asignacion_instalacions.lista_instalacion_id
                inner join trabajadors on trabajadors.id = asignacion_instalacions.trabajadors_id
                inner join personas on personas.id = trabajadors.id_persona
                inner join tracker on tracker.id = instalacions.tracker_idtracker  
                inner join  proyectos on  proyectos.id = tracker.proyecto_id 
                where ' . $where . "
                group by  instalacions.sSerie order by instalacions.dFecha_instalacion asc ");


                                $tbody .= "<td class='td-val'>" . count($w) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";

                                $w3 = count($w);
                            } else {
                                $where .= " and instalacions.sComuna " . " = " . "'" . $resultado[$j] . "'";
                                $w = DB::select('select

                    personas.nombre_uno,
                    personas.apellido_uno,
                    proyectos.nombre,
                    instalacions.sRegion,
                    instalacions.sTipo_sucursal,
                    instalacions.instalador,
                    instalacions.sCui,
                    instalacions.sEstado_instalacion,
                    instalacions.fecha_instalacion_coordinadora,
                    instalacions.id,
                    instalacions.dFecha_instalacion,
                    instalacions.fecha_registrado,
                    instalacions.sEstado_despacho,
                    instalacions.sCliente,
                    instalacions.sComuna,
                    instalacions.Csserie_remplazo,
                    instalacions.Csserie_es,
                    instalacions.sSerie,
                    instalacions.sDireccion,
                    instalacions.proveedor_instalacion
                from instalacions
                inner join asignacion_instalacions on instalacions.id = asignacion_instalacions.lista_instalacion_id
                inner join trabajadors on trabajadors.id = asignacion_instalacions.trabajadors_id
                inner join personas on personas.id = trabajadors.id_persona
                inner join tracker on tracker.id = instalacions.tracker_idtracker  
                inner join  proyectos on  proyectos.id = tracker.proyecto_id 
                where ' . $where . "
                group by  instalacions.sSerie order by instalacions.dFecha_instalacion asc ");


                                $tbody .= "<td class='td-val'>" . count($w) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";
                                $w3 = count($w);
                            }
                        } else if ($opcion[$j] == "proveedor") {


                            $tbody .= "<tbody>";
                            $tbody .= "<td class='td-val'>Proveedor</td>";
                            $tbody .= "<td class='td-val'>" . $resultado[$j] . "</td>";


                            if ($where == "") {
                                $where .= "instalacions.proveedor_instalacion " . " = " . "'" . $resultado[$j] . "'";

                                $w = DB::select('select

                    personas.nombre_uno,
                    personas.apellido_uno,
                    proyectos.nombre,
                    instalacions.sRegion,
                    instalacions.sTipo_sucursal,
                    instalacions.instalador,
                    instalacions.sCui,
                    instalacions.sEstado_instalacion,
                    instalacions.fecha_instalacion_coordinadora,
                    instalacions.id,
                    instalacions.dFecha_instalacion,
                    instalacions.fecha_registrado,
                    instalacions.sEstado_despacho,
                    instalacions.sCliente,
                    instalacions.sComuna,
                    instalacions.Csserie_remplazo,
                    instalacions.Csserie_es,
                    instalacions.sSerie,
                    instalacions.sDireccion,
                    instalacions.proveedor_instalacion
                from instalacions
                inner join asignacion_instalacions on instalacions.id = asignacion_instalacions.lista_instalacion_id
                inner join trabajadors on trabajadors.id = asignacion_instalacions.trabajadors_id
                inner join personas on personas.id = trabajadors.id_persona
                inner join tracker on tracker.id = instalacions.tracker_idtracker  
                inner join  proyectos on  proyectos.id = tracker.proyecto_id 
                where ' . $where . "
                group by  instalacions.sSerie order by instalacions.dFecha_instalacion asc ");


                                $tbody .= "<td class='td-val'>" . count($w) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";

                                $w3 = count($w);
                            } else {

                                $where .= " and instalacions.proveedor_instalacion " . " = " . "'" . $resultado[$j] . "'";
                                $w = DB::select('select

                        personas.nombre_uno,
                        personas.apellido_uno,
                        proyectos.nombre,
                        instalacions.sRegion,
                        instalacions.sTipo_sucursal,
                        instalacions.instalador,
                        instalacions.sCui,
                        instalacions.sEstado_instalacion,
                        instalacions.fecha_instalacion_coordinadora,
                        instalacions.id,
                        instalacions.dFecha_instalacion,
                        instalacions.fecha_registrado,
                        instalacions.sEstado_despacho,
                        instalacions.sCliente,
                        instalacions.sComuna,
                        instalacions.Csserie_remplazo,
                        instalacions.Csserie_es,
                        instalacions.sSerie,
                        instalacions.sDireccion,
                        instalacions.proveedor_instalacion
                    from instalacions
                    inner join asignacion_instalacions on instalacions.id = asignacion_instalacions.lista_instalacion_id
                    inner join trabajadors on trabajadors.id = asignacion_instalacions.trabajadors_id
                    inner join personas on personas.id = trabajadors.id_persona
                    inner join tracker on tracker.id = instalacions.tracker_idtracker  
                    inner join  proyectos on  proyectos.id = tracker.proyecto_id 
                    where ' . $where . "
                    group by  instalacions.sSerie order by instalacions.dFecha_instalacion asc ");


                                $tbody .= "<td class='td-val'>" . count($w) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";
                                $w3 = count($w);
                            }
                        } else if ($opcion[$j] == "sucursal") {
                            $tbody .= "<tbody>";
                            $tbody .= "<td class='td-val'>Sucursal</td>";
                            $tbody .= "<td class='td-val'>" . $resultado[$j] . "</td>";

                            if ($where == "") {
                                $where .= "instalacions.sTipo_sucursal " . " = " . "'" . $resultado[$j] . "'";
                                $w = DB::select('select

                    personas.nombre_uno,
                    personas.apellido_uno,
                    proyectos.nombre,
                    instalacions.sRegion,
                    instalacions.sTipo_sucursal,
                    instalacions.instalador,
                    instalacions.sCui,
                    instalacions.sEstado_instalacion,
                    instalacions.fecha_instalacion_coordinadora,
                    instalacions.id,
                    instalacions.dFecha_instalacion,
                    instalacions.fecha_registrado,
                    instalacions.sEstado_despacho,
                    instalacions.sCliente,
                    instalacions.sComuna,
                    instalacions.Csserie_remplazo,
                    instalacions.Csserie_es,
                    instalacions.sSerie,
                    instalacions.sDireccion,
                    instalacions.proveedor_instalacion
                from instalacions
                inner join asignacion_instalacions on instalacions.id = asignacion_instalacions.lista_instalacion_id
                inner join trabajadors on trabajadors.id = asignacion_instalacions.trabajadors_id
                inner join personas on personas.id = trabajadors.id_persona
                inner join tracker on tracker.id = instalacions.tracker_idtracker  
                inner join  proyectos on  proyectos.id = tracker.proyecto_id 
                where ' . $where . "
                group by  instalacions.sSerie order by instalacions.dFecha_instalacion asc ");


                                $tbody .= "<td class='td-val'>" . count($w) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";

                                $w3 = count($w);
                            } else {
                                $where .= " and instalacions.sTipo_sucursal " . " = " . "'" . $resultado[$j] . "'";
                                $w = DB::select('select

                    personas.nombre_uno,
                    personas.apellido_uno,
                    proyectos.nombre,
                    instalacions.sRegion,
                    instalacions.sTipo_sucursal,
                    instalacions.instalador,
                    instalacions.sCui,
                    instalacions.sEstado_instalacion,
                    instalacions.fecha_instalacion_coordinadora,
                    instalacions.id,
                    instalacions.dFecha_instalacion,
                    instalacions.fecha_registrado,
                    instalacions.sEstado_despacho,
                    instalacions.sCliente,
                    instalacions.sComuna,
                    instalacions.Csserie_remplazo,
                    instalacions.Csserie_es,
                    instalacions.sSerie,
                    instalacions.sDireccion,
                    instalacions.proveedor_instalacion
                from instalacions
                inner join asignacion_instalacions on instalacions.id = asignacion_instalacions.lista_instalacion_id
                inner join trabajadors on trabajadors.id = asignacion_instalacions.trabajadors_id
                inner join personas on personas.id = trabajadors.id_persona
                inner join tracker on tracker.id = instalacions.tracker_idtracker  
                inner join  proyectos on  proyectos.id = tracker.proyecto_id 
                where ' . $where . "
                group by  instalacions.sSerie order by instalacions.dFecha_instalacion asc ");


                                $tbody .= "<td class='td-val'>" . count($w) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";
                                $w3 = count($w);
                            }
                        } else if ($opcion[$j] == "direccion") {
                            $tbody .= "<tbody>";
                            $tbody .= "<td class='td-val'>Direccion</td>";
                            $tbody .= "<td class='td-val'>" . $resultado[$j] . "</td>";

                            if ($where == "") {
                                $where .= "instalacions.sDireccion " . " = " . "'" . $resultado[$j] . "'";
                                $w = DB::select('select

                    personas.nombre_uno,
                    personas.apellido_uno,
                    proyectos.nombre,
                    instalacions.sRegion,
                    instalacions.sTipo_sucursal,
                    instalacions.instalador,
                    instalacions.sCui,
                    instalacions.sEstado_instalacion,
                    instalacions.fecha_instalacion_coordinadora,
                    instalacions.id,
                    instalacions.dFecha_instalacion,
                    instalacions.fecha_registrado,
                    instalacions.sEstado_despacho,
                    instalacions.sCliente,
                    instalacions.sComuna,
                    instalacions.Csserie_remplazo,
                    instalacions.Csserie_es,
                    instalacions.sSerie,
                    instalacions.sDireccion,
                    instalacions.proveedor_instalacion
                from instalacions
                inner join asignacion_instalacions on instalacions.id = asignacion_instalacions.lista_instalacion_id
                inner join trabajadors on trabajadors.id = asignacion_instalacions.trabajadors_id
                inner join personas on personas.id = trabajadors.id_persona
                inner join tracker on tracker.id = instalacions.tracker_idtracker  
                inner join  proyectos on  proyectos.id = tracker.proyecto_id 
                where ' . $where . "
                group by  instalacions.sSerie order by instalacions.dFecha_instalacion asc ");


                                $tbody .= "<td class='td-val'>" . count($w) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";

                                $w3 = count($w);
                            } else {
                                $where .= " and instalacions.sDireccion " . " = " . "'" . $resultado[$j] . "'";
                                $w = DB::select('select

                    personas.nombre_uno,
                    personas.apellido_uno,
                    proyectos.nombre,
                    instalacions.sRegion,
                    instalacions.sTipo_sucursal,
                    instalacions.instalador,
                    instalacions.sCui,
                    instalacions.sEstado_instalacion,
                    instalacions.fecha_instalacion_coordinadora,
                    instalacions.id,
                    instalacions.dFecha_instalacion,
                    instalacions.fecha_registrado,
                    instalacions.sEstado_despacho,
                    instalacions.sCliente,
                    instalacions.sComuna,
                    instalacions.Csserie_remplazo,
                    instalacions.Csserie_es,
                    instalacions.sSerie,
                    instalacions.sDireccion,
                    instalacions.proveedor_instalacion
                from instalacions
                inner join asignacion_instalacions on instalacions.id = asignacion_instalacions.lista_instalacion_id
                inner join trabajadors on trabajadors.id = asignacion_instalacions.trabajadors_id
                inner join personas on personas.id = trabajadors.id_persona
                inner join tracker on tracker.id = instalacions.tracker_idtracker  
                inner join  proyectos on  proyectos.id = tracker.proyecto_id 
                where ' . $where . "
                group by  instalacions.sSerie order by instalacions.dFecha_instalacion asc ");


                                $tbody .= "<td class='td-val'>" . count($w) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";
                                $w3 = count($w);
                            }
                        } else if ($opcion[$j] == "cliente") {
                            $tbody .= "<tbody>";
                            $tbody .= "<td class='td-val'>Cliente</td>";
                            $tbody .= "<td class='td-val'>" . $resultado[$j] . "</td>";

                            if ($where == "") {
                                $where .= "instalacions.sCliente " . " = " . "'" . $resultado[$j] . "'";
                                $w = DB::select('select

                    personas.nombre_uno,
                    personas.apellido_uno,
                    proyectos.nombre,
                    instalacions.sRegion,
                    instalacions.sTipo_sucursal,
                    instalacions.instalador,
                    instalacions.sCui,
                    instalacions.sEstado_instalacion,
                    instalacions.fecha_instalacion_coordinadora,
                    instalacions.id,
                    instalacions.dFecha_instalacion,
                    instalacions.fecha_registrado,
                    instalacions.sEstado_despacho,
                    instalacions.sCliente,
                    instalacions.sComuna,
                    instalacions.Csserie_remplazo,
                    instalacions.Csserie_es,
                    instalacions.sSerie,
                    instalacions.sDireccion,
                    instalacions.proveedor_instalacion
                from instalacions
                inner join asignacion_instalacions on instalacions.id = asignacion_instalacions.lista_instalacion_id
                inner join trabajadors on trabajadors.id = asignacion_instalacions.trabajadors_id
                inner join personas on personas.id = trabajadors.id_persona
                inner join tracker on tracker.id = instalacions.tracker_idtracker  
                inner join  proyectos on  proyectos.id = tracker.proyecto_id 
                where ' . $where . "
                group by  instalacions.sSerie order by instalacions.dFecha_instalacion asc ");


                                $tbody .= "<td class='td-val'>" . count($w) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";

                                $w3 = count($w);
                            } else {
                                $where .= " and instalacions.sCliente " . " = " . "'" . $resultado[$j] . "'";
                                $w = DB::select('select

                    personas.nombre_uno,
                    personas.apellido_uno,
                    proyectos.nombre,
                    instalacions.sRegion,
                    instalacions.sTipo_sucursal,
                    instalacions.instalador,
                    instalacions.sCui,
                    instalacions.sEstado_instalacion,
                    instalacions.fecha_instalacion_coordinadora,
                    instalacions.id,
                    instalacions.dFecha_instalacion,
                    instalacions.fecha_registrado,
                    instalacions.sEstado_despacho,
                    instalacions.sCliente,
                    instalacions.sComuna,
                    instalacions.Csserie_remplazo,
                    instalacions.Csserie_es,
                    instalacions.sSerie,
                    instalacions.sDireccion,
                    instalacions.proveedor_instalacion
                from instalacions
                inner join asignacion_instalacions on instalacions.id = asignacion_instalacions.lista_instalacion_id
                inner join trabajadors on trabajadors.id = asignacion_instalacions.trabajadors_id
                inner join personas on personas.id = trabajadors.id_persona
                inner join tracker on tracker.id = instalacions.tracker_idtracker  
                inner join  proyectos on  proyectos.id = tracker.proyecto_id 
                where ' . $where . "
                group by  instalacions.sSerie order by instalacions.dFecha_instalacion asc ");


                                $tbody .= "<td class='td-val'>" . count($w) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";
                                $w3 = count($w);
                            }
                        } else if ($opcion[$j] == "tecnico") {

                            $tbody .= "<tbody>";
                            $tbody .= "<td class='td-val'>Tecnico</td>";

                            $nombre = DB::table('trabajadors')
                                ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
                                ->where('trabajadors.id_persona', '=', $resultado[$j])
                                ->select('personas.nombre_uno', 'personas.apellido_uno')
                                ->distinct()
                                ->get();

                            $id_trabajador =  DB::table('trabajadors')
                                ->select('trabajadors.id')
                                ->where('trabajadors.id_persona', '=', $resultado[$j])
                                ->get();

                            $id_tra =  $id_trabajador[0]->id;

                            $tbody .= "<td class='td-val'>" . $nombre[0]->nombre_uno . " " . $nombre[0]->apellido_uno . "</td>";

                            if ($where == "") {
                                $where .= "asignacion_instalacions.trabajadors_id " . " = " . "'" . $id_tra . "'";
                                $w = DB::select('select

                    personas.nombre_uno,
                    personas.apellido_uno,
                    proyectos.nombre,
                    instalacions.sRegion,
                    instalacions.sTipo_sucursal,
                    instalacions.instalador,
                    instalacions.sCui,
                    instalacions.sEstado_instalacion,
                    instalacions.fecha_instalacion_coordinadora,
                    instalacions.id,
                    instalacions.dFecha_instalacion,
                    instalacions.fecha_registrado,
                    instalacions.sEstado_despacho,
                    instalacions.sCliente,
                    instalacions.sComuna,
                    instalacions.Csserie_remplazo,
                    instalacions.Csserie_es,
                    instalacions.sSerie,
                    instalacions.sDireccion,
                    instalacions.proveedor_instalacion
                from instalacions
                inner join asignacion_instalacions on instalacions.id = asignacion_instalacions.lista_instalacion_id
                inner join trabajadors on trabajadors.id = asignacion_instalacions.trabajadors_id
                inner join personas on personas.id = trabajadors.id_persona
                inner join tracker on tracker.id = instalacions.tracker_idtracker  
                inner join  proyectos on  proyectos.id = tracker.proyecto_id 
                where ' . $where . "
                group by  instalacions.sSerie order by instalacions.dFecha_instalacion asc ");


                                $tbody .= "<td class='td-val'>" . count($w) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";

                                $w3 = count($w);
                            } else {
                                $where .= " and  asignacion_instalacions.trabajadors_id " . " = " . "'" . $id_tra . "'";
                                $w = DB::select('select

                    personas.nombre_uno,
                    personas.apellido_uno,
                    proyectos.nombre,
                    instalacions.sRegion,
                    instalacions.sTipo_sucursal,
                    instalacions.instalador,
                    instalacions.sCui,
                    instalacions.sEstado_instalacion,
                    instalacions.fecha_instalacion_coordinadora,
                    instalacions.id,
                    instalacions.dFecha_instalacion,
                    instalacions.fecha_registrado,
                    instalacions.sEstado_despacho,
                    instalacions.sCliente,
                    instalacions.sComuna,
                    instalacions.Csserie_remplazo,
                    instalacions.Csserie_es,
                    instalacions.sSerie,
                    instalacions.sDireccion,
                    instalacions.proveedor_instalacion
                from instalacions
                inner join asignacion_instalacions on instalacions.id = asignacion_instalacions.lista_instalacion_id
                inner join trabajadors on trabajadors.id = asignacion_instalacions.trabajadors_id
                inner join personas on personas.id = trabajadors.id_persona
                inner join tracker on tracker.id = instalacions.tracker_idtracker  
                inner join  proyectos on  proyectos.id = tracker.proyecto_id 
                where ' . $where . "
                group by  instalacions.sSerie order by instalacions.dFecha_instalacion asc ");


                                $tbody .= "<td class='td-val'>" . count($w) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";
                                $w3 = count($w);
                            }
                        }
                    }
                } else if ($resultado[$i] == "retiro") {

                    $w = DB::table('instalacions')->count();
                    $w1 = DB::table('retiros')->count();
                    $w2 = DB::table('capacitacions')->count();

                    $w3 = $w1;

                    $re = $w + $w1 + $w2;
                    $tbody .= "<tbody>";
                    $tbody .= "<td class='td-val'>Tipo de Atencion</td>";
                    $tbody .= "<td class='td-val'>Retiro</td>";
                    $tbody .= "<td class='td-val'>" . $w1 . "</td>";
                    $tbody .= "<td class='td-val'>" . $re . "</td>";
                    $tbody .= "</tbody>";

                    for ($j = 0; $j < sizeof($opcion); $j++) {
                        if ($opcion[$j] == "estado") {

                            $tbody .= "<tbody>";
                            $tbody .= "<td class='td-val'>Estado</td>";
                            $tbody .= "<td class='td-val'>" . $resultado[$j] . "</td>";

                            if ($where == "") {
                                $where .= "retiros.estado_retiro_Cord" . " = " . "'" . $resultado[$j] . "'";

                                $w1 = DB::select('select 

                            personas.nombre_uno,
                            personas.apellido_uno,
                            retiros.proveedor_retiro,
                            retiros.sEstado, 
                            retiros.estado_retiro_Cord,
                            retiros.fecha_retiroCord,
                            retiros.id,
                            retiros.estado_retiro_Cord,
                            retiros.sCliente,
                            retiros.sRegion,
                            retiros.sComuna,
                            retiros.sSerie,
                            retiros.sCui,
                            retiros.instalador,
                            retiros.sDireccion 
                        from retiros
                            inner join asignacion_retiros on asignacion_retiros.retiros_id = retiros.id 
                            inner join trabajadors on trabajadors.id = asignacion_retiros.trabajadors_idtecnico
                            inner join personas on personas.id = trabajadors.id_persona
                        where ' . $where . " 
                        group by  retiros.sSerie order by retiros.fecha_retiroCord asc ");

                                $tbody .= "<td class='td-val'>" . count($w1) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";
                                $w3 = count($w1);
                            } else {
                                $where .= " and retiros.sEstado" . " = " . "'" . $resultado[$j] . "'";

                                $w1 = DB::select('select 

                        personas.nombre_uno,
                        personas.apellido_uno,
                        retiros.proveedor_retiro,
                        retiros.sEstado, 
                        retiros.estado_retiro_Cord,
                        retiros.fecha_retiroCord,
                        retiros.id,
                        retiros.estado_retiro_Cord,
                        retiros.sCliente,
                        retiros.sRegion,
                        retiros.sComuna,
                        retiros.sSerie,
                        retiros.sCui,
                        retiros.instalador,
                        retiros.sDireccion 
                    from retiros
                        inner join asignacion_retiros on asignacion_retiros.retiros_id = retiros.id 
                        inner join trabajadors on trabajadors.id = asignacion_retiros.trabajadors_idtecnico
                        inner join personas on personas.id = trabajadors.id_persona
                    where ' . $where . " 
                    group by  retiros.sSerie order by retiros.fecha_retiroCord asc ");

                                $tbody .= "<td class='td-val'>" . count($w1) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";
                                $w3 = count($w1);
                            }
                        } else if ($opcion[$j] == "region") {

                            $tbody .= "<tbody>";
                            $tbody .= "<td class='td-val'>Region</td>";
                            $tbody .= "<td class='td-val'>" . $resultado[$j] . "</td>";

                            if ($where == "") {
                                $where .= "retiros.sRegion" . " = " . "'" . $resultado[$j] . "'";

                                $w1 = DB::select('select 

                            personas.nombre_uno,
                            personas.apellido_uno,
                            retiros.proveedor_retiro,
                            retiros.sEstado, 
                            retiros.estado_retiro_Cord,
                            retiros.fecha_retiroCord,
                            retiros.id,
                            retiros.estado_retiro_Cord,
                            retiros.sCliente,
                            retiros.sRegion,
                            retiros.sComuna,
                            retiros.sSerie,
                            retiros.sCui,
                            retiros.instalador,
                            retiros.sDireccion 
                        from retiros
                            inner join asignacion_retiros on asignacion_retiros.retiros_id = retiros.id 
                            inner join trabajadors on trabajadors.id = asignacion_retiros.trabajadors_idtecnico
                            inner join personas on personas.id = trabajadors.id_persona
                        where ' . $where . " 
                        group by  retiros.sSerie order by retiros.fecha_retiroCord asc ");

                                $tbody .= "<td class='td-val'>" . count($w1) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";
                                $w3 = count($w1);
                            } else {
                                $where .= " and retiros.sRegion" . " = " . "'" . $resultado[$j] . "'";

                                $w1 = DB::select('select 

                        personas.nombre_uno,
                        personas.apellido_uno,
                        retiros.proveedor_retiro,
                        retiros.sEstado, 
                        retiros.estado_retiro_Cord,
                        retiros.fecha_retiroCord,
                        retiros.id,
                        retiros.estado_retiro_Cord,
                        retiros.sCliente,
                        retiros.sRegion,
                        retiros.sComuna,
                        retiros.sSerie,
                        retiros.sCui,
                        retiros.instalador,
                        retiros.sDireccion 
                    from retiros
                        inner join asignacion_retiros on asignacion_retiros.retiros_id = retiros.id 
                        inner join trabajadors on trabajadors.id = asignacion_retiros.trabajadors_idtecnico
                        inner join personas on personas.id = trabajadors.id_persona
                    where ' . $where . " 
                    group by  retiros.sSerie order by retiros.fecha_retiroCord asc ");

                                $tbody .= "<td class='td-val'>" . count($w1) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";
                                $w3 = count($w1);
                            }
                        } else if ($opcion[$j] == "comuna") {

                            $tbody .= "<tbody>";
                            $tbody .= "<td class='td-val'>Comuna</td>";
                            $tbody .= "<td class='td-val'>" . $resultado[$j] . "</td>";

                            if ($where == "") {
                                $where .= "retiros.sComuna" . " = " . "'" . $resultado[$j] . "'";

                                $w1 = DB::select('select 

                            personas.nombre_uno,
                            personas.apellido_uno,
                            retiros.proveedor_retiro,
                            retiros.sEstado, 
                            retiros.estado_retiro_Cord,
                            retiros.fecha_retiroCord,
                            retiros.id,
                            retiros.estado_retiro_Cord,
                            retiros.sCliente,
                            retiros.sRegion,
                            retiros.sComuna,
                            retiros.sSerie,
                            retiros.sCui,
                            retiros.instalador,
                            retiros.sDireccion 
                        from retiros
                            inner join asignacion_retiros on asignacion_retiros.retiros_id = retiros.id 
                            inner join trabajadors on trabajadors.id = asignacion_retiros.trabajadors_idtecnico
                            inner join personas on personas.id = trabajadors.id_persona
                        where ' . $where . " 
                        group by  retiros.sSerie order by retiros.fecha_retiroCord asc ");

                                $tbody .= "<td class='td-val'>" . count($w1) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";
                                $w3 = count($w1);
                            } else {
                                $where .= " and retiros.sComuna" . " = " . "'" . $resultado[$j] . "'";

                                $w1 = DB::select('select 

                        personas.nombre_uno,
                        personas.apellido_uno,
                        retiros.proveedor_retiro,
                        retiros.sEstado, 
                        retiros.estado_retiro_Cord,
                        retiros.fecha_retiroCord,
                        retiros.id,
                        retiros.estado_retiro_Cord,
                        retiros.sCliente,
                        retiros.sRegion,
                        retiros.sComuna,
                        retiros.sSerie,
                        retiros.sCui,
                        retiros.instalador,
                        retiros.sDireccion 
                    from retiros
                        inner join asignacion_retiros on asignacion_retiros.retiros_id = retiros.id 
                        inner join trabajadors on trabajadors.id = asignacion_retiros.trabajadors_idtecnico
                        inner join personas on personas.id = trabajadors.id_persona
                    where ' . $where . " 
                    group by  retiros.sSerie order by retiros.fecha_retiroCord asc ");

                                $tbody .= "<td class='td-val'>" . count($w1) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";
                                $w3 = count($w1);
                            }
                        } else if ($opcion[$j] == "proveedor") {

                            $tbody .= "<tbody>";
                            $tbody .= "<td class='td-val'>Proveedor</td>";
                            $tbody .= "<td class='td-val'>" . $resultado[$j] . "</td>";

                            if ($where == "") {
                                $where .= "retiros.proveedor_retiro" . " = " . "'" . $resultado[$j] . "'";

                                $w1 = DB::select('select 

                            personas.nombre_uno,
                            personas.apellido_uno,
                            retiros.proveedor_retiro,
                            retiros.sEstado, 
                            retiros.estado_retiro_Cord,
                            retiros.fecha_retiroCord,
                            retiros.id,
                            retiros.estado_retiro_Cord,
                            retiros.sCliente,
                            retiros.sRegion,
                            retiros.sComuna,
                            retiros.sSerie,
                            retiros.sCui,
                            retiros.instalador,
                            retiros.sDireccion 
                        from retiros
                            inner join asignacion_retiros on asignacion_retiros.retiros_id = retiros.id 
                            inner join trabajadors on trabajadors.id = asignacion_retiros.trabajadors_idtecnico
                            inner join personas on personas.id = trabajadors.id_persona
                        where ' . $where . " 
                        group by  retiros.sSerie order by retiros.fecha_retiroCord asc ");

                                $tbody .= "<td class='td-val'>" . count($w1) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";
                                $w3 = count($w1);
                            } else {
                                $where .= " and retiros.proveedor_retiro" . " = " . "'" . $resultado[$j] . "'";

                                $w1 = DB::select('select 

                        personas.nombre_uno,
                        personas.apellido_uno,
                        retiros.proveedor_retiro,
                        retiros.sEstado, 
                        retiros.estado_retiro_Cord,
                        retiros.fecha_retiroCord,
                        retiros.id,
                        retiros.estado_retiro_Cord,
                        retiros.sCliente,
                        retiros.sRegion,
                        retiros.sComuna,
                        retiros.sSerie,
                        retiros.sCui,
                        retiros.instalador,
                        retiros.sDireccion 
                    from retiros
                        inner join asignacion_retiros on asignacion_retiros.retiros_id = retiros.id 
                        inner join trabajadors on trabajadors.id = asignacion_retiros.trabajadors_idtecnico
                        inner join personas on personas.id = trabajadors.id_persona
                    where ' . $where . " 
                    group by  retiros.sSerie order by retiros.fecha_retiroCord asc ");

                                $tbody .= "<td class='td-val'>" . count($w1) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";
                                $w3 = count($w1);
                            }
                        } else if ($opcion[$j] == "sucursal") {
                            if ($where == "") {
                                $where .= "";
                            } else
                                $where .= "";
                        } else if ($opcion[$j] == "direccion") {

                            $tbody .= "<tbody>";
                            $tbody .= "<td class='td-val'>Direccion</td>";
                            $tbody .= "<td class='td-val'>" . $resultado[$j] . "</td>";

                            if ($where == "") {
                                $where .= "retiros.sDireccion" . " = " . "'" . $resultado[$j] . "'";

                                $w1 = DB::select('select 

                            personas.nombre_uno,
                            personas.apellido_uno,
                            retiros.proveedor_retiro,
                            retiros.sEstado, 
                            retiros.estado_retiro_Cord,
                            retiros.fecha_retiroCord,
                            retiros.id,
                            retiros.estado_retiro_Cord,
                            retiros.sCliente,
                            retiros.sRegion,
                            retiros.sComuna,
                            retiros.sSerie,
                            retiros.sCui,
                            retiros.instalador,
                            retiros.sDireccion 
                        from retiros
                            inner join asignacion_retiros on asignacion_retiros.retiros_id = retiros.id 
                            inner join trabajadors on trabajadors.id = asignacion_retiros.trabajadors_idtecnico
                            inner join personas on personas.id = trabajadors.id_persona
                        where ' . $where . " 
                        group by  retiros.sSerie order by retiros.fecha_retiroCord asc ");

                                $tbody .= "<td class='td-val'>" . count($w1) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";
                                $w3 = count($w1);
                            } else {
                                $where .= " and retiros.sDireccion" . " = " . "'" . $resultado[$j] . "'";
                                $w1 = DB::select('select 

                        personas.nombre_uno,
                        personas.apellido_uno,
                        retiros.proveedor_retiro,
                        retiros.sEstado, 
                        retiros.estado_retiro_Cord,
                        retiros.fecha_retiroCord,
                        retiros.id,
                        retiros.estado_retiro_Cord,
                        retiros.sCliente,
                        retiros.sRegion,
                        retiros.sComuna,
                        retiros.sSerie,
                        retiros.sCui,
                        retiros.instalador,
                        retiros.sDireccion 
                    from retiros
                        inner join asignacion_retiros on asignacion_retiros.retiros_id = retiros.id 
                        inner join trabajadors on trabajadors.id = asignacion_retiros.trabajadors_idtecnico
                        inner join personas on personas.id = trabajadors.id_persona
                    where ' . $where . " 
                    group by  retiros.sSerie order by retiros.fecha_retiroCord asc ");

                                $tbody .= "<td class='td-val'>" . count($w1) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";
                                $w3 = count($w1);
                            }
                        } else if ($opcion[$j] == "cliente") {

                            $tbody .= "<tbody>";
                            $tbody .= "<td class='td-val'>Cliente</td>";
                            $tbody .= "<td class='td-val'>" . $resultado[$j] . "</td>";
                            if ($where == "") {
                                $where .= "retiros.sCliente" . " = " . "'" . $resultado[$j] . "'";
                                $w1 = DB::select('select 

                            personas.nombre_uno,
                            personas.apellido_uno,
                            retiros.proveedor_retiro,
                            retiros.sEstado, 
                            retiros.estado_retiro_Cord,
                            retiros.fecha_retiroCord,
                            retiros.id,
                            retiros.estado_retiro_Cord,
                            retiros.sCliente,
                            retiros.sRegion,
                            retiros.sComuna,
                            retiros.sSerie,
                            retiros.sCui,
                            retiros.instalador,
                            retiros.sDireccion 
                        from retiros
                            inner join asignacion_retiros on asignacion_retiros.retiros_id = retiros.id 
                            inner join trabajadors on trabajadors.id = asignacion_retiros.trabajadors_idtecnico
                            inner join personas on personas.id = trabajadors.id_persona
                        where ' . $where . " 
                        group by  retiros.sSerie order by retiros.fecha_retiroCord asc ");

                                $tbody .= "<td class='td-val'>" . count($w1) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";
                                $w3 = count($w1);
                            } else {
                                $where .= " and retiros.sCliente" . " = " . "'" . $resultado[$j] . "'";

                                $w1 = DB::select('select 

                        personas.nombre_uno,
                        personas.apellido_uno,
                        retiros.proveedor_retiro,
                        retiros.sEstado, 
                        retiros.estado_retiro_Cord,
                        retiros.fecha_retiroCord,
                        retiros.id,
                        retiros.estado_retiro_Cord,
                        retiros.sCliente,
                        retiros.sRegion,
                        retiros.sComuna,
                        retiros.sSerie,
                        retiros.sCui,
                        retiros.instalador,
                        retiros.sDireccion 
                    from retiros
                        inner join asignacion_retiros on asignacion_retiros.retiros_id = retiros.id 
                        inner join trabajadors on trabajadors.id = asignacion_retiros.trabajadors_idtecnico
                        inner join personas on personas.id = trabajadors.id_persona
                    where ' . $where . " 
                    group by  retiros.sSerie order by retiros.fecha_retiroCord asc ");

                                $tbody .= "<td class='td-val'>" . count($w1) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";
                                $w3 = count($w1);
                            }
                        } else if ($opcion[$j] == "tecnico") {

                            $tbody .= "<tbody>";
                            $tbody .= "<td class='td-val'>Tecnico</td>";

                            $nombre = DB::table('trabajadors')
                                ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
                                ->where('trabajadors.id_persona', '=', $resultado[$j])
                                ->select('personas.nombre_uno', 'personas.apellido_uno')
                                ->distinct()
                                ->get();

                            $id_trabajador =  DB::table('trabajadors')
                                ->select('trabajadors.id')
                                ->where('trabajadors.id_persona', '=', $resultado[$j])
                                ->get();

                            $id_tra =  $id_trabajador[0]->id;

                            $tbody .= "<td class='td-val'>" . $nombre[0]->nombre_uno . " " . $nombre[0]->apellido_uno . "</td>";

                            if ($where == "") {
                                $where .= "asignacion_retiros.trabajadors_idtecnico  = " . "'" . $id_tra . "'";

                                $w1 = DB::select('select 

                            personas.nombre_uno,
                            personas.apellido_uno,
                            retiros.proveedor_retiro,
                            retiros.sEstado, 
                            retiros.estado_retiro_Cord,
                            retiros.fecha_retiroCord,
                            retiros.id,
                            retiros.estado_retiro_Cord,
                            retiros.sCliente,
                            retiros.sRegion,
                            retiros.sComuna,
                            retiros.sSerie,
                            retiros.sCui,
                            retiros.instalador,
                            retiros.sDireccion 
                        from retiros
                            inner join asignacion_retiros on asignacion_retiros.retiros_id = retiros.id 
                            inner join trabajadors on trabajadors.id = asignacion_retiros.trabajadors_idtecnico
                            inner join personas on personas.id = trabajadors.id_persona
                        where ' . $where . " 
                        group by  retiros.sSerie order by retiros.fecha_retiroCord asc ");

                                $tbody .= "<td class='td-val'>" . count($w1) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";
                                $w3 = count($w1);
                            } else {
                                $where .= " and  asignacion_retiros.trabajadors_idtecnico  = " . "'" . $id_tra . "'";

                                $w1 = DB::select('select 

                        personas.nombre_uno,
                        personas.apellido_uno,
                        retiros.proveedor_retiro,
                        retiros.sEstado, 
                        retiros.estado_retiro_Cord,
                        retiros.fecha_retiroCord,
                        retiros.id,
                        retiros.estado_retiro_Cord,
                        retiros.sCliente,
                        retiros.sRegion,
                        retiros.sComuna,
                        retiros.sSerie,
                        retiros.sCui,
                        retiros.instalador,
                        retiros.sDireccion 
                    from retiros
                        inner join asignacion_retiros on asignacion_retiros.retiros_id = retiros.id 
                        inner join trabajadors on trabajadors.id = asignacion_retiros.trabajadors_idtecnico
                        inner join personas on personas.id = trabajadors.id_persona
                    where ' . $where . " 
                    group by  retiros.sSerie order by retiros.fecha_retiroCord asc ");

                                $tbody .= "<td class='td-val'>" . count($w1) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";
                                $w3 = count($w1);
                            }
                        }
                    }
                } else if ($resultado[$i] == "capacitacion") {

                    $w = DB::table('instalacions')->count();
                    $w1 = DB::table('retiros')->count();
                    $w2 = DB::table('capacitacions')->count();

                    $w3 = $w2;

                    $re = $w + $w1 + $w2;
                    $tbody .= "<tbody>";
                    $tbody .= "<td class='td-val'>Tipo de Atencion</td>";
                    $tbody .= "<td class='td-val'>Capacitacion</td>";
                    $tbody .= "<td class='td-val'>" . $w2 . "</td>";
                    $tbody .= "<td class='td-val'>" . $re . "</td>";
                    $tbody .= "</tbody>";

                    for ($j = 0; $j < sizeof($opcion); $j++) {
                        if ($opcion[$j] == "estado") {
                            $tbody .= "<tbody>";
                            $tbody .= "<td class='td-val'>Estado</td>";
                            $tbody .= "<td class='td-val'>" . $resultado[$j] . "</td>";
                            if ($where == "") {
                                $where .= "asignacion_capacitaciones.estado_capa" . " = " . "'" . $resultado[$j] . "'";
                                $w2 = DB::select('select 

            personas.nombre_uno,
            personas.apellido_uno,
            instalacions.id,
            instalacions.sTipo_sucursal,
            asignacion_capacitaciones.id_trabajador as id_trabajador, 
            instalacions.sCui,
            instalacions.sCliente,
            instalacions.sComuna,
            instalacions.sRegion,
            instalacions.sDireccion,
            asignacion_capacitaciones.estado_capa, 
            asignacion_capacitaciones.fecha_capacitacion,
            capacitacions.url_pdf,
            capacitacions.id as id_capacitacion,
            instalacions.proveedor_instalacion,
            instalacions.sEstado_instalacion
            from instalacions 
            left join  asignacion_capacitaciones on  asignacion_capacitaciones.cui =  instalacions.sCui
            left join  capacitacions on  capacitacions.id = asignacion_capacitaciones.id_capa            
            inner join trabajadors on trabajadors.id = asignacion_capacitaciones.id_trabajador
            inner join personas on personas.id = trabajadors.id_persona
            where ' . $where . " 
            group by  instalacions.sCui order by instalacions.dFecha_instalacion asc ");

                                $tbody .= "<td class='td-val'>" . count($w2) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";
                                $w3 = count($w2);
                            } else {
                                $where .= " and asignacion_capacitaciones.estado_capa" . " = " . "'" . $resultado[$j] . "'";

                                $w2 = DB::select('select 

            personas.nombre_uno,
            personas.apellido_uno,
            instalacions.id,
            instalacions.sTipo_sucursal,
            asignacion_capacitaciones.id_trabajador as id_trabajador, 
            instalacions.sCui,
            instalacions.sCliente,
            instalacions.sComuna,
            instalacions.sRegion,
            instalacions.sDireccion,
            asignacion_capacitaciones.estado_capa, 
            asignacion_capacitaciones.fecha_capacitacion,
            capacitacions.url_pdf,
            capacitacions.id as id_capacitacion,
            instalacions.proveedor_instalacion,
            instalacions.sEstado_instalacion
            from instalacions 
            left join  asignacion_capacitaciones on  asignacion_capacitaciones.cui =  instalacions.sCui
            left join  capacitacions on  capacitacions.id = asignacion_capacitaciones.id_capa            
            inner join trabajadors on trabajadors.id = asignacion_capacitaciones.id_trabajador
            inner join personas on personas.id = trabajadors.id_persona
            where ' . $where . " 
            group by  instalacions.sCui order by instalacions.dFecha_instalacion asc ");

                                $tbody .= "<td class='td-val'>" . count($w2) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";
                                $w3 = count($w2);
                            }
                        } else if ($opcion[$j] == "region") {

                            $tbody .= "<tbody>";
                            $tbody .= "<td class='td-val'>Region</td>";
                            $tbody .= "<td class='td-val'>" . $resultado[$j] . "</td>";
                            if ($where == "") {
                                $where .= "instalacions.sRegion  = " . "'" . $resultado[$j] . "'";

                                $w2 = DB::select('select 

            personas.nombre_uno,
            personas.apellido_uno,
            instalacions.id,
            instalacions.sTipo_sucursal,
            asignacion_capacitaciones.id_trabajador as id_trabajador, 
            instalacions.sCui,
            instalacions.sCliente,
            instalacions.sComuna,
            instalacions.sRegion,
            instalacions.sDireccion,
            asignacion_capacitaciones.estado_capa, 
            asignacion_capacitaciones.fecha_capacitacion,
            capacitacions.url_pdf,
            capacitacions.id as id_capacitacion,
            instalacions.proveedor_instalacion,
            instalacions.sEstado_instalacion
            from instalacions 
            left join  asignacion_capacitaciones on  asignacion_capacitaciones.cui =  instalacions.sCui
            left join  capacitacions on  capacitacions.id = asignacion_capacitaciones.id_capa            
            inner join trabajadors on trabajadors.id = asignacion_capacitaciones.id_trabajador
            inner join personas on personas.id = trabajadors.id_persona
            where ' . $where . " 
            group by  instalacions.sCui order by instalacions.dFecha_instalacion asc ");

                                $tbody .= "<td class='td-val'>" . count($w2) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";
                                $w3 = count($w2);
                            } else {
                                $where .= " and  instalacions.sRegion  = " . "'" . $resultado[$j] . "'";

                                $w2 = DB::select('select 

            personas.nombre_uno,
            personas.apellido_uno,
            instalacions.id,
            instalacions.sTipo_sucursal,
            asignacion_capacitaciones.id_trabajador as id_trabajador, 
            instalacions.sCui,
            instalacions.sCliente,
            instalacions.sComuna,
            instalacions.sRegion,
            instalacions.sDireccion,
            asignacion_capacitaciones.estado_capa, 
            asignacion_capacitaciones.fecha_capacitacion,
            capacitacions.url_pdf,
            capacitacions.id as id_capacitacion,
            instalacions.proveedor_instalacion,
            instalacions.sEstado_instalacion
            from instalacions 
            left join  asignacion_capacitaciones on  asignacion_capacitaciones.cui =  instalacions.sCui
            left join  capacitacions on  capacitacions.id = asignacion_capacitaciones.id_capa            
            inner join trabajadors on trabajadors.id = asignacion_capacitaciones.id_trabajador
            inner join personas on personas.id = trabajadors.id_persona
            where ' . $where . " 
            group by  instalacions.sCui order by instalacions.dFecha_instalacion asc ");

                                $tbody .= "<td class='td-val'>" . count($w2) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";
                                $w3 = count($w2);
                            }
                        } else if ($opcion[$j] == "proveedor") {
                            if ($where == "") {
                                $where .= "";
                            } else
                                $where .= "";
                        } else if ($opcion[$j] == "sucursal") {

                            $tbody .= "<tbody>";
                            $tbody .= "<td class='td-val'>Sucursal</td>";
                            $tbody .= "<td class='td-val'>" . $resultado[$j] . "</td>";
                            if ($where == "") {
                                $where .= "instalacions.sTipo_sucursal" . " = " . "'" . $resultado[$j] . "'";
                                $w2 = DB::select('select 

            personas.nombre_uno,
            personas.apellido_uno,
            instalacions.id,
            instalacions.sTipo_sucursal,
            asignacion_capacitaciones.id_trabajador as id_trabajador, 
            instalacions.sCui,
            instalacions.sCliente,
            instalacions.sComuna,
            instalacions.sRegion,
            instalacions.sDireccion,
            asignacion_capacitaciones.estado_capa, 
            asignacion_capacitaciones.fecha_capacitacion,
            capacitacions.url_pdf,
            capacitacions.id as id_capacitacion,
            instalacions.proveedor_instalacion,
            instalacions.sEstado_instalacion
            from instalacions 
            left join  asignacion_capacitaciones on  asignacion_capacitaciones.cui =  instalacions.sCui
            left join  capacitacions on  capacitacions.id = asignacion_capacitaciones.id_capa            
            inner join trabajadors on trabajadors.id = asignacion_capacitaciones.id_trabajador
            inner join personas on personas.id = trabajadors.id_persona
            where ' . $where . " 
            group by  instalacions.sCui order by instalacions.dFecha_instalacion asc ");

                                $tbody .= "<td class='td-val'>" . count($w2) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";
                                $w3 = count($w2);
                            } else {
                                $where .= " and instalacions.sTipo_sucursal" . " = " . "'" . $resultado[$j] . "'";

                                $w2 = DB::select('select 

            personas.nombre_uno,
            personas.apellido_uno,
            instalacions.id,
            instalacions.sTipo_sucursal,
            asignacion_capacitaciones.id_trabajador as id_trabajador, 
            instalacions.sCui,
            instalacions.sCliente,
            instalacions.sComuna,
            instalacions.sRegion,
            instalacions.sDireccion,
            asignacion_capacitaciones.estado_capa, 
            asignacion_capacitaciones.fecha_capacitacion,
            capacitacions.url_pdf,
            capacitacions.id as id_capacitacion,
            instalacions.proveedor_instalacion,
            instalacions.sEstado_instalacion
            from instalacions 
            left join  asignacion_capacitaciones on  asignacion_capacitaciones.cui =  instalacions.sCui
            left join  capacitacions on  capacitacions.id = asignacion_capacitaciones.id_capa            
            inner join trabajadors on trabajadors.id = asignacion_capacitaciones.id_trabajador
            inner join personas on personas.id = trabajadors.id_persona
            where ' . $where . " 
            group by  instalacions.sCui order by instalacions.dFecha_instalacion asc ");

                                $tbody .= "<td class='td-val'>" . count($w2) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";
                                $w3 = count($w2);
                            }
                        } else if ($opcion[$j] == "direccion") {

                            $tbody .= "<tbody>";
                            $tbody .= "<td class='td-val'>Direccion</td>";
                            $tbody .= "<td class='td-val'>" . $resultado[$j] . "</td>";
                            if ($where == "") {
                                $where .= "instalacions.sDireccion" . " = " . "'" . $resultado[$j] . "'";

                                $w2 = DB::select('select 

            personas.nombre_uno,
            personas.apellido_uno,
            instalacions.id,
            instalacions.sTipo_sucursal,
            asignacion_capacitaciones.id_trabajador as id_trabajador, 
            instalacions.sCui,
            instalacions.sCliente,
            instalacions.sComuna,
            instalacions.sRegion,
            instalacions.sDireccion,
            asignacion_capacitaciones.estado_capa, 
            asignacion_capacitaciones.fecha_capacitacion,
            capacitacions.url_pdf,
            capacitacions.id as id_capacitacion,
            instalacions.proveedor_instalacion,
            instalacions.sEstado_instalacion
            from instalacions 
            left join  asignacion_capacitaciones on  asignacion_capacitaciones.cui =  instalacions.sCui
            left join  capacitacions on  capacitacions.id = asignacion_capacitaciones.id_capa            
            inner join trabajadors on trabajadors.id = asignacion_capacitaciones.id_trabajador
            inner join personas on personas.id = trabajadors.id_persona
            where ' . $where . " 
            group by  instalacions.sCui order by instalacions.dFecha_instalacion asc ");

                                $tbody .= "<td class='td-val'>" . count($w2) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";
                                $w3 = count($w2);
                            } else {
                                $where .= " and instalacions.sDireccion" . " = " . "'" . $resultado[$j] . "'";
                                $w2 = DB::select('select 

            personas.nombre_uno,
            personas.apellido_uno,
            instalacions.id,
            instalacions.sTipo_sucursal,
            asignacion_capacitaciones.id_trabajador as id_trabajador, 
            instalacions.sCui,
            instalacions.sCliente,
            instalacions.sComuna,
            instalacions.sRegion,
            instalacions.sDireccion,
            asignacion_capacitaciones.estado_capa, 
            asignacion_capacitaciones.fecha_capacitacion,
            capacitacions.url_pdf,
            capacitacions.id as id_capacitacion,
            instalacions.proveedor_instalacion,
            instalacions.sEstado_instalacion
            from instalacions 
            left join  asignacion_capacitaciones on  asignacion_capacitaciones.cui =  instalacions.sCui
            left join  capacitacions on  capacitacions.id = asignacion_capacitaciones.id_capa            
            inner join trabajadors on trabajadors.id = asignacion_capacitaciones.id_trabajador
            inner join personas on personas.id = trabajadors.id_persona
            where ' . $where . " 
            group by  instalacions.sCui order by instalacions.dFecha_instalacion asc ");

                                $tbody .= "<td class='td-val'>" . count($w2) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";
                                $w3 = count($w2);
                            }
                        } else if ($opcion[$j] == "comuna") {

                            $tbody .= "<tbody>";
                            $tbody .= "<td class='td-val'>Comuna</td>";
                            $tbody .= "<td class='td-val'>" . $resultado[$j] . "</td>";
                            if ($where == "") {
                                $where .= "instalacions.sComuna  = " . "'" . $resultado[$j] . "'";
                                $w2 = DB::select('select 

            personas.nombre_uno,
            personas.apellido_uno,
            instalacions.id,
            instalacions.sTipo_sucursal,
            asignacion_capacitaciones.id_trabajador as id_trabajador, 
            instalacions.sCui,
            instalacions.sCliente,
            instalacions.sComuna,
            instalacions.sRegion,
            instalacions.sDireccion,
            asignacion_capacitaciones.estado_capa, 
            asignacion_capacitaciones.fecha_capacitacion,
            capacitacions.url_pdf,
            capacitacions.id as id_capacitacion,
            instalacions.proveedor_instalacion,
            instalacions.sEstado_instalacion
            from instalacions 
            left join  asignacion_capacitaciones on  asignacion_capacitaciones.cui =  instalacions.sCui
            left join  capacitacions on  capacitacions.id = asignacion_capacitaciones.id_capa            
            inner join trabajadors on trabajadors.id = asignacion_capacitaciones.id_trabajador
            inner join personas on personas.id = trabajadors.id_persona
            where ' . $where . " 
            group by  instalacions.sCui order by instalacions.dFecha_instalacion asc ");

                                $tbody .= "<td class='td-val'>" . count($w2) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";
                                $w3 = count($w2);
                            } else {
                                $where .= " and  instalacions.sComuna  = " . "'" . $resultado[$j] . "'";
                                $w2 = DB::select('select 

            personas.nombre_uno,
            personas.apellido_uno,
            instalacions.id,
            instalacions.sTipo_sucursal,
            asignacion_capacitaciones.id_trabajador as id_trabajador, 
            instalacions.sCui,
            instalacions.sCliente,
            instalacions.sComuna,
            instalacions.sRegion,
            instalacions.sDireccion,
            asignacion_capacitaciones.estado_capa, 
            asignacion_capacitaciones.fecha_capacitacion,
            capacitacions.url_pdf,
            capacitacions.id as id_capacitacion,
            instalacions.proveedor_instalacion,
            instalacions.sEstado_instalacion
            from instalacions 
            left join  asignacion_capacitaciones on  asignacion_capacitaciones.cui =  instalacions.sCui
            left join  capacitacions on  capacitacions.id = asignacion_capacitaciones.id_capa            
            inner join trabajadors on trabajadors.id = asignacion_capacitaciones.id_trabajador
            inner join personas on personas.id = trabajadors.id_persona
            where ' . $where . " 
            group by  instalacions.sCui order by instalacions.dFecha_instalacion asc ");

                                $tbody .= "<td class='td-val'>" . count($w2) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";
                                $w3 = count($w2);
                            }
                        } else if ($opcion[$j] == "cliente") {

                            $tbody .= "<tbody>";
                            $tbody .= "<td class='td-val'>Cliente</td>";
                            $tbody .= "<td class='td-val'>" . $resultado[$j] . "</td>";
                            if ($where == "") {
                                $where .= "instalacions.sCliente = " . "'" . $resultado[$j] . "'";
                                $w2 = DB::select('select 

            personas.nombre_uno,
            personas.apellido_uno,
            instalacions.id,
            instalacions.sTipo_sucursal,
            asignacion_capacitaciones.id_trabajador as id_trabajador, 
            instalacions.sCui,
            instalacions.sCliente,
            instalacions.sComuna,
            instalacions.sRegion,
            instalacions.sDireccion,
            asignacion_capacitaciones.estado_capa, 
            asignacion_capacitaciones.fecha_capacitacion,
            capacitacions.url_pdf,
            capacitacions.id as id_capacitacion,
            instalacions.proveedor_instalacion,
            instalacions.sEstado_instalacion
            from instalacions 
            left join  asignacion_capacitaciones on  asignacion_capacitaciones.cui =  instalacions.sCui
            left join  capacitacions on  capacitacions.id = asignacion_capacitaciones.id_capa            
            inner join trabajadors on trabajadors.id = asignacion_capacitaciones.id_trabajador
            inner join personas on personas.id = trabajadors.id_persona
            where ' . $where . " 
            group by  instalacions.sCui order by instalacions.dFecha_instalacion asc ");

                                $tbody .= "<td class='td-val'>" . count($w2) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";
                                $w3 = count($w2);
                            } else {
                                $where .= " and instalacions.sCliente = " . "'" . $resultado[$j] . "'";
                                $w2 = DB::select('select 

                        personas.nombre_uno,
                        personas.apellido_uno,
                        instalacions.id,
                        instalacions.sTipo_sucursal,
                        asignacion_capacitaciones.id_trabajador as id_trabajador, 
                        instalacions.sCui,
                        instalacions.sCliente,
                        instalacions.sComuna,
                        instalacions.sRegion,
                        instalacions.sDireccion,
                        asignacion_capacitaciones.estado_capa, 
                        asignacion_capacitaciones.fecha_capacitacion,
                        capacitacions.url_pdf,
                        capacitacions.id as id_capacitacion,
                        instalacions.proveedor_instalacion,
                        instalacions.sEstado_instalacion
                        from instalacions 
                        left join  asignacion_capacitaciones on  asignacion_capacitaciones.cui =  instalacions.sCui
                        left join  capacitacions on  capacitacions.id = asignacion_capacitaciones.id_capa            
                        inner join trabajadors on trabajadors.id = asignacion_capacitaciones.id_trabajador
                        inner join personas on personas.id = trabajadors.id_persona
                        where ' . $where . " 
                        group by  instalacions.sCui order by instalacions.dFecha_instalacion asc ");

                                $tbody .= "<td class='td-val'>" . count($w2) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";
                                $w3 = count($w2);
                            }
                        } else if ($opcion[$j] == "tecnico") {
                            $tbody .= "<tbody>";
                            $tbody .= "<td class='td-val'>Tecnico</td>";

                            $nombre = DB::table('trabajadors')
                                ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
                                ->where('trabajadors.id_persona', '=', $resultado[$j])
                                ->select('personas.nombre_uno', 'personas.apellido_uno')
                                ->distinct()
                                ->get();

                            $id_trabajador =  DB::table('trabajadors')
                                ->select('trabajadors.id')
                                ->where('trabajadors.id_persona', '=', $resultado[$j])
                                ->get();

                            $id_tra =  $id_trabajador[0]->id;

                            $tbody .= "<td class='td-val'>" . $nombre[0]->nombre_uno . " " . $nombre[0]->apellido_uno . "</td>";


                            if ($where == "") {
                                $where .= "asignacion_capacitaciones.id_trabajador  = " . "'" . $id_tra . "'";

                                $w2 = DB::select('select 

            personas.nombre_uno,
            personas.apellido_uno,
            instalacions.id,
            instalacions.sTipo_sucursal,
            asignacion_capacitaciones.id_trabajador as id_trabajador, 
            instalacions.sCui,
            instalacions.sCliente,
            instalacions.sComuna,
            instalacions.sRegion,
            instalacions.sDireccion,
            asignacion_capacitaciones.estado_capa, 
            asignacion_capacitaciones.fecha_capacitacion,
            capacitacions.url_pdf,
            capacitacions.id as id_capacitacion,
            instalacions.proveedor_instalacion,
            instalacions.sEstado_instalacion
            from instalacions 
            left join  asignacion_capacitaciones on  asignacion_capacitaciones.cui =  instalacions.sCui
            left join  capacitacions on  capacitacions.id = asignacion_capacitaciones.id_capa            
            inner join trabajadors on trabajadors.id = asignacion_capacitaciones.id_trabajador
            inner join personas on personas.id = trabajadors.id_persona
            where ' . $where . " 
            group by  instalacions.sCui order by instalacions.dFecha_instalacion asc ");

                                $tbody .= "<td class='td-val'>" . count($w2) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";
                                $w3 = count($w2);
                            } else {
                                $where .= " and  asignacion_capacitaciones.id_trabajador  = " . "'" . $id_tra . "'";

                                $w2 = DB::select('select 

            personas.nombre_uno,
            personas.apellido_uno,
            instalacions.id,
            instalacions.sTipo_sucursal,
            asignacion_capacitaciones.id_trabajador as id_trabajador, 
            instalacions.sCui,
            instalacions.sCliente,
            instalacions.sComuna,
            instalacions.sRegion,
            instalacions.sDireccion,
            asignacion_capacitaciones.estado_capa, 
            asignacion_capacitaciones.fecha_capacitacion,
            capacitacions.url_pdf,
            capacitacions.id as id_capacitacion,
            instalacions.proveedor_instalacion,
            instalacions.sEstado_instalacion
            from instalacions 
            left join  asignacion_capacitaciones on  asignacion_capacitaciones.cui =  instalacions.sCui
            left join  capacitacions on  capacitacions.id = asignacion_capacitaciones.id_capa            
            inner join trabajadors on trabajadors.id = asignacion_capacitaciones.id_trabajador
            inner join personas on personas.id = trabajadors.id_persona
            where ' . $where . " 
            group by  instalacions.sCui order by instalacions.dFecha_instalacion asc ");

                                $tbody .= "<td class='td-val'>" . count($w2) . "</td>";
                                $tbody .= "<td class='td-val'>" . $w3 . "</td>";
                                $tbody .= "</tbody>";
                                $w3 = count($w2);
                            }
                        }
                    }
                }
            }
        }


        $tbody .= "</table>";


        return $tbody;
    }
    public function consulta_tabla_reportes(request $request)
    {

        $tbody = "";
        $where = "";
        $opcion = $request->opcion;
        $fecha = "";
        $fecha2 = "";
        $resultado = $request->resultado;
        $serie = $request->serie;

        if ($request->fecha != null && $request->fecha2 != null) {

            $fecha = Carbon::createFromDate($request->fecha)->format('Y-m-d');
            $fecha2 = Carbon::createFromDate($request->fecha2)->format('Y-m-d');

            for ($i = 0; $i < sizeof($opcion); $i++) {
                if ($resultado[$i] == "instalacion") {
                    if ($where == "") {
                        $where .= "instalacions.fecha_instalacion_coordinadora" . " BETWEEN " . "'" . $fecha . "'" . " and " . "'" . $fecha2 . "'";
                    } else $where .= " and instalacions.fecha_instalacion_coordinadora" . " BETWEEN " . "'" . $fecha . "'" . " and " . "'" . $fecha2 . "'";
                } else if ($resultado[$i] == "capacitacion") {

                    if ($where == "") {
                        $where .= "asignacion_capacitaciones.fecha_capacitacion" . " BETWEEN " . "'" . $fecha . "'" . " and " . "'" . $fecha2 . "'";
                    } else $where .= " and asignacion_capacitaciones.fecha_capacitacion" . " BETWEEN " . "'" . $fecha . "'" . " and " . "'" . $fecha2 . "'";
                } else if ($resultado[$i] == "retiro") {

                    if ($where == "") {
                        $where .= "retiros.fecha_retiroCord" . " BETWEEN " . "'" . $fecha . "'" . " and " . "'" . $fecha2 . "'";
                    } else $where .= " and retiros.fecha_retiroCord" . " BETWEEN " . "'" . $fecha . "'" . " and " . "'" . $fecha2 . "'";
                }
            }
        }

        if ($serie != null) {

            for ($i = 0; $i < sizeof($opcion); $i++) {
                if ($opcion[$i] == "tipo") {
                    if ($resultado[$i] == "instalacion") {
                        if ($where == "") {
                            $where .= "instalacions.sSerie " . " = " . "'" . $serie . "'";
                        } else
                            $where .= " and instalacions.sSerie " . " = " . "'" . $serie . "'";
                    } else if ($resultado[$i] == "retiro") {
                        if ($where == "") {
                            $where .= "retiros.sSerie " . " = " . "'" . $serie . "'";
                        } else
                            $where .= " and retiros.sSerie " . " = " . "'" . $serie . "'";
                    }
                }
            }
        }

        for ($i = 0; $i < sizeof($opcion); $i++) {
            if ($opcion[$i] == "tipo") {

                if ($resultado[$i] == "instalacion") {

                    for ($j = 0; $j < sizeof($opcion); $j++) {
                        if ($opcion[$j] == "estado") {

                            if ($where == "") {
                                $where .= "instalacions.sEstado_instalacion" . " = " . "'" . $resultado[$j] . "'";
                            } else {
                                $where .= " and instalacions.sEstado_instalacion" . " = " . "'" . $resultado[$j] . "'";
                            }
                        } else if ($opcion[$j] == "region") {

                            if ($where == "") {
                                $where .= "instalacions.sRegion " . " = " . "'" . $resultado[$j] . "'";
                            } else {
                                $where .= " and instalacions.sRegion " . " = " . "'" . $resultado[$j] . "'";
                            }
                        } else if ($opcion[$j] == "comuna") {

                            if ($where == "") {
                                $where .= "instalacions.sComuna " . " = " . "'" . $resultado[$j] . "'";
                            } else {
                                $where .= " and instalacions.sComuna " . " = " . "'" . $resultado[$j] . "'";
                            }
                        } else if ($opcion[$j] == "proveedor") {

                            if ($where == "") {
                                $where .= "instalacions.proveedor_instalacion " . " = " . "'" . $resultado[$j] . "'";
                            } else {

                                $where .= " and instalacions.proveedor_instalacion " . " = " . "'" . $resultado[$j] . "'";
                            }
                        } else if ($opcion[$j] == "sucursal") {

                            if ($where == "") {
                                $where .= "instalacions.sTipo_sucursal " . " = " . "'" . $resultado[$j] . "'";
                            } else {
                                $where .= " and instalacions.sTipo_sucursal " . " = " . "'" . $resultado[$j] . "'";
                            }
                        } else if ($opcion[$j] == "direccion") {

                            if ($where == "") {
                                $where .= "instalacions.sDireccion " . " = " . "'" . $resultado[$j] . "'";
                            } else {
                                $where .= " and instalacions.sDireccion " . " = " . "'" . $resultado[$j] . "'";
                            }
                        } else if ($opcion[$j] == "cliente") {

                            if ($where == "") {
                                $where .= "instalacions.sCliente " . " = " . "'" . $resultado[$j] . "'";
                            } else {
                                $where .= " and instalacions.sCliente " . " = " . "'" . $resultado[$j] . "'";
                            }
                        } else if ($opcion[$j] == "tecnico") {

                            $id_trabajador =  DB::table('trabajadors')
                                ->select('trabajadors.id')
                                ->where('trabajadors.id_persona', '=', $resultado[$j])
                                ->get();

                            $id_tra =  $id_trabajador[0]->id;

                            if ($where == "") {
                                $where .= "asignacion_instalacions.trabajadors_id " . " = " . "'" . $id_tra . "'";
                            } else {
                                $where .= " and  asignacion_instalacions.trabajadors_id " . " = " . "'" . $id_tra . "'";
                            }
                        }
                    }

                    $instalaciones = DB::select('select

                    personas.nombre_uno,
                    personas.apellido_uno,
                    proyectos.nombre,
                    instalacions.sRegion,
                    instalacions.sTipo_sucursal,
                    instalacions.instalador,
                    instalacions.sCui,
                    instalacions.sEstado_instalacion,
                    instalacions.fecha_instalacion_coordinadora,
                    instalacions.id,
                    instalacions.dFecha_instalacion,
                    instalacions.fecha_registrado,
                    instalacions.sEstado_despacho,
                    instalacions.sCliente,
                    instalacions.sComuna,
                    instalacions.Csserie_remplazo,
                    instalacions.Csserie_es,
                    instalacions.sSerie,
                    instalacions.sDireccion,
                    instalacions.proveedor_instalacion
                from instalacions
                inner join asignacion_instalacions on instalacions.id = asignacion_instalacions.lista_instalacion_id
                inner join trabajadors on trabajadors.id = asignacion_instalacions.trabajadors_id
                inner join personas on personas.id = trabajadors.id_persona
                inner join tracker on tracker.id = instalacions.tracker_idtracker  
                inner join  proyectos on  proyectos.id = tracker.proyecto_id 
                where ' . $where . "
                group by  instalacions.sSerie order by instalacions.dFecha_instalacion asc ");


                    $tbody .= "<table class='table table-striped table-hover table-responsive' id='mitable'>
                <thead class='color-head'>
                  <tr>
                    <th class='th-head border-th separador-v' colspan='1'>FECHA RECEPCION</th>
                    <th class='th-head border-th separador-v' colspan='1'>FECHA INSTALACION</th>
                    <th class='th-head border-th separador-v' colspan='1'>PROVEEDOR</th>
                    <th class='th-head border-th separador-v' colspan='1'>CLIENTE</th>
                    <th class='th-head border-th separador-v' colspan='1'>TECNICO</th>
                    <th class='th-head border-th separador-v' colspan='1'>ATENCION</th>
                    <th class='th-head border-th separador-v' colspan='1'>REGION</th>
                    <th class='th-head border-th separador-v' colspan='1'>COMUNA</th>
                    <th class='th-head border-th separador-v' colspan='1'>DIRECCION</th>
                    <th class='th-head border-th separador-v' colspan='1'>SUCURSAL</th>
                    <th class='th-head border-th separador-v' colspan='1'>ESTADO</th>
                    <th class='th-head border-th separador-v' colspan='1'>N° SERIE</th>
                  </tr>
                </thead>";

                    $tbody .= "<tbody>";
                    foreach ($instalaciones as $datos) {

                        $fecha_aux = Carbon::createFromDate($datos->fecha_registrado)->format('d-m-Y');
                        $fecha_aux1 = Carbon::createFromDate($datos->fecha_instalacion_coordinadora)->format('d-m-Y');
                        $tbody .= "<tr>";
                        $tbody .= "<td class='td-val'>$fecha_aux</td>";
                        if ($datos->fecha_instalacion_coordinadora != "" || $datos->fecha_instalacion_coordinadora != null) {
                            $tbody .= "<td class='td-val'>$fecha_aux1</td>";
                        }
                        $tbody .= "<td class='td-val'>$datos->proveedor_instalacion</td>";
                        $tbody .= "<td class='td-val'>$datos->sCliente</td>";
                        $tbody .= "<td class='td-val'>$datos->nombre_uno $datos->apellido_uno</td>";
                        $tbody .= "<td class='td-val'>Instalacion</td>";
                        $tbody .= "<td class='td-val'>$datos->sRegion</td>";
                        $tbody .= "<td class='td-val'>$datos->sComuna</td>";
                        $tbody .= "<td class='td-val'>$datos->sDireccion</td>";
                        $tbody .= "<td class='td-val'>$datos->sTipo_sucursal</td>";
                        $tbody .= "<td class='td-val'>$datos->sEstado_instalacion</td>";
                        $tbody .= "<td class='td-val'>$datos->sSerie</td>";
                        $tbody .= "</tr>";
                    }
                    $tbody .= "</tbody>";
                } else if ($resultado[$i] == "retiro") {

                    for ($j = 0; $j < sizeof($opcion); $j++) {
                        if ($opcion[$j] == "estado") {

                            if ($where == "") {
                                $where .= "retiros.estado_retiro_Cord" . " = " . "'" . $resultado[$j] . "'";
                            } else {
                                $where .= " and retiros.sEstado" . " = " . "'" . $resultado[$j] . "'";
                            }
                        } else if ($opcion[$j] == "region") {

                            if ($where == "") {
                                $where .= "retiros.sRegion" . " = " . "'" . $resultado[$j] . "'";
                            } else {
                                $where .= " and retiros.sRegion" . " = " . "'" . $resultado[$j] . "'";
                            }
                        } else if ($opcion[$j] == "comuna") {

                            if ($where == "") {
                                $where .= "retiros.sComuna" . " = " . "'" . $resultado[$j] . "'";
                            } else {
                                $where .= " and retiros.sComuna" . " = " . "'" . $resultado[$j] . "'";
                            }
                        } else if ($opcion[$j] == "proveedor") {

                            if ($where == "") {
                                $where .= "retiros.proveedor_retiro" . " = " . "'" . $resultado[$j] . "'";
                            } else {
                                $where .= " and retiros.proveedor_retiro" . " = " . "'" . $resultado[$j] . "'";
                            }
                        } else if ($opcion[$j] == "sucursal") {
                            if ($where == "") {
                                $where .= "";
                            } else
                                $where .= "";
                        } else if ($opcion[$j] == "direccion") {

                            if ($where == "") {
                                $where .= "retiros.sDireccion" . " = " . "'" . $resultado[$j] . "'";
                            } else {
                                $where .= " and retiros.sDireccion" . " = " . "'" . $resultado[$j] . "'";
                            }
                        } else if ($opcion[$j] == "cliente") {

                            if ($where == "") {
                                $where .= "retiros.sCliente" . " = " . "'" . $resultado[$j] . "'";
                            } else {
                                $where .= " and retiros.sCliente" . " = " . "'" . $resultado[$j] . "'";
                            }
                        } else if ($opcion[$j] == "tecnico") {


                            $id_trabajador =  DB::table('trabajadors')
                                ->select('trabajadors.id')
                                ->where('trabajadors.id_persona', '=', $resultado[$j])
                                ->get();

                            $id_tra =  $id_trabajador[0]->id;

                            if ($where == "") {
                                $where .= "asignacion_retiros.trabajadors_idtecnico  = " . "'" . $id_tra . "'";
                            } else {
                                $where .= " and  asignacion_retiros.trabajadors_idtecnico  = " . "'" . $id_tra . "'";
                            }
                        }
                    }

                    $retiros = DB::select('select 

                personas.nombre_uno,
                personas.apellido_uno,
                retiros.proveedor_retiro,
                retiros.sEstado, 
                retiros.estado_retiro_Cord,
                retiros.fecha_retiroCord,
                retiros.id,
                retiros.estado_retiro_Cord,
                retiros.sCliente,
                retiros.sRegion,
                retiros.sComuna,
                retiros.sSerie,
                retiros.sCui,
                retiros.instalador,
                retiros.sDireccion 
            from retiros
                inner join asignacion_retiros on asignacion_retiros.retiros_id = retiros.id 
                inner join trabajadors on trabajadors.id = asignacion_retiros.trabajadors_idtecnico
                inner join personas on personas.id = trabajadors.id_persona
            where ' . $where . " 
            group by  retiros.sSerie order by retiros.fecha_retiroCord asc ");


                    $tbody .= "<table class='table table-striped table-hover table-responsive' id='mitable'>
            <thead class='color-head'>
            <tr>
                <th class='th-head border-th separador-v' colspan='1'>FECHAS DE RETIRO</th>
                <th class='th-head border-th separador-v' colspan='1'>PROVEEDOR</th>
                <th class='th-head border-th separador-v' colspan='1'>CLIENTE</th>
                <th class='th-head border-th separador-v' colspan='1'>TECNICO</th>
                <th class='th-head border-th separador-v' colspan='1'>ATENCION</th>
                <th class='th-head border-th separador-v' colspan='1'>REGION</th>
                <th class='th-head border-th separador-v' colspan='1'>COMUNA</th>
                <th class='th-head border-th separador-v' colspan='1'>DIRECCION</th>
                <th class='th-head border-th separador-v' colspan='1'>ESTADO</th>
                <th class='th-head border-th separador-v' colspan='1'>N° SERIE</th>
            </tr>
            </thead>";


                    $tbody .= "<tbody>";
                    foreach ($retiros as $datos) {
                        $fecha_aux = Carbon::createFromDate($datos->fecha_retiroCord)->format('d-m-Y');
                        $tbody .= "<tr>";
                        if ($datos->fecha_retiroCord != null  and $datos->fecha_retiroCord  !=  "0000-00-00") {
                            $tbody .= "<td class='td-val'>$fecha_aux</td>";
                        } else $tbody .= "<td class='td-val'>Sin Fecha</td>";
                        $tbody .= "<td class='td-val'>$datos->proveedor_retiro</td>";
                        $tbody .= "<td class='td-val'>$datos->sCliente</td>";
                        $tbody .= "<td class='td-val'>$datos->nombre_uno $datos->apellido_uno</td>";
                        $tbody .= "<td class='td-val'>Retiro</td>";
                        $tbody .= "<td class='td-val'>$datos->sRegion</td>";
                        $tbody .= "<td class='td-val'>$datos->sComuna</td>";
                        $tbody .= "<td class='td-val'>$datos->sDireccion</td>";
                        $tbody .= "<td class='td-val'>$datos->estado_retiro_Cord</td>";
                        $tbody .= "<td class='td-val'>$datos->sSerie</td>";
                        $tbody .= "</tr>";
                    }

                    $tbody .= "</tbody>";
                } else if ($resultado[$i] == "capacitacion") {

                    for ($j = 0; $j < sizeof($opcion); $j++) {
                        if ($opcion[$j] == "estado") {
                            if ($where == "") {
                                $where .= "asignacion_capacitaciones.estado_capa" . " = " . "'" . $resultado[$j] . "'";
                            } else {
                                $where .= " and asignacion_capacitaciones.estado_capa" . " = " . "'" . $resultado[$j] . "'";
                            }
                        } else if ($opcion[$j] == "region") {

                            if ($where == "") {
                                $where .= "instalacions.sRegion  = " . "'" . $resultado[$j] . "'";
                            } else {
                                $where .= " and  instalacions.sRegion  = " . "'" . $resultado[$j] . "'";
                            }
                        } else if ($opcion[$j] == "proveedor") {
                            if ($where == "") {
                                $where .= "";
                            } else
                                $where .= "";
                        } else if ($opcion[$j] == "sucursal") {

                            if ($where == "") {
                                $where .= "instalacions.sTipo_sucursal" . " = " . "'" . $resultado[$j] . "'";
                            } else {
                                $where .= " and instalacions.sTipo_sucursal" . " = " . "'" . $resultado[$j] . "'";
                            }
                        } else if ($opcion[$j] == "direccion") {

                            if ($where == "") {
                                $where .= "instalacions.sDireccion" . " = " . "'" . $resultado[$j] . "'";
                            } else {
                                $where .= " and instalacions.sDireccion" . " = " . "'" . $resultado[$j] . "'";
                            }
                        } else if ($opcion[$j] == "comuna") {

                            if ($where == "") {
                                $where .= "instalacions.sComuna  = " . "'" . $resultado[$j] . "'";
                            } else {
                                $where .= " and  instalacions.sComuna  = " . "'" . $resultado[$j] . "'";
                            }
                        } else if ($opcion[$j] == "cliente") {

                            if ($where == "") {
                                $where .= "instalacions.sCliente = " . "'" . $resultado[$j] . "'";
                            } else {
                                $where .= " and instalacions.sCliente = " . "'" . $resultado[$j] . "'";
                            }
                        } else if ($opcion[$j] == "tecnico") {

                            $id_trabajador =  DB::table('trabajadors')
                                ->select('trabajadors.id')
                                ->where('trabajadors.id_persona', '=', $resultado[$j])
                                ->get();

                            $id_tra =  $id_trabajador[0]->id;

                            if ($where == "") {
                                $where .= "asignacion_capacitaciones.id_trabajador  = " . "'" . $id_tra . "'";
                            } else {
                                $where .= " and  asignacion_capacitaciones.id_trabajador  = " . "'" . $id_tra . "'";
                            }
                        }
                    }


                    $capacitacion = DB::select('select 

        personas.nombre_uno,
        personas.apellido_uno,
        instalacions.id,
        instalacions.sTipo_sucursal,
        asignacion_capacitaciones.id_trabajador as id_trabajador, 
        instalacions.sCui,
        instalacions.sCliente,
        instalacions.sComuna,
        instalacions.sRegion,
        instalacions.sDireccion,
        asignacion_capacitaciones.estado_capa, 
        asignacion_capacitaciones.fecha_capacitacion,
        capacitacions.url_pdf,
        capacitacions.id as id_capacitacion,
        instalacions.proveedor_instalacion,
        instalacions.sEstado_instalacion
        from instalacions 
        left join  asignacion_capacitaciones on  asignacion_capacitaciones.cui =  instalacions.sCui
        left join  capacitacions on  capacitacions.id = asignacion_capacitaciones.id_capa            
        inner join trabajadors on trabajadors.id = asignacion_capacitaciones.id_trabajador
        inner join personas on personas.id = trabajadors.id_persona
        where ' . $where . " 
        group by  instalacions.sCui order by instalacions.dFecha_instalacion asc ");


                    $tbody .= "<table class='table table-striped table-hover table-responsive' id='mitable'>
<thead class='color-head'>
  <tr>
    <th class='th-head border-th separador-v' colspan='1'>FECHAS DE CAPACITACION</th>
    <th class='th-head border-th separador-v' colspan='1'>PROVEEDOR</th>
    <th class='th-head border-th separador-v' colspan='1'>CLIENTE</th>
    <th class='th-head border-th separador-v' colspan='1'>TECNICO</th>
    <th class='th-head border-th separador-v' colspan='1'>ATENCION</th>
    <th class='th-head border-th separador-v' colspan='1'>REGION</th>
    <th class='th-head border-th separador-v' colspan='1'>COMUNA</th>
    <th class='th-head border-th separador-v' colspan='1'>DIRECCION</th>
    <th class='th-head border-th separador-v' colspan='1'>SUCURSAL</th>
    <th class='th-head border-th separador-v' colspan='1'>ESTADO</th>
  </tr>
</thead>";

                    $tbody .= "<tbody>";
                    foreach ($capacitacion as $datos) {

                        $fecha_aux = Carbon::createFromDate($datos->fecha_capacitacion)->format('d-m-Y');
                        $tbody .= "<tr>";
                        if ($datos->fecha_capacitacion != "") {
                            $tbody .= "<td class='td-val'>$fecha_aux</td>";
                        } else $tbody .= "<td class='td-val'>No Informado</td>";
                        $tbody .= "<td class='td-val'>$datos->proveedor_instalacion</td>";
                        $tbody .= "<td class='td-val'>$datos->sCliente</td>";
                        $tbody .= "<td class='td-val'>$datos->nombre_uno $datos->apellido_uno</td>";
                        $tbody .= "<td class='td-val'>Capacitacion</td>";
                        $tbody .= "<td class='td-val'>$datos->sRegion</td>";
                        $tbody .= "<td class='td-val'>$datos->sComuna</td>";
                        $tbody .= "<td class='td-val'>$datos->sDireccion</td>";
                        $tbody .= "<td class='td-val'>$datos->sTipo_sucursal</td>";
                        $tbody .= "<td class='td-val'>$datos->estado_capa</td>";
                        $tbody .= "</tr>";
                    }
                    $tbody .= "</tbody>";
                }
            }
        }

        $tbody .= "</table>";

        return $tbody;
    }
    // SELECTS DINAMICOS 
    public function reporte(request $request)
    {


        $cliente = "";
        $estado = "";
        $tbody = "";
        $id_persona = "";
        $sucursal = "";
        $region = "";
        $comuna = "";
        $direccion = "";
        $proveedor = "";
        $tecnico = "";



        if ($request->opcion == 'proveedor') {

            $tbody = "";
            $consulta =  DB::table('instalacions')
                ->select('instalacions.proveedor_instalacion')
                ->orderBy('instalacions.proveedor_instalacion', 'asc')
                ->where('instalacions.proveedor_instalacion', '!=', '')
                ->distinct()
                ->get();
            foreach ($consulta as $datos) {

                $tbody .= "<option value='$datos->proveedor_instalacion '>$datos->proveedor_instalacion</option>";
            }
        } else if ($request->opcion == 'cliente') {


            for ($j = 0; $j < sizeof($request->opciones); $j++) {
                if ($request->opciones[$j] == "proveedor") {

                    $proveedor = $request->resultado[$j];
                }
            }

            if ($proveedor == "") {
                $tbody = "";

                $consulta = DB::table('instalacions')
                    ->select('sCliente')
                    ->distinct()
                    ->get();
            } else {
                $tbody = "";

                $consulta = DB::table('instalacions')
                    ->select('sCliente')
                    ->where("instalacions.proveedor_instalacion", "=", $proveedor)
                    ->distinct()
                    ->get();
            }
            if (!empty($consulta)) {
                foreach ($consulta as $datos) {

                    $tbody .= "<option value='$datos->sCliente'>$datos->sCliente</option>";
                }
            }
        } else if ($request->opcion == 'estado') {

            $tbody = "";
            $consulta_instalacion = DB::table('retiros')
                ->select('retiros.sEstado as uEstado')
                ->where('retiros.sEstado', '!=', null)
                ->distinct();

            $consulta = DB::table('instalacions')
                ->select('instalacions.sEstado_instalacion as uEstado')
                ->where('instalacions.sEstado_instalacion', '!=', null)
                ->distinct()
                ->union($consulta_instalacion)
                ->get();

            foreach ($consulta as $datos) {
                if ($datos->uEstado == $estado) {

                    $tbody .= "<option value=' $datos->uEstado '>$datos->uEstado</option>";
                } else {

                    $tbody .= "<option value=' $datos->uEstado '>$datos->uEstado</option>";
                }
            }
        } else if ($request->opcion == 'tecnico') {


            $tbody = "";
            $consulta = DB::table('asignacion_instalacions')
                ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
                ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
                ->where('trabajadors.estado', '=', '1')
                ->select('personas.nombre_uno', 'personas.apellido_uno', 'personas.id')
                ->orderBy('personas.nombre_uno', 'asc')
                ->distinct()
                ->get();

            // return $consulta;

            if (!empty($consulta)) {
                foreach ($consulta as $datos) {
                    if ($datos->nombre_uno != null) {
                        if ($datos->id == $id_persona) {

                            $tbody .= "<option value=' $datos->id '>$datos->nombre_uno $datos->apellido_uno</option>";
                        } else {

                            $tbody .= "<option value=' $datos->id '>$datos->nombre_uno $datos->apellido_uno</option>";
                        }
                    }
                }
            }
        } else if ($request->opcion == 'sucursal') {


            $tbody = "";

            $consulta = DB::table('instalacions')
                ->select('instalacions.sTipo_sucursal')
                ->distinct()
                ->orderBy('instalacions.sTipo_sucursal', 'asc')
                ->get();

            if (!empty($consulta)) {
                foreach ($consulta as $datos) {
                    if ($datos->sTipo_sucursal != null) {
                        if ($datos->sTipo_sucursal == $sucursal) {

                            $tbody .= "<option value=' $datos->sTipo_sucursal '>$datos->sTipo_sucursal</option>";
                        } else {

                            $tbody .= "<option value=' $datos->sTipo_sucursal '>$datos->sTipo_sucursal</option>";
                        }
                    }
                }
            }
        } else if ($request->opcion == 'region') {


            $consulta = DB::table('retiros')
                ->select('retiros.sRegion')
                ->where('retiros.sRegion', '!=', null)
                ->orderByRaw(DB::raw("FIELD(retiros.sRegion,  1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17) ASC"))
                ->distinct()
                ->get();
            $tbody = "";
            if (!empty($consulta)) {
                foreach ($consulta as $datos) {
                    if ($datos->sRegion != null) {

                        $tbody .= "<option value='$datos->sRegion'>$datos->sRegion</option>";
                    }
                }
            }
        } else if ($request->opcion == 'comuna') {


            for ($j = 0; $j < sizeof($request->opciones); $j++) {
                if ($request->opciones[$j] == "region") {

                    $region = $request->resultado[$j];
                }
            }

            if ($region == "") {
                $tbody = "";
                $consulta = DB::table('instalacions')
                    ->select('instalacions.sComuna')
                    ->orderBy('instalacions.sComuna', 'asc')
                    ->distinct()
                    ->get();
            } else {
                $tbody = "";
                $consulta = DB::table('instalacions')
                    ->select('instalacions.sComuna')
                    ->where("instalacions.sRegion", "=", $region)
                    ->orderBy('instalacions.sComuna', 'asc')
                    ->distinct()
                    ->get();
            }
            foreach ($consulta as $datos) {
                if ($datos->sComuna == $comuna) {

                    $tbody .= "<option value='$datos->sComuna'>$datos->sComuna</option>";
                } else {

                    $tbody .= "<option value='$datos->sComuna'>$datos->sComuna</option>";
                }
            }
        } else if ($request->opcion == 'direccion') {

            for ($j = 0; $j < sizeof($request->opciones); $j++) {
                if ($request->opciones[$j] == "comuna") {

                    $comuna = $request->resultado[$j];
                }
            }

            if ($comuna == "") {
                $tbody = "";
                $consulta = DB::table('retiros')
                    ->select('retiros.sDireccion as descripcion_direccion')
                    ->distinct()
                    ->get();
            } else {

                $tbody = "";
                $consulta = DB::table('retiros')
                    ->select('retiros.sDireccion as descripcion_direccion')
                    ->where('retiros.sComuna', '=', $comuna)
                    ->distinct()
                    ->get();
            }

            if (!empty($consulta)) {
                foreach ($consulta as $datos) {

                    $tbody .= "<option value='$datos->descripcion_direccion'>$datos->descripcion_direccion</option>";
                }
            }
        }

        return $tbody;
    }
    // BUSCAR NUMERO DE SERIE
    function fetch_numeroserie(Request $request)
    {
        if ($request->get('query')) {

            $query = $request->get('query');

            $data_instalacion = DB::table('instalacions')
                ->where('sSerie', 'LIKE', "%{$query}%")
                ->select('sSerie');

            $data_serie = DB::table('retiros')
                ->where('sSerie', 'LIKE', "%{$query}%")
                ->select('sSerie')
                ->union($data_instalacion)
                ->get();


            $output = '<ul  class="alert alert-success" style="display:block; list-style:none">';
            foreach ($data_serie as $row) {
                $output .= '
   <li class="mayuscula" data-rut="' . $row->sSerie . '" style="list-style:none;cursor: pointer;">' . '<a class="add_id" data-rut="' . "'" . $row->sSerie . "'" . '">' . $row->sSerie . '</a></li><hr>';
            }
            $output .= '</ul>';

            echo $output;
        } else {
        }
    }
    public function check_tecnico_historial_retiro(Request $request)
    {

        $id_asignacion = $request->id;

        $id_retiro = DB::table('asignacion_retiros')
            ->select('retiros_id')
            ->where('asignacion_retiros.id', '=', $id_asignacion)
            ->get();

        $id = $id_retiro[0]->retiros_id;

        $historial = DB::table('checklist_retiros')
            ->select(
                'checklist_retiros.csSerie',
                'checklist_retiros.observacion',
                'checklist_retiros.csDireccion',
                'checklist_retiros.csCiudad',
                'checklist_retiros.csComuna',
                'checklist_retiros.csCliente',
                'checklist_retiros.cnContador',
                'checklist_retiros.cnContador_color',
                'asignacion_retiros.fecha_asignado'
            )
            ->join('asignacion_retiros', 'asignacion_retiros.id', '=', 'checklist_retiros.asignacion_retiros_id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->where('retiros.id', '=', $id)
            ->get();

        $tabla = "";

        foreach ($historial as $dato) {
            $tabla .= '<tr>';
            $tabla .= '<td>' . $dato->csSerie . '</td>';
            $tabla .= '<td>' . $dato->csCiudad . ' ' . $dato->csComuna . '</td>';
            $tabla .= '<td>' . $dato->csCliente . '</td>';
            $tabla .= '<td>' . $dato->fecha_asignado . '</td>';
            $tabla .= '<td>' . $dato->cnContador . '</td>';
            $tabla .= '<td>' . $dato->cnContador_color . '</td>';
            $tabla .= '<td>' . $dato->observacion . '</td>';
            $tabla .= '</tr>';
        }

        return $tabla;
    }

    public function check_tecnico_historial_instalacion(Request $request)
    {

        $id_asignacion = $request->id;


        $id_instalacion = DB::table('asignacion_instalacions')
            ->select('lista_instalacion_id')
            ->where('asignacion_instalacions.id', '=', $id_asignacion)
            ->get();

        $id = $id_instalacion[0]->lista_instalacion_id;

        $historial = DB::table('checklist_instalacions')
            ->select(
                'checklist_instalacions.id',
                'checklist_instalacions.CsSerie',
                'checklist_instalacions.CsObservacion',
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscliente',
                'checklist_instalacions.CnContador',
                'checklist_instalacions.Csserie_remplazo',
                'checklist_instalacions.CnContador_color',
                'asignacion_instalacions.fecha_asignado',
                'asignacion_instalacions.numero_visita',
                'tipos_visitas.descripcion',
                //'accesorios.descripcion as nombre'
            )
            ->join('asignacion_instalacions', 'asignacion_instalacions.id', '=', 'checklist_instalacions.asignacion_instalacion_retiro_id')
            ->join('tipos_visitas', 'tipos_visitas.id', '=', 'asignacion_instalacions.tipos_visitas_id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->where('instalacions.id', '=', $id)
            ->get();

        $tabla = "";

        foreach ($historial as $dato) {
            $fecha = Carbon::createFromDate($dato->fecha_asignado)->format('d-m-Y h:i');
            $tabla .= '<tr>';
            $tabla .= '<td>' . $dato->numero_visita . '</td>';
            if ($dato->Csserie_remplazo != null || $dato->Csserie_remplazo != "") {
                $tabla .= '<td>' . $dato->Csserie_remplazo . '</td>';
            } else {
                $tabla .= '<td>' . $dato->CsSerie . '</td>';
            }
            $tabla .= '<td>' . $dato->Csdireccion . '</td>';
            $tabla .= '<td>' . $dato->Cscliente . '</td>';
            $tabla .= '<td>' . $fecha . '</td>';
            $tabla .= '<td>' . $dato->CnContador . '</td>';
            $tabla .= '<td>' . $dato->CnContador_color . '</td>';
            $tabla .= '<td>' . $dato->descripcion . '</td>';
            $tabla .= '<td>' . $dato->CsObservacion . '</td>';

            $accesorios = DB::table('checklist_accesorios')
                ->select('accesorios.descripcion as nombre', 'checklist_accesorios.cantidad')
                ->join('accesorios', 'accesorios.id', '=', 'checklist_accesorios.id_accesorio')
                ->where('checklist_accesorios.id_checklist_instalacion', '=', $dato->id)
                ->get();

            $tabla .= '<td>';
            foreach ($accesorios as $key => $partes) {
                $tabla .= ($key + 1) . '-' . $partes->nombre . '(' . $partes->cantidad . ') <br> ';
            }
            $tabla .= '</td>';

            $tabla .= '</tr>';
        }

        return $tabla;

        $cont = [];
        for ($i = 0; $i < count($historial); $i++) {
            $accesorios = DB::table('checklist_accesorios')
                ->select('accesorios.descripcion as nombre')
                ->leftjoin('accesorios', 'accesorios.id', '=', 'checklist_accesorios.id_accesorio')
                ->where('checklist_accesorios.id_checklist_instalacion', '=', $historial[$i]->id)
                ->get();

            $cont[$i] = $accesorios;
        }
    }
    public function intermedio_api_retiros()
    {

        $carga_selectProveedor = DB::table('retiros')
            ->select('retiros.proveedor_retiro')
            ->orderBy('retiros.proveedor_retiro', 'asc')
            ->distinct()
            ->get();
        //Cargar Select Clientes

        return view('Apiviews.intermedio_retiro', compact('carga_selectProveedor'));
    }
    public function obtenerClientesAsociados2(request $re)
    {

        $idCliente = $re->idClientes;

        $carga_selectClientes = DB::table('clientes')
            ->select('clientes.razon_social', 'clientes.id')
            ->where('clientes.proveedor_nombre', '=', $idCliente)
            ->orderBy('clientes.razon_social', 'asc')
            ->distinct()
            ->get();

        return $carga_selectClientes;

        $option = "";

        foreach ($carga_selectClientes as $datos) {
            $option .= "<option value=" . base64_encode($datos->sCliente) . ">" . $datos->sCliente . "</option>";
        }

        return  $option;
    }

    public function intermedio_capas()
    {
        $carga_selectProveedor = DB::table('instalacions')
            ->select('instalacions.proveedor_instalacion')
            ->orderBy('instalacions.proveedor_instalacion', 'asc')
            ->distinct()
            ->get();

        return view('capacitacion.intermedio_capas', compact('carga_selectProveedor'));
    }
    public function obtenerProyectosAsociados2(request $re)
    {



        $idCliente = $re->idClientes;


        $proyectos = DB::table('proyectos')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->select("proyectos.nombre", "proyectos.id")
            ->orderBy('proyectos.nombre', 'asc')
            ->where("clientes.razon_social", "=", $idCliente)
            ->distinct()
            ->get();

        return  $proyectos;
    }
    public function obtenerClientesAsociados(request $re)
    {

        $idCliente = $re->idClientes;

        $carga_selectClientes = DB::table('instalacions')
            ->select('instalacions.sCliente')
            ->where('instalacions.proveedor_instalacion', '=', $idCliente)
            ->orderBy('instalacions.sCliente', 'asc')
            ->distinct()
            ->get();

        $option = "";

        foreach ($carga_selectClientes as $datos) {
            $option .= "<option value=" . base64_encode($datos->sCliente) . ">" . $datos->sCliente . "</option>";
        }

        return  $option;
    }
    public function check_historial_instalacion(Request $request)
    {

        try {
            $id = Crypt::decryptString($request->id);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }

        $historial = DB::table('checklist_instalacions')
            ->select(
                'checklist_instalacions.id',
                'checklist_instalacions.CsSerie',
                'checklist_instalacions.observacion',
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscliente',
                'checklist_instalacions.CnContador',
                'checklist_instalacions.Csserie_remplazo',
                'checklist_instalacions.CnContador_color',
                'asignacion_instalacions.fecha_asignado',
                'asignacion_instalacions.numero_visita',
                'asignacion_instalacions.opcion_estado_instalacion',
                'tipos_visitas.descripcion',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'checklist_instalacions.CsModelo',
                'checklist_instalacions.CsModelo_es',
                'checklist_instalacions.Csregion',
                'checklist_instalacions.Cscomuna',
                //'accesorios.descripcion as nombre'
            )
            ->join('asignacion_instalacions', 'asignacion_instalacions.id', '=', 'checklist_instalacions.asignacion_instalacion_retiro_id')
            ->join('tipos_visitas', 'tipos_visitas.id', '=', 'asignacion_instalacions.tipos_visitas_id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('instalacions.id', '=', $id)
            ->get();

        $tabla = "";

        foreach ($historial as $dato) {
            $fecha = Carbon::createFromDate($dato->fecha_asignado)->format('d-m-Y h:i');
            $tabla .= '<tr>';
            $tabla .= '<td>' . $dato->numero_visita . '</td>';
            $tabla .= '<td>' . $dato->nombre_uno . ' ' . $dato->apellido_uno . '</td>';
            $tabla .= '<td>' . $dato->opcion_estado_instalacion . '</td>';
            if ($dato->Csserie_remplazo != null || $dato->Csserie_remplazo != "") {
                $tabla .= '<td>' . $dato->Csserie_remplazo . '</td>';
            } else {
                $tabla .= '<td>' . $dato->CsSerie . '</td>';
            }
            if ($dato->CsModelo_es != null || $dato->CsModelo_es != "") {
                $tabla .= '<td>' . $dato->CsModelo_es . '</td>';
            } else {
                $tabla .= '<td>' . $dato->CsModelo . '</td>';
            }
            $tabla .= '<td>' . $dato->Csdireccion . '</td>';
            $tabla .= '<td>' . $dato->Csregion . '</td>';
            $tabla .= '<td>' . $dato->Cscomuna . '</td>';
            $tabla .= '<td>' . $dato->Cscliente . '</td>';
            $tabla .= '<td>' . $fecha . '</td>';
            $tabla .= '<td>' . $dato->CnContador . '</td>';
            $tabla .= '<td>' . $dato->CnContador_color . '</td>';
            $tabla .= '<td>' . $dato->descripcion . '</td>';
            $tabla .= '<td>' . $dato->observacion . '</td>';

            $accesorios = DB::table('checklist_accesorios')
                ->select('accesorios.descripcion as nombre', 'checklist_accesorios.cantidad')
                ->join('accesorios', 'accesorios.id', '=', 'checklist_accesorios.id_accesorio')
                ->where('checklist_accesorios.id_checklist_instalacion', '=', $dato->id)
                ->get();

            $tabla .= '<td>';
            foreach ($accesorios as $key => $partes) {
                $tabla .= ($key + 1) . '-' . $partes->nombre . '(' . $partes->cantidad . ') <br> ';
            }
            $tabla .= '</td>';

            $tabla .= '</tr>';
        }

        return $tabla;
    }

    public function check_historial_retiro(Request $request)
    {

        try {
            $id = Crypt::decryptString($request->id);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }

        $historial = DB::table('checklist_retiros')
            ->select(
                'checklist_retiros.csSerie',
                'checklist_retiros.observacion',
                'checklist_retiros.csDireccion',
                'checklist_retiros.csCiudad',
                'checklist_retiros.csComuna',
                'checklist_retiros.csCliente',
                'checklist_retiros.cnContador',
                'checklist_retiros.cnContador_color',
                'asignacion_retiros.fecha_asignado'
            )
            ->join('asignacion_retiros', 'asignacion_retiros.id', '=', 'checklist_retiros.asignacion_retiros_id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->where('retiros.id', '=', $id)
            ->get();

        $tabla = "";

        foreach ($historial as $dato) {
            $tabla .= '<tr>';
            $tabla .= '<td>' . $dato->csSerie . '</td>';
            $tabla .= '<td>' . $dato->csCiudad . ' ' . $dato->csComuna . '</td>';
            $tabla .= '<td>' . $dato->csCliente . '</td>';
            $tabla .= '<td>' . $dato->fecha_asignado . '</td>';
            $tabla .= '<td>' . $dato->cnContador . '</td>';
            $tabla .= '<td>' . $dato->cnContador_color . '</td>';
            $tabla .= '<td>' . $dato->observacion . '</td>';
            $tabla .= '</tr>';
        }

        return $tabla;
    }
    public function ver_api_solicitudes_old()
    {
        $Api_solicitudes = DB::table('api_solicitudes')
            ->select(
                "api_solicitudes.dFechaCreacion",
                'api_solicitudes.fecha_asignado as fecha_asignada',
                'api_solicitudes.dFechaCreacion as fecha_recepcion',
                'api_solicitudes.sComuna',
                'api_solicitudes.sRegion',
                'api_solicitudes.sCliente',
                'api_solicitudes.sSC',
                'api_solicitudes.id',
                'api_solicitudes.sDireccion',
                'api_solicitudes.estado_interno',
                'api_solicitudes.estado_externo',
            )

            ->orderBy(DB::raw('FIELD(api_solicitudes.estado_interno, "REVISAR","INICIADO","ENTREGADO","POR ASIGNAR","REASIGNAR","RECHAZADO","PENDIENTE","CANCELADO","FINALIZADO")'))
            ->get();

        return view('Apiviews.Api_solicitudes', compact('Api_solicitudes'));
    }
    public function ver_api_solicitudes()
    {
        $Api_solicitudes = DB::table('api_solicitudes')
            // ->leftJoin('asignacion_solicitudes','asignacion_solicitudes.api_solicitudes_id','=','api_solicitudes.id')
            ->select(
                "api_solicitudes.dFechaCreacion",
                // 'asignacion_solicitudes.estado_externo',
                // 'asignacion_solicitudes.estado_interno',
                'api_solicitudes.fecha_asignado as fecha_asignada',
                'api_solicitudes.dFechaCreacion as fecha_recepcion',
                'api_solicitudes.sComuna',
                'api_solicitudes.sRegion',
                'api_solicitudes.sCliente',
                'api_solicitudes.sSC',
                'api_solicitudes.id',
                'api_solicitudes.sDireccion',
                'api_solicitudes.sSerie',
                'api_solicitudes.estado_interno',
                'api_solicitudes.estado_externo',
                'api_solicitudes.id',
            )


            ->orderBy(DB::raw('FIELD(api_solicitudes.estado_interno, "REVISAR","INICIADO","ENTREGADO","POR ASIGNAR","REASIGNAR","RECHAZADO","PENDIENTE","CANCELADO","FINALIZADO")'))
            ->limit(150)->get();

        //obtener trabajadores asociados a checklist
        // $tecnico = DB::table('asignacion_instalacions')
        //     ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
        //     ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
        //     ->where('trabajadors.estado', '=', '1')
        //     ->select('personas.nombre_uno', 'personas.apellido_uno', 'personas.id')
        //     ->orderBy('personas.nombre_uno', 'asc')
        //     ->distinct()
        //     ->get();

         //obtener trabajadores asociados a checklist
         $tecnico = DB::table('trabajadors')
         // ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
         ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
         ->where('trabajadors.estado', '=', '1')
         ->select('personas.nombre_uno', 'personas.apellido_uno', 'personas.id')
         ->orderBy('personas.nombre_uno', 'asc')
         ->distinct()
         ->get();
         // return 
        //Cargar Select Estado
        $carga_selectEstado = DB::table('api_solicitudes')
            ->select('api_solicitudes.estado_externo')
            ->orderBy('api_solicitudes.estado_externo', 'asc')
            ->distinct()
            ->get();
        //Cargar Select Clientes
        $carga_selectClientes = DB::table('api_solicitudes')
            ->select('api_solicitudes.sCliente')
            ->orderBy('api_solicitudes.sCliente', 'asc')
            ->distinct()
            ->get();

        //Cargar Select Region
        $carga_selectRegion = DB::table('api_solicitudes')
            ->select('api_solicitudes.sRegion')
            ->where('api_solicitudes.sRegion', '!=', null)
            //->orderByRaw("CAST(api_solicitudes.sRegion as UNSIGNED) ASC")
            ->orderByRaw(DB::raw("FIELD(api_solicitudes.sRegion,  1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17) ASC"))

            ->distinct()
            ->get();
        //Cargar Select Comuna
        $carga_selectComuna = DB::table('api_solicitudes')
            ->select('api_solicitudes.sComuna')
            ->orderBy('api_solicitudes.sComuna', 'asc')
            ->distinct()
            ->get();

        //Cargar Select direccion
        $direccionTemporal = DB::table('api_solicitudes')
            ->select('api_solicitudes.sDireccion as descripcion_direccion')

            ->distinct()
            ->get();


        $id_persona = "";
        $direccion = "";
        $sucursal = "";
        $sc = "";
        $serie = "";
        $comuna = "";
        $region = "";
        $estado = "";
        $cliente = "";
        return view('Apiviews.Api_solicitudes', compact('direccionTemporal', 'carga_selectComuna', 'carga_selectRegion', 'cliente', 'carga_selectClientes', 'carga_selectEstado', 'direccion', 'sucursal', 'sc', 'serie', 'comuna', 'region', 'estado', 'id_persona', 'tecnico', 'Api_solicitudes'));
    }
    public function check_tecnico_servicios()
    {
        // $databases = $this->nombre_database();
        $databases = App\bd_proveedores::selectDB();

        //return $databases;
        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();
        $id_trabajador = $datos_trabajador[0]->id;

        foreach ($databases as $los_datos) {
            $asignacion_solicitudes[] = DB::connection(strtolower($los_datos->Database))->table('asignacion_solicitudes')
                ->join('api_solicitudes', 'api_solicitudes.id', '=', 'asignacion_solicitudes.api_solicitudes_id')
                ->select('api_solicitudes.sDescripcion','asignacion_solicitudes.motivo_rechazo', 'api_solicitudes.proveedor_servicio', 'api_solicitudes.sSC', 'asignacion_solicitudes.id as idAsig', 'api_solicitudes.sComuna', 'asignacion_solicitudes.fecha', 'asignacion_solicitudes.estado_interno', 'asignacion_solicitudes.estado_externo', 'api_solicitudes.sDireccion', 'api_solicitudes.sSerie', 'api_solicitudes.sCliente')
                ->where('asignacion_solicitudes.estado_interno', '=', "tarea_asignada")
                ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador)
                ->orwhere('asignacion_solicitudes.estado_interno', '=', "INICIADO")
                ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador)
                ->orwhere('asignacion_solicitudes.estado_interno', '=', "EN TRANSITO")
                ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador)
                ->orwhere('asignacion_solicitudes.estado_interno', '=', "ESPERANDODO")
                ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador)
                ->orwhere('asignacion_solicitudes.estado_interno', '=', "RECHAZADO")
                ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador)
                ->orwhere('asignacion_solicitudes.estado_interno', '=', "REVISAR")
                ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador)
                ->where('api_solicitudes.sSC', '=', 'SC149914')
                ->get();
        }

        //Cargar Select Estado
        $estado_instalacion = DB::table('asignacion_instalacions')
            ->select('estado_asignacion')
            ->where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->distinct();

        $estado_retiros = DB::table('asignacion_retiros')
            ->select('estado_asignacion')
            ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->union($estado_instalacion)
            ->distinct()
            ->get();


        //Cargar Select Estado
        $tipo_asignacion = DB::table('asignacion_instalacions')
            ->select('asignacion_instalacions.tipo')
            ->where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador);

        $asignaciones = DB::table('asignacion_retiros')
            ->select('asignacion_retiros.tipo')
            ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->union($tipo_asignacion)
            ->distinct()
            ->get();

        //Cargar comunas
        $comuna_instalacion = DB::table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->select('checklist_instalacions.Cscomuna')

            ->where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador);

        $comuna_retiros = DB::table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->select('checklist_retiros.Cscomuna')
            ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->union($comuna_instalacion)
            ->get();


        $datos_asignacion = "";
        $estado_retiros = "";

        //return $asignacion_solicitudes;
        return view('solicitudes_servicios.check_tecnico_solicitud_servicios', compact('datos_asignacion', 'estado_retiros', 'comuna_retiros', 'asignacion_solicitudes'));
    }


    public function filtros_solicitudes_proveedores(Request $request)
    {
        $id_persona = $request->tecnicos;
        $estado = $request->estado;
        $clientes = $request->clientes;
        $region = $request->region;
        $comuna = $request->comuna;
        $serie = $request->serie;
        $sSC = $request->sSC;

        $direccion = $request->direccion;
        $cliente_seleccionado = $request->clientes;
        $fecha = "";
        $fecha2 = "";



        $Api_solicitudesAcumulador = DB::table('api_solicitudes')
            // ->Join('asignacion_solicitudes','asignacion_solicitudes.api_solicitudes_id','=','api_solicitudes.id')

            ->select(
                "api_solicitudes.dFechaCreacion",
                'api_solicitudes.fecha_asignado as fecha_asignada',
                'api_solicitudes.dFechaCreacion as fecha_recepcion',
                'api_solicitudes.sComuna',
                'api_solicitudes.sRegion',
                'api_solicitudes.sCliente',
                'api_solicitudes.sSC',
                'api_solicitudes.sSerie',
                'api_solicitudes.id',
                'api_solicitudes.sDireccion',
                'api_solicitudes.estado_interno',
                'api_solicitudes.estado_externo',
            )
            ->where('api_solicitudes.proveedor_servicio', '=', Auth::user()->nombre_proveedor);

        // if ($id_persona != "") {
        //     $id_trabajador =  DB::table('trabajadors')
        //         ->select('trabajadors.id')

        //         ->get();


        //     $Api_solicitudesAcumulador->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id');
        //     $Api_solicitudesAcumulador->where("asignacion_solicitudes.trabajadors_id", "=", $id_trabajador[0]->id);
        // }


        if ($request->datepicker != "" && $request->datepicker2 != "") {
            $fecha = Carbon::createFromDate($request->datepicker)->format('Y-m-d');
            $fecha2 = Carbon::createFromDate($request->datepicker2)->format('Y-m-d');
            // $where = $where . " and instalacions.fecha_instalacion_coordinadora" . " BETWEEN " . "'" . $fecha . "'" . " and " . "'" . $fecha2 . "'";
            // $query->whereBetween('age', [$ageFrom, $ageTo]);

            $Api_solicitudesAcumulador->whereBetween('api_solicitudes.fecha_asignado', [$fecha, $fecha2]);
        }


        if ($direccion != "") {
            $Api_solicitudesAcumulador->where("api_solicitudes.sDireccion", "=", $direccion);
        }
        if ($region != "") {
            $Api_solicitudesAcumulador->where("api_solicitudes.sRegion", "=", $region);
        }
        if ($comuna != "") {
            $Api_solicitudesAcumulador->where("api_solicitudes.sComuna", "=", $comuna);
        }
        if ($estado != "") {
            $Api_solicitudesAcumulador->where("api_solicitudes.estado_externo", "=", $estado);
        }
        if ($comuna != "") {
            $Api_solicitudesAcumulador->where("api_solicitudes.sComuna", "=", $comuna);
        }
        if ($serie != "") {
            $Api_solicitudesAcumulador->where("api_solicitudes.sSerie", "=", $serie);
        }
        if ($sSC != "") {
            $Api_solicitudesAcumulador->where("api_solicitudes.sSC", "=", $sSC);
        }
        if ($clientes != "") {
            $Api_solicitudesAcumulador->where("api_solicitudes.sCliente", "=", $clientes);
        }



        $Api_solicitudes = $Api_solicitudesAcumulador->get();

        //obtener trabajadores asociados a checklist
        $tecnico = DB::table('asignacion_instalacions')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('trabajadors.estado', '=', '1')
            ->select('personas.nombre_uno', 'personas.apellido_uno', 'personas.id')
            ->orderBy('personas.nombre_uno', 'asc')
            ->distinct()
            ->get();
        //Cargar Select Estado
        $carga_selectEstado = DB::table('api_solicitudes')
            ->select('api_solicitudes.estado_externo')
            ->orderBy('api_solicitudes.estado_externo', 'asc')
            ->where('api_solicitudes.proveedor_servicio', '=', Auth::user()->nombre_proveedor)

            ->distinct()
            ->get();
        //Cargar Select Clientes
        $carga_selectClientes = DB::table('api_solicitudes')
            ->select('api_solicitudes.sCliente')
            ->orderBy('api_solicitudes.sCliente', 'asc')
            ->where('api_solicitudes.proveedor_servicio', '=', Auth::user()->nombre_proveedor)

            ->distinct()
            ->get();

        //Cargar Select Region
        $carga_selectRegion = DB::table('api_solicitudes')
            ->select('api_solicitudes.sRegion')
            ->where('api_solicitudes.sRegion', '!=', null)
            //->orderByRaw("CAST(api_solicitudes.sRegion as UNSIGNED) ASC")
            ->orderByRaw(DB::raw("FIELD(api_solicitudes.sRegion,  1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17) ASC"))
            ->where('api_solicitudes.proveedor_servicio', '=', Auth::user()->nombre_proveedor)

            ->distinct()
            ->get();
        //Cargar Select Comuna
        $carga_selectComuna = DB::table('api_solicitudes')
            ->select('api_solicitudes.sComuna')
            ->orderBy('api_solicitudes.sComuna', 'asc')
            ->where('api_solicitudes.proveedor_servicio', '=', Auth::user()->nombre_proveedor)

            ->distinct()
            ->get();

        //Cargar Select direccion
        $direccionTemporal = DB::table('api_solicitudes')
            ->select('api_solicitudes.sDireccion as descripcion_direccion')

            ->distinct()
            ->get();



        $id_persona = $request->tecnicos;
        $estado = $request->estado;
        $clientes = $request->clientes;
        $region = $request->region;
        $comuna = $request->comuna;
        $serie = $request->serie;
        $sSC = $request->sSC;

        $direccion = $request->direccion;
        $cliente_seleccionado = $request->clientes;
        $fecha = "";
        $fecha2 = "";


        $id_persona = $id_persona;
        $direccion = $direccion;
        $sucursal = "";
        $sc = $sSC;
        $serie = $serie;
        $comuna = $comuna;
        $region = $region;
        $estado = $estado;
        $cliente = $cliente_seleccionado;
        return view('portal.vista_proveedor_servicio', compact('direccionTemporal', 'carga_selectComuna', 'carga_selectRegion', 'cliente', 'carga_selectClientes', 'carga_selectEstado', 'direccion', 'sucursal', 'sc', 'serie', 'comuna', 'region', 'estado', 'id_persona', 'tecnico', 'Api_solicitudes'));
    }

    public function filtros_solicitudes(Request $request)
    {




        $id_persona = $request->tecnicos;
        $estado = $request->estado;
        $clientes = $request->clientes;
        $region = $request->region;
        $comuna = $request->comuna;
        $serie = $request->serie;
        $sSC = $request->sSC;

        $direccion = $request->direccion;
        $cliente_seleccionado = $request->clientes;
        $fecha = "";
        $fecha2 = "";


        if ($request->estado_opcional != "") {
            $Api_solicitudesAcumulador = DB::table('asignacion_solicitudes')
                ->join("check_formulario_solicitudes", "check_formulario_solicitudes.id", "=", "asignacion_solicitudes.check_formulario_solicitudes_id")
                ->join("api_solicitudes", "api_solicitudes.id", "=", "asignacion_solicitudes.api_solicitudes_id")
                ->select(
                    "asignacion_solicitudes.fecha as dFechaCreacion",
                    'asignacion_solicitudes.fecha as fecha_asignada',
                    'asignacion_solicitudes.fecha as fecha_recepcion',
                    'check_formulario_solicitudes.sComuna',
                    'check_formulario_solicitudes.sRegion',
                    'check_formulario_solicitudes.sCliente',
                    'check_formulario_solicitudes.sSC',
                    'check_formulario_solicitudes.sSerie',
                    'api_solicitudes.id',
                    'check_formulario_solicitudes.sDireccion',
                    'asignacion_solicitudes.estado_interno',
                    'asignacion_solicitudes.estado_externo',
                )->where('check_formulario_solicitudes.estado_seleccionado', '=', $request->estado_opcional);

            $Api_solicitudes = $Api_solicitudesAcumulador->get();
        } else {
            
            $Api_solicitudesAcumulador = DB::table('api_solicitudes')
                ->select(
                    "api_solicitudes.dFechaCreacion",
                    'api_solicitudes.fecha_asignado as fecha_asignada',
                    'api_solicitudes.dFechaCreacion as fecha_recepcion',
                    'api_solicitudes.sComuna',
                    'api_solicitudes.sRegion',
                    'api_solicitudes.sCliente',
                    'api_solicitudes.sSC',
                    'api_solicitudes.sSerie',
                    'api_solicitudes.id',
                    'api_solicitudes.sDireccion',
                    'api_solicitudes.estado_interno',
                    'api_solicitudes.estado_externo',
                );

            if ($id_persona != "") {
                $id_trabajador =  DB::table('trabajadors')
                    ->select('trabajadors.id')
                    ->where('trabajadors.id_persona', '=', $id_persona)
                    
                    ->get();


                $Api_solicitudesAcumulador->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id');
                $Api_solicitudesAcumulador->where("asignacion_solicitudes.trabajadors_id", "=", $id_trabajador[0]->id)->where('asignacion_solicitudes.estado_interno', '!=', "CAMBIO_TECNICO")
                ;
            }


            if ($request->datepicker != "" && $request->datepicker2 != "") {
                $fecha = Carbon::createFromDate($request->datepicker)->format('Y-m-d');
                $fecha2 = Carbon::createFromDate($request->datepicker2)->format('Y-m-d');
                // $where = $where . " and instalacions.fecha_instalacion_coordinadora" . " BETWEEN " . "'" . $fecha . "'" . " and " . "'" . $fecha2 . "'";
                // $query->whereBetween('age', [$ageFrom, $ageTo]);
                $Api_solicitudesAcumulador->whereBetween('fecha_asignado', [$fecha, $fecha2]);
            }


            if ($direccion != "") {
                $Api_solicitudesAcumulador->where("api_solicitudes.sDireccion", "=", $direccion);
            }
            if ($region != "") {
                $Api_solicitudesAcumulador->where("api_solicitudes.sRegion", "=", $region);
            }
            if ($comuna != "") {
                $Api_solicitudesAcumulador->where("api_solicitudes.sComuna", "=", $comuna);
            }
            if ($estado != "") {
                $Api_solicitudesAcumulador->where("api_solicitudes.estado_externo", "=", $estado);
            }
            if ($comuna != "") {
                $Api_solicitudesAcumulador->where("api_solicitudes.sComuna", "=", $comuna);
            }
            if ($serie != "") {
                $Api_solicitudesAcumulador->where("api_solicitudes.sSerie", "=", $serie);
            }
            if ($sSC != "") {
                $Api_solicitudesAcumulador->where("api_solicitudes.sSC", "=", $sSC);
            }
            if ($clientes != "") {
                $Api_solicitudesAcumulador->where("api_solicitudes.sCliente", "=", $clientes);
            }

            $Api_solicitudesAcumulador->orderBy(DB::raw('FIELD(api_solicitudes.estado_interno, "REVISAR","INICIADO","ENTREGADO","POR ASIGNAR","REASIGNAR","RECHAZADO","PENDIENTE","CANCELADO","FINALIZADO")'));

            $Api_solicitudes = $Api_solicitudesAcumulador->get();
        } //opcional
        //obtener trabajadores asociados a checklist
        // $tecnico = DB::table('asignacion_instalacions')
        //     ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
        //     ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
        //     ->where('trabajadors.estado', '=', '1')
        //     ->select('personas.nombre_uno', 'personas.apellido_uno', 'personas.id')
        //     ->orderBy('personas.nombre_uno', 'asc')
        //     ->distinct()
        //     ->get();

        $tecnico = DB::table('trabajadors')
        // ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
        ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
        ->where('trabajadors.estado', '=', '1')
        ->select('personas.nombre_uno', 'personas.apellido_uno', 'personas.id')
        ->orderBy('personas.nombre_uno', 'asc')
        ->distinct()
        ->get();
        //Cargar Select Estado
        $carga_selectEstado = DB::table('api_solicitudes')
            ->select('api_solicitudes.estado_externo')
            ->orderBy('api_solicitudes.estado_externo', 'asc')
            ->distinct()
            ->get();
        //Cargar Select Clientes
        $carga_selectClientes = DB::table('api_solicitudes')
            ->select('api_solicitudes.sCliente')
            ->orderBy('api_solicitudes.sCliente', 'asc')
            ->distinct()
            ->get();

        //Cargar Select Region
        $carga_selectRegion = DB::table('api_solicitudes')
            ->select('api_solicitudes.sRegion')
            ->where('api_solicitudes.sRegion', '!=', null)
            //->orderByRaw("CAST(api_solicitudes.sRegion as UNSIGNED) ASC")
            ->orderByRaw(DB::raw("FIELD(api_solicitudes.sRegion,  1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17) ASC"))

            ->distinct()
            ->get();
        //Cargar Select Comuna
        $carga_selectComuna = DB::table('api_solicitudes')
            ->select('api_solicitudes.sComuna')
            ->orderBy('api_solicitudes.sComuna', 'asc')
            ->distinct()
            ->get();

        //Cargar Select direccion
        $direccionTemporal = DB::table('api_solicitudes')
            ->select('api_solicitudes.sDireccion as descripcion_direccion')

            ->distinct()
            ->get();



        $id_persona = $request->tecnicos;
        $estado = $request->estado;
        $clientes = $request->clientes;
        $region = $request->region;
        $comuna = $request->comuna;
        $serie = $request->serie;
        $sSC = $request->sSC;

        $direccion = $request->direccion;
        $cliente_seleccionado = $request->clientes;
        $fecha = "";
        $fecha2 = "";


        $id_persona = $id_persona;
        $direccion = $direccion;
        $sucursal = "";
        $sc = $sSC;
        $serie = $serie;
        $comuna = $comuna;
        $region = $region;
        $estado = $estado;
        $cliente = $cliente_seleccionado;
        return view('Apiviews.Api_solicitudes', compact('direccionTemporal', 'carga_selectComuna', 'carga_selectRegion', 'cliente', 'carga_selectClientes', 'carga_selectEstado', 'direccion', 'sucursal', 'sc', 'serie', 'comuna', 'region', 'estado', 'id_persona', 'tecnico', 'Api_solicitudes'));

        return $re;
    }

    public function buscarComunasSolicitud(request $request)
    {

        $carga_selectComuna = DB::table('api_solicitudes')
            ->select('api_solicitudes.sComuna')
            ->orderBy('api_solicitudes.sComuna', 'asc')
            // ->orderByRaw(DB::raw("FIELD(api_solicitudes.sRegion, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17 ) ASC"))
            ->where("api_solicitudes.sRegion", "=", $request->region)

            ->distinct()
            ->get();

        return  $carga_selectComuna;
    }


    public function buscardireccionessolicitudes(request $request)
    {

        $carga_selectComuna = DB::table('api_solicitudes')
            ->select('api_solicitudes.sDireccion')
            ->orderBy('api_solicitudes.sDireccion', 'asc')


            // ->orderByRaw(DB::raw("FIELD(api_solicitudes.sRegion, 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17 ) ASC"))

            ->where("api_solicitudes.sComuna", "=", $request->comuna)

            ->distinct()
            ->get();

        return $carga_selectComuna;
    }
    public function check_historial_instalacion_home(Request $request)
    {

        // return "x";
        $id = $request->id;
        $historial = DB::table('checklist_instalacions')
            ->select(
                'checklist_instalacions.id',
                'checklist_instalacions.CsSerie',
                'checklist_instalacions.observacion',
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscliente',
                'checklist_instalacions.CnContador',
                'checklist_instalacions.Csserie_remplazo',
                'checklist_instalacions.CnContador_color',
                'asignacion_instalacions.fecha_asignado',
                'asignacion_instalacions.numero_visita',
                'asignacion_instalacions.opcion_estado_instalacion',
                'tipos_visitas.descripcion',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'checklist_instalacions.CsModelo',
                'checklist_instalacions.CsModelo_es',
                'checklist_instalacions.Csregion',
                'checklist_instalacions.Cscomuna',
                //'accesorios.descripcion as nombre'
            )
            ->join('asignacion_instalacions', 'asignacion_instalacions.id', '=', 'checklist_instalacions.asignacion_instalacion_retiro_id')
            ->join('tipos_visitas', 'tipos_visitas.id', '=', 'asignacion_instalacions.tipos_visitas_id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('instalacions.id', '=', $id)
            ->get();

        $tabla = "";

        foreach ($historial as $dato) {
            $fecha = Carbon::createFromDate($dato->fecha_asignado)->format('d-m-Y H:s');
            $tabla .= '<tr>';
            $tabla .= '<td>' . $dato->numero_visita . '</td>';
            $tabla .= '<td>' . $dato->nombre_uno . ' ' . $dato->apellido_uno . '</td>';
            $tabla .= '<td>' . $dato->opcion_estado_instalacion . '</td>';
            if ($dato->Csserie_remplazo != null || $dato->Csserie_remplazo != "") {
                $tabla .= '<td>' . $dato->Csserie_remplazo . '</td>';
            } else {
                $tabla .= '<td>' . $dato->CsSerie . '</td>';
            }
            if ($dato->CsModelo_es != null || $dato->CsModelo_es != "") {
                $tabla .= '<td>' . $dato->CsModelo_es . '</td>';
            } else {
                $tabla .= '<td>' . $dato->CsModelo . '</td>';
            }
            $tabla .= '<td>' . $dato->Csdireccion . '</td>';
            $tabla .= '<td>' . $dato->Csregion . '</td>';
            $tabla .= '<td>' . $dato->Cscomuna . '</td>';
            $tabla .= '<td>' . $dato->Cscliente . '</td>';
            $tabla .= '<td>' . $fecha . '</td>';
            $tabla .= '<td>' . $dato->CnContador . '</td>';
            $tabla .= '<td>' . $dato->CnContador_color . '</td>';
            $tabla .= '<td>' . $dato->descripcion . '</td>';
            $tabla .= '<td>' . $dato->observacion . '</td>';

            $accesorios = DB::table('checklist_accesorios')
                ->select('accesorios.descripcion as nombre', 'checklist_accesorios.cantidad')
                ->join('accesorios', 'accesorios.id', '=', 'checklist_accesorios.id_accesorio')
                ->where('checklist_accesorios.id_checklist_instalacion', '=', $dato->id)
                ->get();

            $tabla .= '<td>';
            foreach ($accesorios as $key => $partes) {
                $tabla .= ($key + 1) . '-' . $partes->nombre . '(' . $partes->cantidad . ') <br> ';
            }
            $tabla .= '</td>';

            $tabla .= '</tr>';
        }

        return $tabla;
    }
    public function check_historial_retiro_home(Request $request)
    {
        $id = $request->id;

        $historial = DB::table('checklist_retiros')
            ->select(
                'checklist_retiros.csSerie',
                'checklist_retiros.observacion',
                'checklist_retiros.csDireccion',
                'checklist_retiros.csCiudad',
                'checklist_retiros.csComuna',
                'checklist_retiros.csCliente',
                'checklist_retiros.cnContador',
                'checklist_retiros.cnContador_color',
                'asignacion_retiros.fecha_asignado'
            )
            ->join('asignacion_retiros', 'asignacion_retiros.id', '=', 'checklist_retiros.asignacion_retiros_id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->where('retiros.id', '=', $id)
            ->get();

        $tabla = "";

        foreach ($historial as $dato) {
            $tabla .= '<tr>';
            $tabla .= '<td>' . $dato->csSerie . '</td>';
            $tabla .= '<td>' . $dato->csCiudad . ' ' . $dato->csComuna . '</td>';
            $tabla .= '<td>' . $dato->csCliente . '</td>';
            $tabla .= '<td>' . $dato->fecha_asignado . '</td>';
            $tabla .= '<td>' . $dato->cnContador . '</td>';
            $tabla .= '<td>' . $dato->cnContador_color . '</td>';
            $tabla .= '<td>' . $dato->observacion . '</td>';
            $tabla .= '</tr>';
        }

        return $tabla;
    }
    public function correos (){

        $clientes = App\clientes::where('razon_social','!=','global')->where('razon_social','!=','SERVICIOS')->get();

        return view('email.correos',compact('clientes'));

    }
    public function cambio_envio (request $request){

        $clientes = App\proyectos::where('id','=',$request->id)->get();

        if($clientes[0]->enviar_reporte_diario == 1){
            $clientes = App\proyectos::findOrfail($request->id);
            $clientes->enviar_reporte_diario = 0;
            $clientes->timestamps = false;
            $clientes->save();
            
        }else{
            $clientes = App\proyectos::findOrfail($request->id);
            $clientes->enviar_reporte_diario = 1;
            $clientes->timestamps = false;
            $clientes->save();
        }

    }

    public function sla (){

        // $clientes = App\clientes::where('razon_social','!=','global')->where('razon_social','!=','SERVICIOS')->get();
             $proveeedores =    DB::table('config_usuarios')->where("estado","=",1)->get();
 
         return view('sla.websla',compact('proveeedores'));
 
     }
     public function festivos (){
 
         // $clientes = App\clientes::where('razon_social','!=','global')->where('razon_social','!=','SERVICIOS')->get();
              $festivos =    DB::table('dias_festivos')->where("estado","=",0)->get();
  
          return view('sla.festivos',compact('festivos'));
  
      }
}
