<?php

namespace App\Http\Controllers\checklist;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Contracts\Encryption\DecryptException;
use Crypt;
use App;
use Illuminate\Support\Facades\Storage;
use App\direccion;
use App\persona;
use App\User;
use App\checklist_instalacions;
use App\fotos_checks_accesorios;
use App\Accesorios;
use Auth;
use Session;
use DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Carbon\Carbon;

class checklistController extends Controller
{

    // public function __construct()
    // {
    //     $this->middleware('auth');
    // }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(request $request, $idinstalacion)
    {




        try {
            $idinstalacion_desin = Crypt::decryptString($idinstalacion);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }

        $rules = [
            'tipo_visita' => 'required|max:100',
            'proyectos' => 'required|max:10',
            'numero_visita' => 'required|max:10',
            'tecnico' => 'required|max:10',
            'fecha_instalacion' => 'date|required'
        ];

        $this->validate($request, $rules);

        $info_tracker = DB::table('tracker')
            ->where('tracker.tipo_tracker', '=', "instalacion")
            ->where('tracker.proyecto_id', '=', $request->proyectos)
            ->get();




        $datos_instalacion =  App\instalacions::findOrfail($idinstalacion_desin);
        $datos_instalacion->tracker_idtracker = $info_tracker[0]->id;
        $datos_instalacion->sEstado_instalacion = "asignado";
        $datos_instalacion->fecha_instalacion_coordinadora     =   $request->fecha_instalacion;

        $datos_instalacion->timestamps = false;
        $datos_instalacion->save();


        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();

        $FechaHoraActual  = Carbon::now();
        $FechaHoraActual = $FechaHoraActual->toDateTimeString();

        $asignacion_ins = new App\asignacion_instalacions;
        $asignacion_ins->trabajadors_id     =  $request->tecnico;
        $asignacion_ins->lista_instalacion_id     =  $idinstalacion_desin;
        $asignacion_ins->numero_visita     = $request->numero_visita;
        $asignacion_ins->estado_asignacion     =  "tarea_asignada";
        $asignacion_ins->detalle_costo_id     =   1;
        $asignacion_ins->trabajadors_id_cordinador   = $datos_trabajador[0]->id;
        $asignacion_ins->tipos_visitas_id     =  $request->tipo_visita;
        $asignacion_ins->fecha_instalacion     =  $request->fecha_instalacion;
        $asignacion_ins->fecha_asignado     =  $FechaHoraActual;



        $asignacion_ins->timestamps = false;
        $asignacion_ins->save();



        $datos_api_intalacion = DB::table('instalacions')
            ->where('instalacions.id', '=', $idinstalacion_desin)
            ->get();





        $checklist_instalacion_ = new App\checklist_instalacions;
        $checklist_instalacion_->asignacion_instalacion_retiro_id = $asignacion_ins->id;
        $checklist_instalacion_->Cnfolio     = $datos_api_intalacion[0]->nFolio;
        $checklist_instalacion_->Csrut     = $datos_api_intalacion[0]->sRut;
        $checklist_instalacion_->Cscliente     = $datos_api_intalacion[0]->sCliente;
        $checklist_instalacion_->Csdireccion     = $datos_api_intalacion[0]->sDireccion;

        $checklist_instalacion_->Cscomuna      = $datos_api_intalacion[0]->sComuna;
        $checklist_instalacion_->Csciudad      = $datos_api_intalacion[0]->sCiudad;
        $checklist_instalacion_->Cscui      = $datos_api_intalacion[0]->sCui;
        $checklist_instalacion_->Cstipo_sucursal      = $datos_api_intalacion[0]->sTipo_sucursal;
        $checklist_instalacion_->Cscontacto      = $datos_api_intalacion[0]->sContacto;
        $checklist_instalacion_->Csn_contacto      = $datos_api_intalacion[0]->sN_contacto;
        $checklist_instalacion_->CsSerie      = $datos_api_intalacion[0]->sSerie;
        $checklist_instalacion_->CsModelo      = $datos_api_intalacion[0]->sModelo;
        $checklist_instalacion_->CUsb_red     = $datos_api_intalacion[0]->sUsb_red;
        $checklist_instalacion_->CDriver     = $datos_api_intalacion[0]->sDriver;
        $checklist_instalacion_->CsSC     = $datos_api_intalacion[0]->sSC;
        $checklist_instalacion_->CsIP     = $datos_api_intalacion[0]->sIP;
        $checklist_instalacion_->CsMsk     = $datos_api_intalacion[0]->sMsk;
        $checklist_instalacion_->CsGateway     = $datos_api_intalacion[0]->sGateway;
        $checklist_instalacion_->CsMac     = $datos_api_intalacion[0]->sMac;
        $checklist_instalacion_->CsBandeja_adicional     = $datos_api_intalacion[0]->sBandeja_adicional;
        $checklist_instalacion_->CsMueble     = $datos_api_intalacion[0]->sMueble;
        $checklist_instalacion_->CsKit_lector     = $datos_api_intalacion[0]->sKit_lector;
        $checklist_instalacion_->CsCable_poder     = $datos_api_intalacion[0]->sCable_poder;
        $checklist_instalacion_->CsSD     = $datos_api_intalacion[0]->sSD;
        $checklist_instalacion_->CsCable_red     = $datos_api_intalacion[0]->sCable_red;
        $checklist_instalacion_->CdFecha_plan_despacho     = $datos_api_intalacion[0]->dFecha_plan_despacho;
        $checklist_instalacion_->CnGuia     = $datos_api_intalacion[0]->nGuia;
        $checklist_instalacion_->CsEstado_despacho     = $datos_api_intalacion[0]->sEstado_despacho;
        $checklist_instalacion_->CnContador     = $datos_api_intalacion[0]->nContador;
        $checklist_instalacion_->CnContador_color     = $datos_api_intalacion[0]->nContador_color;


        $checklist_instalacion_->CsEstado_instalacion     = $datos_api_intalacion[0]->sCable_poder;
        $checklist_instalacion_->CsObservacion     = $datos_api_intalacion[0]->sObservacion;
        $checklist_instalacion_->idSala     = $datos_api_intalacion[0]->idSala;

        // $checklist_instalacion_->Csmarca	 = $datos_api_intalacion[0]->sCable_poder ;
        $checklist_instalacion_->softwares_id = "1";
        $checklist_instalacion_->timestamps = false;
        $checklist_instalacion_->save();


        //   return back()->with('mensaje', 'Checklist Asignado');    
        //return redirect('ver_api_instalaciones')->with('mensaje', 'Checklist Asignado');  
        return redirect(session('url_cordinadora'))->with('mensaje', 'Checklist Asignado');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }



    public function asignar_check()
    {


        $url =  $_GET['url_filtro'];

        session(['url_cordinadora' => $url]);


        try {
            $id_instalacion = Crypt::decryptString($_GET['idintalacion']);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }

        $Client = DB::table('instalacions')
            ->select('instalacions.sCliente')
            ->where('id', '=', $id_instalacion)
            ->get();
        $nID_Tracker = DB::table('instalacions')
            ->join('tracker', 'tracker.id', 'instalacions.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', 'tracker.proyecto_id')
            ->select('proyectos.clientes_id')
            ->where('sCliente', '=', $Client[0]->sCliente)
            ->where('instalacions.tracker_idtracker', '!=', 1)
            ->orderBy('instalacions.id', 'ASC')
            ->get();
        count($nID_Tracker);
        $trabajadores = DB::table('personas')
            ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
            ->join('users', 'users.id', '=', 'trabajadors.id_login')
            ->where('trabajadors.estado', '=', '1')
            ->where('users.tipo_usuario', '=', 'trabajador')
            ->select('personas.nombre_uno', 'personas.apellido_uno', 'personas.apellido_dos', 'trabajadors.id')
            ->get();

        $tipos_visitas = DB::table('tipos_visitas')
            ->where('tipos_visitas.estado', '=', '1')
            ->select('tipos_visitas.descripcion', 'tipos_visitas.id')
            ->get();

        if (count($nID_Tracker) > 0) {
            $proyectos = DB::table('proyectos')
                ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
                ->where('proyectos.estado', '=', '1')
                ->where('proyectos.id', '!=', '1')
                ->where('proyectos.nombre', '!=', 'SERVICIOS')
                ->where('proyectos.clientes_id', '=', $nID_Tracker[0]->clientes_id)
                ->select('proyectos.nombre', 'clientes.razon_social', 'proyectos.id as id_proyecto')
                ->get();
        } else {
            $proyectos = DB::table('proyectos')
                ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
                ->where('proyectos.estado', '=', '1')
                ->where('proyectos.id', '!=', '1')
                ->where('proyectos.nombre', '!=', 'SERVICIOS')
                ->select('proyectos.nombre', 'clientes.razon_social', 'proyectos.id as id_proyecto')
                ->get();
        }

        $api_instalaciones = DB::table('instalacions')
            ->where('instalacions.id', '=', $id_instalacion)
            ->select(
                'instalacions.sCliente',
                'instalacions.dFecha_instalacion',
                'instalacions.sDireccion',
                'instalacions.sComuna',
                'instalacions.sContacto',
                'instalacions.sCui',
                'instalacions.sSC',
                'instalacions.sModelo',
                'instalacions.sSerie',
                'instalacions.sIP',
                'instalacions.sMsk',
                'instalacions.sGateway',
                'instalacions.sMac',
                'instalacions.nContador',
                'instalacions.nContador_color',
                'instalacions.sCable_red',
                'instalacions.sCable_poder',
                'instalacions.sBandeja_adicional',
                'instalacions.sMueble',
                'instalacions.sKit_lector',
                'instalacions.sSD',
                'instalacions.sCable_red',
                'instalacions.sCable_poder',
                'instalacions.id as id_instalacion',
                'instalacions.tipo',
                'instalacions.razonSocial',
                'instalacions.idSala'

            )
            ->get();

    
            $tipo = $api_instalaciones[0]->tipo;
            $razonsocial =$api_instalaciones[0]->razonSocial;
            $cliente = $Client[0]->sCliente;


            $con_razonSocial= "no";
            $razonAgrupasa = DB::table('clientes')
            ->select('razon_social_agrupada')
            ->where('clientes.razon_social', '=', $cliente)
            ->get();


            if(count($razonAgrupasa ) >0){
              $con_razonSocial = $razonAgrupasa[0]->razon_social_agrupada;
            }else{
                $con_razonSocial= "no";
            
            }

        //buscamos las asignaciones para poder saber cual es el numero de visita

        $datos_asignacion = DB::table('asignacion_instalacions')
            ->where('asignacion_instalacions.lista_instalacion_id', '=', $id_instalacion)
            ->get();

        if (count($datos_asignacion) == 0) {
            $total_dias = 1;
        } else {
            $total_dias = count($datos_asignacion) + 1;
        }


        return view('check.asignar_checklist', compact('con_razonSocial','cliente','tipo','razonsocial','trabajadores', 'tipos_visitas', 'proyectos', 'api_instalaciones', 'total_dias'));
    }


    public function asignar_check_retiro()
    {
        return view('check.asignar_checklistretiro');
    }
    public function check_asociados_proveedor(Request $request)
    {
        # code...

        try {
            $id_instalacion = Crypt::decryptString($request->id_instalacion);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }


        $datos_asignacion = DB::table('asignacion_instalacions')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('asignacion_instalacions.lista_instalacion_id', '=', $id_instalacion)
            ->select('asignacion_instalacions.id', 'personas.nombre_uno', 'personas.apellido_uno', 'asignacion_instalacions.estado_asignacion', 'asignacion_instalacions.fecha_instalacion')
            ->orderBy('asignacion_instalacions.id', 'desc')

            ->get();
        $i = 1;
        $totoal = count($datos_asignacion);
        $totoal = $totoal + 1;
        $tbody = "";
        if (count($datos_asignacion) > 0) {



            foreach ($datos_asignacion as $row) {
                $j = $i++;
                $tbody .= "<tr>";
                $tbody .= "<td>" . $id_instalacion . "</td>";
                $tbody .= "<td>" . ($totoal - $j) . "</td>";
                $tbody .= "<td> " . $row->nombre_uno . " " . $row->apellido_uno . "</td>";

                if ($row->estado_asignacion == "pendiente" || $row->estado_asignacion == "Pendiente") {
                    $tbody .= '<td class="pendiente">' . $row->estado_asignacion . "</td>";
                } else if ($row->estado_asignacion == "cancelado" || $row->estado_asignacion == "Cancelado") {
                    $tbody .= '<td class="cancelado">' . $row->estado_asignacion . "</td>";
                } else if ($row->estado_asignacion == "reasignar" || $row->estado_asignacion == "Reasignar") {
                    $tbody .= '<td class="cancelado">' . "Reasignar" . "</td>";
                } else if ($row->estado_asignacion == "finalizado" || $row->estado_asignacion == "Finalizado") {
                    $tbody .= '<td class="finalizado">' . $row->estado_asignacion . "</td>";
                } else if ($row->estado_asignacion == "asignado" || $row->estado_asignacion == "Asignado") {
                    $tbody .= '<td class="asignado">' . $row->estado_asignacion . "</td>";
                } else if ($row->estado_asignacion == "revisar" || $row->estado_asignacion == "revisar") {
                    $tbody .= '<td class="revisado">' . "Revisar" . "</td>";
                } else if ($row->estado_asignacion == "rechazado" || $row->estado_asignacion == "Rechazado") {
                    $tbody .= '<td class="rechazado">' . $row->estado_asignacion . "</td>";
                } else if ($row->estado_asignacion == "tarea_asignada" || $row->estado_asignacion == "Tarea_asignada") {
                    $tbody .= '<td class="pendiente">' . "Tarea Asignada" . "</td>";
                }



                //boton editar
                $tbody .= "<td>";
                //boton finalizar
                $tbody .= "<a target='_blank' href='" . route('generar.pdfCordinadoraInstalacion', Crypt::encryptString($row->id)) . "' role='button' title='Ver PDF'>";
                $tbody .= "<span class='material-icons-round'>picture_as_pdf</span>";
                $tbody .= "</a>";
                // }

                $tbody .= "</td>";
                //     $tbody .= "<div class='dropdown dropleft' style='text-align: center;'>

                //     <button type='button' class='btn-dropdown' data-toggle='dropdown'>
                //       <span class='material-icons'>more_vert</span>
                //     </button>";
                //     $tbody .= "<div class='dropdown-menu mostrar shadow'>
                //   <div class='d-flex justify-content-around'>";
                // $tbody .= '<a href="#" role="button" title="Editar">';
                //   $tbody .= "<img class='' src='".asset('Botones/Botones/Editar.png')."'   alt='' style='margin: 2px 0px'/>"; 
                // $tbody.="</a>" ;   

                //boton historial para la coordinadora

                // $tbody .= "<a  target='_blank' class='btn-icon-dd' href='" . route('go.ver_check_cordinadora', Crypt::encryptString($row->id)) . "' role='button' title='Revisar'>";
                // $tbody .= " <span class='material-icons'>visibility</span>";
                // $tbody .= "</a>";



                // $tbody .= "</div></div></div>";
                // $tbody .= "</td>";

                $tbody .= "</tr>";
            }
        } else {
            $tbody .= "<tr>";
            $tbody .= "<td>Sin Datos</td>";
            $tbody .= "</tr>";
        }




        return $tbody;
    }
    public function check_asociados(Request $request)
    {
        # code...

        try {
            $id_instalacion = Crypt::decryptString($request->id_instalacion);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }


        $datos_asignacion = DB::table('asignacion_instalacions')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('asignacion_instalacions.lista_instalacion_id', '=', $id_instalacion)
            ->select('asignacion_instalacions.id', 'personas.nombre_uno', 'personas.apellido_uno', 'asignacion_instalacions.estado_asignacion', 'asignacion_instalacions.fecha_instalacion')
            ->orderBy('asignacion_instalacions.id', 'desc')
            ->get();

        $tbody = "";
        if (count($datos_asignacion) > 0) {



            foreach ($datos_asignacion as $row) {

                $tbody .= "<tr>";
                $tbody .= "<td>" . $id_instalacion . "</td>";
                $tbody .= "<td>" . date('d-m-Y', strtotime($row->fecha_instalacion)) . "</td>";
                $tbody .= "<td> " . $row->nombre_uno . " " . $row->apellido_uno . "</td>";

                if ($row->estado_asignacion == "pendiente" || $row->estado_asignacion == "Pendiente") {
                    $tbody .= '<td class="pendiente">' . $row->estado_asignacion . "</td>";
                } else if ($row->estado_asignacion == "cancelado" || $row->estado_asignacion == "Cancelado") {
                    $tbody .= '<td class="cancelado">' . $row->estado_asignacion . "</td>";
                } else if ($row->estado_asignacion == "reasignar" || $row->estado_asignacion == "Reasignar") {
                    $tbody .= '<td class="cancelado">' . "Reasignar" . "</td>";
                } else if ($row->estado_asignacion == "finalizado" || $row->estado_asignacion == "Finalizado") {
                    $tbody .= '<td class="finalizado">' . $row->estado_asignacion . "</td>";
                } else if ($row->estado_asignacion == "asignado" || $row->estado_asignacion == "Asignado") {
                    $tbody .= '<td class="asignado">' . $row->estado_asignacion . "</td>";
                } else if ($row->estado_asignacion == "revisar" || $row->estado_asignacion == "revisar") {
                    $tbody .= '<td class="revisado">' . "Revisar" . "</td>";
                } else if ($row->estado_asignacion == "rechazado" || $row->estado_asignacion == "Rechazado") {
                    $tbody .= '<td class="rechazado">' . $row->estado_asignacion . "</td>";
                } else if ($row->estado_asignacion == "tarea_asignada" || $row->estado_asignacion == "Tarea_asignada") {
                    $tbody .= '<td class="pendiente">' . "Tarea Asignada" . "</td>";
                }



                //boton editar
                $tbody .= "<td class='td-val'>";
                $tbody .= "<div class='dropdown dropleft' style='text-align: center;'>

                <button type='button' class='btn-dropdown' data-toggle='dropdown'>
                  <span class='material-icons'>more_vert</span>
                </button>";
                $tbody .= "<div class='dropdown-menu mostrar shadow'>
              <div class='d-flex justify-content-around'>";
                // $tbody .= '<a href="#" role="button" title="Editar">';
                //   $tbody .= "<img class='' src='".asset('Botones/Botones/Editar.png')."'   alt='' style='margin: 2px 0px'/>"; 
                // $tbody.="</a>" ;   

                //boton historial para la coordinadora

                $tbody .= "<a  target='_blank' class='btn-icon-dd' href='" . route('go.ver_check_cordinadora', Crypt::encryptString($row->id)) . "' role='button' title='Revisar'>";
                $tbody .= " <span class='material-icons'>visibility</span>";
                $tbody .= "</a>";


                if ($row->estado_asignacion != "revisar" && $row->estado_asignacion != "revisar" && $row->estado_asignacion != "finalizado" && $row->estado_asignacion && "Finalizado") {
                    //boton finalizar
                    $tbody .= "<a target='_blank' class='btn-icon-dd' href='" . route('go.finalizamanual', Crypt::encryptString($row->id)) . "' role='button' title='Finalizar Manual'>";
                    $tbody .= "<span class='material-icons-round'>
                    check_circle_outline
                    </span>";
                    $tbody .= "</a>";
                }

                $tbody .= "</div></div></div>";
                $tbody .= "</td>";

                $tbody .= "</tr>";
            }
        } else {
            $tbody .= "<tr>";
            $tbody .= "<td>Sin Datos</td>";
            $tbody .= "</tr>";
        }




        return $tbody;
    }
    public function check_asociados_old(Request $request)
    {
        # code...

        try {
            $id_instalacion = Crypt::decryptString($request->id_instalacion);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }


        $datos_asignacion = DB::table('asignacion_instalacions')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('asignacion_instalacions.lista_instalacion_id', '=', $id_instalacion)
            ->select('asignacion_instalacions.id', 'personas.nombre_uno', 'personas.apellido_uno', 'asignacion_instalacions.estado_asignacion', 'asignacion_instalacions.fecha_instalacion')
            ->orderBy('asignacion_instalacions.id', 'desc')

            ->get();

        $tbody = "";
        if (count($datos_asignacion) > 0) {



            foreach ($datos_asignacion as $row) {

                $tbody .= "<tr>";
                $tbody .= "<td>" . $id_instalacion . "</td>";
                $tbody .= "<td>" . date('d-m-Y', strtotime($row->fecha_instalacion)) . "</td>";
                $tbody .= "<td> " . $row->nombre_uno . " " . $row->apellido_uno . "</td>";

                if ($row->estado_asignacion == "pendiente" || $row->estado_asignacion == "Pendiente") {
                    $tbody .= '<td class="pendiente">' . $row->estado_asignacion . "</td>";
                } else if ($row->estado_asignacion == "cancelado" || $row->estado_asignacion == "Cancelado") {
                    $tbody .= '<td class="cancelado">' . $row->estado_asignacion . "</td>";
                } else if ($row->estado_asignacion == "reasignar" || $row->estado_asignacion == "Reasignar") {
                    $tbody .= '<td class="cancelado">' . "Reasignar" . "</td>";
                } else if ($row->estado_asignacion == "finalizado" || $row->estado_asignacion == "Finalizado") {
                    $tbody .= '<td class="finalizado">' . $row->estado_asignacion . "</td>";
                } else if ($row->estado_asignacion == "asignado" || $row->estado_asignacion == "Asignado") {
                    $tbody .= '<td class="asignado">' . $row->estado_asignacion . "</td>";
                } else if ($row->estado_asignacion == "revisar" || $row->estado_asignacion == "revisar") {
                    $tbody .= '<td class="revisado">' . "Revisar" . "</td>";
                } else if ($row->estado_asignacion == "rechazado" || $row->estado_asignacion == "Rechazado") {
                    $tbody .= '<td class="rechazado">' . $row->estado_asignacion . "</td>";
                } else if ($row->estado_asignacion == "tarea_asignada" || $row->estado_asignacion == "Tarea_asignada") {
                    $tbody .= '<td class="pendiente">' . "Tarea Asignada" . "</td>";
                }



                //boton editar
                $tbody .= "<td class='td-val'>";
                $tbody .= "<div class='dropdown dropleft' style='text-align: center;'>

                <button type='button' class='btn-dropdown' data-toggle='dropdown'>
                  <span class='material-icons'>more_vert</span>
                </button>";
                $tbody .= "<div class='dropdown-menu mostrar shadow'>
              <div class='d-flex justify-content-around'>";
                // $tbody .= '<a href="#" role="button" title="Editar">';
                //   $tbody .= "<img class='' src='".asset('Botones/Botones/Editar.png')."'   alt='' style='margin: 2px 0px'/>"; 
                // $tbody.="</a>" ;   

                //boton historial para la coordinadora

                $tbody .= "<a  target='_blank' class='btn-icon-dd' href='" . route('go.ver_check_cordinadora', Crypt::encryptString($row->id)) . "' role='button' title='Revisar'>";
                $tbody .= " <span class='material-icons'>visibility</span>";
                $tbody .= "</a>";


                if ($row->estado_asignacion != "revisar" && $row->estado_asignacion != "revisar" && $row->estado_asignacion != "finalizado" && $row->estado_asignacion && "Finalizado") {
                    //boton finalizar
                    $tbody .= "<a target='_blank' class='btn-icon-dd' href='" . route('go.finalizamanual', Crypt::encryptString($row->id)) . "' role='button' title='Finalizar Manual'>";
                    $tbody .= "<span class='material-icons-round'>
                    check_circle_outline
                    </span>";
                    $tbody .= "</a>";
                }

                $tbody .= "</div></div></div>";
                $tbody .= "</td>";

                $tbody .= "</tr>";
            }
        } else {
            $tbody .= "<tr>";
            $tbody .= "<td>Sin Datos</td>";
            $tbody .= "</tr>";
        }




        return $tbody;
    }


    public function completar_checklist(request $request)
    {
        
        $id_asignacion = $request->id;

        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();
        $id_trabajador = $datos_trabajador[0]->id;
        $datos_asignacion = DB::table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_instalacions.CsMueble',
                'checklist_instalacions.CsKit_lector',
                'checklist_instalacions.Csconexion_electrica',
                'checklist_instalacions.Cscantidad_usuarios',
                'checklist_instalacions.CsCable_poder',
                'checklist_instalacions.Csservidor_impresion',
                'checklist_instalacions.CsSD',
                'checklist_instalacions.ins_driver',
                'checklist_instalacions.equipo_operativo',
                'checklist_instalacions.CsObservacion',
                'checklist_instalacions.Cscontacto',
                'checklist_instalacions.modo_U253',
                'checklist_instalacions.Csconfig_smb',
                'checklist_instalacions.CsBandeja_adicional',
                'checklist_instalacions.Cstipo_conexion',
                'checklist_instalacions.CsCable_red',
                'checklist_instalacions.nombre_servidores_id',
                'checklist_instalacions.tipo_conexiones_id',
                'checklist_instalacions.tipo_equipo',
                'checklist_instalacions.softwares_id',
                'checklist_instalacions.motivo',
                'checklist_instalacions.Csn_contacto',
                'checklist_instalacions.Csconfig_email',
                'checklist_instalacions.CsMarca_es',
                'checklist_instalacions.CsSerie_es',
                'checklist_instalacions.CsModelo_es',
                'checklist_instalacions.CsTipoequipo_es',
                'checklist_instalacions.CsContador_es',
                'checklist_instalacions.CsContadorcolor_es',
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscliente',
                'asignacion_instalacions.estado_asignacion',
                'asignacion_instalacions.fecha_instalacion',
                'asignacion_instalacions.id',
                'asignacion_instalacions.numero_visita',
                'asignacion_instalacions.tipos_visitas_id',
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscomuna',
                'checklist_instalacions.Cscui',
                'checklist_instalacions.Cspiso',
                'checklist_instalacions.Csregion',
                'checklist_instalacions.Cnfolio',
                'checklist_instalacions.CsSerie',
                'checklist_instalacions.CsModelo',
                'checklist_instalacions.CUsb_red',
                'checklist_instalacions.CDriver',
                'checklist_instalacions.Cscontacto',
                'checklist_instalacions.CsSC',
                'asignacion_instalacions.lista_instalacion_id as id_instalacion',
                'checklist_instalacions.CsIP',
                'checklist_instalacions.CsGateway',
                'checklist_instalacions.CsMsk',
                'checklist_instalacions.idSala',

                'checklist_instalacions.CnContador',
                'checklist_instalacions.CnContador_color',
                'checklist_instalacions.id as id_checklist',
                'checklist_instalacions.estado_inicio',
                'personas.nombre_uno as nombrepersona',
                'personas.nombre_dos as nombrepe',
                'asignacion_instalacions.motivo_rechazado',
                'checklist_instalacions.url_firma'
            )
            //    ->select('checklist_instalacions.Csdireccion','checklist_instalacions.Cscliente',
            //    'asignacion_instalacions.estado_asignacion','asignacion_instalacions.fecha_instalacion','asignacion_instalacions.id',
            //    'asignacion_instalacions.numero_visita','asignacion_instalacions.tipos_visitas_id','checklist_instalacions.Csdireccion','checklist_instalacions.Cscomuna'
            //    ,'checklist_instalacions.Cscui','checklist_instalacions.Cspiso','checklist_instalacions.Csregion','checklist_instalacions.Cnfolio'
            //    ,'checklist_instalacions.CsSerie','checklist_instalacions.CsModelo','checklist_instalacions.CUsb_red','checklist_instalacions.CDriver','checklist_instalacions.Cscontacto'
            //    ,'checklist_instalacions.CsSC','asignacion_instalacions.lista_instalacion_id as id_instalacion','checklist_instalacions.CsIP'
            //    ,'checklist_instalacions.CsGateway','checklist_instalacions.CsMsk','checklist_instalacions.CnContador','checklist_instalacions.CnContador_color'
            //    ,'checklist_instalacions.id as id_checklist','checklist_instalacions.estado_inicio', 'personas.nombre_uno as nombrepersona','personas.nombre_dos as nombrepe'
            //    ,'asignacion_instalacions.motivo_rechazado','checklist_instalacions.url_firma')
            ->where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_instalacions.id', '=', $id_asignacion)
            ->orderBy('asignacion_instalacions.id', 'desc')
            ->get();

        $cantidad_fotos = App\fotos_check_instalacions::where('checklist_instalacion_id', $datos_asignacion[0]->id_checklist)->count();

        if ($datos_asignacion[0]->motivo_rechazado == "" || $datos_asignacion[0]->motivo_rechazado == null) {
            $accion = "1";   //iniciar
        } else {
            $accion = "2"; // completas rechazado
        }
        
        //encontramos el nombre del proyecto asociado al checklist de instalacion
        $id_instalacion = $datos_asignacion[0]->id_instalacion;
        $id = $datos_asignacion[0]->id;
        $proyecto_asociado = DB::table('instalacions')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->select('proyectos.nombre', 'clientes.razon_social','proveedor_instalacion')
            ->where('instalacions.id', '=', $id_instalacion)
            ->get();

        // return $proyecto_asociado;clientes_id

        $softwares = DB::table('softwares')
            ->where('softwares.estado', '=', "activo")
            ////->where('softwares.id','!=',1)
            ->get();

        $servidores = DB::table('nombre_servidores')
            ->where('nombre_servidores.estado', '=', "activo")
            ////->where('nombre_servidores.id','!=',1)
            ->get();

        $tipo_conexion = DB::table('tipo_conexiones')
            ->where('tipo_conexiones.estado', '=', "activo")
            ////->where('tipo_conexiones.id','!=',1)
            ->get();

        //$estado = ;
        $estado = collect(['Finalizar', 'Pendiente', 'Cancelar']);

        $detalle = collect(['Ubicacion provisoria', 'Habilitacion de credenciales', 'Continua usando equipo anterior', 'Equipo operativo', 'Configurado, pendiente Capacitacion']);

        // $detalle_ = [
        //     ['name' => 'Taylor',  'coffee_drinker' => true],
        //     ['name' => 'Matt', 'coffee_drinker' => true]
        // ];

        // $detalle = collect($detalle_);
        $tipo_visita = App\tipos_visitas::findOrfail($datos_asignacion[0]->tipos_visitas_id);
        $Direccion = $datos_asignacion[0]->Csdireccion;

        /*$datos_retiros = DB::table('asignacion_retiros')
        ->join('checklist_retiros','checklist_retiros.asignacion_retiros_id','=','asignacion_retiros.id')
        ->orWhere(function($query) use ($id_trabajador )
        {
            $query->where('asignacion_retiros.trabajadors_idtecnico','=',$id_trabajador)
            ->where('asignacion_retiros.estado_asignacion','=','tarea_asignada');
        })  
        ->select(    
            'checklist_retiros.motivo_reasignado',
            'checklist_retiros.Csdireccion',
            'checklist_retiros.Cscliente',
            'asignacion_retiros.estado_asignacion',
            'asignacion_retiros.fecha_asignado as fecha_as',
            'asignacion_retiros.id',
            'asignacion_retiros.tipo', //retiro o intalaccion
            'asignacion_retiros.motivo_rechazado' ,
            'asignacion_retiros.fecha_retiro as fecha_visita',
            'checklist_retiros.csComuna',
            'checklist_retiros.CsSerie',
            'checklist_retiros.id as idcheck'  
        );*/
        $datos_instalacion = DB::table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            //->leftjoin('fotos_check_instalacions','fotos_check_instalacions.checklist_instalacion_id','=','checklist_instalacions.id')
            ->Where(function ($query) use ($id_trabajador, $id, $Direccion) {
                $query->where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
                    ->where('asignacion_instalacions.id', '!=', $id)
                    ->where('checklist_instalacions.Csdireccion', '=', $Direccion)
                    ->where('checklist_instalacions.url_firma', '=', NULL);
            })
            ->select(
                'checklist_instalacions.motivo_reasignado',
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscliente',
                'asignacion_instalacions.estado_asignacion',
                'asignacion_instalacions.fecha_asignado as fecha_as',
                'asignacion_instalacions.id',
                'asignacion_instalacions.tipo', //retiro o intalaccion
                'asignacion_instalacions.motivo_rechazado',
                'asignacion_instalacions.fecha_instalacion as fecha_visita', //fecha_instalacion
                'checklist_instalacions.csComuna',
                'checklist_instalacions.CsSerie',
                'checklist_instalacions.id as idcheck'
            )
            ->orderBy('fecha_visita', 'desc')
            ->get();

        return view('check.iniciar_checklist', compact('cantidad_fotos', 'datos_asignacion', 'tipo_visita', 'proyecto_asociado', 'softwares', 'servidores', 'tipo_conexion', 'accion', 'estado', 'detalle', 'datos_instalacion'));
    }




    public function finalizar_check(request $request, $id_instalacion)
    {

        $estado = $request->estado;
        $detalle = $request->detalle;
        $estado_guardar = "";
        $add_estado = "";

        try {
            $id_instalacion_desin = Crypt::decryptString($id_instalacion);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }

        if ($request->no_firma_cliente == "si") {
            $firma = "0";
            //no firma
        } else {
            $firma = "1";
            //si firma
            $check =  App\checklist_instalacions::findOrfail($id_instalacion_desin);
            $validacionFirma = $check->url_firma;
            if ($validacionFirma == "" || $validacionFirma == null) {
                return back()->with('mensaje_error', 'Seleccione cliente se niega a firmar')->withInput($request->input());
            }
        }

        $lista = App\fotos_check_instalacions::where('checklist_instalacion_id', $id_instalacion_desin)->get();

        $msjinstal = "";

        //Mensaje de accion, revi
        if ($request->acc == "1") {
            $msjinstal = "revisar";
        } elseif ($request->acc == "2") {
            $msjinstal = "corregido";
        } else {
            return "No Puede Realizar Esta Accion";
        }

        switch ($estado) {
            case 'Finalizar':
                # code...
                $add_estado = $request->obsercaviones;
                $msjinstal = "finalizado";
                break;

            case 'Pendiente':
                $msjinstal = "Pendiente";
                $add_estado = $request->obsercaviones;
                # code...

                break;
            case 'Cancelar':
                # code...
                $msjinstal = "Cancelado";
                $add_estado = $request->obsercaviones;

                break;
            default:
                # code...
                return "intente Nuevamente ";
                break;
        }

        $cambio_serie =  $request->cambio_serie;

        if ($cambio_serie == "cambio_serie") {

            $rules = [
                'cambio_serie' => 'required',
                'serie_remplazo' => 'required',
                'modelo_remplazo' => 'required',
            ];

            $this->validate($request, $rules);
            $cambioSerie = "si";
        } else {
            $cambioSerie = "no";
        }
        $rules = [
            'Software' => 'required',
            'ip' => 'required',
            'Mask' => 'required',
            'Gateway' => 'required',
            'contador_bn' => 'required',
            'contador_color' => 'required',
        ];

        if ($msjinstal != "Pendiente" && $msjinstal != "Cancelado") {
            $this->validate($request, $rules);
        }


        if ($request->band_ad == "bandeja-adicional") {
            $rules = [
                'modelo_bandeja' => 'required',

            ];

            $this->validate($request, $rules);
            $bandeja_adicional = "si";
        } else {
            $bandeja_adicional = "no";
        }


        $rules = [
            // 'mueble' => 'required',
            'kit_lector' => 'required',
            'memoria_sd' => 'required',
            'cable_red' => 'required',
            'cable_poder' => 'required',
            'contacto_firma' => 'required',


        ];

        if ($msjinstal != "Pendiente" && $msjinstal != "Cancelado") {
            //$this->validate($request, $rules);
        }


        if ($msjinstal != "Pendiente" && $msjinstal != "Cancelado") {
            if (count($lista) == 0) {
                return back()->with('mensaje_error', 'Ingrese las fotos')->withInput($request->input());
            }
        }

        $motivo = "";
        if ($request->accesorios_si == "on") {
            if ($request->motivo_1 != "" ||  $request->motivo_2 != "" ||  $request->motivo_3 != "") {
                if ($request->motivo_1 != "") {
                    $motivo = "Fin de vida util";
                } else if ($request->motivo_2 != "") {
                    $motivo = "Garantia";
                } else if ($request->motivo_3 != "") {
                    $motivo = "Daño de usuario";
                } else {
                    $motivo = "";
                }
            } else {
                return back()->with('mensaje_error', 'Ingrese Motivo')->withInput($request->input());
            }
        }

        if ($request->accesorios_instalacion_si == "on") {
            if ($request->accesorios_instalacion_manual_si == "") {
                if ($request->cantidad4 == "") {
                    return back()->with('mensaje_error', 'Ingrese accesorios instalados')->withInput($request->input());
                }
            } else {
                if ($request->nombre_pieza5 == "") {
                    return back()->with('mensaje_error', 'Ingrese accesorios instalados manuales')->withInput($request->input());
                }
            }
        }
        if ($request->accesorios_si == "on") {
            if ($motivo == "Fin de vida util" || $motivo == "Daño de usuario") {
                if ($request->accesorios_manual_si == "") {
                    if ($request->cantidad == "") {
                        return back()->with('mensaje_error', 'Ingrese accesorios solicitados')->withInput($request->input());
                    } elseif ($request->cantidad2 == "") {
                        return back()->with('mensaje_error', 'Ingrese accesorios dañados')->withInput($request->input());
                    }
                }
            }
        }
        if ($motivo == "Garantia") {
            if ($request->accesorios_manual_si == "") {
                if ($request->cantidad == "") {
                    return back()->with('mensaje_error', 'Ingrese accesorios solicitados')->withInput($request->input());
                }
            } else {
                if ($request->nombre_pieza3 == "") {
                    return back()->with('mensaje_error', 'Ingrese accesorios instalados manuales')->withInput($request->input());
                }
            }
        }

        $FechaHoraActual  = Carbon::now();
        $FechaHoraActual = $FechaHoraActual->toDateTimeString();

        //id_instalacion_desin = id del checlik
        $check =  App\checklist_instalacions::findOrfail($id_instalacion_desin);
        $check->idSala = $request->idsala;

        $check->softwares_id = $request->Software;
        $check->Cscambio_serie = $cambioSerie;
        $check->Csserie_remplazo = $request->serie_remplazo;
        $check->Csmodelo_remplazo = $request->modelo_remplazo;
        $check->CsIP = $request->ip;
        $check->CsMsk = $request->Mask;
        $check->CsGateway = $request->Gateway;
        $check->CnContador = $request->contador_bn;
        $check->CnContador_color = $request->contador_color;
        $check->CsBandeja_adicional = $bandeja_adicional;
        $check->CsMueble = $request->mueble;
        $check->CsKit_lector = $request->kit_lector;
        $check->CsSD = $request->memoria_sd;
        $check->CsCable_red = $request->cable_red;
        $check->CsCable_poder = $request->cable_poder;
        $check->Cstipo_conexion = $request->tipo_conexion;
        $check->Csnombre_servidor = $request->servidores;
        $check->fecha_fin = $FechaHoraActual;
        $check->observacion = $add_estado;
        $check->Csmarca = $request->marca;
        if ($request->equip_remplazo_si == "on") {
            $check->CsMarca_es = $request->marca_es;
            $check->CsSerie_es = $request->serie_es;
            $check->CsModelo_es = $request->modelo_es;
            $check->CsTipoequipo_es = $request->tipo_equipo_es;
            $check->CsContador_es = $request->contador_bn_es;
            $check->CsContadorcolor_es = $request->contador_color_es;
        }
        $check->Csconexion_electrica     = $request->conexion_electrica;
        $check->Csservidor_impresion     = $request->servidor_impresion;
        $check->Csconfig_smb     = $request->conf_smb;
        $check->Csconfig_email     = $request->conf_email;
        $check->ins_driver = $request->ins_driver;
        $check->modo_U253 = $request->modo_U253;
        $check->tipo_equipo =  $request->tipo_equipo;
        $check->firma_contacto = $firma;
        $check->nombre_contactoF = $request->nombre_contacto;
        $check->rut_contactoF = $request->rut_contacto;
        $check->equipo_operativo = $request->equipo_operativo;
        $check->Cscantidad_usuarios = $request->cantidad_usuarios;
        // $check->estado_inicio = "finalizado";
        $check->estado_inicio = strtolower($msjinstal);
        if ($request->accesorios_si == "on") {
            $check->motivo = $motivo;
        }
        $check->timestamps = false;
        $check->save();
        //ACCESORIOS
        if ($request->accesorios_si == "on") {
            if ($motivo == "Fin de vida util" || $motivo == "Daño de usuario") {
                if ($request->cantidad != "") {
                    for ($i = 0; $i < count($request->cantidad); $i++) {
                        $accesorios = new App\checklist_accesorios;
                        $accesorios->id_checklist_instalacion = $id_instalacion_desin;
                        $accesorios->id_accesorio = $request->descripcion_accesorio[$i];
                        $accesorios->serie_parte = $request->serie_parte[$i];
                        $accesorios->cantidad = $request->cantidad[$i];
                        $accesorios->timestamps = false;
                        $accesorios->save();
                    }
                }
                if ($request->cantidad2 != "") {
                    for ($i = 0; $i < count($request->cantidad2); $i++) {
                        $accesorios = new App\checklist_accesorios_dañados;
                        $accesorios->id_checklist_instalacion = $id_instalacion_desin;
                        $accesorios->id_accesorio = $request->descripcion_accesorio2[$i];
                        $accesorios->serie_parte = $request->serie_parte2[$i];
                        $accesorios->cantidad = $request->cantidad2[$i];
                        $accesorios->timestamps = false;
                        $accesorios->save();
                    }
                }

                if ($request->accesorios_manual_si == "on") {
                    for ($i = 0; $i < count($request->cantidad3); $i++) {
                        $accesorios = new App\accesorios_manuales;
                        $accesorios->id_checklist_instalacion = $id_instalacion_desin;
                        $accesorios->nombre_parte = $request->nombre_pieza3[$i];
                        $accesorios->numero_parte = $request->numero_parte3[$i];
                        $accesorios->serie_parte = $request->serie_parte3[$i];
                        $accesorios->cantidad = $request->cantidad3[$i];
                        $accesorios->observacion = $request->observacion3[$i];
                        $accesorios->timestamps = false;
                        $accesorios->save();
                    }
                }
            }
            if ($motivo == "Garantia") {
                if ($request->cantidad != "") {
                    for ($i = 0; $i < count($request->cantidad); $i++) {
                        $accesorios = new App\checklist_accesorios;
                        $accesorios->id_checklist_instalacion = $id_instalacion_desin;
                        $accesorios->id_accesorio = $request->descripcion_accesorio[$i];
                        $accesorios->serie_parte = $request->serie_parte[$i];
                        $accesorios->cantidad = $request->cantidad[$i];
                        $accesorios->timestamps = false;
                        $accesorios->save();
                    }
                }
                if ($request->accesorios_manual_si == "on") {
                    for ($i = 0; $i < count($request->cantidad3); $i++) {
                        $accesorios = new App\accesorios_manuales;
                        $accesorios->id_checklist_instalacion = $id_instalacion_desin;
                        $accesorios->nombre_parte = $request->nombre_pieza3[$i];
                        $accesorios->numero_parte = $request->numero_parte3[$i];
                        $accesorios->serie_parte = $request->serie_parte3[$i];
                        $accesorios->cantidad = $request->cantidad3[$i];
                        $accesorios->observacion = $request->observacion3[$i];
                        $accesorios->timestamps = false;
                        $accesorios->save();
                    }
                }
            }
        }
        if ($request->accesorios_instalacion_si == "on") {
            if ($request->cantidad4 != "") {
                for ($i = 0; $i < count($request->cantidad4); $i++) {
                    $accesorios = new App\checklist_instalacion_accesorios;
                    $accesorios->id_checklist_instalacion = $id_instalacion_desin;
                    $accesorios->id_accesorio = $request->descripcion_accesorio4[$i];
                    $accesorios->serie_parte = $request->serie_parte4[$i];
                    $accesorios->cantidad = $request->cantidad4[$i];
                    $accesorios->timestamps = false;
                    $accesorios->save();
                }
            }
            if ($request->accesorios_instalacion_manual_si == "on") {
                for ($i = 0; $i < count($request->cantidad5); $i++) {
                    $accesorios = new App\instalacion_accesorios_manuales;
                    $accesorios->id_checklist_instalacion = $id_instalacion_desin;
                    $accesorios->nombre_parte = $request->nombre_pieza5[$i];
                    $accesorios->numero_parte = $request->numero_parte5[$i];
                    $accesorios->serie_parte = $request->serie_parte5[$i];
                    $accesorios->cantidad = $request->cantidad5[$i];
                    $accesorios->observacion = $request->observacion5[$i];
                    $accesorios->timestamps = false;
                    $accesorios->save();
                }
            }
        }


        $datos_check = DB::table('checklist_instalacions')
            //  ->join('asignacion_instalacions.id','=','checklist_instalacions.asignacion_instalacion_retiro_id')
            //  ->where('softwares.estado','=',"activo")
            ->where('checklist_instalacions.id', '=', $id_instalacion_desin)
            ->get();

        $FechaHoraActual  = Carbon::now();
        $FechaHoraActual = $FechaHoraActual->toDateTimeString();


        if (strtolower($msjinstal) == "finalizado") {
            $msjinstal = "revisar";
        }

        //return redirect('chekstecnico')->with('mensaje', 'Checklist Actualizado');  
        $asignacion =  App\asignacion_instalacions::findOrfail($datos_check[0]->asignacion_instalacion_retiro_id);
        $asignacion->estado_asignacion     = strtolower($msjinstal);
        $asignacion->fecha_termino     =  $FechaHoraActual;
        $asignacion->opcion_estado_instalacion = $detalle;
        $asignacion->check_manual     =  $request->tipo_instalacion;
        $asignacion->timestamps = false;
        $asignacion->save();


        //actualizamos la lista de api insntalacion
        $instalacions =  App\instalacions::findOrfail($asignacion->lista_instalacion_id);
        //   $instalacions->sEstado_despacho     =  strtolower($msjinstal);
        $instalacions->Csserie_remplazo = $request->serie_remplazo;
        $instalacions->Csserie_es = $request->serie_es;
        $instalacions->i_opcion_estado_instalacion = $detalle;
        $instalacions->idSala = $request->idsala;

        $instalacions->sEstado_instalacion = strtolower($msjinstal);
        $instalacions->timestamps = false;
        $instalacions->save();

        if ($request->tipo_instalacion == "si") {

            $url = session('url_cordinadora');
            return redirect($url)->with('mensaje', 'Checklist Actualizado');
        } else {
            return redirect('chekstecnico')->with('mensaje', 'Checklist Actualizado');
        }
    }

    //revisa el check el tecnico
    public function ver_checklist(request $request)
    {
        $id_asignacion = $request->id;

        $mi_asignacion = DB::table('asignacion_instalacions')
            ->where('asignacion_instalacions.id', '=', $id_asignacion)
            ->get();

        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();
        $id_trabajador = $datos_trabajador[0]->id;

        $datos_asignacion = DB::table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('softwares', 'softwares.id', '=', 'checklist_instalacions.softwares_id')
            ->join('tipo_conexiones', 'tipo_conexiones.id', '=', 'checklist_instalacions.tipo_conexiones_id')
            ->join('nombre_servidores', 'nombre_servidores.id', '=', 'checklist_instalacions.nombre_servidores_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscliente',
                'asignacion_instalacions.estado_asignacion',
                'asignacion_instalacions.fecha_instalacion',
                'asignacion_instalacions.id',
                'asignacion_instalacions.numero_visita',
                'checklist_instalacions.Csmarca',
                'asignacion_instalacions.tipos_visitas_id',
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscomuna',
                'checklist_instalacions.Cscui',
                'checklist_instalacions.Cspiso',
                'checklist_instalacions.Csregion',
                'checklist_instalacions.Cnfolio',
                'checklist_instalacions.CsSerie',
                'checklist_instalacions.CsModelo',
                'checklist_instalacions.CUsb_red',
                'checklist_instalacions.CDriver',
                'checklist_instalacions.Cscontacto',
                'checklist_instalacions.CsSC',
                'asignacion_instalacions.lista_instalacion_id as id_instalacion',
                'checklist_instalacions.CsIP',
                'checklist_instalacions.CsGateway',
                'checklist_instalacions.CsMsk',
                'checklist_instalacions.CnContador',
                'checklist_instalacions.CnContador_color',
                'checklist_instalacions.id as id_checklist',
                'softwares.descripcion as nombre_software',
                'tipo_conexiones.descripcion as nombre_conexion',
                'nombre_servidores.descripcion as nombre_servidor',
                'personas.nombre_uno as nombrepersona',
                'personas.nombre_dos as nombrepe',
                'checklist_instalacions.CsObservacion',
                'checklist_instalacions.CsBandeja_adicional',
                'checklist_instalacions.CsMueble',
                'checklist_instalacions.CsKit_lector',
                'checklist_instalacions.CsSD',
                'checklist_instalacions.CsCable_poder',
                'checklist_instalacions.CsCable_red',
                'checklist_instalacions.Csconexion_electrica',
                'checklist_instalacions.Csservidor_impresion',
                'checklist_instalacions.Csservidor_impresion',
                'checklist_instalacions.Csconfig_smb',
                'checklist_instalacions.Csconfig_email',
                'checklist_instalacions.Cscantidad_usuarios',
                'checklist_instalacions.firma_contacto',
                'checklist_instalacions.observacion',
                'checklist_instalacions.url_firma',
                'checklist_instalacions.tipo_equipo',
                'checklist_instalacions.fecha_inicio',
                'checklist_instalacions.fecha_fin',
                'checklist_instalacions.nombre_contactoF',
                'checklist_instalacions.modo_U253',
                'checklist_instalacions.ins_driver',
                'checklist_instalacions.equipo_operativo'
            )
            ->where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_instalacions.id', '=', $id_asignacion)
            ->orderBy('asignacion_instalacions.id', 'desc')
            ->get();


        //encontramos el nombre del proyecto asociado al checklist de instalacion
        $id_instalacion = $datos_asignacion[0]->id_instalacion;
        $proyecto_asociado = DB::table('instalacions')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->select('proyectos.nombre', 'clientes.razon_social')
            ->where('instalacions.id', '=', $id_instalacion)
            ->get();

        // modal foto traer imagenes.
        $fotos = DB::table('fotos_check_instalacions')
            ->where('fotos_check_instalacions.checklist_instalacion_id', '=', $datos_asignacion[0]->id_checklist)
            ->get();


        // return $proyecto_asociado;clientes_id


        $softwares = DB::table('softwares')
            ->where('softwares.estado', '=', "activo")
            //->where('softwares.id','!=',1)
            ->get();


        $servidores = DB::table('nombre_servidores')
            ->where('nombre_servidores.estado', '=', "activo")
            //->where('nombre_servidores.id','!=',1)
            ->get();


        $tipo_conexion = DB::table('tipo_conexiones')
            ->where('tipo_conexiones.estado', '=', "activo")
            //->where('tipo_conexiones.id','!=',1)
            ->get();




        $tipo_visita = App\tipos_visitas::findOrfail($datos_asignacion[0]->tipos_visitas_id);



        return view('check.ver_checklist', compact('datos_asignacion', 'tipo_visita', 'proyecto_asociado', 'softwares', 'servidores', 'tipo_conexion', 'fotos'));
    }

    public function ver_checklistCoodinadora($idasig)
    {

        try {
            $id_asignacion = Crypt::decryptString($idasig);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }


        $mi_asignacion = DB::table('asignacion_instalacions')
            ->where('asignacion_instalacions.id', '=', $id_asignacion)
            ->get();

        $id_trabajador = $mi_asignacion[0]->trabajadors_id;

        $firma_tecnico = DB::table('firma_clientes')
            ->where('id_tecnico', '=', $id_trabajador)
            ->get();

        $datos_asignacion = DB::table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('softwares', 'softwares.id', '=', 'checklist_instalacions.softwares_id')
            ->join('tipo_conexiones', 'tipo_conexiones.id', '=', 'checklist_instalacions.tipo_conexiones_id')
            ->join('nombre_servidores', 'nombre_servidores.id', '=', 'checklist_instalacions.nombre_servidores_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')

            ->select(
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscliente',
                'asignacion_instalacions.estado_asignacion',
                'asignacion_instalacions.fecha_instalacion',
                'asignacion_instalacions.id',
                'asignacion_instalacions.numero_visita',
                'asignacion_instalacions.opcion_estado_instalacion',
                'asignacion_instalacions.tipos_visitas_id',
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscomuna',
                'checklist_instalacions.Cscui',
                'checklist_instalacions.Cspiso',
                'checklist_instalacions.Csmarca',
                'checklist_instalacions.Cscambio_serie',
                'checklist_instalacions.Csserie_remplazo',
                'checklist_instalacions.Csmodelo_remplazo',
                'checklist_instalacions.modo_U253',
                'checklist_instalacions.ins_driver',
                'checklist_instalacions.equipo_operativo',
                'checklist_instalacions.Csregion',
                'checklist_instalacions.Cnfolio',
                'checklist_instalacions.CsSerie',
                'checklist_instalacions.CsModelo',
                'checklist_instalacions.CUsb_red',
                'checklist_instalacions.CDriver',
                'checklist_instalacions.Cscontacto',
                'checklist_instalacions.CsSC',
                'asignacion_instalacions.lista_instalacion_id as id_instalacion',
                'checklist_instalacions.CsIP',
                'checklist_instalacions.CsGateway',
                'checklist_instalacions.CsMsk',
                'checklist_instalacions.CnContador',
                'checklist_instalacions.CnContador_color',
                'checklist_instalacions.id as id_checklist',
                'softwares.descripcion as nombre_software',
                'tipo_conexiones.descripcion as nombre_conexion',
                'nombre_servidores.descripcion as nombre_servidor',
                'personas.nombre_uno as nombrepersona',
                'personas.nombre_dos as nombrepe',
                'checklist_instalacions.CsObservacion',
                'checklist_instalacions.CsBandeja_adicional',
                'checklist_instalacions.CsMueble',
                'checklist_instalacions.CsKit_lector',
                'checklist_instalacions.CsSD',
                'checklist_instalacions.CsCable_poder',
                'checklist_instalacions.CsCable_red',
                'checklist_instalacions.Csconexion_electrica',
                'checklist_instalacions.Csservidor_impresion',
                'checklist_instalacions.Csservidor_impresion',
                'checklist_instalacions.Csconfig_smb',
                'checklist_instalacions.Csconfig_email',
                'checklist_instalacions.Cscantidad_usuarios',
                'checklist_instalacions.firma_contacto',
                'checklist_instalacions.observacion',
                'checklist_instalacions.url_firma',
                'checklist_instalacions.tipo_equipo',
                'checklist_instalacions.fecha_inicio',
                'checklist_instalacions.fecha_fin',
                'checklist_instalacions.CsMarca_es',
                'checklist_instalacions.CsSerie_es',
                'checklist_instalacions.CsModelo_es',
                'checklist_instalacions.CsTipoequipo_es',
                'checklist_instalacions.CsContador_es',
                'checklist_instalacions.CsContadorcolor_es',
                'checklist_instalacions.motivo',
                'checklist_instalacions.nombre_contactoF',
                'checklist_instalacions.rut_contactoF',
                'checklist_instalacions.idSala'



            )
            ->where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_instalacions.id', '=', $id_asignacion)
            ->orderBy('asignacion_instalacions.id', 'desc')
            ->get();
            // return $datos_asignacion;


        //encontramos el nombre del proyecto asociado al checklist de instalacion
        $id_instalacion = $datos_asignacion[0]->id_instalacion;
        $proyecto_asociado = DB::table('instalacions')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->select('proyectos.nombre', 'clientes.razon_social', 'sEstado_instalacion', 'i_opcion_estado_instalacion')
            ->where('instalacions.id', '=', $id_instalacion)
            ->get();


        $i_opcion_estado_instalacion = $proyecto_asociado[0]->i_opcion_estado_instalacion;
        $i_opcion_estado_instalacion = str_replace("_", " ", $i_opcion_estado_instalacion);


        
        //RAZONSOCIALAGRUPADAS
        $con_razonSocial= "no";
        $razonAgrupasa = DB::table('clientes')
        ->select('razon_social_agrupada')
        ->where('clientes.razon_social', '=', $proyecto_asociado[0]->razon_social)
        ->get();

        if(count($razonAgrupasa ) >0){
            $con_razonSocial = $razonAgrupasa[0]->razon_social_agrupada;
          }else{
              $con_razonSocial= "no";
          
          }

        // modal foto traer imagenes.
        $fotos = DB::table('fotos_check_instalacions')
            ->where('fotos_check_instalacions.checklist_instalacion_id', '=', $datos_asignacion[0]->id_checklist)
            ->get();

        $fotos_accesorios = DB::table('fotos_checks_accesorios')
            ->where('checklist_instalacion_id', '=', $datos_asignacion[0]->id_checklist)
            ->get();
       

        $softwares = DB::table('softwares')
            ->where('softwares.estado', '=', "activo")
            //->where('softwares.id','!=',1)
            ->get();

        $servidores = DB::table('nombre_servidores')
            ->where('nombre_servidores.estado', '=', "activo")
            //->where('nombre_servidores.id','!=',1)
            ->get();

        $tipo_conexion = DB::table('tipo_conexiones')
            ->where('tipo_conexiones.estado', '=', "activo")
            //->where('tipo_conexiones.id','!=',1)
            ->get();

        $datos_instalacion = DB::table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            //->leftjoin('fotos_check_instalacions','fotos_check_instalacions.checklist_instalacion_id','=','checklist_instalacions.id')
            ->Where(function ($query) use ($id_trabajador, $id_asignacion, $datos_asignacion) {
                $query
                    //->where('asignacion_instalacions.trabajadors_id','=',$id_trabajador)
                    ->where('checklist_instalacions.Csdireccion', '=', $datos_asignacion[0]->Csdireccion)
                    ->where('asignacion_instalacions.id', '!=', $id_asignacion)
                    ->where('checklist_instalacions.url_firma', '=', NULL);
            })
            ->select(
                'checklist_instalacions.motivo_reasignado',
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscliente',
                'asignacion_instalacions.estado_asignacion',
                'asignacion_instalacions.fecha_asignado as fecha_as',
                'asignacion_instalacions.id',
                'asignacion_instalacions.tipo', //retiro o intalaccion
                'asignacion_instalacions.motivo_rechazado',
                'asignacion_instalacions.fecha_instalacion as fecha_visita', //fecha_instalacion
                'checklist_instalacions.csComuna',
                'checklist_instalacions.CsSerie',
                'checklist_instalacions.id as idcheck'
            )
            ->orderBy('fecha_visita', 'desc')
            ->get();

        $tipo_visita = App\tipos_visitas::findOrfail($datos_asignacion[0]->tipos_visitas_id);

        return view('check.ver_checklistCoordinadora', compact('con_razonSocial','firma_tecnico', 'datos_instalacion', 'i_opcion_estado_instalacion', 'datos_asignacion', 'tipo_visita', 'proyecto_asociado', 'softwares', 'servidores', 'tipo_conexion', 'fotos', 'fotos_accesorios'));
    }


    public function iniciar_check($id_checklist)
    {

        try {
            $checklistid = Crypt::decryptString($id_checklist);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }
        $FechaHoraActual  = Carbon::now();
        $FechaHoraActual = $FechaHoraActual->toDateTimeString();

        $check =  App\checklist_instalacions::findOrfail($checklistid);
        $check->timestamps = false;
        $check->estado_inicio = "activo";
        $check->fecha_inicio = $FechaHoraActual;
        //  $check->fecha_inicio = Carbon::now();
        $check->save();

        return back()->with('mensaje', 'Checklist  Iniciado');
    }



    public function save_imagen(request $request)
    {
        $numeroRandom = rand();

        if (!empty($request->file('cargafoto1'))) {
            $file = $request->file('cargafoto1');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            //sacamos la exxtencion por medio de _
            $extencionArray = explode("_", $extencion);
            if ($extencionArray[1] == "jpg" || $extencionArray[1] == "JPG" || $extencionArray[1] == "jpeg" || $extencionArray[1] == "JPEG" || $extencionArray[1] == "png" || $extencionArray[1] == "PNG" || $extencionArray[1] == "jfif" || $extencionArray[1] == "JFIF") {            } else {
                return [
                    'status' => 400,
                    'msg' => "Solo se permiten imagenes",
                ];
            }
            $nombreGuardar1 = "f1_" .$numeroRandom . $request->check_list . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("foto_instalaciones/" . $nombreGuardar1,  \File::get($file));
        }
        //foto2
        if (!empty($request->file('cargafoto2'))) {
            $file = $request->file('cargafoto2');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            $extencionArray = explode("_", $extencion);
            if ($extencionArray[1] == "jpg" || $extencionArray[1] == "JPG" || $extencionArray[1] == "jpeg" || $extencionArray[1] == "JPEG" || $extencionArray[1] == "png" || $extencionArray[1] == "PNG" || $extencionArray[1] == "jfif" || $extencionArray[1] == "JFIF") {            } else {
                return [
                    'status' => 400,
                    'msg' => "Solo se permiten imagenes",
                ];
            }
            $nombreGuardar2 = "f2_".$numeroRandom  . $request->check_list . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("foto_instalaciones/" . $nombreGuardar2,  \File::get($file));
        }
        //foto3
        if (!empty($request->file('cargafoto3'))) {
            $file = $request->file('cargafoto3');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            $extencionArray = explode("_", $extencion);
            if ($extencionArray[1] == "jpg" || $extencionArray[1] == "JPG" || $extencionArray[1] == "jpeg" || $extencionArray[1] == "JPEG" || $extencionArray[1] == "png" || $extencionArray[1] == "PNG" || $extencionArray[1] == "jfif" || $extencionArray[1] == "JFIF") {            } else {
                return [
                    'status' => 400,
                    'msg' => "Solo se permiten imagenes",
                ];
            }
            $nombreGuardar3 = "f3_".$numeroRandom  . $request->check_list . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("foto_instalaciones/" . $nombreGuardar3,  \File::get($file));
        }
        //FOTO 4
        if (!empty($request->file('cargafoto4'))) {
            $file = $request->file('cargafoto4');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            $extencionArray = explode("_", $extencion);
            if ($extencionArray[1] == "jpg" || $extencionArray[1] == "JPG" || $extencionArray[1] == "jpeg" || $extencionArray[1] == "JPEG" || $extencionArray[1] == "png" || $extencionArray[1] == "PNG" || $extencionArray[1] == "jfif" || $extencionArray[1] == "JFIF") {            } else {
                return [
                    'status' => 400,
                    'msg' => "Solo se permiten imagenes",
                ];
            }
            $nombreGuardar4 = "f4_" .$numeroRandom . $request->check_list . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("foto_instalaciones/" . $nombreGuardar4,  \File::get($file));
        }
        //FOTO 5
        if (!empty($request->file('cargafoto5'))) {
            $file = $request->file('cargafoto5');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            $extencionArray = explode("_", $extencion);
            if ($extencionArray[1] == "jpg" || $extencionArray[1] == "JPG" || $extencionArray[1] == "jpeg" || $extencionArray[1] == "JPEG" || $extencionArray[1] == "png" || $extencionArray[1] == "PNG" || $extencionArray[1] == "jfif" || $extencionArray[1] == "JFIF") {            } else {
                return [
                    'status' => 400,
                    'msg' => "Solo se permiten imagenes",
                ];
            }
            $nombreGuardar5 = "f5_" .$numeroRandom . $request->check_list . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("foto_instalaciones/" . $nombreGuardar5,  \File::get($file));
        }
        //FOTO 6
        if (!empty($request->file('cargafoto6'))) {
            $file = $request->file('cargafoto6');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            $extencionArray = explode("_", $extencion);
            if ($extencionArray[1] == "jpg" || $extencionArray[1] == "JPG" || $extencionArray[1] == "jpeg" || $extencionArray[1] == "JPEG" || $extencionArray[1] == "png" || $extencionArray[1] == "PNG" || $extencionArray[1] == "jfif" || $extencionArray[1] == "JFIF") {            } else {
                return [
                    'status' => 400,
                    'msg' => "Solo se permiten imagenes",
                ];
            }
            $nombreGuardar6 = "f6_" .$numeroRandom . $request->check_list . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("foto_instalaciones/" . $nombreGuardar6,  \File::get($file));
        }
        //FOTO 7
        if (!empty($request->file('cargafoto7'))) {
            $file = $request->file('cargafoto7');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            $extencionArray = explode("_", $extencion);
            if ($extencionArray[1] == "jpg" || $extencionArray[1] == "JPG" || $extencionArray[1] == "jpeg" || $extencionArray[1] == "JPEG" || $extencionArray[1] == "png" || $extencionArray[1] == "PNG" || $extencionArray[1] == "jfif" || $extencionArray[1] == "JFIF") {            } else {
                return [
                    'status' => 400,
                    'msg' => "Solo se permiten imagenes",
                ];
            }
            $nombreGuardar7 = "f7_".$numeroRandom  . $request->check_list . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("foto_instalaciones/" . $nombreGuardar7,  \File::get($file));
        }
        //FOTO 8
        if (!empty($request->file('cargafoto8'))) {
            $file = $request->file('cargafoto8');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            $extencionArray = explode("_", $extencion);
            if ($extencionArray[1] == "jpg" || $extencionArray[1] == "JPG" || $extencionArray[1] == "jpeg" || $extencionArray[1] == "JPEG" || $extencionArray[1] == "png" || $extencionArray[1] == "PNG" || $extencionArray[1] == "jfif" || $extencionArray[1] == "JFIF") {            } else {
                return [
                    'status' => 400,
                    'msg' => "Solo se permiten imagenes",
                ];
            }
            $nombreGuardar8 = "f8_".$numeroRandom  . $request->check_list . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("foto_instalaciones/" . $nombreGuardar8,  \File::get($file));
        }
        //FOTO 9
        if (!empty($request->file('cargafoto9'))) {
            $file = $request->file('cargafoto9');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            $extencionArray = explode("_", $extencion);
            if ($extencionArray[1] == "jpg" || $extencionArray[1] == "JPG" || $extencionArray[1] == "jpeg" || $extencionArray[1] == "JPEG" || $extencionArray[1] == "png" || $extencionArray[1] == "PNG" || $extencionArray[1] == "jfif" || $extencionArray[1] == "JFIF") {            } else {
                return [
                    'status' => 400,
                    'msg' => "Solo se permiten imagenes",
                ];
            }
            $nombreGuardar9 = "f9_".$numeroRandom  . $request->check_list . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("foto_instalaciones/" . $nombreGuardar9,  \File::get($file));
        }
        //FOTO 10    
        if (!empty($request->file('cargafoto10'))) {
            $file = $request->file('cargafoto10');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            $extencionArray = explode("_", $extencion);
            if ($extencionArray[1] == "jpg" || $extencionArray[1] == "JPG" || $extencionArray[1] == "jpeg" || $extencionArray[1] == "JPEG" || $extencionArray[1] == "png" || $extencionArray[1] == "PNG" || $extencionArray[1] == "jfif" || $extencionArray[1] == "JFIF") {            } else {
                return [
                    'status' => 400,
                    'msg' => "Solo se permiten imagenes",
                ];
            }
            $nombreGuardar10 = "f10_".$numeroRandom  . $request->check_list . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("foto_instalaciones/" . $nombreGuardar10,  \File::get($file));
        }
        //FOTO 11
        if (!empty($request->file('cargafoto11'))) {
            $file = $request->file('cargafoto10');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            $extencionArray = explode("_", $extencion);
            if ($extencionArray[1] == "jpg" || $extencionArray[1] == "JPG" || $extencionArray[1] == "jpeg" || $extencionArray[1] == "JPEG" || $extencionArray[1] == "png" || $extencionArray[1] == "PNG" || $extencionArray[1] == "jfif" || $extencionArray[1] == "JFIF") {            } else {
                return [
                    'status' => 400,
                    'msg' => "Solo se permiten imagenes",
                ];
            }
            $nombreGuardar11 = "f11_" .$numeroRandom . $request->check_list . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("foto_instalaciones/" . $nombreGuardar11,  \File::get($file));
        }
        //FOTO 12   
        if (!empty($request->file('cargafoto12'))) {
            $file = $request->file('cargafoto10');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            $extencionArray = explode("_", $extencion);
            if ($extencionArray[1] == "jpg" || $extencionArray[1] == "JPG" || $extencionArray[1] == "jpeg" || $extencionArray[1] == "JPEG" || $extencionArray[1] == "png" || $extencionArray[1] == "PNG" || $extencionArray[1] == "jfif" || $extencionArray[1] == "JFIF") {            } else {
                return [
                    'status' => 400,
                    'msg' => "Solo se permiten imagenes",
                ];
            }
            $nombreGuardar12 = "f12_".$numeroRandom  . $request->check_list . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("foto_instalaciones/" . $nombreGuardar12,  \File::get($file));
        }
        //FOTO 13    
        if (!empty($request->file('cargafoto13'))) {
            $file = $request->file('cargafoto10');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            $extencionArray = explode("_", $extencion);
            if ($extencionArray[1] == "jpg" || $extencionArray[1] == "JPG" || $extencionArray[1] == "jpeg" || $extencionArray[1] == "JPEG" || $extencionArray[1] == "png" || $extencionArray[1] == "PNG" || $extencionArray[1] == "jfif" || $extencionArray[1] == "JFIF") {
            } else {
                return [
                    'status' => 400,
                    'msg' => "Solo se permiten imagenes",
                ];
            }
            $nombreGuardar13 = "f13_".$numeroRandom  . $request->check_list . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("foto_instalaciones/" . $nombreGuardar13,  \File::get($file));
        }

        ////$deletedRows = App\fotos_check_instalacions::where('checklist_instalacion_id', $request->check_list)->delete();

        if (!empty($request->file('cargafoto1'))) {
            //$deletedRows = App\fotos_check_instalacions::where('url', 'foto_instalaciones/f1_' . $request->check_list . '.png')->delete();
            //$deletedRows = App\fotos_check_instalacions::where('url', 'foto_instalaciones/f1_' . $request->check_list . '.jpg')->delete();
            $fotos_check_instalacions = new App\fotos_check_instalacions;
            $fotos_check_instalacions->descripcion_foto  = $nombreGuardar1;
            $fotos_check_instalacions->url  = "foto_instalaciones/" . $nombreGuardar1;
            $fotos_check_instalacions->checklist_instalacion_id   = $request->check_list;
            $fotos_check_instalacions->timestamps = false;
            $fotos_check_instalacions->save();
        }
        if (!empty($request->file('cargafoto2'))) {
            //$deletedRows = App\fotos_check_instalacions::where('url', 'foto_instalaciones/f2_' . $request->check_list . '.png')->delete();
            //$deletedRows = App\fotos_check_instalacions::where('url', 'foto_instalaciones/f2_' . $request->check_list . '.jpg')->delete();
            $fotos_check_instalacions = new App\fotos_check_instalacions;
            $fotos_check_instalacions->descripcion_foto  = $nombreGuardar2;
            $fotos_check_instalacions->url  = "foto_instalaciones/" . $nombreGuardar2;
            $fotos_check_instalacions->checklist_instalacion_id   = $request->check_list;
            $fotos_check_instalacions->timestamps = false;
            $fotos_check_instalacions->save();
        }
        if (!empty($request->file('cargafoto3'))) {
            //$deletedRows = App\fotos_check_instalacions::where('url', 'foto_instalaciones/f3_' . $request->check_list . '.png')->delete();
            //$deletedRows = App\fotos_check_instalacions::where('url', 'foto_instalaciones/f3_' . $request->check_list . '.jpg')->delete();
            $fotos_check_instalacions = new App\fotos_check_instalacions;
            $fotos_check_instalacions->descripcion_foto  = $nombreGuardar3;
            $fotos_check_instalacions->url  = "foto_instalaciones/" . $nombreGuardar3;
            $fotos_check_instalacions->checklist_instalacion_id   = $request->check_list;
            $fotos_check_instalacions->timestamps = false;
            $fotos_check_instalacions->save();
        }
        if (!empty($request->file('cargafoto4'))) {
            //$deletedRows = App\fotos_check_instalacions::where('url', 'foto_instalaciones/f4_' . $request->check_list . '.png')->delete();
            //$deletedRows = App\fotos_check_instalacions::where('url', 'foto_instalaciones/f4_' . $request->check_list . '.jpg')->delete();
            $fotos_check_instalacions = new App\fotos_check_instalacions;
            $fotos_check_instalacions->descripcion_foto  = $nombreGuardar4;
            $fotos_check_instalacions->url  = "foto_instalaciones/" . $nombreGuardar4;
            $fotos_check_instalacions->checklist_instalacion_id   = $request->check_list;
            $fotos_check_instalacions->timestamps = false;
            $fotos_check_instalacions->save();
        }
        if (!empty($request->file('cargafoto5'))) {
            //$deletedRows = App\fotos_check_instalacions::where('url', 'foto_instalaciones/f5_' . $request->check_list . '.png')->delete();
            //$deletedRows = App\fotos_check_instalacions::where('url', 'foto_instalaciones/f5_' . $request->check_list . '.jpg')->delete();
            $fotos_check_instalacions = new App\fotos_check_instalacions;
            $fotos_check_instalacions->descripcion_foto  = $nombreGuardar5;
            $fotos_check_instalacions->url  = "foto_instalaciones/" . $nombreGuardar5;
            $fotos_check_instalacions->checklist_instalacion_id   = $request->check_list;
            $fotos_check_instalacions->timestamps = false;
            $fotos_check_instalacions->save();
        }
        if (!empty($request->file('cargafoto6'))) {
            //$deletedRows = App\fotos_check_instalacions::where('url', 'foto_instalaciones/f6_' . $request->check_list . '.png')->delete();
            //$deletedRows = App\fotos_check_instalacions::where('url', 'foto_instalaciones/f6_' . $request->check_list . '.jpg')->delete();
            $fotos_check_instalacions = new App\fotos_check_instalacions;
            $fotos_check_instalacions->descripcion_foto  = $nombreGuardar6;
            $fotos_check_instalacions->url  = "foto_instalaciones/" . $nombreGuardar6;
            $fotos_check_instalacions->checklist_instalacion_id   = $request->check_list;
            $fotos_check_instalacions->timestamps = false;
            $fotos_check_instalacions->save();
        }
        if (!empty($request->file('cargafoto7'))) {
            //$deletedRows = App\fotos_check_instalacions::where('url', 'foto_instalaciones/f7_' . $request->check_list . '.png')->delete();
            //$deletedRows = App\fotos_check_instalacions::where('url', 'foto_instalaciones/f7_' . $request->check_list . '.jpg')->delete();
            $fotos_check_instalacions = new App\fotos_check_instalacions;
            $fotos_check_instalacions->descripcion_foto  = $nombreGuardar7;
            $fotos_check_instalacions->url  = "foto_instalaciones/" . $nombreGuardar7;
            $fotos_check_instalacions->checklist_instalacion_id   = $request->check_list;
            $fotos_check_instalacions->timestamps = false;
            $fotos_check_instalacions->save();
        }
        if (!empty($request->file('cargafoto8'))) {
            //$deletedRows = App\fotos_check_instalacions::where('url', 'foto_instalaciones/f8_' . $request->check_list . '.png')->delete();
            //$deletedRows = App\fotos_check_instalacions::where('url', 'foto_instalaciones/f8_' . $request->check_list . '.jpg')->delete();
            $fotos_check_instalacions = new App\fotos_check_instalacions;
            $fotos_check_instalacions->descripcion_foto  = $nombreGuardar8;
            $fotos_check_instalacions->url  = "foto_instalaciones/" . $nombreGuardar8;
            $fotos_check_instalacions->checklist_instalacion_id   = $request->check_list;
            $fotos_check_instalacions->timestamps = false;
            $fotos_check_instalacions->save();
        }
        if (!empty($request->file('cargafoto9'))) {
            //$deletedRows = App\fotos_check_instalacions::where('url', 'foto_instalaciones/f9_' . $request->check_list . '.png')->delete();
            //$deletedRows = App\fotos_check_instalacions::where('url', 'foto_instalaciones/f9_' . $request->check_list . '.jpg')->delete();
            $fotos_check_instalacions = new App\fotos_check_instalacions;
            $fotos_check_instalacions->descripcion_foto  = $nombreGuardar9;
            $fotos_check_instalacions->url  = "foto_instalaciones/" . $nombreGuardar9;
            $fotos_check_instalacions->checklist_instalacion_id   = $request->check_list;
            $fotos_check_instalacions->timestamps = false;
            $fotos_check_instalacions->save();
        }
        if (!empty($request->file('cargafoto10'))) {
            //$deletedRows = App\fotos_check_instalacions::where('url', 'foto_instalaciones/f10_' . $request->check_list . '.png')->delete();
            //$deletedRows = App\fotos_check_instalacions::where('url', 'foto_instalaciones/f10_' . $request->check_list . '.jpg')->delete();
            $fotos_check_instalacions = new App\fotos_check_instalacions;
            $fotos_check_instalacions->descripcion_foto  = $nombreGuardar10;
            $fotos_check_instalacions->url  = "foto_instalaciones/" . $nombreGuardar10;
            $fotos_check_instalacions->checklist_instalacion_id   = $request->check_list;
            $fotos_check_instalacions->timestamps = false;
            $fotos_check_instalacions->save();
        }
        if (!empty($request->file('cargafoto11'))) {
            //$deletedRows = App\fotos_check_instalacions::where('url', 'foto_instalaciones/f11_' . $request->check_list . '.png')->delete();
            //$deletedRows = App\fotos_check_instalacions::where('url', 'foto_instalaciones/f11_' . $request->check_list . '.jpg')->delete();
            $fotos_check_instalacions = new App\fotos_check_instalacions;
            $fotos_check_instalacions->descripcion_foto  = $nombreGuardar11;
            $fotos_check_instalacions->url  = "foto_instalaciones/" . $nombreGuardar11;
            $fotos_check_instalacions->checklist_instalacion_id   = $request->check_list;
            $fotos_check_instalacions->timestamps = false;
            $fotos_check_instalacions->save();
        }
        if (!empty($request->file('cargafoto12'))) {
            //$deletedRows = App\fotos_check_instalacions::where('url', 'foto_instalaciones/f12_' . $request->check_list . '.png')->delete();
            //$deletedRows = App\fotos_check_instalacions::where('url', 'foto_instalaciones/f12_' . $request->check_list . '.jpg')->delete();
            $fotos_check_instalacions = new App\fotos_check_instalacions;
            $fotos_check_instalacions->descripcion_foto  = $nombreGuardar12;
            $fotos_check_instalacions->url  = "foto_instalaciones/" . $nombreGuardar12;
            $fotos_check_instalacions->checklist_instalacion_id   = $request->check_list;
            $fotos_check_instalacions->timestamps = false;
            $fotos_check_instalacions->save();
        }
        if (!empty($request->file('cargafoto13'))) {
            //$deletedRows = App\fotos_check_instalacions::where('url', 'foto_instalaciones/f13_' . $request->check_list . '.png')->delete();
            //$deletedRows = App\fotos_check_instalacions::where('url', 'foto_instalaciones/f13_' . $request->check_list . '.jpg')->delete();
            $fotos_check_instalacions = new App\fotos_check_instalacions;
            $fotos_check_instalacions->descripcion_foto  = $nombreGuardar13;
            $fotos_check_instalacions->url  = "foto_instalaciones/" . $nombreGuardar13;
            $fotos_check_instalacions->checklist_instalacion_id   = $request->check_list;
            $fotos_check_instalacions->timestamps = false;
            $fotos_check_instalacions->save();
        }

        return [
            'status' => 200,
        ];
    }
    public function validar_imagenes(request $request)
    {

        $validar = DB::table('fotos_check_instalacions')->where('checklist_instalacion_id', $request->id)->get();
        if ($validar != "") {
            if (count($validar) < 3) {
                return "Ingrese las 3 fotos obligatorias";
            } else {
                return "ok";
            }
        }
    }
    public function cancelar_imagenes(request $request)
    {

        $validar = DB::table('fotos_check_instalacions')->where('checklist_instalacion_id', $request->id)->get();
        if ($validar != "") {
            if (count($validar) < 3) {
                //$deletedRows = App\fotos_check_instalacions::where('checklist_instalacion_id', $request->id)->delete();
                return count($validar);
            } else {
                return "ok";
            }
        }
    }

    public function checklisRechazar(request $request, $id_instalacion)
    {


        try {
            $checklistid = Crypt::decryptString($id_instalacion);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }





        try {
            $id_instalacion_desin = Crypt::decryptString($id_instalacion);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }





        $datos_check = DB::table('checklist_instalacions')
            //  ->join('asignacion_instalacions.id','=','checklist_instalacions.asignacion_instalacion_retiro_id')
            //  ->where('softwares.estado','=',"activo")
            ->where('checklist_instalacions.id', '=', $id_instalacion_desin)
            ->get();


        $check =  App\checklist_instalacions::findOrfail($datos_check[0]->id);
        $check->timestamps = false;
        $check->estado_inicio = "rechazado";
        //$check->motivo_rechazado = $request->motivorechazado;
        $check->save();

        //return redirect('chekstecnico')->with('mensaje', 'Checklist Actualizado');  
        $asignacion =  App\asignacion_instalacions::findOrfail($datos_check[0]->asignacion_instalacion_retiro_id);
        $asignacion->estado_asignacion     =  "rechazado";
        $asignacion->motivo_rechazado = $request->motivorechazado;
        $asignacion->fecha_termino     =  Carbon::now();
        $asignacion->timestamps = false;
        $asignacion->save();



        //actualizamos la lista de api insntalacion
        $instalacions =  App\instalacions::findOrfail($asignacion->lista_instalacion_id);
        //  $instalacions->sEstado_despacho     =  "rechazado"  ;
        $instalacions->sEstado_instalacion = "rechazado";
        $instalacions->timestamps = false;
        $instalacions->save();

        // return redirect(session('url_cordinadora'))->with('mensaje', 'Checklist Rechazado');  

        //  return redirect('ver_api_instalaciones')->with('mensaje', 'Checklist Rechazado');  

        $url = session('url_cordinadora');
        if (!empty($url)) {
            return redirect($url)->with('mensaje', 'Checklist Rechazado');
         } else {
            return redirect('/home')->with('mensaje_error', 'Checklist Rechazado');
        }
    }


    public function checklisReasignar(request $request, $id_instalacion)
    {


        try {
            $checklistid = Crypt::decryptString($id_instalacion);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }





        try {
            $id_instalacion_desin = Crypt::decryptString($id_instalacion);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }





        $datos_check = DB::table('checklist_instalacions')
            //  ->join('asignacion_instalacions.id','=','checklist_instalacions.asignacion_instalacion_retiro_id')
            //  ->where('softwares.estado','=',"activo")
            ->where('checklist_instalacions.id', '=', $id_instalacion_desin)
            ->get();


        $check =  App\checklist_instalacions::findOrfail($datos_check[0]->id);
        $check->timestamps = false;
        $check->estado_inicio = "reasignar";
        //$check->motivo_rechazado = $request->motivorechazado;
        $check->save();

        //return redirect('chekstecnico')->with('mensaje', 'Checklist Actualizado');  
        $asignacion =  App\asignacion_instalacions::findOrfail($datos_check[0]->asignacion_instalacion_retiro_id);
        $asignacion->estado_asignacion     =  "reasignar";
        $asignacion->motivo_rechazado = $request->motivorechazado;
        $asignacion->fecha_termino     =  Carbon::now();
        $asignacion->timestamps = false;
        $asignacion->save();



        //actualizamos la lista de api insntalacion
        $instalacions =  App\instalacions::findOrfail($asignacion->lista_instalacion_id);
        //$instalacions->sEstado_despacho     =  "reasignar"  ;
        $instalacions->sEstado_instalacion = "reasignar";
        $instalacions->timestamps = false;
        $instalacions->save();

        // return redirect(session('url_cordinadora'))->with('mensaje', 'Checklist  listo para Reasignar');  

        // return redirect(session('url_cordinadora'))->with('mensaje', 'Checklist Asignado');  

        //   return redirect('ver_api_instalaciones')->with('mensaje', 'Checklist  listo para Reasignar');  

        $url = session('url_cordinadora');
        return redirect($url)->with('mensaje', 'Checklist  listo para Reasignar');
    }

    //obtener datos_api_retiro
    public function datos_api_retiro(Request $request)
    {
        try {
            $id_asignacion = Crypt::decryptString($request->id_retiros);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }
        $datosretiro = DB::table('retiros')
            ->select(
                'retiros.id',
                'retiros.tracker_id',
                'retiros.nFolio',
                'retiros.sRegion',
                'retiros.sRut',
                'retiros.sCliente',
                'retiros.sCiudad',
                'retiros.sComuna',
                'retiros.sDireccion',
                'retiros.sSerie',
                'retiros.sModelo',
                'retiros.nContador',
                'retiros.nContador_color',
                'retiros.nGuia',
                'retiros.sEstado',
                'retiros.sObservacion',
                'retiros.sCui',
                'retiros.dFecharegistrado'
            )
            ->where('retiros.id', '=', $id_asignacion)
            ->get();

        return  $datosretiro;
    }


    //obtener datos_api_instalacion
    public function datos_instalacion(Request $request)
    {
        try {
            $id_instalacion = Crypt::decryptString($request->id_instalacion);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }

        $datosinstalacion = DB::table('instalacions')
            ->select(
                'instalacions.id',
                'instalacions.tracker_idtracker',
                'instalacions.nFolio',
                'instalacions.sRegion',
                'instalacions.sRut',
                'instalacions.sCliente',
                'instalacions.sCiudad',
                'instalacions.sComuna',
                'instalacions.sDireccion',
                'instalacions.sSerie',
                'instalacions.sModelo',
                'instalacions.nContador',
                'instalacions.nContador_color',
                'instalacions.nGuia',
                'instalacions.sObservacion',
                'instalacions.sCui',
                'instalacions.dFecha_instalacion'
            )
            ->where('instalacions.id', '=', $id_instalacion)
            ->get();

        return  $datosinstalacion;
    }

    public function funguardandofotosprueba2(request $request)
    {

        try {
            $id_checlistInstalacion = Crypt::decryptString($request->check);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }
        $url = DB::table('checklist_instalacions')
            ->select('url_firma')
            ->where('id', '=', $id_checlistInstalacion)
            ->get();
        
        $checks = $request->jerarquia;
        if ($checks != "" || $checks != null) {
            $contador = count($checks);
            for ($i = 0; $i < $contador; $i++) {
                $check_masivo =  App\checklist_instalacions::findOrfail($checks[$i]);
                $check_masivo->url_firma = $url[0]->url_firma;
                $check_masivo->timestamps = false;
                $check_masivo->save();
            }
        }

        return back()->with('mensaje', 'Firma masiva exitosa');
    }

    // para guardar las fotos
    public function funguardandofotosprueba(request $request)
    {
        if (isset($request->imagen_firma)) {

            // mostrar la imagen
            try {
                $id_checlistInstalacion = Crypt::decryptString($request->check);
            } catch (DecryptException $e) {
                //
                return "No Puede Realizar Esta Accion";
            }
            $nombre_guardar = "firmacheckinstalacion" . $id_checlistInstalacion . ".png";
            // funcion para gusrfdar la imagen base64 en el servidor
            // el nombre debe tener la extension
            function uploadImgBase64($base64, $name)
            {
                $datosBase64 = base64_decode(preg_replace('#^data:image/\w+;base64,#i', '', $base64));
                //optimixar para poder subir imagenes
                $path = $_SERVER['DOCUMENT_ROOT'] . '/aya/rendicion/fotos/fotos_firmas/' . $name;

                // guardamos la imagen en el server
                if (!file_put_contents($path, $datosBase64)) {
                    // retorno si falla
                    return "0";
                } else {
                    // retorno si todo fue bien
                    return "1";
                }
            }

            // llamamos a la funcion uploadImgBase64( img_base64, nombre_fina.png) 
            $resultado = uploadImgBase64($request->imagen_firma, $nombre_guardar);

            if ($resultado == "0") {
                return "Intente nuevamente";
            } else {

                $check =  App\checklist_instalacions::findOrfail($id_checlistInstalacion);
                $check->url_firma = "fotos_firmas/" . $nombre_guardar;
                $check->timestamps = false;
                $check->save();

                $checks = $request->jerarquia;
                if(!empty($checks)){
                    $datos =  explode(',',$checks);
                    foreach($datos as $los_datos){
                        if($los_datos != ""){
                            $check_masivo =  App\checklist_instalacions::findOrfail($los_datos);
                            $check_masivo->url_firma = "fotos_firmas/" . $nombre_guardar;
                            $check_masivo->timestamps = false;
                            $check_masivo->save();
                        }
                    }
                }
                return "Firma Guardada con Exito";
            }
        } else {
            return "Intente Nuevamente";
        }
    }


    //Ver Checklist Retiro Coordinadora
    public function ver_retirocoodinadora($idasig)
    {
        try {
            $idretiroasig = Crypt::decryptString($idasig);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }
        $datos_asignacion = DB::table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_retiros.trabajadors_idtecnico')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'asignacion_retiros.numero_visita',
                'checklist_retiros.csDireccion',
                'checklist_retiros.csComuna',
                'checklist_retiros.csCui',
                'checklist_retiros.csSerie',
                'checklist_retiros.estado_check',
                'checklist_retiros.csModelo',
                'checklist_retiros.cnContador',
                'checklist_retiros.cnContador_color',
                'checklist_retiros.csObservacion',
                'checklist_retiros.nombre_contacto',
                'checklist_retiros.bandeja_adicional',
                'checklist_retiros.mueble',
                'checklist_retiros.kitlector',
                'checklist_retiros.memoriasd',
                'checklist_retiros.cablered',
                'checklist_retiros.cablepoder',
                'checklist_retiros.equipoembalado',
                'checklist_retiros.cliente_firma',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'personas.apellido_dos',
                'asignacion_retiros.fecha_termino',
                'asignacion_retiros.fecha_inicio',
                'asignacion_retiros.fecha_asignado',
                'asignacion_retiros.fecha_retiro',
                'asignacion_retiros.estado_asignacion',
                'asignacion_retiros.id as idCheckRetiros',
                'checklist_retiros.url_firma',
                'checklist_retiros.id as id_retiroChec'
            )

            ->where('asignacion_retiros.id', '=', $idretiroasig)
            ->get();




        $proyectos =  DB::table('asignacion_retiros')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->join('tracker', 'tracker.id', '=', 'retiros.tracker_id')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')

            ->select('clientes.razon_social', 'proyectos.nombre')
            ->where('asignacion_retiros.id', '=', $idretiroasig)
            ->get();

        $fotos = DB::table('fotos_retiros')
            ->where('fotos_retiros.checklist_retiros_id', '=', $datos_asignacion[0]->id_retiroChec)
            ->get();

        return view('check.ver_checklist_retiro_coordinadora', compact('datos_asignacion', 'proyectos', 'fotos'));
    }



    public function buscar_opciones(request $request)
    {




        $detalle = "";


        $opcione = $request->id;

        switch ($opcione) {
            case 'Finalizar':
                # code...
                $detalle = collect(['Ubicación provisoria', 'Habilitación de credenciales', 'Continua usando equipo anterior', 'Equipo operativo', 'Configurado, pendiente Capacitación']);

                break;

            case 'Pendiente':

                # code...
                $detalle = collect(['Rechazado por usuario', 'Usuario pide reagendar visita', 'Pre-Instalacion']);

                break;
            case 'Cancelar':
                # code...
                $detalle = collect([
                    'NO REALIZADO POR A&A', 'Ingreso no autorizado a la sucursal', 'Sin accesorios', 'Sin Memoria', 'Sin Mueble Base', 'Sin SD', 'Sin Cable de red
                ',
                    'Sin Cable de poder', 'Punto de red defectuoso', 'Sucursal cerrada', 'Sin punto de red', 'Sin punto eléctrico', 'Equipo con daño', 'Equipo Sin tóner', 'No llega equipo a sucursal ', 'Sin Lector de tarjeta', 'Ubicación no definida', 'No se puede instalar por bloqueo de red en los puntos'
                ]);

                break;
            default:
                # code...
                return "intente Nuevamente ";
                break;
        }
        return $detalle;
    }





    public function GenerarpdfIntalacionCordin($idasig)
    {


        try {
            $id_asignacion = Crypt::decryptString($idasig);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }

        $mi_asignacion = DB::table('asignacion_instalacions')
            ->where('asignacion_instalacions.id', '=', $id_asignacion)
            ->get();

        $id_trabajador = $mi_asignacion[0]->trabajadors_id;

        $datos_asignacion = DB::table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('softwares', 'softwares.id', '=', 'checklist_instalacions.softwares_id')
            ->join('tipo_conexiones', 'tipo_conexiones.id', '=', 'checklist_instalacions.tipo_conexiones_id')
            ->join('nombre_servidores', 'nombre_servidores.id', '=', 'checklist_instalacions.nombre_servidores_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscliente',
                'asignacion_instalacions.estado_asignacion',
                'asignacion_instalacions.fecha_instalacion',
                'asignacion_instalacions.id',
                'asignacion_instalacions.numero_visita',
                'checklist_instalacions.Csmarca',
                'checklist_instalacions.modo_U253',
                'checklist_instalacions.ins_driver',
                'asignacion_instalacions.tipos_visitas_id',
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscomuna',
                'checklist_instalacions.Cscui',
                'checklist_instalacions.Cspiso',
                'checklist_instalacions.Csregion',
                'checklist_instalacions.Cnfolio',
                'checklist_instalacions.Cscambio_serie',
                'checklist_instalacions.CsSerie',
                'checklist_instalacions.Csserie_remplazo',
                'checklist_instalacions.CsModelo',
                'checklist_instalacions.Csmodelo_remplazo',
                'checklist_instalacions.CUsb_red',
                'checklist_instalacions.CDriver',
                'checklist_instalacions.Cscontacto',
                'checklist_instalacions.CsSC',
                'asignacion_instalacions.lista_instalacion_id as id_instalacion',
                'checklist_instalacions.CsIP',
                'checklist_instalacions.CsGateway',
                'checklist_instalacions.CsMsk',
                'checklist_instalacions.CnContador',
                'checklist_instalacions.CnContador_color',
                'checklist_instalacions.id as id_checklist',
                'softwares.descripcion as nombre_software',
                'tipo_conexiones.descripcion as nombre_conexion',
                'nombre_servidores.descripcion as nombre_servidor',
                'personas.nombre_uno as nombrepersona',
                'personas.nombre_dos as nombrepe',
                'personas.apellido_uno as apellidouno',
                'personas.apellido_dos as apellidodos',
                'checklist_instalacions.CsObservacion',
                'checklist_instalacions.CsBandeja_adicional',
                'checklist_instalacions.CsMueble',
                'checklist_instalacions.CsKit_lector',
                'checklist_instalacions.CsSD',
                'checklist_instalacions.CsCable_poder',
                'checklist_instalacions.CsCable_red',
                'checklist_instalacions.Csconexion_electrica',
                'checklist_instalacions.Csservidor_impresion',
                'checklist_instalacions.Csservidor_impresion',
                'checklist_instalacions.Csconfig_smb',
                'checklist_instalacions.Csconfig_email',
                'checklist_instalacions.Cscantidad_usuarios',
                'checklist_instalacions.firma_contacto',
                'checklist_instalacions.observacion',
                'checklist_instalacions.url_firma',
                'checklist_instalacions.tipo_equipo',
                'checklist_instalacions.fecha_inicio',
                'checklist_instalacions.fecha_fin',
                'checklist_instalacions.CsMarca_es',
                'checklist_instalacions.CsSerie_es',
                'checklist_instalacions.CsModelo_es',
                'checklist_instalacions.CsTipoequipo_es',
                'checklist_instalacions.CsContador_es',
                'checklist_instalacions.CsContadorcolor_es',
                'checklist_instalacions.motivo',
                'checklist_instalacions.nombre_contactoF',
                'checklist_instalacions.rut_contactoF',
                'trabajadors.id as id_trabajador',
                'checklist_instalacions.idSala',
                'checklist_instalacions.Cstipo_sucursal'


                // 'checklist_instalacions.razonSocial'

            )
            ->where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_instalacions.id', '=', $id_asignacion)
            ->orderBy('asignacion_instalacions.id', 'desc')
            ->get();

        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id', '=', $datos_asignacion[0]->id_trabajador)
            ->get();
        // $firmatrabajador = DB::table('firma_clientes')
        //     ->where('firma_clientes.id_tecnico', '=', $datos_trabajador[0]->id_login)
        //     ->get();

        $firmatrabajador = DB::table('firma_clientes')
            ->where('firma_clientes.id_tecnico', '=', $datos_trabajador[0]->id)
            ->get();

        //return $firmatrabajador;

        //encontramos el nombre del proyecto asociado al checklist de instalacion
        $id_instalacion = $datos_asignacion[0]->id_instalacion;
        $proyecto_asociado = DB::table('instalacions')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->select('proyectos.nombre', 'clientes.razon_social', 'proyectos.url_logo', 'proyectos.proveedor_nombre','instalacions.razonSocial')
            ->where('instalacions.id', '=', $id_instalacion)
            ->get();

            //RAZONSOCIALAGRUPADAS
        $con_razonSocial= "no";
        $razonAgrupasa = DB::table('clientes')
        ->select('razon_social_agrupada')
        ->where('clientes.razon_social', '=', $proyecto_asociado[0]->razon_social)
        ->get();

        if(count($razonAgrupasa ) >0){
            $con_razonSocial = $razonAgrupasa[0]->razon_social_agrupada;
          }else{
              $con_razonSocial= "no";
          
          }

        // modal foto traer imagenes.
        $fotos = DB::table('fotos_check_instalacions')
            ->where('fotos_check_instalacions.checklist_instalacion_id', '=', $datos_asignacion[0]->id_checklist)
            ->get();


        // return $proyecto_asociado;clientes_id


        $softwares = DB::table('softwares')
            ->where('softwares.estado', '=', "activo")
            //->where('softwares.id','!=',1)
            ->get();


        $servidores = DB::table('nombre_servidores')
            ->where('nombre_servidores.estado', '=', "activo")
            //->where('nombre_servidores.id','!=',1)
            ->get();


        $tipo_conexion = DB::table('tipo_conexiones')
            ->where('tipo_conexiones.estado', '=', "activo")
            //->where('tipo_conexiones.id','!=',1)
            ->get();



        $datos_accesorios = DB::table('checklist_accesorios')
            ->join('accesorios', 'accesorios.id', '=', 'checklist_accesorios.id_accesorio')
            ->select('accesorios.id', 'accesorios.articulo', 'accesorios.descripcion', 'checklist_accesorios.cantidad', 'checklist_accesorios.serie_parte')
            ->where('checklist_accesorios.id_checklist_instalacion', '=', $datos_asignacion[0]->id_checklist)
            ->get();

        $accesorios_dañados = DB::table('checklist_accesorios_dañados')
            ->join('accesorios', 'accesorios.id', '=', 'checklist_accesorios_dañados.id_accesorio')
            ->select('accesorios.id', 'accesorios.descripcion', 'accesorios.articulo', 'checklist_accesorios_dañados.cantidad', 'checklist_accesorios_dañados.serie_parte')
            ->where('checklist_accesorios_dañados.id_checklist_instalacion', '=', $datos_asignacion[0]->id_checklist)
            ->get();

        $accesorios_manuales = DB::table('accesorios_manuales')
            ->where('accesorios_manuales.id_checklist_instalacion', '=', $datos_asignacion[0]->id_checklist)
            ->get();

        $instalacion_accesorios = DB::table('checklist_instalacion_accesorios')
            ->join('accesorios', 'accesorios.id', '=', 'checklist_instalacion_accesorios.id_accesorio')
            ->select('accesorios.id', 'accesorios.descripcion', 'accesorios.articulo', 'checklist_instalacion_accesorios.cantidad', 'accesorios.id as ID', 'checklist_instalacion_accesorios.serie_parte')
            ->where('checklist_instalacion_accesorios.id_checklist_instalacion', '=', $datos_asignacion[0]->id_checklist)
            ->get();

        $instalacion_accesorios_manuales = DB::table('instalacion_accesorios_manuales')
            ->where('instalacion_accesorios_manuales.id_checklist_instalacion', '=', $datos_asignacion[0]->id_checklist)
            ->get();

        $fotos_accesorios = DB::table('fotos_checks_accesorios')
            ->where('checklist_instalacion_id', '=', $datos_asignacion[0]->id_checklist)
            ->get();


        $tipo_visita = App\tipos_visitas::findOrfail($datos_asignacion[0]->tipos_visitas_id);


        $datos = "hola";
        if ($datos_asignacion[0]->Csserie_remplazo != null || $datos_asignacion[0]->Csserie_remplazo != "") {
            return \PDF::setOptions(['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true])
                ->loadView('check/pdf.pdfInstalacionCoordinadora', compact('con_razonSocial','instalacion_accesorios_manuales', 'instalacion_accesorios', 'accesorios_manuales', 'datos_asignacion', 'tipo_visita', 'proyecto_asociado', 'fotos', 'firmatrabajador', 'datos_accesorios', 'accesorios_dañados', 'fotos_accesorios'))
                ->stream($datos_asignacion[0]->Csserie_remplazo . '.pdf');
            // return view('check/pdf.pdfInstalacionCoordinadora');
        } else {
            return \PDF::setOptions(['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true])
                ->loadView('check/pdf.pdfInstalacionCoordinadora', compact('con_razonSocial','instalacion_accesorios_manuales', 'instalacion_accesorios', 'accesorios_manuales', 'datos_asignacion', 'tipo_visita', 'proyecto_asociado', 'fotos', 'firmatrabajador', 'datos_accesorios', 'accesorios_dañados', 'fotos_accesorios'))
                ->stream($datos_asignacion[0]->CsSerie . '.pdf');
        }
    }
    public function GenerarpdfRetiroCordin($idasig)
    {



        try {
            $idretiroasig = Crypt::decryptString($idasig);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }


        $mi_asignacion = DB::table('asignacion_retiros')
            ->where('asignacion_retiros.id', '=', $idretiroasig)
            ->get();


        $id_trabajador = $mi_asignacion[0]->trabajadors_idtecnico;


        $datos_asignacion = DB::table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_retiros.trabajadors_idtecnico')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'asignacion_retiros.numero_visita',
                'checklist_retiros.csDireccion',
                'checklist_retiros.csComuna',
                'checklist_retiros.csCui',
                'checklist_retiros.csSerie',
                'checklist_retiros.csModelo',
                'checklist_retiros.cnContador',
                'checklist_retiros.cnContador_color',
                'checklist_retiros.csObservacion',
                'checklist_retiros.nombre_contacto',
                'checklist_retiros.bandeja_adicional',
                'checklist_retiros.mueble',
                'checklist_retiros.kitlector',
                'checklist_retiros.memoriasd',
                'checklist_retiros.cablered',
                'checklist_retiros.cablepoder',
                'checklist_retiros.equipoensucursal',
                'checklist_retiros.equipoembalado',
                'checklist_retiros.cliente_firma',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'personas.apellido_dos',
                'asignacion_retiros.fecha_termino',
                'asignacion_retiros.fecha_inicio',
                'asignacion_retiros.fecha_asignado',
                'asignacion_retiros.fecha_retiro',
                'checklist_retiros.id as idCheckRetiros',
                'checklist_retiros.url_firma',
                'trabajadors.id as id_trabajador'
            )

            ->where('asignacion_retiros.id', '=', $idretiroasig)
            ->get();


        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id', '=', $datos_asignacion[0]->id_trabajador)
            ->get();


        $firmatrabajador = DB::table('firma_clientes')
            ->where('firma_clientes.id_tecnico', '=', $datos_trabajador[0]->id_login)
            ->get();




        $proyectos =  DB::table('asignacion_retiros')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->join('tracker', 'tracker.id', '=', 'retiros.tracker_id')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')

            ->select('clientes.razon_social', 'proyectos.nombre', 'proyectos.url_logo', 'proyectos.proveedor_nombre')
            ->where('asignacion_retiros.id', '=', $idretiroasig)
            ->get();


        $fotos = DB::table('fotos_retiros')
            ->where('fotos_retiros.checklist_retiros_id', '=', $datos_asignacion[0]->idCheckRetiros)
            ->get();



        return \PDF::setOptions(['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true])
            ->loadView('check/pdf.pdfretiroCoordinadora', compact('datos_asignacion', 'proyectos', 'fotos', 'firmatrabajador'))
            ->stream();
        // return view('check/pdf.pdfInstalacionCoordinadora');

    }

    public function GenerarpdfCapacitacionCordin($idasig)
    {

        try {
            $idcapa = Crypt::decryptString($idasig);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }

        $datoscapa = DB::table('capacitacions')
            ->join('asignacion_capacitaciones', 'asignacion_capacitaciones.id_capa', '=', 'capacitacions.id')
            ->where('asignacion_capacitaciones.id', '=', $idcapa)
            ->get();


        $fotosCapacitacion = DB::table('fotos_capacitacions')
            ->where('fotos_capacitacions.id_capacitacion', '=', $datoscapa[0]->id_capa)
            ->get();
        $capacitadas_personas = str_replace(",", ", ", $datoscapa[0]->personas_capacitadas);
        /**/

        $datos_proyecto = DB::table('proyectos')
            ->where('proyectos.id', '=', $datoscapa[0]->proyecto_id)
            ->get();

        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', $datoscapa[0]->trabajadors_id)
            ->get();

        $id_trabajador = $datos_trabajador[0]->id;
        $id_persona = $datos_trabajador[0]->id_persona;
        $datos_tecnico = DB::table('personas')
            ->where('personas.id', '=', $id_persona)
            ->select(
                'personas.nombre_uno',
                'personas.nombre_dos',
                'personas.apellido_uno',
                'personas.apellido_dos'
            )
            ->get();

        $firmatrabajador = DB::table('firma_clientes')
            ->where('firma_clientes.id_tecnico', '=', $id_trabajador)
            ->get();

        $fecha = Carbon::now();
        $fecha = $fecha->format('y-m-d');

        return \PDF::setOptions(['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true])
            ->loadView('check/pdf.pdfcapacitacion_coordinadora', compact('fotosCapacitacion', 'datoscapa', 'datos_tecnico', 'firmatrabajador', 'datos_proyecto', 'capacitadas_personas'))
            ->stream($datoscapa[0]->direccion . '.pdf');
        // return view('check/pdf.pdfInstalacionCoordinadora');

    }

    public function GenerarpdfCapacitacionCordin_old($idasig)
    {

        try {
            $idcapa = Crypt::decryptString($idasig);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }

        $datoscapa = DB::table('capacitacions')
            ->where('capacitacions.id', '=', $idcapa)
            ->get();

        /**/
        $datos_proyecto = DB::table('proyectos')
            ->where('proyectos.id', '=', $datoscapa[0]->proyecto_id)
            ->get();

        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', $datoscapa[0]->trabajadors_id)
            ->get();


        $id_trabajador = $datos_trabajador[0]->id;
        $id_persona = $datos_trabajador[0]->id_persona;

        $datos_tecnico = DB::table('personas')
            ->where('personas.id', '=', $id_persona)

            ->select(
                'personas.nombre_uno',
                'personas.nombre_dos',
                'personas.apellido_uno',
                'personas.apellido_dos'
            )

            ->get();

        $firmatrabajador = DB::table('firma_clientes')
            ->where('firma_clientes.id_tecnico', '=', $datos_trabajador[0]->id_login)
            ->get();
        //return $datoscapa;

        $fecha = Carbon::now();
        $fecha = $fecha->format('y-m-d');


        return \PDF::setOptions(['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true])
            ->loadView('check/pdf.pdfcapacitacion_coordinadora', compact('datoscapa', 'datos_tecnico', 'firmatrabajador', 'datos_proyecto'))

            ->stream();
        // return view('check/pdf.pdfInstalacionCoordinadora');

    }

    public function GenerarpdfResumenRetiroCordin($idasig)
    {

        try {
            $idcapa = Crypt::decryptString($idasig);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }

        $datoscapa = DB::table('resumen_retiros')
            ->join('trabajadors', 'trabajadors.id', '=', 'resumen_retiros.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('resumen_retiros.id', '=', $idcapa)
            ->get();

        //nuevo
        $cuisucursal = $datoscapa[0]->cuisucursal;
        /**/
        $datos_proyecto = DB::table('proyectos')
            ->where('proyectos.id', '=', $datoscapa[0]->proyectos_id)
            ->get();

        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();

        $id_trabajador = $datos_trabajador[0]->id;
        $id_persona = $datos_trabajador[0]->id_persona;

        $datos_tecnico = DB::table('personas')
            ->where('personas.id', '=', $id_persona)
            ->select(
                'personas.nombre_uno',
                'personas.nombre_dos',
                'personas.apellido_uno',
                'personas.apellido_dos'
            )
            ->get();

        $fecha = $datoscapa[0]->fecha_resumen;

        $datos_checklist = DB::table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->select(
                'checklist_retiros.id',
                'checklist_retiros.csSerie',
                'checklist_retiros.csModelo',
                'checklist_retiros.cnContador_color',
                'checklist_retiros.cnContador',
                'asignacion_retiros.fecha_termino'
            )
            ->where('asignacion_retiros.estado_asignacion', '=', 'finalizado')
            //->whereDate ('asignacion_retiros.fecha_termino','=',$fecha)
            ->where('checklist_retiros.csCui', '=', $cuisucursal)
            ->get();

        return \PDF::setOptions(['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true])
            ->loadView('check/pdf.pdfhistorialRetiro_coordinadora', compact('datos_tecnico', 'datoscapa', 'datos_proyecto', 'datos_checklist', 'idcapa'))
            ->stream();

        // return view('check/pdf.pdfInstalacionCoordinadora');

    }


    public function cambiodefechafin(request $request)
    {

        $id = $request->id_check;
        $fecha = $request->fecha;

        // $fecha = $fecha." 17:00:00";

        $asignacion_instalacions =  App\asignacion_instalacions::findOrfail($id);
        $asignacion_instalacions->fecha_termino     = $fecha;
        $asignacion_instalacions->timestamps = false;
        $asignacion_instalacions->save();



        $checklist_instalacions =  App\checklist_instalacions::where('asignacion_instalacion_retiro_id', $asignacion_instalacions->id)->firstOrFail();
        $checklist_instalacions->fecha_fin     = $fecha;
        $checklist_instalacions->timestamps = false;
        $checklist_instalacions->save();



        $fecha = Carbon::parse($fecha);
        $fecha =  $fecha->format('d-m-Y h:i:s');

        return $fecha;
    }
    public function cambiodefechainicio(request $request)
    {
        $id = $request->id_check;
        $fecha = $request->fecha;
        $fecha = str_replace('T', ' ', $fecha);

        // $fecha = $fecha." 17:00:00";

        $asignacion_instalacions =  App\asignacion_instalacions::findOrfail($id);
        $asignacion_instalacions->fecha_inicio = $fecha;
        $asignacion_instalacions->timestamps = false;
        $asignacion_instalacions->save();



        $checklist_instalacions =  App\checklist_instalacions::where('asignacion_instalacion_retiro_id', $asignacion_instalacions->id)->firstOrFail();
        $checklist_instalacions->fecha_inicio = $fecha;
        $checklist_instalacions->timestamps = false;
        $checklist_instalacions->save();

        $fecha = Carbon::createFromDate($fecha)->format('d-m-Y H:i');

        return $fecha;
    }

    public function excel_coordinadora_instalacion_old(request $request)
    {




        $instalaciones = DB::select(
            'select instalacions.id, instalacions.dFecha_instalacion,instalacions.fecha_registrado, instalacions.sEstado_despacho, 
    instalacions.sCliente, instalacions.sComuna, instalacions.sSerie,instalacions.sDireccion,instalacions.fecha_registrado,instalacions.sEstado_instalacion,instalacions.fecha_instalacion_coordinadora,personas.nombre_uno, personas.apellido_uno, proyectos.nombre  from personas inner join trabajadors on personas.id = trabajadors.id_persona
    inner join users on trabajadors.id_login = users.id inner join asignacion_instalacions on trabajadors.id  =  asignacion_instalacions.trabajadors_id
    inner join instalacions on instalacions.id = asignacion_instalacions.lista_instalacion_id inner join  tracker on tracker.id = instalacions.tracker_idtracker
    inner join proyectos on proyectos.id =tracker.proyecto_id  group by  instalacions.sSerie'
        );


        return view('check.excel.excel_instalacioncordinadora', compact('instalaciones'));

        return $instalaciones;

        $instalaciones =  DB::table('instalacions')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->select(
                'instalacions.id',
                'instalacions.dFecha_instalacion',
                'instalacions.fecha_registrado',
                'instalacions.sEstado_despacho',
                'instalacions.sCliente',
                'instalacions.sComuna',
                'instalacions.sSerie',
                'instalacions.sDireccion',
                'instalacions.fecha_registrado',
                'instalacions.sEstado_instalacion',
                'instalacions.fecha_instalacion_coordinadora'
            )
            //  ->where("instalacions.sEstado_despacho","<>","asignado")
            ->orderBy('instalacions.fecha_registrado', 'desc')
            ->orderBy('instalacions.sComuna', 'desc')
            ->get();

        return view('check.excel.excel_instalacioncordinadora', compact('instalaciones'));
    }

    public function filtros_instalacionExport(request $request)
    {
        

        $id_persona = $request->tecnicos;
        $estado = $request->estado;
        $clientes =  $request->clientes;
        $region = $request->region;
        $comuna = $request->comuna;
        $serie = $request->serie;
        $sc = $request->sc;

        
        if ($id_persona == "" &&  $estado == ""  &&  $region == "" &&  $comuna == ""  && $serie == "" &&  $sc == "" &&  $request->datepicker == "" && $request->datepicker2 == "") {

            if (strtolower(DB::connection()->getDatabaseName()) == "kyocera") {
                $nid_tracker = DB::table('instalacions')
                    ->select('nID_Tracker')
                    ->where('sCliente', '=', $clientes)
                    ->orderby('id', 'ASC')
                    ->get();

                $instalaciones = DB::select(
                    'select
                instalacions.id,
                instalacions.sModelo,

                
                instalacions.dFecha_instalacion,
                instalacions.fecha_registrado, 
                instalacions.sEstado_despacho, 
                instalacions.sCliente, 
                instalacions.sRegion, 
                instalacions.sComuna, 
                instalacions.sSerie,
                instalacions.Csserie_remplazo as remplazo,
                instalacions.sDireccion,
                instalacions.fecha_registrado,
                instalacions.sObservacion as observacion,
                instalacions.sEstado_instalacion,
                instalacions.sTipo_sucursal,
                instalacions.idSala,

                instalacions.fecha_instalacion_coordinadora,
                proyectos.nombre  
                from instalacions
                left join tracker on tracker.id = instalacions.tracker_idtracker
                left join proyectos on proyectos.id = tracker.proyecto_id  
                where instalacions.nID_Tracker =' . '"' . $nid_tracker[0]->nID_Tracker . '"' . '
                order by instalacions.fecha_instalacion_coordinadora DESC'
                );
            } else {
                $instalaciones = DB::select(
                    'select
                    instalacions.sModelo,
                instalacions.id,
                instalacions.dFecha_instalacion,
                instalacions.fecha_registrado, 
                instalacions.sEstado_despacho, 
                instalacions.sCliente, 
                instalacions.sRegion, 
                instalacions.sComuna, 
                instalacions.sSerie,
                instalacions.Csserie_remplazo as remplazo,
                instalacions.sDireccion,
                instalacions.fecha_registrado,
                instalacions.sObservacion as observacion,
                instalacions.sEstado_instalacion,
                instalacions.fecha_instalacion_coordinadora,
                instalacions.idSala,
                instalacions.sTipo_sucursal,

                proyectos.nombre  
                from instalacions
                left join tracker on tracker.id = instalacions.tracker_idtracker
                left join proyectos on proyectos.id = tracker.proyecto_id  
                where instalacions.sCliente =' . '"' . $clientes . '"' . '
                order by instalacions.fecha_instalacion_coordinadora DESC'
                );
            }
         
            return view('check.excel.excel_instalacioncordinadora', compact('instalaciones'));
        }

        $where  = "instalacions.id != " . "''";

        if ($request->datepicker != "" && $request->datepicker2 != "") {
            $fecha = Carbon::createFromDate($request->datepicker)->format('Y-m-d');
            $fecha2 = Carbon::createFromDate($request->datepicker2)->format('Y-m-d');
            $where = $where . " and instalacions.fecha_instalacion_coordinadora" . " BETWEEN " . "'" . $fecha . "'" . " and " . "'" . $fecha2 . "'";
        }
        if ($estado != "") {
            $where = $where . " and instalacions.sEstado_instalacion" . " = " . "'" . $estado . "'";
        }
        if ($clientes != "") {
            if (strtolower(DB::connection()->getDatabaseName()) == "kyocera") {
                $nid_tracker = DB::table('instalacions')
                    ->select('nID_Tracker')
                    ->where('sCliente', '=', $clientes)
                    ->orderby('id', 'ASC')
                    ->get();

                $where = $where . " and instalacions.nID_Tracker = " . "'" . $nid_tracker[0]->nID_Tracker . "'";
            } else {
                $where = $where . " and instalacions.sCliente = " . "'" . $request->clientes . "'";
            }
        }
        if ($region != "") {
            $where = $where . " and  instalacions.sRegion  = " . "'" . $region . "'";
        }
        if ($comuna != "") {
            $where = $where . " and  instalacions.sComuna  = " . "'" . $comuna . "'";
        }
        if ($serie != "") {
            $where = $where . " and  instalacions.sSerie  = " . "'" . $serie . "'";
        }
        if ($sc != "") {
            $where = $where . " and  instalacions.sSC  = " . "'" . $sc . "'";
        }
        //return $where;
        if ($id_persona != "") {


            $id_trabajador =  DB::table('trabajadors')
                ->select('trabajadors.id')
                ->where('trabajadors.id_persona', '=', $id_persona)
                ->get();

            $id_tra =  $id_trabajador[0]->id;

            $where = $where . " and  asignacion_instalacions.trabajadors_id  = " . "'" . $id_tra . "'";

            $instalaciones = DB::select('SELECT
                personas.nombre_uno,
                personas.apellido_uno,
                proyectos.nombre,
                checklist_instalacions.observacion,
                instalacions.sEstado_instalacion,
                instalacions.fecha_instalacion_coordinadora,
                instalacions.id,
                instalacions.dFecha_instalacion,
                instalacions.fecha_registrado,
                instalacions.sEstado_despacho,
                instalacions.Csserie_remplazo as remplazo,
                instalacions.sCliente,
                instalacions.sRegion,
                instalacions.sComuna,
                instalacions.sSerie,
                instalacions.idSala,
                instalacions.sTipo_sucursal,

                instalacions.sDireccion,
                instalacions.sModelo
            FROM
                instalacions
            INNER JOIN
                tracker
            ON
                tracker.id = instalacions.tracker_idtracker
            INNER JOIN
                proyectos
            ON
                proyectos.id = tracker.proyecto_id
            LEFT JOIN
                asignacion_instalacions
            ON
                instalacions.id = asignacion_instalacions.lista_instalacion_id
            LEFT JOIN
                checklist_instalacions
            ON
                checklist_instalacions.asignacion_instalacion_retiro_id = asignacion_instalacions.id
            LEFT JOIN
                trabajadors
            ON
                asignacion_instalacions.trabajadors_id = trabajadors.id
            LEFT JOIN
                personas
            ON
                trabajadors.id_persona = personas.id
            WHERE ' . $where . " group by  instalacions.sSerie order by instalacions.dFecha_instalacion asc ");
        } else {

            $instalaciones = DB::select('SELECT
                personas.nombre_uno,
                personas.apellido_uno,
                proyectos.nombre,
                checklist_instalacions.observacion,
                instalacions.sEstado_instalacion,
                instalacions.fecha_instalacion_coordinadora,
                instalacions.id,
                instalacions.dFecha_instalacion,
                instalacions.fecha_registrado,
                instalacions.sEstado_despacho,
                instalacions.Csserie_remplazo as remplazo,
                instalacions.sCliente,
                instalacions.sRegion,
                instalacions.sComuna,
                instalacions.sSerie,
                instalacions.idSala,
                instalacions.sTipo_sucursal,

                

                instalacions.sDireccion,
                instalacions.sModelo
            FROM
                instalacions
            INNER JOIN
                tracker
            ON
                tracker.id = instalacions.tracker_idtracker
            INNER JOIN
                proyectos
            ON
                proyectos.id = tracker.proyecto_id
            LEFT JOIN
                asignacion_instalacions
            ON
                instalacions.id = asignacion_instalacions.lista_instalacion_id
            LEFT JOIN
                checklist_instalacions
            ON
                checklist_instalacions.asignacion_instalacion_retiro_id = asignacion_instalacions.id
            LEFT JOIN
                trabajadors
            ON
                asignacion_instalacions.trabajadors_id = trabajadors.id
            LEFT JOIN
                personas
            ON
                trabajadors.id_persona = personas.id
            WHERE ' . $where . " group by  instalacions.sSerie order by instalacions.dFecha_instalacion asc ");
        }

        return view('check.excel.excel_instalacioncordinadora', compact('instalaciones'));
    }


    public function filtros_instalacionExport_old(request $request)
    {



        $id_persona = $request->tecnicos;
        $estado = $request->estado;
        $clientes = $request->clientes;
        $comuna = $request->comuna;
        $serie = $request->serie;
        $sc = $request->sc;

        if ($id_persona == "" &&  $estado == "" &&  $clientes == ""  &&  $comuna == ""  && $serie == "" &&  $sc == "" &&  $request->datepicker == "" && $request->datepicker2 == "") {

            // $instalaciones = DB::select('select instalacions.id, instalacions.dFecha_instalacion,instalacions.fecha_registrado, instalacions.sEstado_despacho, 
            // instalacions.sCliente, instalacions.sComuna, instalacions.sSerie,instalacions.sDireccion,instalacions.fecha_registrado,instalacions.sEstado_instalacion,instalacions.fecha_instalacion_coordinadora,personas.nombre_uno, personas.apellido_uno, proyectos.nombre  from personas inner join trabajadors on personas.id = trabajadors.id_persona
            // inner join users on trabajadors.id_login = users.id inner join asignacion_instalacions on trabajadors.id  =  asignacion_instalacions.trabajadors_id
            // inner join instalacions on instalacions.id = (SELECT MAX(asignacion_instalacions.id) FROM asignacion_instalacions WHERE asignacion_instalacions.lista_instalacion_id = instalacions.id)  inner join  tracker on tracker.id = instalacions.tracker_idtracker
            // inner join proyectos on proyectos.id =tracker.proyecto_id'
            // );
            //     $instalaciones = DB::select('SELECT
            //     instalacions.id,
            //     instalacions.dFecha_instalacion,
            //     instalacions.fecha_registrado,
            //     instalacions.sEstado_despacho,

            //     instalacions.sCliente,
            //     instalacions.sComuna,
            //     instalacions.sSerie,
            //     instalacions.sDireccion,
            //     instalacions.fecha_registrado,
            //     instalacions.sEstado_instalacion,
            //     instalacions.fecha_instalacion_coordinadora

            //     FROM

            //         instalacions
            //  ');

            $instalaciones = DB::select(
                'select instalacions.id, instalacions.dFecha_instalacion,instalacions.fecha_registrado, instalacions.sEstado_despacho, 
        instalacions.sCliente, instalacions.sComuna, instalacions.sSerie,instalacions.sDireccion,instalacions.fecha_registrado,instalacions.sEstado_instalacion,instalacions.fecha_instalacion_coordinadora,personas.nombre_uno, personas.apellido_uno, proyectos.nombre  
        from personas inner join trabajadors on personas.id = trabajadors.id_persona
        inner join users on trabajadors.id_login = users.id inner join asignacion_instalacions on trabajadors.id  =  asignacion_instalacions.trabajadors_id
        inner join instalacions on instalacions.id = asignacion_instalacions.lista_instalacion_id inner join  tracker on tracker.id = instalacions.tracker_idtracker
        inner join proyectos on proyectos.id =tracker.proyecto_id  group by  instalacions.sSerie'
            );

            return view('check.excel.excel_instalacioncordinadora', compact('instalaciones'));
        }

        // ******

        /*  $usuario_empresas = 0; */

        //    $datos_trabajador = DB::table('trabajadors')        
        //    ->where('trabajadors.id_login','=',Auth::user()->id)
        //    ->get();
        //    $id_trabajador = $datos_trabajador[0]->id;

        $where  = "instalacions.sEstado_despacho != " . "'" . "estoesparapasarlosdemasparametros" . "'";

        if ($request->datepicker != "" && $request->datepicker2 != "") {
            $fecha = Carbon::createFromDate($request->datepicker)->format('Y-m-d');
            $fecha2 = Carbon::createFromDate($request->datepicker2)->format('Y-m-d');
            $where = $where . " and instalacions.fecha_instalacion_coordinadora" . " BETWEEN " . "'" . $fecha . "'" . " and " . "'" . $fecha2 . "'";
        }
        if ($estado != "") {
            $where = $where . " and instalacions.sEstado_instalacion" . " = " . "'" . $estado . "'";
        }
        if ($clientes != "") {
            $where = $where . " and instalacions.sCliente = " . "'" . $clientes . "'";
        }
        if ($comuna != "") {
            $where = $where . " and  instalacions.sComuna  = " . "'" . $comuna . "'";
        }

        if ($serie != "") {
            $where = $where . " and  instalacions.sSerie  = " . "'" . $serie . "'";
        }
        if ($sc != "") {
            $where = $where . " and  instalacions.sSC  = " . "'" . $sc . "'";
        }

        if ($id_persona != "") {


            $id_trabajador =  DB::table('trabajadors')
                ->select('trabajadors.id')
                ->where('trabajadors.id_persona', '=', $id_persona)
                ->get();

            $id_tra =  $id_trabajador[0]->id;

            $where = $where . " and  asignacion_instalacions.trabajadors_id  = " . "'" . $id_tra . "'";

            $instalaciones = DB::select('SELECT
    instalacions.sEstado_instalacion,
    instalacions.fecha_instalacion_coordinadora,
    instalacions.id,
    instalacions.dFecha_instalacion,
    instalacions.fecha_registrado,
    instalacions.sEstado_despacho,
    instalacions.sCliente,
    instalacions.sComuna,
    instalacions.sSerie,
    instalacions.sDireccion,
    personas.nombre_uno,
    personas.apellido_uno,
    proyectos.nombre,
    checklist_instalacions.observacion
FROM
    personas
INNER JOIN
    trabajadors
ON
    personas.id = trabajadors.id_persona
INNER JOIN
    users
ON
    trabajadors.id_login = users.id
INNER JOIN
    asignacion_instalacions
ON
    trabajadors.id = asignacion_instalacions.trabajadors_id
INNER JOIN
    instalacions
ON
    instalacions.id = asignacion_instalacions.lista_instalacion_id
INNER JOIN
    tracker
ON
    tracker.id = instalacions.tracker_idtracker
INNER JOIN
    proyectos
ON
    proyectos.id = tracker.proyecto_id

INNER JOIN
    checklist_instalacions
ON
    checklist_instalacions.asignacion_instalacion_retiro_id = asignacion_instalacions.id  where ' . $where . " group by  instalacions.sSerie order by instalacions.dFecha_instalacion asc ");
        } else {

            $instalaciones = DB::select('SELECT
    personas.nombre_uno,
    personas.apellido_uno,
    proyectos.nombre,
    checklist_instalacions.observacion,
    instalacions.sEstado_instalacion,
    instalacions.fecha_instalacion_coordinadora,
    instalacions.id,
    instalacions.dFecha_instalacion,
    instalacions.fecha_registrado,
    instalacions.sEstado_despacho,
    instalacions.sCliente,
    instalacions.sComuna,
    instalacions.sSerie,
    instalacions.sDireccion
FROM
    personas
INNER JOIN
    trabajadors
ON
    personas.id = trabajadors.id_persona
INNER JOIN
    users
ON
    trabajadors.id_login = users.id
INNER JOIN
    asignacion_instalacions
ON
    trabajadors.id = asignacion_instalacions.trabajadors_id
INNER JOIN
    instalacions
ON
    instalacions.id = asignacion_instalacions.lista_instalacion_id
INNER JOIN
    tracker
ON
    tracker.id = instalacions.tracker_idtracker
INNER JOIN
    proyectos
ON
    proyectos.id = tracker.proyecto_id

INNER JOIN
    checklist_instalacions
ON
    checklist_instalacions.asignacion_instalacion_retiro_id = asignacion_instalacions.id where ' . $where . " group by  instalacions.sSerie order by instalacions.dFecha_instalacion asc ");
        }

        return view('check.excel.excel_instalacioncordinadora', compact('instalaciones'));
    }


    public function excel_coordinadora_instalacion($url)
    {

        try {
            $url = Crypt::decryptString($url);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }

        $buscando = strpos($url, "/filtros_instalacion?");

        if ($buscando === false) {
            // $resultado = "http://35.232.42.155/aya/rendicion/filtros_instalacionexport";
            $resultado = str_replace("/ver_api_instalaciones?", "/filtros_instalacionexport?", $url);

            //  return "sinfiiltro";
        } else {
            $resultado = str_replace("/filtros_instalacion?", "/filtros_instalacionexport?", $url);
            //  return "confiltro";

        }



        return redirect($resultado);



        //     $instalaciones = DB::select('SELECT
        //     instalacions.id,
        //     instalacions.dFecha_instalacion,
        //     instalacions.fecha_registrado,
        //     instalacions.sEstado_despacho,

        //     instalacions.sCliente,
        //     instalacions.sComuna,
        //     instalacions.sSerie,
        //     instalacions.sDireccion,
        //     instalacions.fecha_registrado,
        //     instalacions.sEstado_instalacion,
        //     instalacions.fecha_instalacion_coordinadora,
        //     personas.nombre_uno,
        //     personas.apellido_uno,
        //     proyectos.nombre,
        //     checklist_instalacions.observacion
        // FROM
        //     personas
        // INNER JOIN
        //     trabajadors
        // ON
        //     personas.id = trabajadors.id_persona
        // INNER JOIN
        //     users
        // ON
        //     trabajadors.id_login = users.id
        // INNER JOIN
        //     asignacion_instalacions
        // ON
        //     trabajadors.id = asignacion_instalacions.trabajadors_id
        // INNER JOIN
        //     instalacions
        // ON
        //     instalacions.id = asignacion_instalacions.lista_instalacion_id
        // INNER JOIN
        //     tracker
        // ON
        //     tracker.id = instalacions.tracker_idtracker
        // INNER JOIN
        //     proyectos
        // ON
        //     proyectos.id = tracker.proyecto_id
        // inner JOIN  checklist_instalacions on checklist_instalacions.asignacion_instalacion_retiro_id = asignacion_instalacions.id group by  instalacions.sSerie'
        //     );

        //     // $instalaciones = DB::select('select instalacions.id, instalacions.dFecha_instalacion,instalacions.fecha_registrado, instalacions.sEstado_despacho, 
        //     // instalacions.sCliente, instalacions.sComuna, instalacions.sSerie,instalacions.sDireccion,instalacions.fecha_registrado,instalacions.sEstado_instalacion,instalacions.fecha_instalacion_coordinadora,personas.nombre_uno, personas.apellido_uno, proyectos.nombre  from personas inner join trabajadors on personas.id = trabajadors.id_persona
        //     // inner join users on trabajadors.id_login = users.id inner join asignacion_instalacions on trabajadors.id  =  asignacion_instalacions.trabajadors_id
        //     // inner join instalacions on instalacions.id = (SELECT MAX(asignacion_instalacions.id) FROM asignacion_instalacions WHERE asignacion_instalacions.lista_instalacion_id = instalacions.id)  inner join  tracker on tracker.id = instalacions.tracker_idtracker
        //     // inner join proyectos on proyectos.id =tracker.proyecto_id'
        //     // );

        //     return view('check.excel.excel_instalacioncordinadora',compact('instalaciones'));

        //     return $instalaciones;

        //     $instalaciones =  DB::table('instalacions')
        //         ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
        //         ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
        //         ->select('instalacions.id', 'instalacions.dFecha_instalacion','instalacions.fecha_registrado', 'instalacions.sEstado_despacho', 
        //         'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sSerie','instalacions.sDireccion','instalacions.fecha_registrado','instalacions.sEstado_instalacion','instalacions.fecha_instalacion_coordinadora')
        //       //  ->where("instalacions.sEstado_despacho","<>","asignado")
        //         ->orderBy('instalacions.fecha_registrado', 'desc')
        //         ->orderBy('instalacions.sComuna', 'desc')
        //         ->get();

        //     return view('check.excel.excel_instalacioncordinadora',compact('instalaciones'));

    }

    //funcioes para las finalizaciones manuales
    public function finaliza_manual($id_asignacion_)
    {

        try {
            $id_asignacion = Crypt::decryptString($id_asignacion_);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }

        $datos_trabajador = DB::table('asignacion_instalacions')
            ->select('trabajadors_id')
            ->where("id", "=", $id_asignacion)
            ->get();

        $id_trabajador =  $datos_trabajador[0]->trabajadors_id;

        $datos_asignacion = DB::table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscliente',
                'asignacion_instalacions.estado_asignacion',
                'asignacion_instalacions.fecha_instalacion',
                'asignacion_instalacions.id',
                'asignacion_instalacions.numero_visita',
                'asignacion_instalacions.tipos_visitas_id',
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscomuna',
                'checklist_instalacions.Cscui',
                'checklist_instalacions.Cspiso',
                'checklist_instalacions.Csregion',
                'checklist_instalacions.Cnfolio',
                'checklist_instalacions.CsSerie',
                'checklist_instalacions.CsModelo',
                'checklist_instalacions.CUsb_red',
                'checklist_instalacions.CDriver',
                'checklist_instalacions.Cscontacto',
                'checklist_instalacions.CsSC',
                'asignacion_instalacions.lista_instalacion_id as id_instalacion',
                'checklist_instalacions.CsIP',
                'checklist_instalacions.CsGateway',
                'checklist_instalacions.CsMsk',
                'checklist_instalacions.CnContador',
                'checklist_instalacions.CnContador_color',
                'checklist_instalacions.id as id_checklist',
                'checklist_instalacions.estado_inicio',
                'personas.nombre_uno as nombrepersona',
                'personas.nombre_dos as nombrepe',
                'asignacion_instalacions.motivo_rechazado',
                'checklist_instalacions.url_firma',
                'asignacion_instalacions.tipos_visitas_id',
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscomuna',
                'checklist_instalacions.CsSerie_es',
                'checklist_instalacions.CsModelo_es',
                'checklist_instalacions.CsContador_es',
                'checklist_instalacions.CsContadorcolor_es',
                'checklist_instalacions.CsKit_lector',
                'checklist_instalacions.Csconexion_electrica',
                'checklist_instalacions.Cscantidad_usuarios',
                'checklist_instalacions.CsCable_poder',
                'checklist_instalacions.Csservidor_impresion',
                'checklist_instalacions.CsSD',
                'checklist_instalacions.ins_driver',
                'checklist_instalacions.equipo_operativo',
                'checklist_instalacions.CsObservacion',
                'checklist_instalacions.Cscontacto',
                'checklist_instalacions.modo_U253',
                'checklist_instalacions.Csconfig_smb',
                'checklist_instalacions.CsBandeja_adicional',
                'checklist_instalacions.Cstipo_conexion',
                'checklist_instalacions.motivo',
                'checklist_instalacions.CsCable_red',
                'checklist_instalacions.nombre_servidores_id',
                'checklist_instalacions.tipo_conexiones_id',
                'checklist_instalacions.tipo_equipo',
                'checklist_instalacions.softwares_id',
                'checklist_instalacions.Csn_contacto',
                'checklist_instalacions.Csconfig_email',
                'checklist_instalacions.idSala',

            )
            ->where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_instalacions.id', '=', $id_asignacion)
            ->orderBy('asignacion_instalacions.id', 'desc')
            ->get();

        $cantidad_fotos = App\fotos_check_instalacions::where('checklist_instalacion_id', $datos_asignacion[0]->id_checklist)->count();



        if ($datos_asignacion[0]->motivo_rechazado == "" || $datos_asignacion[0]->motivo_rechazado == null) {
            $accion = "1";   //iniciar
        } else {
            $accion = "2"; // completas rechazado
        }

        //encontramos el nombre del proyecto asociado al checklist de instalacion
        $id_instalacion = $datos_asignacion[0]->id_instalacion;
        $proyecto_asociado = DB::table('instalacions')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            // ->select('proyectos.nombre', 'clientes.razon_social')
            ->select('proyectos.nombre', 'clientes.razon_social','proveedor_instalacion')

            ->where('instalacions.id', '=', $id_instalacion)
            ->get();

        // return $proyecto_asociado;clientes_id


        $softwares = DB::table('softwares')
            ->where('softwares.estado', '=', "activo")
            ////->where('softwares.id','!=',1)
            ->get();


        $servidores = DB::table('nombre_servidores')
            ->where('nombre_servidores.estado', '=', "activo")
            ////->where('nombre_servidores.id','!=',1)
            ->get();


        $tipo_conexion = DB::table('tipo_conexiones')
            ->where('tipo_conexiones.estado', '=', "activo")
            // //->where('tipo_conexiones.id','!=',1)
            ->get();

        //$estado = ;
        $estado = collect(['Finalizar', 'Pendiente', 'Cancelar']);

        $detalle = collect(['Ubicacion provisoria', 'Habilitacion de credenciales', 'Continua usando equipo anterior', 'Equipo operativo', 'Configurado, pendiente Capacitacion']);

        // $detalle_ = [
        //     ['name' => 'Taylor',  'coffee_drinker' => true],
        //     ['name' => 'Matt', 'coffee_drinker' => true]
        // ];

        // $detalle = collect($detalle_);



        $tipo_visita = App\tipos_visitas::findOrfail($datos_asignacion[0]->tipos_visitas_id);
        $manual = "si";

        return view('check.iniciar_checklist', compact('manual', 'cantidad_fotos', 'datos_asignacion', 'tipo_visita', 'proyecto_asociado', 'softwares', 'servidores', 'tipo_conexion', 'accion', 'estado', 'detalle'));
    }



    //exportar todo los checklist de las intalaciones
    public function instalacionchecklistExport($clienteseleccionado)
    {

        $instalaciones = DB::select('select
        checklist_instalacions.CnContador,
        checklist_instalacions.CsIP,
        checklist_instalacions.CnContador_color,
        checklist_instalacions.CsModelo,
        checklist_instalacions.CsModelo_es,
        checklist_instalacions.CsSerie_es,
        checklist_instalacions.CsMarca_es,
        checklist_instalacions.Cstipo_sucursal,
        checklist_instalacions.Cscantidad_usuarios,
        checklist_instalacions.observacion,
        checklist_instalacions.id as id_checklist,
        asignacion_instalacions.estado_asignacion,
        asignacion_instalacions.opcion_estado_instalacion,
        asignacion_instalacions.id as id_asig,
        instalacions.id,
        instalacions.dFecha_instalacion,
        instalacions.fecha_registrado,
        instalacions.sEstado_despacho,
        asignacion_instalacions.fecha_termino,
        asignacion_instalacions.fecha_instalacion,
        instalacions.sCliente,
        instalacions.sRegion,
        instalacions.sComuna,
        instalacions.sSerie,
        instalacions.Csserie_remplazo as remplazo,
        instalacions.sDireccion,
        instalacions.fecha_registrado,
        instalacions.sEstado_instalacion,
        instalacions.fecha_instalacion_coordinadora,
        instalacions.idSala,

        personas.nombre_uno,
        personas.apellido_uno,
        proyectos.nombre
    from personas 
    inner join trabajadors on personas.id = trabajadors.id_persona
    inner join users on trabajadors.id_login = users.id
    inner join asignacion_instalacions on trabajadors.id  =  asignacion_instalacions.trabajadors_id
    inner join checklist_instalacions on  checklist_instalacions.asignacion_instalacion_retiro_id = asignacion_instalacions.id
    inner join instalacions on instalacions.id = asignacion_instalacions.lista_instalacion_id 
    inner join tracker on tracker.id = instalacions.tracker_idtracker
    inner join proyectos on proyectos.id =tracker.proyecto_id
    where instalacions.sCliente =' . " '$clienteseleccionado '" . "" . '
    order by asignacion_instalacions.fecha_instalacion DESC');

        return view('check.excel.excel_instalacioncheckcordinadora', compact('instalaciones'));
    }

    public function cambiarcontadorbn(request $request)
    {

        $id = $request->id_check;
        $contadorbn = $request->contadorbn;

        $asignacion_instalacions =  App\asignacion_instalacions::findOrfail($id);

        $checklist_instalacions = App\checklist_instalacions::where('asignacion_instalacion_retiro_id', $asignacion_instalacions->id)->firstOrFail();
        $checklist_instalacions->CnContador = $contadorbn;
        $checklist_instalacions->timestamps = false;
        $checklist_instalacions->save();

        $instalacion = App\instalacions::findOrfail($asignacion_instalacions->lista_instalacion_id);
        $instalacion->nContador = $contadorbn;
        $instalacion->timestamps = false;
        $instalacion->save();

        return $contadorbn;
    }

    public function cambiarcontadorcolor(request $request)
    {

        $id = $request->id_check;
        $contadorcolor = $request->contadorcolor;

        $asignacion_instalacions =  App\asignacion_instalacions::findOrfail($id);

        $checklist_instalacions = App\checklist_instalacions::where('asignacion_instalacion_retiro_id', $asignacion_instalacions->id)->firstOrFail();
        $checklist_instalacions->CnContador_color = $contadorcolor;
        $checklist_instalacions->timestamps = false;
        $checklist_instalacions->save();

        $instalacion = App\instalacions::findOrfail($asignacion_instalacions->lista_instalacion_id);
        $instalacion->nContador_color = $contadorcolor;
        $instalacion->timestamps = false;
        $instalacion->save();

        return $contadorcolor;
    }

    public function cambiardedireccion(request $request)
    {


        $id = $request->id_check;
        $direccion = $request->direccion;

        $asignacion_instalacions =  App\asignacion_instalacions::findOrfail($id);

        $checklist_instalacions = App\checklist_instalacions::where('asignacion_instalacion_retiro_id', $asignacion_instalacions->id)->firstOrFail();
        $checklist_instalacions->Csdireccion = $direccion;
        $checklist_instalacions->timestamps = false;
        $checklist_instalacions->save();

        $instalacion = App\instalacions::findOrfail($asignacion_instalacions->lista_instalacion_id);
        $instalacion->sDireccion = $direccion;
        $instalacion->timestamps = false;
        $instalacion->save();

        return $direccion;
    }

    public function cambiardedireccion_retiro(request $request)
    {

        $id = $request->id_check;
        $direccion = $request->direccion;

        $asignacion_retiros =  App\asignacion_retiros::findOrfail($id);

        $checklist_retiro = App\checklist_retiros::where('asignacion_retiros_id', $asignacion_retiros->id)->firstOrFail();
        $checklist_retiro->csDireccion = $direccion;
        $checklist_retiro->timestamps = false;
        $checklist_retiro->save();

        $retiros = App\retiros::where('sSerie', '=', $checklist_retiro->csSerie)->firstOrFail();
        $retiros->sDireccion = $direccion;
        $retiros->timestamps = false;
        $retiros->save();

        return $direccion;
    }

    public function cambiarcontadorbn_retiro(request $request)
    {


        $id = $request->id_check;
        $contadorbn = $request->contadorbn;

        $asignacion_retiros =  App\asignacion_retiros::findOrfail($id);

        $checklist_retiro = App\checklist_retiros::where('asignacion_retiros_id', $asignacion_retiros->id)->firstOrFail();
        $checklist_retiro->cnContador = $contadorbn;
        $checklist_retiro->timestamps = false;
        $checklist_retiro->save();

        $retiros = App\retiros::where('sSerie', '=', $checklist_retiro->csSerie)->firstOrFail();
        $retiros->nContador = $contadorbn;
        $retiros->timestamps = false;
        $retiros->save();

        return $contadorbn;
    }

    public function cambiarcontadorcolor_retiro(request $request)
    {


        $id = $request->id_check;
        $contadorcolor = $request->contadorcolor;

        $asignacion_retiros =  App\asignacion_retiros::findOrfail($id);

        $checklist_retiro = App\checklist_retiros::where('asignacion_retiros_id', $asignacion_retiros->id)->firstOrFail();
        $checklist_retiro->cnContador_color = $contadorcolor;
        $checklist_retiro->timestamps = false;
        $checklist_retiro->save();

        $retiros = App\retiros::where('sSerie', '=', $checklist_retiro->csSerie)->firstOrFail();
        $retiros->nContador_color = $contadorcolor;
        $retiros->timestamps = false;
        $retiros->save();

        return $contadorcolor;
    }

    public function cambiardecomuna(request $request)
    {

        $id = $request->id_check;
        $comuna = $request->comuna;

        $asignacion_instalacions = App\asignacion_instalacions::findOrfail($id);

        $checklist_instalacions = App\checklist_instalacions::where('asignacion_instalacion_retiro_id', $asignacion_instalacions->id)->firstOrFail();
        $checklist_instalacions->Cscomuna = $comuna;
        $checklist_instalacions->timestamps = false;
        $checklist_instalacions->save();

        return $comuna;
    }

    public function cambiardecomuna_retiro(request $request)
    {

        $id = $request->id_check;
        $comuna = $request->comuna;

        $asignacion_retiros = App\asignacion_retiros::findOrfail($id);

        $checklist_retiro = App\checklist_retiros::where('asignacion_retiros_id', $asignacion_retiros->id)->firstOrFail();
        $checklist_retiro->Cscomuna = $comuna;
        $checklist_retiro->timestamps = false;
        $checklist_retiro->save();

        $retiros = App\retiros::where('sSerie', '=', $checklist_retiro->csSerie)->firstOrFail();
        $retiros->sComuna = $comuna;
        $retiros->timestamps = false;
        $retiros->save();

        return $comuna;
    }

    public function cambiarderegion(request $request)
    {
        $id = $request->id_check;
        $region = $request->region;

        $asignacion_instalacions = App\asignacion_instalacions::findOrfail($id);

        $checklist_instalacions = App\checklist_instalacions::where('asignacion_instalacion_retiro_id', $asignacion_instalacions->id)->firstOrFail();
        $checklist_instalacions->Csregion = $region;
        $checklist_instalacions->timestamps = false;
        $checklist_instalacions->save();

        return $region;
    }

    public function cambiardecontacto(request $request)
    {
        $id = $request->id_check;
        $contacto = $request->contacto;

        $asignacion_instalacions = App\asignacion_instalacions::findOrfail($id);

        $checklist_instalacions = App\checklist_instalacions::where('asignacion_instalacion_retiro_id', $asignacion_instalacions->id)->firstOrFail();
        $checklist_instalacions->Cscontacto = $contacto;
        $checklist_instalacions->timestamps = false;
        $checklist_instalacions->save();

        return $contacto;
    }

    public function cambiardecui(request $request)
    {
        $id = $request->id_check;
        $cui = $request->cui;

        $asignacion_instalacions = App\asignacion_instalacions::findOrfail($id);

        $checklist_instalacions = App\checklist_instalacions::where('asignacion_instalacion_retiro_id', $asignacion_instalacions->id)->firstOrFail();
        $checklist_instalacions->Cscui = $cui;
        $checklist_instalacions->timestamps = false;
        $checklist_instalacions->save();

        return $cui;
    }

    public function cambiardeserie(request $request)
    {

        $id = $request->id_check;
        $serie = $request->serie;

        $asignacion_instalacions = App\asignacion_instalacions::findOrfail($id);

        $checklist_instalacions = App\checklist_instalacions::where('asignacion_instalacion_retiro_id', $asignacion_instalacions->id)->firstOrFail();
        $checklist_instalacions->CsSerie = $serie;
        $checklist_instalacions->timestamps = false;
        $checklist_instalacions->save();

        $instalacion = App\instalacions::findOrfail($asignacion_instalacions->lista_instalacion_id);
        $instalacion->sSerie = $serie;
        $instalacion->timestamps = false;
        $instalacion->save();

        return $serie;
    }
    public function cambiodeserieasignar(request $request)
    {

        $id = $request->id_check;
        $serie = $request->serie;


        $instalacion = App\instalacions::findOrfail($id);
        $instalacion->sSerie = $serie;
        $instalacion->timestamps = false;
        $instalacion->save();

        return $serie;
    }
    public function cambiodemodeloasignar(request $request)
    {

        $id = $request->id_check;
        $serie = $request->serie;


        $instalacion = App\instalacions::findOrfail($id);
        $instalacion->sModelo = $serie;
        $instalacion->timestamps = false;
        $instalacion->save();

        return $serie;
    }
    public function cambiardeserieremplazo(request $request)
    {
        $id = $request->id_check;
        $serie_remplazo = $request->serie_remplazo;

        $asignacion_instalacions = App\asignacion_instalacions::findOrfail($id);

        $checklist_instalacions = App\checklist_instalacions::where('asignacion_instalacion_retiro_id', $asignacion_instalacions->id)->firstOrFail();
        $checklist_instalacions->Csserie_remplazo = $serie_remplazo;
        $checklist_instalacions->timestamps = false;
        $checklist_instalacions->save();

        $instalacion = App\instalacions::findOrfail($asignacion_instalacions->lista_instalacion_id);
        $instalacion->Csserie_remplazo = $serie_remplazo;
        $instalacion->timestamps = false;
        $instalacion->save();

        return $serie_remplazo;
    }
    public function cambiardecontadorbn(request $request)
    {
        $id = $request->id_check;
        $contadorbn = $request->contadorbn;

        $asignacion_instalacions = App\asignacion_instalacions::findOrfail($id);

        $checklist_instalacions = App\checklist_instalacions::where('asignacion_instalacion_retiro_id', $asignacion_instalacions->id)->firstOrFail();
        $checklist_instalacions->CnContador = $contadorbn;
        $checklist_instalacions->timestamps = false;
        $checklist_instalacions->save();

        return $contadorbn;
    }
    public function cambiardecontadorcc(request $request)
    {
        $id = $request->id_check;
        $contadorcolor = $request->contadorcolor;

        $asignacion_instalacions = App\asignacion_instalacions::findOrfail($id);

        $checklist_instalacions = App\checklist_instalacions::where('asignacion_instalacion_retiro_id', $asignacion_instalacions->id)->firstOrFail();
        $checklist_instalacions->CnContador_color = $contadorcolor;
        $checklist_instalacions->timestamps = false;
        $checklist_instalacions->save();


        return $contadorcolor;
    }
    public function cambiardeobservacion(request $request)
    {
        $id = $request->id_check;
        $observacion = $request->observacion;

        $asignacion_instalacions = App\asignacion_instalacions::findOrfail($id);

        $checklist_instalacions = App\checklist_instalacions::where('asignacion_instalacion_retiro_id', $asignacion_instalacions->id)->firstOrFail();
        $checklist_instalacions->CsObservacion = $observacion;
        $checklist_instalacions->timestamps = false;
        $checklist_instalacions->save();


        return $observacion;
    }
    public function buscar_accesorios(request $request)
    {

        $id = $request->id;
        $descripcion = $request->descripcion;
        $articulo = $request->articulo;
        $opciones = $request->opciones;
        $where = "";

        if (!empty($opciones)) {

            $where .= ' AND accesorios.descripcion LIKE' . '"%' . $descripcion . '%"';
            $where .= ' OR accesorios.articulo LIKE' . '"%' . $articulo . '%"';
        } else {

            if ($id != "") {
                $where .= ' AND accesorios.id LIKE ' . '"%' . $id . '%"';
            }
            if ($descripcion != "") {
                $where .= ' AND accesorios.descripcion LIKE' . '"%' . $descripcion . '%"';
            }
            if ($articulo != "") {
                $where .= ' AND accesorios.articulo LIKE' . '"%' . $articulo . '%"';
            }
        }


        if ($where != "") {
            $accesorios = DB::select('select
            accesorios.id,
            accesorios.articulo,
            accesorios.descripcion
            from accesorios where accesorios.estado = 1' . $where);

            return $accesorios;
        }
    }
    public function buscar_accesorios___(request $request)
    {

        $id = $request->id;
        $descripcion = $request->descripcion;
        $articulo = $request->articulo;
        $where = "";

        if ($id != "") {
            $where .= ' AND accesorios.id LIKE ' . '"%' . $id . '%"';
        }
        if ($descripcion != "") {
            $where .= ' AND accesorios.descripcion LIKE' . '"%' . $descripcion . '%"';
        }
        if ($articulo != "") {
            $where .= ' AND accesorios.articulo LIKE' . '"%' . $articulo . '%"';
        }
        if ($where != "") {
            $accesorios = DB::select('select
            accesorios.id,
            accesorios.articulo,
            accesorios.descripcion
            from accesorios where accesorios.estado = 1' . $where);

            return $accesorios;
        }
    }

    public function agregar_accesorios(Request $request)
    {
        $id = $request->id;

        $accesorios = DB::table('accesorios')
            ->where('accesorios.id', '=', $id)
            ->get();

        return $accesorios;
    }

    public function inicio_accesorios()
    {

        $accesorios = DB::table('accesorios')
            ->get();

        return view('check.accesorios', compact('accesorios'));
    }
    public function editar_accesorios(Request $request)
    {


        $delete_accesorios = App\checklist_accesorios::where('id_checklist_instalacion', $request->id_check)->delete();
        $delete_accesorios_dañados = App\checklist_accesorios_dañados::where('id_checklist_instalacion', $request->id_check)->delete();

        if ($request->arreglo != null || $request->arreglo != "") {
            for ($i = 0; $i < count($request->arreglo); $i++) {
                if ($request->arreglo[$i] != "" || $request->arreglo[$i] != null) {
                    $agregar_accesorios = new App\checklist_accesorios;
                    $agregar_accesorios->id_checklist_instalacion = $request->id_check;
                    $agregar_accesorios->id_accesorio = $request->arreglo[$i];
                    $agregar_accesorios->serie_parte = $request->serie_parte[$i];
                    $agregar_accesorios->cantidad = $request->cantidad[$i];
                    $agregar_accesorios->timestamps = false;
                    $agregar_accesorios->save();
                }
            }
        }
        if ($request->arreglo2 != null || $request->arreglo2 != "") {
            for ($i = 0; $i < count($request->arreglo2); $i++) {
                if ($request->arreglo2[$i] != "" || $request->arreglo2[$i] != null) {
                    $agregar_accesorios = new App\checklist_accesorios_dañados;
                    $agregar_accesorios->id_checklist_instalacion = $request->id_check;
                    $agregar_accesorios->id_accesorio = $request->arreglo2[$i];
                    $agregar_accesorios->serie_parte = $request->serie_parte2[$i];
                    $agregar_accesorios->cantidad = $request->cantidad2[$i];
                    $agregar_accesorios->timestamps = false;
                    $agregar_accesorios->save();
                }
            }
        }
    }
    public function buscar_accesorios2(request $request)
    {

        $id = $request->id;
        $descripcion = $request->descripcion;
        $articulo = $request->articulo;
        $where = "";

        if ($id != "") {
            $where .= ' AND accesorios.id LIKE ' . '"%' . $id . '%"';
        }
        if ($descripcion != "") {
            $where .= ' AND accesorios.descripcion LIKE' . '"%' . $descripcion . '%"';
        }
        if ($articulo != "") {
            $where .= ' AND accesorios.articulo LIKE' . '"%' . $articulo . '%"';
        }
        $accesorios = DB::select('select
            accesorios.id,
            accesorios.articulo,
            accesorios.descripcion
            from accesorios where accesorios.estado = 1' . $where);

        return $accesorios;
    }

    public function save_imagen_accesorios(request $request)
    {
        $numeroRandom = rand();

        ////$deletedRows = App\fotos_checks_accesorios::where('checklist_instalacion_id', $request->check_list)->delete();
        //foto1
        if ($request->file('cargafotoa1') != "") {
            //$deletedRows = App\fotos_checks_accesorios::where('descripcion_foto','fa1_'.$request->check_list.'.jpeg')->delete();
            //$deletedRows = App\fotos_checks_accesorios::where('descripcion_foto','fa1_'.$request->check_list.'.jpg')->delete();
            //$deletedRows = App\fotos_checks_accesorios::where('descripcion_foto','fa1_'.$request->check_list.'.png')->delete();
            $file = $request->file('cargafotoa1');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            //sacamos la exxtencion por medio de _
            $extencionArray = explode("_", $extencion);
            $nombreGuardar1 = "fa1_" .$numeroRandom. $request->check_list . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("foto_instalaciones/" . $nombreGuardar1,  \File::get($file));

            $fotos_check_instalacions = new App\fotos_checks_accesorios;
            $fotos_check_instalacions->descripcion_foto  = $nombreGuardar1;
            $fotos_check_instalacions->url  = "foto_instalaciones/" . $nombreGuardar1;
            $fotos_check_instalacions->checklist_instalacion_id   = $request->check_list;
            $fotos_check_instalacions->timestamps = false;
            $fotos_check_instalacions->save();
        }
        //foto2
        if ($request->file('cargafotoa2') != "") {
            //$deletedRows = App\fotos_checks_accesorios::where('descripcion_foto', 'fa2_' . $request->check_list . '.jpeg')->delete();
            //$deletedRows = App\fotos_checks_accesorios::where('descripcion_foto', 'fa2_' . $request->check_list . '.jpg')->delete();
            //$deletedRows = App\fotos_checks_accesorios::where('descripcion_foto', 'fa2_' . $request->check_list . '.png')->delete();
            $file = $request->file('cargafotoa2');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            //sacamos la exxtencion por medio de _
            $extencionArray = explode("_", $extencion);
            $nombreGuardar1 = "fa2_".$numeroRandom . $request->check_list . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("foto_instalaciones/" . $nombreGuardar1,  \File::get($file));

            $fotos_check_instalacions = new App\fotos_checks_accesorios;
            $fotos_check_instalacions->descripcion_foto  = $nombreGuardar1;
            $fotos_check_instalacions->url  = "foto_instalaciones/" . $nombreGuardar1;
            $fotos_check_instalacions->checklist_instalacion_id   = $request->check_list;
            $fotos_check_instalacions->timestamps = false;
            $fotos_check_instalacions->save();
        }
        //foto3
        if ($request->file('cargafotoa3') != "") {
            //$deletedRows = App\fotos_checks_accesorios::where('descripcion_foto', 'fa3_' . $request->check_list . '.jpeg')->delete();
            //$deletedRows = App\fotos_checks_accesorios::where('descripcion_foto', 'fa3_' . $request->check_list . '.jpg')->delete();
            //$deletedRows = App\fotos_checks_accesorios::where('descripcion_foto', 'fa3_' . $request->check_list . '.png')->delete();
            $file = $request->file('cargafotoa3');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            //sacamos la exxtencion por medio de _
            $extencionArray = explode("_", $extencion);
            $nombreGuardar1 = "fa3_".$numeroRandom . $request->check_list . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("foto_instalaciones/" . $nombreGuardar1,  \File::get($file));

            $fotos_check_instalacions = new App\fotos_checks_accesorios;
            $fotos_check_instalacions->descripcion_foto  = $nombreGuardar1;
            $fotos_check_instalacions->url  = "foto_instalaciones/" . $nombreGuardar1;
            $fotos_check_instalacions->checklist_instalacion_id   = $request->check_list;
            $fotos_check_instalacions->timestamps = false;
            $fotos_check_instalacions->save();
        }
        //foto4
        if ($request->file('cargafotoa4') != "") {
            //$deletedRows = App\fotos_checks_accesorios::where('descripcion_foto', 'fa4_' . $request->check_list . '.jpeg')->delete();
            //$deletedRows = App\fotos_checks_accesorios::where('descripcion_foto', 'fa4_' . $request->check_list . '.jpg')->delete();
            //$deletedRows = App\fotos_checks_accesorios::where('descripcion_foto', 'fa4_' . $request->check_list . '.png')->delete();
            $file = $request->file('cargafotoa4');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            //sacamos la exxtencion por medio de _
            $extencionArray = explode("_", $extencion);
            $nombreGuardar1 = "fa4_" .$numeroRandom. $request->check_list . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("foto_instalaciones/" . $nombreGuardar1,  \File::get($file));

            $fotos_check_instalacions = new App\fotos_checks_accesorios;
            $fotos_check_instalacions->descripcion_foto  = $nombreGuardar1;
            $fotos_check_instalacions->url  = "foto_instalaciones/" . $nombreGuardar1;
            $fotos_check_instalacions->checklist_instalacion_id   = $request->check_list;
            $fotos_check_instalacions->timestamps = false;
            $fotos_check_instalacions->save();
        }
        //foto5
        if ($request->file('cargafotoa5') != "") {
            //$deletedRows = App\fotos_checks_accesorios::where('descripcion_foto', 'fa5_' . $request->check_list . '.jpeg')->delete();
            //$deletedRows = App\fotos_checks_accesorios::where('descripcion_foto', 'fa5_' . $request->check_list . '.jpg')->delete();
            //$deletedRows = App\fotos_checks_accesorios::where('descripcion_foto', 'fa5_' . $request->check_list . '.png')->delete();
            $file = $request->file('cargafotoa5');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            //sacamos la exxtencion por medio de _
            $extencionArray = explode("_", $extencion);
            $nombreGuardar1 = "fa5_".$numeroRandom . $request->check_list . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("foto_instalaciones/" . $nombreGuardar1,  \File::get($file));

            $fotos_check_instalacions = new App\fotos_checks_accesorios;
            $fotos_check_instalacions->descripcion_foto  = $nombreGuardar1;
            $fotos_check_instalacions->url  = "foto_instalaciones/" . $nombreGuardar1;
            $fotos_check_instalacions->checklist_instalacion_id   = $request->check_list;
            $fotos_check_instalacions->timestamps = false;
            $fotos_check_instalacions->save();
        }
        //foto6
        if ($request->file('cargafotoa6') != "") {
            //$deletedRows = App\fotos_checks_accesorios::where('descripcion_foto', 'fa6_' . $request->check_list . '.jpeg')->delete();
            //$deletedRows = App\fotos_checks_accesorios::where('descripcion_foto', 'fa6_' . $request->check_list . '.jpg')->delete();
            //$deletedRows = App\fotos_checks_accesorios::where('descripcion_foto', 'fa6_' . $request->check_list . '.png')->delete();
            $file = $request->file('cargafotoa6');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            //sacamos la exxtencion por medio de _
            $extencionArray = explode("_", $extencion);
            $nombreGuardar1 = "fa6_".$numeroRandom . $request->check_list . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("foto_instalaciones/" . $nombreGuardar1,  \File::get($file));

            $fotos_check_instalacions = new App\fotos_checks_accesorios;
            $fotos_check_instalacions->descripcion_foto  = $nombreGuardar1;
            $fotos_check_instalacions->url  = "foto_instalaciones/" . $nombreGuardar1;
            $fotos_check_instalacions->checklist_instalacion_id   = $request->check_list;
            $fotos_check_instalacions->timestamps = false;
            $fotos_check_instalacions->save();
        } //foto7
        if ($request->file('cargafotoa7') != "") {
            //$deletedRows = App\fotos_checks_accesorios::where('descripcion_foto', 'fa7_' . $request->check_list . '.jpeg')->delete();
            //$deletedRows = App\fotos_checks_accesorios::where('descripcion_foto', 'fa7_' . $request->check_list . '.jpg')->delete();
            //$deletedRows = App\fotos_checks_accesorios::where('descripcion_foto', 'fa7_' . $request->check_list . '.png')->delete();
            $file = $request->file('cargafotoa7');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            //sacamos la exxtencion por medio de _
            $extencionArray = explode("_", $extencion);
            $nombreGuardar1 = "fa7_".$numeroRandom . $request->check_list . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("foto_instalaciones/" . $nombreGuardar1,  \File::get($file));

            $fotos_check_instalacions = new App\fotos_checks_accesorios;
            $fotos_check_instalacions->descripcion_foto  = $nombreGuardar1;
            $fotos_check_instalacions->url  = "foto_instalaciones/" . $nombreGuardar1;
            $fotos_check_instalacions->checklist_instalacion_id   = $request->check_list;
            $fotos_check_instalacions->timestamps = false;
            $fotos_check_instalacions->save();
        }
        //foto8
        if ($request->file('cargafotoa8') != "") {
            //$deletedRows = App\fotos_checks_accesorios::where('descripcion_foto', 'fa8_' . $request->check_list . '.jpeg')->delete();
            //$deletedRows = App\fotos_checks_accesorios::where('descripcion_foto', 'fa8_' . $request->check_list . '.jpg')->delete();
            //$deletedRows = App\fotos_checks_accesorios::where('descripcion_foto', 'fa8_' . $request->check_list . '.png')->delete();
            $file = $request->file('cargafotoa8');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            //sacamos la exxtencion por medio de _
            $extencionArray = explode("_", $extencion);
            $nombreGuardar1 = "fa8_".$numeroRandom . $request->check_list . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("foto_instalaciones/" . $nombreGuardar1,  \File::get($file));

            $fotos_check_instalacions = new App\fotos_checks_accesorios;
            $fotos_check_instalacions->descripcion_foto  = $nombreGuardar1;
            $fotos_check_instalacions->url  = "foto_instalaciones/" . $nombreGuardar1;
            $fotos_check_instalacions->checklist_instalacion_id   = $request->check_list;
            $fotos_check_instalacions->timestamps = false;
            $fotos_check_instalacions->save();
        }
        //foto9
        if ($request->file('cargafotoa9') != "") {
            //$deletedRows = App\fotos_checks_accesorios::where('descripcion_foto', 'fa9_' . $request->check_list . '.jpeg')->delete();
            //$deletedRows = App\fotos_checks_accesorios::where('descripcion_foto', 'fa9_' . $request->check_list . '.jpg')->delete();
            //$deletedRows = App\fotos_checks_accesorios::where('descripcion_foto', 'fa9_' . $request->check_list . '.png')->delete();
            $file = $request->file('cargafotoa9');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            //sacamos la exxtencion por medio de _
            $extencionArray = explode("_", $extencion);
            $nombreGuardar1 = "fa9_".$numeroRandom . $request->check_list . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("foto_instalaciones/" . $nombreGuardar1,  \File::get($file));

            $fotos_check_instalacions = new App\fotos_checks_accesorios;
            $fotos_check_instalacions->descripcion_foto  = $nombreGuardar1;
            $fotos_check_instalacions->url  = "foto_instalaciones/" . $nombreGuardar1;
            $fotos_check_instalacions->checklist_instalacion_id   = $request->check_list;
            $fotos_check_instalacions->timestamps = false;
            $fotos_check_instalacions->save();
        }
        //foto10
        if ($request->file('cargafotoa10') != "") {
            //$deletedRows = App\fotos_checks_accesorios::where('descripcion_foto', 'fa10_' . $request->check_list . '.jpeg')->delete();
            //$deletedRows = App\fotos_checks_accesorios::where('descripcion_foto', 'fa10_' . $request->check_list . '.jpg')->delete();
            //$deletedRows = App\fotos_checks_accesorios::where('descripcion_foto', 'fa10_' . $request->check_list . '.png')->delete();
            $file = $request->file('cargafotoa10');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            //sacamos la exxtencion por medio de _
            $extencionArray = explode("_", $extencion);
            $nombreGuardar1 = "fa10_".$numeroRandom . $request->check_list . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("foto_instalaciones/" . $nombreGuardar1,  \File::get($file));

            $fotos_check_instalacions = new App\fotos_checks_accesorios;
            $fotos_check_instalacions->descripcion_foto  = $nombreGuardar1;
            $fotos_check_instalacions->url  = "foto_instalaciones/" . $nombreGuardar1;
            $fotos_check_instalacions->checklist_instalacion_id   = $request->check_list;
            $fotos_check_instalacions->timestamps = false;
            $fotos_check_instalacions->save();
        }

        return [
            'status' => 200,
            'msg' => 'ok'
        ];
    }
    public function asignar_check_home(request $request)
    {



        $id_instalacion = $request->id;
        $trabajadores = DB::table('personas')
            ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
            ->join('users', 'users.id', '=', 'trabajadors.id_login')
            ->where('trabajadors.estado', '=', '1')
            ->where('users.tipo_usuario', '=', 'trabajador')
            ->select('personas.nombre_uno', 'personas.apellido_uno', 'personas.apellido_dos', 'trabajadors.id')
            ->get();

        $tipos_visitas = DB::table('tipos_visitas')
            ->where('tipos_visitas.estado', '=', '1')
            ->select('tipos_visitas.descripcion', 'tipos_visitas.id')
            ->get();

        $proyectos = DB::table('proyectos')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->where('proyectos.estado', '=', '1')
            ->where('proyectos.id', '!=', '1')
            ->where('proyectos.nombre', '!=', 'SERVICIOS')
            ->select('proyectos.nombre', 'clientes.razon_social', 'proyectos.id as id_proyecto')
            ->get();

        $api_instalaciones = DB::table('instalacions')

            ->where('instalacions.id', '=', $id_instalacion)
            ->select(
                'instalacions.sCliente',
                'instalacions.dFecha_instalacion',
                'instalacions.sDireccion',
                'instalacions.sComuna',
                'instalacions.sContacto',
                'instalacions.sCui',
                'instalacions.sSC',
                'instalacions.sModelo',
                'instalacions.sSerie',
                'instalacions.sIP',
                'instalacions.sMsk',
                'instalacions.sGateway',
                'instalacions.sMac',
                'instalacions.nContador',
                'instalacions.tipo',
                'instalacions.razonSocial',
                'instalacions.nContador_color',
                'instalacions.sCable_red',
                'instalacions.sCable_poder',
                'instalacions.sBandeja_adicional',
                'instalacions.sMueble',
                'instalacions.sKit_lector',
                'instalacions.sSD',
                'instalacions.sCable_red',
                'instalacions.sCable_poder',
                'instalacions.id as id_instalacion',
                'instalacions.idSala'

            )
            ->get();

            $tipo = $api_instalaciones[0]->tipo;
            $razonSocial = $api_instalaciones[0]->razonSocial;
            $cliente = $api_instalaciones[0]->sCliente;

            

            $con_razonSocial= "no";
            $razonAgrupasa = DB::table('clientes')
            ->select('razon_social_agrupada')
            ->where('clientes.razon_social', '=', $cliente)
            ->get();


            if(count($razonAgrupasa ) >0){
              $con_razonSocial = $razonAgrupasa[0]->razon_social_agrupada;
            }else{
                $con_razonSocial= "no";
            
            }

        //buscamos las asignaciones para poder saber cual es el numero de visita
        $datos_asignacion = DB::table('asignacion_instalacions')
            ->where('asignacion_instalacions.lista_instalacion_id', '=', $id_instalacion)
            ->get();

        if (count($datos_asignacion) == 0) {
            $total_dias = 1;
        } else {
            $total_dias = count($datos_asignacion) + 1;
        }


        return view('check.asignar_checklist', compact('con_razonSocial','cliente','razonSocial','tipo','trabajadores', 'tipos_visitas', 'proyectos', 'api_instalaciones', 'total_dias'));
    }
    public function ver_checklistCoodinadora_home(request $request)
    {

        $id_asignacion = $request->id;


        $mi_asignacion = DB::table('asignacion_instalacions')
            ->where('asignacion_instalacions.id', '=', $id_asignacion)
            ->get();

        $id_trabajador = $mi_asignacion[0]->trabajadors_id;

        $firma_tecnico = DB::table('firma_clientes')
        ->where('id_tecnico', '=', $id_trabajador)
        ->get();

        $datos_asignacion = DB::table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('softwares', 'softwares.id', '=', 'checklist_instalacions.softwares_id')
            ->join('tipo_conexiones', 'tipo_conexiones.id', '=', 'checklist_instalacions.tipo_conexiones_id')
            ->join('nombre_servidores', 'nombre_servidores.id', '=', 'checklist_instalacions.nombre_servidores_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')

            ->select(
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscliente',
                'asignacion_instalacions.estado_asignacion',
                'asignacion_instalacions.fecha_instalacion',
                'asignacion_instalacions.id',
                'asignacion_instalacions.numero_visita',
                'asignacion_instalacions.opcion_estado_instalacion',
                'asignacion_instalacions.tipos_visitas_id',
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscomuna',
                'checklist_instalacions.Cscui',
                'checklist_instalacions.Cspiso',
                'checklist_instalacions.Csmarca',
                'checklist_instalacions.Cscambio_serie',
                'checklist_instalacions.Csserie_remplazo',
                'checklist_instalacions.Csmodelo_remplazo',
                'checklist_instalacions.modo_U253',
                'checklist_instalacions.ins_driver',
                'checklist_instalacions.equipo_operativo',
                'checklist_instalacions.Csregion',
                'checklist_instalacions.Cnfolio',
                'checklist_instalacions.CsSerie',
                'checklist_instalacions.CsModelo',
                'checklist_instalacions.CUsb_red',
                'checklist_instalacions.CDriver',
                'checklist_instalacions.Cscontacto',
                'checklist_instalacions.CsSC',
                'asignacion_instalacions.lista_instalacion_id as id_instalacion',
                'checklist_instalacions.CsIP',
                'checklist_instalacions.CsGateway',
                'checklist_instalacions.CsMsk',
                'checklist_instalacions.CnContador',
                'checklist_instalacions.CnContador_color',
                'checklist_instalacions.id as id_checklist',
                'softwares.descripcion as nombre_software',
                'tipo_conexiones.descripcion as nombre_conexion',
                'nombre_servidores.descripcion as nombre_servidor',
                'personas.nombre_uno as nombrepersona',
                'personas.nombre_dos as nombrepe',
                'checklist_instalacions.CsObservacion',
                'checklist_instalacions.CsBandeja_adicional',
                'checklist_instalacions.CsMueble',
                'checklist_instalacions.CsKit_lector',
                'checklist_instalacions.CsSD',
                'checklist_instalacions.CsCable_poder',
                'checklist_instalacions.CsCable_red',
                'checklist_instalacions.Csconexion_electrica',
                'checklist_instalacions.Csservidor_impresion',
                'checklist_instalacions.Csservidor_impresion',
                'checklist_instalacions.Csconfig_smb',
                'checklist_instalacions.Csconfig_email',
                'checklist_instalacions.Cscantidad_usuarios',
                'checklist_instalacions.firma_contacto',
                'checklist_instalacions.observacion',
                'checklist_instalacions.url_firma',
                'checklist_instalacions.tipo_equipo',
                'checklist_instalacions.fecha_inicio',
                'checklist_instalacions.fecha_fin',
                'checklist_instalacions.CsMarca_es',
                'checklist_instalacions.CsSerie_es',
                'checklist_instalacions.CsModelo_es',
                'checklist_instalacions.CsTipoequipo_es',
                'checklist_instalacions.CsContador_es',
                'checklist_instalacions.CsContadorcolor_es',
                'checklist_instalacions.motivo',
                'checklist_instalacions.nombre_contactoF',
                'checklist_instalacions.rut_contactoF',
                'checklist_instalacions.idSala'



            )
            ->where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_instalacions.id', '=', $id_asignacion)
            ->orderBy('asignacion_instalacions.id', 'desc')
            ->get();

        //encontramos el nombre del proyecto asociado al checklist de instalacion
        $id_instalacion = $datos_asignacion[0]->id_instalacion;
        $proyecto_asociado = DB::table('instalacions')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->select('proyectos.nombre', 'clientes.razon_social', 'sEstado_instalacion', 'i_opcion_estado_instalacion','instalacions.razonSocial')
            ->where('instalacions.id', '=', $id_instalacion)
            ->get();



        $i_opcion_estado_instalacion = $proyecto_asociado[0]->i_opcion_estado_instalacion;
        $i_opcion_estado_instalacion = str_replace("_", " ", $i_opcion_estado_instalacion);

                //RAZONSOCIALAGRUPADAS
                $con_razonSocial= "no";
                $razonAgrupasa = DB::table('clientes')
                ->select('razon_social_agrupada')
                ->where('clientes.razon_social', '=', $proyecto_asociado[0]->razon_social)
                ->get();
        
                if(count($razonAgrupasa ) >0){
                    $con_razonSocial = $razonAgrupasa[0]->razon_social_agrupada;
                  }else{
                      $con_razonSocial= "no";
                  
                  }
        

        // modal foto traer imagenes.
        $fotos = DB::table('fotos_check_instalacions')
            ->where('fotos_check_instalacions.checklist_instalacion_id', '=', $datos_asignacion[0]->id_checklist)
            ->get();

        $fotos_accesorios = DB::table('fotos_checks_accesorios')
            ->where('checklist_instalacion_id', '=', $datos_asignacion[0]->id_checklist)
            ->get();

        // return $proyecto_asociado;clientes_id


        $softwares = DB::table('softwares')
            ->where('softwares.estado', '=', "activo")
            //->where('softwares.id','!=',1)
            ->get();


        $servidores = DB::table('nombre_servidores')
            ->where('nombre_servidores.estado', '=', "activo")
            //->where('nombre_servidores.id','!=',1)
            ->get();


        $tipo_conexion = DB::table('tipo_conexiones')
            ->where('tipo_conexiones.estado', '=', "activo")
            //->where('tipo_conexiones.id','!=',1)
            ->get();

        $datos_instalacion = DB::table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            //->leftjoin('fotos_check_instalacions','fotos_check_instalacions.checklist_instalacion_id','=','checklist_instalacions.id')
            ->Where(function ($query) use ($id_trabajador, $id_asignacion, $datos_asignacion) {
                $query
                    //->where('asignacion_instalacions.trabajadors_id','=',$id_trabajador)
                    ->where('checklist_instalacions.Csdireccion', '=', $datos_asignacion[0]->Csdireccion)
                    ->where('asignacion_instalacions.id', '!=', $id_asignacion)
                    ->where('checklist_instalacions.url_firma', '=', NULL);
            })
            ->select(
                'checklist_instalacions.motivo_reasignado',
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscliente',
                'asignacion_instalacions.estado_asignacion',
                'asignacion_instalacions.fecha_asignado as fecha_as',
                'asignacion_instalacions.id',
                'asignacion_instalacions.tipo', //retiro o intalaccion
                'asignacion_instalacions.motivo_rechazado',
                'asignacion_instalacions.fecha_instalacion as fecha_visita', //fecha_instalacion
                'checklist_instalacions.csComuna',
                'checklist_instalacions.CsSerie',
                'checklist_instalacions.id as idcheck'
            )
            ->orderBy('fecha_visita', 'desc')
            ->get();


        $tipo_visita = App\tipos_visitas::findOrfail($datos_asignacion[0]->tipos_visitas_id);

        return view('check.ver_checklistCoordinadora', compact('con_razonSocial','firma_tecnico','datos_instalacion', 'i_opcion_estado_instalacion', 'datos_asignacion', 'tipo_visita', 'proyecto_asociado', 'softwares', 'servidores', 'tipo_conexion', 'fotos', 'fotos_accesorios'));
    }
    public function ver_checklistCoodinadora_home_old_09_02_23(request $request)
    {

        $id_asignacion = $request->id;


        $mi_asignacion = DB::table('asignacion_instalacions')
            ->where('asignacion_instalacions.id', '=', $id_asignacion)
            ->get();

        $id_trabajador = $mi_asignacion[0]->trabajadors_id;

        $firma_tecnico = DB::table('firma_clientes')
        ->where('id_tecnico', '=', $id_trabajador)
        ->get();

        $datos_asignacion = DB::table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('softwares', 'softwares.id', '=', 'checklist_instalacions.softwares_id')
            ->join('tipo_conexiones', 'tipo_conexiones.id', '=', 'checklist_instalacions.tipo_conexiones_id')
            ->join('nombre_servidores', 'nombre_servidores.id', '=', 'checklist_instalacions.nombre_servidores_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')

            ->select(
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscliente',
                'asignacion_instalacions.estado_asignacion',
                'asignacion_instalacions.fecha_instalacion',
                'asignacion_instalacions.id',
                'asignacion_instalacions.numero_visita',
                'asignacion_instalacions.opcion_estado_instalacion',
                'asignacion_instalacions.tipos_visitas_id',
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscomuna',
                'checklist_instalacions.Cscui',
                'checklist_instalacions.Cspiso',
                'checklist_instalacions.Csmarca',
                'checklist_instalacions.Cscambio_serie',
                'checklist_instalacions.Csserie_remplazo',
                'checklist_instalacions.Csmodelo_remplazo',
                'checklist_instalacions.modo_U253',
                'checklist_instalacions.ins_driver',
                'checklist_instalacions.equipo_operativo',
                'checklist_instalacions.Csregion',
                'checklist_instalacions.Cnfolio',
                'checklist_instalacions.CsSerie',
                'checklist_instalacions.CsModelo',
                'checklist_instalacions.CUsb_red',
                'checklist_instalacions.CDriver',
                'checklist_instalacions.Cscontacto',
                'checklist_instalacions.CsSC',
                'asignacion_instalacions.lista_instalacion_id as id_instalacion',
                'checklist_instalacions.CsIP',
                'checklist_instalacions.CsGateway',
                'checklist_instalacions.CsMsk',
                'checklist_instalacions.CnContador',
                'checklist_instalacions.CnContador_color',
                'checklist_instalacions.id as id_checklist',
                'softwares.descripcion as nombre_software',
                'tipo_conexiones.descripcion as nombre_conexion',
                'nombre_servidores.descripcion as nombre_servidor',
                'personas.nombre_uno as nombrepersona',
                'personas.nombre_dos as nombrepe',
                'checklist_instalacions.CsObservacion',
                'checklist_instalacions.CsBandeja_adicional',
                'checklist_instalacions.CsMueble',
                'checklist_instalacions.CsKit_lector',
                'checklist_instalacions.CsSD',
                'checklist_instalacions.CsCable_poder',
                'checklist_instalacions.CsCable_red',
                'checklist_instalacions.Csconexion_electrica',
                'checklist_instalacions.Csservidor_impresion',
                'checklist_instalacions.Csservidor_impresion',
                'checklist_instalacions.Csconfig_smb',
                'checklist_instalacions.Csconfig_email',
                'checklist_instalacions.Cscantidad_usuarios',
                'checklist_instalacions.firma_contacto',
                'checklist_instalacions.observacion',
                'checklist_instalacions.url_firma',
                'checklist_instalacions.tipo_equipo',
                'checklist_instalacions.fecha_inicio',
                'checklist_instalacions.fecha_fin',
                'checklist_instalacions.CsMarca_es',
                'checklist_instalacions.CsSerie_es',
                'checklist_instalacions.CsModelo_es',
                'checklist_instalacions.CsTipoequipo_es',
                'checklist_instalacions.CsContador_es',
                'checklist_instalacions.CsContadorcolor_es',
                'checklist_instalacions.motivo',
                'checklist_instalacions.nombre_contactoF',
                'checklist_instalacions.rut_contactoF'


            )
            ->where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_instalacions.id', '=', $id_asignacion)
            ->orderBy('asignacion_instalacions.id', 'desc')
            ->get();

        //encontramos el nombre del proyecto asociado al checklist de instalacion
        $id_instalacion = $datos_asignacion[0]->id_instalacion;
        $proyecto_asociado = DB::table('instalacions')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->select('proyectos.nombre', 'clientes.razon_social', 'sEstado_instalacion', 'i_opcion_estado_instalacion')
            ->where('instalacions.id', '=', $id_instalacion)
            ->get();



        $i_opcion_estado_instalacion = $proyecto_asociado[0]->i_opcion_estado_instalacion;
        $i_opcion_estado_instalacion = str_replace("_", " ", $i_opcion_estado_instalacion);


        // modal foto traer imagenes.
        $fotos = DB::table('fotos_check_instalacions')
            ->where('fotos_check_instalacions.checklist_instalacion_id', '=', $datos_asignacion[0]->id_checklist)
            ->get();

        $fotos_accesorios = DB::table('fotos_checks_accesorios')
            ->where('checklist_instalacion_id', '=', $datos_asignacion[0]->id_checklist)
            ->get();

        // return $proyecto_asociado;clientes_id


        $softwares = DB::table('softwares')
            ->where('softwares.estado', '=', "activo")
            //->where('softwares.id','!=',1)
            ->get();


        $servidores = DB::table('nombre_servidores')
            ->where('nombre_servidores.estado', '=', "activo")
            //->where('nombre_servidores.id','!=',1)
            ->get();


        $tipo_conexion = DB::table('tipo_conexiones')
            ->where('tipo_conexiones.estado', '=', "activo")
            //->where('tipo_conexiones.id','!=',1)
            ->get();

        $datos_instalacion = DB::table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            //->leftjoin('fotos_check_instalacions','fotos_check_instalacions.checklist_instalacion_id','=','checklist_instalacions.id')
            ->Where(function ($query) use ($id_trabajador, $id_asignacion, $datos_asignacion) {
                $query
                    //->where('asignacion_instalacions.trabajadors_id','=',$id_trabajador)
                    ->where('checklist_instalacions.Csdireccion', '=', $datos_asignacion[0]->Csdireccion)
                    ->where('asignacion_instalacions.id', '!=', $id_asignacion)
                    ->where('checklist_instalacions.url_firma', '=', NULL);
            })
            ->select(
                'checklist_instalacions.motivo_reasignado',
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscliente',
                'asignacion_instalacions.estado_asignacion',
                'asignacion_instalacions.fecha_asignado as fecha_as',
                'asignacion_instalacions.id',
                'asignacion_instalacions.tipo', //retiro o intalaccion
                'asignacion_instalacions.motivo_rechazado',
                'asignacion_instalacions.fecha_instalacion as fecha_visita', //fecha_instalacion
                'checklist_instalacions.csComuna',
                'checklist_instalacions.CsSerie',
                'checklist_instalacions.id as idcheck'
            )
            ->orderBy('fecha_visita', 'desc')
            ->get();


        $tipo_visita = App\tipos_visitas::findOrfail($datos_asignacion[0]->tipos_visitas_id);

        return view('check.ver_checklistCoordinadora', compact('firma_tecnico','datos_instalacion', 'i_opcion_estado_instalacion', 'datos_asignacion', 'tipo_visita', 'proyecto_asociado', 'softwares', 'servidores', 'tipo_conexion', 'fotos', 'fotos_accesorios'));
    }
    public function ver_retirocoodinadora_home(request $request)
    {
        $idretiroasig = $request->id;

        $datos_asignacion = DB::table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_retiros.trabajadors_idtecnico')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'asignacion_retiros.numero_visita',
                'checklist_retiros.csDireccion',
                'checklist_retiros.csComuna',
                'checklist_retiros.csCui',
                'checklist_retiros.csSerie',
                'checklist_retiros.estado_check',
                'checklist_retiros.csModelo',
                'checklist_retiros.cnContador',
                'checklist_retiros.cnContador_color',
                'checklist_retiros.csObservacion',
                'checklist_retiros.nombre_contacto',
                'checklist_retiros.bandeja_adicional',
                'checklist_retiros.mueble',
                'checklist_retiros.kitlector',
                'checklist_retiros.memoriasd',
                'checklist_retiros.cablered',
                'checklist_retiros.cablepoder',
                'checklist_retiros.equipoembalado',
                'checklist_retiros.cliente_firma',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'personas.apellido_dos',
                'asignacion_retiros.fecha_termino',
                'asignacion_retiros.fecha_inicio',
                'asignacion_retiros.fecha_asignado',
                'asignacion_retiros.fecha_retiro',
                'asignacion_retiros.estado_asignacion',
                'asignacion_retiros.id as idCheckRetiros',
                'checklist_retiros.url_firma',
                'checklist_retiros.id as id_retiroChec'
            )
            ->where('asignacion_retiros.id', '=', $idretiroasig)
            ->get();

        $proyectos =  DB::table('asignacion_retiros')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->join('tracker', 'tracker.id', '=', 'retiros.tracker_id')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')

            ->select('clientes.razon_social', 'proyectos.nombre')
            ->where('asignacion_retiros.id', '=', $idretiroasig)
            ->get();

        $fotos = DB::table('fotos_retiros')
            ->where('fotos_retiros.checklist_retiros_id', '=', $datos_asignacion[0]->id_retiroChec)
            ->get();

        return view('check.ver_checklist_retiro_coordinadora', compact('datos_asignacion', 'proyectos', 'fotos'));
    }
    public function finaliza_manual_home(request $request)
    {
        $id_asignacion = $request->id;

        $datos_trabajador = DB::table('asignacion_instalacions')
            ->select('trabajadors_id')
            ->where("id", "=", $id_asignacion)
            ->get();

        $id_trabajador =  $datos_trabajador[0]->trabajadors_id;

        $datos_asignacion = DB::table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscliente',
                'asignacion_instalacions.estado_asignacion',
                'asignacion_instalacions.fecha_instalacion',
                'asignacion_instalacions.id',
                'asignacion_instalacions.numero_visita',
                'asignacion_instalacions.tipos_visitas_id',
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscomuna',
                'checklist_instalacions.Cscui',
                'checklist_instalacions.Cspiso',
                'checklist_instalacions.Csregion',
                'checklist_instalacions.Cnfolio',
                'checklist_instalacions.CsSerie',
                'checklist_instalacions.CsModelo',
                'checklist_instalacions.CUsb_red',
                'checklist_instalacions.CDriver',
                'checklist_instalacions.Cscontacto',
                'checklist_instalacions.CsSC',
                'asignacion_instalacions.lista_instalacion_id as id_instalacion',
                'checklist_instalacions.CsIP',
                'checklist_instalacions.CsGateway',
                'checklist_instalacions.CsMsk',
                'checklist_instalacions.CnContador',
                'checklist_instalacions.CnContador_color',
                'checklist_instalacions.id as id_checklist',
                'checklist_instalacions.estado_inicio',
                'personas.nombre_uno as nombrepersona',
                'personas.nombre_dos as nombrepe',
                'asignacion_instalacions.motivo_rechazado',
                'checklist_instalacions.url_firma',
                'asignacion_instalacions.tipos_visitas_id',
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscomuna',
                'checklist_instalacions.CsKit_lector',
                'checklist_instalacions.Csconexion_electrica',
                'checklist_instalacions.Cscantidad_usuarios',
                'checklist_instalacions.CsCable_poder',
                'checklist_instalacions.Csservidor_impresion',
                'checklist_instalacions.CsSD',
                'checklist_instalacions.ins_driver',
                'checklist_instalacions.equipo_operativo',
                'checklist_instalacions.CsObservacion',
                'checklist_instalacions.Cscontacto',
                'checklist_instalacions.modo_U253',
                'checklist_instalacions.Csconfig_smb',
                'checklist_instalacions.CsBandeja_adicional',
                'checklist_instalacions.Cstipo_conexion',
                'checklist_instalacions.motivo',
                'checklist_instalacions.CsCable_red',
                'checklist_instalacions.nombre_servidores_id',
                'checklist_instalacions.tipo_conexiones_id',
                'checklist_instalacions.tipo_equipo',
                'checklist_instalacions.softwares_id',
                'checklist_instalacions.Csn_contacto',
                'checklist_instalacions.Csconfig_email',
                'checklist_instalacions.CsSerie_es',
                'checklist_instalacions.CsModelo_es',
                'checklist_instalacions.CsContador_es',
                'checklist_instalacions.CsContadorcolor_es',
                'checklist_instalacions.idSala',

            )
            ->where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_instalacions.id', '=', $id_asignacion)
            ->orderBy('asignacion_instalacions.id', 'desc')
            ->get();

        $cantidad_fotos = App\fotos_check_instalacions::where('checklist_instalacion_id', $datos_asignacion[0]->id_checklist)->count();



        if ($datos_asignacion[0]->motivo_rechazado == "" || $datos_asignacion[0]->motivo_rechazado == null) {
            $accion = "1";   //iniciar
        } else {
            $accion = "2"; // completas rechazado
        }

        //encontramos el nombre del proyecto asociado al checklist de instalacion
        $id_instalacion = $datos_asignacion[0]->id_instalacion;
        $proyecto_asociado = DB::table('instalacions')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->select('proyectos.nombre', 'clientes.razon_social')
            ->where('instalacions.id', '=', $id_instalacion)
            ->get();

        // return $proyecto_asociado;clientes_id


        $softwares = DB::table('softwares')
            ->where('softwares.estado', '=', "activo")
            ////->where('softwares.id','!=',1)
            ->get();


        $servidores = DB::table('nombre_servidores')
            ->where('nombre_servidores.estado', '=', "activo")
            ////->where('nombre_servidores.id','!=',1)
            ->get();


        $tipo_conexion = DB::table('tipo_conexiones')
            ->where('tipo_conexiones.estado', '=', "activo")
            // //->where('tipo_conexiones.id','!=',1)
            ->get();

        //$estado = ;
        $estado = collect(['Finalizar', 'Pendiente', 'Cancelar']);

        $detalle = collect(['Ubicacion provisoria', 'Habilitacion de credenciales', 'Continua usando equipo anterior', 'Equipo operativo', 'Configurado, pendiente Capacitacion', 'No realizado por A&A']);

        // $detalle_ = [
        //     ['name' => 'Taylor',  'coffee_drinker' => true],
        //     ['name' => 'Matt', 'coffee_drinker' => true]
        // ];

        // $detalle = collect($detalle_);



        $tipo_visita = App\tipos_visitas::findOrfail($datos_asignacion[0]->tipos_visitas_id);
        $manual = "si";

        return view('check.iniciar_checklist', compact('manual', 'cantidad_fotos', 'datos_asignacion', 'tipo_visita', 'proyecto_asociado', 'softwares', 'servidores', 'tipo_conexion', 'accion', 'estado', 'detalle'));
    }
    public function firma_instalacion($id)
    {
        try {
            $id_instalacion_check = Crypt::decryptString($id);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }

        $datos_asignacion = DB::table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscliente',
                'asignacion_instalacions.estado_asignacion',
                'asignacion_instalacions.fecha_instalacion',
                'asignacion_instalacions.id',
                'asignacion_instalacions.numero_visita',
                'asignacion_instalacions.tipos_visitas_id',
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscomuna',
                'checklist_instalacions.Cscui',
                'checklist_instalacions.Cspiso',
                'checklist_instalacions.Csregion',
                'checklist_instalacions.Cnfolio',
                'checklist_instalacions.CsSerie',
                'checklist_instalacions.CsModelo',
                'checklist_instalacions.CUsb_red',
                'checklist_instalacions.CDriver',
                'checklist_instalacions.Cscontacto',
                'checklist_instalacions.CsSC',
                'asignacion_instalacions.lista_instalacion_id as id_instalacion',
                'checklist_instalacions.CsIP',
                'checklist_instalacions.CsGateway',
                'checklist_instalacions.CsMsk',
                'checklist_instalacions.CnContador',
                'checklist_instalacions.CnContador_color',
                'checklist_instalacions.id as id_checklist',
                'checklist_instalacions.estado_inicio',
                'personas.nombre_uno as nombrepersona',
                'personas.nombre_dos as nombrepe',
                'asignacion_instalacions.motivo_rechazado',
                'checklist_instalacions.url_firma',
                'asignacion_instalacions.tipos_visitas_id',
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscomuna',
                'checklist_instalacions.CsKit_lector',
                'checklist_instalacions.Csconexion_electrica',
                'checklist_instalacions.Cscantidad_usuarios',
                'checklist_instalacions.CsCable_poder',
                'checklist_instalacions.Csservidor_impresion',
                'checklist_instalacions.CsSD',
                'checklist_instalacions.ins_driver',
                'checklist_instalacions.equipo_operativo',
                'checklist_instalacions.CsObservacion',
                'checklist_instalacions.Cscontacto',
                'checklist_instalacions.modo_U253',
                'checklist_instalacions.Csconfig_smb',
                'checklist_instalacions.CsBandeja_adicional',
                'checklist_instalacions.Cstipo_conexion',
                'checklist_instalacions.motivo',
                'checklist_instalacions.CsCable_red',
                'checklist_instalacions.nombre_servidores_id',
                'checklist_instalacions.tipo_conexiones_id',
                'checklist_instalacions.tipo_equipo',
                'checklist_instalacions.softwares_id',
                'checklist_instalacions.Csn_contacto',
                'checklist_instalacions.Csconfig_email',
                'checklist_instalacions.CsSerie_es',
                'checklist_instalacions.CsModelo_es',
                'checklist_instalacions.CsContador_es',
                'checklist_instalacions.CsContadorcolor_es',
                'asignacion_instalacions.trabajadors_id'
            )
            ->where('asignacion_instalacions.id', '=', $id_instalacion_check)
            ->orderBy('asignacion_instalacions.id', 'desc')
            ->get();

        $id = $datos_asignacion[0]->id;
        $Direccion = $datos_asignacion[0]->Csdireccion;
        $idTrabajador = $datos_asignacion[0]->trabajadors_id;

        $datos_instalacion = DB::table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            //->leftjoin('fotos_check_instalacions','fotos_check_instalacions.checklist_instalacion_id','=','checklist_instalacions.id')
            ->Where(function ($query) use ($id, $Direccion, $idTrabajador) {
                $query->where('asignacion_instalacions.id', '!=', $id)
                    ->where('checklist_instalacions.Csdireccion', '=', $Direccion)
                    ->where('checklist_instalacions.url_firma', '=', NULL)
                    ->where('asignacion_instalacions.trabajadors_id', '=', $idTrabajador);
            })
            ->select(
                'checklist_instalacions.motivo_reasignado',
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscliente',
                'asignacion_instalacions.estado_asignacion',
                'asignacion_instalacions.fecha_asignado as fecha_as',
                'asignacion_instalacions.id',
                'asignacion_instalacions.tipo', //retiro o intalaccion
                'asignacion_instalacions.motivo_rechazado',
                'asignacion_instalacions.fecha_instalacion as fecha_visita', //fecha_instalacion
                'checklist_instalacions.csComuna',
                'checklist_instalacions.CsSerie',
                'checklist_instalacions.id as idcheck'
            )
            ->orderBy('fecha_visita', 'desc')
            ->get();

        return view('check.firma_instalacion', compact('datos_asignacion', 'datos_instalacion'));
    }
    public function pdfcorreo(request $request)
    {

        $proveedor = $request->proveedor;
        $id_asignacion = $request->idasig;

        Config::set('database.connections.mysql.database', strtoupper($proveedor));
        DB::reconnect();

        $mi_asignacion = DB::table('asignacion_instalacions')
            ->where('asignacion_instalacions.id', '=', $id_asignacion)
            ->get();

        $id_trabajador = $mi_asignacion[0]->trabajadors_id;

        $datos_asignacion = DB::table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->join('softwares', 'softwares.id', '=', 'checklist_instalacions.softwares_id')
            ->join('tipo_conexiones', 'tipo_conexiones.id', '=', 'checklist_instalacions.tipo_conexiones_id')
            ->join('nombre_servidores', 'nombre_servidores.id', '=', 'checklist_instalacions.nombre_servidores_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscliente',
                'asignacion_instalacions.estado_asignacion',
                'asignacion_instalacions.fecha_instalacion',
                'asignacion_instalacions.id',
                'asignacion_instalacions.numero_visita',
                'asignacion_instalacions.tipos_visitas_id',
                'asignacion_instalacions.opcion_estado_instalacion',
                'checklist_instalacions.Csdireccion',
                'checklist_instalacions.Cscomuna',
                'checklist_instalacions.Cscui',
                'checklist_instalacions.Cspiso',
                'checklist_instalacions.Csmarca',
                'checklist_instalacions.CsMarca_es',
                'checklist_instalacions.CsSerie_es',
                'checklist_instalacions.CsModelo_es',
                'checklist_instalacions.CsTipoequipo_es',
                'checklist_instalacions.CsContador_es',
                'checklist_instalacions.CsContadorcolor_es',
                'checklist_instalacions.Cscambio_serie',
                'checklist_instalacions.Csserie_remplazo',
                'checklist_instalacions.Csmodelo_remplazo',
                'checklist_instalacions.modo_U253',
                'checklist_instalacions.ins_driver',
                'checklist_instalacions.equipo_operativo',
                'checklist_instalacions.Csregion',
                'checklist_instalacions.Csciudad',
                'checklist_instalacions.Csrut',
                'checklist_instalacions.Cnfolio',
                'checklist_instalacions.CsSerie',
                'checklist_instalacions.CsModelo',
                'checklist_instalacions.Csn_contacto',
                'checklist_instalacions.Cstipo_sucursal',
                'checklist_instalacions.CUsb_red',
                'checklist_instalacions.CDriver',
                'checklist_instalacions.Cscontacto',
                'checklist_instalacions.CsSC',
                'asignacion_instalacions.lista_instalacion_id as id_instalacion',
                'checklist_instalacions.CsIP',
                'checklist_instalacions.CsGateway',
                'checklist_instalacions.CsMsk',
                'checklist_instalacions.CsMac',
                'checklist_instalacions.CdFecha_plan_despacho',
                'checklist_instalacions.CdFecha_despacho',
                'checklist_instalacions.CnGuia',
                'checklist_instalacions.CsEstado_despacho',
                'checklist_instalacions.CdFecha_instalacion',
                'checklist_instalacions.CsEstado_instalacion',
                'checklist_instalacions.CnContador',
                'checklist_instalacions.CnContador_color',
                'checklist_instalacions.id as id_checklist',
                'softwares.descripcion as nombre_software',
                'tipo_conexiones.descripcion as nombre_conexion',
                'nombre_servidores.descripcion as nombre_servidor',
                'personas.nombre_uno as nombrepersona',
                'personas.nombre_dos as nombrepe',
                'personas.apellido_uno as apellidouno',
                'personas.apellido_dos as apellidodos',
                'checklist_instalacions.CsObservacion',
                'checklist_instalacions.observacion',
                'checklist_instalacions.CsBandeja_adicional',
                'checklist_instalacions.CsMueble',
                'checklist_instalacions.CsKit_lector',
                'checklist_instalacions.CsSD',
                'checklist_instalacions.CsCable_poder',
                'checklist_instalacions.CsCable_red',
                'checklist_instalacions.Csconexion_electrica',
                'checklist_instalacions.Csservidor_impresion',
                'checklist_instalacions.Csservidor_impresion',
                'checklist_instalacions.Csconfig_smb',
                'checklist_instalacions.Csconfig_email',
                'checklist_instalacions.Cscantidad_usuarios',
                'checklist_instalacions.firma_contacto',
                'checklist_instalacions.observacion',
                'checklist_instalacions.url_firma',
                'checklist_instalacions.tipo_equipo',
                'checklist_instalacions.fecha_inicio',
                'checklist_instalacions.fecha_fin',
                'checklist_instalacions.motivo',
                'checklist_instalacions.nombre_contactoF',
                'checklist_instalacions.rut_contactoF',
                'trabajadors.id as id_trabajador',
                'instalacions.nID_Tracker',
                'instalacions.fecha_instalacion_coordinadora',
                'instalacions.proveedor_instalacion',
                'instalacions.sRegion',
                'instalacions.i_opcion_estado_instalacion',
            )
            ->where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_instalacions.id', '=', $id_asignacion)
            ->orderBy('asignacion_instalacions.id', 'desc')
            ->get();

        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id', '=', $datos_asignacion[0]->id_trabajador)
            ->get();

        $firmatrabajador = DB::table('firma_clientes')
            ->where('firma_clientes.id_tecnico', '=', $datos_trabajador[0]->id_login)
            ->get();

        $id_instalacion = $datos_asignacion[0]->id_instalacion;

        $proyecto_asociado = DB::table('instalacions')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->select('proyectos.nombre', 'clientes.razon_social', 'proyectos.url_logo', 'proyectos.proveedor_nombre')
            ->where('instalacions.id', '=', $id_instalacion)
            ->get();

        $fotos = DB::table('fotos_check_instalacions')
            ->where('fotos_check_instalacions.checklist_instalacion_id', '=', $datos_asignacion[0]->id_checklist)
            ->get();

        $datos_accesorios = DB::table('checklist_accesorios')
            ->join('accesorios', 'accesorios.id', '=', 'checklist_accesorios.id_accesorio')
            ->select('accesorios.id', 'accesorios.articulo', 'accesorios.descripcion', 'checklist_accesorios.cantidad', 'checklist_accesorios.serie_parte')
            ->where('checklist_accesorios.id_checklist_instalacion', '=', $datos_asignacion[0]->id_checklist)
            ->get();

        $accesorios_dañados = DB::table('checklist_accesorios_dañados')
            ->join('accesorios', 'accesorios.id', '=', 'checklist_accesorios_dañados.id_accesorio')
            ->select('accesorios.id', 'accesorios.descripcion', 'accesorios.articulo', 'checklist_accesorios_dañados.cantidad', 'checklist_accesorios_dañados.serie_parte')
            ->where('checklist_accesorios_dañados.id_checklist_instalacion', '=', $datos_asignacion[0]->id_checklist)
            ->get();

        $accesorios_manuales = DB::table('accesorios_manuales')
            ->where('accesorios_manuales.id_checklist_instalacion', '=', $datos_asignacion[0]->id_checklist)
            ->get();

        $instalacion_accesorios = DB::table('checklist_instalacion_accesorios')
            ->join('accesorios', 'accesorios.id', '=', 'checklist_instalacion_accesorios.id_accesorio')
            ->select('accesorios.id', 'accesorios.descripcion', 'accesorios.articulo', 'checklist_instalacion_accesorios.cantidad', 'accesorios.id as ID', 'checklist_instalacion_accesorios.serie_parte')
            ->where('checklist_instalacion_accesorios.id_checklist_instalacion', '=', $datos_asignacion[0]->id_checklist)
            ->get();

        $instalacion_accesorios_manuales = DB::table('instalacion_accesorios_manuales')
            ->where('instalacion_accesorios_manuales.id_checklist_instalacion', '=', $datos_asignacion[0]->id_checklist)
            ->get();

        $fotos_accesorios = DB::table('fotos_checks_accesorios')
            ->where('checklist_instalacion_id', '=', $datos_asignacion[0]->id_checklist)
            ->get();

        $tipo_visita = App\tipos_visitas::findOrfail($datos_asignacion[0]->tipos_visitas_id);

        $CsSerie = $datos_asignacion[0]->CsSerie;

        return \PDF::setOptions((['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true]))
            ->loadView('check/pdf.pdfInstalacionCoordinadora', compact('instalacion_accesorios_manuales', 'instalacion_accesorios', 'accesorios_manuales', 'datos_asignacion', 'tipo_visita', 'proyecto_asociado', 'fotos', 'firmatrabajador', 'datos_accesorios', 'accesorios_dañados', 'fotos_accesorios'))
            ->stream($CsSerie.'instalacion.pdf');
    }
}
