@extends('menu/menu')

@section('content')
@if ( session('mensaje') )
<div class="alert alert-success">{{ session('mensaje') }}</div>
@endif

<div class="container mt-5">
    <div class="title-vista mt-4 d-flex justify-content-between">
        Capacitaciones
        <div class="mostrar-contenido">
            <a class="btn" href="javascript: history.go(-1)">
                <span class="material-icons-round icon-midle">arrow_back</span>
                Volver
            </a>
        </div>
    </div>
</div>
<div class="container mt-5">
    <!-- TABLA DE RESULTADOS DE BUSQUEDA -->
    <div class="container table-responsive mb-5 p-sm-0">
        <table class="table table-striped table-hover">
            <!-- ENCABEZADO -->
            <thead class="color-head">
                <tr>
                    <th class="th-head border-th separador-v" colspan="1">CUI</th>
                    <th class="th-head border-th separador-v" colspan="1">Fecha capacitación</th>
                    <th class="th-head border-th separador-v" colspan="1">Estado</th>
                    <th class="th-head border-th separador-v" colspan="1">Cliente</th>
                    <th class="th-head border-th separador-v" colspan="1">Comuna</th>
                    <th class="th-head border-th separador-v" colspan="1">Dirección</th>
                    <th class="th-head border-th"><span class="material-icons">settings</span></th>
                </tr>
            </thead>
            <!-- FIN ENCABEZADO -->
            <!-- RESULTADOS -->
            <tbody>
                @for($i=0;$i<$cont;$i++) @if(!empty($capas[$i])) @foreach ($capas[$i] as $capacitacion) <tr>
                    <td class="td-val">{{$capacitacion->cui}}</td>
                    <td class="td-val">{{Carbon\Carbon::createFromDate($capacitacion->fecha_capacitacion)->format('d-m-Y')}}</td>
                    <td class="td-val">{{$capacitacion->estado_capa}}</td>
                    <td class="td-val">{{$capacitacion->cliente}}</td>
                    <td class="td-val">{{$capacitacion->comuna}}</td>
                    <td class="td-val">{{$capacitacion->direccion}}</td>
                    <td class="td-val">
                        <div class="dropdown dropleft" style="text-align: center">
                            <button type="button" class="btn-dropdown" data-toggle="dropdown">
                                <span class="material-icons">more_vert</span>
                            </button>

                            <div class="dropdown-menu mostrar shadow">
                                <div class="d-flex justify-content-around">
                                    <div style="text-align: center">
                                        <!--<a href="{{route('go.asignaciontecnico',Crypt::encryptString($capacitacion->id))}}" role="button" title="Editar" class="btn-icon btn-icon-dd"><span class="material-icons">edit</span></a>-->
                                        <form action="{{route('go.asignaciontecnico')}}" method="GET">
                                            <input type="hidden" name="proveedor" value="{{$capacitacion->nombre_proveedor}}">
                                            <input type="hidden" name="idasig" value="{{Crypt::encryptString($capacitacion->id)}}">
                                            <button class="btn"><span class="material-icons-round">edit</span></button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </td>
                    </tr>
                    @endforeach
                    @endif
                    @endfor
            </tbody>
            <!-- FIN RESULTADOS -->
        </table>
    </div>
    <!-- FIN TABLA DE RESULTADOS DE BUSQUEDA -->
</div>
@endsection