<?php

namespace App\Http\Controllers\api;


use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Contracts\Encryption\DecryptException;
// use Cinema\Http\Request;
use Session;
use Redirect;
// use Illuminate\Http\Request;

use Crypt;

use App\User;
use App;
use DB;
use Carbon\Carbon;
use Auth;



use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

class api_retiroController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(request $request)
    {
        
        $rules = [
            'nFolio'=> 'numeric|required|digits_between:1,2',
            'nID_Tracker'=> 'numeric|required',
            'sRegion' => 'required|max:100',          
            'sRut' => 'required|max:20',  
            'sCliente' => 'required|max:100',   
            'sDireccion' => 'required|max:100',   
            'sComuna' =>    'required|max:50', 
            'sCiudad' =>    'required|max:50',  
            'sSerie' =>    'required|max:20',  
            'sModelo' =>    'required|max:30',  
            'nContador' =>    'numeric|required|digits_between:1,4',  
            'nContador_color' =>    'digits_between:0,4',  
            'nGuia' =>    'numeric|digits_between:1,4',  
            'sCui' =>    'max:20',  
            'sEstado' =>    'max:20',  
            'sObservacion' =>    'max:500'
         ];


        $messages = [

            'nFolio.required' => ' nFolio Requerido',
            'sRegion.required' => 'sRegion Requerido',
            'sRut.required' => ' sRut Requerido',
            'sCliente.required' => ' sCliente Requerido',
            'sDireccion.required' => ' sDireccion Requerido',
            'sComuna.required' => ' sComuna Requerido',
            'nID_Tracker.required'=> 'nID_Tracker Requerido',
            'sCiudad.required' => ' sCiudad Requerido',
            'sSerie.required' => ' sSerie Requerido',
            'sModelo.required' => ' sModelo Requerido',
            'nContador.required' => ' nContador Requerido'

        ];
        // $validator = \Validator::make($request->all(),$rules,$messages);
        // if ($validator->fails()) {
        //     return [
        //         'created' => false,
        //         'errors'  => $validator->errors()->all()
        //     ];
        // }

        $FechaHoraActual  = Carbon::now();
        $FechaHoraActual = $FechaHoraActual->toDateTimeString();

        if($request->nContador_color != "" || $request->nContador_color != null){
            if(!is_numeric($request->nContador_color)){
                return "la Variable nContador_color debe ser Numerica";
            }
        }
        $buscar =  DB::table('retiros')
             ->where('sSerie','=',$request->sSerie)  ->get();
         if(count($buscar) == 0){
        $retiros = new App\retiros;

        $retiros->tracker_id	 = "2";

        $retiros->nFolio = $request->nFolio;
        $retiros->sRegion = $request->sRegion;
        $retiros->sRut = $request->sRut;
        $retiros->sCliente = $request->sCliente;
        $retiros->sCiudad = $request->sCiudad;
        $retiros->sComuna = $request->sComuna;
        
        $retiros->nID_Tracker = $request->nID_Tracker;
        $retiros->sDireccion = $request->sDireccion;
        $retiros->sSerie = $request->sSerie;
        $retiros->sModelo = $request->sModelo;
        $retiros->nContador = $request->nContador;
        $retiros->nContador_color = $request->nContador_color;
        $retiros->nGuia = $request->nGuia;
        $retiros->sEstado = $request->sEstado;

        $retiros->estado_retiro_Cord = $request->sEstado;

        $retiros->sObservacion = $request->sObservacion;
        $retiros->sCui = $request->sCui;
        $retiros->dFecharegistrado = $FechaHoraActual;
        $retiros->instalador = $request->instalador;
        
        $retiros->timestamps = false;
             $file = fopen("logretiro.txt", "a");

                          fwrite($file, $request . PHP_EOL);

                        

                          fclose($file);
        $retiros->save();

return "OK";
              }else{
              $actualizar_ins =  App\retiros::findOrfail($buscar[0]->id);
               $actualizar_ins->timestamps = false;
            //   $actualizar_ins->sEstado = $request->sEstado;
              $actualizar_ins->sCui = $request->sCui;

                  $file = fopen("logretiro.txt", "a");

                                           fwrite($file, $request . PHP_EOL);

                                         

                                           fclose($file);
              $actualizar_ins->save();
              return "Actualizado";
              }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\api_retiros  $api_retiros
     * @return \Illuminate\Http\Response
     */
    public function show(api_retiros $api_retiros)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\api_retiros  $api_retiros
     * @return \Illuminate\Http\Response
     */
    public function edit(api_retiros $api_retiros)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\api_retiros  $api_retiros
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, api_retiros $api_retiros)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\api_retiros  $api_retiros
     * @return \Illuminate\Http\Response
     */
    public function destroy(api_retiros $api_retiros)
    {
        //
    }
    public function createTemporal(request $request){



        $cantidad_equipos = $request->cantidad_equipos;
        
        for ($i = 1; $i <= $cantidad_equipos; $i++){
            $info_tracker = DB::table('tracker')
            ->where('tracker.tipo_tracker','=',"retiro")
            ->where('tracker.proyecto_id','=',$request->proyectos)
            ->get();

            $retiros = new App\retiros;
            $retiros->tracker_id	 = $info_tracker[0]->id;
            $retiros->sDireccion = $request->sDireccion;
            $retiros->tipo_retiro = "temporal";
            $retiros->estado_retiro_Cord = "asignado";
            $retiros->sObservacion = "SIN OBSERVACION";
            $retiros->dFecharegistrado = $request->fecha_retiro_temporal;
            $retiros->fecha_retiroCord = $request->fecha_retiro_temporal;
            // $retiros->sCliente = "BANCO DE CHILE";
            $retiros->sCliente = $request->clientes_modal;
            $retiros->sSerie = "Revisar Check";
            $retiros->sComuna = "Revisar Check";
            $retiros->nContador = 0;
            $retiros->nContador_color = 0;
            $retiros->nGuia = 0;
            $retiros->timestamps = false;
            $retiros->proveedor_retiro = DB::connection()->getDatabaseName();

            $retiros->save();

            $datos_trabajador = DB::table('trabajadors')        
            ->where('trabajadors.id_login','=',Auth::user()->id)
            ->get();
        

            //TRAER ULTIMO ID DE RETIROS//
            $idretiros = "";
            $datosretiro = DB::select('select id from retiros order by id desc limit 1');
            foreach ($datosretiro as $item){
                $idretiros = $item->id;
            }       

            $asignacion_retiros = new App\asignacion_retiros;
            $asignacion_retiros->estado_asignacion = "tarea_asignada";
            $asignacion_retiros->numero_visita = 1;
            $asignacion_retiros->trabajadors_idtecnico = $request->tecnicoTemporal;
            $asignacion_retiros->trabajadors_id_coordinador = $datos_trabajador[0]->id;
            $asignacion_retiros->fecha_retiro = $request->fecha_retiro_temporal;
            $asignacion_retiros->detalle_costo_id1	 = 1;
            $asignacion_retiros->retiros_id = $idretiros;
            $asignacion_retiros->timestamps= false;
            $asignacion_retiros->save();

            //CONSULTA PARA LOS DATOS DE RETIROS
            $datos_api_retiro = DB::table('retiros')        
            ->where('retiros.id','=',$idretiros)
            ->get();

            $checklist_retiros = new App\checklist_retiros;
            $checklist_retiros->estado_asignacion = "tarea_asignada";
            $checklist_retiros->csDireccion = $datos_api_retiro[0]->sDireccion;
            $checklist_retiros->csObservacion = $datos_api_retiro[0]->sObservacion;
            $checklist_retiros->cdFecharegistrado = $datos_api_retiro[0]->dFecharegistrado;
            $checklist_retiros->asignacion_retiros_id= $asignacion_retiros->id;
            $checklist_retiros->timestamps = false;
            $checklist_retiros->save();
    
        }
        return back();
    }
}
