@extends('menu/menu')

{{-- <script src="https://ajax.aspnetcdn.com/ajax/jQuery/jquery-3.4.1.min.js"></script> --}}




@section('content')

@if ( session('mensaje') )
    <div class="alert alert-success">{{ session('mensaje') }}</div>
@endif


@if ( session('mensaje_error') )

    <div class="alert alert-danger">{{ session('mensaje_error') }}</div>

@endif

{{-- {{$clientes}} --}}



<div class="container mt-5"> 

  <div class="title-vista mt-4">CLIENTES REGISTRADOS</div>

  {{-- BUSCADOR --}}
  <div class="seccion-filtro">Búsqueda por nombre</div> 
  <hr class="separador">

  <form action="{{route('filtro_see_clien')}}" method="GET">
    {{ csrf_field() }}
    <div class="row mb-4">
      <div class="col-sm-4 mx-auto">
        Nombre del Cliente
        <input type="text" name="rut_trabajador"   id="rut_cliente" autocomplete="off"  value="{{@old('Rut Trabajador')}}"  maxlength="10" class="form-control" id="bus_rut" placeholder="Nombre del cliente">
        <div class="" id="listaarrow"></div>
        <input type="text" value="" id="rut_cliente_" name="rut_cliente_" style="display:none">
      </div>
    </div>
    <div class="col-sm-4 mx-auto mb-5">
        @if($opcion != "1")
        <button type="submit" class="btn btn-pill btn-prim btn-block">
        Buscar</button> 
          @else
          <button type="submit" class="btn btn-pill btn-secundario btn-block">
        Ver Todos</button> 
        @endif
    </div>
  </form>

  

  <div class="table-responsive mb-5">
    <table class="table table-striped table-hover" id="mitable">
      <thead class="color-head">
        <tr>
          <th class="th-head border-th separador-v" colspan="2">DATOS</th>
          <th class="th-head border-th separador-v" colspan="2">CONTACTOS</th>
          <th class="th-head border-th separador-v" colspan="3">DIRECCIÓN</th>
          <th class="th-head border-th"><span class="material-icons">
            settings
            </span></th>
        </tr>
        <tr>
          <th class="th-subhead border-th">Razón Social</th>
          <th class="th-subhead border-th separador-v">RUT</th>
          <th class="th-subhead border-th">Teléfono</th>
          <th class="th-subhead border-th separador-v">Correo</th>
          <th class="th-subhead border-th">Región</th>
          <th class="th-subhead border-th">Comuna</th>
          <th class="th-subhead border-th separador-v">Calle</th>
          <th class="th-subhead border-th"></th>
        </tr>
      </thead>
      <tbody>
        @foreach ($clientes as $los_datos)
          <tr>
            <td class="td-val">{{$los_datos->razon_social}}</td>
            <td class="td-val">{{$los_datos->rut}}</td>
            <td class="td-val">{{$los_datos->telefono}}</td>
            <td class="td-val"> {{$los_datos->correo}}</td>
            <td class="td-val">{{$los_datos->des_region}}</td>
            <td class="td-val">{{$los_datos->des_comuna}}</td>
            <td class="td-val"> {{$los_datos->descripcion_direccion}}</td>
            <td class="td-val">
              <form>
                @csrf
                {{-- botones de acciones están dentro del un dropdown--}}
                <div class="dropdown dropleft" style="text-align: center;">
                  <button type="button" class="btn-dropdown" data-toggle="dropdown">
                    <span class="material-icons">more_vert</span>
                  </button>
                  <div class="dropdown-menu mostrar shadow">
                    <div class="d-flex justify-content-around">
                      <a class="show-modal-versucursales btn-icon" title="Ver" data-id_cliente="{{$los_datos->id_cliente}}">
                        <span class="material-icons">visibility</span>
                      </a>
                      <a class="btn-icon btn-icon-dd editar_cliente" title="Editar" data-id_cliente_="{{$los_datos->id_cliente}}">
                        <span class="material-icons">edit</span>
                      </a>
                      <a class="btn-icon btn-icon-dd" title="Eliminar" href="{{route('eliminar.cliente',$los_datos->id_cliente)}}" onclick="return confirm('¿Desea eliminar el registro?')">
                        <span class="material-icons">delete</span>
                      </a>
                    </div>
                  </div>
                </div>
              </form>
            </td>
          </tr>
        @endforeach
      </tbody>
    </table>
  </div>
  



  





  {{--****************************************descarga de los ficheros********************************************************** --}}

  {{-- ******************Modal Editar***************************************** --}}

  <div class="modal fade" id="modal_editar_sucur" role="dialog">
    <div class="modal-dialog  modal-lg">
      <div class="modal-content">
        <div class="modal-header">
            <h4 id="nombre_sucursal"></h4>
          <button type="button" class="close" data-dismiss="modal">&times;</button>
  
        </div>

        <div class="modal-body">       

      <form action="{{route('actualizar.suc')}}" method="POST">
          <div class="container table-responsive">  

        
            @method('PUT')
            @csrf
              <div class="row" > 
        
                <div class="col-sm-3 form-group" >
                    <label for="clientes_s" class="" >Seleccionar cliente</label>                  
                    <select class="form-control" name="clientes" id="clientes_s">
                      {{-- <option value="">Seleccionar</option> --}}
                      @foreach($clientes_2 as $clien)
                      {{-- <option value="{{$region->id}}">{{$region->des_region}}</option> --}}
                      <option value="{{$clien->id}}" {{(old('region')==$clien->id)? 'selected':''}}>{{$clien->razon_social}}</option>
                      @endforeach
                  </select>


                  <input type="text" value="" id="id_dire" name="id_dire" style="display:none" >
                  <input type="text" value="" id="id_sucur" name="id_sucur" style="display:none" >
                  
                </div>
                <div class="col-sm-3">
                  <label for="nombre" class="" >Nombre</label>
                  <input type="text"  name="nombre" id="nombre" class="form-control"  value=""   placeholder="Nombre">

                </div>
                  
                <div class="col-sm-3 form-group" >
                  <label for="telefono" class="" >Teléfono</label>
                  <input type="number" class="form-control" value="{{@old('telefono')}}" id="telefono"  name="telefono"  placeholder="Telefono">
        
                </div>
                <div class="col-sm-3 form-group" >
                  <label for="correo" class="" >Correo</label>
                  <input type="email" class="form-control" name="correo" id="correo" value="{{@old('correo')}}"   change="correo"  placeholder="Correo">
              </div>
            </div>

          <div class="row">
            <div class="col-sm">
                <label for="" class="" >Región</label>

                <select class="form-control" name="region" id="region_usuario">
                  <option value="">Seleccionar</option>
                  @foreach($regiones as $region)
                  {{-- <option value="{{$region->id}}">{{$region->des_region}}</option> --}}
                  <option value="{{$region->id}}" {{(old('region')==$region->id)? 'selected':''}}>{{$region->des_region}}</option>
                  @endforeach
              </select>
            
              </div>
            <div class="col-sm">
                <label for="" class="" >Comuna</label>
              <select class="form-control" name="comuna" id="comuna_usuarios">
                  {{-- <option value="">Seleccionar</option> --}}
                  <option value="">Seleccionar</option>
                  @foreach($comunas as $comuna)
                  <option value="{{$comuna->id}}" {{(old('comuna')==$comuna->id)? 'selected':''}}>{{$comuna->des_comuna}}</option>
                  @endforeach          
                </select>
            </div>
            <div class="col-sm-6">
                <label for="" class="" >Dirección</label>
                <input type="text" name="calle" class="form-control" value="{{@old('calle')}}"  id="calle"   placeholder="Calle">
              </div>                       
          </div>
      </div>
      
          <div class="modal-footer">
            <button type="submit" class="btn btn-success" id="save">Guardar</button>   
          </div>
    </form>      
        </div>
      </div>
    </div>
  </div>
</div>



<!-- Modal -->
<div class="modal fade" id="modal_ver_sucur" role="dialog">
  <div class="modal-dialog  modal-lg">
    <div class="modal-content">
      <div class="modal-header">
          <h4>Sucursales</h4>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
 
      </div>
      <div class="modal-body">       
          <div class="container table-responsive">  
          <table class="table table-bordered table-hover" id="tabla_sucursales_">                             
                  <tbody>
                  </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
</div>




{{-- *************************************************MODAL PARA EDITAR  UN CIENTE******************************************************************************* --}}



<!-- Modal -->
<div class="modal fade" id="modal_editar_cliente" role="dialog">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content">
      
      <!-- Modal Header -->
      <div class="modal-header">
        <div class="seccion-modal">EDITAR CLIENTE</div>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      
      <!-- Modal body -->
      <div class="modal-body">       
        <form action="{{route('actualizar.client')}}" method="POST">
          @method('PUT')
          @csrf

          
          <div class="container-fluid">
            <!-- Control the column width, and how they should appear on different devices -->
            <div class="seccion-modal">Datos personales</div> 
            <hr class="separador">

            <div class="row" > 
              <div class="col-sm-3 form-group" >
                  <label for="razon_social">Razón Social</label>
                  <input type="text" class="form-control mayuscula" name="razon_social_" id="razon_social_" value="" placeholder="Razon Social">
                  <input type="text" value="" id="id_cliente_" name="id_cliente_" style="display:none">
                  <input type="text" value="" id="id_direccion_" name="id_direccion_" style="display:none">
              </div>

              <div class="col-sm-3">
                <label for="rut">Rut</label>
                <input type="text"  name="rut" id="rut" class="form-control mayuscula" maxlength="10" value="18795022-8"  change="guion,v_rut"  placeholder="Rut">
              </div>
                
              <div class="col-sm-3 form-group" >
                <label for="telefono" class="" >Teléfono</label>
                <input type="number" class="form-control mayuscula" value="" id="telefono_"  name="telefono_"  placeholder="Telefono">

              </div>
              <div class="col-sm-3 form-group" >
                <label for="correo" class="" >Correo</label>
                <input type="email" class="form-control" name="correo_" id="correo_" value=""   change="correo"  placeholder="Correo">
              </div>

              <div class="col-sm-3">
                <label for="rut" class="">Proveedor</label>
                <select required class="custom-select mb-3 mayuscula" name="nombre_proveedor" id="nombre_proveedor">
                  @foreach($proveedores as $datos)
                  <option value="{{$datos->nombre_proveedor }}">{{$datos->nombre_proveedor}}</option>
                  @endforeach
              </select>
              </div>
            </div>
          
            <div class="seccion-modal">Dirección</div> 
            <hr class="separador">

            <div class="row">
              <div class="col-sm-3">
                <label for="">Región</label>
                <select class="form-control mayuscula" name="region_" id="region_usuario_">
                  @foreach($regiones as $region)
                    <option value="{{$region->id}}" {{(old('region')==$region->id)? 'selected':''}}>{{$region->des_region}}</option>
                  @endforeach
                </select>
              </div>

              <div class="col-sm-3">
                <label for="">Comuna</label>
                <select class="form-control mayuscula" name="comuna_" id="comuna_usuarios_">
                  @foreach($comunas as $comuna)
                    <option value="{{$comuna->id}}" {{(old('comuna')==$comuna->id)? 'selected':''}}>{{$comuna->des_comuna}}</option>
                  @endforeach            
                </select>
              </div>

              <div class="col-sm-6">
                  <label for="" class="" >Calle</label>
                  <input type="text" name="calle_" id="calle_" class="form-control" value="{{@old('calle')}}"    placeholder="Calle">
              </div>
                         
            </div><br>

            <!-- Modal footer -->
            <div class="text-center mb-5 mt-5">
              <button type="submit" class="btn btn-pill btn-prim pl-5 pr-5">Guardar edición</button>  
            </div>
          </div>
        </form> 
            
      
            {{-- fin del div.container.fluid --}}
      </div>
    </div>
  </div>
</div>

  </div>
</div>

@endsection
 


{{-- ****************************************************** --}}

<script src="{{ asset('js/jquery-3.4.1.min.js') }}" ></script>

<script>

$(document).ready(function(){


 // *********************************************************

  
 $('#rut_cliente').keyup(function(){ 
          var query = $(this).val();
        //  if(query != '')
          //{
           var _token = $('input[name="_token"]').val();
           $.ajax({
             
            url:"{{ route('autocomplete.fetchnombrecliente') }}",
            method:"POST",
            data:{query:query, _token:_token},
            success:function(data){
              console.log(data);
             $('#listaarrow').fadeIn();  
                      $('#listaarrow').html(data);
            }
           });
        //  }


          
      });
  
      $(document).on('click', 'li', function(){  
          $('#rut_cliente').val($(this).text());  
          $('#listaarrow').fadeOut();  
           
           $("#rut_cliente_").val($(this).attr("data-rut"));

      });  

  //     $(".add_id").click(function(){
	//     alert('Evento click sobre un button con class="add_id"');
	// });
// *********************************************************


$('#bus_rut').on('input', function() {
      var valor = $("#bus_rut").val().replace('.','');
     valor = valor.replace('-','');
     cuerpo = valor.slice(0,-1);
     dv = valor.slice(-1).toUpperCase();
     rut= cuerpo + '-'+ dv;
     $("#bus_rut").val(rut);
     });

})

function buscar_datos_cliente(id_cli){

// alert(id_cli);

// $("#razon_social_").val("prueba");
      // $('#modal_editar_cliente').modal('show');
      $.ajax({

        headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
        type: 'get',
        url: 'bus_car_cliente',
        data: {'id_cli': id_cli},
        success: function(data) {

          $("#razon_social_").val(data[0]['razon_social']);
          $("#telefono_").val(data[0]['telefono']);
          $("#correo_").val(data[0]['correo']);
          $("#rut").val(data[0]['rut']);
          $("#calle_").val(data[0]['descripcion_direccion']);
          $("#id_cliente_").val(data[0]['id_cliente']);
          $("#id_direccion_").val(data[0]['id_direccion']);
          // $('#nombre_proveedor').attr( "checked" ):
          // proveedor_nombre .attr( "checked" ): checked
          $('#nombre_proveedor').prepend("<option selected value='"+data[0]['proveedor_nombre']+"' >"+data[0]['proveedor_nombre']+"</option>");
          $('#comuna_usuarios_').prepend("<option selected value='"+data[0]['id_comuna']+"' >"+data[0]['des_comuna']+"</option>");
           $('#region_usuario_').prepend("<option selected value='"+data[0]['id_region']+"' >"+data[0]['des_region']+"</option>")
          
          $('#modal_editar_cliente').modal('show');
          
            console.log(data);

      },
      error: function(xhr, status) {
          alert('Disculpe, ha ocurrido un problema, intente mas tarde');
          console.log(xhr);
      }
      
      });

}


function editar_sucursal(id_sucursal){


  // $("#modal_ver_sucur").modal('hide');//ocultamos el modal
  // $("#modal_editar_sucur").modal('show');


  $.ajax({

        headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
        type: 'get',
        url: 'edit_sucursal',
        data: {'id_suc': id_sucursal},
        success: function(data) {
               $("#modal_ver_sucur").modal('hide');//ocultamos el modal
               
               $("#nombre_sucursal").text(data[0]['nombre']);
               $("#nombre").val(data[0]['nombre']);
               $("#telefono").val(data[0]['telefono']);
               $("#correo").val(data[0]['correo']);
               $("#calle").val(data[0]['descripcion_direccion']);
               $("#id_dire").val(data[0]['id_direccion']);
               $("#id_sucur").val(data[0]['id_sucursal']);

               $('#comuna_usuarios').prepend("<option selected value='"+data[0]['id_comuna']+"' >"+data[0]['des_comuna']+"</option>");
               $('#region_usuario').prepend("<option selected value='"+data[0]['id_region']+"' >"+data[0]['des_region']+"</option>");
               $('#clientes_s').prepend("<option selected value='"+data[0]['id_cliente_ban']+"' >"+data[0]['razon_social']+"</option>");

              //  clientes_s
              $("#modal_editar_sucur").modal('show');
                console.log(data['nombre']);
               console.log(data);
        },
        error: function(xhr, status) {
            alert('Disculpe, ha ocurrido un problema, intente mas tarde');
            console.log(xhr);
        }

        });

}


    // ******************************************************

    function eliminar_sucursal(id_suc){
        

        var x = confirm("¿Está seguro de eliminar este cliente?");
  if (x){

            $.ajax({

                headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
                type: 'get',
                url: 'delete_sucursal',
                data: { 'id_suc': id_suc },
                success: function(data) {
                    console.log(data);
                    alert(data)
                    $("#modal_ver_sucur").modal('hide');//ocultamos el modal
                },
                error: function(xhr, status) {
                    alert('Disculpe, ha ocurrido un problema, intente mas tarde');
                }

            });


      return true;
  }else{
    return false;
  }




     


    }
// **********************************************************

function buscar_sucursas(id_cliente){

    // alert(id_cliente);


    $.ajax({

headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },

type: 'get',

url: 'buscar_sucursal',

data: { 'id_cliente': id_cliente },

success: function(data) {

    // alert(data);
    $(tabla_sucursales_).empty();
    console.log(data);
    $(tabla_sucursales_).append(data);

    $('#modal_ver_sucur').modal('show');
  


},

error: function(xhr, status) {

    alert('Disculpe, ha ocurrido un problema, intente mas tarde');

}

});

}//fin de la funcio


// *****************************************
$(document).ready(function(){

    $(".show-modal-versucursales").click(function(){
      
      var cliente_id = $(this).attr("data-id_cliente");    
      buscar_sucursas(cliente_id);
      });


     
      $(".editar_cliente").click(function(){
        var cliente_id = $(this).attr("data-id_cliente_");


       
        buscar_datos_cliente(cliente_id);

      });


});//fin del document click



function guardar_editar(){

  $.ajax({

        headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },

        type: 'get',

        url: 'update_sucursal',

        data: { 'id_cliente': id_cliente },

        success: function(data) {
        
   
        
        },

        error: function(xhr, status) {
        
            alert('Disculpe, ha ocurrido un problema, intente mas tarde');
        
        }

        });
}

// ************************************************




function confirmation() 

{

   if(confirm("¿Desea continuar?"))

{

return true;

}

else

{

return false;

}

}

function agregar_id(id){
//alert(id);
//$("#rut_cliente_").val(id);
}




</script>
