@extends('menu/menu')


<script src="{{ asset('js/jquery-3.4.1.min.js') }}" ></script>
<script src="https://files.codepedia.info/files/uploads/iScripts/html2canvas.js"></script>

<style>
    .mostrar {
      display: none;
    
    }
    @media (max-width: 768px) {
        .mostrar {
        display: block;
      }
    }
    </style>


@section('content')
@if ( session('mensaje') )
    <div class="alert alert-success">{{ session('mensaje') }}</div>
@endif

@if ( session('mensaje_error') )
    <div class="alert alert-danger">{{ session('mensaje_error') }}</div>
@endif

@if(count($informacion_retiro) == 0)
    <div class="alert alert-danger">Sin Datos</div>
@endif

<div class="container mt-5">
    <div class="title-vista mt-4 d-flex justify-content-between">
        ESTADO DE EQUIPO
        <div class="mostrar-contenido">
            <a href="javascript: history.go(-1)">
                <span class="material-icons-round icon-midle">arrow_back</span>
                Volver
            </a>
         </div>
    </div>
</div>

<form action="{{route('filtro.estadoequipo' )}} " method="get" id="4" name="primero">
    @csrf

    <div class="container">
        <div class="seccion-filtro">Firltrar por</div> 
        <hr class="separador">

        <!-- BARRA DE BUSQUEDA -->
        <div class="row">
    
            <div class="col-sm-3 form-group">
                <label for="datepicker">Proyecto asociado</label>
                <select name="proyectos" class="custom-select mayuscula">
                    <option value="" selected>Selecione</option>
                    @if(!empty($proyectos))
                        @foreach ($proyectos   as $los_datos)
                            <option value="{{$los_datos->id}}">{{$los_datos->nombre  }}  </option>
                        @endforeach
                    @endif
                </select>
            </div>
        
            <!--AQUI SE CARGA EL SELECT DE ESTADO-->
            <div class="col-sm-3 form-group">
                <label for="estado">Serie</label>
                <input type="text" name="serie" id=""  class="form-control mayuscula">
            </div>
            <!--FIN SELECT DE ESTADO-->
        
        </div>
        <!--AQUI SE CARGA EL SELECT DE CLIENTE-->
        <div class="text-center mb-5 mt-5">
            <button type="buscar" class="btn btn-pill btn-prim w-25" value="BUSCAR" id="uno" name="uno"> Buscar </button>
        </div>
        <!-- FIN BARRA DE BUSQUEDA -->
    </div>
</form>




       

            
<form action="{{route('save.equipoRetiro' )}} " method="POST" enctype="multipart/form-data" >
    @csrf

    <!-- BARRA DE BUSQUEDA -->
    <div class="container mt-5 mb-5">
          
        <!-- Detalle del Cliente -->
        <div class="seccion-filtro">Detalle del cliente</div> 
        <hr class="separador">

        <div class="row">
            <!-- Fila 2 ------------------------------------------------------>
           <div class="col-sm-3 form-group">
                <label for="">Cliente</label>
                <input type="" class="form-control mayuscula" id="" placeholder="Cliente"    value="{{$informacion_retiro[0]->sCliente ?? ''}}" name="cliente">
                @error('cliente')
                    <div class="alert alert-danger">{{ $message }}</div>
                @enderror
            </div>       

            <!-- Fila 3 ------------------------------------------------------>
            <div class="col-sm-3 form-group">
                <label for="">Dirección</label>
                <input type="" class="form-control mayuscula" id=""  placeholder="Dirección" value="{{$informacion_retiro[0]->sDireccion ?? ''}}" name="direccion">
                @error('direccion')
                    <div class="alert alert-danger">{{ $message }}</div>
                @enderror
            </div>

            <div class="col-sm-3 form-group">
                <label for="">Comuna</label>
                <input type="" class="form-control mayuscula" id="" placeholder="Comuna" value="{{$informacion_retiro[0]->sComuna ?? ''}}" name="sComuna">
                @error('sComuna')
                    <div class="alert alert-danger">{{ $message }}</div>
                @enderror
            </div>

            <div class="col-sm-3 form-group">
                <label for="">CUI o Código Sucursal</label>
                <input type="" class="form-control mayuscula" id="" placeholder="SC"   value="{{$informacion_retiro[0]->sCui ?? ''}}" name="sCui">
                @error('sCui')
                    <div class="alert alert-danger">{{ $message }}</div>
                @enderror
            </div>

            <!-- Fila 4 ------------------------------------------------------>
            <div class="col-sm-3 form-group">
                <label for="">Ubicación</label>
                <input type="" class="form-control mayuscula" id=""  placeholder="Ubicación" value="{{@old('ubicacion')}}" name="ubicacion">
                @error('ubicacion')
                    <div class="alert alert-danger">{{ $message }}</div>
                @enderror
            </div>

            <div class="col-sm-3 form-group">
                <label for="">Piso</label>
                <input type="text" class="form-control mayuscula" id="" placeholder="Piso" name="piso"  value="{{@old('piso')}}">
                @error('piso')
                    <div class="alert alert-danger">{{ $message }}</div>
                @enderror
            </div>
        </div>
            
        <!-- Detalle de Equipamiento -->
        <div class="seccion-filtro">Detalle de equipamiento</div> 
        <hr class="separador">

        <div class="row">
            <!-- Fila 5 ------------------------------------------------------>
            <div class="col-sm-3 form-group">
                <label for="">Serie</label>
                <input type="" class="form-control mayuscula" id="" placeholder="Serie"  value="{{$informacion_retiro[0]->sSerie ?? ''}}" name="sSerie">
                @error('sSerie')
                    <div class="alert alert-danger">{{ $message }}</div>
                @enderror
            </div>

            <div class="col-sm-3 form-group">
                <label for="">Modelo</label>
                <input type="" class="form-control mayuscula" id="" placeholder="Modelo"  value="{{$informacion_retiro[0]->sModelo ?? ''}}" name="sModelo">
                @error('sModelo')
                    <div class="alert alert-danger">{{ $message }}</div>
                @enderror
            </div>

            <div class="col-sm-3 form-group">
                <label for="">Contador B/N</label>
                <input type="number"  onKeyPress="return soloNumeros(event)" class="form-control mayuscula" id="" placeholder="Contador B/N" value="{{$informacion_retiro[0]->nContador ?? ''}}" name="nContador">
                @error('nContador')
                    <div class="alert alert-danger">{{ $message }}</div>
                @enderror
             </div>

             <div class="col-sm-3 form-group">
                <label for="">Contador color</label>
                <input type="number"  onKeyPress="return soloNumeros(event)" class="form-control mayuscula" id="" placeholder="Contador color" value="{{$informacion_retiro[0]->nContador_color ?? ''}}" name="nContador_color">
                @error('nContador_color')
                    <div class="alert alert-danger">{{ $message }}</div>
                @enderror
            </div>
        </div>
               
        
        <div class="seccion-filtro">Accesorios</div> 
        <hr class="separador">     
        
        @if ( session('mensaje_error_accesorios') )
            <div class="alert alert-danger">{{ session('mensaje_error_accesorios') }}</div>
        @endif

        <!-- Accsesorios -->
        <div class="row">
            <!-- FILA 8.1 -->
            <div class="col-md-2 form-group checkbox">
                <input type="checkbox" id="bandeja_adicional" name="bandeja_adicional"  value="si" {{ (! empty(old('bandeja_adicional')) ? 'checked' : '') }}>
                <label for="bandeja_adicional">Bandeja adicional</label>
            </div>

            <div class=" col-sm-2 form-group">
                <input type="checkbox" id="mueble" name="mueble"  value="si" {{ (! empty(old('bandeja_adicional')) ? 'checked' : '') }}>
                <label for="mueble">Mueble</label>
            </div>

            <div class=" col-sm-2 form-group">
                <input type="checkbox" id="kit_lector" name="kit_lector"  value="si" {{ (! empty(old('kit_lector')) ? 'checked' : '') }}>
                <label for="kit_lector">Kit lector</label>
            </div>

            <div class=" col-sm-2 form-group">
                <input type="checkbox" id="memoria_sd" name="memoria_sd"   value="si" {{ (! empty(old('memoria_sd')) ? 'checked' : '') }}>
                <label for="memoria_sd">Memoria SD</label>
            </div>
            
            <div class="col-sm-2 form-group checkbox">
                <input type="checkbox" id="cable_red" name="cable_red"   value="si" {{ (! empty(old('cable_red')) ? 'checked' : '') }}>
                <label for="cable_red">Cable red</label>
            </div>
                            
            <div class="col-sm-2 form-group checkbox">
                <input type="checkbox" id="cable_poder" name="cable_poder"   value="si" {{ (! empty(old('cable_poder')) ? 'checked' : '') }}>
                <label for="cable_poder">Cable de poder</label>
            </div>
        </div>    
                   
                           
        <div class="row mt-5">
            <div class="col-sm-12 form-group">
                <input class="custom-file mayuscula" type="file" id="cargafoto1" name="cargafoto1">
            </div>    
        </div>           
                        
               
        <div class="row">
            <div class="col-sm-12 form-group">
                <label for="cambio">Observaciones</label>
                <textarea class="form-control" id="observaciones" name="observaciones" rows="4"></textarea>
            </div>
        </div>               
             
    
        <div class="text-center mb-5 mt-5">               
            <button class="btn btn-prim w-25" type="submit">Guardar</button>
        </div>
   
    </div>
</form>
       

<!-- FIN BARRA DE BUSQUEDA -->

    <!-- MODAL IMAGENES -->
    <div class="modal fade" id="modal_historial_retiros" role="dialog">
      <div class="modal-dialog  modal-lg">
        <div class="modal-content">
          <div class="modal-header">
              <h1 style="margin-top: 50px">CARGA DE IMAGEN DE RETIRO</h1>
            <button type="button" class="close" data-dismiss="modal">&times;</button>
          </div>
          <div class="modal-body">
          
                               <div class="container-fluid">
                                    <form enctype="multipart/form-data" id="formuploadajax" method="post">
                                        @csrf

                                                <div class="container rounded-lg">
                                                    <!-- CARGA DE IMAGEN DE RETIRO -->
                                                    
                                                        <div class="row reex" style="height: auto">
                                                            <input type="text" style="display:none" name="check_listRetiro" id="" value="">


                                                            <div class="container col-12" style="margin-top: 10px">
                                                                <h2><strong>Adjunte la imagen que se solicita a continuación</strong></h2>
                                                            </div>
                                                        
                                                            <!-- 1 -->
                                                            <div class="container col-sm-12 form-group" style="margin-top: 10px">
                                                            <label for="" class="espacio_carga_img"><h2>Fotografía de la página de estado</h2></label>
                                                                <input type="file" id="cargafoto1" name="cargafoto1">
                                                            </div>
                                                            
                                                        </div>
                                                        
                                                        <!-- FIN CARGA DE IMAGEN DE RETIRO -->
                                                    </div>
                                                    
                                                    
                                                    <div class="container form-group">
                                                            <br>
                                                            <button class="btn btn-cancelar float-sm-right guardar btn-rechazar" type="button">CANCELAR</button>
                                                            <button class="btn btn-subir-img float-sm-right btn-conf"  style="margin-right:10px;" type="submit">SUBIR IMÁGENES</button>
                                                        </div>
                                    </form>
                                   
                                   
                               </div>
                              
               
        </div>
      </div>
    </div>
 </div>


@endsection
 <script>
    var lineas = [];


function borrar(){
        
        // Creamos nuestro canvas
        var canvas = document.getElementById("pizarra");
        var ctx = canvas.getContext("2d");
        
        // Borramos el ÃƒÂ¡rea que nos interese
        ctx.clearRect(0, 0, canvas.width, canvas.height);
    //    console.log(lineas);
        lineas = [];
    
    }

$(function(){
  
  var element = $("#pizarra"); // global variable
  var getCanvas; // global variable

        function downloadURI(uri, name) {
          var link = document.createElement("a");
          link.download = name;
          link.href = uri;

        }
  html2canvas(element, {
   onrendered: function (canvas) {
                             getCanvas = canvas;
   }
  });


 

  //======================================================================
      // VARIABLES
      //======================================================================
      let miCanvas = document.querySelector('#pizarra');
   
      let correccionX = 0;
      let correccionY = 0;
      let pintarLinea = false;

      let posicion = miCanvas.getBoundingClientRect()
      correccionX = posicion.x;
      correccionY = posicion.y;

      miCanvas.width = 250;
      miCanvas.height = 250;

      //======================================================================
      // FUNCIONES
      //======================================================================

      /**
       * Funcion que empieza a dibujar la linea
       */
      function empezarDibujo () {
          pintarLinea = true;
          lineas.push([]);
      };

      /**
       * Funcion dibuja la linea
       */
      function dibujarLinea (event) {
          event.preventDefault();
          if (pintarLinea) {
              let ctx = miCanvas.getContext('2d')
              // Estilos de linea
              ctx.lineJoin = ctx.lineCap = 'round';
              ctx.lineWidth = 5;
              // Color de la linea
              ctx.strokeStyle = '#000';
              // Marca el nuevo punto
              let nuevaPosicionX = 0;
              let nuevaPosicionY = 0;
              if (event.changedTouches == undefined) {
                  // Versión ratón
                  nuevaPosicionX = event.layerX;
                  nuevaPosicionY = event.layerY;
              } else {
                  // Versión touch, pantalla tactil
                  nuevaPosicionX = event.changedTouches[0].pageX - correccionX;
                  nuevaPosicionY = event.changedTouches[0].pageY - correccionY;
              }
              // Guarda la linea
              lineas[lineas.length - 1].push({
                  x: nuevaPosicionX,
                  y: nuevaPosicionY
              });
              // Redibuja todas las lineas guardadas
              ctx.beginPath();
              lineas.forEach(function (segmento) {
                  ctx.moveTo(segmento[0].x, segmento[0].y);
                  segmento.forEach(function (punto, index) {
                      ctx.lineTo(punto.x, punto.y);
                  });
              });
              ctx.stroke();
          }
      }

      /**
       * Funcion que deja de dibujar la linea
       */
      function pararDibujar () {
          pintarLinea = false;
      }

      //======================================================================
      // EVENTOS
      //======================================================================

      // Eventos raton
      miCanvas.addEventListener('mousedown', empezarDibujo, false);
      miCanvas.addEventListener('mousemove', dibujarLinea, false);
      miCanvas.addEventListener('mouseup', pararDibujar, false);

      // Eventos pantallas táctiles
      miCanvas.addEventListener('touchstart', empezarDibujo, false);
      miCanvas.addEventListener('touchmove', dibujarLinea, false);
  
 
  
  
  //$("#formCanvas").on("submit", function(e){

 
 // });
  
  
  
    });
    function guardandofirna(){ 


 
      
      url_img =document.getElementById("pizarra").toDataURL('image/png');

    $("#imagen_firma").val(url_img);
   
     // var formData = new FormData(document.getElementById("formCanvas"));
     var _token = $('input[name="_token"]').val();

        var imagen_firma = $("#imagen_firma").val();
        var check = $("#check").val();
        //alert(imagen);
       // alert(id);

   //   formData.append("dato", url_img);
      //formData.append(f.attr("name"), $(this)[0].files[0]);
      $.ajax({
        headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },

          url:"{{ route('guardarfirmaretiro') }}",
          type: "post",
          //dataType: "html",
          data: {'imagen_firma': imagen_firma,'check': check},

        //   cache: false,
        //   contentType: false,
        //   processData: false,
           success: function(response) {
                      alert(response);
           },
          error: function(xhr, status) {
              alert('Disculpe, ha ocurrido un problema, intente mas tarde');
          }
      })
          .done(function(res){
       //    alert("error");
          });
     }

 $(document).ready(function(){

      //////////////////////////////////////////////////////
      $("#formuploadajax").on("submit", function(e){
            e.preventDefault();
            var f = $(this);
            var formData = new FormData(document.getElementById("formuploadajax"));
            formData.append("dato", "valor");
            //formData.append(f.attr("name"), $(this)[0].files[0]);
            $.ajax({
				url:"{{ route('save.imagenchecklistRetiro') }}",
				type: "post",
                dataType: "html",
                data: formData,
                cache: false,
                contentType: false,
	     		processData: false,
				 success: function(response) { 

					 console.log(response);


					 $("#mensaje-text").text("Imagenes Guardadas");
					 alert("imagenes guardadas");
                       $("#modal_historial_retiros").modal('hide');
				 }
            })
                .done(function(res){
                    $("#mensaje").html("Respuesta: " + res);
                });
        });
                   
    

   $('.asignarimagen').click(function() {
         
         $("#modal_historial_retiros").modal('show');
    });

    //funcion para cambiar los tres estados
    $("#mueble").data('checked', 0).on('click', function() {
      el = $(this);
      tres_estados(el,'mueble');
    });
    $("#cable_poder").data('checked', 0).on('click', function() {
      el = $(this);
      tres_estados(el,'cable_poder');
    });
    $("#cable_red").data('checked', 0).on('click', function() {
      el = $(this);
      tres_estados(el,'cable_red');
    });
    $("#memoria_sd").data('checked', 0).on('click', function() {
      el = $(this);
      tres_estados(el,'memoria_sd');
    });
    $("#kit_lector").data('checked', 0).on('click', function() {
      el = $(this);
      tres_estados(el,'kit_lector');
    });
    $("#equipo_ensamblado").data('checked', 0).on('click', function() {
      el = $(this);
      tres_estados(el,'equipo_ensamblado');
    });
    $("#negarse_firma").data('checked', 0).on('click', function() {
      el = $(this);
      tres_estados(el,'negarse_firma');
    });
    $("#bandeja_adicional").data('checked', 0).on('click', function() {
      el = $(this);
      tres_estados(el,'bandeja_adicional');
    });
 
    
    
 })

 //funciones individuales

 function tres_estados(el, id_chec) {

switch (el.data('checked')) {

	case 0: //cehckeado
		el.data('checked', 1);
		el.prop('indeterminate', false);
		el.prop('checked', true);

		var valor2 = id_chec;

		var valor =$("#observaciones").text();



		$("#observaciones").text(valor.replace(" sin "+id_chec+',',""));

		//  console.log('true');
		break;


	case 1:
		el.data('checked', 2);
		el.prop('indeterminate', true);
		el.prop('checked', true);

		var valor2 = id_chec;

		var valor =$("#observaciones").text();

		valor+=" sin "+valor2+',';

		$("#observaciones").text(valor);



		//console.log('null');
		$("#" + id_chec).val("no");

	
		break;


	default:
		el.data('checked', 0);
		el.prop('indeterminate', false);
		el.prop('checked', false);
		//console.log('false');

		var valor2 = id_chec;

		var valor =$("#observaciones").text();


		$("#observaciones").text(valor.replace(" sin "+id_chec+',',""));
}
}
function soloNumeros(e){

var key = window.Event ? e.which : e.keyCode
return (key >= 48 && key <= 57)
}
 </script>

