<?php

namespace App\Http\Controllers\checklist;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App;

use Illuminate\Support\Facades\Storage;

use App\direccion;

use App\persona;

use App\User;

use Auth;
use Session;

use DateTime;
use DateInterval;
use DatePeriod;

use DB;

use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Carbon\Carbon;


class EstadoEquipoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(request $request)
    {


        $informacion_retiro = DB::table('proyectos')
        ->join('tracker','tracker.proyecto_id','=','proyectos.id')
        ->join('retiros','retiros.tracker_id','=','tracker.id')

        ->where('proyectos.id', '=',$request->proyectos)
        ->where('retiros.sSerie', '=',$request->serie)
        ->select('retiros.nFolio','retiros.sRegion','retiros.sCliente','retiros.sCiudad','retiros.sComuna'
                ,'retiros.sDireccion','retiros.sSerie','retiros.sModelo','retiros.nContador_color',
                'retiros.nContador','retiros.nGuia','retiros.sCui','proyectos.nombre')

        ->get();

        $proyectos = DB::table('proyectos') ->select('proyectos.id','proyectos.nombre')
        ->where('proyectos.estado','=',1)
          ->where('proyectos.id','!=',1)
        ->orderBy('proyectos.id', 'asc')
        ->get();


        return view('check.EstadoEquipoRetiros',compact('informacion_retiro','proyectos'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(request $request)
    {



        $rules = [

            'cliente' => 'required',
            'direccion' => 'required',
            'sComuna' => 'required',
            'sCui' => 'required',
            'ubicacion' => 'required',
            'piso' => 'required',
            'sSerie' => 'required',
            'sModelo' => 'required',
            'nContador' => 'required',
            'nContador_color' => 'required',

        ];


    //     $this->validate($request, $rules);


    //    if (empty($request->bandeja_adicional) || empty($request->mueble) || empty($request->kit_lector)
    //    || empty($request->memoria_sd) || empty($request->cable_red) || empty($request->cable_poder)) {
    //           return back()->with('mensaje_error_accesorios', 'MA');
    //     }





        $datos_trabajador = DB::table('trabajadors')
        ->where('trabajadors.id_login','=',Auth::user()->id)
        ->get();







        $verificacion_estados = new  App\verificacion_estados;
        $verificacion_estados->sCliente	 = $request->cliente;
        $verificacion_estados->sComuna	 = $request->sComuna;
        $verificacion_estados->sDireccion	 = $request->direccion;
        $verificacion_estados->sSerie	 = $request->sSerie;
        $verificacion_estados->sModelo	 = $request->sModelo;
        $verificacion_estados->nContador = $request->mueble;
        $verificacion_estados->nContador_color	 = $request->nContador_color;
        $verificacion_estados->sObservacion = $request->observaciones;
        $verificacion_estados->sCui	 = $request->sCui;
        $verificacion_estados->Spiso = $request->piso;
        $verificacion_estados->Subicacion = $request->ubicacion;
        $verificacion_estados->bandeja_adicional = $request->bandeja_adicional;
        $verificacion_estados->mueble = $request->mueble;
        $verificacion_estados->kit_lector = $request->kit_lector;
        $verificacion_estados->memoria_sd = $request->memoria_sd;
        $verificacion_estados->cable_red = $request->cable_red;
        $verificacion_estados->cable_poder = $request->cable_poder;
        $verificacion_estados->trabajadors_id = $datos_trabajador[0]->id  ;


        $verificacion_estados->timestamps = false;
        $verificacion_estados->save();




        $file = $request->file('cargafoto1');

        //obtenemos el nombre del archivo
        $nombre =  time()."_".$file->getClientOriginalName();
        $extencion =  time()."_".$file->getClientOriginalExtension();
        //sacamos la exxtencion por medio de _
        $extencionArray = explode("_", $extencion);
        $nombreGuardar1 = "f1_".$verificacion_estados->id.".".$extencionArray[1];
          //indicamos que queremos guardar un nuevo archivo en el disco local
          \Storage::disk('fotos_sistema_check')->put("foto_estado_equipo/".$nombreGuardar1,  \File::get($file));

        //$verificacion_estados->save();


        $actualizar_estado =  App\verificacion_estados::findOrfail($verificacion_estados->id);
        $actualizar_estado->url_foto =  "foto_estado_equipo/".$nombreGuardar1;

        //generamos el pdf' automaticamente enviandole los datos del formulario
        \PDF::setOptions(['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true])
            ->loadView('check.pdf.pdfEstadoEquipoRetiro', compact('actualizar_estado') )
            ->save(storage_path('app/public/pdfEstadoRetiro/') . $verificacion_estados->id.'estadoretiro.pdf')
            ->stream();

            $actualizar_estado->url_pdf = $verificacion_estados->id."estadoretiro.pdf";

            $actualizar_estado->timestamps = false;
            $actualizar_estado->save();


        return back()->with('mensaje', 'Agregado Con Exito');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
    public function CordinadoraEstadoEquipo()
    {
        //

        $datos = DB::table('verificacion_estados')
        ->join('trabajadors','trabajadors.id','=','verificacion_estados.trabajadors_id')
        ->join('personas','personas.id','=','trabajadors.id_persona')
        ->select(
            'personas.nombre_uno',
            'personas.apellido_uno',
            'personas.apellido_dos'
        ,'verificacion_estados.sCui',
        'verificacion_estados.sCliente',
        'verificacion_estados.sComuna',
        'verificacion_estados.sDireccion',
        'verificacion_estados.Subicacion',
        'verificacion_estados.Spiso',
        'verificacion_estados.url_pdf'
        )
        ->where('trabajadors.estado','=','1')
        ->get();

        return view('check.CordinadoraEstadoEquipo',compact('datos'));
    }

    public function detallepdf(){

        return \PDF::setOptions(['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true])
            ->loadView('check.pdf.pdfEstadoEquipoRetiro' )
            ->stream();

    }
    //funcion para descargar los pdf asociados a estado equipo
   public function getDownload($url_pdf)
   {

       $file= storage_path('app/public/pdfEstadoRetiro/').$url_pdf.".pdf";

       return response()->download($file);
   }


}
