<?php

namespace App\Http\Controllers\api;

use DB;
use GuzzleHttp\Client;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Crypt;
use GuzzleHttp\Exception\RequestException;
use Carbon\Carbon;
use DateTime;
use App;
use Illuminate\Support\Facades\Mail;
use App\Mail\TestMail;
use Illuminate\Support\Facades\Storage;
//use Illuminate\Support\Facades\Http;
class ConsumirInstalaccionController extends Controller
{
   public function sendEmail($h_Inicio, $client, $contacto, $direccion, $comuna, $region, $tipoVisita, $descripcionCliente, $sc, $nSerie, $modelo, $contadorBn, $contadorC, $estadoOpcion, $estadoInstalacion, $observacionTecnico, $proveedor, $size, $idasig)
   {
      $details = [
         'hora_inicio' =>  $h_Inicio,
         'cliente' => $client,
         'contacto' => $contacto,
         'direccion' => $direccion,
         'comuna' => $comuna,
         'region' => $region,
         'tipo_visita' => $tipoVisita,
         'descripcion_cliente' => $descripcionCliente,
         'sc' => $sc,
         'numero_serie' => $nSerie,
         'modelo' => $modelo,
         'contador_bn' => $contadorBn,
         'contador_color' => $contadorC,
         'estado_opcion' => $estadoOpcion,
         'estado_instalacion' => $estadoInstalacion,
         'observacion_tecnico' => $observacionTecnico,
         'size' => $size,
         'proveedor' => $proveedor,
         'idasig' => $idasig
      ];

      if (strtolower($proveedor) == "comtecglobal") {
         $destinatario = ["fvera@comtecglobal.cl","lnavarrete@comtecglobal.cl"];
         Mail::to($destinatario)->send(new TestMail($details,$sc,$nSerie,$size));
      } elseif (strtolower($proveedor) == "kyocera") {
      }
      return "ok";
   }
   /**
    * Display a listing of the resource.
    *
    * @return \Illuminate\Http\Response
    */
   public function index($idasig)
   {

      try {
         $id_asignacion = Crypt::decryptString($idasig);
      } catch (DecryptException $e) {
         //
         return "No Puede Realizar Esta Accion";
      }
      $mi_asignacion = DB::table('asignacion_instalacions')
         ->where('asignacion_instalacions.id', '=', $id_asignacion)
         ->get();

      $id_trabajador = $mi_asignacion[0]->trabajadors_id;

      $datos_asignacion = DB::table('asignacion_instalacions')
         ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
         ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
         ->join('softwares', 'softwares.id', '=', 'checklist_instalacions.softwares_id')
         ->join('tipo_conexiones', 'tipo_conexiones.id', '=', 'checklist_instalacions.tipo_conexiones_id')
         ->join('nombre_servidores', 'nombre_servidores.id', '=', 'checklist_instalacions.nombre_servidores_id')
         ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
         ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
         ->select(
            'checklist_instalacions.Csdireccion',
            'checklist_instalacions.Cscliente',
            'asignacion_instalacions.estado_asignacion',
            'asignacion_instalacions.fecha_instalacion',
            'asignacion_instalacions.id',
            'asignacion_instalacions.numero_visita',
            'asignacion_instalacions.tipos_visitas_id',
            'asignacion_instalacions.opcion_estado_instalacion',
            'checklist_instalacions.Csdireccion',
            'checklist_instalacions.Cscomuna',
            'checklist_instalacions.Cscui',
            'checklist_instalacions.Cspiso',
            'checklist_instalacions.Csmarca',
            'checklist_instalacions.CsMarca_es',
            'checklist_instalacions.CsSerie_es',
            'checklist_instalacions.CsModelo_es',
            'checklist_instalacions.CsTipoequipo_es',
            'checklist_instalacions.CsContador_es',
            'checklist_instalacions.CsContadorcolor_es',
            'checklist_instalacions.Cscambio_serie',
            'checklist_instalacions.Csserie_remplazo',
            'checklist_instalacions.Csmodelo_remplazo',
            'checklist_instalacions.modo_U253',
            'checklist_instalacions.ins_driver',
            'checklist_instalacions.equipo_operativo',
            'checklist_instalacions.Csregion',
            'checklist_instalacions.Csciudad',
            'checklist_instalacions.Csrut',
            'checklist_instalacions.Cnfolio',
            'checklist_instalacions.CsSerie',
            'checklist_instalacions.CsModelo',
            'checklist_instalacions.Csn_contacto',
            'checklist_instalacions.Cstipo_sucursal',
            'checklist_instalacions.CUsb_red',
            'checklist_instalacions.CDriver',
            'checklist_instalacions.Cscontacto',
            'checklist_instalacions.CsSC',
            'asignacion_instalacions.lista_instalacion_id as id_instalacion',
            'checklist_instalacions.CsIP',
            'checklist_instalacions.CsGateway',
            'checklist_instalacions.CsMsk',
            'checklist_instalacions.CsMac',
            'checklist_instalacions.CdFecha_plan_despacho',
            'checklist_instalacions.CdFecha_despacho',
            'checklist_instalacions.CnGuia',
            'checklist_instalacions.CsEstado_despacho',
            'checklist_instalacions.CdFecha_instalacion',
            'checklist_instalacions.CsEstado_instalacion',
            'checklist_instalacions.CnContador',
            'checklist_instalacions.CnContador_color',
            'checklist_instalacions.id as id_checklist',
            'softwares.descripcion as nombre_software',
            'tipo_conexiones.descripcion as nombre_conexion',
            'nombre_servidores.descripcion as nombre_servidor',
            'personas.nombre_uno as nombrepersona',
            'personas.nombre_dos as nombrepe',
            'personas.apellido_uno as apellidouno',
            'personas.apellido_dos as apellidodos',
            'checklist_instalacions.CsObservacion',
            'checklist_instalacions.observacion',
            'checklist_instalacions.CsBandeja_adicional',
            'checklist_instalacions.CsMueble',
            'checklist_instalacions.CsKit_lector',
            'checklist_instalacions.CsSD',
            'checklist_instalacions.CsCable_poder',
            'checklist_instalacions.CsCable_red',
            'checklist_instalacions.Csconexion_electrica',
            'checklist_instalacions.Csservidor_impresion',
            'checklist_instalacions.Csservidor_impresion',
            'checklist_instalacions.Csconfig_smb',
            'checklist_instalacions.Csconfig_email',
            'checklist_instalacions.Cscantidad_usuarios',
            'checklist_instalacions.firma_contacto',
            'checklist_instalacions.observacion',
            'checklist_instalacions.url_firma',
            'checklist_instalacions.tipo_equipo',
            'checklist_instalacions.fecha_inicio',
            'checklist_instalacions.fecha_fin',
            'checklist_instalacions.motivo',
            'checklist_instalacions.nombre_contactoF',
            'checklist_instalacions.rut_contactoF',
            'trabajadors.id as id_trabajador',
            'instalacions.nID_Tracker',
            'instalacions.fecha_instalacion_coordinadora',
            'instalacions.proveedor_instalacion',
            'instalacions.sRegion',
            'instalacions.i_opcion_estado_instalacion',
         )
         ->where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
         ->where('asignacion_instalacions.id', '=', $id_asignacion)
         ->orderBy('asignacion_instalacions.id', 'desc')
         ->get();

      //agregar consultar para gnerar pdf
      $datos_trabajador = DB::table('trabajadors')
         ->where('trabajadors.id', '=', $datos_asignacion[0]->id_trabajador)
         ->get();

      $firmatrabajador = DB::table('firma_clientes')
         ->where('firma_clientes.id_tecnico', '=', $datos_trabajador[0]->id_login)
         ->get();
         

      //encontramos el nombre del proyecto asociado al checklist de instalacion
      $id_instalacion = $datos_asignacion[0]->id_instalacion;
      $proyecto_asociado = DB::table('instalacions')
         ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
         ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
         ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
         ->select('proyectos.nombre', 'clientes.razon_social', 'proyectos.url_logo', 'proyectos.proveedor_nombre')
         ->where('instalacions.id', '=', $id_instalacion)
         ->get();

      // modal foto traer imagenes.
      $fotos = DB::table('fotos_check_instalacions')
         ->where('fotos_check_instalacions.checklist_instalacion_id', '=', $datos_asignacion[0]->id_checklist)
         ->get();

      $tipo_visita = App\tipos_visitas::findOrfail($datos_asignacion[0]->tipos_visitas_id);

      $fecha_uno = $datos_asignacion[0]->CdFecha_plan_despacho;

      if ($fecha_uno == "") {
         $newDate = "1900-01-01";
      } else {
         $newDate = $datos_asignacion[0]->CdFecha_plan_despacho;
      }

      $fecha_dos = $datos_asignacion[0]->CdFecha_despacho;
      if ($fecha_dos == "") {
         $newdate2 = "1900-01-01";
      } else {
         $fecha_dos = $datos_asignacion[0]->CdFecha_despacho;
      }

      $fecha_tres = $datos_asignacion[0]->CdFecha_instalacion;
      $newdate3 = date("yymd", strtotime($fecha_tres));

      //sacar datos para generar nombre pdf
      $CsSerie = "";
      $Csserie_remplazo = $datos_asignacion[0]->Csserie_remplazo;
      if($Csserie_remplazo == ""){
         $CsSerie = $datos_asignacion[0]->CsSerie;
      }else{
         $CsSerie = $datos_asignacion[0]->Csserie_remplazo;
      }
      $id_para_pdf = $datos_asignacion[0]->id;

      $dato11 = $datos_asignacion[0]->nID_Tracker;
      //validacion de datos
      $nId_Solicitud = $datos_asignacion[0]->nID_Tracker;

      if ($datos_asignacion[0]->nID_Tracker == null) {
         $nId_Solicitud = "";
      } else {
         $nId_Solicitud = $datos_asignacion[0]->nID_Tracker;
      }
      if ($datos_asignacion[0]->Cnfolio == null) {
         $nFolio = "";
      } else {
         $nFolio = $datos_asignacion[0]->Cnfolio;
      }
      if ($datos_asignacion[0]->Csregion == null) {
         $sRegion = "";
      } else {
         $sRegion = $datos_asignacion[0]->Csregion;
      }
      if ($datos_asignacion[0]->Csrut == null) {
         $sRut = "";
      } else {
         $sRut = $datos_asignacion[0]->Csrut;
      }
      if ($datos_asignacion[0]->Cscliente == null) {
         $sCliente = "";
      } else {
         $sCliente = $datos_asignacion[0]->Cscliente;
      }
      if ($datos_asignacion[0]->Csdireccion == null) {
         $sDireccion = "";
      } else {
         $sDireccion = $datos_asignacion[0]->Csdireccion;
      }
      if ($datos_asignacion[0]->Cspiso == null) {
         $sPiso = "";
      } else {
         $sPiso = $datos_asignacion[0]->Cspiso;
      }
      if ($datos_asignacion[0]->Cscomuna == null) {
         $sComuna = "";
      } else {
         $sComuna = $datos_asignacion[0]->Cscomuna;
      }
      if ($datos_asignacion[0]->Csciudad == null) {
         $sCiudad = "";
      } else {
         $sCiudad = $datos_asignacion[0]->Csciudad;
      }
      if ($datos_asignacion[0]->Cscui == null) {
         $sCui = "";
      } else {
         $sCui = $datos_asignacion[0]->Cscui;
      }
      if ($datos_asignacion[0]->Cstipo_sucursal == null) {
         $sTipo_sucursal = "";
      } else {
         $sTipo_sucursal = $datos_asignacion[0]->Cstipo_sucursal;
      }
      if ($datos_asignacion[0]->Cscontacto == null) {
         $sContacto = "";
      } else {
         $sContacto = $datos_asignacion[0]->Cscontacto;
      }
      if ($datos_asignacion[0]->Csn_contacto == null) {
         $sN_contacto = "";
      } else {
         $sN_contacto = $datos_asignacion[0]->Csn_contacto;
      }
      if ($datos_asignacion[0]->CsSerie == null) {
         $sSerie = "";
      } else {
         $sSerie = $datos_asignacion[0]->CsSerie;
      }
      if ($datos_asignacion[0]->CsModelo == null) {
         $sModelo = "";
      } else {
         $sModelo = $datos_asignacion[0]->CsModelo;
      }
      if ($datos_asignacion[0]->CUsb_red == null) {
         $sUsb_red = "";
      } else {
         $sUsb_red = $datos_asignacion[0]->CUsb_red;
      }
      if ($datos_asignacion[0]->CDriver == null) {
         $sDriver = "";
      } else {
         $sDriver = $datos_asignacion[0]->CDriver;
      }
      if ($datos_asignacion[0]->CsSC == null) {
         $sSC = "";
      } else {
         $sSC = $datos_asignacion[0]->CsSC;
      }
      if ($datos_asignacion[0]->CsIP == null) {
         $sIP = "";
      } else {
         $sIP = $datos_asignacion[0]->CsIP;
      }
      if ($datos_asignacion[0]->CsMsk == null) {
         $sMsk = "";
      } else {
         $sMsk = $datos_asignacion[0]->CsMsk;
      }
      if ($datos_asignacion[0]->CsGateway == null) {
         $sGateway = "";
      } else {
         $sGateway = $datos_asignacion[0]->CsGateway;
      }
      if ($datos_asignacion[0]->CsMac == null) {
         $CsMac = "";
      } else {
         $CsMac = $datos_asignacion[0]->CsMac;
      }
      if ($datos_asignacion[0]->CsBandeja_adicional == null) {
         $CsBandeja_adicional = "";
      } else {
         $CsBandeja_adicional = $datos_asignacion[0]->CsBandeja_adicional;
      }
      if ($datos_asignacion[0]->CsMueble == null) {
         $CsMueble = "";
      } else {
         $CsMueble = $datos_asignacion[0]->CsMueble;
      }
      if ($datos_asignacion[0]->CsKit_lector == null) {
         $CsKit_lector = "";
      } else {
         $CsKit_lector = $datos_asignacion[0]->CsKit_lector;
      }
      if ($datos_asignacion[0]->CsCable_poder == null) {
         $CsCable_poder = "";
      } else {
         $CsCable_poder = $datos_asignacion[0]->CsCable_poder;
      }
      if ($datos_asignacion[0]->CsSD == null) {
         $CsSD = "";
      } else {
         $CsSD = $datos_asignacion[0]->CsSD;
      }
      if ($datos_asignacion[0]->CsCable_red == null) {
         $CsCable_red = "";
      } else {
         $CsCable_red = $datos_asignacion[0]->CsCable_red;
      }
      if ($datos_asignacion[0]->CnGuia == null) {
         $CnGuia = 0;
      } else {
         $CnGuia = $datos_asignacion[0]->CnGuia;
      }
      if ($datos_asignacion[0]->CsEstado_despacho == null) {
         $CsEstado_despacho = "";
      } else {
         $CsEstado_despacho = $datos_asignacion[0]->CsEstado_despacho;
      }
      if ($datos_asignacion[0]->CnContador == null) {
         $CnContador = "0";
      } else {
         $CnContador = $datos_asignacion[0]->CnContador;
      }
      if ($datos_asignacion[0]->CnContador_color == null) {
         $CnContador_color = "0";
      } else {
         $CnContador_color = $datos_asignacion[0]->CnContador_color;
      }
      if ($datos_asignacion[0]->CsEstado_instalacion == null) {
         $CsEstado_instalacion = "";
      } else {
         $CsEstado_instalacion = $datos_asignacion[0]->CsEstado_instalacion;
      }
      if ($datos_asignacion[0]->CsObservacion == null) {
         $CsObservacion = "";
      } else {
         $CsObservacion = $datos_asignacion[0]->CsObservacion;
      }


      $proveedor = $datos_asignacion[0]->proveedor_instalacion;
      //Solo para kyocera
      // if($proveedor == "kyocera" || $proveedor == "Kyocera" || $proveedor == "KYOCERA"){
      try {
         if ($proveedor == "kyocera" || $proveedor == "Kyocera" || $proveedor == "KYOCERA") {
            $client = new Client([
               // Base URI is used with relative requests
               'base_uri' => 'http://190.153.241.162:3017/wsaya/',
               // You can set any number of default request options.
               'timeout'  => 2.0,
            ]);

            $response = $client->request('GET', 'updatetrackerinsbchile', [

               'form_params' => [
                  'api_key' => 'v3r1z0l4ll3v4',
                  "data" => [
                     "nId_Solicitud" => $datos_asignacion[0]->nID_Tracker,  //No existe
                     "nFolio" => $datos_asignacion[0]->Cnfolio,
                     "sRegion" => $datos_asignacion[0]->sRegion,
                     "sRut" => $datos_asignacion[0]->Csrut,
                     "sCliente" => $datos_asignacion[0]->Cscliente,
                     "sDireccion" => $datos_asignacion[0]->Csdireccion,
                     "sPiso" => $datos_asignacion[0]->Cspiso,
                     "sComuna" => $datos_asignacion[0]->Cscomuna,
                     "sCiudad" => $datos_asignacion[0]->Csciudad,
                     "sCui" => $datos_asignacion[0]->Cscui,
                     "sTipo_sucursal" => $datos_asignacion[0]->Cstipo_sucursal,
                     "sContacto" => $datos_asignacion[0]->Cscontacto,
                     "sN_contacto" => $datos_asignacion[0]->Csn_contacto,
                     "sSerie" => $datos_asignacion[0]->CsSerie,
                     "sModelo" => $datos_asignacion[0]->CsModelo,
                     "sUsb_red" => $datos_asignacion[0]->CUsb_red,
                     "sDriver" => $datos_asignacion[0]->CDriver,
                     "sSC" => $datos_asignacion[0]->CsSC,
                     "sIP" => $datos_asignacion[0]->CsIP,
                     "sMsk" => $datos_asignacion[0]->CsMsk,
                     "sGateway" => $datos_asignacion[0]->CsGateway,
                     "sMac" => $datos_asignacion[0]->CsMac,
                     "sBandeja_adicional" => $datos_asignacion[0]->CsBandeja_adicional,
                     "sMueble" => $datos_asignacion[0]->CsMueble,
                     "sKit_lector" => $datos_asignacion[0]->CsKit_lector,
                     "sCable_poder" => $datos_asignacion[0]->CsCable_poder,
                     "sSD" => $datos_asignacion[0]->CsSD,
                     "sCable_red" => $datos_asignacion[0]->CsCable_red,
                     "dFecha_plan_despacho" => $newDate,
                     "dFecha_despacho" => $newdate2,
                     "nGuia" => $datos_asignacion[0]->CnGuia,
                     "sEstado_despacho" => $datos_asignacion[0]->CsEstado_despacho,
                     "dFecha_instalacion" => $datos_asignacion[0]->fecha_instalacion_coordinadora,
                     "nContador" => $datos_asignacion[0]->CnContador,
                     "nContador_color" => $datos_asignacion[0]->CnContador_color,
                     "sEstado_instalacion" => $datos_asignacion[0]->i_opcion_estado_instalacion,
                     "sObservacion" => $datos_asignacion[0]->observacion
                  ]

               ]


            ]);
         }
         $datos_accesorios = DB::table('checklist_accesorios')
            ->join('accesorios', 'accesorios.id', '=', 'checklist_accesorios.id_accesorio')
            ->select('accesorios.id', 'accesorios.articulo', 'accesorios.descripcion', 'checklist_accesorios.cantidad', 'checklist_accesorios.serie_parte')
            ->where('checklist_accesorios.id_checklist_instalacion', '=', $datos_asignacion[0]->id_checklist)
            ->get();

         $accesorios_dañados = DB::table('checklist_accesorios_dañados')
            ->join('accesorios', 'accesorios.id', '=', 'checklist_accesorios_dañados.id_accesorio')
            ->select('accesorios.id', 'accesorios.descripcion', 'accesorios.articulo', 'checklist_accesorios_dañados.cantidad', 'checklist_accesorios_dañados.serie_parte')
            ->where('checklist_accesorios_dañados.id_checklist_instalacion', '=', $datos_asignacion[0]->id_checklist)
            ->get();

         $accesorios_manuales = DB::table('accesorios_manuales')
            ->where('accesorios_manuales.id_checklist_instalacion', '=', $datos_asignacion[0]->id_checklist)
            ->get();

         $instalacion_accesorios = DB::table('checklist_instalacion_accesorios')
            ->join('accesorios', 'accesorios.id', '=', 'checklist_instalacion_accesorios.id_accesorio')
            ->select('accesorios.id', 'accesorios.descripcion', 'accesorios.articulo', 'checklist_instalacion_accesorios.cantidad', 'accesorios.id as ID', 'checklist_instalacion_accesorios.serie_parte')
            ->where('checklist_instalacion_accesorios.id_checklist_instalacion', '=', $datos_asignacion[0]->id_checklist)
            ->get();

         $instalacion_accesorios_manuales = DB::table('instalacion_accesorios_manuales')
            ->where('instalacion_accesorios_manuales.id_checklist_instalacion', '=', $datos_asignacion[0]->id_checklist)
            ->get();

         $fotos_accesorios = DB::table('fotos_checks_accesorios')
            ->where('checklist_instalacion_id', '=', $datos_asignacion[0]->id_checklist)
            ->get();

         // $var = json_decode($response->getBody()->getContents());
         \PDF::setOptions((['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true]))
            ->loadView('check/pdf.pdfInstalacionCoordinadora', compact('instalacion_accesorios_manuales', 'instalacion_accesorios', 'accesorios_manuales', 'datos_asignacion', 'tipo_visita', 'proyecto_asociado', 'fotos', 'firmatrabajador', 'datos_accesorios', 'accesorios_dañados', 'fotos_accesorios'))
            ->save(storage_path('app/public/pdfinstalacion/') . $CsSerie . 'instalacion.pdf')
            ->stream();

         $buscar_asignacion = App\asignacion_instalacions::where('id', '=', $id_para_pdf)->first();
         $buscar_asignacion->estado_asignacion     =  "finalizado";
         $buscar_asignacion->url_pdf = $CsSerie . "instalacion.pdf";
         $buscar_asignacion->timestamps = false;
         $buscar_asignacion->save();

         $id_para_estado = $buscar_asignacion->lista_instalacion_id;
         $cambioestado = App\instalacions::where('id', '=', $id_para_estado)->first();
         $cambioestado->sEstado_instalacion = "finalizado";
         $cambioestado->timestamps = false;
         $cambioestado->save();

         $check_ = App\checklist_instalacions::where('asignacion_instalacion_retiro_id', '=', $buscar_asignacion->id)->first();;
         $check_->estado_inicio = "finalizado";
         $check_->timestamps = false;
         $check_->save();

         /**DATOS CORREO */
         $client = $datos_asignacion[0]->Cscliente;
         $contacto = $datos_asignacion[0]->nombre_contactoF;
         $direccion = $datos_asignacion[0]->Csdireccion;
         $comuna = $datos_asignacion[0]->Cscomuna;
         $region = $datos_asignacion[0]->Csregion;
         $tipo_visita = $tipo_visita->descripcion;
         $descripcionCliente = $datos_asignacion[0]->observacion;
         $sc = "";
         $nSerie = $datos_asignacion[0]->CsSerie;
         $modelo = $datos_asignacion[0]->CsModelo;
         $contadorBn = $datos_asignacion[0]->CnContador;
         $contadorC = $datos_asignacion[0]->CnContador_color;
         $estadoOpcion = $datos_asignacion[0]->opcion_estado_instalacion;
         $estadoInstalacion = "FINALIZADO";
         $observacionTecnico = $datos_asignacion[0]->observacion;
         $fecha_inicio = date_create($datos_asignacion[0]->fecha_inicio);
         $fecha_inicio = date_format($fecha_inicio, "d-m-Y H:i:s");
         $fecha_fin = date_create($datos_asignacion[0]->fecha_fin);
         $fecha_fin = date_format($fecha_fin, "d-m-Y H:i:s");
         $proveedor = $datos_asignacion[0]->proveedor_instalacion;
         $idasig = $id_asignacion;
         $size = Storage::size('public/pdfinstalacion/' . $CsSerie . 'instalacion.pdf');

         $url = session('url_cordinadora');
         $correo = $this->sendEmail($fecha_inicio, $client, $contacto, $direccion, $comuna, $region, $tipo_visita, $descripcionCliente, $sc, $nSerie, $modelo, $contadorBn, $contadorC, $estadoOpcion, $estadoInstalacion, $observacionTecnico, $proveedor, $size, $idasig);
         if (!empty($url)) {
            return redirect($url)->with('mensaje', 'Respuestas Enviada a Kyocera');
         } else {
            return redirect('/home')->with('mensaje_error', 'Respuestas Enviada a Kyocera');
         }


         dd($response->getBody()->getContents());
      } catch (RequestException $e) {
         echo Psr7\str($e->getRequest());
         if ($e->hasResponse()) {
            echo Psr7\str($e->getResponse());
         }
      }
      // dd($response->getBody()->getContents());
      // return json_decode($response->getBody()->getContents());
   }

   /**
    * Show the form for creating a new resource.
    *
    * @return \Illuminate\Http\Response
    */
   public function regenerar($idasig)
   {

      try {
         $id_asignacion = Crypt::decryptString($idasig);
      } catch (DecryptException $e) {
         //
         return "No Puede Realizar Esta Accion";
      }
      $mi_asignacion = DB::table('asignacion_instalacions')
         ->where('asignacion_instalacions.id', '=', $id_asignacion)
         ->get();

      $id_trabajador = $mi_asignacion[0]->trabajadors_id;

      $datos_asignacion = DB::table('asignacion_instalacions')
         ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
         ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
         ->join('softwares', 'softwares.id', '=', 'checklist_instalacions.softwares_id')
         ->join('tipo_conexiones', 'tipo_conexiones.id', '=', 'checklist_instalacions.tipo_conexiones_id')
         ->join('nombre_servidores', 'nombre_servidores.id', '=', 'checklist_instalacions.nombre_servidores_id')
         ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
         ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')

         ->select(
            'checklist_instalacions.Csdireccion',
            'checklist_instalacions.Cscliente',
            'asignacion_instalacions.estado_asignacion',
            'asignacion_instalacions.fecha_instalacion',
            'asignacion_instalacions.id',
            'asignacion_instalacions.numero_visita',
            'asignacion_instalacions.tipos_visitas_id',
            'checklist_instalacions.Csdireccion',
            'checklist_instalacions.Cscomuna',
            'checklist_instalacions.Cscui',
            'checklist_instalacions.Cspiso',
            'checklist_instalacions.Csmarca',
            'checklist_instalacions.CsMarca_es',
            'checklist_instalacions.CsSerie_es',
            'checklist_instalacions.CsModelo_es',
            'checklist_instalacions.CsTipoequipo_es',
            'checklist_instalacions.CsContador_es',
            'checklist_instalacions.CsContadorcolor_es',
            'checklist_instalacions.Cscambio_serie',
            'checklist_instalacions.Csserie_remplazo',
            'checklist_instalacions.Csmodelo_remplazo',
            'checklist_instalacions.modo_U253',
            'checklist_instalacions.ins_driver',
            'checklist_instalacions.equipo_operativo',
            'checklist_instalacions.Csregion',
            'checklist_instalacions.Csciudad',
            'checklist_instalacions.Csrut',
            'checklist_instalacions.Cnfolio',
            'checklist_instalacions.CsSerie',
            'checklist_instalacions.CsModelo',
            'checklist_instalacions.Csn_contacto',
            'checklist_instalacions.Cstipo_sucursal',
            'checklist_instalacions.CUsb_red',
            'checklist_instalacions.CDriver',
            'checklist_instalacions.Cscontacto',
            'checklist_instalacions.CsSC',
            'asignacion_instalacions.lista_instalacion_id as id_instalacion',
            'checklist_instalacions.CsIP',
            'checklist_instalacions.CsGateway',
            'checklist_instalacions.CsMsk',
            'checklist_instalacions.CsMac',
            'checklist_instalacions.CdFecha_plan_despacho',
            'checklist_instalacions.CdFecha_despacho',
            'checklist_instalacions.CnGuia',
            'checklist_instalacions.CsEstado_despacho',
            'checklist_instalacions.CdFecha_instalacion',
            'checklist_instalacions.CsEstado_instalacion',

            'checklist_instalacions.CnContador',
            'checklist_instalacions.CnContador_color',
            'checklist_instalacions.id as id_checklist',
            'softwares.descripcion as nombre_software',
            'tipo_conexiones.descripcion as nombre_conexion',
            'nombre_servidores.descripcion as nombre_servidor',
            'personas.nombre_uno as nombrepersona',
            'personas.nombre_dos as nombrepe',
            'personas.apellido_uno as apellidouno',
            'personas.apellido_dos as apellidodos',
            'checklist_instalacions.CsObservacion',
            'checklist_instalacions.observacion',

            'checklist_instalacions.CsBandeja_adicional',
            'checklist_instalacions.CsMueble',
            'checklist_instalacions.CsKit_lector',
            'checklist_instalacions.CsSD',
            'checklist_instalacions.CsCable_poder',
            'checklist_instalacions.CsCable_red',
            'checklist_instalacions.Csconexion_electrica',
            'checklist_instalacions.Csservidor_impresion',
            'checklist_instalacions.Csservidor_impresion',
            'checklist_instalacions.Csconfig_smb',
            'checklist_instalacions.Csconfig_email',
            'checklist_instalacions.Cscantidad_usuarios',
            'checklist_instalacions.firma_contacto',
            'checklist_instalacions.observacion',
            'checklist_instalacions.url_firma',
            'checklist_instalacions.tipo_equipo',
            'checklist_instalacions.fecha_inicio',
            'checklist_instalacions.fecha_fin',
            'trabajadors.id as id_trabajador',
            'checklist_instalacions.nombre_contactoF',
            'checklist_instalacions.rut_contactoF',
            'checklist_instalacions.motivo',
            'instalacions.nID_Tracker',
            'instalacions.fecha_instalacion_coordinadora',
            'instalacions.proveedor_instalacion',
            'instalacions.sRegion',
            'instalacions.i_opcion_estado_instalacion',

         )
         ->where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
         ->where('asignacion_instalacions.id', '=', $id_asignacion)
         ->orderBy('asignacion_instalacions.id', 'desc')
         ->get();

      //agregar consultar para gnerar pdf
      $datos_trabajador = DB::table('trabajadors')
         ->where('trabajadors.id', '=', $datos_asignacion[0]->id_trabajador)
         ->get();

      // $firmatrabajador = DB::table('firma_clientes')
      //    ->where('firma_clientes.id_tecnico', '=', $datos_trabajador[0]->id_login) 124
      //    ->get();
      $firmatrabajador = DB::table('firma_clientes')
      ->where('firma_clientes.id_tecnico', '=', $datos_trabajador[0]->id) 
      ->get();

      //encontramos el nombre del proyecto asociado al checklist de instalacion
      $id_instalacion = $datos_asignacion[0]->id_instalacion;
      $proyecto_asociado = DB::table('instalacions')
         ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
         ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
         ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
         ->select('proyectos.nombre', 'clientes.razon_social', 'proyectos.url_logo', 'proyectos.proveedor_nombre')
         ->where('instalacions.id', '=', $id_instalacion)
         ->get();


      // modal foto traer imagenes.
      $fotos = DB::table('fotos_check_instalacions')
         ->where('fotos_check_instalacions.checklist_instalacion_id', '=', $datos_asignacion[0]->id_checklist)
         ->get();



      $tipo_visita = App\tipos_visitas::findOrfail($datos_asignacion[0]->tipos_visitas_id);



      $fecha_uno = $datos_asignacion[0]->CdFecha_plan_despacho;


      if ($fecha_uno == "") {
         $newDate = "1900-01-01";
      } else {
         $newDate = $datos_asignacion[0]->CdFecha_plan_despacho;
      }



      $fecha_dos = $datos_asignacion[0]->CdFecha_despacho;
      if ($fecha_dos == "") {
         $newdate2 = "1900-01-01";
      } else {
         $fecha_dos = $datos_asignacion[0]->CdFecha_despacho;
      }



      $fecha_tres = $datos_asignacion[0]->CdFecha_instalacion;
      $newdate3 = date("yymd", strtotime($fecha_tres));

      //sacar datos para generar nombre pdf
      $CsSerie = $datos_asignacion[0]->CsSerie;
      $id_para_pdf = $datos_asignacion[0]->id;

      $dato11 = $datos_asignacion[0]->nID_Tracker;
      //validacion de datos
      $nId_Solicitud = $datos_asignacion[0]->nID_Tracker;


      if ($datos_asignacion[0]->nID_Tracker == null) {
         $nId_Solicitud = "";
      } else {
         $nId_Solicitud = $datos_asignacion[0]->nID_Tracker;
      }

      if ($datos_asignacion[0]->Cnfolio == null) {
         $nFolio = "";
      } else {
         $nFolio = $datos_asignacion[0]->Cnfolio;
      }

      if ($datos_asignacion[0]->Csregion == null) {
         $sRegion = "";
      } else {
         $sRegion = $datos_asignacion[0]->Csregion;
      }

      if ($datos_asignacion[0]->Csrut == null) {
         $sRut = "";
      } else {
         $sRut = $datos_asignacion[0]->Csrut;
      }
      if ($datos_asignacion[0]->Cscliente == null) {
         $sCliente = "";
      } else {
         $sCliente = $datos_asignacion[0]->Cscliente;
      }
      if ($datos_asignacion[0]->Csdireccion == null) {
         $sDireccion = "";
      } else {
         $sDireccion = $datos_asignacion[0]->Csdireccion;
      }
      if ($datos_asignacion[0]->Cspiso == null) {
         $sPiso = "";
      } else {
         $sPiso = $datos_asignacion[0]->Cspiso;
      }
      if ($datos_asignacion[0]->Cscomuna == null) {
         $sComuna = "";
      } else {
         $sComuna = $datos_asignacion[0]->Cscomuna;
      }
      if ($datos_asignacion[0]->Csciudad == null) {
         $sCiudad = "";
      } else {
         $sCiudad = $datos_asignacion[0]->Csciudad;
      }
      if ($datos_asignacion[0]->Cscui == null) {
         $sCui = "";
      } else {
         $sCui = $datos_asignacion[0]->Cscui;
      }
      if ($datos_asignacion[0]->Cstipo_sucursal == null) {
         $sTipo_sucursal = "";
      } else {
         $sTipo_sucursal = $datos_asignacion[0]->Cstipo_sucursal;
      }
      if ($datos_asignacion[0]->Cscontacto == null) {
         $sContacto = "";
      } else {
         $sContacto = $datos_asignacion[0]->Cscontacto;
      }
      if ($datos_asignacion[0]->Csn_contacto == null) {
         $sN_contacto = "";
      } else {
         $sN_contacto = $datos_asignacion[0]->Csn_contacto;
      }
      if ($datos_asignacion[0]->CsSerie == null) {
         $sSerie = "";
      } else {
         $sSerie = $datos_asignacion[0]->CsSerie;
      }
      if ($datos_asignacion[0]->CsModelo == null) {
         $sModelo = "";
      } else {
         $sModelo = $datos_asignacion[0]->CsModelo;
      }
      if ($datos_asignacion[0]->CUsb_red == null) {
         $sUsb_red = "";
      } else {
         $sUsb_red = $datos_asignacion[0]->CUsb_red;
      }
      if ($datos_asignacion[0]->CDriver == null) {
         $sDriver = "";
      } else {
         $sDriver = $datos_asignacion[0]->CDriver;
      }
      if ($datos_asignacion[0]->CsSC == null) {
         $sSC = "";
      } else {
         $sSC = $datos_asignacion[0]->CsSC;
      }
      if ($datos_asignacion[0]->CsIP == null) {
         $sIP = "";
      } else {
         $sIP = $datos_asignacion[0]->CsIP;
      }
      if ($datos_asignacion[0]->CsMsk == null) {
         $sMsk = "";
      } else {
         $sMsk = $datos_asignacion[0]->CsMsk;
      }
      if ($datos_asignacion[0]->CsGateway == null) {
         $sGateway = "";
      } else {
         $sGateway = $datos_asignacion[0]->CsGateway;
      }
      if ($datos_asignacion[0]->CsMac == null) {
         $CsMac = "";
      } else {
         $CsMac = $datos_asignacion[0]->CsMac;
      }
      if ($datos_asignacion[0]->CsBandeja_adicional == null) {
         $CsBandeja_adicional = "";
      } else {
         $CsBandeja_adicional = $datos_asignacion[0]->CsBandeja_adicional;
      }
      if ($datos_asignacion[0]->CsMueble == null) {
         $CsMueble = "";
      } else {
         $CsMueble = $datos_asignacion[0]->CsMueble;
      }
      if ($datos_asignacion[0]->CsKit_lector == null) {
         $CsKit_lector = "";
      } else {
         $CsKit_lector = $datos_asignacion[0]->CsKit_lector;
      }
      if ($datos_asignacion[0]->CsCable_poder == null) {
         $CsCable_poder = "";
      } else {
         $CsCable_poder = $datos_asignacion[0]->CsCable_poder;
      }
      if ($datos_asignacion[0]->CsSD == null) {
         $CsSD = "";
      } else {
         $CsSD = $datos_asignacion[0]->CsSD;
      }
      if ($datos_asignacion[0]->CsCable_red == null) {
         $CsCable_red = "";
      } else {
         $CsCable_red = $datos_asignacion[0]->CsCable_red;
      }
      if ($datos_asignacion[0]->CnGuia == null) {
         $CnGuia = 0;
      } else {
         $CnGuia = $datos_asignacion[0]->CnGuia;
      }
      if ($datos_asignacion[0]->CsEstado_despacho == null) {
         $CsEstado_despacho = "";
      } else {
         $CsEstado_despacho = $datos_asignacion[0]->CsEstado_despacho;
      }
      if ($datos_asignacion[0]->CnContador == null) {
         $CnContador = "0";
      } else {
         $CnContador = $datos_asignacion[0]->CnContador;
      }
      if ($datos_asignacion[0]->CnContador_color == null) {
         $CnContador_color = "0";
      } else {
         $CnContador_color = $datos_asignacion[0]->CnContador_color;
      }
      if ($datos_asignacion[0]->CsEstado_instalacion == null) {
         $CsEstado_instalacion = "";
      } else {
         $CsEstado_instalacion = $datos_asignacion[0]->CsEstado_instalacion;
      }
      if ($datos_asignacion[0]->CsObservacion == null) {
         $CsObservacion = "";
      } else {
         $CsObservacion = $datos_asignacion[0]->CsObservacion;
      }


      $proveedor = $datos_asignacion[0]->proveedor_instalacion;

      $datos_accesorios = DB::table('checklist_accesorios')
         ->join('accesorios', 'accesorios.id', '=', 'checklist_accesorios.id_accesorio')
         ->select('accesorios.id', 'accesorios.articulo', 'accesorios.descripcion', 'checklist_accesorios.cantidad', 'checklist_accesorios.serie_parte')
         ->where('checklist_accesorios.id_checklist_instalacion', '=', $datos_asignacion[0]->id_checklist)
         ->get();

      $accesorios_dañados = DB::table('checklist_accesorios_dañados')
         ->join('accesorios', 'accesorios.id', '=', 'checklist_accesorios_dañados.id_accesorio')
         ->select('accesorios.id', 'accesorios.descripcion', 'accesorios.articulo', 'checklist_accesorios_dañados.cantidad', 'checklist_accesorios_dañados.serie_parte')
         ->where('checklist_accesorios_dañados.id_checklist_instalacion', '=', $datos_asignacion[0]->id_checklist)
         ->get();
      $accesorios_manuales = DB::table('accesorios_manuales')
         ->where('accesorios_manuales.id_checklist_instalacion', '=', $datos_asignacion[0]->id_checklist)
         ->get();

      $instalacion_accesorios = DB::table('checklist_instalacion_accesorios')
         ->join('accesorios', 'accesorios.id', '=', 'checklist_instalacion_accesorios.id_accesorio')
         ->select('accesorios.id', 'accesorios.descripcion', 'accesorios.articulo', 'checklist_instalacion_accesorios.cantidad', 'accesorios.id as ID', 'checklist_instalacion_accesorios.serie_parte')
         ->where('checklist_instalacion_accesorios.id_checklist_instalacion', '=', $datos_asignacion[0]->id_checklist)
         ->get();

      $instalacion_accesorios_manuales = DB::table('instalacion_accesorios_manuales')
         ->where('instalacion_accesorios_manuales.id_checklist_instalacion', '=', $datos_asignacion[0]->id_checklist)
         ->get();

      $fotos_accesorios = DB::table('fotos_checks_accesorios')
         ->where('checklist_instalacion_id', '=', $datos_asignacion[0]->id_checklist)
         ->get();

      $buscar_asignacion = App\asignacion_instalacions::where('id', '=', $id_para_pdf)->first();
      $buscar_asignacion->url_pdf = $CsSerie . $id_para_pdf . "instalacion.pdf";
      $buscar_asignacion->timestamps = false;
      $buscar_asignacion->save();


      // $var = json_decode($response->getBody()->getContents());
      return \PDF::setOptions((['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true]))
         ->loadView('check/pdf.pdfInstalacionCoordinadora', compact('instalacion_accesorios_manuales', 'instalacion_accesorios', 'accesorios_manuales', 'datos_asignacion', 'tipo_visita', 'proyecto_asociado', 'fotos', 'firmatrabajador', 'datos_accesorios', 'accesorios_dañados', 'fotos_accesorios'))
         ->save(storage_path('app/public/pdfinstalacion/') . $CsSerie . $id_para_pdf . 'instalacion.pdf')
         ->stream();

      $url = session('url_cordinadora');
      return redirect($url)->with('mensaje', 'pdf regenerado');
   }
   public function create()
   {
      //
   }

   /**
    * Store a newly created resource in storage.
    *
    * @param  \Illuminate\Http\Request  $request
    * @return \Illuminate\Http\Response
    */
   public function store(Request $request)
   {
      //
   }

   /**
    * Display the specified resource.
    *
    * @param  int  $id
    * @return \Illuminate\Http\Response
    */
   public function show($id)
   {
      //
   }

   /**
    * Show the form for editing the specified resource.
    *
    * @param  int  $id
    * @return \Illuminate\Http\Response
    */
   public function edit($id)
   {
      //
   }

   /**
    * Update the specified resource in storage.
    *
    * @param  \Illuminate\Http\Request  $request
    * @param  int  $id
    * @return \Illuminate\Http\Response
    */
   public function update(Request $request, $id)
   {
      //
   }

   /**
    * Remove the specified resource from storage.
    *
    * @param  int  $id
    * @return \Illuminate\Http\Response
    */
   public function destroy($id)
   {
      //
   }
}
