<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Carbon\Carbon;
use Auth;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {

        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();

        /** CONTADORES PARA COORDINADOR */
        //ESTADO PARA REASIGNAR PARA COORDIANDOR
        $retiros_comtecglobal_porreasignar_coordiandor = DB::connection('comtecglobal')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->select(
                'asignacion_retiros.id'
            )
            ->where('asignacion_retiros.estado_asignacion', '=', 'reasignar');
        $instalacion_comtecglobal_porreasignar_coordiandor = DB::connection('comtecglobal')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->select(
                'asignacion_instalacions.id'
            )
            ->where('asignacion_instalacions.estado_asignacion', '=', 'reasignar')
            ->where('instalacions.sEstado_instalacion', '=', 'reasignar')
            ->union($retiros_comtecglobal_porreasignar_coordiandor)
            ->count();

        $retiros_kyocera_porreasignar_coordiandor = DB::connection('kyocera')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->select(
                'asignacion_retiros.id'
            )
            ->where('asignacion_retiros.estado_asignacion', '=', 'reasignar');
        $instalacion_kyocera_porreasignar_coordiandor = DB::connection('kyocera')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->select(
                'asignacion_instalacions.id'
            )
            ->where('asignacion_instalacions.estado_asignacion', '=', 'reasignar')
            ->where('instalacions.sEstado_instalacion', '=', 'reasignar')
            ->union($retiros_kyocera_porreasignar_coordiandor)
            ->count();

        $retiros_upgrade_porreasignar_coordiandor = DB::connection('upgrade')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->select(
                'asignacion_retiros.id'
            )
            ->where('asignacion_retiros.estado_asignacion', '=', 'reasignar');
        $instalacion_upgrade_porreasignar_coordiandor = DB::connection('upgrade')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->select(
                'asignacion_instalacions.id'
            )
            ->where('asignacion_instalacions.estado_asignacion', '=', 'reasignar')
            ->where('instalacions.sEstado_instalacion', '=', 'reasignar')
            ->union($retiros_upgrade_porreasignar_coordiandor)
            ->count();

        $suma_porreasignars_coordiandor = $instalacion_comtecglobal_porreasignar_coordiandor + $instalacion_kyocera_porreasignar_coordiandor + $instalacion_upgrade_porreasignar_coordiandor;
        //ESTADO EN CURSO PARA COORDIANDOR
        $retiros_comtecglobal_curso_coordiandor = DB::connection('comtecglobal')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->select(
                'asignacion_retiros.id'
            )
            ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
            ->where('checklist_retiros.estado_inicio', '=', 'activo');
        $instalacion_comtecglobal_curso_coordiandor = DB::connection('comtecglobal')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->select(
                'asignacion_instalacions.id'
            )
            ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
            ->where('checklist_instalacions.estado_inicio', '=', 'activo')
            ->orderBy('fecha_visita', 'desc')
            ->union($retiros_comtecglobal_curso_coordiandor)
            ->count();

        $retiros_kyocera_curso_coordiandor = DB::connection('kyocera')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->select(
                'asignacion_retiros.id'
            )
            ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
            ->where('checklist_retiros.estado_inicio', '=', 'activo');
        $instalacion_kyocera_curso_coordiandor = DB::connection('kyocera')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->select(
                'asignacion_instalacions.id'
            )
            ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
            ->where('checklist_instalacions.estado_inicio', '=', 'activo')
            ->orderBy('fecha_visita', 'desc')
            ->union($retiros_kyocera_curso_coordiandor)
            ->count();

        $retiros_upgrade_curso_coordiandor = DB::connection('upgrade')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->select(
                'asignacion_retiros.id'
            )
            ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
            ->where('checklist_retiros.estado_inicio', '=', 'activo');
        $instalacion_upgrade_curso_coordiandor = DB::connection('upgrade')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->select(
                'asignacion_instalacions.id'
            )
            ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
            ->where('checklist_instalacions.estado_inicio', '=', 'activo')
            ->orderBy('fecha_visita', 'desc')
            ->union($retiros_upgrade_curso_coordiandor)
            ->count();

        $suma_encursos_coordiandor = $instalacion_comtecglobal_curso_coordiandor + $instalacion_kyocera_curso_coordiandor + $instalacion_upgrade_curso_coordiandor;
        //ESTADO PENDIENTE PARA COORDINADOR
        $retiros_comtecglobal_pendientes_coordinador = DB::connection('comtecglobal')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->select(
                'asignacion_retiros.id'
            )
            ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada');
        $instalacion_comtecglobal_pendientes_coordinador = DB::connection('comtecglobal')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->select(
                'asignacion_instalacions.id'
            )
            ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
            ->orderBy('fecha_visita', 'desc')
            ->union($retiros_comtecglobal_pendientes_coordinador)
            ->count();

        $retiros_kyocera_pendientes_coordinador = DB::connection('kyocera')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->select(
                'asignacion_retiros.id'
            )
            ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada');
        $instalacion_kyocera_pendientes_coordinador = DB::connection('kyocera')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->select(
                'asignacion_instalacions.id'
            )
            ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
            ->orderBy('fecha_visita', 'desc')
            ->union($retiros_kyocera_pendientes_coordinador)
            ->count();

        $retiros_upgrade_pendientes_coordinador = DB::connection('upgrade')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->select(
                'asignacion_retiros.id'
            )
            ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada');
        $instalacion_upgrade_pendientes_coordinador = DB::connection('upgrade')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->select(
                'asignacion_instalacions.id'
            )
            ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
            ->orderBy('fecha_visita', 'desc')
            ->union($retiros_upgrade_pendientes_coordinador)
            ->count();

        $suma_pendientes_coordinador = $instalacion_upgrade_pendientes_coordinador + $instalacion_kyocera_pendientes_coordinador + $instalacion_comtecglobal_pendientes_coordinador;
        //ESTADO POR ASIGNAR PARA COORDINADOR 
        $retiros_comtecglobal_pendientes = DB::connection('comtecglobal')->table('retiros')
            ->join('tracker', 'tracker.id', '=', 'retiros.tracker_id')
            ->select(
                'retiros.proveedor_retiro as proveedor',
                'tracker.tipo_tracker as tipo',
                'retiros.sCliente as cliente',
                'retiros.sRegion',
                'retiros.sComuna',
                'retiros.sSerie',
                'retiros.id'
            )
            ->where('retiros.estado_retiro_Cord', '=', 'Por Asignar');
        $instalacion_comtecglobal_pendientes = DB::connection('comtecglobal')->table('instalacions')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->select(
                'instalacions.proveedor_instalacion as proveedor',
                'tracker.tipo_tracker as tipo',
                'instalacions.sCliente as cliente',
                'instalacions.sRegion',
                'instalacions.sComuna',
                'instalacions.sSerie',
                'instalacions.id'
            )
            ->where('instalacions.sEstado_instalacion', 'like', '%Por Asignar%')
            ->union($retiros_comtecglobal_pendientes)
            ->get();
        $retiros_kyocera_pendientes = DB::connection('kyocera')->table('retiros')
            ->join('tracker', 'tracker.id', '=', 'retiros.tracker_id')
            ->select(
                'retiros.proveedor_retiro as proveedor',
                'tracker.tipo_tracker as tipo',
                'retiros.sCliente as cliente',
                'retiros.sRegion',
                'retiros.sComuna',
                'retiros.sSerie',
                'retiros.id'
            )
            ->where('retiros.estado_retiro_Cord', '=', 'Por Asignar');
        $instalacion_kyocera_pendientes = DB::connection('kyocera')->table('instalacions')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->select(
                'instalacions.proveedor_instalacion as proveedor',
                'tracker.tipo_tracker as tipo',
                'instalacions.sCliente as cliente',
                'instalacions.sRegion',
                'instalacions.sComuna',
                'instalacions.sSerie',
                'instalacions.id'
            )
            ->where('instalacions.sEstado_instalacion', 'like', '%Por Asignar%')
            ->union($retiros_kyocera_pendientes)
            ->get();

        $retiros_upgrade_pendientes = DB::connection('upgrade')->table('retiros')
            ->join('tracker', 'tracker.id', '=', 'retiros.tracker_id')
            ->select(
                'retiros.proveedor_retiro as proveedor',
                'tracker.tipo_tracker as tipo',
                'retiros.sCliente as cliente',
                'retiros.sRegion',
                'retiros.sComuna',
                'retiros.sSerie',
                'retiros.id'
            )
            ->where('retiros.estado_retiro_Cord', '=', 'Por Asignar');
        $instalacion_upgrade_pendientes = DB::connection('upgrade')->table('instalacions')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->select(
                'instalacions.proveedor_instalacion as proveedor',
                'tracker.tipo_tracker as tipo',
                'instalacions.sCliente as cliente',
                'instalacions.sRegion',
                'instalacions.sComuna',
                'instalacions.sSerie',
                'instalacions.id'
            )
            ->where('instalacions.sEstado_instalacion', 'like', '%Por Asignar%')
            ->union($retiros_upgrade_pendientes)
            ->get();

        $suma_porasignar_coordinador = count($instalacion_upgrade_pendientes) + count($instalacion_kyocera_pendientes) + count($instalacion_comtecglobal_pendientes);
        if (count($datos_trabajador) != 0) {
            $id_trabajador = $datos_trabajador[0]->id;

            //ESTADO PENDIENTE PARA TECNICO 
            $retiros_comtecglobal_pendientes = DB::connection('comtecglobal')->table('asignacion_retiros')
                ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                ->select(
                    'asignacion_retiros.id'
                )
                ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
                ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
                ->where('checklist_retiros.estado_asignacion', '=', 'tarea_asignada');
            $instalacion_comtecglobal_pendientes = DB::connection('comtecglobal')->table('asignacion_instalacions')
                ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->select(
                    'asignacion_instalacions.id'
                )
                ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
                ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
                ->where('checklist_instalacions.estado_inicio', '!=', 'activo')
                ->where('checklist_instalacions.estado_inicio', '!=', 'finalizado')
                ->where('checklist_instalacions.estado_inicio', '!=', 'cancelado')
                ->orderBy('fecha_visita', 'desc')
                ->union($retiros_comtecglobal_pendientes)
                ->count();

            $retiros_kyocera_pendientes = DB::connection('kyocera')->table('asignacion_retiros')
                ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                ->select(
                    'asignacion_retiros.id'
                )
                ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
                ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
                ->where('checklist_retiros.estado_asignacion', '=', 'tarea_asignada');
            $instalacion_kyocera_pendientes = DB::connection('kyocera')->table('asignacion_instalacions')
                ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->select(
                    'asignacion_instalacions.id'
                )
                ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
                ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
                ->where('checklist_instalacions.estado_inicio', '!=', 'activo')
                ->where('checklist_instalacions.estado_inicio', '!=', 'finalizado')
                ->where('checklist_instalacions.estado_inicio', '!=', 'cancelado')
                ->orderBy('fecha_visita', 'desc')
                ->union($retiros_kyocera_pendientes)
                ->count();

            $retiros_upgrade_pendientes = DB::connection('upgrade')->table('asignacion_retiros')
                ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                ->select(
                    'asignacion_retiros.id'
                )
                ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
                ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
                ->where('checklist_retiros.estado_asignacion', '=', 'tarea_asignada');
            $instalacion_upgrade_pendientes = DB::connection('upgrade')->table('asignacion_instalacions')
                ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->select(
                    'asignacion_instalacions.id'
                )
                ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
                ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
                ->where('checklist_instalacions.estado_inicio', '!=', 'activo')
                ->where('checklist_instalacions.estado_inicio', '!=', 'finalizado')
                ->where('checklist_instalacions.estado_inicio', '!=', 'cancelado')
                ->orderBy('fecha_visita', 'desc')
                ->union($retiros_upgrade_pendientes)
                ->count();

            $suma_pendientes = $instalacion_upgrade_pendientes + $instalacion_kyocera_pendientes + $instalacion_comtecglobal_pendientes;

            //ESTADO EN CURSO PARA TECNICO
            $retiros_comtecglobal_curso = DB::connection('comtecglobal')->table('asignacion_retiros')
                ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                ->select(
                    'asignacion_retiros.id'
                )
                ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
                ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
                ->where('checklist_retiros.estado_inicio', '=', 'activo');
            $instalacion_comtecglobal_curso = DB::connection('comtecglobal')->table('asignacion_instalacions')
                ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->select(
                    'asignacion_instalacions.id'
                )
                ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
                ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
                ->where('checklist_instalacions.estado_inicio', '=', 'activo')
                ->orderBy('fecha_visita', 'desc')
                ->union($retiros_comtecglobal_curso)
                ->count();

            $retiros_kyocera_curso = DB::connection('kyocera')->table('asignacion_retiros')
                ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                ->select(
                    'asignacion_retiros.id'
                )
                ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
                ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
                ->where('checklist_retiros.estado_inicio', '=', 'activo');
            $instalacion_kyocera_curso = DB::connection('kyocera')->table('asignacion_instalacions')
                ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->select(
                    'asignacion_instalacions.id'
                )
                ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
                ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
                ->where('checklist_instalacions.estado_inicio', '=', 'activo')
                ->orderBy('fecha_visita', 'desc')
                ->union($retiros_kyocera_curso)
                ->count();

            $retiros_upgrade_curso = DB::connection('upgrade')->table('asignacion_retiros')
                ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                ->select(
                    'asignacion_retiros.id'
                )
                ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
                ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
                ->where('checklist_retiros.estado_inicio', '=', 'activo');
            $instalacion_upgrade_curso = DB::connection('upgrade')->table('asignacion_instalacions')
                ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->select(
                    'asignacion_instalacions.id'
                )
                ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
                ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
                ->where('checklist_instalacions.estado_inicio', '=', 'activo')
                ->orderBy('fecha_visita', 'desc')
                ->union($retiros_upgrade_curso)
                ->count();

            $suma_encursos = $instalacion_comtecglobal_curso + $instalacion_kyocera_curso + $instalacion_upgrade_curso;

            //ESTADO EN RECHAZADOS PARA TECNICO
            $retiros_comtecglobal_rechazado = DB::connection('comtecglobal')->table('asignacion_retiros')
                ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                ->select(
                    'asignacion_retiros.id'
                )
                ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
                ->where('asignacion_retiros.estado_asignacion', '=', 'rechazado');
            $instalacion_comtecglobal_rechazado = DB::connection('comtecglobal')->table('asignacion_instalacions')
                ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->select(
                    'asignacion_instalacions.id'
                )
                ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
                ->where('asignacion_instalacions.estado_asignacion', '=', 'rechazado')
                ->orderBy('fecha_visita', 'desc')
                ->union($retiros_comtecglobal_rechazado)
                ->count();

            $retiros_kyocera_rechazado = DB::connection('kyocera')->table('asignacion_retiros')
                ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                ->select(
                    'asignacion_retiros.id'
                )
                ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
                ->where('asignacion_retiros.estado_asignacion', '=', 'rechazado');
            $instalacion_kyocera_rechazado = DB::connection('kyocera')->table('asignacion_instalacions')
                ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->select(
                    'asignacion_instalacions.id'
                )
                ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
                ->where('asignacion_instalacions.estado_asignacion', '=', 'rechazado')
                ->orderBy('fecha_visita', 'desc')
                ->union($retiros_kyocera_rechazado)
                ->count();

            $retiros_upgrade_rechazado = DB::connection('upgrade')->table('asignacion_retiros')
                ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                ->select(
                    'asignacion_retiros.id'
                )
                ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
                ->where('asignacion_retiros.estado_asignacion', '=', 'rechazado');
            $instalacion_upgrade_rechazado = DB::connection('upgrade')->table('asignacion_instalacions')
                ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->select(
                    'asignacion_instalacions.id'
                )
                ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
                ->where('asignacion_instalacions.estado_asignacion', '=', 'rechazado')
                ->orderBy('fecha_visita', 'desc')
                ->union($retiros_upgrade_rechazado)
                ->count();

            $suma_rechazado = $instalacion_comtecglobal_rechazado + $instalacion_kyocera_rechazado + $instalacion_upgrade_rechazado;
        } else {
            $suma_rechazado = "";
            $suma_encursos = "";
            $suma_pendientes = "";
        }

        return view('home', compact('suma_pendientes', 'suma_encursos', 'suma_rechazado', 'suma_pendientes_coordinador', 'suma_porasignar_coordinador', 'suma_encursos_coordiandor', 'suma_porreasignars_coordiandor'));
    }
    public function establecer_proveedor(Request $request)
    {
        $nombre_proveedores = DB::table('config_usuarios')
            ->select('id', 'nombre_proveedor', 'name_bd')
            ->where('estado', '=', 1)
            ->get();

        $nombre_DB = DB::connection()->getDatabaseName();
        return "ok";
    }

    /** FUNCION PARA REVISAR ATENCIONES PENDIENTES TECNICOS  */
    public function revisar_pendiente_tecnico()
    {
        $datos_trabajador = DB::table('trabajadors')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select('trabajadors.id', 'personas.nombre_uno', 'personas.apellido_uno')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();

        $id_trabajador = $datos_trabajador[0]->id;

        //ESTADO PENDIENTE PARA TECNICO 
        $retiros_comtecglobal_pendientes = DB::connection('comtecglobal')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->select(
                'checklist_retiros.csSerie as serie',
                'checklist_retiros.csComuna as comuna',
                'checklist_retiros.csRegion as region',
                'checklist_retiros.Cscliente as cliente',
                'asignacion_retiros.tipo',
                'asignacion_retiros.id',
                'retiros.proveedor_retiro as proveedor'
            )
            ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
            ->where('checklist_retiros.estado_asignacion', '=', 'tarea_asignada');
        $instalacion_comtecglobal_pendientes = DB::connection('comtecglobal')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->select(
                'checklist_instalacions.CsSerie as serie',
                'checklist_instalacions.Cscomuna as comuna',
                'checklist_instalacions.Csregion as region',
                'checklist_instalacions.Cscliente as cliente',
                'asignacion_instalacions.tipo',
                'asignacion_instalacions.id',
                'instalacions.proveedor_instalacion as proveedor'
            )
            ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
            ->where('checklist_instalacions.estado_inicio', '!=', 'activo')
            ->union($retiros_comtecglobal_pendientes)
            ->get();
        $retiros_kyocera_pendientes = DB::connection('kyocera')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->select(
                'checklist_retiros.csSerie as serie',
                'checklist_retiros.csComuna as comuna',
                'checklist_retiros.csRegion as region',
                'checklist_retiros.Cscliente as cliente',
                'asignacion_retiros.tipo',
                'asignacion_retiros.id',
                'retiros.proveedor_retiro as proveedor'
            )
            ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
            ->where('checklist_retiros.estado_asignacion', '=', 'tarea_asignada');
        $instalacion_kyocera_pendientes = DB::connection('kyocera')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->select(
                'checklist_instalacions.CsSerie as serie',
                'checklist_instalacions.Cscomuna as comuna',
                'checklist_instalacions.Csregion as region',
                'checklist_instalacions.Cscliente as cliente',
                'asignacion_instalacions.tipo',
                'asignacion_instalacions.id',
                'instalacions.proveedor_instalacion as proveedor'
            )
            ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
            ->where('checklist_instalacions.estado_inicio', '!=', 'activo')
            ->union($retiros_kyocera_pendientes)
            ->get();

        $retiros_upgrade_pendientes = DB::connection('upgrade')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->select(
                'checklist_retiros.csSerie as serie',
                'checklist_retiros.csComuna as comuna',
                'checklist_retiros.csRegion as region',
                'checklist_retiros.Cscliente as cliente',
                'asignacion_retiros.tipo',
                'asignacion_retiros.id',
                'retiros.proveedor_retiro as proveedor'
            )
            ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
            ->where('checklist_retiros.estado_inicio', '!=', 'activo')
            ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
            ->where('checklist_retiros.estado_asignacion', '=', 'tarea_asignada');
        $instalacion_upgrade_pendientes = DB::connection('upgrade')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->select(
                'checklist_instalacions.CsSerie as serie',
                'checklist_instalacions.Cscomuna as comuna',
                'checklist_instalacions.Csregion as region',
                'checklist_instalacions.Cscliente as cliente',
                'asignacion_instalacions.tipo',
                'asignacion_instalacions.id',
                'instalacions.proveedor_instalacion as proveedor'
            )
            ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->where('checklist_instalacions.estado_inicio', '!=', 'activo')
            ->where('checklist_instalacions.estado_inicio', '!=', 'finalizado')
            ->where('checklist_instalacions.estado_inicio', '!=', 'cancelado')
            ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
            ->union($retiros_upgrade_pendientes)
            ->get();

        $table = "";
        foreach ($instalacion_comtecglobal_pendientes as $d1) {
            $table .= "<tr>";
            $table .= "<td>" . $datos_trabajador[0]->nombre_uno . "" . $datos_trabajador[0]->apellido_uno . "</td>";
            $table .= "<td>" . $d1->tipo . "</td>";
            $table .= "<td>" . $d1->cliente . "</td>";
            $table .= "<td>" . $d1->region . "</td>";
            $table .= "<td>" . $d1->comuna . "</td>";
            $table .= "<td>" . $d1->serie . "</td>";
            if ($d1->tipo == "retiro") {
                $table .=
                    '<td>
                        <form action="' . route('go.ChecklistRetiros') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
            } else {
                $table .=
                    '<td>
                        <form action="' . route('go.completando_check') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
            }
            $table .= "</tr>";
        }
        foreach ($instalacion_kyocera_pendientes as $d1) {
            $table .= "<tr>";
            $table .= "<td>" . $datos_trabajador[0]->nombre_uno . "" . $datos_trabajador[0]->apellido_uno . "</td>";
            $table .= "<td>" . $d1->tipo . "</td>";
            $table .= "<td>" . $d1->cliente . "</td>";
            $table .= "<td>" . $d1->region . "</td>";
            $table .= "<td>" . $d1->comuna . "</td>";
            $table .= "<td>" . $d1->serie . "</td>";
            if ($d1->tipo == "retiro") {
                $table .=
                    '<td>
                        <form action="' . route('go.ChecklistRetiros') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
            } else {
                $table .=
                    '<td>
                        <form action="' . route('go.completando_check') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
            }
            $table .= "</tr>";
        }
        foreach ($instalacion_upgrade_pendientes as $d1) {
            $table .= "<tr>";
            $table .= "<td>" . $datos_trabajador[0]->nombre_uno . "" . $datos_trabajador[0]->apellido_uno . "</td>";
            $table .= "<td>" . $d1->tipo . "</td>";
            $table .= "<td>" . $d1->cliente . "</td>";
            $table .= "<td>" . $d1->region . "</td>";
            $table .= "<td>" . $d1->comuna . "</td>";
            $table .= "<td>" . $d1->serie . "</td>";
            if ($d1->tipo == "retiro") {
                $table .=
                    '<td>
                        <form action="' . route('go.ChecklistRetiros') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
            } else {
                $table .=
                    '<td>
                        <form action="' . route('go.completando_check') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
            }
            $table .= "</tr>";
        }
        return $table;
    }
    public function revisar_encurso_tecnico()
    {
        $datos_trabajador = DB::table('trabajadors')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select('trabajadors.id', 'personas.nombre_uno', 'personas.apellido_uno')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();

        $id_trabajador = $datos_trabajador[0]->id;

        //ESTADO ENCURSO PARA TECNICO 
        $retiros_comtecglobal_encurso = DB::connection('comtecglobal')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_retiros.trabajadors_idtecnico')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_retiros.csSerie as serie',
                'checklist_retiros.fecha_inicio as fecha',
                'checklist_retiros.csComuna as comuna',
                'checklist_retiros.csRegion as region',
                'checklist_retiros.Cscliente as cliente',
                'asignacion_retiros.tipo',
                'asignacion_retiros.id',
                'retiros.proveedor_retiro as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_retiros.fecha_asignado',
            )
            ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
            ->where('checklist_retiros.estado_inicio', '=', 'activo');
        $instalacion_comtecglobal_encurso  = DB::connection('comtecglobal')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_instalacions.CsSerie as serie',
                'checklist_instalacions.fecha_inicio as fecha',
                'checklist_instalacions.Cscomuna as comuna',
                'checklist_instalacions.Csregion as region',
                'checklist_instalacions.Cscliente as cliente',
                'asignacion_instalacions.tipo',
                'asignacion_instalacions.id',
                'instalacions.proveedor_instalacion as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_instalacions.fecha_asignado',
            )
            ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
            ->where('checklist_instalacions.estado_inicio', '=', 'activo')
            ->union($retiros_comtecglobal_encurso)
            ->get();
        $retiros_kyocera_encurso  = DB::connection('kyocera')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_retiros.trabajadors_idtecnico')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_retiros.csSerie as serie',
                'checklist_retiros.fecha_inicio as fecha',
                'checklist_retiros.csComuna as comuna',
                'checklist_retiros.csRegion as region',
                'checklist_retiros.Cscliente as cliente',
                'asignacion_retiros.tipo',
                'asignacion_retiros.id',
                'retiros.proveedor_retiro as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_retiros.fecha_asignado',
            )
            ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
            ->where('checklist_retiros.estado_inicio', '=', 'activo');
        $instalacion_kyocera_encurso  = DB::connection('kyocera')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_instalacions.CsSerie as serie',
                'checklist_instalacions.fecha_inicio as fecha',
                'checklist_instalacions.Cscomuna as comuna',
                'checklist_instalacions.Csregion as region',
                'checklist_instalacions.Cscliente as cliente',
                'asignacion_instalacions.tipo',
                'asignacion_instalacions.id',
                'instalacions.proveedor_instalacion as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_instalacions.fecha_asignado',
            )
            ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
            ->where('checklist_instalacions.estado_inicio', '=', 'activo')
            ->union($retiros_kyocera_encurso)
            ->get();

        $retiros_upgrade_encurso  = DB::connection('upgrade')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_retiros.trabajadors_idtecnico')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_retiros.csSerie as serie',
                'checklist_retiros.fecha_inicio as fecha',
                'checklist_retiros.csComuna as comuna',
                'checklist_retiros.csRegion as region',
                'checklist_retiros.Cscliente as cliente',
                'asignacion_retiros.tipo',
                'asignacion_retiros.id',
                'retiros.proveedor_retiro as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_retiros.fecha_asignado',
            )
            ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
            ->where('checklist_retiros.estado_inicio', '=', 'activo');
        $instalacion_upgrade_encurso  = DB::connection('upgrade')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_instalacions.CsSerie as serie',
                'checklist_instalacions.fecha_inicio as fecha',
                'checklist_instalacions.Cscomuna as comuna',
                'checklist_instalacions.Csregion as region',
                'checklist_instalacions.Cscliente as cliente',
                'asignacion_instalacions.tipo',
                'asignacion_instalacions.id',
                'instalacions.proveedor_instalacion as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_instalacions.fecha_asignado',
            )
            ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
            ->where('checklist_instalacions.estado_inicio', '=', 'activo')
            ->union($retiros_upgrade_encurso)
            ->get();

        $table = "";
        foreach ($instalacion_comtecglobal_encurso  as $d1) {
            $table .= "<tr>";
            $table .= "<td>" . $datos_trabajador[0]->nombre_uno . "" . $datos_trabajador[0]->apellido_uno . "</td>";
            $table .= "<td>" . $d1->fecha . "</td>";
            $table .= "<td>" . $d1->cliente . "</td>";
            $table .= "<td>" . $d1->serie . "</td>";
            if ($d1->tipo == "retiro") {
                $table .=
                    '<td>
                    <form action="' . route('go.ChecklistRetiros') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
            } else {
                $table .=
                    '<td>
                    <form action="' . route('go.completando_check') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
            }
            $table .= "</tr>";
        }
        foreach ($instalacion_kyocera_encurso  as $d1) {
            $table .= "<tr>";
            $table .= "<td>" . $datos_trabajador[0]->nombre_uno . "" . $datos_trabajador[0]->apellido_uno . "</td>";
            $table .= "<td>" . $d1->fecha . "</td>";
            $table .= "<td>" . $d1->cliente . "</td>";
            $table .= "<td>" . $d1->serie . "</td>";
            if ($d1->tipo == "retiro") {
                $table .=
                    '<td>
                    <form action="' . route('go.ChecklistRetiros') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
            } else {
                $table .=
                    '<td>
                    <form action="' . route('go.completando_check') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
            }
            $table .= "</tr>";
        }
        foreach ($instalacion_upgrade_encurso  as $d1) {
            $table .= "<tr>";
            $table .= "<td>" . $datos_trabajador[0]->nombre_uno . "" . $datos_trabajador[0]->apellido_uno . "</td>";
            $table .= "<td>" . $d1->fecha . "</td>";
            $table .= "<td>" . $d1->cliente . "</td>";
            $table .= "<td>" . $d1->serie . "</td>";
            if ($d1->tipo == "retiro") {
                $table .=
                    '<td>
                    <form action="' . route('go.ChecklistRetiros') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
            } else {
                $table .=
                    '<td>
                    <form action="' . route('go.completando_check') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
            }
            $table .= "</tr>";
        }
        return $table;
    }
    /** FUNCION PARA REVISAR ATENCIONES RECHAZADAS TECNICO */
    public function revisar_rechazados_tecnico()
    {
        $datos_trabajador = DB::table('trabajadors')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select('trabajadors.id', 'personas.nombre_uno', 'personas.apellido_uno')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();

        $id_trabajador = $datos_trabajador[0]->id;

        //ESTADO PENDIENTE PARA TECNICO 
        $retiros_comtecglobal_pendientes = DB::connection('comtecglobal')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->select(
                'checklist_retiros.csSerie as serie',
                'checklist_retiros.csComuna as comuna',
                'checklist_retiros.csRegion as region',
                'checklist_retiros.Cscliente as cliente',
                'asignacion_retiros.tipo',
                'asignacion_retiros.id',
                'retiros.proveedor_retiro as proveedor'
            )
            ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->where('asignacion_retiros.estado_asignacion', '=', 'rechazado');
        $instalacion_comtecglobal_pendientes = DB::connection('comtecglobal')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->select(
                'checklist_instalacions.CsSerie as serie',
                'checklist_instalacions.Cscomuna as comuna',
                'checklist_instalacions.Csregion as region',
                'checklist_instalacions.Cscliente as cliente',
                'asignacion_instalacions.tipo',
                'asignacion_instalacions.id',
                'instalacions.proveedor_instalacion as proveedor'
            )
            ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_instalacions.estado_asignacion', '=', 'rechazado')
            ->union($retiros_comtecglobal_pendientes)
            ->get();
        $retiros_kyocera_pendientes = DB::connection('kyocera')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->select(
                'checklist_retiros.csSerie as serie',
                'checklist_retiros.csComuna as comuna',
                'checklist_retiros.csRegion as region',
                'checklist_retiros.Cscliente as cliente',
                'asignacion_retiros.tipo',
                'asignacion_retiros.id',
                'retiros.proveedor_retiro as proveedor'
            )
            ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->where('asignacion_retiros.estado_asignacion', '=', 'rechazado');
        $instalacion_kyocera_pendientes = DB::connection('kyocera')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->select(
                'checklist_instalacions.CsSerie as serie',
                'checklist_instalacions.Cscomuna as comuna',
                'checklist_instalacions.Csregion as region',
                'checklist_instalacions.Cscliente as cliente',
                'asignacion_instalacions.tipo',
                'asignacion_instalacions.id',
                'instalacions.proveedor_instalacion as proveedor'
            )
            ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_instalacions.estado_asignacion', '=', 'rechazado')
            ->union($retiros_kyocera_pendientes)
            ->get();

        $retiros_upgrade_pendientes = DB::connection('upgrade')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->select(
                'checklist_retiros.csSerie as serie',
                'checklist_retiros.csComuna as comuna',
                'checklist_retiros.csRegion as region',
                'checklist_retiros.Cscliente as cliente',
                'asignacion_retiros.tipo',
                'asignacion_retiros.id',
                'retiros.proveedor_retiro as proveedor'
            )
            ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
            ->where('asignacion_retiros.estado_asignacion', '=', 'rechazado');
        $instalacion_upgrade_pendientes = DB::connection('upgrade')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->select(
                'checklist_instalacions.CsSerie as serie',
                'checklist_instalacions.Cscomuna as comuna',
                'checklist_instalacions.Csregion as region',
                'checklist_instalacions.Cscliente as cliente',
                'asignacion_instalacions.tipo',
                'asignacion_instalacions.id',
                'instalacions.proveedor_instalacion as proveedor'
            )
            ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_instalacions.estado_asignacion', '=', 'rechazado')
            ->union($retiros_upgrade_pendientes)
            ->get();

        $table = "";
        foreach ($instalacion_comtecglobal_pendientes as $d1) {
            $table .= "<tr>";
            $table .= "<td>" . $datos_trabajador[0]->nombre_uno . "" . $datos_trabajador[0]->apellido_uno . "</td>";
            $table .= "<td>" . $d1->tipo . "</td>";
            $table .= "<td>" . $d1->cliente . "</td>";
            $table .= "<td>" . $d1->region . "</td>";
            $table .= "<td>" . $d1->comuna . "</td>";
            $table .= "<td>" . $d1->serie . "</td>";
            if ($d1->tipo == "retiro") {
                $table .=
                    '<td>
                        <form action="' . route('go.ChecklistRetiros') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
            } else {
                $table .=
                    '<td>
                        <form action="' . route('go.completando_check') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
            }
            $table .= "</tr>";
        }
        foreach ($instalacion_kyocera_pendientes as $d1) {
            $table .= "<tr>";
            $table .= "<td>" . $datos_trabajador[0]->nombre_uno . "" . $datos_trabajador[0]->apellido_uno . "</td>";
            $table .= "<td>" . $d1->tipo . "</td>";
            $table .= "<td>" . $d1->cliente . "</td>";
            $table .= "<td>" . $d1->region . "</td>";
            $table .= "<td>" . $d1->comuna . "</td>";
            $table .= "<td>" . $d1->serie . "</td>";
            if ($d1->tipo == "retiro") {
                $table .=
                    '<td>
                        <form action="' . route('go.ChecklistRetiros') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
            } else {
                $table .=
                    '<td>
                        <form action="' . route('go.completando_check') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
            }
            $table .= "</tr>";
        }
        foreach ($instalacion_upgrade_pendientes as $d1) {
            $table .= "<tr>";
            $table .= "<td>" . $datos_trabajador[0]->nombre_uno . "" . $datos_trabajador[0]->apellido_uno . "</td>";
            $table .= "<td>" . $d1->tipo . "</td>";
            $table .= "<td>" . $d1->cliente . "</td>";
            $table .= "<td>" . $d1->region . "</td>";
            $table .= "<td>" . $d1->comuna . "</td>";
            $table .= "<td>" . $d1->serie . "</td>";
            if ($d1->tipo == "retiro") {
                $table .=
                    '<td>
                        <form action="' . route('go.ChecklistRetiros') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
            } else {
                $table .=
                    '<td>
                        <form action="' . route('go.completando_check') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
            }
            $table .= "</tr>";
        }
        return $table;
    }
    /** FUNCION PARA REVISAR ATENCIONES POR ASIGNAR COORDINADOR  */

    public function revisar_porasignar()
    {
        $retiros_comtecglobal_pendientes = DB::connection('comtecglobal')->table('retiros')
            ->join('tracker', 'tracker.id', '=', 'retiros.tracker_id')
            ->select(
                'retiros.proveedor_retiro as proveedor',
                'tracker.tipo_tracker as tipo',
                'retiros.sCliente as cliente',
                'retiros.sRegion',
                'retiros.sComuna',
                'retiros.sSerie',
                'retiros.id'
            )
            ->where('retiros.estado_retiro_Cord', '=', 'Por Asignar');
        $instalacion_comtecglobal_pendientes = DB::connection('comtecglobal')->table('instalacions')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->select(
                'instalacions.proveedor_instalacion as proveedor',
                'tracker.tipo_tracker as tipo',
                'instalacions.sCliente as cliente',
                'instalacions.sRegion',
                'instalacions.sComuna',
                'instalacions.sSerie',
                'instalacions.id'
            )
            ->where('instalacions.sEstado_instalacion', 'like', '%Por Asignar%')
            ->union($retiros_comtecglobal_pendientes)
            ->get();
        $retiros_kyocera_pendientes = DB::connection('kyocera')->table('retiros')
            ->join('tracker', 'tracker.id', '=', 'retiros.tracker_id')
            ->select(
                'retiros.proveedor_retiro as proveedor',
                'tracker.tipo_tracker as tipo',
                'retiros.sCliente as cliente',
                'retiros.sRegion',
                'retiros.sComuna',
                'retiros.sSerie',
                'retiros.id'
            )
            ->where('retiros.estado_retiro_Cord', '=', 'Por Asignar');
        $instalacion_kyocera_pendientes = DB::connection('kyocera')->table('instalacions')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->select(
                'instalacions.proveedor_instalacion as proveedor',
                'tracker.tipo_tracker as tipo',
                'instalacions.sCliente as cliente',
                'instalacions.sRegion',
                'instalacions.sComuna',
                'instalacions.sSerie',
                'instalacions.id'
            )
            ->where('instalacions.sEstado_instalacion', 'like', '%Por Asignar%')
            ->union($retiros_kyocera_pendientes)
            ->get();

        $retiros_upgrade_pendientes = DB::connection('upgrade')->table('retiros')
            ->join('tracker', 'tracker.id', '=', 'retiros.tracker_id')
            ->select(
                'retiros.proveedor_retiro as proveedor',
                'tracker.tipo_tracker as tipo',
                'retiros.sCliente as cliente',
                'retiros.sRegion',
                'retiros.sComuna',
                'retiros.sSerie',
                'retiros.id'
            )
            ->where('retiros.estado_retiro_Cord', '=', 'Por Asignar');
        $instalacion_upgrade_pendientes = DB::connection('upgrade')->table('instalacions')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->select(
                'instalacions.proveedor_instalacion as proveedor',
                'tracker.tipo_tracker as tipo',
                'instalacions.sCliente as cliente',
                'instalacions.sRegion',
                'instalacions.sComuna',
                'instalacions.sSerie',
                'instalacions.id'
            )
            ->where('instalacions.sEstado_instalacion', 'like', '%Por Asignar%')
            ->union($retiros_upgrade_pendientes)
            ->get();

        $table = "";
        foreach ($instalacion_comtecglobal_pendientes as $d1) {
            $table .= "<tr>";
            $table .= "<td>"  . $d1->proveedor . "</td>";
            $table .= "<td>"  . $d1->tipo . "</td>";
            $table .= "<td>"  . $d1->cliente . "</td>";
            $table .= "<td>"  . $d1->sRegion . "</td>";
            $table .= "<td>"  . $d1->sComuna . "</td>";
            $table .= "<td>"  . $d1->sSerie . "</td>";
            if ($d1->tipo == "retiro") {
                $table .=
                    '<td> 
                        <form action="' . route('go.asignar_check_retiro_home') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn">Asignar</button>
                        </form> 
                    </td>';
            } else {
                $table .=
                    '<td> 
                    <form action="' . route('go.asignar_check_home') . '" method="GET">
                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                        <input type="hidden" value="' . $d1->id . '" name="id">
                        <button type="submit" class="btn">Asignar</button>
                    </form> 
                </td>';
            }
            $table .= "</tr>";
        }
        foreach ($instalacion_kyocera_pendientes as $d1) {
            $table .= "<tr>";
            $table .= "<td>" . $d1->proveedor . "</td>";
            $table .= "<td>"  . $d1->tipo . "</td>";
            $table .= "<td>"  . $d1->cliente . "</td>";
            $table .= "<td>"  . $d1->sRegion . "</td>";
            $table .= "<td>"  . $d1->sComuna . "</td>";
            $table .= "<td>"  . $d1->sSerie . "</td>";
            if ($d1->tipo == "retiro") {
                $table .=
                    '<td> 
                        <form action="' . route('go.asignar_check_retiro_home') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn">Asignar</button>
                        </form> 
                    </td>';
            } else {
                $table .=
                    '<td> 
                    <form action="' . route('go.asignar_check_home') . '" method="GET">
                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                        <input type="hidden" value="' . $d1->id . '" name="id">
                        <button type="submit" class="btn">Asignar</button>
                    </form> 
                </td>';
            }
            $table .= "</tr>";
        }
        foreach ($instalacion_upgrade_pendientes as $d1) {
            $table .= "<tr>";
            $table .= "<td>" . $d1->proveedor . "</td>";
            $table .= "<td>"  . $d1->tipo . "</td>";
            $table .= "<td>"  . $d1->cliente . "</td>";
            $table .= "<td>"  . $d1->sRegion . "</td>";
            $table .= "<td>"  . $d1->sComuna . "</td>";
            $table .= "<td>"  . $d1->sSerie . "</td>";
            if ($d1->tipo == "retiro") {
                $table .=
                    '<td> 
                        <form action="' . route('go.asignar_check_retiro_home') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn">Asignar</button>
                        </form> 
                    </td>';
            } else {
                $table .=
                    '<td> 
                    <form action="' . route('go.asignar_check_home') . '" method="GET">
                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                        <input type="hidden" value="' . $d1->id . '" name="id">
                        <button type="submit" class="btn">Asignar</button>
                    </form> 
                </td>';
            }
            $table .= "</tr>";
        }
        return $table;
    }

    public function revisar_pendientes_coordinador()
    {
        $datos_trabajador = DB::table('trabajadors')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select('trabajadors.id', 'personas.nombre_uno', 'personas.apellido_uno')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();

        $id_trabajador = $datos_trabajador[0]->id;

        //ESTADO PENDIENTE PARA TECNICO 
        $retiros_comtecglobal_pendientes = DB::connection('comtecglobal')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_retiros.trabajadors_idtecnico')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_retiros.csSerie as serie',
                'checklist_retiros.csComuna as comuna',
                'checklist_retiros.csRegion as region',
                'checklist_retiros.Cscliente as cliente',
                'asignacion_retiros.tipo',
                'asignacion_retiros.id',
                'retiros.proveedor_retiro as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno'
            )
            ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada');
        $instalacion_comtecglobal_pendientes = DB::connection('comtecglobal')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_instalacions.CsSerie as serie',
                'checklist_instalacions.Cscomuna as comuna',
                'checklist_instalacions.Csregion as region',
                'checklist_instalacions.Cscliente as cliente',
                'asignacion_instalacions.tipo',
                'asignacion_instalacions.id',
                'instalacions.proveedor_instalacion as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno'
            )
            ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
            ->union($retiros_comtecglobal_pendientes)
            ->get();
        $retiros_kyocera_pendientes = DB::connection('kyocera')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_retiros.trabajadors_idtecnico')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_retiros.csSerie as serie',
                'checklist_retiros.csComuna as comuna',
                'checklist_retiros.csRegion as region',
                'checklist_retiros.Cscliente as cliente',
                'asignacion_retiros.tipo',
                'asignacion_retiros.id',
                'retiros.proveedor_retiro as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno'
            )
            ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada');
        $instalacion_kyocera_pendientes = DB::connection('kyocera')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_instalacions.CsSerie as serie',
                'checklist_instalacions.Cscomuna as comuna',
                'checklist_instalacions.Csregion as region',
                'checklist_instalacions.Cscliente as cliente',
                'asignacion_instalacions.tipo',
                'asignacion_instalacions.id',
                'instalacions.proveedor_instalacion as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno'
            )
            ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
            ->union($retiros_kyocera_pendientes)
            ->get();

        $retiros_upgrade_pendientes = DB::connection('upgrade')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_retiros.trabajadors_idtecnico')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_retiros.csSerie as serie',
                'checklist_retiros.csComuna as comuna',
                'checklist_retiros.csRegion as region',
                'checklist_retiros.Cscliente as cliente',
                'asignacion_retiros.tipo',
                'asignacion_retiros.id',
                'retiros.proveedor_retiro as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno'
            )
            ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada');
        $instalacion_upgrade_pendientes = DB::connection('upgrade')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_instalacions.CsSerie as serie',
                'checklist_instalacions.Cscomuna as comuna',
                'checklist_instalacions.Csregion as region',
                'checklist_instalacions.Cscliente as cliente',
                'asignacion_instalacions.tipo',
                'asignacion_instalacions.id',
                'instalacions.proveedor_instalacion as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno'
            )
            ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
            ->union($retiros_upgrade_pendientes)
            ->get();

        $table = "";
        foreach ($instalacion_comtecglobal_pendientes as $d1) {
            $table .= "<tr>";
            $table .= "<td>" . $d1->nombre_uno . " " . $d1->apellido_uno . "</td>";
            $table .= "<td>" . $d1->tipo . "</td>";
            $table .= "<td>" . $d1->cliente . "</td>";
            $table .= "<td>" . $d1->region . "</td>";
            $table .= "<td>" . $d1->comuna . "</td>";
            $table .= "<td>" . $d1->serie . "</td>";
            if ($d1->tipo == "retiro") {
                $table .=
                    '<td>
                        <div class="dropdown dropleft">
                            <button type="button" class="btn-dropdown" data-toggle="dropdown" aria-expanded="false">
                                <span class="material-icons">more_vert</span>
                            </button>
                            <div class="dropdown-menu mostrar shadow">
                                <div class="d-flex justify-content-around">
                                    <form action="' . route('go.ver_check_retirocordinadora2') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button class="btn">
                                            <span class="material-icons-round">
                                                visibility
                                            </span>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div
                    </td>';
            } else {
                $table .=
                    '<td>
                        <div class="dropdown dropleft">
                            <button type="button" class="btn-dropdown" data-toggle="dropdown" aria-expanded="false">
                                <span class="material-icons">more_vert</span>
                            </button>
                            <div class="dropdown-menu mostrar shadow">
                                <div class="d-flex justify-content-around">
                                    <form action="' . route('go.finalizamanual_home') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">   
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button class="btn">
                                            <span class="material-icons-round">
                                                check_circle_outline
                                            </span>
                                        </button>
                                    </form>
                                    <form action="' . route('go.ver_check_cordinadora2') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button class="btn">
                                            <span class="material-icons-round">
                                                visibility
                                            </span>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div
                    </td>';
            }
            $table .= "</tr>";
        }
        foreach ($instalacion_kyocera_pendientes as $d1) {
            $table .= "<tr>";
            $table .= "<td>" . $d1->nombre_uno . " " . $d1->apellido_uno . "</td>";
            $table .= "<td>" . $d1->tipo . "</td>";
            $table .= "<td>" . $d1->cliente . "</td>";
            $table .= "<td>" . $d1->region . "</td>";
            $table .= "<td>" . $d1->comuna . "</td>";
            $table .= "<td>" . $d1->serie . "</td>";
            if ($d1->tipo == "retiro") {
                $table .=
                    '<td>
                        <div class="dropdown dropleft">
                            <button type="button" class="btn-dropdown" data-toggle="dropdown" aria-expanded="false">
                                <span class="material-icons">more_vert</span>
                            </button>
                            <div class="dropdown-menu mostrar shadow">
                                <div class="d-flex justify-content-around">
                                    <form action="' . route('go.ver_check_retirocordinadora2') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button class="btn">
                                            <span class="material-icons-round">
                                                visibility
                                            </span>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div
                    </td>';
            } else {
                $table .=
                    '<td>
                        <div class="dropdown dropleft">
                            <button type="button" class="btn-dropdown" data-toggle="dropdown" aria-expanded="false">
                                <span class="material-icons">more_vert</span>
                            </button>
                            <div class="dropdown-menu mostrar shadow">
                                <div class="d-flex justify-content-around">
                                    <form action="' . route('go.finalizamanual_home') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">   
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button class="btn">
                                            <span class="material-icons-round">
                                                check_circle_outline
                                            </span>
                                        </button>
                                    </form>
                                    <form action="' . route('go.ver_check_cordinadora2') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button class="btn">
                                            <span class="material-icons-round">
                                                visibility
                                            </span>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div
                    </td>';
            }
            $table .= "</tr>";
        }
        foreach ($instalacion_upgrade_pendientes as $d1) {
            $table .= "<tr>";
            $table .= "<td>" . $d1->nombre_uno . " " . $d1->apellido_uno . "</td>";
            $table .= "<td>" . $d1->tipo . "</td>";
            $table .= "<td>" . $d1->cliente . "</td>";
            $table .= "<td>" . $d1->region . "</td>";
            $table .= "<td>" . $d1->comuna . "</td>";
            $table .= "<td>" . $d1->serie . "</td>";
            if ($d1->tipo == "retiro") {
                $table .=
                    '<td>
                        <div class="dropdown dropleft">
                            <button type="button" class="btn-dropdown" data-toggle="dropdown" aria-expanded="false">
                                <span class="material-icons">more_vert</span>
                            </button>
                            <div class="dropdown-menu mostrar shadow">
                                <div class="d-flex justify-content-around">
                                    <form action="' . route('go.ver_check_retirocordinadora2') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button class="btn">
                                            <span class="material-icons-round">
                                                visibility
                                            </span>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div
                    </td>';
            } else {
                $table .=
                    '<td>
                        <div class="dropdown dropleft">
                            <button type="button" class="btn-dropdown" data-toggle="dropdown" aria-expanded="false">
                                <span class="material-icons">more_vert</span>
                            </button>
                            <div class="dropdown-menu mostrar shadow">
                                <div class="d-flex justify-content-around">
                                    <form action="' . route('go.finalizamanual_home') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">   
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button class="btn">
                                            <span class="material-icons-round">
                                                check_circle_outline
                                            </span>
                                        </button>
                                    </form>
                                    <form action="' . route('go.ver_check_cordinadora2') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button class="btn">
                                            <span class="material-icons-round">
                                                visibility
                                            </span>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div
                    </td>';
            }
            $table .= "</tr>";
        }
        return $table;
    }
    public function revisar_encurso_coordinador()
    {
        $datos_trabajador = DB::table('trabajadors')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select('trabajadors.id', 'personas.nombre_uno', 'personas.apellido_uno')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();

        $id_trabajador = $datos_trabajador[0]->id;

        //ESTADO ENCURSO PARA TECNICO 
        $retiros_comtecglobal_encurso = DB::connection('comtecglobal')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_retiros.trabajadors_idtecnico')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_retiros.csSerie as serie',
                'checklist_retiros.fecha_inicio as fecha',
                'checklist_retiros.csComuna as comuna',
                'checklist_retiros.csRegion as region',
                'checklist_retiros.Cscliente as cliente',
                'asignacion_retiros.tipo',
                'asignacion_retiros.id',
                'retiros.proveedor_retiro as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_retiros.fecha_asignado',
            )
            ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
            ->where('checklist_retiros.estado_inicio', '=', 'activo');
        $instalacion_comtecglobal_encurso  = DB::connection('comtecglobal')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_instalacions.CsSerie as serie',
                'checklist_instalacions.fecha_inicio as fecha',
                'checklist_instalacions.Cscomuna as comuna',
                'checklist_instalacions.Csregion as region',
                'checklist_instalacions.Cscliente as cliente',
                'asignacion_instalacions.tipo',
                'asignacion_instalacions.id',
                'instalacions.proveedor_instalacion as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_instalacions.fecha_asignado',
            )
            ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
            ->where('checklist_instalacions.estado_inicio', '=', 'activo')
            ->union($retiros_comtecglobal_encurso)
            ->get();
        $retiros_kyocera_encurso  = DB::connection('kyocera')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_retiros.trabajadors_idtecnico')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_retiros.csSerie as serie',
                'checklist_retiros.fecha_inicio as fecha',
                'checklist_retiros.csComuna as comuna',
                'checklist_retiros.csRegion as region',
                'checklist_retiros.Cscliente as cliente',
                'asignacion_retiros.tipo',
                'asignacion_retiros.id',
                'retiros.proveedor_retiro as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_retiros.fecha_asignado',
            )
            ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
            ->where('checklist_retiros.estado_inicio', '=', 'activo');
        $instalacion_kyocera_encurso  = DB::connection('kyocera')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_instalacions.CsSerie as serie',
                'checklist_instalacions.fecha_inicio as fecha',
                'checklist_instalacions.Cscomuna as comuna',
                'checklist_instalacions.Csregion as region',
                'checklist_instalacions.Cscliente as cliente',
                'asignacion_instalacions.tipo',
                'asignacion_instalacions.id',
                'instalacions.proveedor_instalacion as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_instalacions.fecha_asignado',
            )
            ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
            ->where('checklist_instalacions.estado_inicio', '=', 'activo')
            ->union($retiros_kyocera_encurso)
            ->get();

        $retiros_upgrade_encurso  = DB::connection('upgrade')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_retiros.trabajadors_idtecnico')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_retiros.csSerie as serie',
                'checklist_retiros.fecha_inicio as fecha',
                'checklist_retiros.csComuna as comuna',
                'checklist_retiros.csRegion as region',
                'checklist_retiros.Cscliente as cliente',
                'asignacion_retiros.tipo',
                'asignacion_retiros.id',
                'retiros.proveedor_retiro as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_retiros.fecha_asignado',
            )
            ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
            ->where('checklist_retiros.estado_inicio', '=', 'activo');
        $instalacion_upgrade_encurso  = DB::connection('upgrade')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_instalacions.CsSerie as serie',
                'checklist_instalacions.fecha_inicio as fecha',
                'checklist_instalacions.Cscomuna as comuna',
                'checklist_instalacions.Csregion as region',
                'checklist_instalacions.Cscliente as cliente',
                'asignacion_instalacions.tipo',
                'asignacion_instalacions.id',
                'instalacions.proveedor_instalacion as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_instalacions.fecha_asignado',
            )
            ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
            ->where('checklist_instalacions.estado_inicio', '=', 'activo')
            ->union($retiros_upgrade_encurso)
            ->get();

        $table = "";
        foreach ($instalacion_comtecglobal_encurso  as $d1) {
            $fecha = Carbon::createFromDate($d1->fecha)->format('d-m-Y H:s');
            $table .= "<tr>";
            $table .= "<td>" . $d1->nombre_uno . " " . $d1->apellido_uno . "</td>";
            $table .= "<td>" . $fecha . "</td>";
            $table .= "<td>" . $d1->cliente . "</td>";
            $table .= "<td>" . $d1->serie . "</td>";
            if ($d1->tipo == "retiro") {
                $table .=
                    '<td>
                        <div class="dropdown dropleft">
                            <button type="button" class="btn-dropdown" data-toggle="dropdown" aria-expanded="false">
                                <span class="material-icons">more_vert</span>
                            </button>
                            <div class="dropdown-menu mostrar shadow">
                                <div class="d-flex justify-content-around">
                                    <form action="' . route('go.ver_check_retirocordinadora2') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button class="btn">
                                            <span class="material-icons-round">
                                                visibility
                                            </span>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div
                    </td>';
            } else {
                $table .=
                    '<td>
                        <div class="dropdown dropleft">
                            <button type="button" class="btn-dropdown" data-toggle="dropdown" aria-expanded="false">
                                <span class="material-icons">more_vert</span>
                            </button>
                            <div class="dropdown-menu mostrar shadow">
                                <div class="d-flex justify-content-around">
                                    <form action="' . route('go.finalizamanual_home') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">   
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button class="btn">
                                            <span class="material-icons-round">
                                                check_circle_outline
                                            </span>
                                        </button>
                                    </form>
                                    <form action="' . route('go.ver_check_cordinadora2') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button class="btn">
                                            <span class="material-icons-round">
                                                visibility
                                            </span>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div
                    </td>';
            }
            $table .= "</tr>";
        }
        foreach ($instalacion_kyocera_encurso  as $d1) {
            $fecha = Carbon::createFromDate($d1->fecha)->format('d-m-Y H:s');
            $table .= "<tr>";
            $table .= "<td>" . $d1->nombre_uno . " " . $d1->apellido_uno . "</td>";
            $table .= "<td>" . $fecha . "</td>";
            $table .= "<td>" . $d1->cliente . "</td>";
            $table .= "<td>" . $d1->serie . "</td>";
            if ($d1->tipo == "retiro") {
                $table .=
                    '<td>
                        <div class="dropdown dropleft">
                            <button type="button" class="btn-dropdown" data-toggle="dropdown" aria-expanded="false">
                                <span class="material-icons">more_vert</span>
                            </button>
                            <div class="dropdown-menu mostrar shadow">
                                <div class="d-flex justify-content-around">
                                    <form action="' . route('go.ver_check_retirocordinadora2') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button class="btn">
                                            <span class="material-icons-round">
                                                visibility
                                            </span>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div
                    </td>';
            } else {
                $table .=
                    '<td>
                        <div class="dropdown dropleft">
                            <button type="button" class="btn-dropdown" data-toggle="dropdown" aria-expanded="false">
                                <span class="material-icons">more_vert</span>
                            </button>
                            <div class="dropdown-menu mostrar shadow">
                                <div class="d-flex justify-content-around">
                                    <form action="' . route('go.finalizamanual_home') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">   
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button class="btn">
                                            <span class="material-icons-round">
                                                check_circle_outline
                                            </span>
                                        </button>
                                    </form>
                                    <form action="' . route('go.ver_check_cordinadora2') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button class="btn">
                                            <span class="material-icons-round">
                                                visibility
                                            </span>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div
                    </td>';
            }
            $table .= "</tr>";
        }
        foreach ($instalacion_upgrade_encurso  as $d1) {
            $fecha = Carbon::createFromDate($d1->fecha)->format('d-m-Y H:s');
            $table .= "<tr>";
            $table .= "<td>" . $d1->nombre_uno . " " . $d1->apellido_uno . "</td>";
            $table .= "<td>" . $fecha . "</td>";
            $table .= "<td>" . $d1->cliente . "</td>";
            $table .= "<td>" . $d1->serie . "</td>";
            if ($d1->tipo == "retiro") {
                $table .=
                    '<td>
                        <div class="dropdown dropleft">
                            <button type="button" class="btn-dropdown" data-toggle="dropdown" aria-expanded="false">
                                <span class="material-icons">more_vert</span>
                            </button>
                            <div class="dropdown-menu mostrar shadow">
                                <div class="d-flex justify-content-around">
                                    <form action="' . route('go.ver_check_retirocordinadora2') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button class="btn">
                                            <span class="material-icons-round">
                                                visibility
                                            </span>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div
                    </td>';
            } else {
                $table .=
                    '<td>
                        <div class="dropdown dropleft">
                            <button type="button" class="btn-dropdown" data-toggle="dropdown" aria-expanded="false">
                                <span class="material-icons">more_vert</span>
                            </button>
                            <div class="dropdown-menu mostrar shadow">
                                <div class="d-flex justify-content-around">
                                    <form action="' . route('go.finalizamanual_home') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">   
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button class="btn">
                                            <span class="material-icons-round">
                                                check_circle_outline
                                            </span>
                                        </button>
                                    </form>
                                    <form action="' . route('go.ver_check_cordinadora2') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button class="btn">
                                            <span class="material-icons-round">
                                                visibility
                                            </span>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div
                    </td>';
            }
            $table .= "</tr>";
        }
        return $table;
    }
    public function revisar_porreasignar_coordinador()
    {
        $datos_trabajador = DB::table('trabajadors')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select('trabajadors.id', 'personas.nombre_uno', 'personas.apellido_uno')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();

        $id_trabajador = $datos_trabajador[0]->id;

        //ESTADO PORREASIGNAR PARA COORDINADOR 
        $retiros_comtecglobal_encurso = DB::connection('comtecglobal')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_retiros.trabajadors_idtecnico')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_retiros.csSerie as serie',
                'checklist_retiros.csComuna as comuna',
                'checklist_retiros.csRegion as region',
                'checklist_retiros.Cscliente as cliente',
                'asignacion_retiros.tipo',
                'asignacion_retiros.id',
                'retiros.proveedor_retiro as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_retiros.fecha_asignado',
            )
            ->where('asignacion_retiros.estado_asignacion', '=', 'reasignar');
        $instalacion_comtecglobal_encurso  = DB::connection('comtecglobal')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_instalacions.CsSerie as serie',
                'checklist_instalacions.Cscomuna as comuna',
                'checklist_instalacions.Csregion as region',
                'checklist_instalacions.Cscliente as cliente',
                'asignacion_instalacions.tipo',
                'asignacion_instalacions.id',
                'instalacions.proveedor_instalacion as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_instalacions.fecha_asignado',
            )
            ->where('asignacion_instalacions.estado_asignacion', '=', 'reasignar')
            ->where('instalacions.sEstado_instalacion', '=', 'reasignar')
            ->union($retiros_comtecglobal_encurso)
            ->get();
        $retiros_kyocera_encurso  = DB::connection('kyocera')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_retiros.trabajadors_idtecnico')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_retiros.csSerie as serie',
                'checklist_retiros.csComuna as comuna',
                'checklist_retiros.csRegion as region',
                'checklist_retiros.Cscliente as cliente',
                'asignacion_retiros.tipo',
                'asignacion_retiros.id',
                'retiros.proveedor_retiro as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_retiros.fecha_asignado',
            )
            ->where('asignacion_retiros.estado_asignacion', '=', 'reasignar');
        $instalacion_kyocera_encurso  = DB::connection('kyocera')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_instalacions.CsSerie as serie',
                'checklist_instalacions.Cscomuna as comuna',
                'checklist_instalacions.Csregion as region',
                'checklist_instalacions.Cscliente as cliente',
                'asignacion_instalacions.tipo',
                'asignacion_instalacions.id',
                'instalacions.proveedor_instalacion as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_instalacions.fecha_asignado',
            )
            ->where('asignacion_instalacions.estado_asignacion', '=', 'reasignar')
            ->where('instalacions.sEstado_instalacion', '=', 'reasignar')
            ->union($retiros_kyocera_encurso)
            ->get();

        $retiros_upgrade_encurso  = DB::connection('upgrade')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_retiros.trabajadors_idtecnico')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_retiros.csSerie as serie',
                'checklist_retiros.csComuna as comuna',
                'checklist_retiros.csRegion as region',
                'checklist_retiros.Cscliente as cliente',
                'asignacion_retiros.tipo',
                'asignacion_retiros.id',
                'retiros.proveedor_retiro as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_retiros.fecha_asignado',
            )
            ->where('asignacion_retiros.estado_asignacion', '=', 'reasignar');
        $instalacion_upgrade_encurso  = DB::connection('upgrade')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_instalacions.CsSerie as serie',
                'checklist_instalacions.Cscomuna as comuna',
                'checklist_instalacions.Csregion as region',
                'checklist_instalacions.Cscliente as cliente',
                'asignacion_instalacions.tipo',
                'asignacion_instalacions.id',
                'instalacions.proveedor_instalacion as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_instalacions.fecha_asignado',
            )
            ->where('asignacion_instalacions.estado_asignacion', '=', 'reasignar')
            ->where('instalacions.sEstado_instalacion', '=', 'reasignar')
            ->union($retiros_upgrade_encurso)
            ->get();

        $table = "";
        foreach ($instalacion_comtecglobal_encurso  as $d1) {
            $fecha = Carbon::createFromDate($d1->fecha_asignado)->format('d-m-y');
            $table .= "<tr>";
            $table .= "<td>" . $d1->nombre_uno . " " . $d1->apellido_uno . "</td>";
            $table .= "<td>" . $fecha . "</td>";
            $table .= "<td>" . $d1->cliente  . "</td>";
            $table .= "<td>" . $d1->serie . "</td>";
            if ($d1->tipo == "retiro") {
                $table .=
                    '<td>
                        <form action="' . route('go.asignar_check_retiro_home') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
            } else {
                $table .=
                    '<td>
                        <form action="' . route('go.asignar_check_home') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
            }
            $table .= "</tr>";
        }
        foreach ($instalacion_kyocera_encurso  as $d1) {
            $fecha = Carbon::createFromDate($d1->fecha_asignado)->format('d-m-y');
            $table .= "<tr>";
            $table .= "<td>" . $d1->nombre_uno . " " . $d1->apellido_uno . "</td>";
            $table .= "<td>" . $fecha . "</td>";
            $table .= "<td>" . $d1->cliente . "</td>";
            $table .= "<td>" . $d1->serie . "</td>";
            if ($d1->tipo == "retiro") {
                $table .=
                    '<td>
                        <form action="' . route('go.asignar_check_retiro_home') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
            } else {
                $table .=
                    '<td>
                        <form action="' . route('go.asignar_check_home') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
            }
            $table .= "</tr>";
        }
        foreach ($instalacion_upgrade_encurso  as $d1) {
            $fecha = Carbon::createFromDate($d1->fecha_asignado)->format('d-m-y');
            $table .= "<tr>";
            $table .= "<td>" . $d1->nombre_uno . " " . $d1->apellido_uno . "</td>";
            $table .= "<td>" . $fecha . "</td>";
            $table .= "<td>" . $d1->cliente . "</td>";
            $table .= "<td>" . $d1->serie . "</td>";
            if ($d1->tipo == "retiro") {
                $table .=
                    '<td>
                        <form action="' . route('go.asignar_check_retiro_home') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
            } else {
                $table .=
                    '<td>
                        <form action="' . route('go.asignar_check_home') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
            }
            $table .= "</tr>";
        }
        return $table;
    }
    public function seguimiento(request $request)
    {
        $serie = $request->serie;

        $retiros_comtecglobal_seguimiento = DB::connection('comtecglobal')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_retiros.trabajadors_idtecnico')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_retiros.csSerie as serie',
                'checklist_retiros.csComuna as comuna',
                'checklist_retiros.csRegion as region',
                'checklist_retiros.Cscliente as cliente',
                'asignacion_retiros.tipo',
                'asignacion_retiros.id',
                'retiros.proveedor_retiro as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_retiros.fecha_asignado',
                'retiros.sEstado as estado',
                'checklist_retiros.estado_inicio'
            )
            ->where('checklist_retiros.csSerie', '=', $serie);
        $instalacion_comtecglobal_seguimiento  = DB::connection('comtecglobal')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_instalacions.CsSerie as serie',
                'checklist_instalacions.Cscomuna as comuna',
                'checklist_instalacions.Csregion as region',
                'checklist_instalacions.Cscliente as cliente',
                'asignacion_instalacions.tipo',
                'asignacion_instalacions.id',
                'instalacions.proveedor_instalacion as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_instalacions.fecha_asignado',
                'instalacions.sEstado_instalacion as estado',
                'checklist_instalacions.estado_inicio'
            )
            ->where('checklist_instalacions.CsSerie', '=', $serie)
            ->orwhere('checklist_instalacions.CsSerie_es', '=', $serie)
            ->union($retiros_comtecglobal_seguimiento)
            ->orderBy('id','desc')
            ->take(1)
            ->get();
        $retiros_kyocera_seguimiento  = DB::connection('kyocera')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_retiros.trabajadors_idtecnico')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_retiros.csSerie as serie',
                'checklist_retiros.csComuna as comuna',
                'checklist_retiros.csRegion as region',
                'checklist_retiros.Cscliente as cliente',
                'asignacion_retiros.tipo',
                'asignacion_retiros.id',
                'retiros.proveedor_retiro as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_retiros.fecha_asignado',
                'retiros.sEstado as estado',
                'checklist_retiros.estado_inicio'
            )
            ->where('checklist_retiros.csSerie', '=', $serie);
        $instalacion_kyocera_seguimiento  = DB::connection('kyocera')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_instalacions.CsSerie as serie',
                'checklist_instalacions.Cscomuna as comuna',
                'checklist_instalacions.Csregion as region',
                'checklist_instalacions.Cscliente as cliente',
                'asignacion_instalacions.tipo',
                'asignacion_instalacions.id',
                'instalacions.proveedor_instalacion as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_instalacions.fecha_asignado',
                'instalacions.sEstado_instalacion as estado',
                'checklist_instalacions.estado_inicio'
            )
            ->where('checklist_instalacions.CsSerie', '=', $serie)
            ->orwhere('checklist_instalacions.CsSerie_es', '=', $serie)
            ->union($retiros_kyocera_seguimiento)
            ->orderBy('id','desc')
            ->take(1)
            ->get();

        $retiros_upgrade_seguimiento  = DB::connection('upgrade')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_retiros.trabajadors_idtecnico')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_retiros.csSerie as serie',
                'checklist_retiros.csComuna as comuna',
                'checklist_retiros.csRegion as region',
                'checklist_retiros.Cscliente as cliente',
                'asignacion_retiros.tipo',
                'asignacion_retiros.id',
                'retiros.proveedor_retiro as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_retiros.fecha_asignado',
                'retiros.sEstado as estado',
                'checklist_retiros.estado_inicio'
            )
            ->where('checklist_retiros.csSerie', '=', $serie);
        $instalacion_upgrade_seguimiento  = DB::connection('upgrade')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_instalacions.CsSerie as serie',
                'checklist_instalacions.Cscomuna as comuna',
                'checklist_instalacions.Csregion as region',
                'checklist_instalacions.Cscliente as cliente',
                'asignacion_instalacions.tipo',
                'asignacion_instalacions.id',
                'instalacions.proveedor_instalacion as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_instalacions.fecha_asignado',
                'instalacions.sEstado_instalacion as estado',
                'checklist_instalacions.estado_inicio'
            )
            ->where('checklist_instalacions.CsSerie', '=', $serie)
            ->orwhere('checklist_instalacions.CsSerie_es', '=', $serie)
            ->union($retiros_upgrade_seguimiento)
            ->orderBy('id','desc')
            ->take(1)
            ->get();

        $table = "";
        foreach ($instalacion_comtecglobal_seguimiento as $d1) {
            $estado = $d1->estado;
            $estado_inicio = $d1->estado_inicio;
            $table .= "<tr>";
            $table .= "<td>" . $d1->nombre_uno . " " . $d1->apellido_uno . "</td>";
            $table .= "<td>" . $d1->fecha_asignado . "</td>";
            $table .= "<td>" . $d1->cliente . "</td>";
            $table .= "<td>" . $d1->region . "</td>";
            $table .= "<td>" . $d1->comuna . "</td>";
            $table .= "<td>" . $d1->serie . "</td>";
            $table .= "<td>" . $d1->tipo . "</td>";
            $table .= "</tr>";
        }
        foreach ($instalacion_kyocera_seguimiento  as $d1) {
            $estado = $d1->estado;
            $estado_inicio = $d1->estado_inicio;
            $table .= "<tr>";
            $table .= "<td>" . $d1->nombre_uno . " " . $d1->apellido_uno . "</td>";
            $table .= "<td>" . $d1->fecha_asignado . "</td>";
            $table .= "<td>" . $d1->cliente . "</td>";
            $table .= "<td>" . $d1->region . "</td>";
            $table .= "<td>" . $d1->comuna . "</td>";
            $table .= "<td>" . $d1->serie . "</td>";
            $table .= "<td>" . $d1->tipo . "</td>";
            $table .= "</tr>";
        }
        foreach ($instalacion_upgrade_seguimiento  as $d1) {
            $estado = $d1->estado;
            $estado_inicio = $d1->estado_inicio;
            $table .= "<tr>";
            $table .= "<td>" . $d1->nombre_uno . " " . $d1->apellido_uno . "</td>";
            $table .= "<td>" . $d1->fecha_asignado . "</td>";
            $table .= "<td>" . $d1->cliente . "</td>";
            $table .= "<td>" . $d1->region . "</td>";
            $table .= "<td>" . $d1->comuna . "</td>";
            $table .= "<td>" . $d1->serie . "</td>";
            $table .= "<td>" . $d1->tipo . "</td>";
            $table .= "</tr>";
        }

        $array_[] = array(
            "table" => $table,
            "estado" => $estado,
            "estado_inicio" => $estado_inicio
        );
        return $array_;
    }
}
