@extends('menu/menu')
<style>
	.mostrar {
		display: none;
	}

	@media (max-width: 768px) {
		.mostrar {
			display: block;
		}
	}

	.selectBox {
		position: relative;
	}

	.overSelect {
		position: absolute;
		left: 0;
		right: 0;
		top: 0;
		bottom: 0;
	}

	#checkboxes2 {
		display: none;
		border: 1px #dadada solid;
		background-color: white;
	}

	#checkboxes2 label {
		display: block;
	}

	#checkboxes2 label:hover {
		background-color: #1e90ff;
	}

	/* canvas {
		width: 250px;
		height: 250px;
		background-color: #fff;
	}

	@media screen and (max-width: 768px) {
		canvas {
			width: 250px;
			height: 250px;
			z-index: 99999;
			float: center;
			background-color: #fff;
		}
	} */
</style>

<script src="{{ asset('js/jquery-3.4.1.min.js')  ?? ''}}"></script>
{{-- <script src="https://html2canvas.hertzen.com/dist/html2canvas.js"></script> --}}
<script src="{{ asset('js/html2canvas.js')  ?? ''}}"></script>
@section('content')
@if ( session('mensaje') )
<div class="alert alert-success">{{ session('mensaje') }}</div>
@endif
@if ( session('mensaje_error') )
<div class="alert alert-danger">{{ session('mensaje_error') }}</div>
@endif

<!-- body code goes here -->
<div class="mostrar" style="text-align: right">
	<a href="javascript: history.go(-1)"><img src="img/volver.png"></a>
</div>

<!-- body code goes here -->
<div class="container mt-5">
	<div class="title-vista mt-4">Checklist Servicios</div>
</div>

<div class="container my-5">

	<form action="{{route('finalizar.checklist.servicios',Crypt::encryptString($asignacion_solicitudes[0]->idAsig)) }}" method="POST" class="needs-validation" novalidate>
		@csrf
		<!-- Fila 1 ------------------------------------------------------>
		<div class="seccion-filtro">Asignación</div>
		<hr class="separador">
		<div class="row">
			<input type="hidden" value="{{$accion ?? ''}}" name="acc">
			<div class="col-sm-6 form-group ali">
				<label for="">Proyecto asociado</label>
				<input type="" class="form-control mayuscula" id="" placeholder="" name="" style="pointer-events: none" readonly="readonly" placeholder="" value="{{$apiSolicitud[0]->nombre ?? ''}}">
			</div>
			<div class="col-sm-3 form-group">
				<label for="">Numero OT</label>
				<input type="text" required class="form-control mayuscula" id="" placeholder="" name="numeroOT" value="{{$asignacion_solicitudes[0]->numero_ot	 ?? ''}}">

			</div>
			<div class="col-sm-3 form-group">
			</div>

			{{-- EN CAMINO --}}
			<div class="col-sm-3 form-group">
				<label for="">Fecha en Camino @if($asignacion_solicitudes[0]->fecha_transito == "") (SIN FECHA) @endif</label>
				<div class="input-group d-flex">
					@if($asignacion_solicitudes[0]->fecha_transito == "")
					<input type="" class="form-control mayuscula" id="idfecha1" placeholder="FECHA" name="" style="pointer-events: none" readonly="readonly" placeholder="" value="" name="">
					@else
					<input type="" class="form-control mayuscula" id="idfecha1" placeholder="FECHA" name="" style="pointer-events: none" readonly="readonly" placeholder="" value="{{Carbon\Carbon::createFromDate($asignacion_solicitudes[0]->fecha_transito ?? '')->format('d-m-Y H:i:s')}}" name="">
					@endif
					<div class="input-group-append">
						<a class="btn app-color" title="modificar" href="" data-toggle="modal" onclick="cambiosFechas(1)">
							<span class="material-icons-round">edit</span>
						</a>
					</div>
				</div>
			</div>
			{{-- EN LOCAL --}}
			<div class="col-sm-3 form-group">
				<label for="">Fecha en el Local @if($asignacion_solicitudes[0]->fecha_local == "") (SIN FECHA) @endif</label>
				<div class="input-group d-flex">
					@if($asignacion_solicitudes[0]->fecha_local == "")
					<input type="" class="form-control mayuscula" id="idfecha2" placeholder="FECHA" name="" style="pointer-events: none" readonly="readonly" placeholder="" value="" name="">
					@else
					<input type="" class="form-control mayuscula" id="idfecha2" placeholder="FECHA" name="" style="pointer-events: none" readonly="readonly" placeholder="" value="{{Carbon\Carbon::createFromDate($asignacion_solicitudes[0]->fecha_local ?? '')->format('d-m-Y H:i:s')}}" name="">
					@endif

					<div class="input-group-append">
						<a class="btn app-color" title="modificar" href="" data-toggle="modal" onclick="cambiosFechas(2)">
							<span class="material-icons-round">edit</span>
						</a>
					</div>
				</div>
			</div>
			{{-- INICIO --}}
			<div class="col-sm-3 form-group">
				<label for="">Fecha de Inicio @if($asignacion_solicitudes[0]->fecha_inicio == "") (SIN FECHA) @endif</label>
				<div class="input-group d-flex">
					@if($asignacion_solicitudes[0]->fecha_inicio == "")
					<input type="" class="form-control mayuscula" id="idfecha3" placeholder="FECHA" name="" style="pointer-events: none" readonly="readonly" placeholder="" value="" name="">

					@else
					<input type="" class="form-control mayuscula" id="idfecha3" placeholder="FECHA" name="" style="pointer-events: none" readonly="readonly" placeholder="" value="{{Carbon\Carbon::createFromDate($asignacion_solicitudes[0]->fecha_inicio ?? '')->format('d-m-Y H:i:s')}}" name="">

					@endif
					<div class="input-group-append">
						<a class="btn app-color" title="modificar" href="" data-toggle="modal" onclick="cambiosFechas(3)">
							<span class="material-icons-round">edit</span>
						</a>
					</div>
				</div>
			</div>
			{{-- FIN --}}
			<div class="col-sm-3 form-group">
				<label for="">Fecha de Termino @if($asignacion_solicitudes[0]->fecha_fin == "") (SIN FECHA) @endif</label>
				<div class="input-group d-flex">
					@if($asignacion_solicitudes[0]->fecha_fin == "")
					<input type="" class="form-control mayuscula" id="idfecha4" placeholder="FECHA" name="" style="pointer-events: none" readonly="readonly" placeholder="" name="" value="">
					@else
					<input type="" class="form-control mayuscula" id="idfecha4" placeholder="FECHA" name="" style="pointer-events: none" readonly="readonly" placeholder="" value="{{Carbon\Carbon::createFromDate($asignacion_solicitudes[0]->fecha_fin ?? '')->format('d-m-Y H:i:s')}}" name="">
					@endif
					<div class="input-group-append">
						<a class="btn app-color" title="modificar" href="" data-toggle="modal" onclick="cambiosFechas(4)">
							<span class="material-icons-round">edit</span>
						</a>
					</div>
				</div>
			</div>
		</div>

						<!-- SLA -->
						<div class="row">
				<div class="col-sm-3 form-group">
					<label for="">Tiempo Asignacion</label>
					   <div class="input-group d-flex">

						@if($asignacion_solicitudes[0]->fecha_asignacion   == "")
						<input type="" class="form-control mayuscula" id="idfecha4" placeholder="FECHA" name="" style="pointer-events: none" readonly="readonly" placeholder="" name="" value="0">

						@else
						
							@php
							   $var = \App\Api_solicitudes::calcularHoraDos($fechaIngreso ,$asignacion_solicitudes[0]->sProveedor,$asignacion_solicitudes[0]->sRegion,$asignacion_solicitudes[0]->fecha_asignacion);	
							@endphp
							<input type="" class="form-control mayuscula" id="idfecha4" placeholder="FECHA" name="" style="pointer-events: none" readonly="readonly" placeholder="" name="" value="{{$var[1]}}">
						@endif
						</div>
				</div>
				<div class="col-sm-3 form-group">
					<label for="">Fecha recepción ticket</label>
					   <div class="input-group d-flex">

						
							<input type="" class="form-control mayuscula" id="idfecha4" placeholder="FECHA" name="" style="pointer-events: none" readonly="readonly" placeholder="" name="" value="{{Carbon\Carbon::createFromDate($fechaIngreso ?? '')->format('d-m-Y H:i:s') ?? ''}}">

						</div>
				</div>
				
				<div class="col-sm-3 form-group">
					<label for="">SLA</label>
					   <div class="input-group d-flex">
						<!-- {{$asignacion_solicitudes}} -->

						@if($asignacion_solicitudes[0]->fecha_fin  == "")

				
					 <input type="" class="form-control mayuscula" id="idfecha4" placeholder="FECHA" name="" style="pointer-events: none" readonly="readonly" placeholder="" name="" value="0">

						@else
						@php
						$var = \App\Api_solicitudes::calcularHoraDos($fechaIngreso,$asignacion_solicitudes[0]->sProveedor,$asignacion_solicitudes[0]->sRegion,$asignacion_solicitudes[0]->fecha_fin);	
					 @endphp
					 <input type="" class="form-control mayuscula" id="idfecha4" placeholder="FECHA" name="" style="pointer-events: none" readonly="readonly" placeholder="" name="" value="{{$var[1]}}">

						@endif
			
						</div>
				</div>
				<div class="col-sm-3 form-group">
					<label for="">Tiempo Aceptacion</label>
					   <div class="input-group d-flex">
						@if($asignacion_solicitudes[0]->fecha_revision  == "")
						<input type="" class="form-control mayuscula" id="idfecha4" placeholder="FECHA" name="" style="pointer-events: none" readonly="readonly" placeholder="" name="" value="0">

						@else

							@php
							   $var = \App\Api_solicitudes::calcularHoraDos($asignacion_solicitudes[0]->fecha_fin ,$asignacion_solicitudes[0]->sProveedor,$asignacion_solicitudes[0]->sRegion,$asignacion_solicitudes[0]->fecha_revision);	
							@endphp
							<input type="" class="form-control mayuscula" id="idfecha4" placeholder="FECHA" name="" style="pointer-events: none" readonly="readonly" placeholder="" name="" value="{{$var[1]}}">
						@endif
						</div>
				</div>
				
		    </div>
		<!-- Fila 2 ------------------------------------------------------>
		<div class="seccion-filtro mt-2">Detalla del cliente</div>
		<hr class="separador">
		<div class="row">
			<div class="col-sm-3 form-group">
				<label for="">Cliente</label>
				<input type="" class="form-control mayuscula" id="" placeholder="" name="" style="pointer-events: none" readonly="readonly" value="{{$apiSolicitud[0]->sCliente ?? ''}}">
			</div>
			<div class="col-sm-3 form-group">
				<label for="">Fecha</label>
				<input type="" class="form-control mayuscula" id="" placeholder="FECHA" name="" style="pointer-events: none" readonly="readonly" value="{{Carbon\Carbon::createFromDate($asignacion_solicitudes[0]->fecha ?? '')->format('d-m-Y') ?? ''}}" name="">
			</div>
			<div class="col-sm-3 form-group">
				<label for="">Dirección</label>
				<input type="" class="form-control mayuscula" id="" placeholder="" name="" style="pointer-events: none" readonly="readonly" value="{{$asignacion_solicitudes[0]->sDireccion ?? ''}}" name="">
			</div>
			<div class="col-sm-3 form-group">
				<label for="">Comuna</label>
				<input type="" class="form-control mayuscula" id="" placeholder="" name="" style="pointer-events: none" readonly="readonly" value="{{$asignacion_solicitudes[0]->sComuna ?? ''}}" name="">
			</div>
			<!-- Fila 3 ------------------------------------------------------>
			<div class="col-sm-6 form-group">
				<label for="">Contacto</label>
				<input type="" class="form-control mayuscula" id="" placeholder="" name="" style="pointer-events: none" readonly="readonly" value="{{$asignacion_solicitudes[0]->sContacto ?? ''}}" name="">
			</div>
			<div class="col-sm-3 form-group">
				<label for="">Telefono</label>
				<input type="" class="form-control mayuscula" id="" placeholder="" name="" style="pointer-events: none" readonly="readonly" value="{{$asignacion_solicitudes[0]->sTelefono ?? ''}}" name="">
			</div>

		</div>

		<!-- Fila 4 ------------------------------------------------------>
		<div class="seccion-filtro mt-2">Detalle de equipamiento</div>
		<hr class="separador">
		<div class="row">
		<div class="col-sm-3 form-group">
				<label for="">Equipo</label>
				<input type="" class="form-control mayuscula" id="" placeholder="" name="" style="pointer-events: none" readonly="readonly" value="{{$asignacion_solicitudes[0]->equipos ?? ''}}" name="">
			</div>
			<div class="col-sm-3 form-group">
				<label for="">Marca</label>
				<div class="input-group d-flex">

				<input type="" required class="form-control mayuscula" id="lamarcaid" placeholder="" name="marca" required  value="{{ @old('marca',$asignacion_solicitudes[0]->Smarca ?? '')}}" name="">
				<div class="input-group-append">
					<a class="btn app-color" title="modificar" href="" data-toggle="modal" onclick="modificarMarca(3)">
						<span class="material-icons-round">edit</span>
					</a>
				</div>
			</div>

			</div>
			<div class="col-sm-3 form-group">
				<label for="">Modelo</label>
				<input type="" class="form-control mayuscula" id="" placeholder="" name="" style="pointer-events: none" readonly="readonly" value="{{$asignacion_solicitudes[0]->sModelo ?? ''}}" name="">
			</div>
			<div class="col-sm-3 form-group">
				<label for="">Serie</label>
				<div class="input-group d-flex">

				<input type="" required class="form-control mayuscula" id="numerodeserieid" placeholder="" name="" style="pointer-events: none" readonly="readonly" value="{{$asignacion_solicitudes[0]->sSerie ?? ''}}" name="">
				<div class="input-group-append">
						<a class="btn app-color" title="modificar" href="" data-toggle="modal" onclick="modificarSerie()">
							<span class="material-icons-round">edit</span>
						</a>
					</div>
				</div>
			
			</div>
			{{-- <div class="col-sm-3 form-group">
				<label for="">Serie</label>
				<input type="" required class="form-control mayuscula" id="" placeholder="" name="" style="pointer-events: none" readonly="readonly" value="{{$asignacion_solicitudes[0]->sSerie ?? ''}}" name="">
			</div> --}}
			<div class="col-sm-3 form-group">
				<label for="">Contadores B/N (*)</label>
				<input type="" required class="form-control mayuscula" id="" placeholder="" name="contadorBN" value="{{$asignacion_solicitudes[0]->contador_bn ?? ''}}">
			</div>
			<div class="col-sm-3 form-group">
				<label for="">Contadores Color (*)</label>
				<input type="" required class="form-control mayuscula" id="" placeholder="" name="ContadorColor" value="{{$asignacion_solicitudes[0]->contador_color ?? ''}}" name="">
			</div>
		
			
			<div class="col-sm-3 form-group">
				<label for="">IP (*)</label>
				<input type="" required class="form-control mayuscula" id="" placeholder="" name="ip" value="{{$asignacion_solicitudes[0]->ip ?? ''}}" name="">
			</div>
			<div class="col-sm-3 form-group">
				<label for="">USB (*)</label>
				<input type="" required class="form-control mayuscula" id="" placeholder="usb" name="usb" value="{{$asignacion_solicitudes[0]->usb ?? ''}}" name="">
			</div>
		
			<div class="col-sm-3 form-group">
				<label for="">Toner 1</label>
				<!-- <input type="" required class="form-control mayuscula" id="" placeholder="usb" name="usb"  value="{{@old('usb')}}" name=""> -->
				<input type="number" required class="form-control mayuscula" id="" style="pointer-events: none" readonly="readonly" placeholder="" name="t_uno" value="{{$asignacion_solicitudes[0]->t_uno ?? ''}}">

			</div>
			<div class="col-sm-3 form-group">
				<label for="">Toner 2</label>
				<!-- <input type="number" required class="form-control mayuscula" id="" style="pointer-events: none" readonly="readonly" placeholder="usb" name="usb"  value="{{@old('usb')}}" > -->
				<input type="number" required class="form-control mayuscula" id="" style="pointer-events: none" readonly="readonly" placeholder="" name="t_dos" value="{{$asignacion_solicitudes[0]->t_dos ?? ''}}">

			</div>
			<div class="col-sm-3 form-group">
				<label for="">Toner 3</label>
				<!-- <input type="number" required class="form-control mayuscula" id="" style="pointer-events: none" readonly="readonly" placeholder="usb" name="usb"  value="{{@old('usb')}}" > -->
				<input type="number" required class="form-control mayuscula" id="" style="pointer-events: none" readonly="readonly" placeholder="" name="t_tres" value="{{$asignacion_solicitudes[0]->t_tres ?? ''}}">

			</div>

			<!-- Fila 5 ------------------------------------------------------>

			<!-- Fila 6 ------------------------------------------------------>

			<!-- Fila 7 ------------------------------------------------------>

		</div>

		<!-- Fila 9 - Accesorios ----------------------------------------------------->
		<div class="row">
			<div class="col-sm-12">
				<div class="seccion-filtro mt-2">Reporte del Cliente</div>
				<hr class="separador">
				<div class="row">
					<!-- FILA 9.1 -->
					<div class="col-md-12 form-group ">
						<div class="">
							<label class="" for="">Descripcion</label><span  style="cursor: pointer" class="material-icons-round"  data-toggle="modal" data-target="#modaldescripcion">edit</span>
							<textarea class="form-control mayuscula" required name="descripcionApiServicios" id="cambio" cols="30" rows="10"> {{$asignacion_solicitudes[0]->descripcion ?? ''}}</textarea>
						</div>
					</div>

					<!-- FILA 9.2 -->


					<!-- FILA 9.3 -->


					<!-- FILA 8.4 -->

				</div>
			</div>
			<div class="col-sm-6">
				{{-- para diferenciar si es manual  o no  --}}
				@if(!empty($manual))
				<input type="text" id="tipo_instalacion" name="tipo_instalacion" style="display:none" value="{{$manual  ?? '' ?? ''}}">
				@else
				<input type="text" id="tipo_instalacion" name="tipo_instalacion" style="display:none" value="no">
				@endif

			</div>
		</div>

		<!-- Fila 10 - ----------------------------------------------------
		<div class="seccion-filtro mt-2">Nº de serie, Componentes sustituidos</div>
		<hr class="separador">
		<div class="row bg-destacar pt-3">
			<div class="col-sm-12 form-group checkbox d-flex">
				<label class="mr-3" for="">Componentes</label>
				<div class="custom-control custom-checkbox mr-3">
					@if($asignacion_solicitudes[0]->tipo_componente == "")
					<input type="checkbox" class="custom-control-input" id="componentes_si" disabled name="componentes_si">
					@else
					<input type="checkbox" class="custom-control-input" id="componentes_si" disabled checked name="componentes_si">
					@endif
					<label class="custom-control-label" for="componentes_si">Si</label>
				</div>
				<div class="custom-control custom-checkbox mr-3">
					@if($asignacion_solicitudes[0]->tipo_componente == "")
					<input type="checkbox" class="custom-control-input" id="componentes_no" disabled checked name="componentes_no">
					@else
					<input type="checkbox" class="custom-control-input" id="componentes_no" disabled name="componentes_no">
					@endif
					<label class="custom-control-label" for="componentes_no">No</label>
				</div>
			</div>
			@if($asignacion_solicitudes[0]->tipo_componente == "")
			<div style="display:none">
				@else
				<div>
					@endif
					<div class="col-sm-12 form-group checkbox d-flex">
						<label class="mr-3" for="">Tipo</label>
						<div class="custom-control custom-checkbox mr-3">
							@if($asignacion_solicitudes[0]->tipo_componente === "blanco y negro" )
							<input type="checkbox" class="custom-control-input" id="maquina_b_n" name="maquina_b_n" checked disabled>
							@else
							<input type="checkbox" class="custom-control-input" id="maquina_b_n" name="maquina_b_n" disabled>
							@endif
							<label class="custom-control-label" for="maquina_b_n">B/N</label>
						</div>
						<div class="custom-control custom-checkbox">
							@if($asignacion_solicitudes[0]->tipo_componente === "color" )
							<input type="checkbox" class="custom-control-input" id="maquina_color" name="maquina_color" checked disabled>
							@else
							<input type="checkbox" class="custom-control-input" id="maquina_color" name="maquina_color" disabled>
							@endif
							<label class="custom-control-label" for="maquina_color">Color</label>
						</div>
					</div>
				</div>
				@if($asignacion_solicitudes[0]->tipo_componente == "")
				<div class="col-sm-12" style="display:none">
					@else
					<div class="col-sm-12">
						@endif
						<table class="table table-hover" id="tabla2">
							<thead class="bg-light">
								<th scope="col">Tipo</th>
								<th scope="col">Nombre de Pieza</th>
								<th scope="col">Numero Parte</th>
								<th scope="col">S/N Parte</th>
								<th scope="col">Cantidad</th>
							</thead>
							<tbody id="agregar_accesorios2">
								<td>DV - UN Revelado(s)</td>
								@foreach ($tipo_equipamientos_dvRevelado as $key => $los_datos)
								<tr class="2eliminar{{$key+1}}">
									<td>
										{{$los_datos->tipo}}
									</td>
									<td>
										{{$los_datos->descripcion}}
									</td>
									<td>
										{{$los_datos->numero_parte}}
									</td>
									<td>
										{{$los_datos->sn_parte}}
									</td>
									<td>
										{{$los_datos->cantidad}}
									</td>
								</tr>
								@endforeach
								<td>DDK - UN Cilindro(s)</td>
								@foreach ($tipo_equipamientos_dkCilindro as $key => $los_datos)
								<tr class="2eliminar{{$key+1}}">
									<td>
										{{$los_datos->tipo}}
									</td>
									<td>
										{{$los_datos->descripcion}}
									</td>
									<td>
										{{$los_datos->numero_parte}}
									</td>
									<td>
										{{$los_datos->sn_parte}}
									</td>

									<td>
										{{$los_datos->cantidad}}
									</td>
								</tr>
								@endforeach
								<td>Detalle del equipamiento</td>
								@foreach ($tipo_equipamientos_detalleEquipamiento as $key => $los_datos)
								<tr class="2eliminar{{$key+1}}">
									<td>
										{{$los_datos->tipo}}
									</td>
									<td>
										{{$los_datos->descripcion}}
									</td>
									<td>
										{{$los_datos->numero_parte}}
									</td>
									<td>
										{{$los_datos->sn_parte}}
									</td>

									<td>
										{{$los_datos->cantidad}}
									</td>
								</tr>
								@endforeach
							</tbody>
						</table>
					</div>
				</div>-->

				<div class="seccion-filtro mt-2">Solicitud de accesorios</div>
				<hr class="separador">
				<!-- Fila 13 ------------------>
				<div class="row bg-destacar py-3">
					<div class="col-sm-12 form-group checkbox d-flex">
						<label class="mr-3" for="">Solicitar accesorios</label>
						<div class="custom-control custom-checkbox mr-3">
							@if ( $asignacion_solicitudes[0]->solicita_acessorios === "si" )
							<input type="checkbox" class="custom-control-input" disabled checked id="accesorios_si" name="accesorios_si">
							@else
							<input type="checkbox" class="custom-control-input" disabled id="accesorios_si" name="accesorios_si">
							@endif
							<label class="custom-control-label" for="accesorios_si">Si</label>
						</div>
						<div class="custom-control custom-checkbox mr-3">
							@if($asignacion_solicitudes[0]->solicita_acessorios === "no")
							<input type="checkbox" class="custom-control-input" disabled checked id="accesorios_no" name="accesorios_no">
							@else
							<input type="checkbox" class="custom-control-input" disabled id="accesorios_no" name="accesorios_no">
							@endif

							<label class="custom-control-label" for="accesorios_no">No</label>
						</div>
					</div>
					@if ( $asignacion_solicitudes[0]->solicita_acessorios === "si" )
					<!--MOTIVOS-->
					<div class="col-sm-12 form-group checkbox" id="motivos" style="display:">
						<label for="" class="mr-3">Motivo</label>
						<div class=" d-flex flex-wrap">
							<div class="custom-control custom-checkbox mr-3">
								<input type="checkbox" class="custom-control-input" checked disabled>
								<label class="custom-control-label" for="motivo_1">{{$asignacion_solicitudes[0]->motivo_accesorio}}</label>
							</div>
						</div>
						@if($asignacion_solicitudes[0]->motivo_accesorio == "Garantia")
						<!--FOTOS-->
						<div class="container" id="fotos_accesorios" style="display:"><br><br>
							<button class="btn btn-secundario px-sm-5 " type="button" data-toggle="modal" data-target="#myModal">Ver imagenes</button>
						</div>
						@endif
					</div>
					@if($asignacion_solicitudes[0]->motivo_accesorio != "Garantia")
					<!--ACCESORIOS DAÑADOS-->
					<div class="container" id="div_accesorios_solicitados" style="display:">
						<div class="row">
							<div class="col-sm-12 seccion-filtro mt-2">Accesorios Dañados</div>
							<hr class="container mx-3 separador">

							<div class="container mx-3 mb-2" id="" style="max-height: 300px; border: 1px solid #ddd; border-radius: 6px; background: #ffffff; overflow-y: scroll;">
								<table class="table table-hover">
									<tbody id="accesorios"></tbody>
								</table>
							</div>
							<div class="col-sm-12">
								<table class="table table-hover">
									<thead class="bg-light">
										<th scope="col">Nombre de la pieza</th>
										<th scope="col">Numero de parte</th>
										<th scope="col">S/N parte</th>
										<th scope="col">Cantidad</th>

									</thead>
									<tbody id="">
										@foreach ($acceDanos as $key => $los_datos)
										<tr class="2eliminar{{$key+1}}">
											<td>
												{{$los_datos->descripcion}}
											</td>
											<td>
												{{$los_datos->articulo}}
											</td>
											<td>
												{{$los_datos->serie_parte}}
											</td>
											<td>
												{{$los_datos->cantidad}}
											</td>
										</tr>
										@endforeach
									</tbody>
								</table>
							</div>
						</div>
					</div>
					@endif
					<!--ACCESORIOS A SOLICITAR-->
					<div class="container" id="div_accesorios_solicitados" style="display:">
						<div class="row">
							<div class="col-sm-12 seccion-filtro mt-2">Accsesorios a Solicitar</div>
							<hr class="container mx-3 separador">
							<div class="container mx-3 mb-2" id="" style="max-height: 300px; border: 1px solid #ddd; border-radius: 6px; background: #ffffff; overflow-y: scroll;">
								<table class="table table-hover">
									<tbody id="accesorios"></tbody>
								</table>
							</div>
							<div class="col-sm-12">
								<table class="table table-hover">
									<thead class="bg-light">
										<th scope="col">Nombre de la pieza</th>
										<th scope="col">Numero de parte</th>
										<th scope="col">S/N parte</th>
										<th scope="col">Cantidad</th>
									</thead>
									<tbody>
										@foreach ($acceSoli as $key => $los_datos)
										<tr class="2eliminar{{$key+1}}">
											<td>
												{{$los_datos->descripcion}}
											</td>
											<td>
												{{$los_datos->articulo}}
											</td>
											<td>
												{{$los_datos->serie_parte}}
											</td>
											<td>
												{{$los_datos->cantidad}}
											</td>
										</tr>
										@endforeach

									</tbody>
								</table>
							</div>
						</div>
					</div>
					<div class="container" id="div_accesorios_manual" style="display:">
						<div class="row">
							<div class="col-sm-12 seccion-filtro mt-2">Ingrese accesorios manualmente</div>
							<hr class="container mx-3 separador">
							<div class="col-sm-12">
								<table class="table table-hover" id="">
									<thead class="bg-light">
										<th scope="col">Nombre de la pieza</th>
										<th scope="col">Numero de parte</th>
										<th scope="col">S/N parte</th>
										<th scope="col">Cantidad</th>
										<th scope="col">Observaciones</th>
									</thead>
									<tbody>
										@foreach ($accesorios_manuales as $key => $los_datos)
										<tr>
											<td>
												{{$los_datos->nombre_parte}}
											</td>
											<td>
												{{$los_datos->numero_parte}}
											</td>
											<td>
												{{$los_datos->serie_parte}}
											</td>
											<td>
												{{$los_datos->cantidad}}
											</td>
											<td>
												{{$los_datos->observacion}}
											</td>
										</tr>
										@endforeach
									</tbody>
								</table>
							</div>
						</div>
					</div>
					@endif
				</div>
				<!--INSTALACION DE PARTES-->
				<div class="seccion-filtro mt-2">Instalacion de accesorios</div>
				<hr class="separador">
				<div class="row bg-destacar py-3">
					<div class="col-sm-12 form-group checkbox d-flex">
						<label class="mr-3" for="">Instalar accesorios</label>
						<div class="custom-control custom-checkbox mr-3">
							@if(count($instalacion_accesorios) != 0 || count($instalacion_accesorios_manuales) != 0 )
							<input type="checkbox" class="custom-control-input" checked id="accesorios_instalacion_si" name="accesorios_instalacion_si">
							@else
							<input type="checkbox" class="custom-control-input" id="accesorios_instalacion_si" name="accesorios_instalacion_si">
							@endif
							<label class="custom-control-label" for="accesorios_instalacion_si">Si</label>
						</div>
						<div class="custom-control custom-checkbox mr-3">
							@if(count($instalacion_accesorios) != 0 || count($instalacion_accesorios_manuales) != 0 )
							<input type="checkbox" class="custom-control-input" id="accesorios_instalacion_no" name="accesorios_instalacion_no">
							@else
							<input type="checkbox" class="custom-control-input" checked id="accesorios_instalacion_no" name="accesorios_instalacion_no">
							@endif
							<label class="custom-control-label" for="accesorios_instalacion_no">No</label>
						</div>
					</div>
					<div class="container">
						@if(count($instalacion_accesorios) != 0)
						<div class="container" id="div_accesorios_manual_instalacion" style="display:">
							@else
							<div class="container" id="div_accesorios_manual_instalacion" style="display:none">
								@endif
								<div class="row">
									<hr class="container mx-3 separador">
									<div class="col-12">
										<table class="table table-hover" id="tabla2">
											<thead class="bg-light">
												<th scope="col">Nombre de la pieza</th>
												<th scope="col">Numero de parte</th>
												<th scope="col">S/N parte</th>
												<th scope="col">Cantidad</th>
											</thead>
											<tbody>
												@foreach ($instalacion_accesorios as $key => $los_datos)
												<tr>
													<td>
														{{$los_datos->descripcion}}
													</td>
													<td>
														{{$los_datos->articulo}}
													</td>
													<td>
														{{$los_datos->serie_parte}}
													</td>
													<td>
														{{$los_datos->cantidad}}
													</td>
												</tr>
												@endforeach
											</tbody>
										</table>
									</div>
								</div>
							</div>
							<!--PARTES MANUAL INSTALACION DE ACCESORIOS-->
							@if(count($instalacion_accesorios_manuales) != 0)
							<div class="container" id="div_accesorios_manual_instalacion">
								@else
								<div class="container" id="div_accesorios_manual_instalacion" style="display:none">
									@endif
									<div class="row">
										<div class="col-12 seccion-filtro mt-2">Ingrese accesorios manualmente</div>
										<hr class="container mx-3 separador">
										<div class="col-12">
											<table class="table table-hover" id="tabla">
												<thead class="bg-light">
													<th scope="col">Nombre de la pieza</th>
													<th scope="col">Numero de parte</th>
													<th scope="col">S/N parte</th>
													<th scope="col">Cantidad</th>
													<th scope="col">Observaciones</th>
												</thead>
												<tbody id="agregar_accesorios_manual_instalacion">
													@foreach ($instalacion_accesorios_manuales as $key => $los_datos)
													<tr>
														<td>
															{{$los_datos->nombre_parte}}
														</td>
														<td>
															{{$los_datos->numero_parte}}
														</td>
														<td>
															{{$los_datos->serie_parte}}
														</td>
														<td>
															{{$los_datos->cantidad}}
														</td>
														<td>
															{{$los_datos->observacion}}
														</td>
													</tr>
													@endforeach
												</tbody>
											</table>
										</div>
									</div>
								</div>
							</div>
							<!--FINAL PARTES MANUAL INSTALACION DE ACCESORIOS-->
						</div>
						<div class="seccion-filtro mt-2">Repuestos solicitdados validado por</div>
						<hr class="separador">
						<div class="row">
							<div class="col-sm-12 form-group checkbox">
								<select name="validador" id="" class="form-control" disabled>
									<option value="" selected>{{$asignacion_solicitudes[0]->validador ?? 'no validado'}}</option>
								</select>
							</div>
						</div>
						<div class="seccion-filtro mt-2">Equipo operativo</div>
						<hr class="separador">
						<div class="row">
							<div class="col-sm-12 form-group checkbox">
								<label for="cambio">Observaciones</label>
							<span class="material-icons-round"  style="cursor: pointer" data-toggle="modal" data-target="#modalobservacion">edit</span>

								<textarea required class="form-control mayuscula" id="cambio_observacion" name="obsercaviones" rows="4" name="observaciones">{{$asignacion_solicitudes[0]->observaciones ?? ''}}</textarea>
								<div class="invalid-feedback">Este campo es requerido!</div>
							</div>
						</div>
						<div class="seccion-filtro mt-2">Datos</div>
						<hr class="separador">

						<div class="row">
							<div class="col-md-6">
								<div class="row">
									<div class="col-sm-12 form-group">
										<label for="">Datos del Técnico</label>
										<input required type="text" class="form-control mayuscula" placeholder="DATOS DEL CONTACTO" name="contacto_firma" value="{{ $datosTrabajador[0]->nombre_uno  ?? ''}} {{ $datosTrabajador[0]->apellido_uno  ?? ''}}">
									</div>
								</div>
								<div class="row">
									<div class="col-sm-12 form-group">
										@if(count($firmaTrabajador) != 0)
										<img id="pizarra" src="{{ asset ("fotos/".$firmaTrabajador[0]->url_firma ?? '')}}" alt="">
										@else
										@endif
									</div>
								</div>
							</div>
							<div class="col-md-6">
								<div class="row">
									<div class="col-sm-12 form-group">
										<label for="">Datos del Contacto</label>
										<input required type="text" class="form-control mayuscula" placeholder="DATOS DEL CONTACTO" name="contacto_firma" value="{{ $asignacion_solicitudes[0]->nombre_contacto_firma  ?? ''}}">
									</div>
									<div class="col-sm-12 form-group">
										<label for="">Correo Contacto</label>
										<div class="input-group d-flex">
											<input required type="text" class="form-control mayuscula" id="contacto_correo" placeholder="CORREO CONTACTO" readonly name="contacto_correo" value="{{ $asignacion_solicitudes[0]->correo_contacto  ?? ''}}">
											<div class="input-group-append">
												<a class="btn app-color" title="modificar" href="" data-toggle="modal" onclick="cambiocorreo()">
													<span class="material-icons-round">edit</span>
												</a>
											</div>
										</div>									
									</div>
									<div class="col-sm-12 form-group">
										<label for="">Firma Contacto</h2>
									</div>
									<div class="col-sm-12 form-group checkbox check-space">
										<div class="custom-control custom-checkbox">
											@if($asignacion_solicitudes[0]->firma_contacto === "si")
											<input type="checkbox" class="custom-control-input" checked id="no_firma_cliente" name="no_firma_cliente">
											@else
											<input type="checkbox" class="custom-control-input" id="no_firma_cliente" name="no_firma_cliente">
											@endif
											<label class="custom-control-label" for="no_firma_cliente">Cliente se niega a firmar</label>
										</div>
									</div>

									@if($asignacion_solicitudes[0]->firma_contacto === "si" )
									@if($asignacion_solicitudes[0]->url_firma != "")
									<div class="col-sm-12 form-group">
										<div id="contenido" class="container text-center bg-destacar mb-3" id='formCanvas'>
											<!-- <form id='formCanvas' method='post' action="{{route('guardandofotosprueba')}} " enctype='multipart/form-data'> -->
											<!-- @csrf -->
											<div class="container py-3 d-flex flex-wrap">
												<div class="mx-auto mb-3">
													{{-- Pizarra --}}

													<img id="pizarra" src="{{ asset ("fotos/".$asignacion_solicitudes[0]->url_firma)}}" alt="">

												</div>

											</div>

											<input type='hidden' name='imagen' id='imagen' />
											<!-- </form> -->
										</div>

									</div>
									@endif
									@endif

								</div>
							</div>
						</div>
						<hr class="separador">

						<div class="row">
							<div class="col-sm-4 form-group ">
								<label for="">Estado</label>
								<select disabled name="estado_finalizado" required__* class="custom-select mayuscula col-mb-3" id="estado">
									<option value="terminado">{{$asignacion_solicitudes[0]->estado_seleccionado}}</option>

								</select>
								@error('estado')
								<div class="alert alert-danger">{{ $message }}</div>
								@enderror
							</div>
							<div class="col-sm-4 form-group ">

							</div>

						</div>
						{{-- {{$asignacion_solicitudes[0]->estado_interno}} --}}
						@if($asignacion_solicitudes[0]->estado_interno != "tarea_asignada" & $asignacion_solicitudes[0]->estado_interno != "INICIADO")
						<div class="seccion-filtro mt-2">Imágenes</div>
						<hr class="separador">

						<div class="row">
							<div class="col-sm-12 form-group">
								@if($asignacion_solicitudes[0]->estado_interno == "REASIGNAR")
								<div class="mb-5 text-center">
									<button class="btn btn-secundario px-sm-5 " type="button" data-toggle="modal" data-target="#myModalTresFotos">Ver imágenes</button>
								</div>
								@else

								<div class="text-center modo-escritorio">
									{{-- {{$asignacion_solicitudes[0]->idAsig }} --}}
									{{-- {{$asignacion_solicitudes[0]->idAsig }} --}}
									<a class="btn btn-ter" target="_blank" href="{{route('generar.pdfCordinadoraServicios',Crypt::encryptString($asignacion_solicitudes[0]->idAsig ?? ''))}}">
										<span class="material-icons-round icon-midle">picture_as_pdf</span> Ver PDF</a>
								</div>
								{{-- {{$fotos}} --}}
								<div class="mb-5 text-center">
									<button class="btn btn-secundario px-sm-5 " type="button" data-toggle="modal" data-target="#myModalTresFotos">Ver imágenes</button>
								</div>

								{{-- <div class="text-center">
						<div class="float-md-left my-3">
							<a class="btn btn-secundario px-5 reasignar">Reasignar</a>
							<button class="btn btn-secundario px-5" id="rechazar" type="button">Rechazar</button>
						</div>

						<div class="float-md-right my-3">
							<a class="btn btn-secundario px-5" href="{{route('consumir.Ainstalacionserviciossolicitar',Crypt::encryptString($asignacion_solicitudes[0]->idAsig))}}">Solicitar repuestos</a>

								<a class="btn btn-prim px-5" href="{{route('consumir.Ainstalacionservicios',Crypt::encryptString($asignacion_solicitudes[0]->idAsig))}}">Aceptar</a>
							</div>
						</div> --}}

						{{-- <div class="text-center modo-mobil"></div> --}}

						<div class="float-md-right my-3">
							<a class="btn btn-secundario px-5" href="{{route('consumir.Ainstalacionserviciossolicitar',Crypt::encryptString($asignacion_solicitudes[0]->idAsig))}}">Solicitar repuestos</a>

							<a class="btn btn-prim px-5" href="{{route('consumir.Ainstalacionservicios',Crypt::encryptString($asignacion_solicitudes[0]->idAsig))}}">Aceptar</a>
						</div>
						@endif
						@endif
						<div class="text-center">
							<div class="float-md-left my-3">
								<a class="btn btn-secundario px-5 reasignar">Reasignar</a>
								<button class="btn btn-secundario px-5" id="rechazar" type="button">Rechazar</button>
							</div>

						</div>
					</div>
				</div>


			</div>
	</form>
</div>
<!-- FIN BARRA DE BUSQUEDA -->

<!-- Modal  Marca-->
<div class="modal fade" id="modalMarca" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
	<div class="modal-dialog" role="document">
		<div class="modal-content">

			<div class="modal-header">
				<h4 class="seccion-modal">Cambiar marca</h4>
				<button type="button" class="close" data-dismiss="modal">&times;</button>
			</div>
			<hr class="separador ml-4 mr-4">

			<div class="modal-body">
				<div class="container">
					<div class="row">
						<div class="col-sm-12 form-group">
							<input  class="form-control mayuscula"  type="text" name="" id="marcaseleccionada">					
							
							<input class="form-control mayuscula" type="hidden" value="{{$asignacion_solicitudes[0]->idAsig ?? ''}}" id="id_check_marca">
							
						</div>
					</div>
				</div>
			</div>

			<div class="modal-footer">
				<button type="button" class="btn btn-prim w-25 mx-auto" id="cambiarmarca">Guardar</button>
			</div>
		</div>
	</div>
</div>

<!-- Modal  Serie-->
<div class="modal fade" id="modalSerie" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
	<div class="modal-dialog" role="document">
		<div class="modal-content">

			<div class="modal-header">
				<h4 class="seccion-modal">Cambiar serie</h4>
				<button type="button" class="close" data-dismiss="modal">&times;</button>
			</div>
			<hr class="separador ml-4 mr-4">

			<div class="modal-body">
				<div class="container">
					<div class="row">
						<div class="col-sm-12 form-group">
							<input  class="form-control mayuscula"  type="text" name="" id="serieseleccionada">					
							
							<input class="form-control mayuscula" type="hidden" value="{{$asignacion_solicitudes[0]->idAsig ?? ''}}" id="id_check_serie">
							
						</div>
					</div>
				</div>
			</div>

			<div class="modal-footer">
				<button type="button" class="btn btn-prim w-25 mx-auto" id="cambiarSerie">Guardar</button>
			</div>
		</div>
	</div>
</div>

<!-- Modal  FECHA INICIO-->
<div class="modal fade" id="modalcalendario" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
	<div class="modal-dialog" role="document">
		<div class="modal-content">

			<div class="modal-header">
				<h4 class="seccion-modal">Cambiar fecha</h4>
				<button type="button" class="close" data-dismiss="modal">&times;</button>
			</div>
			<hr class="separador ml-4 mr-4">

			<div class="modal-body">
				<div class="container">
					<div class="row">
						<div class="col-sm-12 form-group">
							<input class="form-control mayuscula" type="datetime-local" id="fecha_cambio">
							<input class="form-control mayuscula" type="hidden" value="{{$asignacion_solicitudes[0]->idAsig ?? ''}}" id="id_check">
							<input class="form-control mayuscula" type="hidden" value="" id="opcionFecha">
						</div>
					</div>
				</div>
			</div>

			<div class="modal-footer">
				<button type="button" class="btn btn-prim w-25 mx-auto" id="cambiarfecha">Guardar</button>
			</div>
		</div>
	</div>
</div>
<!--Modal Ver imágenes------------------------------------------->
<div class="modal" id="myModal">
	<div class="modal-dialog">
		<div class="modal-content">

			<div class="modal-header">
				<h4 class="seccion-modal">Ver Imágenes</h4>
				<button type="button" class="close" data-dismiss="modal">&times;</button>
			</div>
			<hr class="separador ml-4 mr-4">

			<div class="modal-body">
				<div class="container">
					<!--Carrusel----------------------------------------------->
					<div id="demo" class="carousel slide" data-ride="carousel">

						<!--Indicaciones-->
						<ul class="carousel-indicators">
							<li data-target="#demo" data-slide-to="0" class="active"></li>
							<li data-target="#demo" data-slide-to="1"></li>
							<li data-target="#demo" data-slide-to="2"></li>
						</ul>

						<div class="carousel-inner">
							{{$valor = 0}}
							@if(!empty($fotos))
							@foreach ($fotos as $los_datos)

							@if($valor == 0)
							<div class="carousel-item active">
								<img src="{{ asset ("fotos/".$los_datos->url) ?? ''}}" alt="cajas" width="500" height="500">
							</div>
							{{$valor=1}}
							@else

							<div class="carousel-item">
								<img src="{{ asset ("fotos/".$los_datos->url ) ?? ''}}" alt="joya 1" width="500" height="500">
							</div>

							@endif
							@endforeach
							@endif
						</div>

						<!--Controles del acrrusel-->
						<a class="carousel-control-prev" href="#demo" data-slide="prev">
							<span class="carousel-control-prev-icon"></span>
						</a>
						<a class="carousel-control-next" href="#demo" data-slide="next">
							<span class="carousel-control-next-icon"></span>
						</a>
					</div>
					<!--Fin Carrusel---------------------------------------->
				</div>
			</div>

			<div class="modal-footer">
				<button type="button" class="btn btn-prim w-25 mx-auto" data-dismiss="modal">Cerrar</button>
			</div>
		</div>
	</div>
</div>


<!--Modal Ver imágenes-------------son las tres de abajo------------------------------>
<div class="modal" id="myModalTresFotos">
	<div class="modal-dialog">
		<div class="modal-content">

			<div class="modal-header">
				<h4 class="seccion-modal">Ver Imágenes</h4>
				<button type="button" class="close" data-dismiss="modal">&times;</button>
			</div>
			<hr class="separador ml-4 mr-4">

			<div class="modal-body">
				<div class="container">
					<!--Carrusel----------------------------------------------->
					<div id="demo2" class="carousel slide" data-ride="carousel">

						<!--Indicaciones-->
						<ul class="carousel-indicators">
							<li data-target="#demo2" data-slide-to="0" class="active"></li>
							<li data-target="#demo2" data-slide-to="1"></li>
							<li data-target="#demo2" data-slide-to="2"></li>
						</ul>

						<div class="carousel-inner">
							{{$valor = 0}}
							@if(!empty($fotos_servicios_cheks))
							@foreach ($fotos_servicios_cheks as $los_datos)

							@if($valor == 0)
							<div class="carousel-item active">
								<img src="{{ asset ("fotos/".$los_datos->url) ?? ''}}" alt="cajas" width="500" height="500">
							</div>
							{{$valor=1}}
							@else

							<div class="carousel-item">
								<img src="{{ asset ("fotos/".$los_datos->url ) ?? ''}}" alt="joya 1" width="500" height="500">
							</div>

							@endif
							@endforeach
							@endif
						</div>

						<!--Controles del acrrusel-->
						<a class="carousel-control-prev" href="#demo2" data-slide="prev">
							<span class="carousel-control-prev-icon"></span>
						</a>
						<a class="carousel-control-next" href="#demo2" data-slide="next">
							<span class="carousel-control-next-icon"></span>
						</a>
					</div>
					<!--Fin Carrusel---------------------------------------->
				</div>
			</div>

			<div class="modal-footer">
				<button type="button" class="btn btn-prim w-25 mx-auto" data-dismiss="modal">Cerrar</button>
			</div>
		</div>
	</div>
</div>

<!-- MODAL IMAGENES -->
<div class="modal fade" id="modal_historial_retiros" role="dialog">
	<div class="modal-dialog  modal-lg">
		<div class="modal-content">
			<div class="modal-header">
				<div class="seccion-modal">Ingresar el siguiente ID en la Aplicacción</div>
				<button type="button" class="close" data-dismiss="modal">&times;</button>
			</div>
			<hr class="separador ml-4 mr-4">

			<div class="modal-body">
				<form enctype="multipart/form-data" id="formuploadajax" method="post">
					@csrf
					<div class="container">

						<!-- CARGA DE IMÁGENES DE INSTALACIÓN -->
						<div class="seccion-filtro mt-2">Adjunte las imágenes que se solicita a continuación</div>
						<div class="row">
							<input type="text" style="display:none" name="idAsig" id="" value="{{$asignacion_solicitudes[0]->idAsig ?? ''}}">
							<div class="col-sm-12">
								<label style="color:red" ; id="mensaje-text" for=""></label>
							</div>
							<!-- 1 -->
							<div class="col-sm-12 form-group">
								<img src="{{ asset('img/p1.png')  ?? ''}}" width="30" height="30" class="espacio_carga_img" alt="" />
								<label for="cargafoto1" class="espacio_carga_img">Fotografía de la página de estado</label>
								<input type="file" required__* id="cargafoto1" name="cargafoto1">
							</div>
							<!-- 2 -->
							<div class="col-sm-12 form-group">
								<img src="{{ asset('img/p2.png')  ?? ''}}" width="30" height="30" class="espacio_carga_img" alt="" />
								<label for="cargafoto2" class="espacio_carga_img">Fotografía del panel de la máquina</label>
								<input type="file" required__* id="cargafoto2" name="cargafoto2">
							</div>
							<!-- 3 -->
							<div class="col-sm-12 form-group">
								<img src="{{ asset('img/p3.png')  ?? ''}}" width="30" height="30" class="espacio_carga_img" alt="" />
								<label for="cargafoto3" class="espacio_carga_img">Fotografía a 2 metros del equipo</label>
								<input type="file" required__* id="cargafoto3" name="cargafoto3">
							</div>
						</div>
						<!-- FIN CARGA DE IMÁGENES DE INSTALACIÓN -->

						<div class="container form-group text-center my-4">
							<button class="btn btn-secundario" type="button" data-dismiss="modal">Cancelar</button>
							<button class="btn btn-prim" type="submit">Subir imágenes</button>
						</div>
					</div>
				</form>
			</div>
		</div>
	</div>
</div>

<!-- MODAL IMAGENES -->
<div class="modal fade" id="modal_fotos_email" role="dialog">
	<div class="modal-dialog  modal-lg">
		<div class="modal-content">

			<div class="modal-header">
				<div class="seccion-modal">Ingresar 3 Fotos</div>
				<button type="button" class="close" data-dismiss="modal">&times;</button>
			</div>
			<hr class="separador ml-4 mr-4">

			<div class="modal-body">
				<div class="container text-center">
					<!-- CARGA DE IMÁGENES DE INSTALACIÓN -->
					<a class="btn btn-ter w-25 border rounded-lg py-2" href="mailto:ayaing@retailmax.cl?subject=<?php echo $asignacion_solicitudes[0]->idAsig; ?>">Subir Fotos</a>
				</div>

				<!-- FIN CARGA DE IMÁGENES DE INSTALACIÓN -->
				<div class="container form-group text-center my-4">
					<a class="btn btn-prim w-25" href="http://globati.com/ayaingenieria/index.php?id=<?php echo $asignacion_solicitudes[0]->idAsig; ?>" target="_blank">Confirmar</a>
					<button class="btn btn-secundario w-25 " type="button" data-dismiss="modal">Cancelar</button>
				</div>
			</div>
		</div>
	</div>
</div>

<!-- MODAL IMAGENES -->
<div class="modal fade" id="modal_fotos_android" role="dialog">
	<div class="modal-dialog  modal-lg">
		<div class="modal-content">

			<div class="modal-header">
				<div class="seccion-modal">Ingresar el siguiente ID en la Aplicacción</div>
				<button type="button" class="close" data-dismiss="modal">&times;</button>
			</div>
			<hr class="separador ml-4 mr-4">

			<div class="modal-body">
				<div class="container">
					<!-- CARGA DE IMÁGENES DE INSTALACIÓN -->
					<div class="text-center">
						<h1 class="border rounded-lg py-3">ID = {{$asignacion_solicitudes[0]->idAsig}}</h1>
					</div>
					<!-- FIN CARGA DE IMÁGENES DE INSTALACIÓN -->
				</div>
				<div class="container form-group text-center my-4">
					<button class="btn btn-prim w-25" type="button" data-dismiss="modal">CANCELAR</button>
				</div>
			</div>
		</div>
	</div>
</div>


<div class="modal fade" id="modalfirma" tabindex="-1" role="dialog" aria-labelledby="modalfirma" aria-hidden="true">
	<div class="modal-dialog" role="document">
		<div class="modal-content">

			<div class="modal-header">
				<div class="seccion-modal" id="exampleModalLabel">Ingrese Firma</div>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					<span aria-hidden="true">&times;</span>
				</button>
			</div>
			<div class="modal-body">
			</div>

			<div class="modal-footer">
				<button type="button" class="btn btn-primary">Guardar Firma</button>
				<button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
			</div>
		</div>
	</div>
</div>


<!--Modal  -->
<div class="modal" id="modalRechazo">
	<div class="modal-dialog">
		<div class="modal-content">

			<!-- Modal Header -->
			<div class="modal-header">
				<h4 class="seccion-modal">Escriba sus observaciones</h4>
				<button type="button" class="close" data-dismiss="modal">&times;</button>
			</div>
			<hr class="separador ml-4 mr-4">

			<form action="{{route('checklist.rechazarServicio',Crypt::encryptString($asignacion_solicitudes[0]->idAsig?? ''))}} " method="POST">
				<!-- Modal body -->
				@csrf
				<div class="modal-body">
					<div class="container">
						<div class="row">
							<div class="col-sm-12 form-group">
								<label for="cambio">Observaciones</label>
								<textarea class="form-control mayuscula" id="modal-obs" name="motivorechazado" required rows="4"></textarea>
							</div>
						</div>
					</div>
				</div>

				<!-- Modal footer -->
				<div class="modal-footer">
					<button type="submit" class="btn btn-prim w-25 mx-auto">ENVIAR</button>
				</div>
			</form>
		</div>
	</div>
</div>

<div class="modal" id="modalReasignar">
	<div class="modal-dialog">
		<div class="modal-content">

			<!-- Modal Header -->
			<div class="modal-header">
				<h4 class="seccion-modal">Escriba sus observaciones</h4>
				<button type="button" class="close" data-dismiss="modal">&times;</button>
			</div>
			<hr class="separador ml-4 mr-4">

			<form action="{{route('checklist.reasignarServicio',Crypt::encryptString($asignacion_solicitudes[0]->idAsig?? ''))}} " method="POST">
				<!-- Modal body -->
				@csrf
				<div class="modal-body">
					<div class="container">
						<div class="row">
							<div class="col-sm-12 form-group">
								<label for="cambio">Observaciones</label>
								<textarea class="form-control mayuscula" id="modal-obs" name="motivorechazado" required rows="4"></textarea>
							</div>
						</div>
					</div>
				</div>
				<!-- Modal footer -->
				<div class="modal-footer">
					<button type="submit" class="btn btn-prim w-25 mx-auto">Enviar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<!--MODAL CAMBIO DE CORREO-->
<div class="modal" id="modalcorreo">
	<div class="modal-dialog">
		<div class="modal-content">
			<!-- Modal Header -->
			<div class="modal-header">
				<h4 class="seccion-modal">Correo contacto</h4>
				<button type="button" class="close" data-dismiss="modal">&times;</button>
			</div>
			<hr class="separador ml-4 mr-4">
			<div class="modal-body">
				<div class="container">
					<div class="row">
						<div class="col-sm-12 form-group">
							<input class="form-control mayuscula" id="cambiocorreo">
						</div>
					</div>
				</div>
			</div>
			<!-- Modal footer -->
			<div class="modal-footer">
				<button type="button" class="btn btn-prim w-25 mx-auto" id="modificarcorreo">Modificar</button>
			</div>
		</div>
	</div>
</div>


<!-- Modal Contador COLOR-->
<div class="modal fade" id="modaldescripcion" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="seccion-modal">Cambiar Descripcion</h4>
          <button type="button" class="close" data-dismiss="modal">&times;</button>
        </div>
        <hr class="separador ml-4 mr-4">
        <div class="modal-body">
          <div class="container">
            <div class="row">
              <div class="col-sm-12 form-group">
                <textarea rows="10"  class="form-control mayuscula" type="text" id="observacion_cambio" placeholder="">{{$asignacion_solicitudes[0]->descripcion ?? ''}}</textarea>
                 <input class="form-control mayuscula" type="" style="display:none" value="{{$asignacion_solicitudes[0]->idAsig ?? ''}}" id="id_asignacion_check"> 
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-prim w-25 mx-auto" id="cambiadescripcion" >Guardar</button>
        </div>
      </div>
    </div>
  </div>

<!-- Modal Contador COLOR-->
<div class="modal fade" id="modalobservacion" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="seccion-modal">Cambiar Observacion</h4>
          <button type="button" class="close" data-dismiss="modal">&times;</button>
        </div>
        <hr class="separador ml-4 mr-4">
        <div class="modal-body">
          <div class="container">
            <div class="row">
              <div class="col-sm-12 form-group">
                <textarea class="form-control mayuscula" type="text" rows="10" id="observacion_cambio_observacion" placeholder="">{{$asignacion_solicitudes[0]->observaciones ?? ''}}</textarea>
                 <input class="form-control mayuscula" style="display:none" type="" value="{{$asignacion_solicitudes[0]->idAsig ?? ''}}" id="id_asignacion_check_observacion"> 
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-prim w-25 mx-auto"  id="cambiarobservacion" >Guardar</button>
        </div>
      </div>
    </div>
  </div>
   
@endsection
<script>

$(document).ready(function(){ 
		


		$("#cambiarobservacion").click(function() {
      observacion = $("#observacion_cambio_observacion").val();
      id_asignacion_check = $("#id_asignacion_check_observacion").val();
      var _token = $('input[name="_token"]').val();
      $.ajax({
        headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
        url:"{{ route('cambiodeobservacionservicio') }}",
        type: "post",
        data: {'observacion': observacion,'id_asignacion_check': id_asignacion_check,'opcion':'observacion'},
        success: function(response) {
        //   alert(response);
		console.log(response);
			$("#cambio_observacion").text(response);
          $('#modalobservacion').modal('toggle');
        },
        error: function(xhr, status) {
        alert('Disculpe, ha ocurrido un problema, intente mas tarde');
        }
      })
    });

		$("#cambiadescripcion").click(function() {
      observacion = $("#observacion_cambio").val();
      id_asignacion_check = $("#id_asignacion_check").val();
      var _token = $('input[name="_token"]').val();
      $.ajax({
        headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
        url:"{{ route('cambiodeobservacionservicio') }}",
        type: "post",
        data: {'observacion': observacion,'id_asignacion_check': id_asignacion_check,'opcion':'descripcion'},
        success: function(response) {
        //   alert(response);
		console.log(response);
			$("#cambio").text(response);
          $('#modaldescripcion').modal('toggle');
        },
        error: function(xhr, status) {
        alert('Disculpe, ha ocurrido un problema, intente mas tarde');
        }
      })
    });





  });

	function cambiocorreo() {
		correo = $("#contacto_correo").val();
		$("#cambiocorreo").val(correo);
		$("#modalcorreo").modal("show");
	}
	function cambiosFechas(opcion) {
		// alert(opcion);
		$("#opcionFecha").val(opcion);
		$("#modalcalendario").modal("show");

		// 
	}
	function modificarSerie() {
		// alert(opcion);..
		// numerodeserieid
		// $marca = $("#lamarcaid").val();
		
		$("#serieseleccionada").val($("#numerodeserieid").val());
		$("#modalSerie").modal("show");

		// 
	}
	function modificarMarca(opcion) {
		// alert(opcion);..

		// $marca = $("#lamarcaid").val();
		
		$("#marcaseleccionada").val($("#lamarcaid").val());
		$("#modalMarca").modal("show");

		// 
	}
	function sumarCantidaes(identificador) {

		acumulador = $("." + identificador).val();
		suma = parseFloat(acumulador) + parseFloat(1);
		$("." + identificador).val(suma);
		$(".id_" + identificador).text(suma);
		// id_cantidadLk
	}

	function restarCantidaes(identificador) {
		acumulador = $("." + identificador).val();
		resta = parseFloat(acumulador) - parseFloat(1);
		if (resta >= 1) {
			$("." + identificador).val(resta);
			$(".id_" + identificador).text(resta);
		}


	}


	function firmar() {


		url_img = document.getElementById("pizarra").toDataURL('image/png');
		console.log(check);
		$("#imagen_firma").val(url_img);
		// 	e.preventDefault();
		// 	var f = $(this);
		// pizarra
		// imagen_firma
		// check

		var formData = new FormData();
		formData.append("pizarra", $("#pizarra").val());
		formData.append("imagen_firma", url_img);
		formData.append("check", $("#check").val());

		// var formData = new FormData(document.getElementById("formCanvas"));
		var a = document.getElementById("jerarquia");
		$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				url: "{{ route('guardandofotosservicios')  ?? ''}}",
				type: "post",
				dataType: "html",
				data: formData,
				a,
				cache: false,
				contentType: false,
				processData: false,
				success: function(response) {
					alert(response);
				},
				error: function(xhr, status) {
					alert('Disculpe, ha ocurrido un problema, intente mas tarde');
				}
			})
			.done(function(res) {});



	}
	var lineas = [];

	function borrar() {

		// Creamos nuestro canvas
		var canvas = document.getElementById("pizarra");
		var ctx = canvas.getContext("2d");



		// Borramos el ÃƒÂ¡rea que nos interese
		ctx.clearRect(0, 0, canvas.width, canvas.height);
		//	console.log(lineas);
		lineas = [];
	}

	$(function() {

		var element = $("#pizarra"); // global variable
		var getCanvas; // global variable

		function downloadURI(uri, name) {
			var link = document.createElement("a");
			link.download = name;
			link.href = uri;
		}
		html2canvas(element, {
			onrendered: function(canvas) {
				getCanvas = canvas;
			}
		});

		//======================================================================
		// VARIABLES
		//======================================================================
		let miCanvas = document.querySelector('#pizarra');

		let correccionX = 0;
		let correccionY = 0;
		let pintarLinea = false;

		let posicion = miCanvas.getBoundingClientRect()
		correccionX = posicion.x;
		correccionY = posicion.y;

		miCanvas.width = 250;
		miCanvas.height = 250;

		//======================================================================
		// FUNCIONES
		//======================================================================

		//borrar	

		/**
		 * Funcion que empieza a dibujar la linea
		 */
		function empezarDibujo() {
			pintarLinea = true;
			lineas.push([]);
		};

		/**
		 * Funcion dibuja la linea
		 */
		function dibujarLinea(event) {
			event.preventDefault();
			if (pintarLinea) {
				let ctx = miCanvas.getContext('2d')
				// Estilos de linea
				ctx.lineJoin = ctx.lineCap = 'round';
				ctx.lineWidth = 5;
				// Color de la linea
				ctx.strokeStyle = '#000';



				// Marca el nuevo punto
				let nuevaPosicionX = 0;
				let nuevaPosicionY = 0;
				if (event.changedTouches == undefined) {
					// Versión ratón
					nuevaPosicionX = event.layerX;
					nuevaPosicionY = event.layerY;
				} else {
					// Versión touch, pantalla tactil
					nuevaPosicionX = event.changedTouches[0].pageX - correccionX;
					nuevaPosicionY = event.changedTouches[0].pageY - correccionY;
				}
				// Guarda la linea
				lineas[lineas.length - 1].push({
					x: nuevaPosicionX,
					y: nuevaPosicionY
				});
				// Redibuja todas las lineas guardadas
				ctx.beginPath();
				lineas.forEach(function(segmento) {
					ctx.moveTo(segmento[0].x, segmento[0].y);
					segmento.forEach(function(punto, index) {
						ctx.lineTo(punto.x, punto.y);
					});
				});
				ctx.stroke();
			}
		}

		/**
		 * Funcion que deja de dibujar la linea
		 */
		function pararDibujar() {
			pintarLinea = false;
		}

		//======================================================================
		// EVENTOS
		//======================================================================

		// Eventos raton
		miCanvas.addEventListener('mousedown', empezarDibujo, false);
		miCanvas.addEventListener('mousemove', dibujarLinea, false);
		miCanvas.addEventListener('mouseup', pararDibujar, false);

		// Eventos pantallas táctiles
		miCanvas.addEventListener('touchstart', empezarDibujo, false);
		miCanvas.addEventListener('touchmove', dibujarLinea, false);

		////////////////////////////////////////

		$("#formuploadajax").on("submit", function(e) {
			e.preventDefault();
			var f = $(this);
			var formData = new FormData(document.getElementById("formuploadajax"));
			formData.append("dato", "valor");
			//formData.append(f.attr("name"), $(this)[0].files[0]);
			$.ajax({
					url: "{{ route('save.save_imagen_servicios_tres')  ?? ''}}",
					type: "post",
					dataType: "html",
					data: formData,
					cache: false,
					contentType: false,
					processData: false,
					beforeSend: function() {
						$("#loader").text("Subiendo Imágenes.....");
					},
					success: function(response) {
						alert(response);
						alert(response);
						$("#loader").text("");
						console.log(response);
						$("#mensaje-text").text("Imagenes Guardadas");
						alert("imagenes guardadas");
						$("#modal_historial_retiros").modal('hide');
					}
				})
				.done(function(res) {
					$("#mensaje").html("Respuesta: " + res);
				});
		});
		$("#formuploadservicios").on("submit", function(e) {
			e.preventDefault();
			var aaa = $(this);
			var formData = new FormData(document.getElementById("formuploadservicios"));
			formData.append("dato", "valor");
			$.ajax({
					url: "{{ route('save.imagen_servicios')  ?? ''}}",
					type: "post",
					dataType: "html",
					data: formData,
					cache: false,
					contentType: false,
					processData: false,
					beforeSend: function() {
						$("#loader").text("Subiendo Imágenes.....");
					},
					success: function(response) {
						$("#loader").text("");
						console.log(response);
						$("#mensaje-text").text("Imagenes Guardadas");
						alert("imagenes guardadas");
						$("#modal_fotos_accesorios").modal('hide');
					}
				})
				.done(function(res) {
					$("#mensaje").html("Respuesta: " + res);
				});
		});
		//fin de la fucn
	});

	$(document).ready(function() {
		$("#modificarcorreo").click(function() {
			correo = $("#cambiocorreo").val();
			id_check = $("#id_check").val();
			var _token = $('input[name="_token"]').val();
			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				url: "{{ route('cambiodecorreosolicitud') }}",
				type: "post",
				data: {
					'correo': correo,
					'id_check': id_check
				},
				success: function(response) {
					console.log(response)
					$('#modalcorreo').modal('toggle');
					$("#contacto_correo").val(response);
				},
				error: function(xhr, status) {
					alert('Disculpe, ha ocurrido un problema, intente mas tarde');
				}
			})
		});
		$("#cambiarSerie").click(function() {
			serieseleccionada = $("#serieseleccionada").val();
			id_check_serie = $("#id_check_serie").val();

			var _token = $('input[name="_token"]').val();

		
			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				url: "{{ route('cambiodeserie') }}",
				type: "post",
				data: {
					'serieseleccionada': serieseleccionada,
					'id_check_serie': id_check_serie,
				},

				success: function(response) {
					// console.log("responseAriel");

					// console.log(response);
					//  console.log("aqqq");
					//  console.log(response);
					 // $("#idfecha"+opcionFecha).val(response);
					  $('#modalSerie').modal('toggle');
					  location.reload();
					  location.reload();
					//  $("#idfecha").val(response);
					//  $('#modalcalendario').modal('toggle');

				},
				error: function(xhr, status) {
					alert('Disculpe, ha ocurrido un problema, intente mas tarde');
				}
			})
		});
		$("#cambiarmarca").click(function() {
			marcaseleccionada = $("#marcaseleccionada").val();
			id_check_marca = $("#id_check_marca").val();

			var _token = $('input[name="_token"]').val();

		
			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				url: "{{ route('cambiodemarca') }}",
				type: "post",
				data: {
					'marcaseleccionada': marcaseleccionada,
					'id_check_marca': id_check_marca,
				},

				success: function(response) {

					// console.log("aqqq");
					// console.log(response);
					// // $("#idfecha"+opcionFecha).val(response);
					 $('#modalMarca').modal('toggle');
					 location.reload();
					 location.reload();
					// $("#idfecha").val(response);
					// $('#modalcalendario').modal('toggle');

				},
				error: function(xhr, status) {
					alert('Disculpe, ha ocurrido un problema, intente mas tarde');
				}
			})
		});
		$("#cambiarfecha").click(function() {
			fecha = $("#fecha_cambio").val();
			id_check = $("#id_check").val();
			opcionFecha = $("#opcionFecha").val();

			var _token = $('input[name="_token"]').val();

			console.log(fecha);
			console.log(id_check);
			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				url: "{{ route('cambiodefechasolicitudes') }}",
				type: "post",
				data: {
					'fecha': fecha,
					'id_check': id_check,
					'opcionFecha': opcionFecha
				},

				success: function(response) {

					// $("#idfecha"+opcionFecha).val(response);
					$('#modalcalendario').modal('toggle');
					location.reload();
					location.reload();
					// $("#idfecha").val(response);
					// $('#modalcalendario').modal('toggle');

				},
				error: function(xhr, status) {
					alert('Disculpe, ha ocurrido un problema, intente mas tarde');
				}
			})
		});
		//funcion para poder cambiar las opciones del finalizar
		$('#estado').change(function() {
			buscar_opciones($("#estado option:selected").val(), "#detalle");
		})

		//enviar for firma
		$("#formCanvas").on("submit", function(e) {
			url_img = document.getElementById("pizarra").toDataURL('image/png');
			$("#imagen_firma").val(url_img);
			e.preventDefault();
			var f = $(this);
			var formData = new FormData(document.getElementById("formCanvas"));
			var a = document.getElementById("jerarquia");
			$.ajax({
					url: "{{ route('guardandofotosprueba')  ?? ''}}",
					type: "post",
					dataType: "html",
					data: formData,
					a,
					cache: false,
					contentType: false,
					processData: false,
					success: function(response) {
						alert(response);
					},
					error: function(xhr, status) {
						alert('Disculpe, ha ocurrido un problema, intente mas tarde');
					}
				})
				.done(function(res) {});
		});

		//modal imagenes
		$('.asignarimagen').click(function() {
			$("#modal_historial_retiros").modal('show');
		});
		//mueble
		$("#mueble").data('checked', 0).on('click', function() {
			el = $(this);
			tres_estados(el, 'mueble');
		});
		$("#kit_lector").data('checked', 0).on('click', function() {
			el = $(this);
			tres_estados(el, 'kit_lector');
		});
		$("#memoria_sd").data('checked', 0).on('click', function() {
			el = $(this);
			tres_estados(el, 'memoria_sd');
		});
		$("#cable_poder").data('checked', 0).on('click', function() {
			el = $(this);
			tres_estados(el, 'cable_poder');
		});
		$("#cable_red").data('checked', 0).on('click', function() {
			el = $(this);
			tres_estados(el, 'cable_red');
		});
		$("#conexion_electrica").data('checked', 0).on('click', function() {
			el = $(this);
			tres_estados(el, 'conexion_electrica');
		});
		$("#servidor_impresion").data('checked', 0).on('click', function() {
			el = $(this);
			tres_estados(el, 'servidor_impresion');
		});
		$("#conf_smb").data('checked', 0).on('click', function() {
			el = $(this);
			tres_estados(el, 'conf_smb');
		});
		$("#conf_email").data('checked', 0).on('click', function() {
			el = $(this);
			tres_estados(el, 'conf_email');
		});
		$("#modo_U253").data('checked', 0).on('click', function() {
			el = $(this);
			tres_estados(el, 'modo_U253');
		});
		$("#ins_driver").data('checked', 0).on('click', function() {
			el = $(this);
			tres_estados(el, 'ins_driver');
		});
		$("#equipo_operativo").data('checked', 0).on('click', function() {
			el = $(this);
			tres_estados(el, 'equipo_operativo');
		});
		$('#no_firma_cliente').on('click', function() {
			if ($(this).is(':checked')) {
				// Hacer algo si el checkbox ha sido seleccionado
				//    alert("El checkbox con valor " + $(this).val() + " ha sido seleccionado");
				$("#contenido").css("display", "none")
			} else {
				$("#contenido").css("display", "")
			}
		});
	}); //fin del onclick

	function tres_estados(el, id_chec) {

		switch (el.data('checked')) {
			case 0: //cehckeado
				el.data('checked', 1);
				el.prop('indeterminate', false);
				el.prop('checked', true);
				var valor2 = id_chec;
				var valor = $("#cambio").val();
				$("#" + id_chec).val("si");
				break;

			case 1:
				el.data('checked', 2);
				el.prop('indeterminate', true);
				el.prop('checked', true);
				var valor2 = id_chec;
				var valor = $("#cambio").val();
				valor += " sin " + valor2 + ',';
				$("#" + id_chec).val("no");
				break;

			default:
				el.data('checked', 0);
				el.prop('indeterminate', false);
				el.prop('checked', false);
				var valor2 = id_chec;
				var valor = $("#cambio").val();
				$("#" + id_chec).val("");
		}
	}

	function buscar_opciones(id_estado, id_detalle, direccion = "") {
		//el parametro direccion, es por si mandan la solicitud desde un punto que no conincide con toda la raiz. (../) 
		$.ajax({
			headers: {
				'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
			},
			type: 'POST',
			url: "{{ route('buscar_opciones')  ?? ''}}",
			data: {
				'id': id_estado
			},
			success: function(data) {
				$("#detalle").empty();
				$.each(data, function(id, dato) {
					sin_espacio = dato.replace(/\s+/g, "_");
					$("#detalle").append("<option value=" + sin_espacio + ">" + dato + "</option>");
				});
			},
			error: function(xhr, status) {
				alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
			}
		});
	}

	function soloNumeros(e) {
		var key = window.Event ? e.which : e.keyCode
		return (key >= 48 && key <= 57)
	}
</script>
<?php
// comprovamos si se envió la imagen
if (isset($_POST['imagen'])) {

	// mostrar la imagen
	echo '<img src="' . $_POST['imagen'] . '" border="1">';

	// funcion para gusrfdar la imagen base64 en el servidor
	// el nombre debe tener la extension
	function uploadImgBase64($base64, $name)
	{
		// decodificamos el base64
		$datosBase64 = base64_decode(preg_replace('#^data:image/\w+;base64,#i', '', $base64));
		// definimos la ruta donde se guardara en el server
		$path = $_SERVER['DOCUMENT_ROOT'] . '/firmas/' . $name;
		// guardamos la imagen en el server
		if (!file_put_contents($path, $datosBase64)) {
			// retorno si falla
			return false;
		} else {
			// retorno si todo fue bien
			return true;
		}
	}
	// llamamos a la funcion uploadImgBase64( img_base64, nombre_fina.png)
	uploadImgBase64($_POST['imagen'], 'mi_imagen_' . date('d_m_Y_H_i_s') . '.png');
}
?>
<script>
	function rellenar(id) {
		if ($("#" + id).val() == "no") {
			$("#" + id).prop('indeterminate', true);
			$("#" + id).prop('checked', true);
		} else if ($("#" + id).val() == "si") {
			$("#" + id).prop('indeterminate', false);
			$("#" + id).prop('checked', true);
		}

	}
</script>

<script>
	$(function() {
		var idCheck = ["equipo_operativo", "ins_driver", "modo_U253", "conf_email", "conf_smb", "servidor_impresion", "conexion_electrica", "cable_red", "cable_poder", "mueble", "kit_lector", "memoria_sd", ];

		for (let i = 0; i < idCheck.length; i++) {
			rellenar(idCheck[i]);
		}

		$("#mueble").data('checked', 0).on('click', function() {
			el = $(this);
			tres_estados(el, 'mueble');
		});

		// $("#estado").change(function() {
		// 	var selecion = $(this).val();
		// 	if (selecion == "Pendiente") {
		// 		$('#Software').removeAttr("required__*");
		// 		$('#tipo_equipo').removeAttr("required__*");
		// 		$('#mueble').removeAttr("required__*");
		// 		$('#kit_lector').removeAttr("required__*");
		// 		$('#memoria_sd').removeAttr("required__*");
		// 		$('#cable_red').removeAttr("required__*");
		// 		$('#cable_poder').removeAttr("required__*");
		// 		$('#tipo_conexion').removeAttr("required__*");
		// 		$('#conexion_electrica').removeAttr("required__*");
		// 		$('#servidores').removeAttr("required__*");
		// 		$('#servidor_impresion').removeAttr("required__*");
		// 		$('#conf_smb').removeAttr("required__*");
		// 		$('#conf_email').removeAttr("required__*");
		// 		$('#modo_U253').removeAttr("required__*");
		// 		$('#ins_driver').removeAttr("required__*");
		// 		$('#cantidad_usuarios').removeAttr("required__*");
		// 		$('#equipo_operativo').removeAttr("required__*");
		// 		$('#cambio').removeAttr("required__*");
		// 	} else if (selecion == "Cancelar") {
		// 		$('#Software').removeAttr("required__*");
		// 		$('#tipo_equipo').removeAttr("required__*");
		// 		$('#mueble').removeAttr("required__*");
		// 		$('#kit_lector').removeAttr("required__*");
		// 		$('#memoria_sd').removeAttr("required__*");
		// 		$('#cable_red').removeAttr("required__*");
		// 		$('#cable_poder').removeAttr("required__*");
		// 		$('#tipo_conexion').removeAttr("required__*");
		// 		$('#conexion_electrica').removeAttr("required__*");
		// 		$('#servidores').removeAttr("required__*");
		// 		$('#servidor_impresion').removeAttr("required__*");
		// 		$('#conf_smb').removeAttr("required__*");
		// 		$('#conf_email').removeAttr("required__*");
		// 		$('#modo_U253').removeAttr("required__*");
		// 		$('#ins_driver').removeAttr("required__*");
		// 		$('#cantidad_usuarios').removeAttr("required__*");
		// 		$('#equipo_operativo').removeAttr("required__*");
		// 		$('#cambio').removeAttr("required__*");
		// 	}
		// });
	});
</script>
<script>
	element = document.getElementById("equipo_de_remplazo");

	function showContent() {
		element = document.getElementById("equipo_de_remplazo");
		check = document.getElementById("maquina_b_n");
		check2 = document.getElementById("maquina_color");

		if (check.checked) {
			// element.style.display = '';
		} else if (check2.checked) {
			// element.style.display = 'none';
		} else {
			// element.style.display = 'none';
		}
	}

	function changeCheckNo() {
		($('#maquina_color')).prop('checked', false);
		$(".id_color").css("display", "none");
		$(".id_color").prop("required", false);
		// $(".id_bn").prop("required", true);
	}

	function changeCheckSi() {
		// element.style.display = 'none';

		$(".id_color").css("display", "");
		// $(".id_bn").prop("required", false);
		$(".id_color").prop("required", true);
		($('#maquina_b_n')).prop('checked', false);
	}
</script>
<script>
	function desabilitar() {
		cambio = document.getElementById("cambio_serie");
		serie = document.getElementById("serie_remplazo");
		modelo = document.getElementById("modelo_remplazo");
		if (cambio.checked) {
			serie.removeAttribute('disabled');
			modelo.removeAttribute('disabled');
		} else {
			serie.setAttribute('disabled', 'disabled');
			modelo.setAttribute('disabled', 'disabled');
		}
	}
</script>
<script>
	// Example starter JavaScript for disabling form submissions if there are invalid fields
	(function() {
		'use strict'
		window.addEventListener('load', function() {
			// Fetch all the forms we want to apply custom Bootstrap validation styles to
			var forms = document.querySelectorAll('.needs-validation')

			// Loop over them and prevent submission
			Array.prototype.slice.call(forms).forEach(function(form) {
				form.addEventListener('submit', function(event) {
					if (!form.checkValidity()) {
						event.preventDefault()
						event.stopPropagation()
					}
					form.classList.add('was-validated')
				}, false)
			})
		})
	})()
</script>
<script>
	var expanded = false;

	function showCheckBoxes2() {
		checkboxes = document.getElementById("checkboxes2");
		if (!expanded) {
			checkboxes.style.display = "block";
			expanded = true;
		} else {
			checkboxes.style.display = "none";
			expanded = false;
		}
	}
</script>
<script>
	var aux = 1;
	var aux2 = 1;

	function myFunction() {
		descripcion = $('#keywords').val();
		id = $('#id_accesorio').val();
		articulo = $('#articulo').val();
		$.ajax({
			headers: {
				'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
			},
			type: 'POST',
			url: "{{ route('go.search_accesorios')  ?? ''}}",
			data: {
				'id': id,
				'articulo': articulo,
				'descripcion': descripcion
			},
			success: function(data) {
				$('#accesorios').empty();
				$(data).each(function(i, v) {
					$('#accesorios').append(
						'<tr><td class="agregar" onclick="agregar(' + v.id + ')">' + v.descripcion + '</td></tr');
				})
			},
			error: function(xhr, status) {
				alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
			}
		});
	};

	function myFunction2() {
		descripcion = $('#keywords2').val();
		id = $('#id_accesorio2').val();
		articulo = $('#articulo2').val();
		$.ajax({
			headers: {
				'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
			},
			type: 'POST',
			url: "{{ route('go.search_accesorios')  ?? ''}}",
			data: {
				'id': id,
				'articulo': articulo,
				'descripcion': descripcion
			},
			success: function(data) {
				$('#accesorios2').empty();
				$(data).each(function(i, v) {
					$('#accesorios2').append(
						'<tr><td class="agregar" onclick="agregar2(' + v.id + ')">' + v.descripcion + '</td></tr');
				})
			},
			error: function(xhr, status) {
				alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
			}
		});
	};


	function agregar(id) {
		$.ajax({
			headers: {
				'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
			},
			type: 'POST',
			url: "{{ route('go.agregar_accesorio')  ?? ''}}",
			data: {
				'id': id
			},
			success: function(data) {
				$(data).each(function(i, v) {
					if (v.serie_parte == "undefined" || v.serie_parte == null) {
						v.serie_parte == "";
					}
					$('#agregar_accesorios').append(
						'<tr class="eliminar' + aux + '">' +
						'<td>' +
						'<input name="descripcion_accesorio[]" value="' + v.id + '" type="hidden">' + v.descripcion +
						'</td>' +
						'<td>' + v.articulo + '</td>' +
						'<td> <input type="text" name="serie_parte[]" class="form-control" placeholder="Serie de parte" onkeyup="this.value=Numeros(this.value)"' + v.serie_parte + '"> </td>' +
						'<td>' +
						'<button class="btn btn-light" type="button" onclick="sumalo(' + aux + ')">+</button>' +
						'<input type="hidden" name="cantidad[]" value="1" class="resultados' + aux + '" id="resultados' + aux + '">' +
						'<span class="mx-2 resultado' + aux + '" id="resultado' + aux + '">1</span>' +
						'<button class="btn btn-light" type="button" onclick="restalo(' + aux + ')">-</button>' +
						'</td>' +
						'<td class="text-center" onclick="eliminalo(' + aux + ')">' +
						'<a class="btn-icon btn-icon-dd ver_historial_retiros">' +
						'<span class="material-icons-round">' +
						'delete' +
						'</span>' +
						'</a>' +
						'</td>' +
						'</tr');
				})
				aux++;
				limpiar();
			},
			error: function(xhr, status) {
				alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
			}
		});
	};

	function agregar2(id) {
		$.ajax({
			headers: {
				'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
			},
			type: 'POST',
			url: "{{ route('go.agregar_accesorio')  ?? ''}}",
			data: {
				'id': id
			},
			success: function(data) {
				$(data).each(function(i, v) {
					if (v.serie_parte == "undefined" || v.serie_parte == null) {
						v.serie_parte == "";
					}
					$('#agregar_accesorios2').append(
						'<tr class="2eliminar' + aux2 + '">' +
						'<td>' +
						'<input name="descripcion_accesorio2[]" value="' + v.id + '" type="hidden">' + v.descripcion +
						'</td>' +
						'<td>' + v.articulo + '</td>' +
						'<td> <input type="text" name="serie_parte2[]" class="form-control" placeholder="Serie de parte" onkeyup="this.value=Numeros(this.value)" value="' + v.serie_parte + '" > </td>' +
						'<td>' +
						'<button class="btn btn-light" type="button" onclick="sumalo2(' + aux2 + ')">+</button>' +
						'<input type="hidden" name="cantidad2[]" value="1" class="2resultados' + aux2 + '" id="2resultados' + aux2 + '">' +
						'<span class="mx-2 2resultado' + aux2 + '" id="2resultado' + aux2 + '">1</span>' +
						'<button class="btn btn-light" type="button" onclick="restalo2(' + aux2 + ')">-</button>' +
						'</td>' +
						'<td class="text-center" onclick="eliminalo2(' + aux2 + ')">' +
						'<a class="btn-icon btn-icon-dd ver_historial_retiros">' +
						'<span class="material-icons-round">' +
						'delete' +
						'</span>' +
						'</a>' +
						'</td>' +
						'</tr');
				})
				aux2++;
				limpiar2();
			},
			error: function(xhr, status) {
				alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
			}
		});
	};

	function limpiar() {
		$('#keywords').val("");
		$('#id_accesorio').val("");
		$('#articulo').val("");
		$('#accesorios').empty();
	}

	function limpiar2() {
		$('#keywords2').val("");
		$('#id_accesorio2').val("");
		$('#articulo2').val("");
		$('#accesorios2').empty();
	}

	function eliminalo(params) {
		$(".eliminar" + params).remove();
	}

	function eliminalo2(params) {
		$(".2eliminar" + params).remove();
	}

	function sumalo(params) {
		x = document.getElementById("resultado" + params).innerText;
		x++;
		document.getElementById("resultado" + params).innerText = x;
		document.getElementById("resultados" + params).value = x;
	}

	function sumalo2(params) {
		x = document.getElementById("2resultado" + params).innerText;
		x++;
		document.getElementById("2resultado" + params).innerText = x;
		document.getElementById("2resultados" + params).value = x;
	}

	function restalo(params) {
		x = document.getElementById("resultado" + params).innerText;
		x--;
		if (x < 1) {} else {
			document.getElementById("resultado" + params).innerText = x;
			document.getElementById("resultados" + params).value = x;
		}
	}

	function restalo2(params) {
		x = document.getElementById("2resultado" + params).innerText;
		x--;
		if (x < 1) {} else {
			document.getElementById("2resultado" + params).innerText = x;
			document.getElementById("2resultados" + params).value = x;
		}
	}
</script>
<script>
	function showContent2() {
		element2 = document.getElementById("motivos");
		check = document.getElementById("accesorios_si");
		check2 = document.getElementById("accesorios_no");
		if (check.checked) {
			element2.style.display = '';
		} else if (check2.checked) {
			element2.style.display = 'none';
		} else {
			element2.style.display = 'none';
		}
	}

	function changeCheckNo2() {
		($('#accesorios_no')).prop('checked', false);
	}

	function changeCheckSi2() {
		element2 = document.getElementById("motivos");
		element_div_danados = document.getElementById("div_accesorios_danados");
		element_div_solicitados = document.getElementById("div_accesorios_solicitados");
		element2.style.display = 'none';
		element_div_danados.style.display = 'none';
		element_div_solicitados.style.display = 'none';
		($('#accesorios_si')).prop('checked', false);
	}

	function showContent3() {
		element3 = document.getElementById("div_accesorios_solicitados");
		element4 = document.getElementById("div_accesorios_danados");
		check = document.getElementById("motivo_1");
		check2 = document.getElementById("motivo_2");
		check3 = document.getElementById("motivo_3");


		if (check.checked || check3.checked) {
			element3.style.display = '';
			element4.style.display = '';
		} else if (check2.checked) {
			element3.style.display = 'none';
			element4.style.display = '';
		} else {
			element3.style.display = 'none';
			element4.style.display = 'none';
		}
	}

	function changeCheckMotivo1() {
		($('#motivo_2')).prop('checked', false);
		($('#motivo_3')).prop('checked', false);
		element4 = document.getElementById("fotos_accesorios");
		//element4.style.display = 'none';
		element4.style.display = '';
	}

	function changeCheckMotivo2() {
		element3 = document.getElementById("div_accesorios_solicitados");
		element4 = document.getElementById("div_accesorios_danados");
		element3.style.display = '';
		element4.style.display = 'none';
		element44 = document.getElementById("fotos_accesorios");
		//element4.style.display = 'none';
		element44.style.display = '';
		($('#motivo_1')).prop('checked', false);
		($('#motivo_3')).prop('checked', false);
	}

	function changeCheckMotivo3() {
		element4 = document.getElementById("fotos_accesorios");
		element4.style.display = '';
		//element4.style.display = 'none';
		($('#motivo_1')).prop('checked', false);
		($('#motivo_2')).prop('checked', false);
	}

	function showContent4() {
		element4 = document.getElementById("fotos_accesorios");
		check = document.getElementById("motivo_1");
		check2 = document.getElementById("motivo_2");
		check3 = document.getElementById("motivo_3");

		div_accesorios_solicitados = document.getElementById("div_accesorios_solicitados");
		if (check2.checked) {
			element4.style.display = '';
		} else {
			element4.style.display = 'none';
			div_accesorios_solicitados.style.display = 'none';
		}
	}
</script>
<script>
	$(document).ready(function() {
		$('.asignarimagenes').click(function() {


			check = document.getElementById("motivo_1");
			check2 = document.getElementById("motivo_2");
			check3 = document.getElementById("motivo_3");

			if (check3.checked) {


				$("#cargafotoa1_1").css("display", "");
				$("#cargafotoa1_2").css("display", "");
				$("#cargafotoa1_3").css("display", "");
				$("#title_123").css("display", "");

			} else {

				$("#cargafotoa1_1").css("display", "none");
				$("#cargafotoa1_2").css("display", "none");
				$("#cargafotoa1_3").css("display", "none");
				$("#title_123").css("display", "none");
			}


			$("#modal_fotos_accesorios").modal('show');
		});
	})
</script>

<script>
	$(document).ready(function() {


		$('#rechazar').click(function() {

			//   alert("gola");
			$("#modalRechazo").modal('show');
		});

		$('.reasignar').click(function() {

			//   alert("gola");
			$("#modalReasignar").modal('show');
		});

	})
</script>