@extends('menu/menu')
<style>
	.mostrar {
		display: none;
	}

	@media (max-width: 768px) {
		.mostrar {
			display: block;
		}
	}

	.selectBox {
		position: relative;
	}

	.overSelect {
		position: absolute;
		left: 0;
		right: 0;
		top: 0;
		bottom: 0;
	}

	#checkboxes2 {
		display: none;
		border: 1px #dadada solid;
		background-color: white;
	}

	#checkboxes2 label {
		display: block;
	}

	#checkboxes2 label:hover {
		background-color: #1e90ff;
	}
</style>
<script src="{{ asset('js/jquery-3.4.1.min.js') }}"></script>
<script src="{{ asset('js/html2canvas.js') }}"></script>
@section('content')
@if ( session('mensaje') )
<div class="alert alert-success">{{ session('mensaje') }}</div>
@endif
@if ( session('mensaje_error') )
<div class="alert alert-danger">{{ session('mensaje_error') }}</div>
@endif

<!-- body code goes here -->
<div class="mostrar" style="text-align: right">
	<a href="javascript: history.go(-1)"><img src="img/volver.png"></a>
</div>

<!-- body code goes here -->
<div class="container mt-5">
	<div class="title-vista mt-4">Checklist de instalación de equipos</div>
</div>

<div class="container my-5">
	@if ( $datos_asignacion[0]->estado_inicio == null || $datos_asignacion[0]->estado_inicio == "" )
	<a class="dropdown-item text-center" href="{{route('iniciando.checklist',Crypt::encryptString($datos_asignacion[0]->id_checklist))}}">
		<button class="btn btn-prim w-25">Iniciar Check</button>
	</a>
	@endif
	<form action="{{route('finalizar.checklist',Crypt::encryptString($datos_asignacion[0]->id_checklist))}}" method="POST" class="needs-validation" novalidate>
		@csrf
		<!-- Fila 1 ------------------------------------------------------>
		<div class="seccion-filtro">Asignación</div>
		<hr class="separador">
		<div class="row">
			<div class="col-sm-3 form-group">
				<label for="">Nº de visita</label>
				<input type="" class="form-control mayuscula" id="" placeholder="Nº DE VISITA" style="pointer-events: none" readonly="readonly" value="{{$datos_asignacion[0]->numero_visita}}" name="">
			</div>
			<div class="col-sm-3 form-group">
				<label for="">Tipo de visita</label>
				<input type="" class="form-control mayuscula" id="" placeholder="Nº DE VISITA" style="pointer-events: none" readonly="readonly" value="{{$tipo_visita->descripcion}}" name="">
			</div>
			<input type="hidden" value="{{$accion}}" name="acc">
			<div class="col-sm-6 form-group ali">
				<label for="">Proyecto asociado</label>
				<input type="" class="form-control mayuscula" id="" placeholder="" name="" style="pointer-events: none" readonly="readonly" placeholder="" value="{{$proyecto_asociado[0]->nombre}}">
			</div>
		</div>
		<!-- Fila 2 ------------------------------------------------------>
		<div class="seccion-filtro mt-2">Detalla del cliente</div>
		<hr class="separador">
		<div class="row">
			<div class="col-sm-3 form-group">
				<label for="">Cliente</label>
				<input type="" class="form-control mayuscula" id="" placeholder="" name="" style="pointer-events: none" readonly="readonly" value="{{$proyecto_asociado[0]->razon_social}}">
			</div>
			<div class="col-sm-3 form-group">
				<label for="">Fecha</label>
				<input type="" class="form-control mayuscula" id="" placeholder="FECHA" name="" style="pointer-events: none" readonly="readonly" value="{{Carbon\Carbon::createFromDate($datos_asignacion[0]->fecha_instalacion ?? '')->format('d-m-Y')}}" name="">
			</div>
			<div class="col-sm-3 form-group">
				<label for="">Dirección</label>
				<input type="" class="form-control mayuscula" id="" placeholder="" name="" style="pointer-events: none" readonly="readonly" value="{{$datos_asignacion[0]->Csdireccion}}" name="">
			</div>
			<div class="col-sm-3 form-group">
				<label for="">Comuna</label>
				<input type="" class="form-control mayuscula" id="" placeholder="" name="" style="pointer-events: none" readonly="readonly" value="{{$datos_asignacion[0]->Cscomuna}}" name="">
			</div>
			<!-- Fila 3 ------------------------------------------------------>
			<div class="col-sm-6 form-group">
				<label for="">Contacto</label>
				<input type="" class="form-control mayuscula" id="" placeholder="" name="" style="pointer-events: none" readonly="readonly" value="{{$datos_asignacion[0]->Cscontacto}}" name="">
			</div>
			<div class="col-sm-3 form-group">
				<label for="">SC</label>
				<input type="" class="form-control mayuscula" id="" placeholder="" name="" style="pointer-events: none" readonly="readonly" value="{{$datos_asignacion[0]->CsSC}}" name="">
			</div>
			<div class="col-sm-3 form-group">
				<label for="">CUI o Código Sucursal</label>
				<input type="" class="form-control mayuscula" id="" placeholder="" name="" style="pointer-events: none" readonly="readonly" value="{{$datos_asignacion[0]->Cscui}}" name="">
			</div>
			<div class="col-sm-3 form-group">
				<label for="">Aréa</label>
				<input type="" class="form-control mayuscula" id="" placeholder="" name="area"   value="{{old('area')}}" >
			</div>
		</div>

		<!-- Fila 4 ------------------------------------------------------>
		<div class="seccion-filtro mt-2">Detalle de equipamiento</div>
		<hr class="separador">
		<div class="row">
		<div class="row col-sm-12">
			
			@if($datos_asignacion[0]->idSala != "")
			<div class="col-sm form-group">
			  <label for="">Id Sala</label>
			  <input type="" class="form-control mayuscula" id="" placeholder="" name="idsala"  value="{{$datos_asignacion[0]->idSala}}">
			</div>
			@endif
			<div class="col-sm form-group">
				<label for="">Marca</label>
				<input type="" required class="form-control mayuscula" id="" placeholder="MARCA" name="marca" value="{{$datos_asignacion[0]->Csmarca ?? ''}}">
			</div>
			<div class="col-sm form-group">
				<label for="">Serie</label>
				<input type="" class="form-control mayuscula" id="" placeholder="" style="pointer-events: none" readonly="readonly" value="{{$datos_asignacion[0]->CsSerie}}">
			</div>
			<div class="col-sm form-group">
				<label for="">Modelo</label>
				<input type="" class="form-control mayuscula" id="" placeholder="" style="pointer-events: none" readonly="readonly" value="{{$datos_asignacion[0]->CsModelo}}">
			</div>
			<div class="col-sm form-group">
				<label for="">Tipo Equipo</label>
				<select required name="tipo_equipo" id="tipo_equipo" class="custom-select mayuscula">
					@if(!empty($$datos_asignacion[0]->tipo_equipo))
					<option value="" required>SELECCIONE</option>
					@if ($datos_asignacion[0]->tipo_equipo == "multifuncional")
					<option value="multifuncional" selected {{ old('tipo_equipo') == "multifuncional" ? 'selected' : '' }} required>MULTIFUNCIONAL</option>
					<option value="impresora" {{ old('tipo_equipo') == "impresora" ? 'selected' : '' }} required>IMPRESORA</option>
					@elseif($datos_asignacion[0]->tipo_equipo == "impresora")
					<option value="multifuncional" {{ old('tipo_equipo') == "multifuncional" ? 'selected' : '' }} required>MULTIFUNCIONAL</option>
					<option value="impresora" selected {{ old('tipo_equipo') == "impresora" ? 'selected' : '' }} required>IMPRESORA</option>
					@else
					<option value="multifuncional" {{ old('tipo_equipo') == "multifuncional" ? 'selected' : '' }} required>MULTIFUNCIONAL</option>
					<option value="impresora" {{ old('tipo_equipo') == "impresora" ? 'selected' : '' }} required>IMPRESORA</option>
					@endif
					@else
					<option value="multifuncional" {{ old('tipo_equipo') == "multifuncional" ? 'selected' : '' }} required>MULTIFUNCIONAL</option>
					<option value="impresora" {{ old('tipo_equipo') == "impresora" ? 'selected' : '' }} required>IMPRESORA</option>
					@endif
				</select>
				@error('tipo_equipo')
				<div class="alert alert-danger">{{ $message }}</div>
				@enderror
			</div>

		</div>	
			<!-- Fila 5 ------------------------------------------------------>
			<div class="col-sm-3 form-group check-input">
				<div class="custom-control custom-checkbox">
					<input class="custom-control-input" type="checkbox" id="cambio_serie" name="cambio_serie" value="cambio_serie" {{ (! empty(old('cambio_serie')) ? 'checked' : '') }} onclick="desabilitar()">
					<label class="custom-control-label" for="cambio_serie">Cambio de serie</label>
				</div>
			</div>
			<div class="col-sm-3 form-group">
				<label for="">Serie de remplazo</label>
				<input type="" class="form-control mayuscula" id="serie_remplazo" disabled placeholder="SERIE DE REMPLAZO" name="serie_remplazo" value="{{ (!empty(@old('serie_remplazo'))) }}">
				<div class="invalid-feedback">Este campo es requerido!</div>
				@error('serie_remplazo')
				<div class="alert alert-danger">{{ $message }}</div>
				@enderror
			</div>
			<div class="col-sm-3 form-group">
				<label for="">Modelo de remplazo</label>
				<input type="" class="form-control mayuscula" id="modelo_remplazo" disabled placeholder="MODELO DE REMPLAZO" name="modelo_remplazo" value="{{@old('modelo_remplazo')}}">
				<div class="invalid-feedback">Este campo es requerido!</div>
				@error('modelo_remplazo')
				<div class="alert alert-danger">{{ $message }}</div>
				@enderror
			</div>
			<div class="col-sm-3 form-group">
				<label for="">IP (*)</label>
				<input type="" class="form-control mayuscula" id="" required placeholder="" name="ip" placeholder="" value="{{old('ip') ?? $datos_asignacion[0]->CsIP }}">
				<div class="invalid-feedback">Este campo es requerido!</div>
				@error('ip')
				<div class="alert alert-danger">{{ $message }}</div>
				@enderror
			</div>
			<!-- Fila 6 ------------------------------------------------------>
			<div class="col-sm-3 form-group">
				<label for="">Software (*)</label>
				<select name="Software" id="Software" required class="custom-select mayuscula">
					<option value="8">SELECCIONE</option>
					@if(!empty($softwares))
					@foreach ($softwares as $los_datos)
					@if ($los_datos->id == $datos_asignacion[0]->id)
					<option selected value="{{$los_datos->id}}" {{ old('Software') == $los_datos->id ? 'selected' : '' }}> {{$los_datos->descripcion}} </option>
					@else
					<option value="{{$los_datos->id}}" {{ old('Software') == $los_datos->id ? 'selected' : '' }}> {{$los_datos->descripcion}} </option>
					@endif
					@endforeach
					@endif
				</select>
				<div class="invalid-feedback">Este campo es requerido!</div>
				@error('Software')
				<div class="alert alert-danger">{{ $message }}</div>
				@enderror
			</div>
			<div class="col-sm-3 form-group">
				<label for="">Mask (*)</label>
				<input type="" class="form-control mayuscula" id="" name="Mask" placeholder="Mask" required placeholder="" value="{{ old('Mask')  ?? $datos_asignacion[0]->CsMsk}}">
				<div class="invalid-feedback">Este campo es requerido!</div>
				@error('Mask')
				<div class="alert alert-danger">{{ $message }}</div>
				@enderror
			</div>
			<div class="col-sm-3 form-group">
				<label for="">Gateway (*)</label>
				<input type="" class="form-control mayuscula" id="" placeholder="Gateway" required placeholder="" value="{{ old('Gateway') ?? $datos_asignacion[0]->CsGateway}}" name="Gateway">
				<div class="invalid-feedback">Este campo es requerido!</div>
				@error('Gateway')
				<div class="alert alert-danger">{{ $message }}</div>
				@enderror
			</div>
			<div class="col-sm-3 form-group">
				<label for="">Contador B/N(*)</label>
				<input type="number" class="form-control mayuscula" id="" placeholder="Contador B/N" onKeyPress="return soloNumeros(event)" required placeholder="" value="{{ old('contador_bn')  ?? $datos_asignacion[0]->CnContador}}" name="contador_bn">
				<div class="invalid-feedback">Este campo es requerido!</div>
				@error('contador_bn')
				<div class="alert alert-danger">{{ $message }}</div>
				@enderror
			</div>
			<!-- Fila 7 ------------------------------------------------------>
			<div class="col-sm-3 form-group">
				<label for="">Contador color(*)</label>
				<input type="number" class="form-control mayuscula" id="" placeholder="Contador color" required onKeyPress="return soloNumeros(event)" placeholder="" value="{{old('contador_color') ?? $datos_asignacion[0]->CnContador_color}}" name="contador_color">
				<div class="invalid-feedback">Este campo es requerido!</div>
				@error('contador_color')
				<div class="alert alert-danger">{{ $message }}</div>
				@enderror
			</div>
		</div>

		<!-- Fila 9 - Accesorios ----------------------------------------------------->
		<div class="row">
			<div class="col-sm-6">
				<div class="seccion-filtro mt-2">Accesorios</div>
				<hr class="separador">
				<div class="row">
					<!-- FILA 9.1 -->
					<div class="col-md-6 form-group check-input check-space">
						<div class="custom-control custom-checkbox">
							<input type="checkbox" class="custom-control-input" id="band_ad" name="band_ad" value="bandeja-adicional" {{ (! empty(old('band_ad')) ? 'checked' : '') }} onclick="disabledBandeja()">
							<label class="custom-control-label" for="band_ad">Bandeja adicional</label>
						</div>
					</div>
					<div class="col-sm-6 form-group">
						<label for="">Modelo de bandeja</label>
						<input type="" class="form-control mayuscula" id="modelo_bandeja" value="{{old('modelo_bandeja')}}" placeholder="MODELO DE BANDEJA" name="modelo_bandeja">
						<div class="invalid-feedback">Este campo es requerido!</div>
						@error('modelo_bandeja')
						<div class="alert alert-danger">{{ $message }}</div>
						@enderror
					</div>
					<!-- FILA 9.2 -->
					<div class="col-md-6 form-group check-input check-space mt-3">
						<div class="custom-control custom-checkbox">
							<input type="checkbox" class="custom-control-input" required id="mueble" name="mueble" value="{{old('mueble')}}" {{ (! empty(old('mueble')) ? 'checked' : '') }}>
							<label class="custom-control-label" for="mueble">Mueble (*)</label>
							<div class="invalid-feedback">Este campo es requerido!</div>
							@error('mueble')
							<div class="alert alert-danger">{{ $message }}</div>
							@enderror
						</div>
					</div>
					<div class="col-md-6 form-group check-input check-space mt-3">
						<div class="custom-control custom-checkbox">
							<input type="checkbox" class="custom-control-input" required id="kit_lector" name="kit_lector" value="{{old('kit_lector')}}" {{ (! empty(old('kit_lector')) ? 'checked' : '') }}>
							<label class="custom-control-label" for="kit_lector">Kit lector (*)</label>
							<div class="invalid-feedback">Este campo es requerido!</div>
						</div>
					</div>
					<!-- FILA 9.3 -->
					<div class="col-md-6 form-group check-input check-space mt-3">
						<div class="custom-control custom-checkbox">
							<input type="checkbox" class="custom-control-input" required id="memoria_sd" name="memoria_sd" value="{{old('memoria_sd')}}" {{ (! empty(old('memoria_sd')) ? 'checked' : '') }}>
							<label class="custom-control-label" for="memoria_sd">Memoria SD (*)</label>
							<div class="invalid-feedback">Este campo es requerido!</div>
						</div>
					</div>
					<div class="col-md-6 form-group check-input check-space mt-3">
						<div class="custom-control custom-checkbox">
							<input type="checkbox" class="custom-control-input" required id="cable_red" name="cable_red" value="{{old('cable_red')}}" {{ (! empty(old('cable_red')) ? 'checked' : '') }}>
							<label class="custom-control-label" for="cable_red">Cable red (*)</label>
							<div class="invalid-feedback">Este campo es requerido!</div>
						</div>
					</div>
					<!-- FILA 8.4 -->
					<div class="col-md-6 form-group check-input check-space mt-3">
						<div class="custom-control custom-checkbox">
							<input type="checkbox" class="custom-control-input" required id="cable_poder" name="cable_poder" value="{{old('cable_poder')}}" {{ (! empty(old('cable_poder')) ? 'checked' : '') }}>
							<label class="custom-control-label" for="cable_poder">Cable de poder (*)</label>
							<div class="invalid-feedback">Este campo es requerido!</div>
						</div>
					</div>
				</div>
			</div>
			<div class="col-sm-6">
				{{-- para diferenciar si es manual  o no  --}}
				@if(!empty($manual))
				<input type="text" id="tipo_instalacion" name="tipo_instalacion" style="display:none" value="{{$manual  ?? ''}}">
				@else
				<input type="text" id="tipo_instalacion" name="tipo_instalacion" style="display:none" value="no">
				@endif

				<div class="seccion-filtro mt-2">Configuración</div>
				<hr class="separador">

				<div class="row">
					<!-- FILA 9.1 -->
					<div class="col-md-6 form-group">
						<label for="">Tipo de conexión (*)</label>
						<select required name="tipo_conexion" id="tipo_conexion" class="custom-select mayuscula">
							<option value="" selected>SELECCIONE</option>
							@if(!empty($tipo_conexion))
							@foreach ($tipo_conexion as $los_datos)
							@if ($los_datos->id == $datos_asignacion[0]->id)
							<option selected value="{{$los_datos->id}}" {{ old('tipo_conexion') == $los_datos->id ? 'selected' : '' }}>{{$los_datos->descripcion}} </option>
							@else
							<option value="{{$los_datos->id}}" {{ old('tipo_conexion') == $los_datos->id ? 'selected' : '' }}>{{$los_datos->descripcion}} </option>
							@endif
							@endforeach
							@endif
						</select>
						<div class="invalid-feedback">Este campo es requerido!</div>
						@error('tipo_conexion')
						<div class="alert alert-danger">{{ $message }}</div>
						@enderror
					</div>
					<div class="col-md-6 form-group check-input check-space">
						<div class="custom-control custom-checkbox">
							<input type="checkbox" class="custom-control-input" required id="conexion_electrica" name="conexion_electrica" value="{{$datos_asignacion[0]->Csconexion_electrica ?? ''}}" {{ (! empty(old('conf_smb')) ? 'checked' : '') }}>
							<label class="custom-control-label" for="conexion_electrica">Conexión eléctrica (*)</label>
							<div class="invalid-feedback">Este campo es requerido!</div>
						</div>
					</div>
					<!-- FILA 9.2 -->
					<div class="col-md-6 form-group">
						@if (strtoupper($proyecto_asociado[0]->proveedor_instalacion) == "SANTOTOMAS")
						<label for="">Estado canaleta (*)</label>
						@else
						<label for="">Nombre servidor (*)</label>

						@endif
						<select required name="servidores" id="servidores" class="custom-select mayuscula">
							<option value="" selected>SELECCIONE</option>
							@if(!empty($servidores))
							@foreach ($servidores as $los_datos)
							@if ($los_datos->id == $datos_asignacion[0]->id)
							<option selected value="{{$los_datos->id}}" {{ old('servidores') == $los_datos->id ? 'selected' : '' }}>{{$los_datos->descripcion}} </option>
							@else
							<option value="{{$los_datos->id}}" {{ old('servidores') == $los_datos->id ? 'selected' : '' }}>{{$los_datos->descripcion}} </option>
							@endif
							@endforeach
							@endif
						</select>
						<div class="invalid-feedback">Este campo es requerido!</div>
						@error('servidores')
						<div class="alert alert-danger">{{ $message }}</div>
						@enderror
					</div>
					<div class="col-md-6 form-group check-input check-space">
						<div class="custom-control custom-checkbox">
							<input type="checkbox" class="custom-control-input" required id="servidor_impresion" name="servidor_impresion" value="{{old('servidor_impresion') ?? $datos_asignacion[0]->Csservidor_impresion}}" {{ (! empty(old('servidor_impresion')) ? 'checked' : '') }}>
							<label class="custom-control-label" for="servidor_impresion">Servidor de impresión (*)</label>
							<div class="invalid-feedback">Este campo es requerido!</div>
						</div>
					</div>
					<!-- FILA 9.3 -->
					<div class="col-md-6 form-group check-input check-space">
						<div class="custom-control custom-checkbox">
							<input type="checkbox" class="custom-control-input" required id="conf_smb" name="conf_smb" value="{{old('conf_smb') ?? $datos_asignacion[0]->Csconfig_smb}}" {{ (! empty(old('conf_smb')) ? 'checked' : '') }}>
							<label class="custom-control-label" for="conf_smb">Config. SMB (*)</label>
							<div class="invalid-feedback">Este campo es requerido!</div>
						</div>
					</div>
					<div class="col-md-6 form-group check-input check-space">
						<div class="custom-control custom-checkbox">
							<input type="checkbox" class="custom-control-input" required id="conf_email" name="conf_email" value="{{old('conf_email') ?? $datos_asignacion[0]->Csconfig_email}}" {{ (! empty(old('conf_email')) ? 'checked' : '') }}>
							<label class="custom-control-label" for="conf_email">Config. Email (*)</label>
							<div class="invalid-feedback">Este campo es requerido!</div>
						</div>
					</div>
					<!-- FILA 9.4 -->
					<div class="col-md-6 form-group check-input check-space bg-seccion-filtro mt-3">
						<div class="custom-control custom-checkbox">
							<input type="checkbox" class="custom-control-input" required id="modo_U253" name="modo_U253" value="{{old('modo_U253') ?? $datos_asignacion[0]->modo_U253}}" {{ (! empty(old('modo_U253')) ? 'checked' : '') }}>
							<label class="custom-control-label" for="modo_U253">modo U253 (*)</label>
							<div class="invalid-feedback">Este campo es requerido!</div>
						</div>
					</div>
					<div class="col-md-6 form-group check-input check-space mt-3">
						<div class="custom-control custom-checkbox">
							<input type="checkbox" class="custom-control-input" required id="ins_driver" name="ins_driver" value="{{old('ins_driver') ?? $datos_asignacion[0]->ins_driver}}" {{ (! empty(old('ins_driver')) ? 'checked' : '') }}>
							<label class="custom-control-label" for="ins_driver">Instalación de driver manual (*)</label>
							<div class="invalid-feedback">Este campo es requerido!</div>
						</div>
					</div>
					<!-- FILA 9.5 -->
					<div class="col-md-6 form-group mt-3">
						<label for="">Cantidad de usuarios (*)</label>
						<input type="number" class="form-control mayuscula" id="cantidad_usuarios" required placeholder="Cantidad de usuarios" name="cantidad_usuarios" value="{{ @old('cantidad_usuarios')  ?? $datos_asignacion[0]->Cscantidad_usuarios}}">
						<div class="invalid-feedback">Este campo es requerido!</div>
					</div>
				</div>
			</div>
		</div>
		<!-- Fila 10 - ----------------------------------------------------->
		<div class="seccion-filtro mt-2">Equipo de remplazo</div>
		<hr class="separador">
		<div class="row bg-destacar pt-3">
			<div class="col-sm-12 form-group checkbox d-flex">
				<label class="mr-3" for="">Equipo de remplazo</label>
				<div class="custom-control custom-checkbox mr-3">
					<input type="checkbox" class="custom-control-input" id="equipo_remplazo_si" name="equip_remplazo_si" {{ (! empty(old('equip_remplazo_si')) ? 'checked' : '') }} onchange="javascript:showContent(); javascript:changeCheckNo()" onclick="enableES();">
					<label class="custom-control-label" for="equipo_remplazo_si">Si</label>
				</div>
				<div class="custom-control custom-checkbox">
					<input type="checkbox" class="custom-control-input" id="equipo_remplazo_no" name="equip_remplazo_no" {{ (! empty(old('equip_remplazo_no')) ? 'checked' : '') }} onchange="javascript:showContent(); javascript:changeCheckSi()" onclick="disabledES();">
					<label class="custom-control-label" for="equipo_remplazo_no">No</label>
				</div>
			</div>
			<div class="col-sm-12" id="equipo_de_remplazo" style="display:none" equip_remplazo_si>
				<div class="container">
					<div class="row">
						<div class="col-sm-12 seccion-filtro mt-2">Detalle del equipamiento</div>
						<hr class="container mx-3 separador">
						<!-- Fila 11 ------>
						<div class="col-sm-12 seccion-filtro mt-2">Equipo Saliente</div>
						<div class="col-sm-3 form-group">
							<label for="">Marca</label>
							<input type="" class="form-control mayuscula" id="id_marca_es" placeholder="MARCA" name="marca_es" value="{{old('marca_es')}}">
							<div class="invalid-feedback">Este campo es requerido!</div>
						</div>
						<div class="col-sm-3 form-group">
							<label for="">Serie</label>
							<input type="" class="form-control mayuscula" name="serie_es" id="id_serie_es" value="{{ old('serie_es')  ?? $datos_asignacion[0]->CsSerie_es}}">
							<div class="invalid-feedback">Este campo es requerido!</div>
						</div>
						<div class="col-sm-3 form-group">
							<label for="">Modelo</label>
							<input type="" class="form-control mayuscula" name="modelo_es" id="id_modelo_es" value="{{ old('modelo_es')  ?? $datos_asignacion[0]->CsModelo_es}}">
							<div class="invalid-feedback">Este campo es requerido!</div>
						</div>
						<div class="col-sm-3 form-group">
							<label for="">Tipo Equipo</label>
							<select name="tipo_equipo_es" id="tipo_equipo_es" class="custom-select mayuscula">
								@if(!empty($$datos_asignacion[0]->CsTipoequipo_es))
								<option value="" required>SELECCIONE</option>
								@if ($datos_asignacion[0]->CsTipoequipo_es == "multifuncional")
								<option value="multifuncional" selected {{ old('CsTipoequipo_es') == "multifuncional" ? 'selected' : '' }} required>MULTIFUNCIONAL</option>
								<option value="impresora" {{ old('CsTipoequipo_es') == "impresora" ? 'selected' : '' }} required>IMPRESORA</option>
								@elseif($datos_asignacion[0]->CsTipoequipo_es == "impresora")
								<option value="multifuncional" {{ old('CsTipoequipo_es') == "multifuncional" ? 'selected' : '' }} required>MULTIFUNCIONAL</option>
								<option value="impresora" selected {{ old('CsTipoequipo_es') == "impresora" ? 'selected' : '' }} required>IMPRESORA</option>
								@else
								<option value="multifuncional" {{ old('CsTipoequipo_es') == "multifuncional" ? 'selected' : '' }} required>MULTIFUNCIONAL</option>
								<option value="impresora" {{ old('CsTipoequipo_es') == "impresora" ? 'selected' : '' }} required>IMPRESORA</option>
								@endif
								@else
								<option value="multifuncional" {{ old('CsTipoequipo_es') == "multifuncional" ? 'selected' : '' }} required>MULTIFUNCIONAL</option>
								<option value="impresora" {{ old('CsTipoequipo_es') == "impresora" ? 'selected' : '' }} required>IMPRESORA</option>
								@endif
							</select>
							<div class="invalid-feedback">Este campo es requerido!</div>
						</div>
						<!-- Fila 12 ------>
						<div class="col-sm-3 form-group">
							<label for="">Contador B/N</label>
							<input type="number" class="form-control mayuscula" id="id_contadorbn_es" value="{{ old('contador_bn_es')  ?? $datos_asignacion[0]->CsContador_es}}" name="contador_bn_es" placeholder="Contador B/N" onKeyPress="return soloNumeros(event)">
							<div class="invalid-feedback">Este campo es requerido!</div>
						</div>
						<div class="col-sm-3 form-group">
							<label for="">Contador color</label>
							<input type="number" class="form-control mayuscula" id="id_contador_es" value="{{ old('contador_color_es')  ?? $datos_asignacion[0]->CsContadorcolor_es}}" name="contador_color_es" placeholder="Contador color" onKeyPress="return soloNumeros(event)">
							<div class="invalid-feedback">Este campo es requerido!</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<?php
		$accesorios = DB::table('checklist_accesorios')
			->join('accesorios', 'accesorios.id', '=', 'checklist_accesorios.id_accesorio')
			->select('accesorios.descripcion', 'accesorios.articulo', 'checklist_accesorios.cantidad', 'accesorios.id as ID', 'checklist_accesorios.serie_parte')
			->where('checklist_accesorios.id_checklist_instalacion', '=', $datos_asignacion[0]->id_checklist)
			->get();

		$accesorios_dañados = DB::table('checklist_accesorios_dañados')
			->join('accesorios', 'accesorios.id', '=', 'checklist_accesorios_dañados.id_accesorio')
			->select('accesorios.descripcion', 'accesorios.articulo', 'checklist_accesorios_dañados.cantidad', 'accesorios.id as ID', 'checklist_accesorios_dañados.serie_parte')
			->where('checklist_accesorios_dañados.id_checklist_instalacion', '=', $datos_asignacion[0]->id_checklist)
			->get();
		?>
		<div class="seccion-filtro mt-2">Solicitud de accesorios</div>
		<hr class="separador">
		<!-- Fila 13 ------------------>
		<div class="row bg-destacar py-3">
			<div class="col-sm-12 form-group checkbox d-flex">
				<label class="mr-3" for="">Solicitar accesorios</label>
				<div class="custom-control custom-checkbox mr-3">
					<input type="checkbox" class="custom-control-input" {{ (! empty(old('accesorios_si')) ? 'checked' : '') }} <?php if (count($accesorios) != 0) {
																																	echo 'checked';
																																} ?> id="accesorios_si" name="accesorios_si">
					<label class="custom-control-label" for="accesorios_si">Si</label>
				</div>
				<div class="custom-control custom-checkbox mr-3">
					<input type="checkbox" class="custom-control-input" {{ (! empty(old('accesorios_no')) ? 'checked' : '') }} id="accesorios_no" name="accesorios_no">
					<label class="custom-control-label" for="accesorios_no">No</label>
				</div>
			</div>
			<!--MOTIVOS-->
			<div class="col-sm-12 form-group checkbox" id="motivos" <?php if (count($accesorios) != 0) {
																		echo 'style="display:"';
																	} else {
																		echo 'style="display:none"';
																	} ?>>
				<label for="" class="mr-3">Motivo</label>
				<div class=" d-flex flex-wrap">
					<div class="custom-control custom-checkbox mr-3">
						<input type="checkbox" class="custom-control-input" {{ (! empty(old('motivo_1')) ? 'checked' : '') }} <?php if ($datos_asignacion[0]->motivo == 'Fin de vida util') ?> id="motivo_1" name="motivo_1">
						<label class="custom-control-label" for="motivo_1">Fin de vida util</label>
					</div>
					<div class="custom-control custom-checkbox mr-3">
						<input type="checkbox" class="custom-control-input" {{ (! empty(old('motivo_2')) ? 'checked' : '') }} <?php if ($datos_asignacion[0]->motivo == 'Garantia') {
																																	echo 'checked';
																																} ?> id="motivo_2" name="motivo_2">
						<label class="custom-control-label" for="motivo_2">Garantia</label>
					</div>
					<div class="custom-control custom-checkbox mr-3">
						<input type="checkbox" class="custom-control-input" {{ (! empty(old('motivo_3')) ? 'checked' : '') }} <?php if ($datos_asignacion[0]->motivo == 'Daño de usuario') {
																																	echo 'checked';
																																} ?> id="motivo_3" name="motivo_3">
						<label class="custom-control-label" for="motivo_3">Daño de usuario</label>
					</div>
				</div>
			</div>
			<!--FOTOS-->
			<div class="container" id="fotos_accesorios" style="display:none">
				<button class="btn btn-ter w-25 asignarimagenes" type="button">Subir imagenes</button>
			</div>
			<!--ACCESORIOS DAÑADOS-->
			<div class="container" <?php if ($datos_asignacion[0]->motivo == 'Fin de vida util' || $datos_asignacion[0]->motivo == 'Daño de usuario') {
										echo 'style="display:"';
									} else {
										echo 'style="display:none"';
									} ?> id="div_accesorios_danados">
				<div class="row">
					<div class="col-sm-12 seccion-filtro mt-2">Accesorios Dañados</div>
					<hr class="container mx-3 separador">
					<div class="col-sm-6 form-group">
						<label for="">Nombre de la pieza</label>
						<input type="" class="form-control mayuscula" id="keywords2" placeholder="Nombre de la pieza" name="" value="" oninput="myFunction2()">
					</div>
					<div class="col-sm-6 form-group">
						<label for="">Número de la pieza</label>
						<input type="" class="form-control mayuscula" id="articulo2" placeholder="Número de la pieza" name="" value="" oninput="myFunction2()">
					</div>
					<div class="container mx-3 mb-2" id="" style="max-height: 300px; border: 1px solid #ddd; border-radius: 6px; background: #ffffff; overflow-y: scroll;">
						<table class="table table-hover">
							<tbody id="accesorios2"></tbody>
						</table>
					</div>
					<div class="col-sm-12">
						<table class="table table-hover" id="tabla2">
							<thead class="bg-light">
								<th scope="col">Nombre de la pieza</th>
								<th scope="col">Numero de parte</th>
								<th scope="col">S/N parte</th>
								<th scope="col">Cantidad</th>
								<th scope="col">Acciones</th>
							</thead>
							<tbody id="agregar_accesorios2">
								@foreach ($accesorios_dañados as $key => $los_datos)
								<tr class="2eliminar{{$key+1}}">
									<td>
										<input name="descripcion_accesorio2[]" value="{{$los_datos->ID}}" type="hidden">
										{{$los_datos->descripcion}}
									</td>
									<td>
										{{$los_datos->articulo}}
									</td>
									<td>
										<input required type="text" value="{{$los_datos->serie_parte}}" required name="serie_parte2[]" class="form-control 2serie_parte{{$key+1}}" onkeyup="this.value=Numeros(this.value)">
									</td>
									<td>
										<button class="btn btn-light" type="button" onclick="sumalo2({{$key+1}})">+</button>
										<input type="hidden" name="cantidad2[]" value="{{$los_datos->cantidad}}" class="2resutlados{{$key+1}}" id="2resultados{{$key+1}}">
										<span class="resultado{{$key+1}}" id="2resultado{{$key+1}}">{{$los_datos->cantidad}}</span>
										<button class="btn btn-light" type="button" onclick="restalo2({{$key+1}})">-</button>
									</td>
									<td class="text-center" onclick="eliminalo2({{$key+1}})">
										<a class="btn-icon btn-icon-dd ver_historial_retiros">
											<span class="material-icons-round">delete</span>
										</a>
									</td>
								</tr>
								@endforeach
							</tbody>
						</table>
					</div>
				</div>
			</div>
			<!--ACCESORIOS A SOLICITAR-->
			<div class="container" <?php if (count($accesorios)) {
										echo 'style="display:"';
									} else {
										echo 'style="display:none"';
									} ?> id="div_accesorios_solicitados" style="display:none">
				<div class="row">
					<div class="col-sm-12 seccion-filtro mt-2">Seleccione Accesorios a solicitar</div>
					<hr class="container mx-3 separador">
					<div class="col-sm-6 form-group">
						<label for="">Nombre de la pieza</label>
						<input type="" class="form-control mayuscula" id="keywords" placeholder="Nombre de la pieza" name="" value="" oninput="myFunction()">
					</div>
					<div class="col-sm-6 form-group">
						<label for="">Número de la pieza</label>
						<input type="" class="form-control mayuscula" id="articulo" placeholder="Número de la pieza" name="" value="" oninput="myFunction()">
					</div>
					<div class="container mx-3 mb-2" id="" style="max-height: 300px; border: 1px solid #ddd; border-radius: 6px; background: #ffffff; overflow-y: scroll;">
						<table class="table table-hover">
							<tbody id="accesorios"></tbody>
						</table>
					</div>
					<div class="col-sm-12">
						<table class="table table-hover" id="tabla">
							<thead class="bg-light">
								<th scope="col">Nombre de la pieza</th>
								<th scope="col">Numero de parte</th>
								<th scope="col">S/N parte</th>
								<th scope="col">Cantidad</th>
								<th scope="col">Acciones</th>
							</thead>
							<tbody id="agregar_accesorios">
								@foreach ($accesorios as $key => $los_datos)
								<tr class="eliminar{{$key+1}}">
									<td>
										<input name="descripcion_accesorio[]" value="{{$los_datos->ID}}" type="hidden">
										{{$los_datos->descripcion}}
									</td>
									<td>
										{{$los_datos->articulo}}
									</td>
									<td>
										<input required type="text" value="{{$los_datos->serie_parte}}" name="serie_parte[]" class="form-control serie_parte{{$key+1}}" onkeyup="this.value=Numeros(this.value)">
									</td>
									<td>
										<button class="btn btn-light" type="button" onclick="sumalo({{$key+1}})">+</button>
										<input type="hidden" name="cantidad[]" value="{{$los_datos->cantidad}}" class="resutlados{{$key+1}}" id="resultados{{$key+1}}">
										<span class="resultado{{$key+1}}" id="resultado{{$key+1}}">{{$los_datos->cantidad}}</span>
										<button class="btn btn-light" type="button" onclick="restalo({{$key+1}})">-</button>
									</td>
									<td class="text-center" onclick="eliminalo({{$key+1}})">
										<a class="btn-icon btn-icon-dd ver_historial_retiros">
											<span class="material-icons-round">delete</span>
										</a>
									</td>
								</tr>
								@endforeach
							</tbody>
						</table>
					</div>
				</div>
			</div>
			<!--PARTES MANUAL -->
			<div class="container mt-3" id="div_ingresar_manual" style="display:none">
				<div class="col-sm-12 form-group checkbox d-flex">
					<label class="mr-3" for="">Ingresar manual</label>
					<div class="custom-control custom-checkbox mr-3">
						<input type="checkbox" class="custom-control-input" id="accesorios_manual_si" name="accesorios_manual_si">
						<label class="custom-control-label" for="accesorios_manual_si">Si</label>
					</div>
					<div class="custom-control custom-checkbox mr-3">
						<input type="checkbox" class="custom-control-input" checked id="accesorios_manual_no" disabled name="accesorios_manual_no">
						<label class="custom-control-label" for="accesorios_manual_no">No</label>
					</div>
				</div>
			</div>
			<div class="container" id="div_accesorios_manual" style="display:none">
				<div class="row">
					<div class="col-sm-12 seccion-filtro mt-2">Ingrese accesorios manualmente</div>
					<hr class="container mx-3 separador">
					<div class="col-sm-12">
						<table class="table table-hover" id="tabla">
							<thead class="bg-light">
								<th scope="col">Nombre de la pieza</th>
								<th scope="col">Numero de parte</th>
								<th scope="col">S/N parte</th>
								<th scope="col">Cantidad</th>
								<th scope="col">Observaciones</th>
								<th scope="col">Acciones</th>
							</thead>
							<tbody id="agregar_accesorios_manual">
								<tr class="3eliminar0">
									<td>
										<input type="text" id="nombre_pieza_manual" name="nombre_pieza3[]" class="form-control" placeholder="Nombre de la pieza">
									</td>
									<td>
										<input type="text" id="numero_parte_manual" name="numero_parte3[]" class="form-control" placeholder="Numero de parte">
									</td>
									<td>
										<input type="text" id="serie_parte_manual" name="serie_parte3[]" class="form-control" onkeyup="this.value=Numeros(this.value)">
									</td>
									<td>
										<button class="btn btn-light" type="button" onclick="sumalo3(0)">+</button>
										<input type="hidden" name="cantidad3[]" value="1" class="3resutlados0" id="3resultados0">
										<span class="3resultado0" id="3resultado0">1</span>
										<button class="btn btn-light" type="button" onclick="restalo3(0)">-</button>
									</td>
									<td>
										<input type="text" id="observacion_manual" name="observacion3[]" class="form-control" placeholder="Observacion">
									</td>
									<td class="text-center">
										<a class="btn-icon btn-icon-dd" onclick="eliminalo3(0)">
											<span class="material-icons-round">delete</span>
										</a>
										<a class="btn-icon btn-icon-dd" onclick="agregar3(0)">
											<span class="material-icons">add</span>
										</a>
									</td>
								</tr>
							</tbody>
						</table>
					</div>
				</div>
			</div>
			<!--FIN PARTES MANUAL-->
		</div>
		<!--INSTALACION DE PARTES-->
		<div class="seccion-filtro mt-2">Instalacion de accesorios</div>
		<hr class="separador">
		<div class="row bg-destacar py-3">
			<div class="col-sm-12 form-group checkbox d-flex">
				<label class="mr-3" for="">Instalar accesorios</label>
				<div class="custom-control custom-checkbox mr-3">
					<input type="checkbox" class="custom-control-input" id="accesorios_instalacion_si" name="accesorios_instalacion_si" {{ (! empty(old('accesorios_instalacion_si')) ? 'checked' : '') }}>
					<label class="custom-control-label" for="accesorios_instalacion_si">Si</label>
				</div>
				<div class="custom-control custom-checkbox mr-3">
					<input type="checkbox" class="custom-control-input" id="accesorios_instalacion_no" name="accesorios_instalacion_no" onchange="javascript:showContent2(); javascript:changeCheckSi2()" {{ (! empty(old('accesorios_instalacion_no')) ? 'checked' : '') }}>
					<label class="custom-control-label" for="accesorios_instalacion_no">No</label>
				</div>
			</div>
			<div id="div_accesorios_instalacion" style="display:none">
				<div class="container">
					<div class="row">
						<hr class="container mx-3 separador">
						<div class="col-sm-6 form-group">
							<label for="">Nombre de la pieza</label>
							<input type="" class="form-control mayuscula" id="keywords3" placeholder="Nombre de la pieza" name="" value="" oninput="myFunction3()">
						</div>
						<div class="col-sm-6 form-group">
							<label for="">Número de la pieza</label>
							<input type="" class="form-control mayuscula" id="articulo3" placeholder="Número de la pieza" name="" value="" oninput="myFunction3()">
						</div>
						<div class="container mx-3 mb-2" id="" style="max-height: 300px; border: 1px solid #ddd; border-radius: 6px; background: #ffffff; overflow-y: scroll;">
							<table class="table table-hover">
								<tbody id="accesorios3"></tbody>
							</table>
						</div>
						<div class="col-sm-12">
							<table class="table table-hover" id="tabla2">
								<thead class="bg-light">
									<th scope="col">Nombre de la pieza</th>
									<th scope="col">Numero de parte</th>
									<th scope="col">S/N parte</th>
									<th scope="col">Cantidad</th>
									<th scope="col">Acciones</th>
								</thead>
								<tbody id="agregar_accesorios_instalacion"></tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
			<div>
				<!--PARTES MANUAL INSTALACION DE ACCESORIOS-->
				<div class="container mt-3" id="div_ingresar_manual_instalacion" style="display:none">
					<div class="col-sm-12 form-group checkbox d-flex">
						<label class="mr-3" for="">Ingresar manual</label>
						<div class="custom-control custom-checkbox mr-3">
							<input type="checkbox" class="custom-control-input" id="accesorios_instalacion_manual_si" name="accesorios_instalacion_manual_si">
							<label class="custom-control-label" for="accesorios_instalacion_manual_si">Si</label>
						</div>
						<div class="custom-control custom-checkbox mr-3">
							<input type="checkbox" class="custom-control-input" checked id="accesorios_instalacion_manual_no" disabled name="accesorios_instalacion_manual_no">
							<label class="custom-control-label" for="accesorios_instalacion_manual_no">No</label>
						</div>
					</div>
				</div>
				<div class="container" id="div_accesorios_manual_instalacion" style="display:none">
					<div class="row">
						<div class="col-sm-12 seccion-filtro mt-2">Ingrese accesorios manualmente</div>
						<hr class="container mx-3 separador">
						<div class="col-sm-12">
							<table class="table table-hover" id="tabla">
								<thead class="bg-light">
									<th scope="col">Nombre de la pieza</th>
									<th scope="col">Numero de parte</th>
									<th scope="col">S/N parte</th>
									<th scope="col">Cantidad</th>
									<th scope="col">Observaciones</th>
									<th scope="col">Acciones</th>
								</thead>
								<tbody id="agregar_accesorios_manual_instalacion">
									<tr class="5eliminar0">
										<td>
											<input type="text" id="nombre_pieza_manual_instalacion" name="nombre_pieza5[]" class="form-control" placeholder="Nombre de la pieza">
										</td>
										<td>
											<input type="text" id="numero_parte_manual_instalacion" name="numero_parte5[]" class="form-control" placeholder="Numero de parte">
										</td>
										<td>
											<input type="text" id="serie_parte_manual_instalacion" name="serie_parte5[]" class="form-control" onkeyup="this.value=Numeros(this.value)">
										</td>
										<td>
											<button class="btn btn-light" type="button" onclick="sumalo5(0)">+</button>
											<input type="hidden" name="cantidad5[]" value="1" class="5resutlados0" id="5resultados0">
											<span class="5resultado0" id="5resultado0">1</span>
											<button class="btn btn-light" type="button" onclick="restalo5(0)">-</button>
										</td>
										<td>
											<input type="text" id="observacion_manual_instalacion" name="observacion5[]" class="form-control" placeholder="Observacion">
										</td>
										<td class="text-center">
											<a class="btn-icon btn-icon-dd" onclick="eliminalo5(0)">
												<span class="material-icons-round">delete</span>
											</a>
											<a class="btn-icon btn-icon-dd" onclick="agregar5(0)">
												<span class="material-icons">add</span>
											</a>
										</td>
									</tr>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
			<!--FINAL PARTES MANUAL INSTALACION DE ACCESORIOS-->
		</div>
		<!--FIN INSTALACION DE PARTES-->
		<div class="seccion-filtro mt-2">Equipo operativo</div>
		<hr class="separador">
		<div class="row">
			<div class="col-md-12 form-group check-input check-space">
				<div class="custom-control custom-checkbox">
					<input type="checkbox" class="custom-control-input" id="equipo_operativo" required name="equipo_operativo" value="{{ old('equipo_operativo') ?? $datos_asignacion[0]->equipo_operativo ?? ''}}" {{ (! empty(old('equipo_operativo')) ? 'checked' : '') }}>
					<label class="custom-control-label" for="equipo_operativo">Equipo operativo</label>
				</div>
			</div>
			<div class="col-sm-12 form-group checkbox">
				<label for="cambio">Observaciones</label>
				<textarea required class="form-control mayuscula" id="cambio" name="obsercaviones" rows="4" name="observaciones"> {{$datos_asignacion[0]->CsObservacion ?? ''}} {{old('obsercaviones')}}</textarea>
				<div class="invalid-feedback">Este campo es requerido!</div>
			</div>

			<div class="col-md-12 form-group check-input check-space">
			<label for="cambio">Para modelo impresora HP 408 dn</label>
				
			<div class="col-md-12 form-group check-input check-space" style="margin-left: 10px;">
			<!-- {{old('impresora408')}} -->
			    <input type="checkbox" class="custom-control-input" id="impresora408"  name="impresora408" value="si" {{ (! empty(old('impresora408')) ? 'checked' : '') }}>
				<label class="custom-control-label" for="impresora408">SI</label>
			</div>

			@if(old('impresora408'))


				<div style="display:" id="datosdelaimpresora408">		
						<div class="col-md-12 form-group check-input check-space" style="margin-left: 10px;">
						<input type="checkbox" class="custom-control-input" id="monitoreo_print"  name="monitoreo_print" value="si" {{ (! empty(old('monitoreo_print')) ? 'checked' : '') }}> 
						<label class="custom-control-label" for="monitoreo_print">Adaptador monitoreo nube print</label>
					</div>
					<div class="col-md-12 form-group check-input check-space" style="margin-left: 10px;">
						<input type="checkbox" class="custom-control-input" id="monito_we"  name="monito_we" value="si" {{ (! empty(old('monito_we')) ? 'checked' : '') }}> 
						<label class="custom-control-label" for="monito_we">Pruebas aplicacion Monito we</label>
					</div>
				</div>
				@else
				<div style="display:none" id="datosdelaimpresora408">		
						<div class="col-md-12 form-group check-input check-space" style="margin-left: 10px;">
						<input type="checkbox" class="custom-control-input" id="monitoreo_print"  name="monitoreo_print" value="si" {{ (! empty(old('monitoreo_print')) ? 'checked' : '') }}> 
						<label class="custom-control-label" for="monitoreo_print">Adaptador monitoreo nube print</label>
					</div>
					<div class="col-md-12 form-group check-input check-space" style="margin-left: 10px;">
						<input type="checkbox" class="custom-control-input" id="monito_we"  name="monito_we" value="si" {{ (! empty(old('monito_we')) ? 'checked' : '') }}> 
						<label class="custom-control-label" for="monito_we">Pruebas aplicacion Monito we</label>
					</div>
				</div>

			@endif
				
			</div>
		</div>
		<div class="seccion-filtro mt-2">Datos</div>
		<hr class="separador">
		<div class="row">
			<div class="col-md-6">
				<div class="row">
					<div class="col-sm-12 form-group">
						<label for="">Datos del Técnico</label>
						<input readonly type="text" class="form-control mayuscula" id="" placeholder="DATOS DEL TÉCNICO" name="" value="{{ $datos_asignacion[0]->nombrepersona. " ". $datos_asignacion[0]->nombrepe  ?? ''}}">
					</div>
				</div>
			</div>
			<div class="col-md-6">
				<div class="row">
					<div class="col-sm-12 form-group">
						<label for="">Datos del Contacto</label>
						<input required type="text" class="form-control mayuscula" placeholder="DATOS DEL CONTACTO" value="{{old('nombre_contacto')}}" name="nombre_contacto">
						<div class="invalid-feedback">Este campo es requerido!</div>
					</div>
					{{-- @if (strtolower($proyecto_asociado[0]->proveedor_instalacion) === 'kyocera' && strtolower($proyecto_asociado[0]->nombre) === 'embalajes y aumentos de parque') --}}
						<label for="correo">Correo del Contacto:</label>
						<input required type="text" class="form-control mayuscula" placeholder="CORREO DEL CONTACTO" value="{{old('correo_contacto')}}" name="correo_contacto">
						<div class="invalid-feedback">Este campo es requerido!</div>
					{{-- @else
							<div class="col-sm-12 form-group">
								<label for="">Rut del Contacto</label>
								<input required type="text" class="form-control mayuscula" placeholder="RUT DEL CONTACTO" value="{{old('rut_contacto')}}" name="rut_contacto">
								<div class="invalid-feedback">Este campo es requerido!</div>
							</div>
					@endif --}}
					<!-- <div class="col-sm-12 form-group">
						<label for="">Rut del Contacto</label>
						<input required type="text" class="form-control mayuscula" placeholder="RUT DEL CONTACTO" value="{{old('rut_contacto')}}" name="rut_contacto">
						<div class="invalid-feedback">Este campo es requerido!</div>
					</div> -->
					<div class="col-sm-12 form-group">
						<label for="">Firma Contacto</h2>
					</div>

					@php
					$hora_actual = Carbon\Carbon::now();
					$date = $hora_actual->toTimeString();
					$hora_salida = "20:00:00";
					$hora_entrada = "08:00:00";
					@endphp
					@if ( $datos_asignacion[0]->estado_inicio != 0 || $datos_asignacion[0]->estado_inicio != "" )
					<div class="col-sm-12 form-group checkbox check-space">
						<div class="custom-control custom-checkbox">
							<input type="checkbox" class="custom-control-input" id="no_firma_cliente" name="no_firma_cliente" value="si">
							<label class="custom-control-label" for="no_firma_cliente">Cliente se niega a firmar</label>
						</div>
					</div>


					<div class="col-sm-12 form-group">
						<button type="button" id="contenido" class="btn"><a href="{{route('firma_instalacion',Crypt::encryptString($datos_asignacion[0]->id)) ?? ''}}" target="_blank">FIRMA CLIENTE</a></button>
						@if($datos_asignacion[0]->url_firma != "")
						<label for="">( Firma ya Registrada) </label>
						@endif
						<input type='hidden' name='imagen' id='imagen' />
					</div>
					@endif
				</div>
			</div>
		</div>

		<div class="seccion-filtro mt-2">Imágenes</div>
		<hr class="separador">
		<div class="row">
			<div class="col-sm-12 form-group">
				<label class="d-block" for="">Subir imágenes</label>
				@if($cantidad_fotos != 0)
				(El siguiente Check, ya tiene imagenes asociadas)<br>
				@endif
				<div class="text-center modo-escritorio">
					<button class="btn btn-secundario asignarimagen col-sm-3" type="button">Imágenes</button>
					<!--<button type="button" class="btn btn-secundario col-sm-3" data-toggle="modal" data-target="#modal_fotos_android">Android</button>
					<button type="button" class="btn btn-secundario col-sm-3" data-toggle="modal" data-target="#modal_fotos_email">Email</button>-->
				</div>
				<div class="text-center modo-mobil">
					<button class="btn btn-secundario asignarimagen btn-block" type="button">Imágenes</button>
					<!--<button type="button" class="btn btn-secundario btn-block" data-toggle="modal" data-target="#modal_fotos_android">Android</button>
					<button type="button" class="btn btn-secundario btn-block" data-toggle="modal" data-target="#modal_fotos_email">Email</button>-->
				</div>
			</div>
		</div>
		<hr class="separador">

		<div class="row">
			<div class="col-sm-4 form-group ">
				<label for="">Estado</label>
				<select name="estado" required class="custom-select mayuscula col-mb-3" id="estado">
					@if(!empty($estado))
					@foreach ($estado as $los_datos)
					@if($los_datos == "Finalizar" || $los_datos == "finalizar")
					<option class="mayuscula" selected value="{{$los_datos}}" {{ old('estado') == $los_datos ? 'selected' : '' }}> {{$los_datos}} </option>
					@else
					<option class="mayuscula" value="{{$los_datos}}" {{ old('estado') == $los_datos ? 'selected' : '' }}> {{$los_datos}} </option>
					@endif
					@endforeach
					@endif
				</select>
				@error('estado')
				<div class="alert alert-danger">{{ $message }}</div>
				@enderror
			</div>
			<div class="col-sm-4 form-group ">
				<label for="">Detalle</label>
				<select name="detalle" required class="custom-select mayuscula col-mb-3" id="detalle">
					@if(!empty($detalle))
					@foreach ($detalle as $los_datos)
					@if($los_datos == "Equipo operativo" || $los_datos == "equipo operativo")
					<option class="mayuscula" selected value="{{$los_datos}}" {{ old('detalle') == $los_datos ? 'selected' : '' }}> {{$los_datos}} </option>
					@else
					<option class="mayuscula" value="{{$los_datos}}" {{ old('detalle') == $los_datos ? 'selected' : '' }}> {{$los_datos}} </option>
					@endif
					@endforeach
					@endif
				</select>
				@error('detalle')
				<div class="alert alert-danger">{{ $message }}</div>
				@enderror
			</div>
			@if ( $datos_asignacion[0]->estado_inicio != 0 || $datos_asignacion[0]->estado_inicio != "" )
			<div class="col-sm-4 form-group d-flex">
				<button class="btn btn-prim btn-block align-self-end" type="submit">GUARDAR</button>
			</div>
			@endif
		</div>
</div>
</form>
</div>
<!-- FIN BARRA DE BUSQUEDA -->







<!--MODAL CARGA DE IMÁGENES DE ACCESORIOS-->
<div class="modal fade" id="modal_fotos_accesorios" role="dialog" data-backdrop="static">
	<div class="modal-dialog modal-lg">
		<div class="modal-content">
			<div class="modal-header">
				<h4>Ingrese las fotos de accesorios</h4>
				<button type="button" class="close" data-dismiss="modal">&times;</button>
			</div>
			<hr class="separador ml-4 mr-4">
			<div class="modal-body">
				<div class="container">
					<!-- CARGA DE IMÁGENES DE ACCESORIOS -->
					<div class="seccion-filtro mt-2">Adjunte las imágenes que se solicita a continuación</div>
					<div class="row">
						<input type="text" style="display:none" name="check_list" id="idchecklist" value="{{$datos_asignacion[0]->id_checklist}}">
						<div class="col-12">
							<label style="color:red" ; id="mensaje-text" for=""></label>
						</div>
						<div id="carouselExampleControls" class="carousel slide w-100" data-interval="false">
							<div class="carousel-inner">
								<!-- 1 -->
								<div class="carousel-item active">
									<form enctype="multipart/form-data" class="formuploadaccesorios" method="post">
										@csrf
										<div class="col-sm-12 form-group">
											<input type="text" style="display:none" name="check_list" id="idchecklist" value="{{$datos_asignacion[0]->id_checklist}}">
											<label for="cargafotoa1" class="espacio_carga_img">Fotografía 1</label>
											<input type="file" required id="cargafotoa1" name="cargafotoa1" accept="image/*">
											<button class="btn btn-prim d-block mx-auto mt-2" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<!-- 2 -->
								<div class="carousel-item">
									<form enctype="multipart/form-data" class="formuploadaccesorios" method="post">
										@csrf
										<div class="col-sm-12 form-group">
											<input type="text" style="display:none" name="check_list" id="idchecklist" value="{{$datos_asignacion[0]->id_checklist}}">
											<label for="cargafotoa2" class="espacio_carga_img">Fotografía 2</label>
											<input type="file" id="cargafotoa2" name="cargafotoa2">
											<button class="btn btn-prim d-block mx-auto mt-2" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<!-- 3 -->
								<div class="carousel-item">
									<form enctype="multipart/form-data" class="formuploadaccesorios" method="post">
										@csrf
										<div class="col-sm-12 form-group">
											<input type="text" style="display:none" name="check_list" id="idchecklist" value="{{$datos_asignacion[0]->id_checklist}}">
											<label for="cargafotoa3" class="espacio_carga_img">Fotografía 3</label>
											<input type="file" id="cargafotoa3" name="cargafotoa3">
											<button class="btn btn-prim d-block mx-auto mt-2" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<!-- 4 -->
								<div class="carousel-item">
									<form enctype="multipart/form-data" class="formuploadaccesorios" method="post">
										@csrf
										<div class="col-sm-12 form-group">
											<input type="text" style="display:none" name="check_list" id="idchecklist" value="{{$datos_asignacion[0]->id_checklist}}">

											<label for="cargafoto3" class="espacio_carga_img">Fotografía 4</label>
											<input type="file" id="cargafotoa4" name="cargafotoa4">
											<button class="btn btn-prim d-block mx-auto mt-2" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<!-- 5 -->
								<div class="carousel-item">
									<form enctype="multipart/form-data" class="formuploadaccesorios" method="post">
										@csrf
										<div class="col-sm-12 form-group">
											<input type="text" style="display:none" name="check_list" id="idchecklist" value="{{$datos_asignacion[0]->id_checklist}}">

											<label for="cargafoto3" class="espacio_carga_img">Fotografía 5</label>
											<input type="file" id="cargafotoa5" name="cargafotoa5">
											<button class="btn btn-prim d-block mx-auto mt-2" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<!-- 6 -->
								<div class="carousel-item">
									<form enctype="multipart/form-data" class="formuploadaccesorios" method="post">
										@csrf
										<div class="col-sm-12 form-group">
											<input type="text" style="display:none" name="check_list" id="idchecklist" value="{{$datos_asignacion[0]->id_checklist}}">

											<label for="cargafoto3" class="espacio_carga_img">Fotografía 6</label>
											<input type="file" id="cargafotoa6" name="cargafotoa6">
											<button class="btn btn-prim d-block mx-auto mt-2" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<!-- 7 -->
								<div class="carousel-item">
									<form enctype="multipart/form-data" class="formuploadaccesorios" method="post">
										@csrf
										<div class="col-sm-12 form-group">
											<input type="text" style="display:none" name="check_list" id="idchecklist" value="{{$datos_asignacion[0]->id_checklist}}">

											<label for="cargafoto3" class="espacio_carga_img">Fotografía 7</label>
											<input type="file" id="cargafotoa7" name="cargafotoa7">
											<button class="btn btn-prim d-block mx-auto mt-2" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<!-- 8 -->
								<div class="carousel-item">
									<form enctype="multipart/form-data" class="formuploadaccesorios" method="post">
										@csrf
										<div class="col-sm-12 form-group">
											<input type="text" style="display:none" name="check_list" id="idchecklist" value="{{$datos_asignacion[0]->id_checklist}}">

											<label for="cargafoto3" class="espacio_carga_img">Fotografía 8</label>
											<input type="file" id="cargafotoa8" name="cargafotoa8">
											<button class="btn btn-prim d-block mx-auto mt-2" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<!-- 9 -->
								<div class="carousel-item">
									<form enctype="multipart/form-data" class="formuploadaccesorios" method="post">
										@csrf
										<div class="col-sm-12 form-group">
											<input type="text" style="display:none" name="check_list" id="idchecklist" value="{{$datos_asignacion[0]->id_checklist}}">

											<label for="cargafoto3" class="espacio_carga_img">Fotografía 9</label>
											<input type="file" id="cargafotoa9" name="cargafotoa9">
											<button class="btn btn-prim d-block mx-auto mt-2" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<!-- 10 -->
								<div class="carousel-item">
									<form enctype="multipart/form-data" class="formuploadaccesorios" method="post">
										@csrf
										<div class="col-sm-12 form-group">
											<input type="text" style="display:none" name="check_list" id="idchecklist" value="{{$datos_asignacion[0]->id_checklist}}">

											<label for="cargafoto3" class="espacio_carga_img">Fotografía 10</label>
											<input type="file" id="cargafotoa10" name="cargafotoa10">
											<button class="btn btn-prim d-block mx-auto mt-2" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
							</div>
						</div>
						<div class="text-center mb-2">
							<a class="carousel-control-prev previus_carrusel" style="display:none" href="#carouselExampleControls" role="button" data-slide="prev">
								<span class="material-icons" style="color:black">
									arrow_back_ios
								</span>
							</a>
						</div>
						<div class="container wrapper2 wrap2 mt-2 w-75" style="display: none">
							<div class="progress progress_wrapper">
								<div class="progress-bar progbar2 progress-bar-striped bg-info progress-bar-animated progress_bar" role="progressbar" style="width: 0%">
									0%
								</div>
							</div>
						</div>
					</div>
					<!-- FIN CARGA DE IMÁGENES DE INSTALACIÓN -->
					<div class="modal-footer d-flex justify-content-center">
						<button class="btn btn-prim" type="button" data-dismiss="modal">Guardar</button>
						<button class="btn btn-secundario" type="button" data-dismiss="modal">Cancelar</button>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<!--FIN MODAL FOTOS ACCESORIOS-->


<!-- MODAL IMAGENES -->
<div class="modal fade" id="modal_historial_retiros" role="dialog" data-backdrop="static">
	<div class="modal-dialog  modal-lg">
		<div class="modal-content">
			<div class="modal-header">
				<div class="seccion-modal">Ingresar el siguiente ID en la Aplicacción</div>
				<button type="button" class="cancel_image close">&times;</button>
			</div>
			<hr class="separador ml-4 mr-4">

			<div class="modal-body">
				<div class="container">
					<!-- CARGA DE IMÁGENES DE INSTALACIÓN -->
					<div class="seccion-filtro mt-2">Adjunte las imágenes que se solicita a continuación</div>
					<div class="row">
						<input type="text" style="display:none" name="check_list" id="" value="{{$datos_asignacion[0]->id_checklist}}">
						<div class="col-sm-12">
							<label style="color:red" id="mensaje-text" for="" class="mensaje_validacion"></label>
						</div>
						<!-- 1 -->
						<div id="carouselExampleControls2" class="carousel slide  w-100" data-interval="false">
							<div class="carousel-inner">
								<div class="carousel-item active">
									<form enctype="multipart/form-data" class="formuploadajax" method="post">
										@csrf
										<div class="col-sm-12 form-group">
											<input type="text" style="display:none" name="check_list" id="" value="{{$datos_asignacion[0]->id_checklist}}">
											<img src="{{ asset('img/p1.png') }}" width="30" height="30" class="espacio_carga_img" alt="" />
											<label for="cargafoto1" class="espacio_carga_img">Fotografía de la página de estado</label>
											<input type="file" required id="cargafoto1" name="cargafoto1" accept="image/*">
											<button class="btn btn-prim d-block mx-auto mt-2" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<div class="carousel-item">
									<form enctype="multipart/form-data" class="formuploadajax" method="post">
										@csrf
										<div class="col-sm-12 form-group">
											<input type="text" style="display:none" name="check_list" id="" value="{{$datos_asignacion[0]->id_checklist}}">
											<img src="{{ asset('img/p2.png') }}" width="30" height="30" class="espacio_carga_img" alt="" />
											<label for="cargafoto2" class="espacio_carga_img">Fotografía del panel de la máquina</label>
											<input type="file" required id="cargafoto2" name="cargafoto2" accept="image/*">
											<button class="btn btn-prim d-block mx-auto mt-2" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<div class="carousel-item">
									<form enctype="multipart/form-data" id="formuploadajax3" class="formuploadajax" method="post">
										@csrf
										<div class="col-sm-12 form-group">
											<input type="text" style="display:none" name="check_list" id="" value="{{$datos_asignacion[0]->id_checklist}}">
											<img src="{{ asset('img/p3.png') }}" width="30" height="30" class="espacio_carga_img" alt="" />
											<label for="cargafoto3" class="espacio_carga_img">Fotografía a 2 metros del equipo</label>
											<input type="file" required id="cargafoto3" name="cargafoto3" accept="image/*">
											<button class="btn btn-prim d-block mx-auto mt-2" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<div class="carousel-item">
									<form enctype="multipart/form-data" id="formuploadajax4" class="formuploadajax" method="post">
										@csrf
										<div class="col-sm-12 form-group">
											<input type="text" style="display:none" name="check_list" id="" value="{{$datos_asignacion[0]->id_checklist}}">
											<label for="cargafoto4" class="espacio_carga_img">Fotografía 4 </label>
											<input type="file" required id="cargafoto4" name="cargafoto4" accept="image/*">
											<button class="btn btn-prim d-block mx-auto mt-2" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<div class="carousel-item">
									<form enctype="multipart/form-data" id="formuploadajax5" class="formuploadajax" method="post">
										@csrf
										<div class="col-sm-12 form-group">
											<input type="text" style="display:none" name="check_list" id="" value="{{$datos_asignacion[0]->id_checklist}}">
											<label for="cargafoto5" class="espacio_carga_img">Fotografía 5 </label>
											<input type="file" required id="cargafoto5" name="cargafoto5" accept="image/*">
											<button class="btn btn-prim d-block mx-auto mt-2" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<div class="carousel-item">
									<form enctype="multipart/form-data" id="formuploadajax6" class="formuploadajax" method="post">
										@csrf
										<div class="col-sm-12 form-group">
											<input type="text" style="display:none" name="check_list" id="" value="{{$datos_asignacion[0]->id_checklist}}">
											<label for="cargafoto6" class="espacio_carga_img">Fotografía 6 </label>
											<input type="file" required id="cargafoto6" name="cargafoto6" accept="image/*">
											<button class="btn btn-prim d-block mx-auto mt-2" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<div class="carousel-item">
									<form enctype="multipart/form-data" id="formuploadajax7" class="formuploadajax" method="post">
										@csrf
										<div class="col-sm-12 form-group">
											<input type="text" style="display:none" name="check_list" id="" value="{{$datos_asignacion[0]->id_checklist}}">
											<label for="cargafoto7" class="espacio_carga_img">Fotografía 7 </label>
											<input type="file" required id="cargafoto7" name="cargafoto7" accept="image/*">
											<button class="btn btn-prim d-block mx-auto mt-2" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<div class="carousel-item">
									<form enctype="multipart/form-data" id="formuploadajax8" class="formuploadajax" method="post">
										@csrf
										<div class="col-sm-12 form-group">
											<input type="text" style="display:none" name="check_list" id="" value="{{$datos_asignacion[0]->id_checklist}}">
											<label for="cargafoto8" class="espacio_carga_img">Fotografía 8 </label>
											<input type="file" required id="cargafoto8" name="cargafoto8" accept="image/*">
											<button class="btn btn-prim d-block mx-auto mt-2" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<div class="carousel-item">
									<form enctype="multipart/form-data" id="formuploadajax9" class="formuploadajax" method="post">
										@csrf
										<div class="col-sm-12 form-group">
											<input type="text" style="display:none" name="check_list" id="" value="{{$datos_asignacion[0]->id_checklist}}">
											<label for="cargafoto9" class="espacio_carga_img">Fotografía 9 </label>
											<input type="file" required id="cargafoto9" name="cargafoto9" accept="image/*">
											<button class="btn btn-prim d-block mx-auto mt-2" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<div class="carousel-item">
									<form enctype="multipart/form-data" id="formuploadajax10" class="formuploadajax" method="post">
										@csrf
										<div class="col-sm-12 form-group">
											<input type="text" style="display:none" name="check_list" id="" value="{{$datos_asignacion[0]->id_checklist}}">
											<label for="cargafoto10" class="espacio_carga_img">Fotografía 10 </label>
											<input type="file" required id="cargafoto10" name="cargafoto10" accept="image/*">
											<button class="btn btn-prim d-block mx-auto mt-2" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<div class="carousel-item">
									<form enctype="multipart/form-data" id="formuploadajax11" class="formuploadajax" method="post">
										@csrf
										<div class="col-sm-12 form-group">
											<input type="text" style="display:none" name="check_list" id="" value="{{$datos_asignacion[0]->id_checklist}}">
											<label for="cargafoto11" class="espacio_carga_img">Fotografía 11 </label>
											<input type="file" required id="cargafoto11" name="cargafoto11" accept="image/*">
											<button class="btn btn-prim d-block mx-auto mt-2" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<div class="carousel-item">
									<form enctype="multipart/form-data" id="formuploadajax12" class="formuploadajax" method="post">
										@csrf
										<div class="col-sm-12 form-group">
											<input type="text" style="display:none" name="check_list" id="" value="{{$datos_asignacion[0]->id_checklist}}">
											<label for="cargafoto12" class="espacio_carga_img">Fotografía 12 </label>
											<input type="file" required id="cargafoto12" name="cargafoto12" accept="image/*">
											<button class="btn btn-prim d-block mx-auto mt-2" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<div class="carousel-item">
									<form enctype="multipart/form-data" id="formuploadajax13" class="formuploadajax" method="post">
										@csrf
										<div class="col-sm-12 form-group">
											<input type="text" style="display:none" name="check_list" id="" value="{{$datos_asignacion[0]->id_checklist}}">
											<label for="cargafoto4" class="espacio_carga_img">Fotografía 13</label>
											<input type="file" required id="cargafoto13" name="cargafoto13" accept="image/*">
											<button class="btn btn-prim d-block mx-auto mt-2" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>

								@for ($i = 14; $i <= 25; $i++)
									<div class="carousel-item">
										<form enctype="multipart/form-data" id="formuploadajax{{$i}}" class="formuploadajax" method="post">
											@csrf
											<div class="col-sm-12 form-group">
												<input type="text" style="display:none" name="check_list" id="" value="{{$datos_asignacion[0]->id_checklist}}">
												<label for="cargafoto{{$i}}" class="espacio_carga_img">Fotografía {{$i}}</label>
												<input type="file" required id="cargafoto{{$i}}" name="cargafoto{{$i}}" accept="image/*">
												<button class="btn btn-prim d-block mx-auto mt-2" type="submit">Subir imagen</button>
											</div>
										</form>
									</div>
								@endfor
								
							</div>
						</div>
						<div class="container text-center mb-2">
							<a class="carousel-control-prev previus_carrusel2" style="display:none" href="#carouselExampleControls2" role="button" data-slide="prev">
								<span class="material-icons" style="color:black">
									arrow_back_ios
								</span>
							</a>
							<!--<a class="carousel-control-next" href="#carouselExampleControls" role="button" data-slide="next">
								<span class="carousel-control-next-icon" aria-hidden="true"></span>
								<span class="material-icons" style="color:black">
									arrow_forward_ios
								</span>
							</a>-->
						</div>
						<div class="container wrapper mt-5" style="display: none">
							<div class="progress progress_wrapper">
								<div class="progress-bar progress-bar-striped bg-info progress-bar-animated progress_bar" role="progressbar" style="width: 0%">
									0%
								</div>
							</div>
						</div>
						<div class="container form-group text-center my-4">
							<button class="btn btn-secundario cancel_image" type="button">Cancelar</button>
							<button class="btn btn-prim save_image" type="button">Guardar</button>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<!-- MODAL IMAGENES -->
	<div class="modal fade" id="modal_fotos_email" role="dialog">
		<div class="modal-dialog  modal-lg">
			<div class="modal-content">

				<div class="modal-header">
					<div class="seccion-modal">Ingresar 3 Fotos</div>
					<button type="button" class="close" data-dismiss="modal">&times;</button>
				</div>
				<hr class="separador ml-4 mr-4">

				<div class="modal-body">
					<div class="container text-center">
						<!-- CARGA DE IMÁGENES DE INSTALACIÓN -->
						<a class="btn btn-ter w-25 border rounded-lg py-2" href="mailto:ayaing@retailmax.cl?subject=<?php echo $datos_asignacion[0]->id_checklist; ?>">Subir Fotos</a>
					</div>

					<!-- FIN CARGA DE IMÁGENES DE INSTALACIÓN -->
					<div class="container form-group text-center my-4">
						<a class="btn btn-prim w-25" href="http://globati.com/ayaingenieria/index.php?id=<?php echo $datos_asignacion[0]->id_checklist; ?>" target="_blank">Confirmar</a>
						<button class="btn btn-secundario w-25 " type="button" data-dismiss="modal">Cancelar</button>
					</div>
				</div>
			</div>
		</div>
	</div>

	<!-- MODAL IMAGENES -->
	<div class="modal fade" id="modal_fotos_android" role="dialog">
		<div class="modal-dialog  modal-lg">
			<div class="modal-content">

				<div class="modal-header">
					<div class="seccion-modal">Ingresar el siguiente ID en la Aplicacción</div>
					<button type="button" class="close" data-dismiss="modal">&times;</button>
				</div>
				<hr class="separador ml-4 mr-4">

				<div class="modal-body">
					<div class="container">
						<!-- CARGA DE IMÁGENES DE INSTALACIÓN -->
						<div class="text-center">
							<h1 class="border rounded-lg py-3">ID = {{$datos_asignacion[0]->id_checklist}}</h1>
						</div>
						<!-- FIN CARGA DE IMÁGENES DE INSTALACIÓN -->
					</div>
					<div class="container form-group text-center my-4">
						<button class="btn btn-prim w-25" type="button" data-dismiss="modal">CANCELAR</button>
					</div>
				</div>
			</div>
		</div>
	</div>


	<div class="modal fade" id="modalfirma" tabindex="-1" role="dialog" aria-labelledby="modalfirma" aria-hidden="true">
		<div class="modal-dialog" role="document">
			<div class="modal-content">

				<div class="modal-header">
					<div class="seccion-modal" id="exampleModalLabel">Ingrese Firma</div>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>
				<div class="modal-body">
				</div>

				<div class="modal-footer">
					<button type="button" class="btn btn-primary">Guardar Firma</button>
					<button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
				</div>
			</div>
		</div>
	</div>
	@endsection
	<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
	<script>
		$(document).ready(function() {
    // Selecciona el elemento de entrada checkbox por su ID
    
    // Agrega un controlador de eventos 'change' al checkbox
    $("#impresora408").change(function() {
        // Verifica si el checkbox está marcado o desmarcado
        if ($("#impresora408").is(":checked")) {
			$("#datosdelaimpresora408").css("display","");
            // El checkbox está marcado
            // Realiza las acciones que deseas cuando está marcado
        } else {
			$("#datosdelaimpresora408").css("display","none");

            // El checkbox está desmarcado
            // Realiza las acciones que deseas cuando está desmarcado
        }
    });
});
		$(document).ready(() => {
			$(".previus_carrusel").click(function() {
				if ($("#carouselExampleControls").carousel(1)) {
					$(".previus_carrusel").css("display", "")
				} else {
					$(".previus_carrusel").css("display", "none")
				}
			});
			$(".previus_carrusel2").click(function() {
				if ($("#carouselExampleControls2").carousel(1)) {
					$(".previus_carrusel2").css("display", "")
				} else {
					$(".previus_carrusel2").css("display", "none")
				}
			});
			$(".formuploadajax").on("submit", function(e) {
				e.preventDefault();
				let form = $(this),
					wrapper = $('.wrapper'),
					progress_bar = $('.progress-bar'),
					data = new FormData(form.get(0));
				progress_bar.removeClass('bg-success bg-danger').addClass('bg-info')
				progress_bar.css('width', '0%');
				progress_bar.html('Preparando...');
				wrapper.fadeIn();

				$.ajax({
					xhr: function() {
						let xhr = new window.XMLHttpRequest();
						xhr.upload.addEventListener("progress", function(e) {
							if (e.lengthComputable) {
								let percentComplete = Math.floor((e.loaded / e.total) * 100);
								progress_bar.css('width', percentComplete + '%');
								progress_bar.html(percentComplete + '%');
							}
						}, false);
						return xhr;
					},
					url: "{{ route('save.imagenchecklist') }}",
					type: "post",
					dataType: "json",
					data: data,
					cache: false,
					contentType: false,
					processData: false,
					beforeSend: () => {
						$("button", form).attr('disabled', true);
					}
				}).done(res => {
					console.log(res);
					if (res.status === 200) {
						progress_bar.removeClass('bg-info').addClass('bg-success');
						progress_bar.html('Subida exitosa!');
						setTimeout(() => {
							wrapper.fadeOut;
							progress_bar.removeClass('bg-success bg-danger').addClass('bg-info');
							progress_bar.css('width', '0%');
						}, 1500);
						setTimeout(() => {
							$("#carouselExampleControls2").carousel("next");
							$(".previus_carrusel2").css("display", "")
						}, 2000);
						console.log(res);
					} else {
						alert(res.msg);
						progress_bar.css('width', '100%');
						progress_bar.html(res.msg);
						console.log(res);
					}
				}).fail(err => {
					progress_bar.removeClass('bg-success bg-info').addClass('bg-danger');
					progress_bar.html('Hubo un error!');
				}).always(() => {
					$('button', form).attr('disabled', false);
				})
			});
			$(".save_image").click(function() {
				id = $('#idchecklist').val();
				$.ajax({
					headers: {
						'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					},
					type: 'POST',
					url: "{{ route('go.validarfotoschecklist') }}",
					data: {
						'id': id,
					},
					success: function(data) {
						console.log(data);
						if (data == "ok") {
							$("#modal_historial_retiros").modal('hide');
						} else {
							$('.mensaje_validacion').empty();
							$('.mensaje_validacion').append(data);
						}
					},
					error: function(xhr, status) {
						alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
					}
				});
			});
			$(".cancel_image").click(function() {
				id = $('#idchecklist').val();
				$.ajax({
					headers: {
						'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					},
					type: 'POST',
					url: "{{ route('go.cancelarfotoschecklist') }}",
					data: {
						'id': id,
					},
					success: function(data) {
						console.log(data);
						$("#modal_historial_retiros").modal('hide');
					},
					error: function(xhr, status) {
						alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
					}
				});
			});
			$(".formuploadaccesorios").on("submit", function(e) {
				e.preventDefault();
				let form = $(this),
					wrapper2 = $('.wrap2'),
					progress_bar2 = $('.progbar2'),
					data = new FormData(form.get(0));
				progress_bar2.removeClass('bg-success bg-danger').addClass('bg-info')
				progress_bar2.css('width', '0%');
				progress_bar2.html('Preparando...');
				wrapper2.fadeIn();
				$.ajax({
					xhr: function() {
						let xhr = new window.XMLHttpRequest();
						xhr.upload.addEventListener("progress", function(e) {
							if (e.lengthComputable) {
								let percentComplete = Math.floor((e.loaded / e.total) * 100);
								progress_bar2.css('width', percentComplete + '%');
								progress_bar2.html(percentComplete + '%');
							}
						}, false);
						return xhr;
					},
					url: "{{ route('save.imagen_accesorios') }}",
					type: "post",
					dataType: "json",
					data: data,
					cache: false,
					contentType: false,
					processData: false,
				}).done(res => {
					console.log(res.status);
					if (res.status === 200) {
						progress_bar2.removeClass('bg-info').addClass('bg-success');
						progress_bar2.html('Subida exitosa!');
						setTimeout(() => {
							wrapper2.fadeOut;
							progress_bar2.removeClass('bg-success bg-danger').addClass('bg-info');
							progress_bar2.css('width', '0%');
						}, 1500);
						setTimeout(() => {
							$("#carouselExampleControls").carousel("next");
							$(".previus_carrusel").css("display", "")
						}, 2000);
					} else {
						alert(res.msg);
						progress_bar2.css('width', '100%');
						progress_bar2.html(res.msg);
					}
				}).fail(err => {
					progress_bar2.removeClass('bg-success bg-info').addClass('bg-danger');
					progress_bar2.html('Hubo un error!');
				}).always(() => {
					$('button', form).attr('disabled', false);
				})
			});
		});
	</script>
	<script>
		$(document).ready(function() {
			check = document.getElementById("equipo_remplazo_si");
			element = document.getElementById("equipo_de_remplazo");
			if (check.checked) {
				element.style.display = '';
			}
		});
	</script>
	<script>
		$(document).ready(function() {
			check = document.getElementById("accesorios_si");
			element = document.getElementById("motivos");
			if (check.checked) {
				element.style.display = '';
			}
		});
	</script>
	<script>
		$(document).ready(function() {
			check1 = document.getElementById("motivo_1");
			check2 = document.getElementById("motivo_2");
			check3 = document.getElementById("motivo_3");
			element = document.getElementById("div_accesorios_danados");
			element2 = document.getElementById("fotos_accesorios");
			element3 = document.getElementById("div_accesorios_solicitados");
			element4 = document.getElementById("div_accesorios_manual")
			if (check.checked) {
				element.style.display = '';
				element3.style.display = '';
				element4.style.display = ''
			}
			if (check2.checked) {
				element2.style.display = '';
				element4.style.display = ''
			}
			if (check3.checked) {
				element.style.display = '';
				element3.style.display = '';
				element4.style.display = ''
			}
		});
	</script>
	<script>
		function firmar() {


			url_img = document.getElementById("pizarra").toDataURL('image/png');
			console.log(check);
			$("#imagen_firma").val(url_img);
			// 	e.preventDefault();
			// 	var f = $(this);
			// pizarra
			// imagen_firma
			// check

			var formData = new FormData();
			formData.append("pizarra", $("#pizarra").val());
			formData.append("imagen_firma", url_img);
			formData.append("check", $("#check").val());

			// var formData = new FormData(document.getElementById("formCanvas"));
			var a = document.getElementById("jerarquia");
			$.ajax({
					headers: {
						'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					},
					url: "{{ route('guardandofotosprueba') }}",
					type: "post",
					dataType: "html",
					data: formData,
					a,
					cache: false,
					contentType: false,
					processData: false,
					success: function(response) {
						alert(response);
					},
					error: function(xhr, status) {
						alert('Disculpe, ha ocurrido un problema, intente mas tarde');
					}
				})
				.done(function(res) {});



		}
		var lineas = [];

		function borrar() {

			// Creamos nuestro canvas
			var canvas = document.getElementById("pizarra");
			var ctx = canvas.getContext("2d");



			// Borramos el ÃƒÂ¡rea que nos interese
			ctx.clearRect(0, 0, canvas.width, canvas.height);
			//	console.log(lineas);
			lineas = [];
		}

		$(function() {

			var element = $("#pizarra"); // global variable
			var getCanvas; // global variable

			function downloadURI(uri, name) {
				var link = document.createElement("a");
				link.download = name;
				link.href = uri;
			}
			html2canvas(element, {
				onrendered: function(canvas) {
					getCanvas = canvas;
				}
			});

			//======================================================================
			// VARIABLES
			//======================================================================
			let miCanvas = document.querySelector('#pizarra');

			let correccionX = 0;
			let correccionY = 0;
			let pintarLinea = false;

			let posicion = miCanvas.getBoundingClientRect()
			correccionX = posicion.x;
			correccionY = posicion.y;

			miCanvas.width = 250;
			miCanvas.height = 250;

			//======================================================================
			// FUNCIONES
			//======================================================================

			//borrar	

			/**
			 * Funcion que empieza a dibujar la linea
			 */
			function empezarDibujo() {
				pintarLinea = true;
				lineas.push([]);
			};

			/**
			 * Funcion dibuja la linea
			 */
			function dibujarLinea(event) {
				event.preventDefault();
				if (pintarLinea) {
					let ctx = miCanvas.getContext('2d')
					// Estilos de linea
					ctx.lineJoin = ctx.lineCap = 'round';
					ctx.lineWidth = 5;
					// Color de la linea
					ctx.strokeStyle = '#000';



					// Marca el nuevo punto
					let nuevaPosicionX = 0;
					let nuevaPosicionY = 0;
					if (event.changedTouches == undefined) {
						// Versión ratón
						nuevaPosicionX = event.layerX;
						nuevaPosicionY = event.layerY;
					} else {
						// Versión touch, pantalla tactil
						nuevaPosicionX = event.changedTouches[0].pageX - correccionX;
						nuevaPosicionY = event.changedTouches[0].pageY - correccionY;
					}
					// Guarda la linea
					lineas[lineas.length - 1].push({
						x: nuevaPosicionX,
						y: nuevaPosicionY
					});
					// Redibuja todas las lineas guardadas
					ctx.beginPath();
					lineas.forEach(function(segmento) {
						ctx.moveTo(segmento[0].x, segmento[0].y);
						segmento.forEach(function(punto, index) {
							ctx.lineTo(punto.x, punto.y);
						});
					});
					ctx.stroke();
				}
			}

			/**
			 * Funcion que deja de dibujar la linea
			 */
			function pararDibujar() {
				pintarLinea = false;
			}

			//======================================================================
			// EVENTOS
			//======================================================================

			// Eventos raton
			miCanvas.addEventListener('mousedown', empezarDibujo, false);
			miCanvas.addEventListener('mousemove', dibujarLinea, false);
			miCanvas.addEventListener('mouseup', pararDibujar, false);

			// Eventos pantallas táctiles
			miCanvas.addEventListener('touchstart', empezarDibujo, false);
			miCanvas.addEventListener('touchmove', dibujarLinea, false);

			////////////////////////////////////////
			//fin de la fucn
		});

		$(document).ready(function() {
			//funcion para poder cambiar las opciones del finalizar
			$('#estado').change(function() {
				buscar_opciones($("#estado option:selected").val(), "#detalle");
			})

			//enviar for firma
			$("#formCanvas").on("submit", function(e) {
				url_img = document.getElementById("pizarra").toDataURL('image/png');
				$("#imagen_firma").val(url_img);
				e.preventDefault();
				var f = $(this);
				var formData = new FormData(document.getElementById("formCanvas"));
				var a = document.getElementById("jerarquia");
				$.ajax({
						url: "{{ route('guardandofotosprueba') }}",
						type: "post",
						dataType: "html",
						data: formData,
						a,
						cache: false,
						contentType: false,
						processData: false,
						success: function(response) {
							alert(response);
						},
						error: function(xhr, status) {
							alert('Disculpe, ha ocurrido un problema, intente mas tarde');
						}
					})
					.done(function(res) {});
			});

			//modal imagenes
			$('.asignarimagen').click(function() {
				$("#modal_historial_retiros").modal('show');
			});
			//mueble
			$("#mueble").data('checked', 0).on('click', function() {
				el = $(this);
				tres_estados(el, 'mueble');
			});
			$("#kit_lector").data('checked', 0).on('click', function() {
				el = $(this);
				tres_estados(el, 'kit_lector');
			});
			$("#memoria_sd").data('checked', 0).on('click', function() {
				el = $(this);
				tres_estados(el, 'memoria_sd');
			});
			$("#cable_poder").data('checked', 0).on('click', function() {
				el = $(this);
				tres_estados(el, 'cable_poder');
			});
			$("#cable_red").data('checked', 0).on('click', function() {
				el = $(this);
				tres_estados(el, 'cable_red');
			});
			$("#conexion_electrica").data('checked', 0).on('click', function() {
				el = $(this);
				tres_estados(el, 'conexion_electrica');
			});
			$("#servidor_impresion").data('checked', 0).on('click', function() {
				el = $(this);
				tres_estados(el, 'servidor_impresion');
			});
			$("#conf_smb").data('checked', 0).on('click', function() {
				el = $(this);
				tres_estados(el, 'conf_smb');
			});
			$("#conf_email").data('checked', 0).on('click', function() {
				el = $(this);
				tres_estados(el, 'conf_email');
			});
			$("#modo_U253").data('checked', 0).on('click', function() {
				el = $(this);
				tres_estados(el, 'modo_U253');
			});
			$("#ins_driver").data('checked', 0).on('click', function() {
				el = $(this);
				tres_estados(el, 'ins_driver');
			});
			$("#equipo_operativo").data('checked', 0).on('click', function() {
				el = $(this);
				tres_estados(el, 'equipo_operativo');
			});
			$('#no_firma_cliente').on('click', function() {
				if ($(this).is(':checked')) {
					// Hacer algo si el checkbox ha sido seleccionado
					//    alert("El checkbox con valor " + $(this).val() + " ha sido seleccionado");
					$("#contenido").css("display", "none")
				} else {
					$("#contenido").css("display", "")
				}
			});
		}); //fin del onclick

		function tres_estados(el, id_chec) {

			switch (el.data('checked')) {
				case 0: //cehckeado
					el.data('checked', 1);
					el.prop('indeterminate', false);
					el.prop('checked', true);
					var valor2 = id_chec;
					var valor = $("#cambio").val();
					$("#" + id_chec).val("si");
					break;

				case 1:
					el.data('checked', 2);
					el.prop('indeterminate', true);
					el.prop('checked', true);
					var valor2 = id_chec;
					var valor = $("#cambio").val();
					valor += " sin " + valor2 + ',';
					$("#" + id_chec).val("no");
					break;

				default:
					el.data('checked', 0);
					el.prop('indeterminate', false);
					el.prop('checked', false);
					var valor2 = id_chec;
					var valor = $("#cambio").val();
					$("#" + id_chec).val("");
			}
		}

		function buscar_opciones(id_estado, id_detalle, direccion = "") {
			//el parametro direccion, es por si mandan la solicitud desde un punto que no conincide con toda la raiz. (../) 
			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				type: 'POST',
				url: "{{ route('buscar_opciones') }}",
				data: {
					'id': id_estado
				},
				success: function(data) {
					$("#detalle").empty();
					$.each(data, function(id, dato) {
						sin_espacio = dato.replace(/\s+/g, "_");
						$("#detalle").append("<option value=" + sin_espacio + ">" + dato + "</option>");
					});
				},
				error: function(xhr, status) {
					alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
				}
			});
		}

		function soloNumeros(e) {
			var key = window.Event ? e.which : e.keyCode
			return (key >= 48 && key <= 57)
		}
	</script>
	<?php
	// comprovamos si se envió la imagen
	if (isset($_POST['imagen'])) {
		// mostrar la imagen
		echo '<img src="' . $_POST['imagen'] . '" border="1">';
		// funcion para gusrfdar la imagen base64 en el servidor
		// el nombre debe tener la extension
		function uploadImgBase64($base64, $name)
		{
			// decodificamos el base64
			$datosBase64 = base64_decode(preg_replace('#^data:image/\w+;base64,#i', '', $base64));
			// definimos la ruta donde se guardara en el server
			$path = $_SERVER['DOCUMENT_ROOT'] . '/firmas/' . $name;
			// guardamos la imagen en el server
			if (!file_put_contents($path, $datosBase64)) {
				// retorno si falla
				return false;
			} else {
				// retorno si todo fue bien
				return true;
			}
		}
		// llamamos a la funcion uploadImgBase64( img_base64, nombre_fina.png)
		uploadImgBase64($_POST['imagen'], 'mi_imagen_' . date('d_m_Y_H_i_s') . '.png');
	}
	?>
	<script>
		function rellenar(id) {
			if ($("#" + id).val() == "no") {
				$("#" + id).prop('indeterminate', true);
				$("#" + id).prop('checked', true);
			} else if ($("#" + id).val() == "si") {
				$("#" + id).prop('indeterminate', false);
				$("#" + id).prop('checked', true);
			}
		}
	</script>
	<script>
		$(function() {
			var idCheck = ["equipo_operativo", "ins_driver", "modo_U253", "conf_email", "conf_smb", "servidor_impresion", "conexion_electrica", "cable_red", "cable_poder", "mueble", "kit_lector", "memoria_sd", ];

			for (let i = 0; i < idCheck.length; i++) {
				rellenar(idCheck[i]);
			}

			$("#mueble").data('checked', 0).on('click', function() {
				el = $(this);
				tres_estados(el, 'mueble');
			});

			$("#estado").change(function() {
				var selecion = $(this).val();
				if (selecion == "Pendiente") {
					$('#Software').removeAttr("required");
					$('#tipo_equipo').removeAttr("required");
					$('#mueble').removeAttr("required");
					$('#kit_lector').removeAttr("required");
					$('#memoria_sd').removeAttr("required");
					$('#cable_red').removeAttr("required");
					$('#cable_poder').removeAttr("required");
					$('#tipo_conexion').removeAttr("required");
					$('#conexion_electrica').removeAttr("required");
					$('#servidores').removeAttr("required");
					$('#servidor_impresion').removeAttr("required");
					$('#conf_smb').removeAttr("required");
					$('#conf_email').removeAttr("required");
					$('#modo_U253').removeAttr("required");
					$('#ins_driver').removeAttr("required");
					$('#cantidad_usuarios').removeAttr("required");
					$('#equipo_operativo').removeAttr("required");
					$('#cambio').removeAttr("required");
				} else if (selecion == "Cancelar") {
					$('#Software').removeAttr("required");
					$('#tipo_equipo').removeAttr("required");
					$('#mueble').removeAttr("required");
					$('#kit_lector').removeAttr("required");
					$('#memoria_sd').removeAttr("required");
					$('#cable_red').removeAttr("required");
					$('#cable_poder').removeAttr("required");
					$('#tipo_conexion').removeAttr("required");
					$('#conexion_electrica').removeAttr("required");
					$('#servidores').removeAttr("required");
					$('#servidor_impresion').removeAttr("required");
					$('#conf_smb').removeAttr("required");
					$('#conf_email').removeAttr("required");
					$('#modo_U253').removeAttr("required");
					$('#ins_driver').removeAttr("required");
					$('#cantidad_usuarios').removeAttr("required");
					$('#equipo_operativo').removeAttr("required");
					$('#cambio').removeAttr("required");
				}
			});
		});
	</script>
	<script>
		element = document.getElementById("equipo_de_remplazo");

		function showContent() {
			element = document.getElementById("equipo_de_remplazo");
			check = document.getElementById("equipo_remplazo_si");
			check2 = document.getElementById("equipo_remplazo_no");
			if (check.checked) {
				element.style.display = '';
			} else if (check2.checked) {
				element.style.display = 'none';
			} else {
				element.style.display = 'none';
			}
		}

		function changeCheckNo() {
			($('#equipo_remplazo_no')).prop('checked', false);
		}

		function changeCheckSi() {
			element.style.display = 'none';
			($('#equipo_remplazo_si')).prop('checked', false);
		}
	</script>
	<script>
		function desabilitar() {
			cambio = document.getElementById("cambio_serie");
			serie = document.getElementById("serie_remplazo");
			modelo = document.getElementById("modelo_remplazo");
			if (cambio.checked) {
				serie.removeAttribute('disabled');
				modelo.removeAttribute('disabled');
				serie.required = true;
				modelo.required = true;
			} else {
				serie.setAttribute('disabled', 'disabled');
				modelo.setAttribute('disabled', 'disabled');
			}
		}
		$(document).ready(function() {
			cambio = document.getElementById("cambio_serie");
			serie = document.getElementById("serie_remplazo");
			modelo = document.getElementById("modelo_remplazo");
			if (cambio.checked) {
				serie.removeAttribute('disabled');
				modelo.removeAttribute('disabled');
				console.log("a");
			}
		});
	</script>
	<script>
		// Example starter JavaScript for disabling form submissions if there are invalid fields
		(function() {
			'use strict'
			window.addEventListener('load', function() {
				// Fetch all the forms we want to apply custom Bootstrap validation styles to
				var forms = document.querySelectorAll('.needs-validation')

				// Loop over them and prevent submission
				Array.prototype.slice.call(forms).forEach(function(form) {
					form.addEventListener('submit', function(event) {
						if (!form.checkValidity()) {
							event.preventDefault()
							event.stopPropagation()
						}
						form.classList.add('was-validated')
					}, false)
				})
			})
		})()
	</script>
	<script>
		var expanded = false;

		function showCheckBoxes2() {
			checkboxes = document.getElementById("checkboxes2");
			if (!expanded) {
				checkboxes.style.display = "block";
				expanded = true;
			} else {
				checkboxes.style.display = "none";
				expanded = false;
			}
		}
	</script>
	<script>
		var aux = 0;
		var aux2 = 0;
		var aux3 = 1;
		var aux4 = 1;
		var aux5 = 1;

		$(document).ready(function() {
			$('#tabla tr').each(function(index, element) {
				aux++;
			})
		})
		$(document).ready(function() {
			$('#tabla2 tr').each(function(index, element) {
				aux2++;
			})
		})
		//BUSCADOR ACCESORIOS SOLICITADOS
		function myFunction() {
			descripcion = $('#keywords').val();
			id = $('#id_accesorio').val();
			articulo = $('#articulo').val();
			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				type: 'POST',
				url: "{{ route('go.search_accesorios') }}",
				data: {
					'id': id,
					'articulo': articulo,
					'descripcion': descripcion
				},
				success: function(data) {
					$('#accesorios').empty();
					$(data).each(function(i, v) {
						$('#accesorios').append(
							'<tr><td class="agregar" onclick="agregar(' + v.id + ')">' + v.descripcion + '</td></tr');
					})
				},
				error: function(xhr, status) {
					alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
				}
			});
		};
		//BUSCADOR ACCESORIOS DAÑADOS
		function myFunction2() {
			descripcion = $('#keywords2').val();
			id = $('#id_accesorio2').val();
			articulo = $('#articulo2').val();
			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				type: 'POST',
				url: "{{ route('go.search_accesorios') }}",
				data: {
					'id': id,
					'articulo': articulo,
					'descripcion': descripcion
				},
				success: function(data) {
					$('#accesorios2').empty();
					$(data).each(function(i, v) {
						$('#accesorios2').append(
							'<tr><td class="agregar" onclick="agregar2(' + v.id + ')">' + v.descripcion + '</td></tr');
					})
				},
				error: function(xhr, status) {
					alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
				}
			});
		};
		//BUSCADOR PARA PARTES INSTALADAS
		function myFunction3() {
			descripcion = $('#keywords3').val();
			articulo = $('#articulo3').val();
			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				type: 'POST',
				url: "{{ route('go.search_accesorios') }}",
				data: {
					'articulo': articulo,
					'descripcion': descripcion
				},
				success: function(data) {
					$('#accesorios3').empty();
					$(data).each(function(i, v) {
						$('#accesorios3').append(
							'<tr><td class="agregar" onclick="agregar4(' + v.id + ')">' + v.descripcion + '</td></tr'
						);
					})
				},
				error: function(xhr, status) {
					alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
				}
			});
		};
		//AGREGAR ACCESORIOS SOLICITADOS
		function agregar(id) {
			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				type: 'POST',
				url: "{{ route('go.agregar_accesorio') }}",
				data: {
					'id': id
				},
				success: function(data) {
					$(data).each(function(i, v) {
						if (v.serie_parte == "undefined" || v.serie_parte == null) {
							v.serie_parte == "";
						}
						$('#agregar_accesorios').append(
							'<tr class="eliminar' + aux + '">' +
							'<td>' +
							'<input name="descripcion_accesorio[]" value="' + v.id + '" type="hidden">' + v.descripcion +
							'</td>' +
							'<td>' + v.articulo + '</td>' +
							'<td> <input required type="text" name="serie_parte[]" class="form-control" placeholder="Serie de parte" onkeyup="this.value=Numeros(this.value)"> </td>' +
							'<td>' +
							'<button class="btn btn-light" type="button" onclick="sumalo(' + aux + ')">+</button>' +
							'<input type="hidden" name="cantidad[]" value="1" class="resultados' + aux + '" id="resultados' + aux + '">' +
							'<span class="mx-2 resultado' + aux + '" id="resultado' + aux + '">1</span>' +
							'<button class="btn btn-light" type="button" onclick="restalo(' + aux + ')">-</button>' +
							'</td>' +
							'<td class="text-center" onclick="eliminalo(' + aux + ')">' +
							'<a class="btn-icon btn-icon-dd ver_historial_retiros">' +
							'<span class="material-icons-round">' +
							'delete' +
							'</span>' +
							'</a>' +
							'</td>' +
							'</tr');
					})
					aux++;
					limpiar();
					if (data[0].articulo == "REPUESTO") {
						$("#div_ingresar_manual").css("display", "");
						$("#nombre_pieza_manual").attr("required", "true");
						$("#numero_parte_manual").attr("required", "true");
						$("#serie_parte_manual").attr("required", "true");
						$("#observacion_manual").attr("required", "true");
					}
				},
				error: function(xhr, status) {
					alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
				}
			});
		};
		//AGREGAR ACCESORIOS DAÑADOS
		function agregar2(id) {
			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				type: 'POST',
				url: "{{ route('go.agregar_accesorio') }}",
				data: {
					'id': id
				},
				success: function(data) {
					$(data).each(function(i, v) {
						if (v.serie_parte == "undefined" || v.serie_parte == null) {
							v.serie_parte == "";
						}
						$('#agregar_accesorios2').append(
							'<tr class="2eliminar' + aux2 + '">' +
							'<td>' +
							'<input name="descripcion_accesorio2[]" value="' + v.id + '" type="hidden">' + v.descripcion +
							'</td>' +
							'<td>' + v.articulo + '</td>' +
							'<td> <input type="text" required name="serie_parte2[]" required class="form-control" placeholder="Serie de parte" onkeyup="this.value=Numeros(this.value)"> </td>' +
							'<td>' +
							'<button class="btn btn-light" type="button" onclick="sumalo2(' + aux2 + ')">+</button>' +
							'<input type="hidden" name="cantidad2[]" value="1" class="2resultados' + aux2 + '" id="2resultados' + aux2 + '">' +
							'<span class="mx-2 2resultado' + aux2 + '" id="2resultado' + aux2 + '">1</span>' +
							'<button class="btn btn-light" type="button" onclick="restalo2(' + aux2 + ')">-</button>' +
							'</td>' +
							'<td class="text-center" onclick="eliminalo2(' + aux2 + ')">' +
							'<a class="btn-icon btn-icon-dd ver_historial_retiros">' +
							'<span class="material-icons-round">' +
							'delete' +
							'</span>' +
							'</a>' +
							'</td>' +
							'</tr');
					})
					aux2++;
					limpiar2();
				},
				error: function(xhr, status) {
					alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
				}
			});
		};
		//AGREGAR MANUAL SOLICITUD DE ACCESORIOS
		function agregar3(id) {
			$('#agregar_accesorios_manual').append(
				'<tr class="3eliminar' + aux3 + '">' +
				'<td><input required type="text" name="nombre_pieza3[]" class="form-control" placeholder="Nombre de la pieza"></td>' +
				'<td><input required type="text" name="numero_parte3[]" class="form-control" placeholder="Articulo"></td>' +
				'<td><input required type="text" name="serie_parte3[]" class="form-control" onkeyup="this.value=Numeros(this.value)"></td>' +
				'<td>' +
				'<button class="btn btn-light" type="button" onclick="sumalo3(' + aux3 + ')">+</button>' +
				'<input type="hidden" name="cantidad3[]" value="1" class="3resultados' + aux3 + '" id="3resultados' + aux3 + '">' +
				'<span class="mx-2 3resultado' + aux3 + '" id="3resultado' + aux3 + '">1</span>' +
				'<button class="btn btn-light" type="button" onclick="restalo3(' + aux3 + ')">-</button>' +
				'</td>' +
				'<td><input required type="text" name="observacion3[]" class="form-control" placeholder="Observacion"></td>' +
				'<td class="text-center">' +
				'<a class="btn-icon btn-icon-dd" onclick="eliminalo3(' + aux3 + ')">' +
				'<span class="material-icons-round">delete</span>' +
				'</a>' +
				'<a class="btn-icon btn-icon-dd" onclick="agregar3(' + aux3 + ')">' +
				'<span class="material-icons">add</span>' +
				'</a>' +
				'</td>' +
				'</tr>');
			aux3++;
		};
		//AGREGAR INSTALACION DE ACCESORIOS
		function agregar4(id) {
			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				type: 'POST',
				url: "{{ route('go.agregar_accesorio') }}",
				data: {
					'id': id
				},
				success: function(data) {
					$(data).each(function(i, v) {
						$('#agregar_accesorios_instalacion').append(
							'<tr class="4eliminar' + aux4 + '">' +
							'<td>' +
							'<input name="descripcion_accesorio4[]" value="' + v.id + '" type="hidden">' + v.descripcion +
							'</td>' +
							'<td>' + v.articulo + '</td>' +
							'<td> <input type="text" required name="serie_parte4[]" required class="form-control" placeholder="Serie de parte" onkeyup="this.value=Numeros(this.value)"> </td>' +
							'<td>' +
							'<button class="btn btn-light" type="button" onclick="sumalo4(' + aux4 + ')">+</button>' +
							'<input type="hidden" name="cantidad4[]" value="1" class="4resultados' + aux4 + '" id="4resultados' + aux4 + '">' +
							'<span class="mx-2 4resultado' + aux4 + '" id="4resultado' + aux4 + '">1</span>' +
							'<button class="btn btn-light" type="button" onclick="restalo4(' + aux4 + ')">-</button>' +
							'</td>' +
							'<td class="text-center" onclick="eliminalo4(' + aux4 + ')">' +
							'<a class="btn-icon btn-icon-dd ver_historial_retiros">' +
							'<span class="material-icons-round">delete</span>' +
							'</a>' +
							'</td>' +
							'</tr'
						);
					})
					aux4++;
					limpiar4();
				},
				error: function(xhr, status) {
					alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
				}
			});
		};
		//AGREGAR MANUAL INSTALACION DE ACCESORIOS
		function agregar5(id) {
			$('#agregar_accesorios_manual_instalacion').append(
				'<tr class="5eliminar' + aux5 + '">' +
				'<td><input required type="text" name="nombre_pieza5[]" class="form-control" placeholder="Nombre de la pieza"></td>' +
				'<td><input required type="text" name="numero_parte5[]" class="form-control" placeholder="Articulo"></td>' +
				'<td><input required type="text" name="serie_parte5[]" class="form-control" onkeyup="this.value=Numeros(this.value)"></td>' +
				'<td>' +
				'<button class="btn btn-light" type="button" onclick="sumalo5(' + aux5 + ')">+</button>' +
				'<input type="hidden" name="cantidad5[]" value="1" class="5resultados' + aux5 + '" id="5resultados' + aux5 + '">' +
				'<span class="mx-2 5resultado' + aux5 + '" id="5resultado' + aux5 + '">1</span>' +
				'<button class="btn btn-light" type="button" onclick="restalo5(' + aux5 + ')">-</button>' +
				'</td>' +
				'<td><input required type="text" name="observacion5[]" class="form-control" placeholder="Observacion"></td>' +
				'<td class="text-center">' +
				'<a class="btn-icon btn-icon-dd" onclick="eliminalo5(' + aux5 + ')">' +
				'<span class="material-icons-round">delete</span>' +
				'</a>' +
				'<a class="btn-icon btn-icon-dd" onclick="agregar5(' + aux5 + ')">' +
				'<span class="material-icons">add</span>' +
				'</a>' +
				'</td>' +
				'</tr>');
			aux5++;
		};
		//FUNCIONES LIMPIAR BUSCADORES
		function limpiar() {
			$('#keywords').val("");
			$('#id_accesorio').val("");
			$('#articulo').val("");
			$('#accesorios').empty();
		}

		function limpiar2() {
			$('#keywords2').val("");
			$('#id_accesorio2').val("");
			$('#articulo2').val("");
			$('#accesorios2').empty();
		}

		function limpiar4() {
			$('#keywords3').val("");
			$('#articulo3').val("");
			$('#accesorios3').empty();
		}
		//FUNCIONES ELIMINAR
		function eliminalo(params) {
			$(".eliminar" + params).remove();
		}

		function eliminalo2(params) {
			$(".2eliminar" + params).remove();
		}

		function eliminalo3(params) {
			$(".3eliminar" + params).remove();
		}

		function eliminalo4(params) {
			$(".4eliminar" + params).remove();
		}

		function eliminalo5(params) {
			$(".5eliminar" + params).remove();
		}
		//FUNCIONES SUMAR
		function sumalo(params) {
			x = document.getElementById("resultado" + params).innerText;
			x++;
			document.getElementById("resultado" + params).innerText = x;
			document.getElementById("resultados" + params).value = x;
		}

		function sumalo2(params) {
			x = document.getElementById("2resultado" + params).innerText;
			x++;
			document.getElementById("2resultado" + params).innerText = x;
			document.getElementById("2resultados" + params).value = x;
		}

		function sumalo3(params) {
			x = document.getElementById("3resultado" + params).innerText;
			x++;
			document.getElementById("3resultado" + params).innerText = x;
			document.getElementById("3resultados" + params).value = x;
		}

		function sumalo4(params) {
			x = document.getElementById("4resultado" + params).innerText;
			x++;
			document.getElementById("4resultado" + params).innerText = x;
			document.getElementById("4resultados" + params).value = x;
		}

		function sumalo5(params) {
			x = document.getElementById("5resultado" + params).innerText;
			x++;
			document.getElementById("5resultado" + params).innerText = x;
			document.getElementById("5resultados" + params).value = x;
		}
		//FUNCIONES RESTAR
		function restalo(params) {
			x = document.getElementById("resultado" + params).innerText;
			x--;
			if (x < 1) {} else {
				document.getElementById("resultado" + params).innerText = x;
				document.getElementById("resultados" + params).value = x;
			}
		}

		function restalo2(params) {
			x = document.getElementById("2resultado" + params).innerText;
			x--;
			if (x < 1) {} else {
				document.getElementById("2resultado" + params).innerText = x;
				document.getElementById("2resultados" + params).value = x;
			}
		}

		function restalo3(params) {
			x = document.getElementById("3resultado" + params).innerText;
			x--;
			if (x < 1) {} else {
				document.getElementById("3resultado" + params).innerText = x;
				document.getElementById("3resultados" + params).value = x;
			}
		}

		function restalo4(params) {
			x = document.getElementById("4resultado" + params).innerText;
			x--;
			if (x < 1) {} else {
				document.getElementById("4resultado" + params).innerText = x;
				document.getElementById("4resultados" + params).value = x;
			}
		}

		function restalo5(params) {
			x = document.getElementById("5resultado" + params).innerText;
			x--;
			if (x < 1) {} else {
				document.getElementById("5resultado" + params).innerText = x;
				document.getElementById("5resultados" + params).value = x;
			}
		}
	</script>
	<script>
		$(document).ready(function() {
			$('#accesorios_si').change(function() {
				if ($('#accesorios_si').is(':checked')) {
					$("#motivos").css("display", "");
					if ($('#motivo_1').is(':checked') || $('#motivo_3').is(':checked')) {
						$("#div_accesorios_danados").css("display", "");
						$("#div_accesorios_solicitados").css("display", "");
					}
					if ($('#motivo_2').is(':checked')) {
						$("#fotos_accesorios").css("display", "");
						$("#div_accesorios_solicitados").css("display", "");
					}
					if ($('#accesorios_manual_si').is(':checked')) {
						$("#div_ingresar_manual").css("display", "");
						$("#div_accesorios_manual").css("display", "");
						$("#nombre_pieza_manual").attr("required", "true");
						$("#numero_parte_manual").attr("required", "true");
						$("#serie_parte_manual").attr("required", "true");
						$("#observacion_manual").attr("required", "true");
					}
					$("#accesorios_no").prop('checked', false)
				} else {
					$("#motivos").css("display", "none");
					$("#accesorios_si").prop('checked', false);
					$("#fotos_accesorios").css("display", "none");
					$("#div_accesorios_danados").css("display", "none");
					$("#div_accesorios_solicitados").css("display", "none");
					$("#div_ingresar_manual").css("display", "none");
					$("#div_accesorios_manual").css("display", "none");
					$("#nombre_pieza_manual").removeAttr('required');
					$("#numero_parte_manual").removeAttr('required');
					$("#serie_parte_manual").removeAttr('required');
					$("#observacion_manual").removeAttr('required');
				}
			});
			$('#accesorios_no').change(function() {
				if ($('#accesorios_no').is(':checked')) {
					$("#motivos").css("display", "none");
					$("#accesorios_si").prop('checked', false);
					$("#fotos_accesorios").css("display", "none");
					$("#div_accesorios_danados").css("display", "none");
					$("#div_accesorios_solicitados").css("display", "none");
					$("#div_ingresar_manual").css("display", "none");
					$("#div_accesorios_manual").css("display", "none");
					$("#nombre_pieza_manual").removeAttr('required');
					$("#numero_parte_manual").removeAttr('required');
					$("#serie_parte_manual").removeAttr('required');
					$("#observacion_manual").removeAttr('required');
				} 
			});

			$('#motivo_1').change(function() {
				if ($('#motivo_1').is(':checked')) {
					$("#fotos_accesorios").css("display", "none");
					$("#div_accesorios_danados").css("display", "");
					$("#div_accesorios_solicitados").css("display", "");
					//$("#div_ingresar_manual").css("display", "");
					$("#motivo_2").prop('checked', false)
					$("#motivo_3").prop('checked', false)
					if ($('#accesorios_manual_si').is(':checked')) {
						$("#div_ingresar_manual").css("display", "");
						$("#div_accesorios_manual").css("display", "");
						$("#nombre_pieza_manual").attr("required", "true");
						$("#numero_parte_manual").attr("required", "true");
						$("#serie_parte_manual").attr("required", "true");
						$("#observacion_manual").attr("required", "true");
					}
				} else {
					$("#div_accesorios_danados").css("display", "none");
					$("#div_accesorios_solicitados").css("display", "none");
					$("#div_ingresar_manual").css("display", "none");
					$("#div_accesorios_manual").css("display", "none");
					$("#nombre_pieza_manual").removeAttr('required');
					$("#numero_parte_manual").removeAttr('required');
					$("#serie_parte_manual").removeAttr('required');
					$("#observacion_manual").removeAttr('required');
				}
			});
			$('#motivo_2').change(function() {
				if ($('#motivo_2').is(':checked')) {
					$("#fotos_accesorios").css("display", "");
					$("#div_accesorios_solicitados").css("display", "");
					//$("#div_ingresar_manual").css("display", "");
					$("#motivo_1").prop('checked', false)
					$("#motivo_3").prop('checked', false)
					if ($('#accesorios_manual_si').is(':checked')) {
						$("#div_ingresar_manual").css("display", "");
						$("#div_accesorios_manual").css("display", "");
						$("#nombre_pieza_manual").attr("required", "true");
						$("#numero_parte_manual").attr("required", "true");
						$("#serie_parte_manual").attr("required", "true");
						$("#observacion_manual").attr("required", "true");
					}
				} else {
					$("#fotos_accesorios").css("display", "none");
					$("#div_accesorios_solicitados").css("display", "none");
					$("#div_ingresar_manual").css("display", "none");
					$("#div_accesorios_manual").css("display", "none");
					$("#nombre_pieza_manual").removeAttr('required');
					$("#numero_parte_manual").removeAttr('required');
					$("#serie_parte_manual").removeAttr('required');
					$("#observacion_manual").removeAttr('required');
				}
			});
			$('#motivo_3').change(function() {
				if ($('#motivo_3').is(':checked')) {
					$("#fotos_accesorios").css("display", "none");
					$("#div_accesorios_danados").css("display", "");
					$("#div_accesorios_solicitados").css("display", "");
					//$("#div_ingresar_manual").css("display", "");
					$("#motivo_1").prop('checked', false)
					$("#motivo_2").prop('checked', false)
					if ($('#accesorios_manual_si').is(':checked')) {
						$("#div_ingresar_manual").css("display", "");
						$("#div_accesorios_manual").css("display", "");
						$("#nombre_pieza_manual").attr("required", "true");
						$("#numero_parte_manual").attr("required", "true");
						$("#serie_parte_manual").attr("required", "true");
						$("#observacion_manual").attr("required", "true");
					}
				} else {
					$("#div_accesorios_danados").css("display", "none");
					$("#div_accesorios_solicitados").css("display", "none");
					$("#div_ingresar_manual").css("display", "none");
					$("#div_accesorios_manual").css("display", "none");
					$("#nombre_pieza_manual").removeAttr('required');
					$("#numero_parte_manual").removeAttr('required');
					$("#serie_parte_manual").removeAttr('required');
					$("#observacion_manual").removeAttr('required');
				}
			});
			//ACCESORIOS MANUAL
			$('#accesorios_manual_si').change(function() {
				if ($('#accesorios_manual_si').is(':checked')) {
					$("#div_accesorios_manual").css("display", "");
					$("#accesorios_manual_no").prop('checked', false)
					$("#nombre_pieza_manual").attr("required", "true");
					$("#numero_parte_manual").attr("required", "true");
					$("#serie_parte_manual").attr("required", "true");
					$("#observacion_manual").attr("required", "true");
				} else {
					$("#div_accesorios_manual").css("display", "none");
					$("#nombre_pieza_manual").removeAttr('required');
					$("#numero_parte_manual").removeAttr('required');
					$("#serie_parte_manual").removeAttr('required');
					$("#observacion_manual").removeAttr('required');
				}
			})
			$('#accesorios_manual_no').change(function() {
				if ($('#accesorios_manual_no').is(':checked')) {
					$("#div_accesorios_manual").css("display", "none");
					$("#accesorios_manual_si").prop('checked', false)
					$("#nombre_pieza_manual").removeAttr('required');
					$("#numero_parte_manual").removeAttr('required');
					$("#serie_parte_manual").removeAttr('required');
					$("#observacion_manual").removeAttr('required');
				}
			})
			//FUNCIONES PARA CHECK INSTALACION DE ACCESORIOS
			$('#accesorios_instalacion_si').change(function() {
				if ($('#accesorios_instalacion_si').is(':checked')) {
					$("#div_accesorios_instalacion").css("display", "");
					$("#div_ingresar_manual_instalacion").css("display", "");
					$("#accesorios_instalacion_no").prop('checked', false)

					if ($('#accesorios_instalacion_manual_si').is(':checked')) {
						$("#div_ingresar_manual_instalacion").css("display", "");
						$("#div_accesorios_manual_instalacion").css("display", "");
					}

				} else {
					$("#div_accesorios_instalacion").css("display", "none");
					$("#div_ingresar_manual_instalacion").css("display", "none");
					$("#div_accesorios_manual_instalacion").css("display", "none");
					$("#nombre_pieza_manual_instalacion").removeAttr('required');
					$("#numero_parte_manual_instalacion").removeAttr('required');
					$("#serie_parte_manual_instalacion").removeAttr('required');
					$("#observacion_manual_instalacion").removeAttr('required');
				}
			})
			$('#accesorios_instalacion_no').change(function() {
				if ($('#accesorios_instalacion_no').is(':checked')) {
					$("#div_accesorios_instalacion").css("display", "none");
					$("#div_ingresar_manual_instalacion").css("display", "none");
					$("#div_accesorios_manual_instalacion").css("display", "none");
					$("#accesorios_instalacion_si").prop('checked', false)
					$("#nombre_pieza_manual_instalacion").removeAttr('required');
					$("#numero_parte_manual_instalacion").removeAttr('required');
					$("#serie_parte_manual_instalacion").removeAttr('required');
					$("#observacion_manual_instalacion").removeAttr('required');
				}
			})
			//INGRESAR MANUAL INSTALACION
			$('#accesorios_instalacion_manual_si').change(function() {
				if ($('#accesorios_instalacion_manual_si').is(':checked')) {
					$("#div_accesorios_manual_instalacion").css("display", "");
					$("#accesorios_instalacion_manual_no").prop('checked', false)
					$("#nombre_pieza_manual_instalacion").attr("required", "true");
					$("#numero_parte_manual_instalacion").attr("required", "true");
					$("#serie_parte_manual_instalacion").attr("required", "true");
					$("#observacion_manual_instalacion").attr("required", "true");
				} else {
					$("#div_accesorios_manual_instalacion").css("display", "none");
					$("#nombre_pieza_manual_instalacion").removeAttr('required');
					$("#numero_parte_manual_instalacion").removeAttr('required');
					$("#serie_parte_manual_instalacion").removeAttr('required');
					$("#observacion_manual_instalacion").removeAttr('required');
				}
			})
			$('#accesorios_instalacion_manual_no').change(function() {
				if ($('#accesorios_instalacion_manual_no').is(':checked')) {
					$("#div_accesorios_manual_instalacion").css("display", "none");
					$("#nombre_pieza_manual_instalacion").removeAttr('required');
					$("#numero_parte_manual_instalacion").removeAttr('required');
					$("#serie_parte_manual_instalacion").removeAttr('required');
					$("#observacion_manual_instalacion").removeAttr('required');
				}
			})
		});

		function disabledBandeja() {
			check = document.getElementById("band_ad");
			element = document.getElementById("modelo_bandeja");
			if (check.checked) {
				element.required = true;
			} else {
				$('#modelo_bandeja').removeAttr("required");
			}
		}

		function enableES() {
			check = document.getElementById("equipo_remplazo_si");
			element = document.getElementById("id_marca_es");
			element2 = document.getElementById("id_serie_es");
			element3 = document.getElementById("id_modelo_es");
			element4 = document.getElementById("tipo_equipo_es");
			element5 = document.getElementById("id_contadorbn_es");
			element6 = document.getElementById("id_contador_es");
			if (check.checked) {
				element.required = true;
				element2.required = true;
				element3.required = true;
				element4.required = true;
				element5.required = true;
				element6.required = true;
			}
		}

		function disabledES() {
			check = document.getElementById("equipo_remplazo_si");
			element = document.getElementById("id_marca_es");
			element2 = document.getElementById("id_serie_es");
			element3 = document.getElementById("id_modelo_es");
			element4 = document.getElementById("tipo_equipo_es");
			element5 = document.getElementById("id_contadorbn_es");
			element6 = document.getElementById("id_contador_es");
			if (check.checked) {
				$('#id_marca_es').removeAttr("required");
				$('#id_serie_es').removeAttr("required");
				$('#id_modelo_es').removeAttr("required");
				$('#tipo_equipo_es').removeAttr("required");
				$('#id_contadorbn_es').removeAttr("required");
				$('#id_contador_es').removeAttr("required");
			}
		}
	</script>
	<script>
		$(document).ready(function() {
			$('.asignarimagenes').click(function() {
				$("#modal_fotos_accesorios").modal('show');
			});
		})
	</script>