<!DOCTYPE html>
<html lang="en">
<?php $mes = date('d/m/Y');
header('Content-type: application/vnd.ms-excel');
header("Content-Disposition: attachment; filename=InformeInstalacionesfecha$mes.xls");
header("Pragma: no-cache");
header("Expires: 0");  ?>

<body>
  <table class="table table-bordered table-responsive-lg table-striped table-hover" style="margin: 0" id="gridData">
    <!-- ENCABEZADO -->
    <thead>
      <tr>
        <th class="container-2">
          <h3>Cliente</h3>
        </th>
        <th class="container-2">
          <h3>Razon social</h3>
        </th>
        <th class="container-1">
          <h3>Proyecto Asociado</h3>
        </th>
        @if(Auth::user()->tipo_usuario == "administrador" || Auth::user()->tipo_usuario == "coordinador")
        <th class="container-1">
          <h3>T&eacute;cnico</h3>
        </th>
        @endif
        <th class="container-1">
          <h3>Fecha de Recepci&oacute;n</h3>
        </th>
        <th class="container-1">
          <h3>Asignaci&oacute;n coordinadora</h3>
        </th>
        <th class="container-2">
          <h3>Fecha inicio</h3>
        </th>
        <th class="container-2">
          <h3>Fecha fin</h3>
        </th>
        <th class="container-2">
          <h3>Estado Despacho</h3>
        </th>
        <th class="container-2">
          <h3>Estado Instalaci&oacute;n</h3>
        </th>
        <th class="container-2">
          <h3>Regi&oacute;n</h3>
        </th>
        <th class="container-2">
          <h3>Comuna</h3>
        </th>
        <th class="container-2">
          <h3>Direcci&oacute;n | CUI</h3>
        </th><?php /*?>Agregue una nueva columna  - FITO<?php */ ?>
        <th class="container-2">
          <h3>Sede</h3>
        </th>
        <th class="container-2">
          <h3>Id sala</h3>
        </th>
        <th class="container-2">
          <h3>N&deg; de serie</h3>
        </th>
        <th class="container-2">
          <h3>Marca</h3>
        </th>
        <th class="container-2">
          <h3>Modelo</h3>
        </th>
     
        <!--SALIENTE-->
        <th class="container-2">
          <h3>N&deg; de serie saliente</h3>
        </th>
        <th class="container-2">
          <h3>Marca saliente</h3>
        </th>
        <th class="container-2">
          <h3>Modelo saliente</h3>
        </th>
        <th class="container-2">
          <h3>Observaci&oacute;n</h3>
        </th>
        
      </tr>
    </thead>
    <!-- FIN ENCABEZADO -->
    <!-- RESULTADOS -->
    <tbody>
      @if(!empty($instalaciones))
      @foreach ($instalaciones as $los_datos)
      <tr>
        <td>{{$los_datos->sCliente ?? ''}}</td>
        <td>{{$los_datos->razonSocial ?? ''}}</td>
        @php
          $fechas = DB::table('asignacion_instalacions')
          ->join("checklist_instalacions","checklist_instalacions.asignacion_instalacion_retiro_id","=","asignacion_instalacions.id")
          ->join("trabajadors","trabajadors.id","=","asignacion_instalacions.trabajadors_id")
          ->join("personas","personas.id","=","trabajadors.id_persona")  
          ->select(
                  'checklist_instalacions.fecha_inicio',
                  'checklist_instalacions.fecha_fin',
                  'checklist_instalacions.CsSerie_es',
                  'checklist_instalacions.CsModelo_es',
                  'checklist_instalacions.CsMarca_es',
                  'checklist_instalacions.observacion',
                  'checklist_instalacions.Csmarca as marca_check',

                  

                  
                  'personas.nombre_uno','personas.apellido_uno'
          )
          ->where('asignacion_instalacions.lista_instalacion_id','=',$los_datos->id)
          ->orderBy('checklist_instalacions.id', 'desc')
          ->get();

          $fecha_inicio = "";
          $fecha_fin = "";
          $nombre_uno = "";
          $apellido_uno = "";
          $marca = "";
          if(count($fechas) != 0){
            if($fechas[0]->fecha_inicio != "" || $fechas[0]->fecha_fin != "" ){
              $fecha_inicio = Carbon\Carbon::createFromDate($fechas[0]->fecha_inicio)->format('d-m-Y H:i:s');
              $fecha_fin = Carbon\Carbon::createFromDate($fechas[0]->fecha_fin)->format('d-m-Y H:i:s');
            }
            $nombre_uno = $fechas[0]->nombre_uno;
            $apellido_uno = $fechas[0]->apellido_uno;

            $marca  =$fechas[0]->marca_check ?? '';

          }else{

            $marca  =    $los_datos->smarca ?? '';
          }
        @endphp

        
        @if ($los_datos->nombre == "Global")
        <td>No Asignado</td>
        @else
        <td>{{$los_datos->nombre ?? ''}}</td>
        @endif

        


        @if(Auth::user()->tipo_usuario == "administrador" || Auth::user()->tipo_usuario == "coordinador")
        <td>{{$nombre_uno ?? ''}} {{$apellido_uno ?? ''}}</td>
        @endif
        @if($los_datos->fecha_registrado != "")
        <td>{{Carbon\Carbon::createFromDate($los_datos->fecha_registrado)->format('d-m-Y')}}</td>
        @else
        <td>No registra</td>
        @endif
        @if($los_datos->fecha_instalacion_coordinadora != "")
        <td>{{Carbon\Carbon::createFromDate($los_datos->fecha_instalacion_coordinadora)->format('d-m-Y')}}</td>
        @else
        <td>No registra</td>
        @endif
        <td>{{$fecha_inicio}}</td>
        <td>{{$fecha_fin}}</td>
        @if($los_datos->sEstado_despacho != null || $los_datos->sEstado_despacho != "")
        <td style="text-transform: uppercase"> {{ucfirst($los_datos->sEstado_despacho ?? 'no informado')}}</td>
        @else
        <td></td>
        @endif
        @if($los_datos->sEstado_instalacion != null || $los_datos->sEstado_instalacion != "")
        <td style="text-transform: uppercase"> {{ucfirst($los_datos->sEstado_instalacion ?? 'no informado')}}</td>
        @else
        <td></td>
        @endif
        <td>{{$los_datos->sRegion ?? ''}}</td>
        <td>{{$los_datos->sComuna ?? ''}}</td>
        <td>{{$los_datos->sDireccion ?? ''}}</td>

        @if($los_datos->sTipo_sucursal != null || $los_datos->sTipo_sucursal != "")
        <td>{{$los_datos->sTipo_sucursal ?? ''}}</td>
        @else
        <td></td>
        @endif

        @if($los_datos->idSala != null || $los_datos->idSala != "")
        <td>{{$los_datos->idSala ?? ''}}</td>
        @else
        <td></td>
        @endif


        @if($los_datos->remplazo != null || $los_datos->remplazo != "")
        <td>{{$los_datos->remplazo ?? ''}}</td>
        @else
        <td>{{$los_datos->sSerie ?? ''}}</td>
        @endif
        <td>{{$marca}}</td>

        <td>{{$los_datos->sModelo ?? ''}}</td>

        @if(count($fechas) != 0)
        <td>{{$fechas[0]->CsSerie_es}}</td>
        @endif
        @if(count($fechas) != 0)
        <td>{{$fechas[0]->CsModelo_es}}</td>
        @endif
        @if(count($fechas) != 0)
        <td>{{$fechas[0]->CsMarca_es}}</td>
        @endif
        <td>{{$los_datos->observacion ?? $fechas[0]->observacion ?? ''}}</td>

        
       


      </tr>
      @endforeach
      @endif
    </tbody>
    <!-- FIN RESULTADOS -->
  </table>
</body>

</html>