<?php

namespace App\Http\Controllers\usuario;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Contracts\Encryption\DecryptException;
use App;
use App\direccion;
use App\persona;
use App\User;
use DB;
use Crypt;
use Carbon\Carbon;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Config;



class usuarios extends Controller
{
    public function __construct()

    {

        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }
    private function nombre_database()
    {
        $tables = DB::select('SHOW DATABASES WHERE `Database` NOT LIKE ' . '"' . '%max%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%ayaweb%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%ayaingen%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%schema%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%php%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%prueba%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%admin%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%fusion%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%sql%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%probando%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%soporte%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%sys%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%13octubre%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%nueva%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%rendicion%' . '"'. ' AND `Database` NOT LIKE ' . '"' . '%ayaoctubre%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%aya_vers%' . '"'  );
        return $tables;
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {

        $rules = [
            //'selecionados' => 'required|max:15',
            'primer_nombre' => 'required|max:15',
            'primer_nombre' => 'required|max:15',
            'segundo_nombre' => 'required|max:15',
            'apellido_paterno' => 'required|max:15',
            'apellido_materno' => 'required|max:15',
            'rut' => 'required|max:10|unique:personas',
            'telefono' => 'required|max:10',
            'telefono_opcional' => 'max:10',
            //  'tipo_usu' => 'required|min:1|max:30',
            'correo' => 'required|max:40',
            'correo_opcional' => 'max:40',
            'region' => 'required|max:40',
            'comuna' => 'required|max:40',
            'calle' => 'required|max:200',
            'usuario' => 'required|max:20|unique:users',
            'password' => 'required|min:8|max:20|required_with:password_2|same:password_2',
            'password_2' => 'required|min:8|max:20',
        ];

        $this->validate($request, $rules);

        $tipos_de_usuarios = "";
        $seleccionados = "";

        //trabjador es el tecnico
        if ($request->tipo_usu == "Comun" || $request->tipo_usu == "comun") {
            $tipos_de_usuarios = "trabajador";

            //validamos que las 
            $rules = [
                'selecionados' => 'required|max:15',
            ];
            $this->validate($request, $rules);

            $seleccionados = $request->selecionados;
        } elseif ($request->tipo_usu == "Coordinador" || $request->tipo_usu == "coordinador") {
            $tipos_de_usuarios = "coordinador";
        } else {
            return "Intenta mas tarde";
        }
        // $databases = $this->nombre_database();
                $databases = App\bd_proveedores::selectDBMasAya();


        foreach ($databases as $los_datos) {

            Config::set('database.connections.mysql.database', $los_datos->Database);
            DB::reconnect();

            $direccion = new App\direccion;
            $direccion->descripcion_direccion = $request->calle;
            $direccion->id_region = $request->region;
            $direccion->id_comuna = $request->comuna;
            $direccion->timestamps = false;
            $direccion->save();

            if ($request->telefono_opcional == "") {
                $telefono2  = "--";
            } else {
                $telefono2 = $request->telefono_opcional;
            }
            if ($request->correo_opcional == "") {
                $correo2  = "--";
            } else {
                $correo2 = $request->correo_opcional;
            }

            $persona = new App\persona;
            $persona->nombre_uno = $request->primer_nombre;
            $persona->nombre_dos = $request->segundo_nombre;
            $persona->apellido_uno = $request->apellido_paterno;
            $persona->apellido_dos = $request->apellido_materno;
            $persona->id_direccion = $direccion->id;
            $persona->telefono1 = $request->telefono;
            $persona->telefono2 = $telefono2;
            $persona->correo1 = $request->correo;
            $persona->correo2 = $correo2;
            $persona->id_direccion = $direccion->id;
            $persona->rut = $request->rut;
            $persona->timestamps = false;
            $persona->save();

            $usuario = new App\user;
            $usuario->usuario = $request->usuario;
            $usuario->password =  Hash::make($request->password);
            $usuario->tipo_usuario = $tipos_de_usuarios;
            $usuario->timestamps = false;
            $usuario->save();

            $firma = new App\firma_clientes;
            $firma->id_tecnico = $usuario->id;
            $firma->url_firma = "fotos_trabajador/unknown.png";
            $firma->timestamps = false;
            $firma->save();

            $billetera = new App\billetera_virtual;
            $billetera->total_acumulado = 0;
            $billetera->fecha_actualizado_acumulado = Carbon::now();
            $billetera->total_gastos = 0;
            $billetera->fecha_actualizado_gasto = Carbon::now();
            $billetera->timestamps = false;
            $billetera->save();

            if ($tipos_de_usuarios == "trabajador") {

                $trabajador = new App\trabajador;
                $trabajador->estado = 1;
                $trabajador->id_persona = $persona->id;
                $trabajador->id_login =  $usuario->id;
                $trabajador->id_billetera = $billetera->id;
                $trabajador->timestamps = false;
                $trabajador->save();

                $total_regiones = count($request->selecionados);

                for ($j = 0; $j < $total_regiones; $j++) {

                    $mis_sucursales = DB::table('sucursals')
                        ->join('direccions', 'direccions.id', '=', 'sucursals.id_direccion')
                        ->join('regions', 'regions.id', '=', 'direccions.id_region')
                        ->where('sucursals.estado', '=', 1)
                        ->where('regions.id', '=', $request->selecionados[$j])
                        ->select('sucursals.id as id_sucu')
                        ->get();

                    $total_sucursales = count($mis_sucursales);

                    for ($i = 0; $i < $total_sucursales; $i++) {

                        $trabajador_sucursal = new App\trabajador_sucursal;
                        $trabajador_sucursal->id_sucursals = $mis_sucursales[$i]->id_sucu;
                        $trabajador_sucursal->id_trabajador = $trabajador->id;
                        $trabajador_sucursal->timestamps = false;
                        $trabajador_sucursal->save();
                    }
                }
            } elseif ($tipos_de_usuarios == "coordinador") {

                $trabajador = new App\trabajador;
                $trabajador->estado = 1;
                $trabajador->id_persona = $persona->id;
                $trabajador->id_login =  $usuario->id;
                $trabajador->id_billetera = $billetera->id;
                $trabajador->timestamps = false;
                $trabajador->save();
            }
        }
        return back()->with('mensaje', 'Trabajador Agregado');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id_trabajador)
    {





        try {
            $id_desencriptado = Crypt::decryptString($id_trabajador);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }


        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_persona', '=', $id_desencriptado)
            ->get();



        $rules = [
            // 'selecionados' => 'required|max:15',

            'primer_nombre' => 'required|max:15',
            'segundo_nombre' => 'required|max:15',
            'apellido_paterno' => 'required|max:15',
            'apellido_materno' => 'required|max:15',
            // 'rut' => 'required|max:10|unique:personas',
            'telefono' => 'required|max:10',
            'telefono_opcional' => 'max:10',
            //  'tipo_usu' => 'required|min:1|max:30',
            'correo' => 'required|max:40',
            'correo_opcional' => 'max:40',
            'region' => 'required|max:40',
            'comuna' => 'required|max:40',
            'calle' => 'required|max:200',
            // 'usuario' => 'required|max:20|unique:users',
            // 'password' => 'required|min:8|max:20|required_with:password_2|same:password_2',
            // 'password_2' => 'required|min:8|max:20',   
        ];

        $this->validate($request, $rules);

        $tipos_de_usuarios = "";

        //trabjador es el tecnico

        if ($request->tipo_usu == "Comun" || $request->tipo_usu == "comun") {
            $tipos_de_usuarios = "trabajador";


            //validamos que las 
            $rules = [
                'selecionados' => 'required|max:15',
            ];
            $this->validate($request, $rules);
        } elseif ($request->tipo_usu == "coordinador" || $request->tipo_usu == "Coordinador") {
            $tipos_de_usuarios = "coordinador";
        } else {
            return "Intenta mas tarde";
        }
        // $databases = $this->nombre_database();
                $databases = App\bd_proveedores::selectDBMasAya();

              
        foreach ($databases as $los_datos) {

            if( $los_datos->Database =="bd_aya"){
            Config::set('database.connections.mysql.database', $los_datos->Database);
            DB::reconnect();

            $persona =  App\persona::findOrfail($id_desencriptado);
            $persona->nombre_uno = $request->primer_nombre;
            $persona->nombre_dos = $request->segundo_nombre;
            $persona->apellido_uno = $request->apellido_paterno;
            $persona->apellido_dos = $request->apellido_materno;
            $persona->telefono1 = $request->telefono;
            $persona->telefono2 = $request->telefono_opcional;
            $persona->correo1 = $request->correo;
            $persona->correo2 = $request->correo_opcional;
            $persona->timestamps = false;
            $persona->save();

            $direccion =  App\direccion::findOrfail($persona->id_direccion);
            $direccion->id_comuna = $request->comuna;
            $direccion->id_region = $request->region;
            $direccion->descripcion_direccion = $request->calle;
            $direccion->timestamps = false;
            $direccion->save();



            $usuario =  App\user::findOrfail($datos_trabajador[0]->id_login);
            $usuario->tipo_usuario = $tipos_de_usuarios;
            $usuario->timestamps = false;
            $usuario->save();

            $deletedRows = App\trabajador_sucursal::where('id_trabajador', $datos_trabajador[0]->id)->delete();



            if ($tipos_de_usuarios == "trabajador" || $tipos_de_usuarios == "Trabajador") {

                $total_regiones = count($request->selecionados);



                for ($j = 0; $j < $total_regiones; $j++) {


                    $mis_sucursales = DB::table('sucursals')
                        ->join('direccions', 'direccions.id', '=', 'sucursals.id_direccion')
                        ->join('regions', 'regions.id', '=', 'direccions.id_region')
                        ->where('regions.id', '=', $request->selecionados[$j])
                        ->where('sucursals.estado', '=', 1)
                        ->select('sucursals.id as id_sucu')
                        ->get();


                    $total_sucursales = count($mis_sucursales);

                    for ($i = 0; $i < $total_sucursales; $i++) {

                        $trabajador_sucursal = new App\trabajador_sucursal;
                        $trabajador_sucursal->id_sucursals = $mis_sucursales[$i]->id_sucu;
                        $trabajador_sucursal->id_trabajador = $datos_trabajador[0]->id;
                        $trabajador_sucursal->timestamps = false;
                        $trabajador_sucursal->save();
                    }
                }
            }
            }//fin del elseif
        }




        if ($request->password != "" and $request->password_2 != "") {


            $rules2 = [
                'password' => 'required|min:8|max:20|required_with:password_2|same:password_2',
                'password_2' => 'required|min:8|max:20',
            ];
            $this->validate($request, $rules2);
            //$trabajador =  App\trabajador::findOrfail($persona->id);

            // return $trabajador;
            foreach ($databases as $los_datos) {
                if( $los_datos->Database =="bd_aya"){
                        Config::set('database.connections.mysql.database', $los_datos->Database);
                        DB::reconnect();

                        $trabajador = DB::table('trabajadors')->where('trabajadors.id_persona', '=', $persona->id)->get();



                    $usuario =  App\user::findOrfail($trabajador[0]->id_login);


                    //$usuario =  App\user::findOrfail($trabajador->id_login);
                    // return $usuario;
                    // $usuario = new App\user; 
                    $usuario->usuario = $request->usuario;
                    $usuario->password =  Hash::make($request->password);
                    $usuario->timestamps = false;
                    $usuario->save();
                }//fin elseif
            }

                 return back()->with('mensaje', 'Usuario Actualizado');
        }


        return back()->with('mensaje', 'Usuario Actualizado');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }


    public function deleting($id_trabajador)
    {
         $id_trabajador;
        // $databases = $this->nombre_database();
                  $databases = App\bd_proveedores::selectDBMasAya();


        
            Config::set('database.connections.mysql.database', "bd_aya");
            DB::reconnect();
               $Gettrabajdor =  App\trabajador::findOrfail($id_trabajador);
                  $Getuser =  App\user::findOrfail($Gettrabajdor->id_login);


        foreach ($databases as $los_datos) {

            Config::set('database.connections.mysql.database', $los_datos->Database);
            DB::reconnect();



            // $user =  App\user::findOrfail($trabajdor->id_login);
            $user =  App\user::where('usuario', $Getuser->usuario)->firstOrFail();
            $user->password = "eliminado";
            $user->timestamps = false;
            $user->save();



            // $trabajdor =  App\trabajador::findOrfail($id_trabajador);
            $trabajdor =  App\trabajador::where('id_login', $user->id)->firstOrFail();

            $trabajdor->estado = "0";
            $trabajdor->timestamps = false;
            $trabajdor->save();
            // return $trabajdor;
        }
        return back()->with('mensaje_error', 'Usuario Eliminado');
    }


    public function updating($id_trabajador)
    {

        $trabajdor =  App\trabajador::findOrfail($id_trabajador);

        $trabajadores = DB::table('personas')
            ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
            ->join('billetera_virtuals', 'billetera_virtuals.id', '=', 'trabajadors.id_billetera')
            ->join('direccions', 'direccions.id', '=', 'personas.id_direccion')
            ->join('users', 'users.id', '=', 'trabajadors.id_login')
            ->select(
                'personas.nombre_uno',
                'personas.nombre_dos',
                'personas.apellido_uno',
                'personas.apellido_dos',
                'personas.telefono1',
                'personas.telefono2',
                'personas.correo1',
                'personas.correo2',
                'personas.rut',
                'billetera_virtuals.total_acumulado',
                'billetera_virtuals.fecha_actualizado_acumulado',
                'billetera_virtuals.total_gastos',
                'billetera_virtuals.fecha_actualizado_gasto',
                'trabajadors.id as id_trabajador',
                'direccions.descripcion_direccion',
                'direccions.id_region',
                'direccions.id_comuna',
                'users.usuario',
                'personas.id as id_persona',
                'users.tipo_usuario'
            )

            ->where('trabajadors.estado', '=', '1')
            ->where('trabajadors.id_persona', '=', $trabajdor->id_persona)
            ->get();



        $regiones = App\region::all();
        $comunas = App\comuna::all();

        // $regiones_clientes = DB::table('sucursals')
        // ->join('direccions','direccions.id','=','sucursals.id_direccion')
        // ->join('regions','regions.id','=','direccions.id_region')
        // // ->join('trabajador_sucursals','trabajador_sucursals.id_sucursals','=','sucursals.id')
        // // ->where('trabajador_sucursals.id_sucursals','!=','sucursals.id')
        // ->select('regions.id','regions.des_region')
        // ->distinct()
        // ->get();
        //     $regiones_clientes = DB::table('sucursals')
        // ->join('direccions','direccions.id','=','sucursals.id_direccion')
        // ->join('regions','regions.id','=','direccions.id_region')
        // ->where('sucursals.estado','=',1)

        // ->select('regions.id','regions.des_region')
        // ->distinct()
        // ->get();
        $regiones_clientes =  $regiones;




        //     $collection = Collection::make($regiones_clientes);
        // return  $collection;


        // $mis_trabajador_sucursals =  App\trabajador_sucursals::findOrfail($id_trabajador)->get();
        $mis_trabajador_sucursals = DB::table('trabajador_sucursals')
            ->join('sucursals', 'sucursals.id', '=', 'trabajador_sucursals.id_sucursals')
            ->join('direccions', 'direccions.id', '=', 'sucursals.id_direccion')
            ->join('regions', 'regions.id', '=', 'direccions.id_region')
            ->select('regions.id', 'regions.des_region')
            ->distinct()
            ->where("id_trabajador", "=", $id_trabajador)->get();


        $posiciones = "";
        $datos = $regiones_clientes;

        for ($h = 0; $h < count($regiones_clientes); $h++) {


            for ($j = 0; $j < count($mis_trabajador_sucursals); $j++) {

                if ($regiones_clientes[$h]->id == $mis_trabajador_sucursals[$j]->id) {
                    $posiciones .= $h . ",";
                }
            }
        }

        $array_datos = trim($posiciones);
        $array_datos =  explode(',', $posiciones);


        //eliminamos del array todo lo repetido  
        for ($jj = 0; $jj < count($array_datos); $jj++) {

            if ($array_datos[$jj] != "") {
                unset($datos[$array_datos[$jj]]);
            } else {
            }
        }

        // unset($datos[0],$datos[1]);
        //    return $datos;
        $regiones_clientes = $datos;

        return view('auth.editar_usuario', compact('trabajadores', 'regiones', 'comunas', 'regiones_clientes', 'mis_trabajador_sucursals'));
    }
}
