<?php

namespace App\Http\Controllers\checklist;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Contracts\Encryption\DecryptException;
use Crypt;
use App;
use Illuminate\Support\Facades\Storage;
use App\direccion;
use App\persona;
use App\User;
use App\checklist_instalacions;
use Auth;
use Session;
use DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Carbon\Carbon;
use Illuminate\Support\Facades\Config;

//ver los checklist asociados de retiros
class checklistRetiroController extends Controller
{
    private function nombre_database()
    {
        $tables = DB::select('SHOW DATABASES WHERE `Database` NOT LIKE ' . '"' . '%max%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%ayaweb%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%ayaingen%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%schema%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%php%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%prueba%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%admin%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%fusion%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%sql%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%probando%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%soporte%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%sys%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%13octubre%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%nueva%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%rendicion%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%web_aya%' . '"'.' AND `Database` NOT LIKE ' . '"' . '%ayaoctubre%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%aya_vers%' . '"');
        return $tables;
    }
    public function check_asociadosRetiros(Request $request)
    {
        # code...


        try {
            $id_retiros = Crypt::decryptString($request->id_retiros);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }




        $datos_asignacion = DB::table('asignacion_retiros')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_retiros.trabajadors_idtecnico')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('asignacion_retiros.retiros_id', '=', $id_retiros)
            ->select(
                'asignacion_retiros.id',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_retiros.estado_asignacion',
                'asignacion_retiros.fecha_retiro'
            )
            ->orderBy('asignacion_retiros.id', 'desc')

            ->get();



        $tbody = "";
        if (count($datos_asignacion) > 0) {



            foreach ($datos_asignacion as $row) {



                $tbody .= "<tr>";
                $tbody .= "<td>" . $id_retiros . "</td>";
                $tbody .= "<td>" . date('d-m-Y', strtotime($row->fecha_retiro)) . "</td>";
                $tbody .= "<td> " . $row->nombre_uno . " " . $row->apellido_uno . "</td>";

                if ($row->estado_asignacion == "pendiente" || $row->estado_asignacion == "Pendiente") {
                    $tbody .= '<td class="pendiente">' . $row->estado_asignacion . "</td>";
                } else if ($row->estado_asignacion == "cancelado" || $row->estado_asignacion == "Cancelado") {
                    $tbody .= '<td class="cancelado">' . $row->estado_asignacion . "</td>";
                } else if ($row->estado_asignacion == "reasignar" || $row->estado_asignacion == "Reasignar") {
                    $tbody .= '<td class="cancelado">' . "Reasignar" . "</td>";
                } else if ($row->estado_asignacion == "finalizado" || $row->estado_asignacion == "Finalizado") {
                    $tbody .= '<td class="finalizado">' . $row->estado_asignacion . "</td>";
                } else if ($row->estado_asignacion == "asignado" || $row->estado_asignacion == "Asignado") {
                    $tbody .= '<td class="asignado">' . $row->estado_asignacion . "</td>";
                } else if ($row->estado_asignacion == "revisar" || $row->estado_asignacion == "revisar") {
                    $tbody .= '<td class="revisado">' . "Revisar" . "</td>";
                } else if ($row->estado_asignacion == "rechazado" || $row->estado_asignacion == "Rechazado") {
                    $tbody .= '<td class="rechazado">' . $row->estado_asignacion . "</td>";
                } else if ($row->estado_asignacion == "tarea_asignada" || $row->estado_asignacion == "Tarea_asignada") {
                    $tbody .= '<td class="pendiente">' . "Tarea Asignada" . "</td>";
                } else if ($row->estado_asignacion == "corregido" || $row->estado_asignacion == "Corregido") {
                    $tbody .= '<td class="pendiente">' . "Corregido" . "</td>";
                }

                //boton editar
                $tbody .= "<td>";
                $tbody .= " <div class='dropdown dropleft' style='text-align: center;'>";
                $tbody .= "<button type='button' class='btn-dropdown' data-toggle='dropdown'>
               <span class='material-icons'>more_vert</span>
                           </button>
               <div class='dropdown-menu mostrar shadow'>
               <div class='d-flex justify-content-around'>";
                //$tbody .= "<a href='".route('go.ChecklistRetiros',Crypt::encryptString($row->id))."' role='button' title='Editar'>";
                // $tbody .= "<img class='' src='".asset('Botones/Botones/Editar.png')."'   alt='' style='margin: 2px 0px'/>";
                // $tbody.="</a>" ;

                //boton historial para la coordinadora

                $tbody .= "<a  target='_blank' href='" . route('go.ver_check_retirocordinadora', Crypt::encryptString($row->id)) . "' role='button' title='Revisar' class='btn-icon btn-icon-dd verdetalle'>";
                $tbody .= "<span class='material-icons'>visibility</span>";
                $tbody .= "</a>";
                $tbody .= "</div> </div> </div>";
                $tbody .= "</td>";

                $tbody .= "</tr>";
            }
        } else {
            $tbody .= "<tr>";
            $tbody .= "<td>Sin Datos</td>";
            $tbody .= "</tr>";
        }




        return $tbody;
    }



    public function asignar_check_retiro()
    {

        try {
            $id_retiros = Crypt::decryptString($_GET['idretiros']);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }
        //para obtener los nombres de los tecnicos
        $trabajadores = DB::table('personas')
            ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
            ->join('users', 'users.id', '=', 'trabajadors.id_login')
            ->where('trabajadors.estado', '=', '1')
            ->where('users.tipo_usuario', '=', 'trabajador')
            ->select('personas.nombre_uno', 'personas.apellido_uno', 'personas.apellido_dos', 'trabajadors.id')
            ->orderBy('personas.nombre_uno', 'asc')
            ->get();

        $proyectos = DB::table('proyectos')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->where('proyectos.estado', '=', '1')
            ->where('proyectos.id', '!=', '1')
            ->select('proyectos.nombre', 'clientes.razon_social', 'proyectos.id as id_proyecto')
            ->get();

        $retiros = DB::table('retiros')
            ->where('retiros.id', '=', $id_retiros)
            // ->select('instalacions.sCliente','instalacions.dFecha_instalacion','instalacions.sDireccion','instalacions.sComuna','instalacions.sContacto'
            //           ,'instalacions.sCui','instalacions.sSC','instalacions.sModelo','instalacions.sSerie','instalacions.sIP','instalacions.sMsk'
            //           ,'instalacions.sGateway','instalacions.sMac','instalacions.nContador','instalacions.nContador_color','instalacions.sCable_red'
            //           ,'instalacions.sCable_poder','instalacions.sBandeja_adicional','instalacions.sMueble','instalacions.sKit_lector'
            //           ,'instalacions.sSD','instalacions.sCable_red','instalacions.sCable_poder','instalacions.id as id_instalacion')
            ->get();


        //buscamos las asignaciones para poder saber cual es el numero de visita

        $datos_asignacion = DB::table('asignacion_retiros')
            ->where('asignacion_retiros.retiros_id', '=', $id_retiros)
            ->orderBy('id', 'DESC')
            ->take(1)
            ->get();

        //return $datos_asignacion[0]->numero_visita;
        //if(count($datos_asignacion) == 0){
        //$total_dias = 1;
        //}else{
        //$total_dias = count($datos_asignacion) + 1;
        //}
        if (count($datos_asignacion) == 0) {
            $total_dias = 1;
        } else {
            $total_dias = $datos_asignacion[0]->numero_visita + 1;
        }


        return view('check.asignar_checklistretiro', compact('trabajadores', 'proyectos', 'retiros', 'total_dias'));

        /* return redirect('check.asignar_checklistretiro',session('url_retiro'),compact('trabajadores','proyectos','retiros','total_dias')); */
    }


    public function create(request $request, $idRetiro)
    {


        try {
            $idRetiro = Crypt::decryptString($idRetiro);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }




        $rules = [

            'proyectos' => 'required|max:10',
            'numero_visitas' => 'required|max:10',
            'tecnico' => 'required|max:10',
            'fecha_retiro' => 'required|max:30',

        ];

        $this->validate($request, $rules);


        $info_tracker = DB::table('tracker')
            ->where('tracker.tipo_tracker', '=', "retiro")
            ->where('tracker.proyecto_id', '=', $request->proyectos)
            ->get();

        $estado_retiro = DB::table('retiros')
            ->select('retiros.estado_retiro_Cord')
            ->where('retiros.id', '=', $idRetiro)
            ->get();

        //return $estado_retiro[0]->estado_retiro_Cord;


        $datos_retiro =  App\retiros::findOrfail($idRetiro);
        $datos_retiro->tracker_id = $info_tracker[0]->id;
        //$datos_retiro->sEstado = "asignado";
        $datos_retiro->estado_retiro_Cord = "asignado";
        $datos_retiro->fecha_retiroCord = $request->fecha_retiro;
        $datos_retiro->timestamps = false;
        $datos_retiro->save();

        //datos del trabajador para obtener la ID

        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();
        $FechaHoraActual  = Carbon::now();
        $FechaHoraActual = $FechaHoraActual->toDateTimeString();


        //guardamos los datos de la asignacion
        $estado_asignacion = new App\asignacion_retiros;
        $estado_asignacion->estado_asignacion     = "tarea_asignada";
        $estado_asignacion->numero_visita     = $request->numero_visitas;
        $estado_asignacion->trabajadors_idtecnico = $request->tecnico;
        $estado_asignacion->trabajadors_id_coordinador     = $datos_trabajador[0]->id;
        $estado_asignacion->fecha_retiro     = $request->fecha_retiro;
        $estado_asignacion->detalle_costo_id1     = 1;
        $estado_asignacion->retiros_id = $idRetiro;
        $estado_asignacion->cdFecharegistrado = $FechaHoraActual;

        $estado_asignacion->timestamps = false;
        $estado_asignacion->save();

        $motivo_rechazado = DB::table('asignacion_retiros')
            ->select('asignacion_retiros.motivo_rechazado')
            ->where('asignacion_retiros.retiros_id', '=', $idRetiro)
            ->where('asignacion_retiros.estado_asignacion', '=', "reasignar")
            ->get();

        //realizamos una consulta, para lograr encontrar los datos de retiros
        $datos_api_retiro = DB::table('retiros')
            ->where('retiros.id', '=', $idRetiro)
            ->get();


        $checklist_retiros = new App\checklist_retiros;
        $checklist_retiros->estado_asignacion = "tarea_asignada";
        $checklist_retiros->cnFolio     = $datos_api_retiro[0]->nFolio;
        $checklist_retiros->csRegion    = $datos_api_retiro[0]->sRegion;
        $checklist_retiros->csRut     = "1";
        $checklist_retiros->csCliente     = $datos_api_retiro[0]->sCliente;
        $checklist_retiros->csCiudad     = $datos_api_retiro[0]->sCiudad;
        $checklist_retiros->csComuna     = $datos_api_retiro[0]->sComuna;
        $checklist_retiros->csDireccion     = $datos_api_retiro[0]->sSerie;
        $checklist_retiros->csSerie     = $datos_api_retiro[0]->sSerie;
        $checklist_retiros->csModelo     = $datos_api_retiro[0]->sModelo;
        $checklist_retiros->cnContador     = $datos_api_retiro[0]->nContador;
        $checklist_retiros->cnContador_color     = $datos_api_retiro[0]->nContador_color;
        $checklist_retiros->cnGuia     = $datos_api_retiro[0]->nGuia;
        $checklist_retiros->csEstado     = $datos_api_retiro[0]->sEstado;
        $checklist_retiros->csObservacion     = $datos_api_retiro[0]->sObservacion;
        $checklist_retiros->csCui     = $datos_api_retiro[0]->sCui;
        $checklist_retiros->cdFecharegistrado    = $datos_api_retiro[0]->dFecharegistrado;
        $checklist_retiros->asignacion_retiros_id    = $estado_asignacion->id;
        $checklist_retiros->nId_Solicitud    = $datos_api_retiro[0]->nID_Tracker;
        if ($estado_retiro[0]->estado_retiro_Cord == "reasignar") {
            $checklist_retiros->motivo_reasignado = $motivo_rechazado[0]->motivo_rechazado;
        }
        // $checklist_retiros->instalador = $request->instalador;

        $checklist_retiros->timestamps = false;
        $checklist_retiros->save();


        //return redirect('ver_api_retiros')->with('mensaje', 'Checklist  Retiro Asignado');  
        return redirect(session('url_retiro'))->with('mensaje', 'Checklist  Retiro Asignado');
    }

    public function   InicarCheckRetiros(request $request)
    {


        $idasignaRetiro = $request->id;


        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();
        $id_trabajador = $datos_trabajador[0]->id;

        $datos_asignacion = DB::table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_retiros.trabajadors_idtecnico')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'asignacion_retiros.numero_visita',
                'asignacion_retiros.id',
                'checklist_retiros.estado_inicio',
                'checklist_retiros.csDireccion',
                'checklist_retiros.csComuna',
                'checklist_retiros.csCui',
                'checklist_retiros.csSerie',
                'checklist_retiros.csModelo',
                'checklist_retiros.cnContador',
                'checklist_retiros.cnContador_color',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'personas.apellido_dos',
                'checklist_retiros.id as idCheckRetiros',
                'checklist_retiros.estado_inicio',
                'asignacion_retiros.motivo_rechazado'
            )
            ->where('asignacion_retiros.id', '=', $idasignaRetiro)
            ->get();

        $id = $datos_asignacion[0]->id;
        $Direccion = $datos_asignacion[0]->csDireccion;

        if ($datos_asignacion[0]->motivo_rechazado == "" || $datos_asignacion[0]->motivo_rechazado == null) {
            $accion = "1";   //iniciar
        } else {
            $accion = "2"; // completas rechazado
        }

        //proyecto asociado
        $proyectos =  DB::table('asignacion_retiros')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->join('tracker', 'tracker.id', '=', 'retiros.tracker_id')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->select('clientes.razon_social', 'proyectos.nombre')
            ->where('asignacion_retiros.id', '=', $idasignaRetiro)
            ->get();

        $datos_retiros = DB::table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->orWhere(function ($query) use ($id_trabajador, $id, $Direccion) {
                $query->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
                    ->where('checklist_retiros.csDireccion', '=', $Direccion)
                    ->where('asignacion_retiros.id', '!=', $id);
            })
            ->select(
                'checklist_retiros.motivo_reasignado',
                'checklist_retiros.Csdireccion',
                'checklist_retiros.Cscliente',
                'asignacion_retiros.estado_asignacion',
                'asignacion_retiros.fecha_asignado as fecha_as',
                'asignacion_retiros.id',
                'asignacion_retiros.tipo', //retiro o intalaccion
                'asignacion_retiros.motivo_rechazado',
                'asignacion_retiros.fecha_retiro as fecha_visita',
                'checklist_retiros.csComuna',
                'checklist_retiros.CsSerie',
                'checklist_retiros.id as idcheck'
            )
            ->orderBy('fecha_visita', 'desc')
            ->get();

        return view('check.iniciarCheckRetiro', compact('proyectos', 'datos_asignacion', 'accion', 'datos_retiros'));
    }

    public function save_imagenRetiro_old(request $request)
    {


        $file = $request->file('cargafoto1');
        //obtenemos el nombre del archivo
        $nombre =  time() . "_" . $file->getClientOriginalName();
        $extencion =  time() . "_" . $file->getClientOriginalExtension();
        //sacamos la exxtencion por medio de _
        $extencionArray = explode("_", $extencion);
        $nombreGuardar1 = "f1_" . $request->check_listRetiro . "." . $extencionArray[1];
        //indicamos que queremos guardar un nuevo archivo en el disco local
        \Storage::disk('fotos_sistema_check')->put("fotos_retiros/" . $nombreGuardar1,  \File::get($file));

        //check_listRetiro = id del checklistretiro

        $deletedRows = App\fotos_retiros::where('checklist_retiros_id', $request->check_listRetiro)->delete();
        $fotos_retiros = new App\fotos_retiros;
        $fotos_retiros->descripcion_foto  = $nombreGuardar1;
        $fotos_retiros->url  = "fotos_retiros/" . $nombreGuardar1;
        $fotos_retiros->checklist_instalacion_id   = $request->check_listRetiro;
        $fotos_retiros->timestamps = false;
        //  $fotos_retiros->save();   

    }





    public function   updatechecklistRetiro(request $request, $id_checkretiro)
    {

        try {
            $idcheckretiro = Crypt::decryptString($id_checkretiro);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }

        // return $request->tipo_equipo;
        if ($request->no_firma_cliente == "si") {
            $firma = "0";
            //no firma
        } else {
            $firma = "1";
            //si firma
        }

        $msjinstal = "revisar";
        //Mensaje de accion, revi
        if ($request->acc == "1") {
            $msjinstal = "revisar";
        } elseif ($request->acc == "2") {
            $msjinstal = "corregido";
        } else {
            return "No Puede Realizar Esta Accion";
        }

        $lista = App\fotos_retiros::where('checklist_retiros_id', $id_checkretiro)->get();
        // if($request->estado == "finalizado"){
        //     if(count($lista) == 0 ) {
        //         return back()->with('mensaje_error', 'Ingrese las fotos');    
        //     }
        // }

        $FechaHoraActual  = Carbon::now();
        $FechaHoraActual = $FechaHoraActual->toDateTimeString();

        $check =  App\checklist_retiros::findOrfail($idcheckretiro);
        $check->timestamps = false;
        $check->estado_check = $request->estado;
        $check->estado_asignacion = strtolower($msjinstal);
        $check->csEstado = strtolower($msjinstal);
        $check->csSerie = $request->n_serie;
        $check->csModelo = $request->n_modelo;
        $check->cliente_firma = $firma;
        $check->csComuna  = $request->sComuna;



        $check->cnContador = $request->n_contador;
        $check->cnContador_color   = $request->n_contadorcolor;
        $check->csObservacion = $request->observaciones . "  " . $request->estado;
        $check->observacion = $request->observaciones . "  " . $request->estado;
        $check->equipoensucursal = $request->equipo_sucursal;
        $check->bandeja_adicional = $request->bandeja_adicional;
        $check->mueble = $request->mueble;
        $check->kitlector = $request->kit_lector;
        $check->memoriasd = $request->memoria_sd;

        $check->cablered = $request->cable_red;
        $check->cablepoder = $request->cable_poder;
        $check->equipoembalado = $request->equipo_ensamblado;
        $check->nombre_contacto = $request->contacto;
        $check->fecha_fin = $FechaHoraActual;


        $check->save();


        $datos_check = DB::table('checklist_retiros')
            //  ->join('asignacion_instalacions.id','=','checklist_instalacions.asignacion_instalacion_retiro_id')
            //  ->where('softwares.estado','=',"activo")
            ->where('checklist_retiros.id', '=', $idcheckretiro)
            ->get();

        $asignacion =  App\asignacion_retiros::findOrfail($datos_check[0]->asignacion_retiros_id);
        $asignacion->estado_asignacion     = strtolower($msjinstal);
        $asignacion->fecha_termino     =  $FechaHoraActual;
        $asignacion->timestamps = false;
        $asignacion->save();

        $retiro =  App\retiros::findOrfail($asignacion->retiros_id);
        //$retiro->sEstado     =   $msjinstal;
        $retiro->estado_retiro_Cord     =   strtolower($msjinstal);
        $retiro->sSerie = $request->n_serie;
        $retiro->sComuna = $request->sComuna;
        $retiro->fecha_retiroCord = $FechaHoraActual;
        $retiro->timestamps = false;

        $retiro->save();

        //
        //

        return redirect('chekstecnico')->with('mensaje', 'Checklist Actualizado');
    }

    // para guardar las fotos
    public function guardarfirmaretiro(request $request)
    {


        // return $request->imagen_firma;

        //echo '<img src="'.$request->imagen_firma.'" border="1">';

        //return $request->imagen;
        if (isset($request->imagen_firma)) {

            // mostrar la imagen



            try {
                $idcheckretiro = Crypt::decryptString($request->check);
            } catch (DecryptException $e) {
                //
                return "No Puede Realizar Esta Accion";
            }

            $nombre_guardar = "firmacheckretiro" . $idcheckretiro . ".png";

            // echo '<img src="'.$request->imagen_firma.'" border="1">';

            // funcion para gusrfdar la imagen base64 en el servidor
            // el nombre debe tener la extension
            function uploadImgBase64($base64, $name)
            {


                $datosBase64 = base64_decode(preg_replace('#^data:image/\w+;base64,#i', '', $base64));

                //optimixar para poder subir imagenes
                $path = $_SERVER['DOCUMENT_ROOT'] . '/aya/rendicion/fotos/fotos_firmas/' . $name;




                // guardamos la imagen en el server
                if (!file_put_contents($path, $datosBase64)) {
                    // retorno si falla
                    return "0";
                } else {
                    // retorno si todo fue bien
                    return "1";
                }
            }

            // llamamos a la funcion uploadImgBase64( img_base64, nombre_fina.png)
            $resultado = uploadImgBase64($request->imagen_firma, $nombre_guardar);


            if ($resultado == "0") {
                return "Intente nuevamente";
            } else {

                $check =  App\checklist_retiros::findOrfail($idcheckretiro);
                $check->url_firma = "fotos_firmas/" . $nombre_guardar;
                $check->timestamps = false;
                $check->save();
                return "Firma Guardada con Exito";
            }
        } else {

            return "Intente Nuevamente";
        }
    }
    public function savefirmatecnico(request $request)
    {


       
        // return $request->imagen_firma;

        //echo '<img src="'.$request->imagen_firma.'" border="1">';

        //return $request->imagen;

        if (isset($request->imagen_firma)) {

            // mostrar la imagen



            try {
                $id_persona = Crypt::decryptString($request->check);
            } catch (DecryptException $e) {
                //
                return "No Puede Realizar Esta Accion";
            }
            $fechanow = Carbon::now();
            $nombre_guardar = $fechanow . "firmatecnico-" . $id_persona . ".png";

            // echo '<img src="'.$request->imagen_firma.'" border="1">';

            // funcion para gusrfdar la imagen base64 en el servidor
            // el nombre debe tener la extension
            function uploadImgBase64($base64, $name)
            {


                $datosBase64 = base64_decode(preg_replace('#^data:image/\w+;base64,#i', '', $base64));

                //optimixar para poder subir imagenes
                $path = $_SERVER['DOCUMENT_ROOT'] . '/aya/rendicion/fotos/fotos_trabajador/' . $name;




                // guardamos la imagen en el server
                if (!file_put_contents($path, $datosBase64)) {
                    // retorno si falla
                    return "0";
                } else {
                    // retorno si todo fue bien
                    return "1";
                }
            }

            // llamamos a la funcion uploadImgBase64( img_base64, nombre_fina.png)
            $resultado = uploadImgBase64($request->imagen_firma, $nombre_guardar);


            if ($resultado == "0") {
                return "Intente nuevamente";
            } else {
                $datos_trabajador = DB::table('trabajadors')
                    ->where('trabajadors.id_login', '=', Auth::user()->id)
                    ->get();


                // $databases = $this->nombre_database();
                $databases = App\bd_proveedores::selectDB();

                Config::set('database.connections.mysql.database', "bd_aya");
                DB::reconnect();
                $deletedRows = App\firma_clientes::where('id_tecnico', $id_persona)->delete();
                $check = new App\firma_clientes;
                $check->url_firma = "fotos_trabajador/" . $nombre_guardar;
                $check->id_tecnico = $id_persona;
                $check->fecha_creada = Carbon::now();
                $check->timestamps = false;
                $check->save();

                foreach ($databases as $los_datos) {
                    // echo $los_datos->Database."<br>";
                    Config::set('database.connections.mysql.database', $los_datos->Database);
                    DB::reconnect();
                    $deletedRows = App\firma_clientes::where('id_tecnico', $id_persona)->delete();
                    $check = new App\firma_clientes;
                    $check->url_firma = "fotos_trabajador/" . $nombre_guardar;
                    $check->id_tecnico = $id_persona;
                    $check->fecha_creada = Carbon::now();
                    $check->timestamps = false;


                    $check->save();
                }
                // return $nombre_guardar;

                //return view('firma.cambiarfirma',compact('datos_trabajador'));
                return back()->with('mensaje', 'Firma Guardada Correctamente');
            }
        } else {

            return "Intente Nuevamente";
        }
    }

    public function iniciar_checkRetiro($id_checklistRetiro)
    {


        try {
            $checklistid = Crypt::decryptString($id_checklistRetiro);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }
        $FechaHoraActual  = Carbon::now();
        $FechaHoraActual = $FechaHoraActual->toDateTimeString();

        $check =  App\checklist_retiros::findOrfail($checklistid);
        $check->timestamps = false;
        $check->estado_inicio = "activo";
        $check->fecha_inicio = $FechaHoraActual;
        $check->save();

        return back()->with('mensaje', 'Checklist Iniciado');
    }

    //FUNCION PARA RECHAZAR RETIROS COORDINADORA
    public function rechazar_retiro(request $request, $idretiros)
    {




        try {
            $id_retiros = Crypt::decryptString($idretiros);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }





        $datos_check = DB::table('checklist_retiros')
            //  ->join('asignacion_instalacions.id','=','checklist_instalacions.asignacion_instalacion_retiro_id')
            //  ->where('softwares.estado','=',"activo")
            ->where('checklist_retiros.asignacion_retiros_id', '=', $id_retiros)
            ->get();


        $check =  App\checklist_retiros::findOrfail($datos_check[0]->id);
        $check->timestamps = false;
        $check->estado_asignacion = strtolower("rechazado");
        $check->csEstado = strtolower("rechazado");
        $check->save();

        $FechaHoraActual  = Carbon::now();
        $FechaHoraActual = $FechaHoraActual->toDateTimeString();

        //return redirect('chekstecnico')->with('mensaje', 'Checklist Actualizado');
        $asignacion =  App\asignacion_retiros::findOrfail($datos_check[0]->asignacion_retiros_id);
        $asignacion->estado_asignacion     =  strtolower("rechazado");
        $asignacion->motivo_rechazado = $request->motivorechazado;
        $asignacion->fecha_termino     =  $FechaHoraActual;
        $asignacion->timestamps = false;

        $asignacion->save();



        //actualizamos la lista de api insntalacion
        $retiros =  App\retiros::findOrfail($asignacion->retiros_id);
        $retiros->estado_retiro_Cord =  strtolower("rechazado");
        $retiros->timestamps = false;
        $retiros->save();


        // return redirect('ver_api_retiros')->with('mensaje', 'Checklist Rechazado');
        return redirect(session('url_retiro'))->with('mensaje', 'Checklist Rechazado');
    }


    public function hola()
    {

        return  "ok";
    }

    public function save_imagenRetiro(request $request)
    {


        $file = $request->file('cargafoto1');
        //obtenemos el nombre del archivo
        $nombre =  time() . "_" . $file->getClientOriginalName();
        $extencion =  time() . "_" . $file->getClientOriginalExtension();
        //sacamos la exxtencion por medio de _
        $extencionArray = explode("_", $extencion);
        if ($extencionArray[1] == "jpg" || $extencionArray[1] == "jpeg" || $extencionArray[1] == "png" || $extencionArray[1] == "jfif") {
        } else {
            return "Solo se permiten imagenes";
        }
        $nombreGuardar1 = "f1_" . $request->check_listRetiro . "." . $extencionArray[1];

        //indicamos que queremos guardar un nuevo archivo en el disco local
        \Storage::disk('fotos_sistema_check')->put("fotos_retiros/" . $nombreGuardar1,  \File::get($file));
        //check_listRetiro = id del checklistretiro
        $deletedRows = App\fotos_retiros::where('checklist_retiros_id', $request->check_listRetiro)->delete();
        $fotos_retiros = new App\fotos_retiros;
        $fotos_retiros->descripcion  = $nombreGuardar1;
        $fotos_retiros->url  = "fotos_retiros/" . $nombreGuardar1;
        $fotos_retiros->checklist_retiros_id   = $request->check_listRetiro;
        $fotos_retiros->timestamps = false;
        $fotos_retiros->save();

        return "Imagen guardada exitosamente";
    }
    //VER  CHEC
    //VER  CHECKLIST RETIRO TECNICO
    public function ver_checktecnico(request $request)
    {
        $idretiroasig = $request->id;

        $datos_asignacion = DB::table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_retiros.trabajadors_idtecnico')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'asignacion_retiros.numero_visita',
                'checklist_retiros.csDireccion',
                'checklist_retiros.csComuna',
                'checklist_retiros.csCui',
                'checklist_retiros.csSerie',
                'checklist_retiros.csModelo',
                'checklist_retiros.cnContador',
                'checklist_retiros.cnContador_color',
                'checklist_retiros.csObservacion',
                'checklist_retiros.nombre_contacto',
                'checklist_retiros.bandeja_adicional',
                'checklist_retiros.mueble',
                'checklist_retiros.kitlector',
                'checklist_retiros.memoriasd',
                'checklist_retiros.cablered',
                'checklist_retiros.cablepoder',
                'checklist_retiros.equipoembalado',
                'checklist_retiros.cliente_firma',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'personas.apellido_dos',
                'asignacion_retiros.fecha_termino',
                'asignacion_retiros.fecha_inicio',
                'asignacion_retiros.fecha_asignado',
                'asignacion_retiros.fecha_retiro',
                'checklist_retiros.id as idCheckRetiros',
                'checklist_retiros.url_firma'
            )

            ->where('asignacion_retiros.id', '=', $idretiroasig)
            ->get();




        $proyectos =  DB::table('asignacion_retiros')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->join('tracker', 'tracker.id', '=', 'retiros.tracker_id')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')

            ->select('clientes.razon_social', 'proyectos.nombre')
            ->where('asignacion_retiros.id', '=', $idretiroasig)
            ->get();

        $fotos = DB::table('fotos_retiros')
            ->where('fotos_retiros.checklist_retiros_id', '=', $datos_asignacion[0]->idCheckRetiros)
            ->get();

        return view('check.ver_checklistretiro', compact('datos_asignacion', 'proyectos', 'fotos'));
    }

    public function checklisRetiroReasignar(request $request, $idRetiro_instalacion)
    {

        // try {
        //     $checklistid = Crypt::decryptString($id_instalacion);

        // } catch (DecryptException $e) {
        //     //
        //     return "No Puede Realizar Esta Accion";
        // }





        try {
            $idAsginacion = Crypt::decryptString($idRetiro_instalacion);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }





        $datos_check = DB::table('checklist_retiros')
            //  ->join('asignacion_instalacions.id','=','checklist_instalacions.asignacion_instalacion_retiro_id')
            //  ->where('softwares.estado','=',"activo")
            ->where('checklist_retiros.asignacion_retiros_id', '=', $idAsginacion)
            ->get();


        $asistencia = $request->asistencia;


        $check =  App\checklist_retiros::findOrfail($datos_check[0]->id);
        $check->timestamps = false;
        $check->estado_inicio = "reasignar";
        $check->estado_asignacion = "reasignar";

        //$check->motivo_rechazado = $request->motivorechazado;
        $check->save();

        //return redirect('chekstecnico')->with('mensaje', 'Checklist Actualizado');  
        $asignacion =  App\asignacion_retiros::findOrfail($datos_check[0]->asignacion_retiros_id);
        $asignacion->estado_asignacion     =  "reasignar";
        if ($asistencia != "" || $asistencia != null) {
        } else {
            $asignacion->numero_visita =  $asignacion->numero_visita - 1;
        }
        $asignacion->motivo_rechazado = $request->motivorechazado;
        $asignacion->fecha_termino     =  Carbon::now();
        $asignacion->timestamps = false;
        $asignacion->save();


        //actualizamos la lista de api insntalacion
        $instalacions =  App\retiros::findOrfail($asignacion->retiros_id);
        //$instalacions->sEstado_despacho     =  "reasignar"  ;
        $instalacions->sEstado = "";
        $instalacions->estado_retiro_Cord = "reasignar";
        $instalacions->timestamps = false;
        $instalacions->save();

        // return redirect(session('url_cordinadora'))->with('mensaje', 'Checklist  listo para Reasignar');  
        // return redirect(session('url_cordinadora'))->with('mensaje', 'Checklist Asignado');  
        //   return redirect('ver_api_instalaciones')->with('mensaje', 'Checklist  listo para Reasignar');  

        //  $url =session('url_cordinadora');
        $url = "https://ayaingenieria.cl/aya/rendicion/filtros_retiro?fecha=&estado=reasignar&serie=";
        //return back()->with('mensaje', 'Retiro Listo  listo para Reasignar');  
        return redirect($url)->with('mensaje', 'Retiro Listo  listo para Reasignar');
    }
    public function asignar_check_retiro_home(request $request)
    {

        $id_retiros = $request->id;

        //para obtener los nombres de los tecnicos
        $trabajadores = DB::table('personas')
            ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
            ->join('users', 'users.id', '=', 'trabajadors.id_login')
            ->where('trabajadors.estado', '=', '1')
            ->where('users.tipo_usuario', '=', 'trabajador')
            ->select('personas.nombre_uno', 'personas.apellido_uno', 'personas.apellido_dos', 'trabajadors.id')
            ->orderBy('personas.nombre_uno', 'asc')
            ->get();

        $proyectos = DB::table('proyectos')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->where('proyectos.estado', '=', '1')
            ->where('proyectos.id', '!=', '1')
            ->select('proyectos.nombre', 'clientes.razon_social', 'proyectos.id as id_proyecto')
            ->get();

        $retiros = DB::table('retiros')
            ->where('retiros.id', '=', $id_retiros)
            ->get();

        //buscamos las asignaciones para poder saber cual es el numero de visita
        $datos_asignacion = DB::table('asignacion_retiros')
            ->where('asignacion_retiros.retiros_id', '=', $id_retiros)
            ->orderBy('id', 'DESC')
            ->take(1)
            ->get();

        if (count($datos_asignacion) == 0) {
            $total_dias = 1;
        } else {
            $total_dias = $datos_asignacion[0]->numero_visita + 1;
        }

        return view('check.asignar_checklistretiro', compact('trabajadores', 'proyectos', 'retiros', 'total_dias'));
    }
}
